' PICAXE Colour Sensor
' Silicon Chip, June 2005

' Listing 3

'********************************************
' PICAXE-08M input/output pins

symbol LED = 0		'colour sensor white LEDs (output 0)
symbol S2 = 1		'colour sensor select S2 (output 1)
symbol ser = 2		'servo (output 2)
symbol CSI = 3		'colour sensor pulse (input 3)
symbol S3 = 4		'colour sensor select S3 (output 4)

'********************************************
' Variables (w4-w6 uses b8-b13!)

symbol new_pos = b1	'new servo position
symbol red_value = w4	'colour sensor red content
symbol blue_value = w5	'colour sensor blue content
symbol green_value = w6	'colour sensor green content

'********************************************
main:
  gosub colour		'scan the colour
  gosub evaluate		'set the servo position
  servo 2, new_pos	'move the servo
  pause 1000
  goto main

'********************************************
' Sub to scan colours

colour:
  high LED			'LED on
  low S2			'read red into w4
  low S3
  count 3, 50, red_value
  high S3			'read blue into w5
  count 3, 50, blue_value
  high S2			'read green into w6
  count 3, 50, green_value
  low LED			'LED off
  return

'********************************************
' Sub to evaluate colour and then set the servo position

evaluate:
  new_pos = 190		'preload reject position

' Now identify correct colour using the threshold values

  if red_value > 150 and red_value < 250 then test_yellow
  if red_value > 50 and red_value < 100 then test_red
  if red_value < 50 then test_blue_or_green
  return

test_blue_or_green:
  if blue_value > 200 and blue_value < 350 then test_blue
  if blue_value > 100 and blue_value < 200 then test_green
  return

test_blue:
  if green_value > 50 and green_value < 150 then is_blue
  return

is_blue:
  new_pos = 170
  return

test_green:
  if green_value > 200 and green_value < 300 then is_green
  return

is_green:
  new_pos = 90
  return

test_red:
  if blue_value > 20 and blue_value < 100 then test_r2
  return

test_r2:
  if green_value > 20 and green_value < 80 then is_red
  return

is_red:
  new_pos = 145
  return

test_yellow:
  if blue_value > 80 and blue_value < 120 then test_y2
  return

test_y2:
  if green_value > 230 and green_value < 350 then is_yellow
  return

is_yellow:
  new_pos = 120
  return
