; Carbon Monoxide Sensor

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

EEPROM0		equ	H'00'	; non-volatile storage for last Alarm state
EEPROM1		equ	H'01'	; non-volatile storage for momentary relay at startup if alarm was on at switchoff

; Bank 0 RAM

WARN_V		equ	H'20'	; Warning A/D value 
WARN_H		equ	H'21'	; Warning hysteresis A/D value 
ALARM_V		equ	H'22'	; Alarm A/D value
ALARM_H		equ	H'23'	; Alarm hysteresis A/D value 
SENSOR		equ	H'24'	; Stored sensor A/D value 
SENSOR_M	equ	H'25'	; sensor A/D value
CYCLE_CNT	equ	H'26'	; cycle counter for 90/60seconds 
ADCOUNT		equ	H'27'	; A/D counter
PURGE		equ	H'28'	; purge mode
WARN_LED	equ	H'29'	; warning LED flasher flag
FLASH_TIME	equ	H'2A'	; warning LED flash rate
TEMP1		equ	H'2B'	; temporary register
ALARM_LED	equ	H'2C'	; alarm LED flag
STORE1		equ	H'2D'	; delay storage value
STORE2		equ	H'2E'	; delay storage value
	 
; All Banks RAM

W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt

 ; preprogram EEPROM DATA 
	
	ORG     2100
	DE	D'0', D'0'

; start at memory 0

	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

; **********************************************************************************************

SETUP

	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'10000011'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'10111111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled TMR0/256)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00011111'	; AN0 to AN4 are analog inputs
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'11000000'	; Fosc, channel etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00111000'	; 0011 for 500kHz
	movwf	OSCCON		; 500kHz osc
	bcf		STATUS,RP0	; select memory bank 0

; initial conditions
INITIAL
	clrf	CYCLE_CNT	; interrupt counter
	clrf	ADCOUNT		; A/D counter
	clrf	PURGE		; purge/reading mode
	clrf	WARN_LED	; warning LED flag
	clrf	FLASH_TIME	; LED flash rate
	clrf	ALARM_LED	; alarm LED flag
	clrf	SENSOR		; stored sensor value

; delay start	
	movlw	D'05'		; extra delay
	movwf	TEMP1

RECYC_DELAYZ
	call	DELAYms
	decfsz	TEMP1,f
	goto	RECYC_DELAYZ

; check reset switch if closed toggle EEPROM1 bit 0
	
	btfsc	PORTB,7		; if low then toggle bit 0
	goto	ALL_INTERRUPTS	; interrupts enable
	movlw	EEPROM1		; momentary action of relay if alarm was set at switch off flag
	call	EEREAD
	movwf	TEMP1
	incf	TEMP1,w		; toggle bit 0
	call	EWRITE		; write to EEPROM
HI_RST
	btfss	PORTB,7		; wait till high again
	goto	HI_RST
; delay start	
	movlw	D'20'		; extra delay
	movwf	TEMP1

RECYC_DELAYY
	call	DELAYms
	decfsz	TEMP1,f
	goto	RECYC_DELAYY

; allow interrupts
ALL_INTERRUPTS
	bsf		INTCON,TMR0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above

; check last alarm state. If alarm was on then momentarily switch relay if it was in momentary mode 
CK_LAST_ALM

	btfsc	PORTB,1		; if low then momentary 
	goto	PURGE_CONTINUE	; not momentary
	movlw	EEPROM1		; option to disable momentary action of relay if car resets to external air at start 
	call	EEREAD		; read momentary relay option EEPROM
	movwf	TEMP1
	btfss	TEMP1,0		; if clear bypass
	goto	PURGE_CONTINUE 
	movlw	EEPROM0		; read eeprom
	call	EEREAD		; value stored
	movwf	TEMP1
	btfss	TEMP1,0		; if set then last alarm was on
	goto	PURGE_CONTINUE
	movlw	0x00
	call	EWRITE		; clear alarm flag
	bsf		PORTA,6		; relay on
	movlw	D'5'		; extra delay
	movwf	TEMP1
RECYC_DELAYX
	call	DELAYms
	decfsz	TEMP1,f
	goto	RECYC_DELAYX
	bcf		PORTA,6		; relay off	

PURGE_CONTINUE	
END_ALARM_CK
	btfsc	PURGE,0		; if set then 90s reading, clear 60s purge
	goto	READING
	bcf		PORTB,5		; set purge voltage for sensor
	movf	CYCLE_CNT,w
; test or normal running
	btfss	PORTB,0		; if low then test
	goto	TEST_P		; test purge
	sublw	D'114'		; =60 seconds
RETURN_FROM_TEST
	btfsc	STATUS,C	; when negative 60 seconds are up
	goto	MORE_PURGE
	clrf	CYCLE_CNT	; return to zero
	bsf		PURGE,0
	goto	READING	
TEST_P
	sublw	D'1'
	goto	RETURN_FROM_TEST

MORE_PURGE
MORE_READING

; check for reset
	btfsc	PORTB,7		; if clear reset
	goto	ALARMS
	call	DELAYms		; wait
	btfsc	PORTB,7		; if still clear then reset alarm
	goto	ALARMS
	clrf	WARN_LED	; warn LED flag off
	clrf	ALARM_LED
	bcf		PORTB,3		; LED off
	btfss	PORTB,1		; if low then momentary so toggle
	goto	TOGGLE1
	bcf		PORTA,6		; toggle relay off
	goto	INITIAL
TOGGLE1
	bsf		PORTA,6		; relay on
	movlw	D'5'		; extra delay
	movwf	TEMP1
RECYC_DELAY
	call	DELAYms
	decfsz	TEMP1,f
	goto	RECYC_DELAY
	bcf		PORTA,6		; relay off
	goto	INITIAL
READING
	btfss	PURGE,0		; if set then 90s reading, clear 60s purge
	goto	PURGE_CONTINUE
	bsf		PORTB,5		; clear purge voltage from sensor
	movf	CYCLE_CNT,w
; test or normal running
	btfss	PORTB,0		; if low then test
	goto	TEST_R		; test purge
	sublw	D'172'		; =90 seconds
RETURN_TEST_R
	btfsc	STATUS,C	; when negative 90 seconds are up
	goto	MORE_READING

; end of 90 seconds
	movf	SENSOR_M,w	; measured value to stored value
	movwf	SENSOR
	clrf	CYCLE_CNT	; return to zero
	bcf		PURGE,0
	goto	ALARMS

TEST_R
	sublw	D'2'
	goto	RETURN_TEST_R

; check for alarms

ALARMS	

; is alarm on, if so check hysteresis for setting off
	
	btfss	ALARM_LED,0	; alarm LED flag
	goto	ALARM_IS_OFF

; subtract alarm hysteresis from alarm value compare with sensor

	movf	ALARM_H,w	; alarm hysteresis
	subwf	ALARM_V,w	; subtract from alarm value
	btfss	STATUS,C	; if negative then clear
	clrw				; do not go below 0
	subwf	SENSOR,w	; compare
	btfsc	STATUS,C	; if positive then still alarm
	goto	END_ALARM_CK; alarm on so keep on

; switch alarm off
	bcf		PORTB,3		; alarm LED off
	clrf	ALARM_LED	; clear flag

; clear EEPROM0 (alarm state)
	movlw	EEPROM0
	call	EEREAD		; sets EEADR
	clrw
	call	EWRITE		; write cleared value

; relay off
	btfss	PORTB,1		; if low then momentary so toggle
	goto	TOGGLE3
	bcf		PORTA,6		; relay off
	goto	ALARM_IS_OFF
TOGGLE3
	bsf		PORTA,6		; relay on
	movlw	D'5'		; extra delay
	movwf	TEMP1
RECYC_DELAY2
	call	DELAYms
	decfsz	TEMP1,f
	goto	RECYC_DELAY2
	bcf		PORTA,6		; relay off	

; if alarm is off, check if should be on 
ALARM_IS_OFF
	movf	ALARM_V,w	; alarm value
	subwf	SENSOR,w	; compare
	btfss	STATUS,C
	goto	CK_WARN_LED
; switch alarm on
	bsf		PORTB,3		; alarm LED on
	bsf		ALARM_LED,0	; set flag
	clrf	WARN_LED	; warning off

; set EEPROM0 (alarm state)
	movlw	EEPROM0
	call	EEREAD		; sets EEADR
	movlw	0x01
	call	EWRITE		; write set value

; relay set
	btfss	PORTB,1		; if low then momentary so toggle
	goto	TOGGLE2
	bsf		PORTA,6		; toggle relay on
	goto	END_ALARM_CK
TOGGLE2
	bsf		PORTA,6		; relay on
	movlw	D'5'		; extra delay
	movwf	TEMP1
RECYC_DELAY1
	call	DELAYms
	decfsz	TEMP1,f
	goto	RECYC_DELAY1
	bcf		PORTA,6		; relay off
	goto	END_ALARM_CK

; if off check if warning should be on	
CK_WARN_LED

	btfsc	WARN_LED,0	; if warning is on
	goto	CK_WARN_OFF
	
	movf	WARN_V,w	; warning value
	subwf	SENSOR,w	; compare
	btfss	STATUS,C
	goto	CK_WARN_OFF

; switch warning on
	bsf		WARN_LED,0	; set flag
	goto	END_ALARM_CK
 
CK_WARN_OFF	
	
; if warning is on check if should be off
; subtract warn hysteresis from warn value compare with sensor

	movf	WARN_H,w	; Warning hysteresis
	subwf	WARN_V,w	; subtract from warning value
	btfss	STATUS,C	; if negative then clear
	clrw				; do not go below 0
	subwf	SENSOR,w	; compare
	btfsc	STATUS,C	; if positive then still alarm
	goto	END_ALARM_CK
	clrf	WARN_LED	; flag unset
	bcf		PORTB,3		; alarm LED off
	
	goto	PURGE_CONTINUE


; delay
DELAYms
	movlw	D'20'		; delay 
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP1	
	movlw	0xFF
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return


 ; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 
	
INTERRUPT
	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag

; increase counter

	incf	CYCLE_CNT,f		; next count value
	incf	FLASH_TIME,f	; flash rate

; check for warning LED
	btfss	WARN_LED,0	; if zero then no flash
	goto	ANALOG_AD
	btfss	FLASH_TIME,0
	goto	CLR_LED
	bsf		PORTB,3		; set LED on
	goto	ANALOG_AD
CLR_LED
	bcf		PORTB,3		; set LED off

; A/D conversion
; set analog input address
ANALOG_AD
	movlw	B'11000111'		; mask bits 5:3
	andwf	ADCON0,f		; set bits 5:3 to zero
	btfsc	ADCOUNT,0		; if bit 0 set then set bit 3 in ADCON0
	bsf		ADCON0,3
	btfsc	ADCOUNT,1		; if bit 1 set then set bit 4 in ADCON0
	bsf		ADCON0,4
	btfsc	ADCOUNT,2		; if bit 2 set,set bit 5
	bsf		ADCON0,5

	movf	ADCOUNT,w		; find address
	btfsc	STATUS,Z		; if zero
	goto	CH_0
	movf	ADCOUNT,w
	xorlw	0x01			; 1
	btfsc	STATUS,Z
	goto	CH_1
	movf	ADCOUNT,w
	xorlw	0x02			; 2
	btfsc	STATUS,Z
	goto	CH_2
	movf	ADCOUNT,w
	xorlw	0x03			; 3
	btfsc	STATUS,Z
	goto	CH_3
	movf	ADCOUNT,w
	xorlw	0x04			; 4
	btfsc	STATUS,Z
	goto	CH_4

; Channel 0 A/D value
CH_0
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	WARN_V			; warning value
	goto	NEW_ADDRESS		; end

; Channel 1 A/D value
CH_1
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	WARN_H			; warning hysteresis value
	goto	NEW_ADDRESS		; end

; Channel 2 A/D value
CH_2
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	SENSOR_M		; Sensor value
	goto	NEW_ADDRESS		; end

; Channel 3 A/D value
CH_3
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	ALARM_H			; alarm hysteresis
	goto	NEW_ADDRESS		; end

; Channel 4 A/D value
CH_4
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	ALARM_V			; Alarm value
	goto	NEW_ADDRESS		; end

; subroutine to wait for conversion
ACQUIRE_AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return
; end subroutine

; set new address
NEW_ADDRESS
	incf	ADCOUNT,f		; counter
	movf	ADCOUNT,w
	sublw	B'00000100'		; compare with 4,if positive or zero leave as is
	btfss	STATUS,C
	clrf	ADCOUNT			; back to zero	
 
; end of interrupt reclaim w and status 
RECLAIM
	
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; **************************************************************
; subroutine to read EEPROM memory

EEREAD	
	bcf		INTCON,GIE	; clear global interrupt enable 
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	bsf		INTCON,GIE	; set global interrupt enable 
	return

; subroutine to write to EEPROM

EWRITE
	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bcf		INTCON,GIE	; disable interrupts
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bsf		INTCON,GIE	; enable interrupts
	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
	bsf		INTCON,GIE	; set global interrupt enable 
	return				; value written 

 end
