
# 1 "usb_descriptors.c"

# 13 "C:\Program Files\Microchip\xc8\v2.50\pic\include\c90\stdint.h"
typedef signed char int8_t;

# 20
typedef signed int int16_t;

# 28
typedef __int24 int24_t;

# 36
typedef signed long int int32_t;

# 52
typedef unsigned char uint8_t;

# 58
typedef unsigned int uint16_t;

# 65
typedef __uint24 uint24_t;

# 72
typedef unsigned long int uint32_t;

# 88
typedef signed char int_least8_t;

# 96
typedef signed int int_least16_t;

# 109
typedef __int24 int_least24_t;

# 118
typedef signed long int int_least32_t;

# 136
typedef unsigned char uint_least8_t;

# 143
typedef unsigned int uint_least16_t;

# 154
typedef __uint24 uint_least24_t;

# 162
typedef unsigned long int uint_least32_t;

# 181
typedef signed char int_fast8_t;

# 188
typedef signed int int_fast16_t;

# 200
typedef __int24 int_fast24_t;

# 208
typedef signed long int int_fast32_t;

# 224
typedef unsigned char uint_fast8_t;

# 230
typedef unsigned int uint_fast16_t;

# 240
typedef __uint24 uint_fast24_t;

# 247
typedef unsigned long int uint_fast32_t;

# 268
typedef int32_t intmax_t;

# 282
typedef uint32_t uintmax_t;

# 289
typedef int16_t intptr_t;




typedef uint16_t uintptr_t;

# 15 "C:\Program Files\Microchip\xc8\v2.50\pic\include\c90\stdbool.h"
typedef unsigned char bool;

# 4 "C:\Program Files\Microchip\xc8\v2.50\pic\include\c90\__size_t.h"
typedef unsigned size_t;

# 7 "C:\Program Files\Microchip\xc8\v2.50\pic\include\c90\stdlib.h"
typedef unsigned short wchar_t;

# 15
typedef struct {
int rem;
int quot;
} div_t;
typedef struct {
unsigned rem;
unsigned quot;
} udiv_t;
typedef struct {
long quot;
long rem;
} ldiv_t;
typedef struct {
unsigned long quot;
unsigned long rem;
} uldiv_t;

# 65
extern double atof(const char *);
extern double strtod(const char *, const char **);
extern int atoi(const char *);
extern unsigned xtoi(const char *) __attribute__((__deprecated__));
extern long atol(const char *);

# 73
extern long strtol(const char *, char **, int);

extern int rand(void);
extern void srand(unsigned int);
extern void * calloc(size_t, size_t);
extern div_t div(int numer, int denom);
extern udiv_t udiv(unsigned numer, unsigned denom) __attribute__((__deprecated__));
extern ldiv_t ldiv(long numer, long denom);
extern uldiv_t uldiv(unsigned long numer,unsigned long denom) __attribute__((__deprecated__));

# 85
extern unsigned long _lrotl(unsigned long value, unsigned int shift);
extern unsigned long _lrotr(unsigned long value, unsigned int shift);
extern unsigned int _rotl(unsigned int value, unsigned int shift);
extern unsigned int _rotr(unsigned int value, unsigned int shift);




extern void * malloc(size_t);
extern void free(void *);
extern void * realloc(void *, size_t);


# 13 "C:\Program Files\Microchip\xc8\v2.50\pic\include\c90\xc8debug.h"
#pragma intrinsic(__builtin_software_breakpoint)
extern void __builtin_software_breakpoint(void);

# 104 "C:\Program Files\Microchip\xc8\v2.50\pic\include\c90\stdlib.h"
extern int atexit(void (*)(void));
extern char * getenv(const char *);
extern char ** environ;
extern int system(char *);
extern void qsort(void *, size_t, size_t, int (*)(const void *, const void *));
extern void * bsearch(const void *, void *, size_t, size_t, int(*)(const void *, const void *));
extern int abs(int);
extern long labs(long);

extern char * itoa(char * buf, int val, int base) __attribute__((__deprecated__));
extern char * utoa(char * buf, unsigned val, int base) __attribute__((__deprecated__));




extern char * ltoa(char * buf, long val, int base) __attribute__((__deprecated__));
extern char * ultoa(char * buf, unsigned long val, int base);

extern char * ftoa(float f, int * status) __attribute__((__deprecated__));

# 46 "usb.h"
struct setup_packet;

# 83
extern int16_t usb_application_get_string(uint8_t string_number, const void **ptr);

# 92
extern const struct device_descriptor this_device_descriptor;

# 110
extern const struct configuration_descriptor *usb_application_config_descs[];

# 144
void app_set_configuration_callback(uint8_t configuration);

# 158
uint16_t app_get_device_status_callback();

# 172
void app_endpoint_halt_callback(uint8_t endpoint, bool halted);

# 191
int8_t app_set_interface_callback(uint8_t interface, uint8_t alt_setting);

# 209
int8_t app_get_interface_callback(uint8_t interface);

# 226
void app_out_transaction_callback(uint8_t endpoint);

# 243
void app_in_transaction_complete_callback(uint8_t endpoint);

# 290
int8_t app_unknown_setup_request_callback(const struct setup_packet *pkt);

# 316
int16_t app_unknown_get_descriptor_callback(const struct setup_packet *pkt, const void **descriptor);

# 327
void app_start_of_frame_callback(void);

# 337
void app_usb_reset_callback(void);

# 350
void usb_init(void);

# 364
void usb_service(void);

# 375
uint8_t usb_get_configuration(void);

# 402
unsigned char *usb_get_in_buffer(uint8_t endpoint);

# 416
void usb_send_in_buffer(uint8_t endpoint, size_t len);

# 428
bool usb_in_endpoint_busy(uint8_t endpoint);

# 440
uint8_t usb_halt_ep_in(uint8_t ep);

# 453
bool usb_in_endpoint_halted(uint8_t endpoint);

# 466
bool usb_out_endpoint_has_data(uint8_t endpoint);

# 478
void usb_arm_out_endpoint(uint8_t endpoint);

# 490
uint8_t usb_halt_ep_out(uint8_t ep);

# 504
bool usb_out_endpoint_halted(uint8_t endpoint);

# 519
uint8_t usb_get_out_buffer(uint8_t endpoint, const unsigned char **buffer);

# 556
typedef int8_t (*usb_ep0_data_stage_callback)(bool data_ok, void *context);

# 581
void usb_start_receive_ep0_data_stage(char *buffer, size_t len,
usb_ep0_data_stage_callback callback, void *context);

# 610
void usb_send_data_stage(char *buffer, size_t len,
usb_ep0_data_stage_callback callback, void *context);

# 59 "usb_ch9.h"
enum PID {
PID_OUT = 0x01,
PID_IN = 0x09,
PID_SOF = 0x05,
PID_SETUP = 0x0D,
PID_DATA0 = 0x03,
PID_DATA1 = 0x0B,
PID_DATA2 = 0x07,
PID_MDATA = 0x0F,
PID_ACK = 0x02,
PID_NAK = 0x0A,
PID_STALL = 0x0E,
PID_NYET = 0x06,
PID_PRE = 0x0C,
PID_ERR = 0x0C,
PID_SPLIT = 0x08,
PID_PING = 0x04,
PID_RESERVED = 0x00,
};

# 83
enum DestinationType {
DEST_DEVICE = 0,
DEST_INTERFACE = 1,
DEST_ENDPOINT = 2,
DEST_OTHER_ELEMENT = 3,
};

# 94
enum RequestType {
REQUEST_TYPE_STANDARD = 0,
REQUEST_TYPE_CLASS = 1,
REQUEST_TYPE_VENDOR = 2,
REQUEST_TYPE_RESERVED = 3,
};

# 105
enum StandardControlRequest {
GET_STATUS = 0x0,
CLEAR_FEATURE = 0x1,
SET_FEATURE = 0x3,
SET_ADDRESS = 0x5,
GET_DESCRIPTOR = 0x6,
SET_DESCRIPTOR = 0x7,
GET_CONFIGURATION = 0x8,
SET_CONFIGURATION = 0x9,
GET_INTERFACE = 0xA,
SET_INTERFACE = 0xB,
SYNCH_FRAME = 0xC,
};


enum DescriptorTypes {
DESC_DEVICE = 0x1,
DESC_CONFIGURATION = 0x2,
DESC_STRING = 0x3,
DESC_INTERFACE = 0x4,
DESC_ENDPOINT = 0x5,
DESC_DEVICE_QUALIFIER = 0x6,
DESC_OTHER_SPEED_CONFIGURATION = 0x7,
DESC_INTERFACE_POWER = 0x8,
DESC_OTG = 0x9,
DESC_DEBUG = 0xA,
DESC_INTERFACE_ASSOCIATION = 0xB,
};

# 143
enum DeviceClassCodes {
DEVICE_CLASS_DEFINED_AT_INTERFACE_LEVEL = 0x0,
DEVICE_CLASS_MISC = 0xef,
DEVICE_CLASS_APPLICATION_SPECIFIC = 0xfe,
DEVICE_CLASS_VENDOR_SPECIFIC = 0xff,
};


enum EndpointAttributes {
EP_CONTROL = 0x0,
EP_ISOCHRONOUS = 0x1,
EP_BULK = 0x2,
EP_INTERRUPT = 0x3,


};

# 165
struct setup_packet {
union {
struct {
uint8_t destination : 5;
uint8_t type : 2;
uint8_t direction : 1;
};
uint8_t bmRequestType;
} REQUEST;
uint8_t bRequest;
uint16_t wValue;
uint16_t wIndex;
uint16_t wLength;
};


struct device_descriptor {
uint8_t bLength;
uint8_t bDescriptorType;
uint16_t bcdUSB;
uint8_t bDeviceClass;
uint8_t bDeviceSubclass;
uint8_t bDeviceProtocol;
uint8_t bMaxPacketSize0;
uint16_t idVendor;
uint16_t idProduct;
uint16_t bcdDevice;
uint8_t iManufacturer;
uint8_t iProduct;
uint8_t iSerialNumber;
uint8_t bNumConfigurations;
};


struct configuration_descriptor {
uint8_t bLength;
uint8_t bDescriptorType;
uint16_t wTotalLength;
uint8_t bNumInterfaces;
uint8_t bConfigurationValue;
uint8_t iConfiguration;
uint8_t bmAttributes;
uint8_t bMaxPower;
};


struct interface_descriptor {
uint8_t bLength;
uint8_t bDescriptorType;
uint8_t bInterfaceNumber;
uint8_t bAlternateSetting;
uint8_t bNumEndpoints;
uint8_t bInterfaceClass;
uint8_t bInterfaceSubclass;
uint8_t bInterfaceProtocol;
uint8_t iInterface;
};


struct endpoint_descriptor {

uint8_t bLength;
uint8_t bDescriptorType;
uint8_t bEndpointAddress;
uint8_t bmAttributes;
uint16_t wMaxPacketSize;
uint8_t bInterval;
};


struct string_descriptor {
uint8_t bLength;
uint8_t bDescriptorType;
uint16_t chars[];
};

# 246
struct interface_association_descriptor {
uint8_t bLength;
uint8_t bDescriptorType;
uint8_t bFirstInterface;
uint8_t bInterfaceCount;
uint8_t bFunctionClass;
uint8_t bFunctionSubClass;
uint8_t bFunctionProtocol;
uint8_t iFunction;
};

# 74 "usb_cdc.h"
enum CDCDescriptorTypes {
DESC_CS_INTERFACE = 0x24,
DESC_CS_ENDPOINT = 0x25,
};


enum CDCFunctionalDescriptorSubtypes {
CDC_FUNCTIONAL_DESCRIPTOR_SUBTYPE_HEADER = 0x0,
CDC_FUNCTIONAL_DESCRIPTOR_SUBTYPE_ACM = 0x2,
CDC_FUNCTIONAL_DESCRIPTOR_SUBTYPE_UNION = 0x6,
};

# 92
enum CDCACMCapabilities {
CDC_ACM_CAPABILITY_COMM_FEATURES = 0x1,
CDC_ACM_CAPABILITY_LINE_CODINGS = 0x2,
CDC_ACM_CAPABILITY_SEND_BREAK = 0x4,
CDC_ACM_CAPABILITY_NETWORK_CONNECTION = 0x8,
};

# 105
enum CDCRequests {
CDC_SEND_ENCAPSULATED_COMMAND = 0x0,
CDC_GET_ENCAPSULATED_RESPONSE = 0x1,
CDC_SET_COMM_FEATURE = 0x2,
CDC_GET_COMM_FEATURE = 0x3,
CDC_CLEAR_COMM_FEATURE = 0x4,
CDC_SET_LINE_CODING = 0x20,
CDC_GET_LINE_CODING = 0x21,
CDC_SET_CONTROL_LINE_STATE = 0x22,
CDC_SEND_BREAK = 0x23,
};

# 121
enum CDCCommFeatureSelector {
CDC_FEATURE_ABSTRACT_STATE = 0x1,
CDC_FEATURE_COUNTRY_SETTING = 0x2,
};

# 132
enum CDCCharFormat {
CDC_CHAR_FORMAT_1_STOP_BIT = 0,
CDC_CHAR_FORMAT_1_POINT_5_STOP_BITS = 1,
CDC_CHAR_FORMAT_2_STOP_BITS = 2,
};

# 144
enum CDCParityType {
CDC_PARITY_NONE = 0,
CDC_PARITY_ODD = 1,
CDC_PARITY_EVEN = 2,
CDC_PARITY_MARK = 3,
CDC_PARITY_SPACE = 4,
};

# 156
enum CDCNotifications {
CDC_NETWORK_CONNECTION = 0x0,
CDC_RESPONSE_AVAILABLE = 0x1,
CDC_SERIAL_STATE = 0x20,
};

# 168
struct cdc_functional_descriptor_header {
uint8_t bFunctionLength;
uint8_t bDescriptorType;
uint8_t bDescriptorSubtype;
uint16_t bcdCDC;
};

# 179
struct cdc_acm_functional_descriptor {
uint8_t bFunctionLength;
uint8_t bDescriptorType;
uint8_t bDescriptorSubtype;
uint8_t bmCapabilities;
};

# 190
struct cdc_union_functional_descriptor {
uint8_t bFunctionLength;
uint8_t bDescriptorType;
uint8_t bDescriptorSubtype;
uint8_t bMasterInterface;
uint8_t bSlaveInterface0;

# 199
};

# 206
struct cdc_notification_header {
union {
struct {
uint8_t destination : 5;
uint8_t type : 2;
uint8_t direction : 1;
};
uint8_t bmRequestType;
} REQUEST;
uint8_t bNotification;
uint16_t wValue;
uint16_t wIndex;
uint16_t wLength;
};

# 226
struct cdc_serial_state_notification {
struct cdc_notification_header header;
union {
struct {
uint16_t bRxCarrier : 1;
uint16_t bTxCarrier : 1;
uint16_t bBreak : 1;
uint16_t bRingSignal : 1;
uint16_t bFraming : 1;
uint16_t bParity : 1;
uint16_t bOverrun : 1;
uint16_t : 1;
uint16_t : 8;
} bits;
uint16_t serial_state;
} data;
};

# 253
struct cdc_line_coding {
uint32_t dwDTERate;
uint8_t bCharFormat;
uint8_t bParityType;
uint8_t bDataBits;
};

# 273
uint8_t process_cdc_setup_request(const struct setup_packet *setup);

# 307
extern int8_t app_send_encapsulated_command(uint8_t interface,
uint16_t length);

# 339
extern int16_t app_get_encapsulated_response(uint8_t interface,
uint16_t length, const void **response,
usb_ep0_data_stage_callback *callback,
void **context);

# 364
extern int8_t app_set_comm_feature_callback(uint8_t interface,
bool idle_setting,
bool data_multiplexed_state);

# 388
extern int8_t app_clear_comm_feature_callback(uint8_t interface,
bool idle_setting,
bool data_multiplexed_state);

# 409
extern int8_t app_get_comm_feature_callback(
uint8_t interface,
bool *idle_setting,
bool *data_multiplexed_state);

# 431
extern int8_t app_set_line_coding_callback(uint8_t interface,
const struct cdc_line_coding *coding);

# 457
extern int8_t app_get_line_coding_callback(uint8_t interface,
struct cdc_line_coding *coding);

# 476
extern int8_t app_set_control_line_state_callback(uint8_t interface,
bool dtr, bool dts);

# 494
extern int8_t app_send_break_callback(uint8_t interface, uint16_t duration);

# 58 "usb_descriptors.c"
struct configuration_1_packet {
struct configuration_descriptor config;
struct interface_association_descriptor iad;


struct interface_descriptor cdc_class_interface;
struct cdc_functional_descriptor_header cdc_func_header;
struct cdc_acm_functional_descriptor cdc_acm;
struct cdc_union_functional_descriptor cdc_union;
struct endpoint_descriptor cdc_ep;


struct interface_descriptor cdc_data_interface;
struct endpoint_descriptor data_ep_in;
struct endpoint_descriptor data_ep_out;

};

# 84
const  struct device_descriptor this_device_descriptor =
{
sizeof(struct device_descriptor),
DESC_DEVICE,
0x0200,
DEVICE_CLASS_MISC,
0x02,

# 92
0x01,
8,
0xA0A0,
0x0004,
0x0001,
1,
2,
5,
1
};

# 112
static const  struct configuration_1_packet configuration_1 =
{
{

sizeof(struct configuration_descriptor),
DESC_CONFIGURATION,
sizeof(configuration_1),
2,
1,
2,
0b10000000,
100/2,
},


{
sizeof(struct interface_association_descriptor),
DESC_INTERFACE_ASSOCIATION,
0,
2,
0x02,
0x02,
0,
2,
},


{

sizeof(struct interface_descriptor),
DESC_INTERFACE,
0x0,
0x0,
0x1,
0x02,
0x02,
0x00,
0x03,
},


{
sizeof(struct cdc_functional_descriptor_header),
DESC_CS_INTERFACE,
CDC_FUNCTIONAL_DESCRIPTOR_SUBTYPE_HEADER,
0x0110,
},


{
sizeof(struct cdc_acm_functional_descriptor),
DESC_CS_INTERFACE,
CDC_FUNCTIONAL_DESCRIPTOR_SUBTYPE_ACM,

# 167
CDC_ACM_CAPABILITY_LINE_CODINGS | CDC_ACM_CAPABILITY_SEND_BREAK,
},


{
sizeof (struct cdc_union_functional_descriptor),
DESC_CS_INTERFACE,
CDC_FUNCTIONAL_DESCRIPTOR_SUBTYPE_UNION,
0,
1,
},


{
sizeof(struct endpoint_descriptor),
DESC_ENDPOINT,
0x01 | 0x80,
EP_INTERRUPT,
10,
1,
},


{

sizeof(struct interface_descriptor),
DESC_INTERFACE,
0x1,
0x0,
0x2,
0x0a,
0,
0x0,
0x04,
},


{
sizeof(struct endpoint_descriptor),
DESC_ENDPOINT,
0x02 | 0x80,
EP_BULK,
64,
1,
},


{
sizeof(struct endpoint_descriptor),
DESC_ENDPOINT,
0x02 ,
EP_BULK,
64,
1,
},
};

# 236
static const  struct {uint8_t bLength;uint8_t bDescriptorType; uint16_t lang; } str00 = {
sizeof(str00),
DESC_STRING,
0x0409
};

static const  struct {uint8_t bLength;uint8_t bDescriptorType; uint16_t chars[25]; } vendor_string = {
sizeof(vendor_string),
DESC_STRING,
{'S','i','l','i','c','o','n',' ','C','h','i','p',' ','P','u','b','l','i','c','a','t','i','o','n','s'}
};

static const  struct {uint8_t bLength;uint8_t bDescriptorType; uint16_t chars[20]; } product_string = {
sizeof(product_string),
DESC_STRING,
{'U','S','B','-','C',' ','S','e','r','i','a','l',' ','A','d','a','p','t','o','r'}
};

static const  struct {uint8_t bLength;uint8_t bDescriptorType; uint16_t chars[13]; } cdc_interface_string = {
sizeof(cdc_interface_string),
DESC_STRING,
{'C','D','C',' ','I','n','t','e','r','f','a','c','e'}
};

static const  struct {uint8_t bLength;uint8_t bDescriptorType; uint16_t chars[18]; } cdc_data_string = {
sizeof(cdc_data_string),
DESC_STRING,
{'C','D','C',' ','D','a','t','a',' ','I','n','t','e','r','f','a','c','e'}
};

static const  struct {uint8_t bLength;uint8_t bDescriptorType; uint16_t chars[8]; } fake_serial_num = {
sizeof(fake_serial_num),
DESC_STRING,
{'2','4','1','0','6','2','4','1'}
};

# 283
int16_t usb_application_get_string(uint8_t string_number, const void **ptr)
{
if (string_number == 0) {
*ptr = &str00;
return sizeof(str00);
}
else if (string_number == 1) {
*ptr = &vendor_string;
return sizeof(vendor_string);
}
else if (string_number == 2) {
*ptr = &product_string;
return sizeof(product_string);
}
else if (string_number == 3) {
*ptr = &cdc_interface_string;
return sizeof(cdc_interface_string);
}
else if (string_number == 4) {
*ptr = &cdc_data_string;
return sizeof(cdc_data_string);
}
else if (string_number == 5) {

# 314
*ptr = &fake_serial_num;
return sizeof(fake_serial_num);
}

return -1;
}

# 332
const struct configuration_descriptor *usb_application_config_descs[] =
{
(struct configuration_descriptor*) &configuration_1,
};
typedef char STATIC_SIZE_CHECK_LINE_336 [((sizeof(usb_application_config_descs)/sizeof(*usb_application_config_descs))==1)?1:-1];
typedef char STATIC_SIZE_CHECK_LINE_337 [(sizeof(this_device_descriptor)==18)?1:-1];

