import processing.serial.*;
// displays air/fuel ratio
Serial sPort;
String portName="-port-";
boolean portConnect=false;
int[] serialBuffer=new int[7];
String bufData="";  //what is read from buffer
String dispData="";  //what is further processed for display
String bufData1="";  //what is read from buffer
String dispData1="";  //what is further processed for display1

int x_window=620;
int y_window=620;
boolean lastkey;
int lastt;
int tPacket;
boolean showhelp=true;
int printcode=-1;
int printkey =-1;
int serialIndex=0;

void settings() {
  size(x_window, y_window,P3D);  
}

void setup() {
  surface.setResizable(true);    //doesn't prevent maximise
  noStroke();    //transparent stroke
  textSize(32); 
  textAlign(CENTER, CENTER);
  if(Serial.list().length>0){portName=Serial.list()[0];}
  lastkey=keyPressed;
  lastt=millis();
  tPacket=-1000;  //invalid
  serialBuffer[0]=0;
  serialBuffer[1]=0;
  serialBuffer[2]=0;
  serialBuffer[3]=0;
  serialBuffer[4]=0;
  serialBuffer[5]=0;
  serialBuffer[6]=0;
}

void draw(){
  boolean thiskey;
  char d;
  //if((width!=x_window)||(height!=y_window)){surface.setSize(x_window, y_window);}
  surface.setTitle("Silicon Chip: Wideband Fuel Mixture Display");
  background(color(128,128,128));      //cls grey
  textSize(32); 
  fill(color(0,0,0));
  textAlign(CENTER, CENTER);
  if(portConnect){
    fill(color(0,0,255)); // blue
    text(portName+" connected",width*0.5,height*0.9);
  }else{
    fill(color(192,0,0)); // reddish
    text(portName+" disconnected",width*0.5,height*0.9);
    fill(color(0,0,0));
    text("<",width*0.25,height*0.9);
    text(">",width*0.75,height*0.9);
  }
    thiskey=keyPressed;
  if((thiskey==true)&&(lastkey!=true)){
    printcode=keyCode;
    printkey=key;
    if(printkey== RETURN){printkey = ENTER;}  // suits windows ENTER 
    // and Mac computers RETURN
    
    if(printkey=='>'){printkey ='.';} // uppercase and lower case keys
    if(printkey=='<'){printkey =',';}
    if(printkey=='H' || printkey=='h'){showhelp=!showhelp;} 
    if(printkey=='q' || printkey=='Q'){exit();}                  //quit!
    if(printkey=='x' || printkey=='X'){exit();}                  //quit!
    if(printkey=='.'&&portConnect==false){
      showhelp=true;    //hide help
      serialIndex++;
    }
    if(printkey==','&&portConnect==false){
      showhelp=true;    //hide help
      serialIndex--;
      if(serialIndex<0){serialIndex=0;}
    }
    if(serialIndex>Serial.list().length-1){serialIndex=Serial.list().length-1;}
    if(Serial.list().length>0){portName=Serial.list()[serialIndex];}
    if(printkey== ENTER){
      showhelp=false;    //hide help
      if(portConnect==false){
        try{
          sPort=new Serial(this, portName, 9600);
          portConnect=true;      
        } catch(Exception e){
          portConnect=false;              //failed to connect        
        }
      }else{
        sPort.stop();
        portConnect=false;              
      }      
    }
  }
  lastkey=thiskey;
  //check data and process
  if(portConnect){
    while(sPort.available()>0){
      d=(char)sPort.read();
     serialBuffer[0]=serialBuffer[1];
     serialBuffer[1]=serialBuffer[2];
     serialBuffer[2]=serialBuffer[3];
     serialBuffer[3]=serialBuffer[4];
     serialBuffer[4]=serialBuffer[5];
     serialBuffer[5]=serialBuffer[6];
     serialBuffer[6]=d;
     if(serialBuffer[6]==10){    // end of packet        
 
        bufData=str((char)serialBuffer[0])+str((char)serialBuffer[1])+"."+str((char)serialBuffer[2])+" :1";
        bufData1=str((char)serialBuffer[3])+"."+str((char)serialBuffer[4])+str((char)serialBuffer[5]);
        tPacket=millis();
       }
     }
   } 
  
  //timed update
  if(millis()-lastt>300){
    dispData=bufData;    
    dispData1=bufData1;
    lastt=millis();   
  }
  //check for time/data validity and display
  
  if((millis()-tPacket)>100){dispData1="-.--";}  //invalid timeout. show -.--
  
  fill(color(0,0,0));
  circle(width/2,height/2,width*0.6);
  textSize(72);
  textAlign (CENTER,TOP);
  fill(color(255,255,255));
  text(dispData1,width/2,height/2);  //show Data1 Lambda
  
  if((millis()-tPacket)>100){dispData="--.-  :1";}  //invalid timeout. show --.- :1
  textAlign (CENTER,BOTTOM);
  fill(color(255,255,255));
  text(dispData,width/2,height/2); //show Data Air/Fuel ratio

//fixed text
  textSize(20); 
  text("Press h for Help on/off",width/2,height*.85); 
  textSize(32); 
  text("Air/Fuel Ratio",width/2,height*0.37);
  text("Lambda",width/2,height*0.70);  
  //show help over top, so draw it last
  if(showhelp){      
    fill(color(192,192,192),40);
    rect(0,0,width,height);
    fill(color(0,0,0));
    //textSize(48); 
    textAlign(LEFT, CENTER);
    //text("HELP:",10,40);
    textSize(24); 
    text("Press",10,20);
    text("ENTER or RETURN to connect/disconnect COM port" ,10,50);
    text("'<' or '>' to select COM port",10,80);
    text("'q' or X to quit or close",10,110);
  }

}
