; Fan Timer

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

; Bank 0 RAM

TIME		equ	H'20'	; fan time setting on VR1
TIMER		equ	H'21'	; timer counter for fan
PHASE_COUNT	equ	H'22'	; mains phase counter 
STORE1		equ	H'23'	; delay storage
STORE2		equ	H'24'	; delay storage
TEMP1		equ	H'25'	; delay extra 
PORTB_STO	equ	H'26'	; store portb for RB7
TMR_SLOW	equ	H'27'	; slow down rate for timer
TIMER_CNT	equ	H'28'	; extra timer period
BEEP		equ	H'29'	; beep time
ONE_TIME	equ	H'2A'	; timer on flag
EDGE_CNT	equ	H'2B'	; interrupt edge counter

; All Banks RAM

W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt

 
; start at memory 0

	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

; **********************************************************************************************

SETUP
	movlw	B'01111111'
	movwf	PORTB		; port B outputs high so TRIAC off
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'10000001'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00001010'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000000'	; settings (pullups enabled TMR0/2)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00000010'	; AN1 analog inputs
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01001000'	; Fosc, channel etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01111000'	; 0111 for 8MHz
	movwf	OSCCON		; 
	bcf		STATUS,RP0	; select memory bank 0

; initial conditions
INITIAL
	clrf	TIMER		; timer at 0
	clrf	BEEP		; beep timer
	clrf	TIMER_CNT	; extra timer period
	clrf	TMR_SLOW	; slow down timer
	clrf	ONE_TIME	; set when timer starts
	
	clrf	EDGE_CNT	; timer between edge interrupts

; delay start	
	movlw	D'10'		; extra delay
	movwf	TEMP1

RECYC_DELAY
	call	DELAYms
	decfsz	TEMP1,f
	goto	RECYC_DELAY

; monitor RB7
	movf	PORTB,w
	movwf	PORTB_STO	; store portB levels
	movlw	B'01111111'
	movwf	PORTB		; set high and low for RB7
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000001'	; port B outputs/ inputs set
	movwf	TRISB		; port B data direction register
	movlw	B'10000000'	; settings (pullups disabled TMR0/2)
	movwf	OPTION_REG

; setup interrupt edge
	bcf		STATUS,RP0	; select memory bank 0
	btfss	PORTB_STO,7	; if low delayed timer mode
	goto	L_INT1		; set high going edge

	
	btfss	PORTB,0		; if low set the high going interrupt level
	goto	L_INT1
	bsf		STATUS,RP0	; select memory bank 1
	bcf		OPTION_REG,INTEDG	; low going interrupt edge
	goto	BY_L_INT1
L_INT1
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		OPTION_REG,INTEDG	; high going interrupt edge
BY_L_INT1		
	bcf		STATUS,RP0	; select memory bank 0

; A/D conversion

; Channel 1 A/D value
	call	ACQUIRE_AD
	movf	ADRESH,w
	sublw	D'04'
	btfss	STATUS,C	; if positive then set at 4
	goto	USE_AD
	movlw	D'04'		; minimum value
	goto	BY_USE_AD
USE_AD
	movf	ADRESH,w
BY_USE_AD
	movwf	TIME		; fan time
	goto	ALL_INTERRUPTS	; end


; subroutine to wait for conversion
ACQUIRE_AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return
; end subroutine

; allow interrupts
ALL_INTERRUPTS
	bcf		INTCON,INTF ; clear interrupt edge flag 
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag	
	bsf		INTCON,TMR0IE	; set interrupt enable for TMR0 
	bsf		INTCON,INTE	; interrupt level at RB0	 
	bsf		INTCON,GIE	; set global interrupt enable for above
	bcf		INTCON,INTF ; clear interrupt edge flag 

; if delayed mode check if switch on
	btfsc	PORTB_STO,7	; if low check switch
	goto	STOP_I		; ready to sleep
	btfss	PORTB,0		; if switch on switch fan on
	goto	STOP_I		; ready to sleep
; switch on so load timer
	movf	TIME,w
	movwf	TIMER
	clrf	TMR_SLOW	; slow timer
	clrf	TIMER_CNT	; extra timing period
	bcf		INTCON,INTF	; clear flag
	
; Check for negative zero crossing on mains	
	
RECHK
	btfss	PORTA,3		; if low wait till set
	goto	RECHK		; not set so continue check

CK_LOW
	btfsc	PORTA,3		; if clear then zero crossing
	goto	CK_LOW 

; stop interrupts and load timer with 127 to start in sequence with zero crossing
ZERO_CROSS
	bcf		INTCON,GIE	; stop interrupt
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag
	movlw	D'255'
	movwf	TMR0		; timer ends
	movlw	D'157'		; 156 x 128us is almost 20ms. Start at 157 as is decreased by 1 for compare
	movwf	PHASE_COUNT
	bsf		INTCON,GIE	; set global interrupt enable for above

; check timer
CKTMR
	movf	TIMER,w
	btfss	STATUS,Z	; if zero then end of timing
	goto	RECHK

	movf	TIMER_CNT,w	; extra timer
	btfsc	STATUS,Z	; if zero end of timing period
	goto	STOP_I
	movf	TIME,w		; time
	movwf	TIMER
	decf	TIMER_CNT,f	; reduce extra timer
	goto	RECHK

; end of time period 
; stop interrupts
STOP_I
	movf	PORTB,w		; look at portB
	iorlw	B'01110110'	; Triac gate high
	movwf	PORTB
	bcf		INTCON,GIE	; stop interrupt
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag
	bcf		INTCON,TMR0IE	; clear interrupt enable for TMR0 

	btfss	PORTB_STO,7	; if low delayed timer mode
	goto	L_INT		; set high going edge

	btfss	PORTB,0		; if low set the high going interrupt level
	goto	L_INT
	bsf		STATUS,RP0	; select memory bank 1
	bcf		OPTION_REG,INTEDG	; low going interrupt edge
	goto	BY_L_INT
L_INT
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		OPTION_REG,INTEDG	; high going interrupt edge
BY_L_INT		
	bcf		STATUS,RP0	; select memory bank 0
	bcf		INTCON,INTF ; clear interrupt edge flag
	clrf	TMR_SLOW	; slow down timer for timer (reset)
	clrf	TIMER_CNT	; timer period cleared so one time for TIMER

	clrf	EDGE_CNT	; timer between edge interrupts
	bsf		INTCON,GIE	; allow interrupt
	bsf		INTCON,INTE	; allow edge interrupt

	sleep				; wait for edge interrupt
	nop
	goto	RECHK


	
; delay subroutine
DELAYms
	movlw	H'FF'		; delay 
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP1	
	movlw	H'FF'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return


 ; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 
	
INTERRUPT
	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; select memory bank 0

; check interrupt source
	btfss	INTCON,TMR0IF	; timer flag
	goto	CK_EDGE_INT
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag
	movlw	D'127'
	addwf	TMR0,f		; timer starts at 127
; beep
	movf	BEEP,w		; beep timer
	btfsc	STATUS,Z
	goto	COMP_38
	btfss	PORTB,3		; if set clear
	goto	SET_3
	bcf		PORTB,3		; clear if set
	goto	COMP_38
SET_3
	bsf		PORTB,3
COMP_38
	movlw	D'38'		; compare with 38 
	xorwf	PHASE_COUNT,w	; is the same drive Triac gate
	btfss	STATUS,Z	; if the same decrease timer
	goto	P_COUNT
; decrease interrupt edge counter
	movf	EDGE_CNT,w	; interrupt edge counter
	btfss	STATUS,Z	; do not decrease if zero
	decf	EDGE_CNT,f	
; decrease beep counter
	movf	BEEP,w		; piezo time
	btfsc	STATUS,Z	; if zero then bypass
	goto	INT_EDG
	decf	BEEP,f		; reduce to zero
	goto	JUMP_IN

; allow edge interrupt
INT_EDG
	bsf		INTCON,INTE ; set interrupt enable when beep is zero

; if jumper in and switch on do not decrease TIMER_SLOW
JUMP_IN
	btfsc	PORTB_STO,7	; if low check switch
	goto	DEC_TIME_SLOW
	btfss	PORTB,0		; if switch on do not decrease timer
DEC_TIME_SLOW
	decfsz	TMR_SLOW,f
	goto	P_COUNT
	movf	TIMER,w
	btfsc	STATUS,Z	; if zero do not decrease
	goto	P_COUNT
; if jumper in and switch on do not decrease TIMER
	btfsc	PORTB_STO,7	; if low check switch
	goto	DEC_TIME
	btfss	PORTB,0		; if switch on do not decrease timer
DEC_TIME
	decf	TIMER,f
P_COUNT

; decrease phase counter
	movf	PHASE_COUNT,w
	btfss	STATUS,Z	; if zero then do not decrease
	decf	PHASE_COUNT,f

	goto	DRV_GATE	; bypass for full gate drive

	movlw	D'151'		; compare for 0 to 90 degrees phase from after zero crossing
	subwf	PHASE_COUNT,w	; Triac gate drive 
	btfsc	STATUS,C
	goto 	DRV_GATE 
	movlw	D'112'		; compare just after zero crossing for positive cycle
	subwf	PHASE_COUNT,w	; Triac gate drive 
	btfsc	STATUS,C	; if negative then check above 39
	goto	OFF_GATE	; not below
	movlw	D'74'		; compare with  
	subwf	PHASE_COUNT,w	; Triac gate 
	btfsc	STATUS,C
	goto	DRV_GATE
	movlw	D'34'
	subwf	PHASE_COUNT,w
	btfss	STATUS,C
	goto	DRV_GATE
; not at these counts so switch off gate drive
OFF_GATE
	movf	PORTB,w		; look at portB
	iorlw	B'01110110'	; Triac gate high
	movwf	PORTB
	goto	CK_EDGE_INT

DRV_GATE
	btfss	ONE_TIME,0		; if set continue
	goto	CK_EDGE_INT
	movf	PORTB,w
	andlw	B'00001001'
	movwf	PORTB		; gate low or on	
 
CK_EDGE_INT
	btfss	INTCON,INTF
	goto	RECLAIM

; on interrupt for edge, set timer so it provides switch debounce
	movf	EDGE_CNT,w	; edge counter
	btfsc	STATUS,Z	; if zero can operate
	goto	EDG_WORK
	bcf		INTCON,INTF	; clear interrupt flag
	goto	RECLAIM
		 	
; edge interrupt so allow timer interrupts
EDG_WORK
;	bcf		INTCON,TMR0IF	; clear flag
	movlw	D'10'
	movwf	EDGE_CNT		; timer between edge interrupts

	bsf		INTCON,TMR0IE	; allow timer interrupts
	btfss	ONE_TIME,0		; if set continue
	goto	ONLY1
	
	movf	TIMER,w		; if zero reload
	btfss	STATUS,Z
	goto	PRESSED_AGN
	movf	TIME,w
	movwf	TIMER
	clrf	TMR_SLOW	; slow timer
	clrf	TIMER_CNT	; extra timing period
	movlw	D'20'		; beep time
	movwf	BEEP		; beep
ONLY1
	bsf		ONE_TIME,0	; set when one interrupt after reset
	bcf		INTCON,INTF ; clear interrupt edge flag 	
	goto	RECLAIM

PRESSED_AGN
; if jumper in no extra time addition feature
	btfss	PORTB_STO,7		; if low no extra timer
	goto	RECLAIM
	
; if switch pressed again during timing then increase timer count by 1
; and beep piezo
	
	bcf		INTCON,INTF	; clear flag	
	incf	TIMER_CNT,f	; extra time
	movf	TIMER_CNT,w
	sublw	D'02'		; stop at 2 extra count periods
	btfss	STATUS,C	; if more than 3 stop
	goto	TIME_END
	bcf		INTCON,INTF ; clear interrupt edge flag 
	bcf		INTCON,INTE ; clear interrupt enable until beep is zero 
	movlw	D'20'		; beep time
	movwf	BEEP		; beep
	goto	RECLAIM

TIME_END
	clrf	TIMER_CNT	; timer
	clrf	TIMER		; time period

; end of interrupt reclaim w and status 
RECLAIM
	
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt



 end
