' Bird Brooder (see Silicon Chip, October 2005)
' PICAXE-18X

' b0 is the temp value from DS18B20
' b4 is the current temperature
' b5 is the desired temperature
' b6 is the displayed temperature
' b7 is used to allow peltier to continue through the display routine
' b11 is used by the display routine
' b12 is used by the display routine

initial:
   b5 = 30			'sets the initial desired temp

main:
   gosub temp
   gosub action
   gosub display
   gosub switchcheck
   goto main
		
temp:
   pause 1000
   readtemp 2,b0
   pause 1000
   if b0 >127 then undertemp
   if b0 >45  then overtemp
   b4=b0			'make the calculated temp the current temp
   b6=b4 			'make the current temp the displayed temp
   return
		
undertemp:
   b4 = 00			'if temp is below zero than make zero 
   b6 = b4			'use this value for display purposes
   return
		
overtemp:
   b4 = 45			'if temp is above 45 degree's than make 45 
   b6 = b4			'use this value for display purposes
   return

action:
   if b4<b5 then peltierhot 
   if b4>b5 then peltiercold
   if b4=b5 then peltiernil
   return

switchcheck:
   if pin0 = 0 then switchdown  'pin normally pulled high
   if pin7 = 0 then switchup	  'pin normally pulled high	
   return

display:
   symbol bDecimal = b6
   symbol bTensNibble = b11
   symbol bUnitNibble = b12

   bTensNibble = bDecimal / 10
   bUnitNibble = bDecimal // 10
		
   let pins = b11+48+b7	'dislay 2 to be be latched		
   low 4  		
   high 4
   let pins = b12+48+b7	'display 1 to be latched 
   low 5 
   high 5
   return

switchup:
   if b5 = 45 then switchcheck  'won't allow countup beyond 45
   let b6=b5
   gosub display
   pause 300
   let b5 = b5+1		'increment one per subroutine
   let b6=b5		'let the desired temp be the displayed temp
   gosub display		'display incremented value
   pause 300
   goto switchcheck

switchdown:
   if b5 = 0 then switchcheck  'won't allow countdown below 0
   let b6=b5
   gosub display
   pause 300
   let b5 = b5-1		'decrement one per subroutine
   let b6=b5		'let the desired temp be the displayed temp
   gosub display		'display decremented value
   pause 300
   goto switchcheck

peltiercold:
   low 7			'ensure the heat is off before
   pause 100		
   high 6			'turn on cool
   let b7=64		'used to keep pin high during display routine
   return

peltierhot:
   low 6 			'ensure the cool is off before 
   pause 100
   high 7			'turn on heat
   let b7=128 		'used to keep pin high during display routine
   return

peltiernil:
   low 6			'ensure cool is off
   pause 100
   low 7			'ensure heat is off
   pause 100
   let b7=0			'used to keep pin low during display routine
   return
