'***********************************************************************************************
'*************** PIC-16f877a Serial IO Controller And Multi Sampler For Windows ****************
'***********************************************************************************************

'Microcontroller Used: PIC 16f877a

Include "modedefs.bas"          ' Include serial modes
Define   OSC 4                 '4MHz crystal 


'-----------------------------------------------------------------------------------------------
'Port Configuration Listing
'-----------------------------------------------------------------------------------------------

'PortA: Pin2,  RA0/AN0  = Temperature Sensor
'PortA: Pin3,  RA1/AN1  = LDR Sensor
'PortA: Pin4,  RA2/AN2  = (0-25) Volt Analog 2 Input
'PortA: Pin5,  RA3/AN3  = (0- 5) Volt Analog 1 Input

'PortE: Pin8,  RE0/AN6  = Relay 1
'PortE: Pin9,  RE1/AN7  = Relay 2
'PortE: Pin10, RE2/AN8  = Buzzer

'PortC: Pin15, RC0      = 10 BIT Input port D8
'PortC: Pin16, RC1      = 10 BIT Input port D9
'PortC: Pin17, RC2/TOC  = 10 BIT Output Port D8
'PortC: Pin18, RC3/AN5  = 10 BIT Output Port D9
'PortC: Pin25, RC6      = Serial Port TX
'PortC: Pin26, RC7      = Serial Port RX

'PortB: Pin33, RB0/INT  = 10 BIT Output port D0
'PortB: Pin34, RB1      = 10 BIT Output port D1
'PortB: Pin35, RB2      = 10 BIT Output port D2
'PortB: Pin36, RB3/PGM  = 10 BIT Output port D3
'PortB: Pin37, RB4      = 10 BIT Output port D4
'PortB: Pin38, RB5      = 10 BIT Output port D5
'PortB: Pin39, RB6/PGC  = 10 BIT Output Port D6
'PortB: Pin40, RB7/PGD  = 10 BIT Output Port D7

'PortD: Pin19, RD0/PSP0 = 10 BIT Input port D0
'PortD: Pin20, RD1/PSP1 = 10 BIT Input port D1
'PortD: Pin21, RD2/PSP2 = 10 BIT Input port D2
'PortD: Pin22, RD3/PSP3 = 10 BIT Input port D3
'PortD: Pin27, RD4/PSP4 = 10 BIT Input port D4
'PortD: Pin28, RD5/PSP5 = 10 BIT Input port D5
'PortD: Pin29, RD6/PSP6 = 10 BIT Input Port D6
'PortD: Pin30, RD7/PSP7 = 10 BIT Input Port D7

'-----------------------------------------------------------------------------------------------
'-----------------------------------------------------------------------------------------------


'Define port pins as inputs and outputs...

                 TRISA  = %00001111
                 TRISB  = %00000000
                 TRISC  = %10000011
                 TRISD  = %11111111
                 TRISE  = %00000000
                 
'Configure ADC register

                 ADCON1 = %10000010
                 PAUSE 500


'Define variables...


                 LoopX VAR BYTE
                 RelayNum VAR BYTE
                 RelayStatus VAR BYTE
                 DoFunction VAR BYTE
                 BuzzerStatus VAR BYTE
                 Temperature VAR WORD
                 LDRLight VAR WORD
                 VCC1 VAR WORD
                 VCC2 VAR WORD
                 PortBits VAR WORD[10]
                 InputDecimalValue VAR WORD
                 OutputDecimalValue VAR BYTE
                 BIT8 VAR BYTE
                 BIT9 VAR BYTE

                 OutputD0 VAR PORTB.0
                  OutputD1 VAR PORTB.1
                   OutputD2 VAR PORTB.2
                  OutputD3 VAR PORTB.3
                 OutputD4 VAR PORTB.4
                  OutputD5 VAR PORTB.5
                   OutputD6 VAR PORTB.6
                   OutputD7 VAR PORTB.7
                  OutputD8 VAR PORTC.4
                 OutputD9 VAR PORTC.5

                 InputD0  VAR PORTD.0
                  InputD1  VAR PORTD.1
                   InputD2  VAR PORTD.2
                  InputD3  VAR PORTD.3
                 InputD4  VAR PORTD.4
                  InputD5  VAR PORTD.5
                   InputD6  VAR PORTD.6
                   InputD7  VAR PORTD.7
                  InputD8  VAR PORTC.0
                 InputD9  VAR PORTC.1

                 Relay1 VAR PORTE.0
                 Relay2 VAR PORTE.1
                 Buzzer VAR PORTE.2
                 TXRXLed VAR PORTA.4


'Set variable to default values
                 
                 LoopX = 0
                 Buzzer = 0
                 OutputDecimalValue = 0
                 InputDecimalValue = 0
                 VCC1 = 0
                 VCC2 = 0
                 Temperature = 0
                 RelayNum = 0
                 RelayStatus = 0
                 DoFunction = 0
                 BIT8 = 0
                 BIT9 = 0

                 LOW OutputD0
                  LOW OutputD1
                 LOW OutputD2
                  LOW OutputD3
                 LOW OutputD4
                  LOW OutputD5
                 LOW OutputD6
                  LOW OutputD7
                 LOW OutputD8
                  LOW OutputD9

                 LOW Relay1
                  LOW Relay2
                 LOW Buzzer


FOR LoopX = 0 TO 9

                 PortBits[LoopX] = 0

NEXT

'Init procs

                 GOSUB ReadAndSendTemperature
                  GOSUB ReadAndSendLightLevel
                   GOSUB ReadVCC1Level
                  GOSUB ReadVCC2Level
                 GOSUB ToggleRelays

'-----------------------------------------------------------------------------------------
     MainLoop:
'-----------------------------------------------------------------------------------------


'Wait for PC to send a function command keep looping until one is received...

                      SERIN PORTC.7, T2400, ["a"], DoFunction

'Toggle TX/RXLed
                      TOGGLE TXRXLed

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'-----------------------------------------------------------------------------------------
SELECT CASE DoFunction
'-----------------------------------------------------------------------------------------


CASE 1

                      GOSUB ReadAndSendTemperature

CASE 2

                      GOSUB ReadAndSendLightLevel

CASE 3

                      GOSUB ReadVCC1Level

CASE 4

                      GOSUB ReadVCC2Level

CASE 5

                      GOSUB ToggleRelays

CASE 6

                      GOSUB ActivateBuzzer

CASE 7

                      GOSUB ReadInputs

CASE 8

                      GOSUB SetOutputs

END SELECT

                      DoFunction = 0

GOTO MainLoop


'-----------------------------------------------------------------------------------------
     ReadAndSendTemperature:
'-----------------------------------------------------------------------------------------
                                             
                       ADCON0 = %11000001
                       PAUSE 2
                       ADCON0.2 = 1
                       PAUSE 2
                       Temperature.HighByte = ADRESH
                       Temperature.LowByte = ADRESL


                       PAUSE 2
                       SEROUT PORTC.6, T2400, ["a", #Temperature, "@"]
                       Temperature = 0

RETURN


'-----------------------------------------------------------------------------------------
     ReadAndSendLightLevel:
'-----------------------------------------------------------------------------------------
                       
                       ADCON0 = %11001001
                       PAUSE 2
                       ADCON0.2 = 1
                       PAUSE 2
                       LDRLight.HighByte = ADRESH
                       LDRLight.LowByte = ADRESL


                       PAUSE 2
                       SEROUT PORTC.6, T2400, ["a", #LDRLight, "@"]
                       LDRLight = 0

RETURN


'-----------------------------------------------------------------------------------------
     ReadVCC1Level:
'-----------------------------------------------------------------------------------------

                       ADCON0 = %11010001
                       PAUSE 2
                       ADCON0.2 = 1
                       PAUSE 2
                       VCC1.HighByte = ADRESH
                       VCC1.LowByte = ADRESL


                       PAUSE 2
                       SEROUT PORTC.6, T2400, ["a", #VCC1, "@"]
                       VCC1 = 0   
 
RETURN


'-----------------------------------------------------------------------------------------
     ReadVCC2Level:
'-----------------------------------------------------------------------------------------

                       ADCON0 = %11011001
                       PAUSE 2
                       ADCON0.2 = 1
                       PAUSE 2
                       VCC2.HighByte = ADRESH
                       VCC2.LowByte = ADRESL


                       PAUSE 2
                       SEROUT PORTC.6, T2400, ["a", #VCC2, "@"]
                       VCC2 = 0
RETURN


'-----------------------------------------------------------------------------------------
     ToggleRelays:
'-----------------------------------------------------------------------------------------
                       
                       PAUSE 2
                       SERIN PORTC.7, T2400, ["a"], RelayNum, RelayStatus
                       IF RelayNum = 1 THEN GOSUB ToggleRelay1
                       IF RelayNum = 2 THEN GOSUB ToggleRelay2
RETURN


'-----------------------------------------------------------------------------------------
     ToggleRelay1:
'-----------------------------------------------------------------------------------------

IF RelayStatus = 1 THEN

                       HIGH Relay1
        ELSE
                       LOW  Relay1


ENDIF
                       RelayStatus = 0
                       RelayNum = 0
RETURN


'-----------------------------------------------------------------------------------------
     ToggleRelay2:
'-----------------------------------------------------------------------------------------

IF RelayStatus = 1 THEN

                       HIGH Relay2
        ELSE
                       LOW  Relay2

ENDIF
                       RelayStatus = 0
                       RelayNum = 0
RETURN


'-----------------------------------------------------------------------------------------
     ActivateBuzzer:
'-----------------------------------------------------------------------------------------

                       PAUSE 2
                       SERIN PORTC.7, T2400, ["a"], BuzzerStatus
                       Buzzer = BuzzerStatus

RETURN


'-----------------------------------------------------------------------------------------
     ReadInputs:
'-----------------------------------------------------------------------------------------

                       IF InputD0 = 1 THEN PortBits[0] = 1
                       IF InputD1 = 1 THEN PortBits[1] = 2
                       IF InputD2 = 1 THEN PortBits[2] = 4
                       IF InputD3 = 1 THEN PortBits[3] = 8
                       IF InputD4 = 1 THEN PortBits[4] = 16
                       IF InputD5 = 1 THEN PortBits[5] = 32
                       IF InputD6 = 1 THEN PortBits[6] = 64
                       IF InputD7 = 1 THEN PortBits[7] = 128
                       IF InputD8 = 1 THEN PortBits[8] = 256
                       IF InputD9 = 1 THEN PortBits[9] = 512
                                        
FOR LoopX = 0 TO 9

                       InputDecimalValue = InputDecimalValue + PortBits[LoopX] 
                       PortBits[LoopX] = 0

NEXT

                       PAUSE 2
                       SEROUT PORTC.6, T2400, ["a", #InputDecimalValue, "@"]

                       InputDecimalValue = 0

RETURN


'-----------------------------------------------------------------------------------------
     SetOutputs:
'-----------------------------------------------------------------------------------------


Write8BITToPort:

                       PAUSE 2
                       SERIN PORTC.7, T2400, ["a"], OutputDecimalValue
                       PORTB = OutputDecimalValue
                       OutputDecimalValue = 0


WriteBITs8And9ToPort:

                       PAUSE 2
                       SERIN PORTC.7, T2400, ["a"], BIT8, BIT9


IF BIT8 = 1 THEN

                       HIGH OutputD8
        ELSE
                       LOW OutputD8

ENDIF


IF BIT9 = 1 THEN

                       HIGH OutputD9
        ELSE
                       LOW OutputD9

ENDIF

                       BIT8 = 0
                       BIT9 = 0

RETURN


'-----------------------------------------------------------------------------------------
END
'-----------------------------------------------------------------------------------------



