;******************************************
;
; Project: Winch Controller Ver 1.7
;
; PICAXE: PICAXE-08M
; ProgEdit Ver. 4.1.2
; PICAXE Firmware: Version 9.0
; Programmer: Robert V Hammond (C) 2K5
; Date commenced: 30-10-2K4
;
;*******************************************
;
; Notes:
;
; Pin0, Pin1, Pin2, Pin3, Pin4 are
; Normally Low, -Active High.
; Last Update: 23:30 16/03/2005
; 
;*******************************************

; Initialisation 
 
setint %00001000, %00001000 	;interrupt when IN3 goes high 
b5 = 0				;interrupt Flag 

; Main program start 
 
Init: 
low output0				;turn off IN relay 
low output2				;turn off OUT relay 
pause 1000				;motor pause - set to suit motor, 
					;must allow motor to stop 
b5 = 0				;zero the interrupt flag 
 
Exec:					;primary input
If b5 = 1 then Init		;has interrupted so init 
pause 10 
if Pin4 = 1 then WinchIn 
pause 10 
if Pin1 = 1 then WinchOut 
goto Exec 
 
NextSwitch:				;secondary switch point 
if b5 = 1 then Init		;has interrupted so init 
pause 10 
If pin4 = 1 then Init 
pause 10 
If pin1 = 1 then Init 
pause 10 
goto NextSwitch

WinchIn:				;rope in 
if b5 = 1 then Init		;has interrupted so init 
high output0			;pull the rope in 
pause 300				;settle time 
goto NextSwitch 
 
WinchOut:				;rope out 
if b5 = 1 then Init		;has interrupted so init 
high output2			;let the rope out 
pause 300				;settle time 
goto NextSwitch 

end					;should not get here! 
 
Interrupt: 
low output0				;switch off IN relay 
low output2				;switch off OUT relay 
input3 = 0				;reset pin3 for next interrupt 
b5 = 1				;set the interrupt flag 
setint %00001000, %00001000 	;restore interrupt 
return 

