;************************************************************************
; Automatic Soldering Iron Controller
; 
; PICAXE-08  Vers 1.00  12 June 2005
;************************************************************************

symbol	iron = 2		'soldering iron control relay on this pin
symbol	pir = pin1		'PIR (or other) people detector on this pin
symbol	timer1 = w0
symbol	timer2 = b9


low iron

start:
  if pin3 = 0 then pressed
  pause 50
  goto start

pressed:
  pause 50				'debounce the button
  if pin3 = 0 then yes_pressed
  goto start

yes_pressed:			'system has now been turned on by operator
  high iron				'so turn the soldering iron on
  sound 4,(100,15,85,20)
  timer1 = 0

time_loop:
  if pir = 0 then clr_timer
  pause 500
  timer1 = timer1 + 1
  if timer1 > 1800 then time_out '1800 equals about 15 minutes
  if pin3 = 0 then but_press
  goto time_loop

clr_timer:
  timer1 = 0			'reset timer 1
  timer2 = 0			'reset timer 2
  goto time_loop

time_out:
  timer2 = 0

cont_lp:
  if pin3 = 0 then oper_can	'button press cancels time out
  if pir = 0 then clr_timer	'the people detector has activated

to_lp:
  if timer2 > 23 then times_up 'this number equals a time of about 30s
  sound 4,(50,10,40,30)
  pause 1000					
  timer2 = timer2 + 1
  goto cont_lp

times_up:
  low iron				'time has run out so switch off the iron
  pause 100
  goto start

oper_can:
  pause 50				'debounce the button
  if pin3 = 0 then tmr_reset
  goto to_lp

tmr_reset:
  sound 4,(90,15,65,20)
  goto clr_timer

but_press:
  pause 50
  if pin3 = 1 then time_loop
  low iron				'switch off the soldering iron

switch_off:
  pause 50				'wait until the button is released...
  if pin3 = 1 then start	'...before restarting the program
  goto switch_off 

