'****************************************************************
'*  Name   : Morseident.bas                                     *
'*  Author : James Cutler                                       *
'*  Notice : Copyright (c)2005, All Rights Reserved             *
'*  Version: 2.0  Date: 01/06/2005                              *
'*                                                              *
'*  Note   : Uses EEPROM to store CW messages                   *
'****************************************************************

TRISA = %11111			'set PORT A as inputs
TRISB = %00000000		'set PORT B as outputs
A VAR byte
D VAR BYTE

LET PORTB = 0

eeprom 0,[02,02,00,00,00,01,02,01,00,01,02,00,00,01,01,01,02,01,02,00,00,02,01,01,02,02]

:standby
IF PORTA.0 = 1 then standby	'wait for button press on PIN 0, port A

:transmit
HIGH PORTB.0			'close TX relay
gosub vk2tim
LOW PORTB.0			'open TX relay 
GOTO standby

:dit
SOUND PORTB.1,[120,05]		'DIT
PAUSE 100
return

:dah
SOUND PORTB.1,[120,20]		'DAH
PAUSE 100
return

:space
PAUSE 200			'SPACE
return

:vk2tim				'read CW information from EEPROM
for a = 0 to 63 step 1
read a,d
IF d = 00 then gosub dit
IF D = 01 then gosub dah
IF d = 02 then gosub space
NEXT a
return
