' Simple Diesel engine sound 
' G. Hunter, Feb 05

' * 6 different steps of rate of sound between stopped and max speed.
' * Constant "fast idle" when decelerating until speed falls below '60' or 40% of max.
' * Double Horn blast on starting.
' * Random single horn when running - every 2 mins at max speed, longer times at slower speeds.
' * Brake exhaust sound on stopping.

' Analogue input voltage is on pin1 - arrange resistor divider to give 3.3V at max speed (3.3V = 160).

' Uses 5-stage shift register with bits 4 & 5 XORd and fed back to input bit.

' pin1 (adc1) is speed volts input
' pin2 (out2) is amplifier output.

' b0 is the shift register
' b2 is ADC voltage representing speed
' b3 is timer to determine rate of sound (pause).
' b4 is intermediate value for speed/10 
' w4 (b8 & b9) is random number used to sound horn 'randomly'

symbol seed = b0
symbol speed = b2
symbol oldspeed = b5				'last speed reading, used to determine if changing
symbol decel = b7					'1 = speed is falling, 0 = accelerating or constant


	seed=56 					'initialize - can be any number except 0 and 255
							'53 is slow, 36 is fast, 56 is pulsy fast
							'4,9 are fast, 5 is pulsy

start:
	seed = seed * 2				'shift left 1 bit. R/H bit 0 is set to zero automatically
	if bit4 <> bit5 then xored		'do an XOR on bits 4 & 5 of seed (b0)
	low 2						'speaker output
	bit0 = 1					'feedback to R/H bit
	goto motspeed

xored:
	high 2					'speaker output

motspeed:
	random w4					'for horn
	readadc 1,speed				'read speed into b2 - 15 steps of 'speed'
	if oldspeed = 0 and speed > 0 then Horn2

horn0:
	if w4 > 65500 and speed > 11 then horn1 '65500 works every 2mins or so at max speed
							 'sometimes get 2 or 3 blasts together - just depends 
							 'on random number generator.
	if oldspeed > speed then slowing
	if oldspeed = speed and decel = 1 then slowing

' So must be accelerating or at steady speed but was last accelerating
	
accel:
	decel = 0

looptarget:
	oldspeed = speed
	b4=speed + 30/31				'integer result converts 16 steps of speed to 6
	
table:						'determine the 'clocking rate'
	lookup b4,(18,10,7,4,2,1,0),b3  	'idle + 6 steps of speed
							'only enough memory for 6 steps in lookup table
paus:
	pause b3				
	goto start

horn2:
	sound 2,(57,50)				'starting double horn blast
	pause 200

horn1:
	sound 2,(57,150)
	oldspeed = speed
	goto looptarget


slowing:  
	decel = 1
	if speed = 0 and oldspeed > 10 then juststopped
	if speed < 60 then loop
	b3 = 8		     			'decelerating at higher speeds gives constant 'fast idle'
	oldspeed = speed
	goto paus

juststopped:
	pause 500
	sound 2,(253,200)				'exhaust brakes sound - try 249 for a quieter hiss
	goto looptarget

