' Steam sound generator with analogue speed input driver.
' G. Hunter, Mar 05.

' Analogue input voltage is on pin1 - arrange resistor divider to give
' 3.3V at max speed. This gives 0-160 analogue values in 16 steps.

' At starting, need something like sound 2,(255,25) then pause 200 = 2 Hz
' At max speed, need  sound 2,(255,8) then pause 20 = 10 Hz

' PICAXE-08

' pin1 (adc1) is speed volts input		'stored in variable b1
' pin2 (out2) is amplifier output.

symbol speed = b1					'input voltage 1-160 count
symbol ontime = b2				'length of hiss sound in 12ms periods
symbol offtime = b3				'quiet time between hiss in ms
symbol chuffsound = b4				'the number represent the hiss in SOUND command
							'usually 255 for loudest hiss. 245 is quiet hiss
symbol oldspeed = b5				'previous speed
symbol speed2 = b7				'oldspeed+10. used to stop instability when speed is just
							'overlapping two input steps.	

oldspeed=0

read2:
	readadc 1,speed
	speed = speed + 5				'see notes at end
	if speed < 11 then stopped
	if oldspeed = 0 and speed > 0 then accel	

L30:
	speed2 = oldspeed+10

L35:
	if speed > speed2 then accel

L40:
	if speed < oldspeed then slowing
	goto times2

slowing:
	oldspeed = speed+10			'+10 necessary
	chuffsound = 249				'mute the volume
	goto times2	  
	  
accel:
	oldspeed = speed-10		
	chuffsound = 255				'loud chuff sound


' Now do the chuffing!!
times2:
	offtime = 254 - speed			
	ontime = 175 - speed		
	ontime = ontime/25 + 5			
	if speed < 10 then stopped
	
chuff:
	sound 2,(chuffsound,ontime)
	pause offtime
	goto read2

stopped:
	if oldspeed > 10 then juststopped
	sound 2,(249,20)
	goto read2

juststopped:
	pause 500
	sound 2,(255,200)				'exhaust brakes sound
	oldspeed = 0
	goto read2

' NOTES:
' Speed is increased by 5 to stop the hunting effect due to the sound ADC having 16.
' Sometimes the speed is on the borderline for the ADC and would change the hiss
' sound when not required.

' This program has been changed so that speed must increase/decrease by TWO steps
' to cause a change in the hiss sound.














