; Luxeon Lighting

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

EEPROM0		equ	H'00'	; non-volatile storage for charging current
EEPROM1		equ	H'01'	; non-volatile storage for Luxeon drive frequency

; Bank 0 RAM

INPUT_V		equ	H'20'	; input voltage
INPUT_VL	equ	H'21'	; input voltage ls byte	
BATT_V		equ	H'22'	; battery voltage
BATT_VL		equ	H'23'	; battery voltage ls bits
CURRENT_I	equ	H'24'	; LED current
CURRENT_IL	equ	H'25'	; LED current ls bits
LDR			equ	H'26'	; LDR 
THERM		equ	H'27'	; thermistor  
MODE		equ	H'28'	; type of operation
ON_OFF		equ	H'29'	; on or off
FLAG_1		equ H'2A'	; charging PWM flag for on or off
CHRG_STRT	equ	H'2B'	; charging started flag
LOW_TME		equ	H'2C'	; charging PWM low time
CHRG_OUT	equ	H'2D'	; charging status
CHRG_COUNT	equ	H'2E'	; counter to check if DC power is connected
CHRGE_ITEMP	equ	H'2F'	; temporary charge comparison value

SWITCH_S2	equ	H'30'	; switch S2 setting
LED_IND		equ	H'31'	; LED indicator flash flags
THERM_STORE	equ	H'32'	; thermister stored value at start of charge
EIGHT_OFF	equ	H'33'	; mode 8 off flag
LED_IND_FS2	equ	H'34'	; LED indicator flash counter, ls byte
SWTIME_MSTR	equ	H'35'	; switch master timer
SW_FLG		equ	H'36'	; switch pressed flag
SW_2SET		equ	H'37'	; time between switch pressings
SW_1SET		equ	H'38'	; time for switch closed
SW_3SET		equ	H'39'	; Luxeon fast start timer
COUNTER2	equ H'3A'	; timeout counter
COUNTER3	equ H'3B'	; timeout counter
COUNTER4	equ H'3C'	; timeout counter
ACQ_TIME	equ	H'3D'	; acquisition period timer
CLOCK_RATE	equ	H'3E'	; 31.25kHz or 8MHz clock
TEN_BIT		equ	H'3F'	; ten bit resolution PWM
TEMP_CHRG	equ	H'40'	; temporary register
PULSE_PWM	equ H'41'	; pulsing of charge pulses
CYCLE_COUNT	equ	H'42'	; cycle counter to determine held switch pressed duration
SET_CURRENT	equ	H'43'	; current set current
FLASH		equ	H'44'	; flashing flags
MODE_2		equ	H'45'	; mode 2 (high, low, flashing)	
SWITCH_W2	equ	H'46'	; switch value temporary working register
LONG_SW		equ	H'47'	; long switch press duration flag
FLASH_COUNT	equ	H'48'	; Luxeon flash counter
FLASH_DUTY	equ	H'49'	; flash (Luxeon) duty flag on or off
TEMP_FLSH	equ	H'4A'	; flash counter temporary register
RAMP		equ	H'4B'	; PWM ramp up flag
FLICKER		equ	H'4C'	; hysteresis flag for LDR dimming	
FLSH_DTY	equ	H'4D'	; for varying duty of flash
ACK_LED		equ	H'4E'	; switch acknowledge flag
SIX_7_8		equ	H'4F'	; on flag for Luxeon in modes 6,7,8
TEMP67		equ	H'50'	; brightness level storage for modes 6,7,8
FLASH_X		equ	H'51'	; mode 8 flash type
LOW_FLASH	equ	H'52'	; low voltage flash
GCOUNTER4	equ	H'53'	; garden timer ms byte of 1,2,3,4
GCOUNTER2	equ	H'54'	; garden timer counters
GCOUNTER3	equ	H'55'	;
GARDEN_TIME	equ	H'56'	; Garden counter on flag
SW_INTRUPT	equ	H'57'	; switch was pressed flag
INTER_READY	equ	H'58'	; interrupt ready flag (set when flash updates ready)
DIV_2COUNT	equ	H'59'	; divide by two for flash and counter changes during charging
CURRENT_AVG	equ	H'5A'	; total of measured Luxeon current over 15 counts
AVG_COUNT	equ	H'5B'	; 15 counter for above
CHARGE_I	equ	H'5C'	; charging current
I_TEMP		equ	H'5D'	; temporary register for charge_I
SW_HOLD		equ	H'5E'	; switch held flag during mode F
	
AVG_CNT1	equ	H'5F'	; current value
AVG_CNT2	equ	H'60'	; current value
AVG_CNT3	equ	H'61'	; current value
AVG_CNT4	equ	H'62'	; current value
AVG_CNT5	equ	H'63'	; current value
AVG_CNT6	equ	H'64'	; current value
AVG_CNT7	equ	H'65'	; current value
AVG_CNT8	equ	H'66'	; current value
SMOOTH_CNT0	equ	H'67'	; total for average counter ms
SMOOTH_CNT1	equ	H'68'	; total for average counter ls

; math routines
AARGB0      equ H'6C'	; most significant byte of argument A
BARGB0      equ H'6D'	; most significant byte of argument B
AARGB1      equ H'6E'	; ls bytes
BARGB1		equ	H'6F'

; All Banks RAM

W_TMP		equ	H'70'	; storage of w before interrupt
STATUS_TMP	equ	H'71'	; status storage before interrupt

INPUT_V_I   equ H'72'	; input loaded voltage
INPUT_VL_I  equ H'73'	; input loaded voltage
B_STORE		equ	H'74'	; port B storage for indicator LEDs
CHARGE_LOOP	equ	H'75'	; charge loop
MEAS_FLAG	equ	H'76'	; set so does not change in interrupt
STORE1		equ	H'77'	; delay timer
STORE2		equ	H'78'	; delay timer
DIMMING		equ	H'79'	; dimming flag
LUX_FREQ	equ	H'7A'	; luxeon drive frequency
FREQ_CHNG_FG equ H'7B'	; frequency flag

 ; preprogram EEPROM DATA 
	
	ORG     2100
	DE	D'28'	; 28 is for 0.7V avg across 1.5 ohm. (assuming 10 bit shifted left by 2 bits)
	DE	D'01'	; higher Luxeon frequency

; start at memory 0

	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT
 
; lookup charge timer values according to settings
CHRG_TIME				; 
	addwf	PCL,f		; add value of display to program counter
	retlw	D'00'		; 0 zero if below trickle rate
	retlw	D'00'		; 100mA zero if below trickle rate
	retlw	D'33'		; 200mA 
	retlw	D'22'		; 300mA 
	retlw	D'17'		; 400mA 
	retlw	D'14'		; 500mA 
	retlw	D'11'		; 600mA 
	retlw	D'9'		; 700mA 
	retlw	D'8'		; 800mA 
	retlw	D'7'		; 900mA
	retlw	D'7'		; 1000mA 
	retlw	D'7'		; 1000mA

CHRG_TIME2	; reduced by 1.5 for above 12V
	addwf	PCL,f		; add value of display to program counter
 	retlw	D'00'		; 0 zero if below trickle rate
	retlw	D'00'		; 100mA zero if below trickle rate
	retlw	D'22'		; 200mA 
	retlw	D'15'		; 300mA 
	retlw	D'12'		; 400mA 
	retlw	D'9'		; 500mA 
	retlw	D'7'		; 600mA 
	retlw	D'6'		; 700mA 
	retlw	D'5'		; 800mA 
	retlw	D'4'		; 900mA
	retlw	D'4'		; 1000mA 
	retlw	D'4'		; 1000mA

CHRG_TIME3	; reduced by 2 for above 15V
	addwf	PCL,f		; add value of display to program counter
	retlw	D'00'		; 0 zero if below trickle rate
	retlw	D'00'		; 100mA zero if below trickle rate
	retlw	D'17'		; 200mA 
	retlw	D'11'		; 300mA 
	retlw	D'9'		; 400mA 
	retlw	D'7'		; 500mA 
	retlw	D'6'		; 600mA 
	retlw	D'5'		; 700mA 
	retlw	D'4'		; 800mA 
	retlw	D'3'		; 900mA
	retlw	D'3'		; 1000mA 
	retlw	D'3'		; 1000mA

RESTART
SETUP
	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11000111'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00111111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'11000000'	; settings (pullups disabled TMR0/2)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'01100111'	; AN0 to AN2 and AN5 and AN6 are analog inputs
	movwf	ANSEL
	movlw	B'01100000'	; left justified A/D result, Vref+ to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'11000000'	; Fosc for 31.25kHz, channel etc use B'01000000'for the 8MHz oscillation
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001000'	; 31.25kHz use B'011110000' for 8MHz
	movwf	OSCCON		; 
; set frequency
	movlw	D'127'		; set PWM (when set at 8MHz)
	btfss	LUX_FREQ,0	; if clear set at FF
	movlw	H'FF'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	clrf	CLOCK_RATE	; clock settings flag

; pwm set
	movlw	H'00'		; 0% duty
	movwf	CCPR1L		; ms byte of PWM
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation

; initial conditions
INITIAL
	clrf	FREQ_CHNG_FG; frequency flag
	clrf	SW_INTRUPT	; if switch was pressed flag
	bsf		DIMMING,0	; dimming flag
	clrf	INTER_READY	; flash ready
	clrf	GARDEN_TIME	; garden timer flag
	clrf	LOW_FLASH	; low voltage flash
	clrf	FLASH_X		; mode 8 flash type
	clrf	SW_FLG		; switch pressed flag
	clrf	LED_IND		; LED indicator flashing flags
	clrf	ACK_LED		; switch acknowledge flag
	clrf	FLICKER		; hysteresis flag for LDR dimming
	clrf	ON_OFF		; off
	clrf	MEAS_FLAG	; clear. It is set so does not change LEDs in interrupt
	clrf	CHRG_OUT	; charge status
	clrf	CHRG_STRT	; charging flag
	clrf	TEN_BIT		; ten bit PWM
	clrf	SW_1SET		; debounce for switch
	clrf	SW_2SET		; repeat timer
	movlw	D'40'		; Luxeon current setting
	movwf	SET_CURRENT	; dimming current
	clrf	FLASH		; flashing off
	clrf	LONG_SW		; long switch pressed duration	
	clrf	SW_FLG		; switch pressed flag
	clrf	FLASH_DUTY	; flash duty on or off flag

; get charge current
	movlw	EEPROM0		; eeprom charge current value
	call	EEREAD		; value in W
	movwf	CHARGE_I	; charge current
	movlw	D'10'		; delay to start
	call	DELAYX
; get frequency
	movlw	EEPROM1		; eeprom address
	call	EEREAD		; sets eeadr	
	movwf	LUX_FREQ	; new value
		
; allow interrupts
ALL_INTERRUPTS
	bcf		INTCON,INTF		; RB0 interrupt flag
	bcf		INTCON,TMR0IF	; timer flag
	bsf		INTCON,INTE		; RB0 interrupt
	bsf		INTCON,TMR0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE		; set global interrupt enable for above

OFF_CYCLE
; if already charging go to RECYC_CHRG
	btfsc	CHRG_STRT,0	; if set then started	
	goto	RECYC_CHRG

	movf	ON_OFF,w	; on or off
	btfss	STATUS,Z	; if zero, off
	goto	ON_CYCLE
	movf	SWITCH_S2,w
	xorlw	H'0F'	
	btfss	STATUS,Z	; if zero then keep reference on
	bcf		PORTA,7		; reference off

; when off set for 31.25kHz
	call	SET31.25

; initial timer
INIT_TIME
	movlw	D'20'		; check every few seconds or so
	movwf	CHRG_COUNT	; timer

; off loop here	
OFF_LOOP
	clrf	LOW_TME  	; RA6 low
	bcf		PORTA,6		; low output
	clrf	CHRG_OUT	; charge status
	clrf	CHRG_STRT	; charge started cleared
; if off reset clock rate
	movf	ON_OFF,w	; on or off
	btfss	STATUS,Z	; if zero, off
	goto	ON_CYCLE
	call	SET31.25	; off so reset to 31.25kHz
; switch off Acknowledge LED
	movf	SW_2SET,w	; switch timer
	btfsc	STATUS,Z	; if timed out switch off Acknowledge LED
	clrf	ACK_LED		; acknowledge LED
	bcf		PORTB,4		; ack. LED off

; set timer
WAIT_TIME1
	movf	SWITCH_S2,w	; switch value
	xorlw	H'0F'		; if mode F bypass waiting for delays
	btfsc	STATUS,Z
	goto	RECYC_CHRG
	movf	CHRG_COUNT,w
	btfss	STATUS,Z	; if zero continue otherwise wait 
	goto	CH_ON_OFF1	; 
	movlw	D'50'		; check periodically
	movwf	CHRG_COUNT	; timer
	goto	RECYC_CHRG
; check if on or off
CH_ON_OFF1
	movf	ON_OFF,w	; on or off
	btfss	STATUS,Z	; if zero, off
	goto	ON_CYCLE
	goto	WAIT_TIME1
RECYC_CHRG
; check if on or off
	movf	ON_OFF,w	; on or off
	btfss	STATUS,Z	; if zero, off
	goto	ON_CYCLE
	call	MON_S2		; monitor S2
; if mode 0 do not read input volts
	movf	SWITCH_S2,w
	btfsc	STATUS,Z	; when 0 bypass
	goto	OFF_LOOP	
	call	MEAS_INPUT_V ; get input
	
; if >8V then charger attached (diode drop 0.7V)
	movf	INPUT_V,w
	sublw	D'88'		; 8.7V at input
	btfsc	STATUS,C	; if negative then > 
	goto	OFF_LOOP	; clear chrg_strt flag 
	movf	INPUT_V,w	; input value
	sublw	D'198'		; maximum voltage equivalent to 18.7V at input
	btfss	STATUS,C	; 
	goto	OFF_LOOP
; start charger
	btfsc	CHRG_STRT,0	; if set then started
	goto	STRTD

; check battery and start charge when voltage below 1.5V/ cell 

	call	MEAS_BATT_V	; get Battery value in BATT_V
	movf	BATT_V,w	; battery value
	sublw	D'196'		; voltage equivalent to 1.5V/cell
	btfss	STATUS,C	; 
	goto	OFF_LOOP	; do not start
	call	SET_8MHz	; set for 8MHz rate

; load counter with x hour timer dependent on charge
	
LD_5_HR
; charge value 0-40
	rrf		CHARGE_I,w	; /2
	movwf	TEMP_CHRG	; temp
	rrf		TEMP_CHRG,f	; /4
	bcf		TEMP_CHRG,7
	bcf		TEMP_CHRG,6	; clear ms bits if set
	movf	TEMP_CHRG,w
; alter according to input voltage
	call	MEAS_INPUT_V ; get input
	
; if >12V then reduce charge time
	movf	INPUT_V,w
	sublw	D'131'		; 12V at input
	btfss	STATUS,C	; if negative then > 
	goto	ABVE12		; more than 12V 
	movf	TEMP_CHRG,w
	call	CHRG_TIME
 	goto	STO_CNT
ABVE12
	movf	INPUT_V,w
	sublw	D'164'		; 15V at input
	btfss	STATUS,C	; if negative then > 
	goto	ABVE15		; more than 15V 
	movf	TEMP_CHRG,w
	call	CHRG_TIME2
 	goto	STO_CNT
ABVE15
	movf	TEMP_CHRG,w
	call	CHRG_TIME3	; less time
STO_CNT
	movwf	COUNTER4	; ms byte of 2,3,4. sets hours
	clrf	COUNTER3	; clear ls byte counters
	clrf	COUNTER2
	clrf	CHRG_OUT	; charge status to full rate
	call	MEAS_THERM	; get Thermistor value value in THERM
	movf	THERM,w		; thermistor value
	movwf	THERM_STORE
	bsf		CHRG_STRT,0	; start flag set 

STRTD
; switch off if battery over 1.95V
	call	MEAS_BATT_V	; get Battery value in BATT_V
	movf	BATT_V,w	; battery value
	sublw	D'253'		; maximim voltage equivalent to 1.95V/cell
	btfss	STATUS,C	; 
	goto	OFF_LOOP

	call	CHARGE_CYC	
	goto	RECYC_CHRG

; ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
; when the Lighting system is on
ON_CYCLE
	movf	ON_OFF,w	; on or off
	btfsc	STATUS,Z	; if zero, off
	goto	OFF_CYCLE
; set for 8MHz
	call	SET_8MHz
; initial timer
	movf	SWITCH_S2,w
	xorlw	D'11'		; for modes 11 and 12 check input V continuously
	btfsc	STATUS,Z
	goto	CONTINUOUS_CHK
	movf	SWITCH_S2,w
	xorlw	D'12'		; for modes 11 and 12 check input V continuously
	btfsc	STATUS,Z
	goto	CONTINUOUS_CHK
	movf	CHRG_COUNT,w
	btfss	STATUS,Z	; when zero
	goto	SW_S2_READ
	movlw	D'200'		; check periodically 
	movwf	CHRG_COUNT	; timer

CONTINUOUS_CHK
	call	MEAS_INPUT_V ; get input
	
; if >8V then charger attached (diode drop 0.7V)
	movf	INPUT_V,w
	sublw	D'88'		; 8.7V at input
	btfsc	STATUS,C	; if negative then > 
	goto	OFF_LOOP1	; clear chrg_strt flag 
	movf	INPUT_V,w	; input value
	sublw	D'198'		; maximum voltage equivalent to 18.7V at input
	btfsc	STATUS,C	; 
; start charger
	goto	STRT_CHRG1
OFF_LOOP1
	clrf	LOW_TME  	; RA6 low
	bcf		PORTA,6		; low output
	clrf	CHRG_OUT	; charge status
	clrf	CHRG_STRT	; charge started cleared
	call	MON_S2
	goto	BATT_MON

; start charger
STRT_CHRG1
	btfsc	CHRG_STRT,0	; if set then started
	goto	STRTD_ON

; check battery and start charge when voltage below 1.5V/ cell 

	call	MEAS_BATT_V	; get Battery value in BATT_V
	movf	BATT_V,w	; battery value
	sublw	D'196'		; voltage equivalent to 1.5V/cell
	btfss	STATUS,C	; 
	goto	OFF_LOOP1	; do not start
; 
; load counter with x hour timer
; charge value 0-40
	rrf		CHARGE_I,w	; /2
	movwf	TEMP_CHRG	; temp
	rrf		TEMP_CHRG,f	; /4
	bcf		TEMP_CHRG,7
	bcf		TEMP_CHRG,6	; clear ms bits if set
	movf	TEMP_CHRG,w
	call	CHRG_TIME
	movwf	COUNTER4	; ms byte of 1,2,3,4
	clrf	COUNTER2	; clear ls byte counters
	clrf	COUNTER3
	clrf	CHRG_OUT	; charge status to full rate
	call	MEAS_THERM	; get Thermistor value value in THERM
	movf	THERM,w		; thermistor value
	movwf	THERM_STORE	; store current temperature

STRTD_ON
	bsf		CHRG_STRT,0	; start flag set 
; switch off if battery over 1.95V
	call	MEAS_BATT_V	; get Battery value in BATT_V
	movf	BATT_V,w	; battery value
	sublw	D'253'		; maximim voltage equivalent to 1.95V/cell
	btfss	STATUS,C	; 
	goto	OFF_LOOP1
 
; read switch S2
SW_S2_READ
	call	MON_S2		; get current switch settings

; SWITCH_S2 has switch setting from 0 to 15
	 
BATT_MON
; monitor battery voltage
	call	MEAS_BATT_V
; values in BATT_V and BATVL

; if charger off, drive indicator LEDs
	movf	CHRG_STRT,w	; check for charger
	btfss	STATUS,Z	; if not zero then charger on
	goto	DRV_LUX
; if mode 6,7,8 and Luxeon off, switch off indicator LEDs
	movf	SWITCH_S2,w
	xorlw	D'6'		; if 6
	btfsc	STATUS,Z
	goto	LUX_OFF?
	movf	SWITCH_S2,w
	xorlw	D'7'		; if 7
	btfsc	STATUS,Z
	goto	LUX_OFF?
	movf	SWITCH_S2,w
	xorlw	D'8'		; if 8
	btfss	STATUS,Z
	goto	MEAS_BATT
LUX_OFF?
	btfss	SIX_7_8,0	; if clear Luxeon off so indicator LEDs off too
	goto	IND_LEDS_OFF

; measure and indicate battery Voltage	
MEAS_BATT
	movf	BATT_V,w
	sublw	D'156'		; equivalent to 1.2V per cell
	btfss	STATUS,C	; if c is 0 then - and battery voltage more than 1.2V per cell
	goto	INDICATE_GOOD
	movf	BATT_V,w
	sublw	D'151'		; equivalent to 1.15V per cell
	btfss	STATUS,C
	goto	INDICATE_DROPPING
	movf	BATT_V,w
	sublw	D'144'		; equivalent to 1.1V per cell
	btfss	STATUS,C
	goto	INDICATE_LOW
	movf	BATT_V,w
	sublw	D'137'		; equivalent to 1.05V per cell
	btfss	STATUS,C
	goto	INDICATE_VLOW
	movf	BATT_V,w
	sublw	D'130'		; equivalent to 1.0V per cell
	btfss	STATUS,C
	goto	INDICATE_FLAT
IND_LEDS_OFF
	bcf		LED_IND,0	; flash orange off
	bcf		LED_IND,1	; flash red off
	bcf		PORTB,4		; green LED off
	bcf		PORTB,5		; red LED off
 	goto	DRV_LUX

; indicating LED off for below 1V per cell
; LUXEON off below 0.9V per cell (118 in A/D)
INDICATE_GOOD
	bcf		LED_IND,0	; flash orange off
	bcf		LED_IND,1	; flash red off
	bsf		PORTB,4		; green LED on
	bcf		PORTB,5		; red LED off
 	goto	DRV_LUX
INDICATE_DROPPING
	bcf		LED_IND,0	; flash orange off
	bcf		LED_IND,1	; flash red off
	bsf		PORTB,4		; green LED on
	bsf		PORTB,5		; red LED on
 	goto	DRV_LUX
INDICATE_LOW
	bcf		LED_IND,1	; flash red off
	bsf		LED_IND,0	; flash orange
	goto	DRV_LUX1
INDICATE_VLOW
	bcf		LED_IND,0	; flash orange off
	bcf		LED_IND,1	; flash red off
	bcf		PORTB,4		; green LED off
	bsf		PORTB,5		; red LED on
 	goto	DRV_LUX	
INDICATE_FLAT
	bcf		LED_IND,0	; flash orange off
	bsf		LED_IND,1	; flash red
	goto	DRV_LUX1

; drive Luxeon LED/s

DRV_LUX
	movf	PORTB,w
	movwf	B_STORE			; keep values
DRV_LUX1
	movf	FLASH,w			; if not flashing bypass waiting for interrupt
	goto	LUX_FLASHING

; do PWM when waiting
DRV_LUX_PWM
	btfss	FLASH_DUTY,0	; when set Luxeon is on so do PWM
	goto	DRV_LUX1
	btfsc	EIGHT_OFF,0		; if mode 8 off flag set do not continue
	goto	DRV_LUX1

LUX_FLASHING
; Luxeon flashing
	btfss	FLASH,1			; torch flash flag
	goto	CHK_FLASH0

; slow flash (parking mode 9 and 10 and torch mode 2)
	movf	FLASH_COUNT,w	; flash rate counter
	andlw	B'00011111'		; only the 16 bit count (65ms x 32) for flash rate 
	movwf	TEMP_FLSH
	movlw	D'01'
	xorwf	TEMP_FLSH,w
	btfss	STATUS,Z		; flash on when equal
	goto	SET_FLASH_DUTY
	goto	CLR_FLASH_DUTY

CHK_FLASH0	
	btfss	FLASH,0			; emergency flash flag
	goto	CK_LOW_FLSH_0	; low voltage flash flag
	goto	FLASH_0
CK_LOW_FLSH_0
	btfss	LOW_FLASH,0		; if set then flash0
	goto	CHK_FLASH2
FLASH_0
	movf	FLASH_COUNT,w	; flash rate counter
	andlw	B'00000111'		; only the 8 bit count (65ms x 8) for fast flash rate
	movwf	TEMP_FLSH

; fast flash
	movlw	D'01'			; 1/8
	xorwf	TEMP_FLSH,w
	btfss	STATUS,Z		; flash when equal to 01
	goto	SET_FLASH_DUTY
	goto	CLR_FLASH_DUTY

CHK_FLASH2
	btfss	FLASH,2			; fast flash flag
	goto	BY_INC_FS		; if bit 2 set is fast flash
	movf	SWITCH_S2,w		; fixed flash duty (mode 9 of variable duty mode 10) 
	xorlw	D'09'
	btfss	STATUS,Z
	goto	TEN_FLSH
; mode 9 flash fixed at 25% 4Hz
NINE_FLSH
	movf	FLASH_COUNT,w	; flash rate counter
	andlw	B'00000011'		; only the 2 bit count (65ms x 4) for fast flash rate
	movwf	TEMP_FLSH

; fast flash
	movlw	D'01'			; 1/4
	xorwf	TEMP_FLSH,w
	btfss	STATUS,Z		; flash when equal to 01
	goto	SET_FLASH_DUTY
	goto	CLR_FLASH_DUTY

TEN_FLSH
; fast flash
; SWTIME_MSTR has lower bytes
; if mode 10 vary duty with FLSH_DTY (LDR stored value) value
	btfss	FLASH,2			; tailight flash flag
	goto	BY_INC_FS
	movf	FLASH_COUNT,w	; flash rate counter
	andlw	B'00000011'		; only the 4 bit count (65ms x 4) for fast flash rate
	movwf	TEMP_FLSH
	rlf		TEMP_FLSH,f
	bcf		TEMP_FLSH,0		; remove ls bit
	btfsc	SWTIME_MSTR,7	; if set set Temp flsh 0
	bsf		TEMP_FLSH,0
; 3-bits select duty
	movf	TEMP_FLSH,w		; 3-bits for duty cycle 
	btfsc	STATUS,Z		; if zero add in 12.5% duty
	goto	CLR_FLASH_DUTY
	movf	FLSH_DTY,w		; LDR value
	sublw	D'16'			; if 16 or more add another 12.5% duty
	btfsc	STATUS,C
	goto	SET_FLASH_DUTY	; not over so off
	movf	TEMP_FLSH,w
	xorlw	D'01'			; if one
	btfsc	STATUS,Z		; if 1 drive on
	goto	CLR_FLASH_DUTY

	movf	FLSH_DTY,w		; LDR value
	sublw	D'32'			; if 32 or more add another 12.5% duty
	btfsc	STATUS,C
	goto	SET_FLASH_DUTY	; not over so off
	movf	TEMP_FLSH,w
	xorlw	D'02'			; if two
	btfsc	STATUS,Z		; if 1 drive on
	goto	CLR_FLASH_DUTY

	movf	FLSH_DTY,w		; LDR value
	sublw	D'64'			; if 64 or more add another 12.5% duty
	btfsc	STATUS,C
	goto	SET_FLASH_DUTY	; not over so off
	movf	TEMP_FLSH,w
	xorlw	D'03'			; if three
	btfsc	STATUS,Z		; if 1 drive on
	goto	CLR_FLASH_DUTY
	goto	SET_FLASH_DUTY
CLR_FLASH_DUTY
	bsf		FLASH_DUTY,0	; flash
	goto	BY_INC_FS
SET_FLASH_DUTY
	bcf		FLASH_DUTY,0
BY_INC_FS	

; monitor LED current and adjust PWM
	call	MEAS_CURRENT_I
; values in CURRENT_I and CURRENT_IL
; ramp PWM up until current is reached 8-bit=10 for 100mV at AN0
	call	SET_CURRENTS
	btfsc	CHRG_STRT,0
	call	CHARGE_CYC
	goto	ON_CYCLE

;:::::
; set current
SET_CURRENTS	 
	movf	ON_OFF,w
	btfss	STATUS,Z	; if off then PWM off
	goto	PWM_DRIVE

; off so pwm output off
	btfsc	CHRG_STRT,0	; charge started flag if cleared then clear LEDs
	goto	PWM_OFF_NOW
	bcf		PORTB,5		; red LED off
	bcf		PORTB,4		; green LED off
PWM_OFF_NOW
PWM_OFF_NOW1
	clrf	CCPR1L		; pwm bits off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	;
	bcf		FLICKER,0	; hysteresis flag for LDR dimming
	bcf		FLICKER,1
	return
PWM_OFF_NOW_FLASH
	clrf	CCPR1L		; pwm bits off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	;
	movlw	D'40'		; max flash brightness
	movf	SET_CURRENT,w	; current setting
	clrf	RAMP		; faster PWM ramp up flag
	return

PWM_DRIVE
; check modes
	movf	SWITCH_S2,w
	xorlw	D'1'		; if mode 1
	btfss	STATUS,Z
	goto	TEST_MODE11
	movlw	D'40'
	movwf	SET_CURRENT
	goto	CHECK_FLASHER1

TEST_MODE11
	movf	SWITCH_S2,w
	xorlw	D'11'		; if mode 11 (B)
	btfss	STATUS,Z
	goto	TEST_MODE12

; Full brightness when input power lost and light below threshold
	call	MEAS_INPUT_V ; get input
	btfss	FLICKER,0
	goto	LOW_CK1
	movf	INPUT_V,w
	sublw	D'99'
	btfss	STATUS,C	; if negative then >
	goto	PWM_OFF_NOW
	goto	CHK_LDR0
LOW_CK1
	movf	INPUT_V,w
	sublw	D'88'
	btfss	STATUS,C	; if negative then >
	goto	PWM_OFF_NOW
	bsf		FLICKER,0
CHK_LDR0
; check LDR level
	call	MEAS_LDR	; get LDR A/D value
	btfsc	FLICKER,1
	goto	FLICK_1
	movlw	D'102'		; trip point
	subwf	LDR,W
	btfsc	STATUS,C
	goto	PWM_OFF_NOW	;
	goto	SET_AT_MAX1
FLICK_1
	movlw	D'152'		; trip point
	subwf	LDR,W
	btfsc	STATUS,C	; either on or off
	goto	PWM_OFF_NOW
	goto	CHECK_FLASHER1
SET_AT_MAX1
	bsf		FLICKER,1
	goto	SET_AT_MAX

TEST_MODE12
	movf	SWITCH_S2,w
	xorlw	D'12'		; if mode 12 (C)
	btfss	STATUS,Z
	goto	TEST_MODE4
; Full brightness when input power lost

	call	MEAS_INPUT_V ; get input
	btfss	FLICKER,0
	goto	LOW_CK
	movf	INPUT_V,w
	sublw	D'99'
	btfss	STATUS,C	; if negative then >
	goto	PWM_OFF_NOW
	goto	ON_WO_FLASHER
LOW_CK
	movf	INPUT_V,w
	sublw	D'88'
	btfss	STATUS,C	; if negative then >
	goto	PWM_OFF_NOW
	bsf		FLICKER,0
	goto	SET_AT_MAX

TEST_MODE4
	movf	SWITCH_S2,w
	xorlw	D'04'		; if mode 4
	btfss	STATUS,Z
	goto	TEST_MODE5
; emergency flash
	btfsc	FLASH,0
	goto	SET_AT_MAX	; # CHECK_FLASHER1
	bcf		FLASH,2
	bsf		FLASH,1		; emergency flash
SET_AT_MAX
	movlw	D'40'		; 
SET_AT_W

	movwf	SET_CURRENT
	sublw	D'40'
	btfsc	STATUS,C	; if minus set at 40	
	goto	CHECK_FLASHER1
	movlw	D'40'
	goto	SET_AT_W

TEST_MODE5
	movf	SWITCH_S2,w
	xorlw	D'05'		; mode 5
	btfss	STATUS,Z
	goto	TEST_MODE9

	movf	FLASH,W		; if zero no flashing
	btfss	STATUS,Z
	goto	SET_AT_MAX

; monitor LDR 
	call	MEAS_LDR	; get LDR A/D value

; value in LDR
; vary brightness between 0 and 40 for set_current

	movlw	D'50'			; min value	 
	subwf	LDR,f			; LDR value
	btfss	STATUS,C		; if minus set to 40
	goto	SET_AT_MAX		; was set at max1

	rrf		LDR,f			; divide by 2
	rrf		LDR,w			; divide by 2

	andlw	B'00111111'
	btfss	FLICKER,0		; if set remove flickering at threshold
	goto	LOWER_LEV
	sublw	D'42'
	goto	H_L_LEV
LOWER_LEV
	sublw	D'40'
H_L_LEV
	btfss	STATUS,C
	goto	PWM_OFF_NOW1
	bsf		FLICKER,0
	goto	SET_AT_W		; set current at w register

TEST_MODE9
	movf	SWITCH_S2,w
	xorlw	D'09'		; mode 9
	btfss	STATUS,Z
	goto	TEST_MODE10
	btfsc	FLASH,0		; if emergency flasher set exit
	goto	SET_AT_MAX
	btfsc	FLASH,1		; if park flasher set exit
	goto	SET_AT_MAX
	call	MEAS_LDR	; get LDR A/D value

	btfss	FLASH,2		; if flash set 
	goto	NO_FLSH2
	movlw	D'102'		; trip point
	subwf	LDR,W
	btfss	STATUS,C
	clrf	FLASH
	goto	SET_AT_MAX
NO_FLSH2
	movlw	D'122'		; trip point
	subwf	LDR,W
	btfss	STATUS,C	; either full brightness or flash
	goto	NO_FLASH2
	bcf		FLASH,1
	bcf		FLASH,0
	bsf		FLASH,2		; flasher on
	movf	LDR,w
	movwf	FLSH_DTY	; for varying duty of flash
	goto	SET_AT_MAX
NO_FLASH2
	clrf	FLASH
	clrf	RAMP		; faster ramp up
	goto	SET_AT_MAX

TEST_MODE10	
	movf	SWITCH_S2,w
	xorlw	D'10'		; mode 10
	btfss	STATUS,Z
	goto	TEST_MODE6
	
	btfsc	FLASH,0		; if emergency flasher set exit
	goto	SET_AT_MAX
	btfsc	FLASH,1		; if park flasher set exit
	goto	SET_AT_MAX
	call	MEAS_LDR	; get LDR A/D value
	bcf		FLASH,1
	bcf		FLASH,0
	bsf		FLASH,2		; flasher on
	movf	LDR,w
	movwf	FLSH_DTY	; for varying duty of flash
	goto	SET_AT_MAX

; modes 6, 7 & 8 set to low current (31.25kHz) when Luxeon is off)

TEST_MODE6
	movf	SWITCH_S2,w
	xorlw	D'06'		; mode 6
	btfss	STATUS,Z
	goto	TEST_MODE7

	movf	FLASH,W		; if zero no flashing
	btfss	STATUS,Z
	goto	SET_AT_MAX_678

; monitor LDR 
	call	MEAS_LDR	; get LDR A/D value

; value in LDR
; vary brightness between 0 and 40 for set_current

	movlw	D'50'			; min value	 
	subwf	LDR,f			; LDR value
	btfss	STATUS,C		; if minus set to 40
	goto	SET_AT_MAX_678
	rrf		LDR,f			; divide by 2
	rrf		LDR,w			; divide by 2
	andlw	B'00111111'
	btfss	FLICKER,0		; if set remove flickering at threshold
	goto	LOWER_LEV6
	sublw	D'42'
	goto	H_L_LEV6
LOWER_LEV6
	sublw	D'40'
H_L_LEV6
	movwf	TEMP67
	btfss	STATUS,C
	goto	PWM_OFF_NOW_678
	bsf		FLICKER,0
	goto	SET_AT_W_678		; set current at w register

PWM_OFF_NOW_678
	clrf	SIX_7_8			; off for modes 6,7&8
	call	SET31.25		; low power rate
	goto	PWM_OFF_NOW1
SET_AT_W_678
	movwf	TEMP67			; keep value
	bsf		SIX_7_8,0		; Luxeon on flag
	call	SET_8MHz		; ensure at 8MHz
	movf	TEMP67,w		; return w
	goto	SET_AT_W
SET_AT_MAX_678
	bsf		SIX_7_8,0		; Luxeon on flag
	call	SET_8MHz		; ensure at 8MHz
	goto	SET_AT_MAX

TEST_MODE7
	movf	SWITCH_S2,w
	xorlw	D'07'		; mode 7
	btfss	STATUS,Z
	goto	TEST_MODE8

	movf	FLASH,W		; if zero no flashing
	btfss	STATUS,Z
	goto	SET_AT_MAX_678

; monitor LDR 
	call	MEAS_LDR	; get LDR A/D value

; value in LDR
; vary brightness between 0 and 40 for set_current

	movlw	D'50'			; min value	 
	subwf	LDR,f			; LDR value
	btfss	STATUS,C		; if minus set to 40
	goto	SET_GARDEN_TIMER; set timer at ~6hrs when set on

	rrf		LDR,f			; divide by 2
	rrf		LDR,w			; divide by 2

	andlw	B'00111111'
	btfss	FLICKER,0		; if set remove flickering at threshold
	goto	LOWER_LEV7
	sublw	D'42'
	goto	H_L_LEV7
LOWER_LEV7
	sublw	D'40'
H_L_LEV7
	movwf	TEMP67			; keep value
	btfss	STATUS,C
	goto	GARDEN_CLEAR
	bsf		FLICKER,0
	btfss	GARDEN_TIME,0	; if set check timer
	goto	SET_AT_W_678	; set current at w register
	movf	GCOUNTER4,w		; ms byte of garden timer of cleared then set to off
	btfsc	STATUS,Z
	goto	GARDEN_CLEAR1	; off after 6 hrs
	movf	TEMP67,w		; restore value
	goto	SET_AT_W_678	; set current at w register

; when off clear timers and flag
GARDEN_CLEAR
	bcf		GARDEN_TIME,0	; clear when stopped
GARDEN_CLEAR1
	clrf	GCOUNTER4	; all cleared ms byte of 1,2,3,4
	clrf	GCOUNTER2	; clear ls byte counters
	clrf	GCOUNTER3
	goto	PWM_OFF_NOW_678

SET_GARDEN_TIMER
	btfss	GARDEN_TIME,0	; if set check timer
	goto	INSERT_VALUE
	movf	GCOUNTER4,w		; ms byte of garden timer if cleared then set to off
	btfsc	STATUS,Z
	goto	GARDEN_CLEAR1	; off after 6 hrs
	movf	TEMP67,w		; get w value for current
	goto	SET_AT_W_678	; set current at w register
INSERT_VALUE
	movlw	D'5'			; 6 hours
	movwf	GCOUNTER4		; ms byte of 1,2,3,4
	clrf	GCOUNTER2		; clear ls byte counters
	clrf	GCOUNTER3

; testfor timeout
;	movlw	D'1'
;	movwf	GCOUNTER4
;	movwf	GCOUNTER3
;	movlw	D'50'			; ~3s
;	movwf	GCOUNTER2
; end of test
	
	bsf		GARDEN_TIME,0	; set when started			
	goto	SET_AT_MAX_678

TEST_MODE8
	movf	SWITCH_S2,w
	xorlw	D'08'		; if mode 8
	btfss	STATUS,Z
	goto	CHECK_FLASHER1

; on/off with LDR

; check LDR level
	call	MEAS_LDR	; get LDR A/D value
	btfsc	FLICKER,0
	goto	FLICK_8
	movlw	D'102'		; trip point
	subwf	LDR,W
	btfsc	STATUS,C
	goto	PWM_OFF_NOW_678X
	goto	SET_AT_MAX8
FLICK_8
	movlw	D'122'		; trip point
	subwf	LDR,W
	btfsc	STATUS,C	; either on or off
	goto	PWM_OFF_NOW_678X

SET_AT_MAX8
	bsf		FLICKER,0
	btfss	FLASH_X,0	; if set emergency flash
	goto	STANDARD_F
	bcf		FLASH,1
	bcf		FLASH,2
	bsf		FLASH,0		;  flash
	goto	SET_AT_MAX_678X
STANDARD_F
	bcf		FLASH,0
	bcf		FLASH,2
	bsf		FLASH,1		;  flash
	goto	SET_AT_MAX_678X
PWM_OFF_NOW_678X
	bsf		EIGHT_OFF,0	; ensure off
	goto	PWM_OFF_NOW_678
SET_AT_MAX_678X
	clrf	EIGHT_OFF
	goto	SET_AT_MAX_678

; check flasher
CHECK_FLASHER1
	movf	FLASH,W		; if zero no flashing
	btfsc	STATUS,Z
	goto	LOW_BATTRY
	movlw	D'40'		; set at max for flash
	movwf	SET_CURRENT
FLSH_DTYX		
	btfss	FLASH_DUTY,0	; if set then on, clear off
	goto	PWM_OFF_NOW_FLASH
	goto	ON_WI_FLASHER
LOW_BATTRY
	movf	LOW_FLASH,W		; low voltage flash flag if zero no flashing
	btfsc	STATUS,Z
	goto	ON_WO_FLASHER
	goto	FLSH_DTYX

ON_WI_FLASHER			; on with flashing

ON_WO_FLASHER
 	bcf		PIR1,1		; clear timer2 to pr2 match flag	
; get averaged current
	movf	CURRENT_I,w
	addwf	CURRENT_AVG,f
	btfsc	STATUS,C	; if carry set overcurrent (over 17 average)

	goto	STOP_PWM
	incf	AVG_COUNT,f
	movf	AVG_COUNT,w
	xorlw	D'15'		; 15 average currents
	btfss	STATUS,Z	; when 15 clear counter
	goto	SET_10BITS
	clrf	CURRENT_AVG	; total over 15 counts
	clrf	AVG_COUNT

; set current readings for 10-bit ignoring ms two bits
SET_10BITS
	rlf		CURRENT_I,f	; left shift
	rlf		CURRENT_I,f
	bcf		CURRENT_I,0	; ls bits clear
	bcf		CURRENT_I,1
	btfsc	CURRENT_IL,6; if 0 set set 
	bsf		CURRENT_I,0	; set
	btfsc	CURRENT_IL,7 ; 
	bsf		CURRENT_I,1	
; Average
; use average over 8 measurements when "Dimming" is clear
; avg_cnt is the current measurements over past 8 counts

	movf	AVG_CNT7,w		; shift along
	movwf	AVG_CNT8
	movf	AVG_CNT6,w		; shift along
	movwf	AVG_CNT7
	movf	AVG_CNT5,w		; shift along
	movwf	AVG_CNT6
	movf	AVG_CNT4,w		; shift along
	movwf	AVG_CNT5
	movf	AVG_CNT3,w		; shift along
	movwf	AVG_CNT4
	movf	AVG_CNT2,w		; shift along
	movwf	AVG_CNT3
	movf	AVG_CNT1,w		; shift along
	movwf	AVG_CNT2
	movf	CURRENT_I,w		; shift along
	movwf	AVG_CNT1
	movwf	SMOOTH_CNT1

; Add up currents into SMOOTH_CNT1,1
	clrf	SMOOTH_CNT0		; ms byte
	movf	AVG_CNT2,w
	call	ADD_AVG
	movf	AVG_CNT3,w
	call	ADD_AVG
	movf	AVG_CNT4,w
	call	ADD_AVG
	movf	AVG_CNT5,w
	call	ADD_AVG
	movf	AVG_CNT6,w
	call	ADD_AVG
	movf	AVG_CNT7,w
	call	ADD_AVG
	movf	AVG_CNT8,w
	call	ADD_AVG
; divide by 8
	bcf		STATUS,C
	rrf		SMOOTH_CNT0,f
	rrf		SMOOTH_CNT1,f	; /2
	rrf		SMOOTH_CNT0,f
	rrf		SMOOTH_CNT1,f	; /4
	rrf		SMOOTH_CNT0,f
	rrf		SMOOTH_CNT1,f	; /8
	goto	REPLACE_I
ADD_AVG
	addwf	SMOOTH_CNT1,f
	btfsc	STATUS,C		; when set increase ms byte
	incf	SMOOTH_CNT0,f
	return
REPLACE_I
; place into current_I if ready
	movf	SMOOTH_CNT1,w		; averaged value
	btfss	DIMMING,0			; if clear
	movwf	CURRENT_I


; Check SET_CURRENT value make sure it is not 0

	movf	SET_CURRENT,w	; current setting requirement
	btfsc	STATUS,Z		; if zero set to 1
	movlw	D'1'			; set to 1
	movwf	SET_CURRENT
; Monitor battery. If flat set brightness down
	call	MEAS_BATT_V		; get battery voltage
	movf	BATT_V,w
	sublw	D'130'			; equivalent to 1V per cell
	btfss	STATUS,C
	goto	HIGHER_BATT?
; Set current to max of 20 and flash
	movf	SET_CURRENT,w	; current setting
	sublw	D'20'			; if above 20 set to 20
	btfsc	STATUS,C
	goto	NO_CURRENT_CHANGE?
	movlw	D'20'
	movwf	SET_CURRENT
NO_CURRENT_CHANGE?
	bsf		LOW_FLASH,0		; low flash flag
	goto	CURRENT_CHANGE?
HIGHER_BATT?
	bcf		LOW_FLASH,0
	movf	BATT_V,w
	sublw	D'137'			; equivalent to 1.05V per cell
	btfss	STATUS,C
	goto	CURRENT_CHANGE?
	movf	SET_CURRENT,w	; current setting
	sublw	D'20'			; if above 20, set to 20
	btfsc	STATUS,C
	goto	CURRENT_CHANGE?
	movlw	D'20'
	movwf	SET_CURRENT
	
CURRENT_CHANGE?
	movf	SET_CURRENT,w; set current value maximum is 
;(10=100mv for CURRENT_I when shifted left and 10bits added=40) 
	subwf	CURRENT_I,W
CURRENT_COMP
	btfsc	STATUS,C	; if carry is zero keep increasing PWM
	goto	BY_CCINC

CC_INC
; fix at max level	
	movf	CCPR1L,w	; ms byte of PWM
	sublw	D'180'		; limit 
	btfsc	STATUS,C	
	goto	INC_CCP1
	movlw	D'181'
	movwf	CCPR1L

; *********************************
; if current is zero with PWM over 179 turn off
INC_CCP
	movf	CCPR1L,w	; ms byte of PWM
	sublw	D'179'		; limit 
	btfsc	STATUS,C	
	goto	INC_CCP1
	movf	CURRENT_I,w
	btfss	STATUS,Z	; 
	goto	TEST1
SWITCH_IT_OFF
; if zero switch off
	clrf	CCPR1L		; pwm bits off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	; 
	clrf	RAMP		; for faster PWM ramp up
	clrf	FLASH		; flashing off	
	clrf	ON_OFF		; switch to off mode
	clrf	SW_FLG		; switch off
	bcf		PORTB,5		; red LED off
	bcf		PORTB,4		; green LED off	
	clrf	SW_1SET		; switch timers
	clrf	SW_2SET
	clrf	FLASH_X		; type of flash
	clrf	CURRENT_AVG	; total over 15 counts
	clrf	AVG_COUNT
	clrf	DIMMING		; dimming flag
	return
TEST1
	xorlw	D'1'		; if a 1
	btfsc	STATUS,Z
	goto	SWITCH_IT_OFF

; ****************************

; increase ten bit
INC_CCP1
	movf	FLASH,W		; check if flash mode
	btfss	STATUS,Z	; if flash bypass 10-bit PWM
	goto	INCREASE_5
	btfsc	DIMMING,0	; dimming flag
	goto	INCREASE_8
	btfss	RAMP,0		; if starting up ramp at 8-bit
	goto	INCREASE_8	; faster ramp
; redo current compare
	decfsz	SET_CURRENT,w
	goto	CK_AGN1
	goto	BIT_10_GO
CK_AGN1
	subwf	CURRENT_I,w
	btfsc	STATUS,C
	goto	PWM_KEEP1
BIT_10_GO
	clrf	TEN_BIT
	btfsc	CCP1CON,5	; ten bit PWM ms bit
	bsf		TEN_BIT,1
	btfsc	CCP1CON,4
	bsf		TEN_BIT,0
	incf	TEN_BIT,f

; replace into CCP1CON *
WAIT_MATCH1				; wait for timer match
	btfss	PIR1,1
	goto	WAIT_MATCH1	
	btfss	TEN_BIT,0	; if set set bit 4 in CCP1CON
	goto	CLR_4
	bsf		CCP1CON,4	; set
	goto	CON_5
CLR_4
	bcf		CCP1CON,4	; clear
CON_5
	btfss	TEN_BIT,1	; if set set bit 5 in CCP1CON
	goto	CLR_5 
	bsf		CCP1CON,5	; set
	goto	TEN_BIT_2
CLR_5
	bcf		CCP1CON,5	; clear

TEN_BIT_2
	btfsc	TEN_BIT,2	; if set add to CCPR1L
INCREASE_8	
	incf	CCPR1L,f	; increase 8-bit PWM
	return

BY_CCINC
	movf	SET_CURRENT,w		; set current
	xorwf	CURRENT_I,W
BY_INC_LP
	btfsc	STATUS,Z	; if zero keep current PWM
	goto	PWM_KEEP
CC_DEC

	decf	CCPR1L,W
	xorlw	0xFF		; if passed beyond zero bypass decrement
	btfsc	STATUS,Z
	return
DEC_PWM_10
	
	movf	CCPR1L,w
	btfsc	STATUS,Z
	return				; if PWM zero do not decrement
	movf	FLASH,W		; check if flash mode
	btfss	STATUS,Z	; if flash bypass 10-bit PWM
	goto	DECREASE_8
	btfsc	DIMMING,0
	goto	DECREASE_8
; redo measure	
	incf	SET_CURRENT,w
	subwf	CURRENT_I,w
	btfss	STATUS,C
	goto	PWM_KEEP1

	clrf	TEN_BIT
	btfsc	CCP1CON,5	; ten bit PWM ms bit
	bsf		TEN_BIT,1
	btfsc	CCP1CON,4
	bsf		TEN_BIT,0
	decf	TEN_BIT,f

; replace into CCP1CON *
WAIT_MATCH2				; wait for timer match
	btfss	PIR1,1
	goto	WAIT_MATCH2
	btfss	TEN_BIT,0	; if set set bit 4 in CCP1CON
	goto	CLR_4_DEC
	bsf		CCP1CON,4	; set
	goto	CON_5_DEC
CLR_4_DEC
	bcf		CCP1CON,4	; clear
CON_5_DEC
	btfss	TEN_BIT,1	; if set set bit 5 in CCP1CON
	goto	CLR_5_DEC 
	bsf		CCP1CON,5	; set
	goto	TEN_BIT_7
CLR_5_DEC
	bcf		CCP1CON,5	; clear

TEN_BIT_7
	btfsc	TEN_BIT,7	; if set decrease CCPR1L	
DECREASE_8
	decf	CCPR1L,f
	return

PWM_KEEP
; update storage of PWM. Value is correct.
	clrf	DIMMING		; when equal use 10-BIT
PWM_KEEP1
	movf	SW_3SET,w
	btfsc	STATUS,Z	; if timer zero can set RAMP,O
	bsf		RAMP,0		; set when equal or larger
	return
STOP_PWM
	clrf	CCPR1L		; pwm bits off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	; 
	clrf	CURRENT_AVG	; total over 15 counts
	clrf	AVG_COUNT
	return
; flash ramp up fast
INCREASE_5	
	incf	CCPR1L,f	; increase 8-bit PWM
	movf	CCPR1L,w
	sublw	D'180'		; limit 
	btfsc	STATUS,C	
	goto	INC_AGN1
	movlw	D'181'
	movwf	CCPR1L
	return
	btfsc	RAMP,0		; when set only increase at 1 bit at a time
	return
INC_AGN1
	incf	CCPR1L,f	; increase 8-bit PWM
	movf	CCPR1L,w
	sublw	D'180'		; limit 
	btfsc	STATUS,C	
	goto	INC_AGN2
	movlw	D'181'
	movwf	CCPR1L
	return
INC_AGN2
	incf	CCPR1L,f	; increase 8-bit PWM
	movf	CCPR1L,w
	sublw	D'180'		; limit 
	btfsc	STATUS,C	
	goto	INC_AGN3
	movlw	D'181'
	movwf	CCPR1L
	return
INC_AGN3
	incf	CCPR1L,f	; increase 8-bit PWM
	movf	CCPR1L,w
	sublw	D'180'		; limit 
	btfsc	STATUS,C	
	return
	movlw	D'181'
	movwf	CCPR1L
	return

;:::::;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 
; subroutines

; battery charging 

CHARGE_CYC

; Check if flashing is off
	movf	FLASH,w			; if flashing mode check if off
	btfsc	STATUS,Z
	goto	DO_CHARG_CYC	; flash off so can run charge cycle
	btfsc	FLASH_DUTY,0
	return
; monitor Thermistor and battery voltage for over/under temperture and over voltage
DO_CHARG_CYC
	call	MEAS_THERM	; get Thermistor value value in THERM
	movf	THERM,w		; thermistor value
	sublw	D'200'		; maximum temperaure
	btfss	STATUS,C
	goto	SET_AT_100mA; trickle when max temp reached
	movf	THERM,w		; thermistor value
	sublw	D'58'		; minimum temperaure (0 deg C)
	btfss	STATUS,C	; 
	goto	CHK_BATT_LEV	
; over temperature/voltage

SWITCH_OFF
OVR_RATING
	clrf	LOW_TME  	; RA6 low
	bcf		PORTA,6		; low output
	clrf	CHRG_OUT	; charge status
	clrf	CHRG_STRT	; charge started cleared
	return

CHK_BATT_LEV
	movf	CHRG_OUT,w	; charger status
	btfss	STATUS,Z	; if zero full current charge so monitor temperature and Voltage 
	goto	MEAS_IB

CHARGER_OK
	call	MEAS_THERM	; get Thermistor value value in THERM
	movf	THERM_STORE,w		; original thermister value
	subwf	THERM,w		; check if temperature has risen
	btfss	STATUS,C
	goto	MEAS_IB
	sublw	D'55'		; temperaure has risen by 55 over initial charge temperature
	btfsc	STATUS,C
	goto	MEAS_IB
MODE_CHRG
	movf	CHRG_OUT,w	; if zero then set at top up
	btfsc	STATUS,Z	
	goto	TOP_TEMP
	movf	CHRG_OUT,w
	xorlw	D'01'
	btfsc	STATUS,Z	; if 1 then set at trickle
	goto	SET_AT_100mA
	goto	MEAS_IB

; temperature detect for current charge so set top up 
; increase CHRG_OUT after full charge rate finished for top up charge
TOP_TEMP
	movlw	D'1'	
	movwf	CHRG_OUT	; top up
	
; reload counters for 1 hour approx	
	movlw	H'01'		; ms byte
	movwf	COUNTER4
	clrf	COUNTER3
	clrf	COUNTER2
	goto	MEAS_IB
SET_AT_100mA
	movlw	D'2'		; trickle
	movwf	CHRG_OUT	; trickle

; measure input and battery voltage
MEAS_IB
	movf	CHARGE_LOOP,w
	btfsc	STATUS,Z
	goto	RENEW_CHRG
	decfsz	CHARGE_LOOP,f
	return
RENEW_CHRG
	movlw	D'10'		; 
	movwf	CHARGE_LOOP
	movlw	D'10'		; check periodically 
	movwf	CHRG_COUNT	; timer
; input voltage
	call	MEAS_INPUT_V_I	; voltage after current sense
;	call	MEAS_INPUT_V ; get input
	call	MEAS_BATT_V
; check if input voltage is off
	movf	INPUT_V,w
	sublw	D'88'
	btfsc	STATUS,C	; if negative then > 
	goto	SWITCH_OFF	; 

	movf	INPUT_V,w	; input value
	sublw	D'198'		; maximum voltage equivalent to 18.6V at input
	btfss	STATUS,C	; 
	goto	OVR_RATING
; when in maintenance or top up charge if battery V drops start full charge
	movf	CHRG_OUT,f
	btfsc	STATUS,Z	; if zero bypass
	goto	CALC_V
	movf	BATT_V,w
	sublw	D'150' 		; 1.15V per cell
	btfss	STATUS,C	; if lower than this recharge 
	goto	CALC_V			

; restart full charge
; charge value 0-40, set timeout according to charge

	rrf		CHARGE_I,w	; /2
	movwf	TEMP_CHRG	; temp
	rrf		TEMP_CHRG,f	; /4
	bcf		TEMP_CHRG,7
	bcf		TEMP_CHRG,6	; clear ms bits if set

; alter according to input voltage
	call	MEAS_INPUT_V ; get input
	
; if >12V then reduce charge time
	movf	INPUT_V,w
	sublw	D'131'		; 12V at input
	btfss	STATUS,C	; if negative then > 
	goto	ABVE_12		; more than 12V 
	movf	TEMP_CHRG,w
	call	CHRG_TIME
 	goto	STOCNT
ABVE_12
	movf	INPUT_V,w
	sublw	D'164'		; 15V at input
	btfss	STATUS,C	; if negative then > 
	goto	ABVE_15		; more than 15V 
	movf	TEMP_CHRG,w
	call	CHRG_TIME2
 	goto	STOCNT
ABVE_15
	movf	TEMP_CHRG,w
	call	CHRG_TIME3	; less time
STOCNT
	movwf	COUNTER4	; ms byte of 2,3,4
	clrf	COUNTER3	; clear ls byte counters
	clrf	COUNTER2
	clrf	CHRG_OUT	; charge status to full rate
	call	MEAS_THERM	; get Thermistor value value in THERM
	movf	THERM,w		; thermistor value
	movwf	THERM_STORE
	bsf		CHRG_STRT,0	; start flag set 

; full charge current calculation
;
; Vin divider is 0.1065 

; subtract loaded input voltage (via current sense) from input (AARGB0,1 - BARGB0,1 = BARGB0,1)
CALC_V

	movf	INPUT_V,w	; input voltage
	movwf	AARGB0		; ms byte
	movf	INPUT_VL,w
	movwf	AARGB1

	movf	INPUT_V_I,w	; loaded input voltage
	movwf	BARGB0		; ms byte
	movf	INPUT_VL_I,w
	movwf	BARGB1

	movf	BARGB0,w	; ms batt volts
	subwf	AARGB0,w	; subtract input ms byte
	movwf	BARGB0
	movf	BARGB1,w	; mid bytes
	subwf	AARGB1,w
	movwf	BARGB1
	btfss	STATUS,C	; if carry reduce ms byte
	decf	BARGB0,f
;
; if BARGB0 bit 7 set,current too low

	btfss	BARGB0,7
	goto	ROLL
	clrf	BARGB0
	goto	ROLL_BY
ROLL
	rlf		BARGB1,f
	rlf		BARGB0,f	; shift left to move current to match CHARGE_I
	rlf		BARGB1,f
	rlf		BARGB0,f
ROLL_BY
; determine charge mode (full, top up or trickle and compare)if full compare with CHARGE_I, 
; if Top up use half current unless this is below 100mA (4)

	movf	CHRG_OUT,w	; charge mode
	btfss	STATUS,Z	; if zero the full charge
	goto	NXT_MODES
	movf	CHARGE_I,w	; charge value
	movwf	CHRGE_ITEMP	; compare value
	goto	CHRG_CYC
NXT_MODES
	movf	CHRG_OUT,w
	xorlw	D'01'		; top up
	btfss	STATUS,Z	; if 1 then check values
	goto	SET_4
; check charge current setting. Set at half full current
	movf	CHARGE_I,w
	movwf	CHRGE_ITEMP	; new charge level for top up
	bcf		STATUS,C	; carry clear
	rrf		CHRGE_ITEMP,f ; half value
	movf	CHRGE_ITEMP,w
	sublw	D'04'		; if positive set at 4
	btfss	STATUS,C
	goto	CHRG_CYC
SET_4
	movlw	D'04'
	movwf	CHRGE_ITEMP
	goto	CHRG_CYC

CHRG_CYC
	movf	BARGB0,w	; 10-bit current
	subwf	CHRGE_ITEMP,W
	btfsc	STATUS,C	; if negative decrease charge PWM
	goto	INC_CHARG_PWM

; decrease charge PWM 
	movf	LOW_TME,w		; pwm drive value
	btfsc	STATUS,Z		; if zero stop
	return
; if more than twice charge current set to off
; over current protection
	decf	LOW_TME,F
	bcf		STATUS,C
	rrf		BARGB0,w	; /2
	subwf	CHRGE_ITEMP,W
	btfsc	STATUS,C
	return
	clrf	LOW_TME		; off when over current
	return
;
; increase charge PWM
INC_CHARG_PWM
	btfsc	STATUS,Z		; if zero no change
	return
	incf	LOW_TME,w
	sublw	D'200'			; limit value
	btfss	STATUS,C
	goto	STOP_AT200
	incf	LOW_TME,F		; increase
	return
STOP_AT200
	movlw	D'200'
	movwf	LOW_TME
	return
CHARGE_OFF
	bcf		PORTA,6 		; charge off
	clrf	LOW_TME
	return

; Measure input voltage for charger connected
MEAS_INPUT_V
	bsf		PORTA,7			; start reference
	movlw	B'11000111'		; mask bits
	andwf	ADCON0,f		; address zero
	bsf		ADCON0,4		; set AN2
	bsf		MEAS_FLAG,0		; set so does not change in interrupt

	bsf		PORTB,4			; green LED for input volts
	bcf		PORTB,5

	call	ACQUIRE_AD
	btfss	B_STORE,4		; b_store set in interrupt
	bcf		PORTB,4			; clear if was clear
	btfsc	B_STORE,5
	bsf		PORTB,5			; set if was set
	bcf		MEAS_FLAG,0		; set so does not change in interrupt

	movf	ADRESH,w
	movwf	INPUT_V
	bsf		STATUS,RP0		; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	INPUT_VL
	return

; Measure input voltage for charger connected (after current sense Resistor)
MEAS_INPUT_V_I
	bsf		PORTA,7			; start reference
	movlw	B'11000111'		; mask bits
	andwf	ADCON0,f		; address zero
	bsf		ADCON0,4		; set AN2
	bsf		MEAS_FLAG,0		; set so does not change in interrupt
	
	bcf		PORTB,4			; green LED for input volts
	bsf		PORTB,5

	call	ACQUIRE_AD
	btfsc	B_STORE,4
	bsf		PORTB,4			; set if was set
	btfss	B_STORE,5
	bcf		PORTB,5			; clear if was clear
	bcf		MEAS_FLAG,0		; set so does not change in interrupt
	movf	ADRESH,w
	movwf	INPUT_V_I
	bsf		STATUS,RP0		; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	INPUT_VL_I
	return

; measure battery voltage
MEAS_BATT_V
	bsf		PORTA,7			; start reference
	movlw	B'11000111'		; mask bits
	andwf	ADCON0,f		; address zero
	bsf		ADCON0,3		; set AN1
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	BATT_V
	bsf		STATUS,RP0		; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	BATT_VL
	return

; measure LED current
MEAS_CURRENT_I
	bsf		PORTA,7			; start reference
	movlw	B'11000111'		; mask bits
	andwf	ADCON0,f		; address zero
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	CURRENT_I
	bsf		STATUS,RP0		; select memory bank 1
	movf	ADRESL,w		; ls bits
	bcf		STATUS,RP0		; select memory bank 0
	movwf	CURRENT_IL		; ls bits 
	return
; measure LDR
MEAS_LDR
	bsf		PORTA,7			; start reference
	movlw	D'2'
	call	DELAYX			; time for input to settle 
	movlw	B'11000111'		; mask bits
	andwf	ADCON0,f		; address zero
	bsf		ADCON0,5		; set AN6
	bsf		ADCON0,4
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	LDR
	return
; measure Thermistor
MEAS_THERM
	bsf		PORTA,7			; start reference
	movlw	D'2'
	call	DELAYX			; time for input to settle 
	movlw	B'11000111'		; mask bits
	andwf	ADCON0,f		; address zero
	bsf		ADCON0,3		; set AN5
	bsf		ADCON0,5
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	THERM
	return
; subroutine to wait for conversion
ACQUIRE_AD
; wait for acquisition period
	btfss	CLOCK_RATE,0	; if clear bypass wait
	goto	BY_WAITING
	movlw	D'40'
	movwf	ACQ_TIME		; acquisition time
REDUCE_ACQ
	decfsz	ACQ_TIME,f
	goto	REDUCE_ACQ
BY_WAITING
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	
	return
; end subroutine

MON_S2	
 ; monitor S2 settings

	bsf		PORTA,7		; enable common pin on S2
	clrf	SWITCH_W2	; start at 0
	btfsc	PORTA,5		; if set then set bit 0
	bsf		SWITCH_W2,0	; bit 0 set	
	btfsc	PORTB,1		; if set then set bit 1
	bsf		SWITCH_W2,1	; bit 1 set
	btfsc	PORTA,4		; if set then set bit 2
	bsf		SWITCH_W2,2	; bit 2 set
	btfsc	PORTB,2		; if set then set bit 3
	bsf		SWITCH_W2,3	; bit 3 set
; 0 is always off, D & E is reset microcontroller, F is test (setup)
	movf	SWITCH_W2,w	; check value
	movwf	SWITCH_S2	
	btfsc	STATUS,Z	; if zero then keep off
	goto	ALWAYS_OFF
	movf	SWITCH_S2,w
	xorlw	H'0E'		; 14 (E)
	btfsc	STATUS,Z
	goto	RESTART1
	movf	SWITCH_S2,w
	xorlw	H'0D'		; 13 (D)
	btfsc	STATUS,Z
	goto	RESTART2
	movf	SWITCH_S2,w
	xorlw	H'0F'		; 15 (F)
	btfsc	STATUS,Z
	goto	RESET_VAL
	bsf		INTCON,GIE	; set global interrupt enable 
	movf	ON_OFF,w	; if off clear portA,7
	btfsc	STATUS,Z
	bcf		PORTA,7
	return
ALWAYS_OFF
;	bcf		INTCON,GIE	; clear global interrupt enable 
	bcf		PORTA,7
	clrf	ON_OFF		; off
	return
RESTART2
	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf		PORTB,5		; red LED on
	movlw	D'05'
	call	DELAYX
; reread switch
	clrf	SWITCH_W2	; start at 0
	btfsc	PORTA,5		; if set then set bit 0
	bsf		SWITCH_W2,0	; bit 0 set	
	btfsc	PORTB,1		; if set then set bit 1
	bsf		SWITCH_W2,1	; bit 1 set
	btfsc	PORTA,4		; if set then set bit 2
	bsf		SWITCH_W2,2	; bit 2 set
	btfsc	PORTB,2		; if set then set bit 3
	bsf		SWITCH_W2,3	; bit 3 set
; D is reset
	bcf		PORTB,5		; red LED off
	movf	SWITCH_W2,w	; check value
	xorlw	H'0D'		; 
	btfsc	STATUS,Z	; if D then switch still selected					
	goto	RESTART
	goto	RET1
RESTART1
	bcf		INTCON,GIE	; clear global interrupt enable 
	clrf	FREQ_CHNG_FG
	bsf		PORTB,5		; red LED on
	movlw	D'05'
	call	DELAYX
; check if switch still set at E
; reread switch
	clrf	SWITCH_W2	; start at 0
	btfsc	PORTA,5		; if set then set bit 0
	bsf		SWITCH_W2,0	; bit 0 set	
	btfsc	PORTB,1		; if set then set bit 1
	bsf		SWITCH_W2,1	; bit 1 set
	btfsc	PORTA,4		; if set then set bit 2
	bsf		SWITCH_W2,2	; bit 2 set
	btfsc	PORTB,2		; if set then set bit 3
	bsf		SWITCH_W2,3	; bit 3 set
; E is change frequency
	movf	SWITCH_W2,w	; check value
	xorlw	H'0E'		; 
	btfsc	STATUS,Z	; if E then stay in loop					
	goto	RES1
RET1
	bcf		PORTB,5		; red LED off
	bsf		INTCON,GIE	; set global interrupt enable 
	return
RES1
	btfsc	FREQ_CHNG_FG,0	; is already done bypass
	goto	RET1
	bsf		FREQ_CHNG_FG,0
	movlw	EEPROM1		; eeprom address
	call	EEREAD		; sets eeadr	
	incf	LUX_FREQ,f	; new value
	movf	LUX_FREQ,w	; frequency
	call	EWRITE		; store new value
	bcf		PORTB,5		; red LED off
	movlw	D'20'
	call	DELAYX
	goto	RET1
; reset values
RESET_VAL
	
	bcf		INTCON,GIE	; clear global interrupt enable 
	movlw	D'05'
	call	DELAYX
; reread switch
	clrf	SWITCH_W2	; start at 0
	btfsc	PORTA,5		; if set then set bit 0
	bsf		SWITCH_W2,0	; bit 0 set	
	btfsc	PORTB,1		; if set then set bit 1
	bsf		SWITCH_W2,1	; bit 1 set
	btfsc	PORTA,4		; if set then set bit 2
	bsf		SWITCH_W2,2	; bit 2 set
	btfsc	PORTB,2		; if set then set bit 3
	bsf		SWITCH_W2,3	; bit 3 set
; F is setup
	movf	SWITCH_W2,w	; check value
	xorlw	H'0F'		; 
	btfsc	STATUS,Z	; if F then switch still selected					
	goto	SET_UP
	goto	RET1
SET_UP
	bsf		PORTA,7		; enable common pin on S2
	movlw	D'40'		; Luxeon current setting
	movwf	SET_CURRENT
	clrf	FLASH		; flashing off
	bcf		ON_OFF,0
	bcf		PORTA,6		; charge off
	clrf	SW_HOLD		; switch hold flag

; drive LED few/seconds with 1 flash per every 50mA flash value on indicator LED
FLASH_I	
	bcf		PORTB,5		; red LED off
	movf	CHARGE_I,w	; charge current
	movwf	I_TEMP		; working register
REFLASH
	bsf		PORTB,4		; set LED on
	call	CURRENT_SW	; check for changes
	movlw	D'03'
	call	DELAYX

	bcf		PORTB,4		; LED off
	movlw	D'05'
	call	DELAYX
	movf	I_TEMP,w
	sublw	D'40'
	btfss	STATUS,C
	goto	END_OF_FLASH
DEC_I
	decfsz	I_TEMP,F	; reduce to zero
	goto	X_REFLASH
	goto	END_OF_FLASH
X_REFLASH
	decfsz	I_TEMP,F	; reduce to zero
	goto	REFLASH
END_OF_FLASH
	movlw	D'15'
	call	DELAYX

; reread switch
	bsf		PORTA,7		; enable common pin on S2
	clrf	SWITCH_W2	; start at 0
	btfsc	PORTA,5		; if set then set bit 0
	bsf		SWITCH_W2,0	; bit 0 set	
	btfsc	PORTB,1		; if set then set bit 1
	bsf		SWITCH_W2,1	; bit 1 set
	btfsc	PORTA,4		; if set then set bit 2
	bsf		SWITCH_W2,2	; bit 2 set
	btfsc	PORTB,2		; if set then set bit 3
	bsf		SWITCH_W2,3	; bit 3 set
; F is test (setup)
	movf	SWITCH_W2,w	; check value
	xorlw	H'0F'		; 
	btfsc	STATUS,Z	; if F then stay in loop					
	goto	FLASH_I
	bsf		INTCON,GIE	; set global interrupt enable 
	return
; if S1 closed increase the charge current value (20 to 1 range)
CURRENT_SW
	btfsc	PORTB,0		; if closed increase current value
	goto	SWITCH_CLOSED
	clrf	SW_HOLD		; switch hold flag off when released
	return
SWITCH_CLOSED
	btfss	SW_HOLD,0	; if clear then clear Charge
	clrf	CHARGE_I	; set at start if switch first pressed
	bsf		SW_HOLD,0	; stop reset to 1 if switch held closed 
	incf	CHARGE_I,w
	sublw	D'40'		; set at 40 max
	btfsc	STATUS,C	; if negative set at 40
	goto	INC_STORE
SET_40_LEV
	movlw	D'40'
	movwf	CHARGE_I	; new value	
	goto	STORE_I
INC_STORE
	incf	CHARGE_I,f	; increase
	incf	CHARGE_I,w
	sublw	D'40'		; set at 40 max
	btfss	STATUS,C	; if negative set at 40
	goto	SET_40_LEV
	incf	CHARGE_I,f
STORE_I	
	movlw	EEPROM0		; eeprom address
	call	EEREAD		; sets eeadr	
	movf	CHARGE_I,w	; new value
	movwf	I_TEMP		; counter
	call	EWRITE		; store new value
	incf	I_TEMP,F
	return

; set faster 8MHz operation
SET_8MHz
; ensure 8MHz when charging
	btfsc	CHRG_STRT,0	; if set go to 8MHz
	goto	SET_8MHz1
	btfsc	SIX_7_8,0		; if set then Luxeon on so check mode
	goto	SET_8MHz1
; If mode 6,7,8 and Luxeon is to be off ensure it is 31.25kHz setting
	movf	SWITCH_S2,w
	xorlw	D'6'			; if mode 6
	btfsc	STATUS,Z
	goto	CHK_CK_RATE
	movf	SWITCH_S2,w
	xorlw	D'7'			; if mode 7
	btfsc	STATUS,Z
	goto	CHK_CK_RATE
	movf	SWITCH_S2,w
	xorlw	D'8'			; if mode 8
	btfss	STATUS,Z
	goto	SET_8MHz1
CHK_CK_RATE
	
	btfsc	CLOCK_RATE,0	; if set then change to 31.25kHz
 	goto	SET31.25
SET_8MHz1
	btfsc	CLOCK_RATE,0	; if already set bypass
	return
	bcf		INTCON,GIE		; clear global interrupt enable
	bsf		CLOCK_RATE,0	; set for 8MHz flag 
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01000000'	; 8MHz oscillation
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01111000'	; 8MHz
	movwf	OSCCON		; 
	call	DELAY
RECHK_OSCON
	btfss	OSCCON,2	; when set frequency is stable
	goto	RECHK_OSCON
	movlw	D'127'		; set PWM (when set at 8MHz)
	btfss	LUX_FREQ,0	; if clear set at FF
	movlw	H'FF'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	bsf		INTCON,GIE	; set global interrupt enable
	bsf		PORTA,7		; reference on
	return

; subroutine to set 31.25kHz
SET31.25
	call	MON_S2		; get switch value
; if charger started do not return to 31.25kHz

	btfsc	CHRG_STRT,0	; if set go to 8MHz
	goto	SET_8MHz

	movf	SWITCH_S2,w	
	xorlw	H'0F'		; if F
	btfss	STATUS,Z	; if zero then keep reference on
	bcf		PORTA,7		; reference off

	btfss	CLOCK_RATE,0; if already zero bypass
	return
	bcf		CLOCK_RATE,0; clear for 31.25kHz flag 
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'11000000'	; Fosc for 31.25kHz
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001000'	; 31.25kHz 
	movwf	OSCCON		; 
	movlw	D'127'		; set PWM (when set at 8MHz)
	btfss	LUX_FREQ,0	; if clear set at FF
	movlw	H'FF'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm output off
	clrf	CCPR1L		; pwm bits off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	;
	return

; delay
DELAY
	movlw	D'200'		; 
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP1	
	movlw	0xFF
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return


; subroutine to read EEPROM memory

EEREAD	
	bcf		INTCON,GIE	; set global interrupt enable 
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
;	bsf		INTCON,GIE	; set global interrupt enable 
	return

; subroutine to write to EEPROM

EWRITE
	bcf		INTCON,GIE	; set global interrupt enable 
	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bcf		INTCON,GIE	; disable interrupts
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
	return				; value written 


; INTERRUPT
; decrease CHRG_COUNT to zero
; decrease Counter 2,3,4 to zero (4 is ms byte) (05 in counter4 gives 5.9Hr)
; at end of counter 1-4, increase CHRG_OUT (status of charge) (=0 full charging, 01, top up, 2 maintenance
; set counters to 1 hour
; also if charging ie CHRG_STRT not 0(flash LEDs CHRG_OUT =0, fast green LED flashing,top up slower flashing
; maintenance short flash

; check LED_IND if bit 0 set flash orange
; if bit 1 set flash red

; start interrupt by saving w and status registers 
	
INTERRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1	; bank 0

		
	btfss	INTCON,TMR0IF	; is it the timer overflow
	goto	CHK_SWITCH
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag

	movf	CHRG_COUNT,w	; charge input detect count rate
	btfss	STATUS,Z		; if zero do not decrease
	decf	CHRG_COUNT,f

; switch timers
; if 31.25kHz bypass the switch_time_master counter
	btfss	CLOCK_RATE,0	; if set 8MHz so require extra timing period
	goto	LED_INDIC

; if charger on, counters changed at half rate
	incf	DIV_2COUNT,f	; change every interrupt
	movf	CHRG_STRT,0		; if charging increase every second interrupt
	btfsc	STATUS,Z
	goto	NORMAL_CHANGE
	btfss	DIV_2COUNT,0
	goto	PWM_CHRG_SET
NORMAL_CHANGE

; ** test charge timers remove this section below

; Charger timer
;	movf	COUNTER4,w		; ms byte counter
;	btfsc	STATUS,Z		; if zero do not decrease
;	goto	SW_TIME_INC		; if counter already decremented bypass	
;	decfsz	COUNTER2,f
;	goto	SW_TIME_INC	
;	decfsz	COUNTER3,f
;	goto	SW_TIME_INC	
;	movf	COUNTER4,w		; ms byte counter
;	btfss	STATUS,Z		; if zero do not decrease
;	decfsz	COUNTER4,f
;	goto	SW_TIME_INC	
;	goto	EOC
; ** test charge timers remove this section above

SW_TIME_INC		
	incfsz	SWTIME_MSTR,f	; switch master timer
	goto	PWM_CHRG_SET	; charge PWM for 255 in 256 counts of SWTIME_MSTR

; 1/256 cycles do counts, switch monitor etc
; PWM for charge off
	bcf		PORTA,6			; miss a PWM cycle to do other tasks
	bsf		INTER_READY,0	; flash counter increased flag
LED_INDIC
	
; LED indicator flashing
	btfss	CHRG_STRT,0	; if set then charging
	goto	NOT_CHGRING

	movf	CHRG_OUT,w	; charging status
	btfss	STATUS,Z	; if zero then fast flash
	goto	SLOWER_FS
	
	btfsc	LED_IND_FS2,1	; if set set green LED
	goto	ON_GRN_LED
	goto	OFF_GRN_LED
SLOWER_FS
	movf	CHRG_OUT,w
	xorlw	D'1'		; if 1 then top up
	btfss	STATUS,Z	; charging status if set then top up
	goto	EVEN_SLOWER_FS
	btfsc	LED_IND_FS2,2	; if set set green LED
	goto	ON_GRN_LED
	goto	OFF_GRN_LED
EVEN_SLOWER_FS
	btfsc	LED_IND_FS2,3	; if set set green LED
	goto	ON_GRN_LED
OFF_LED	
OFF_GRN_LED
	btfsc	MEAS_FLAG,0		; measure flag set when measuring input voltage
	goto	GRN_WAIT
	bcf		PORTB,5		; red LED off
	bcf		PORTB,4		; green LED off
	goto	DEC_SW_NOW
GRN_WAIT
	bcf		B_STORE,5	; no port change till ready
	bcf		B_STORE,4
	goto	DEC_SW_NOW1
ON_GRN_LED
	btfsc	MEAS_FLAG,0
	goto	RED_WAIT
	bcf		PORTB,5		; red LED off
	bsf		PORTB,4		; green LED on
	goto	DEC_SW_NOW
RED_WAIT
	bcf		B_STORE,5		; red LED off when ready
	bsf		B_STORE,4		; green LED on when ready
	goto	DEC_SW_NOW1
NOT_CHGRING

; control flashing of LEDs while not charging ie battery status
	btfsc	MEAS_FLAG,0		; measure flag set when measuring input voltage
	goto	DEC_SW_NOW1
	movf	ON_OFF,w	; if zero then off
	btfsc	STATUS,Z
	goto	OFF_LED 	; indicator LEDs off
	btfss	LED_IND,0	; if set then flash orange
	goto	FLASH_RED
	btfsc	LED_IND_FS2,2 ; if counter set then orange on
	goto	ORG_ON
	goto	OFF_LED
FLASH_RED	
	btfss	LED_IND,1	; if set then flash red
	goto	DEC_SW_NOW1
	btfss	LED_IND_FS2,2 ; flash red
	goto	OFF_LED
	btfsc	MEAS_FLAG,0
	goto	RED_WAIT1
	bcf		PORTB,4			; green off
	bsf		PORTB,5			; red on
	goto	DEC_SW_NOW
RED_WAIT1
	bcf		B_STORE,4		; green off when ready
	bsf		B_STORE,5			; red on when ready
	goto	DEC_SW_NOW1
ORG_ON
	btfsc	MEAS_FLAG,0
	goto	ORG_WAIT
	bsf		PORTB,4			; green on
	bsf		PORTB,5			; red on
	goto	DEC_SW_NOW
ORG_WAIT
	bsf		B_STORE,4		; green on when ready
	bsf		B_STORE,5			; red on when ready
	goto	DEC_SW_NOW1

; switch pressed timers
DEC_SW_NOW
; save portB LED drive
	nop						; time for PORT change
	movf	PORTB,w			; read and store 
	movwf	B_STORE
DEC_SW_NOW1
	movf	CYCLE_COUNT,w	; timer for pressed switch time
	btfss	STATUS,Z
	decf	CYCLE_COUNT,f
DEC_SW_2
	movf	SW_2SET,w		; time between switch pressings
	btfss	STATUS,Z		; if zero do not decrease
	goto	DEC_NOT0
	btfss	PORTB,0			; if set do not clear switch flag
	clrf	SW_FLG			; switch off
	goto	DEB_TIME
DEC_NOT0
	decf	SW_2SET,f
DEB_TIME
	movf	SW_1SET,w		; DEBOUNCE time for switch pressing
	btfss	STATUS,Z
	decf	SW_1SET,f
	movf	SW_3SET,w		; Luxeon start up
	btfss	STATUS,Z
	decf	SW_3SET,f

	incf	FLASH_COUNT,f	; flash rate counter (ls bit is 65ms)

	incf	LED_IND_FS2,f	; charging flashers	

DEC_COUNTERS
; decrease counters
; Garden counters
	movf	GCOUNTER4,w		; ms byte Garden counter
	btfsc	STATUS,Z		; if zero do not decrease
	goto	DEC_GARDENBY	; if counter already decremented bypass	
	decfsz	GCOUNTER2,f
	goto	DEC_GARDENBY
	decfsz	GCOUNTER3,f
	goto	DEC_GARDENBY
	movf	GCOUNTER4,w		; ms byte counter
	btfss	STATUS,Z		; if zero do not decrease
	decf	GCOUNTER4,f	
DEC_GARDENBY
; Charger timer
	movf	COUNTER4,w		; ms byte counter
	btfsc	STATUS,Z		; if zero do not decrease
	goto	DEC_BY			; if counter already decremented bypass	
	decfsz	COUNTER2,f
	goto	DEC_BY
	decfsz	COUNTER3,f
	goto	DEC_BY
	movf	COUNTER4,w		; ms byte counter
	btfss	STATUS,Z		; if zero do not decrease
	decfsz	COUNTER4,f
	goto	CHK_SWITCH

; end of count
EOC
	movf	CHRG_OUT,w		; charge status
	btfss	STATUS,Z		; if zero then end of full charge rate set for top up
	goto	IF_TOP_UP
; increase CHRG_OUT after full charge rate finished for top up charge
	movlw	D'01'
	movwf	CHRG_OUT
; reload counters for 1 hour approx
	movlw	H'01'		; ms byte
	movwf	COUNTER4
	clrf	COUNTER3
	clrf	COUNTER2
	goto	CHK_SWITCH
IF_TOP_UP
	movf	CHRG_OUT,w
	xorlw	H'01'		; top up rate
	btfss	STATUS,Z
	goto	CHK_SWITCH
	movlw	D'02'
	movwf	CHRG_OUT	; maintenance mode

; Check switch closure
DEC_BY
CHK_SWITCH
; if debounce timed out and switch open clear LONG_SW flag
	movf	SW_1SET,w	; if zero accept as timed out (debounce)
	btfss	STATUS,Z
	goto	SW_INTERR
	btfsc	PORTB,0		; if set closed
	goto	SW_INTERR
	clrf	LONG_SW		; long pressed switch flag cleared when switch open
	
SW_INTERR
	btfsc	SW_INTRUPT,0; if switch was pressed flag
	goto	ACK_SW	
	btfss	INTCON,INTF	; if set then switch pressed
	goto	SW_RECYC
	bcf		INTCON,INTF	
	bsf		SW_INTRUPT,0
	goto	RECLAIM		; set flag and check switch on 1/256 cycles
ACK_SW
	clrf	SW_INTRUPT	; switch interrupt
	movf	SWITCH_S2,w
	btfsc	STATUS,Z	; if mode 0 LED off
	goto	BY_ACK_LED	
	bsf		PORTB,4		; green LED ON
	bsf		ACK_LED,0	; acknowledge
BY_ACK_LED
	movlw	D'3'
	movwf	CYCLE_COUNT	; counter to determine modes when switch held closed
	
; check if SW_1SET is clear
	movf	SW_1SET,w	; if zero accept as timed out (debounce)
	btfss	STATUS,Z
	goto	SW_RECYC	
; if switch flag set and SW_2SET is not 0 increase SW_FLG to indicate two or 3 presses within time period
	btfss	SW_FLG,0
	goto	SET_FLG_PRESSED
	movf	SW_2SET,w
	btfss	STATUS,Z
	incf	SW_FLG,f	; two presses
	goto	SW_DEBOUNCE
SET_FLG_PRESSED	
	bsf		SW_FLG,0	; switch pressed flag
	clrf	SWTIME_MSTR	; switch master timer
	movlw	D'12'	
	movwf	SW_2SET		; time between switch pressings
	movwf	SW_3SET		; Luxeon start up timer
SW_DEBOUNCE
	movlw	D'02'
	movwf	SW_1SET			;
 
; looking for switch closed period
; initial debounce period

SW_RECYC
	
; check switch status
	movf	SW_FLG,w	; if switch pressed check timeout
	btfsc	STATUS,Z	; if not zero  pressed
	goto	RECLAIM_ACK
	movf	SW_1SET,w	; if zero accept as timed out (debounce)
	btfss	STATUS,Z
	goto	RECLAIM
	btfss	PORTB,0		; if set then closed
	goto	SW_TMR
	movf	SW_2SET,w
	btfss	STATUS,Z	; if zero then check
	goto	RECLAIM
	movf	CYCLE_COUNT,w
	btfss	STATUS,Z	; if zero then change modes of operation
	goto	RECLAIM
	bsf		LONG_SW,0	; set long pressed switch flag

; if mode 3 dim down
	movf	SWITCH_S2,w
	xorlw	D'03'		; if mode 3
	btfss	STATUS,Z
	goto	CHK_MODEA 
	movf	SET_CURRENT,w; lamp current
	btfsc	STATUS,Z	; if >0 can decrease
	goto	RESET_BRIGHT
	decfsz	SET_CURRENT,f ; dim lamp
	goto	KEEP_SET_VAL
	movlw	D'40'
	movwf	SET_CURRENT
KEEP_SET_VAL
	clrf	FLASH		; flashing off
	movf	SET_CURRENT,w
	sublw	D'03'		; compare with 3
	movlw	D'15'		; longer time between changes at low levels
	btfss	STATUS,C
	movlw	D'3'
	movwf	CYCLE_COUNT	; counter to determine modes change rate when switch held closed
	bsf		DIMMING,0	; dimming flag
	goto	RECLAIM
CHK_MODEA
; if mode 2 High/Low/Flash (also for 9 & 10 (A))
 	movf	SWITCH_S2,w
	xorlw	D'02'		; if mode 2
	btfsc	STATUS,Z
	goto	MODE_X		; SW_TMR		; 
	movf	SWITCH_S2,w
	xorlw	D'09'		; if mode 9
	btfsc	STATUS,Z
	goto	MODE_Y
	movf	SWITCH_S2,w
	xorlw	D'10'		; if mode 10
	btfss	STATUS,Z
	goto	SW_TMR		; not these
MODE_Y
	incf	MODE_2,f	; bypass dimming mode
MODE_X
	incf	MODE_2,f	; determines mode (high, low, flash)
	movf	MODE_2,W
	sublw	D'02'
	btfss	STATUS,C	; if zero clear
	clrf	MODE_2 
	movf	MODE_2,w	; if clear high level
	btfsc	STATUS,Z
	goto	RESET_BRIGHT ; max level
	xorlw	D'01'		; dim
	btfss	STATUS,Z
	goto 	FLASH_2		; mode 2 flash
; dim level
	clrf	FLASH
	movlw	D'10'
	movwf	SET_CURRENT
	bsf		DIMMING,0	; dimming flag
	movlw	D'20'
	movwf	CYCLE_COUNT	; counter to determine modes when switch held closed
	goto	RECLAIM
FLASH_2
;	clrf	FLASH
	bcf		FLASH,0
	bcf		FLASH,2
	bsf		FLASH,1		; flash
	clrf	FLASH_COUNT	; set flash counter to zero
	goto	RESET_BRIGHT2
RESET_BRIGHT
	clrf	FLASH
RESET_BRIGHT2
	movlw	D'40'		; 
	movwf	SET_CURRENT
	movlw	D'19'		; longer for reset to maximum
	movwf	CYCLE_COUNT	; counter to determine modes when switch held closed
	goto	RECLAIM

; check switch timer
SW_TMR
	movf	ON_OFF,w	; if on then ignore SW_2SET timer
	btfss	STATUS,Z
	goto	SWITCH_OFF?

	movf	SW_2SET,w	; time between switchings
	btfss	STATUS,Z
	goto	RECLAIM
	clrf	ACK_LED		; acknowledge LED
	btfsc	SW_FLG,1	; if set then 2 or 3 switchings
	goto	SW_ON_SW
	btfss	SW_FLG,0	; if set then 3 switchings
	goto	RECLAIM
	bcf		FLASH,1
	bcf		FLASH,2
	bsf		FLASH,0		; emergency flash
	movlw	D'40'		; 
	movwf	SET_CURRENT
	clrf	FLASH_COUNT	; set flash counter to zero
	goto	RECLAIM
SWITCH_OFF?
	btfss	LONG_SW,0	; if long switch pressed do not switch off
	goto	OFF_		; if switch held pressed do not switch off
	clrf	LONG_SW		; cleared on switch open
	clrf	SW_FLG		; switch off
	goto	RECLAIM	
OFF_
	movf	ON_OFF,w	; if already off bypass
	btfsc	STATUS,Z
	goto	RECLAIM
	clrf	RAMP		; for faster PWM ramp up
	clrf	FLASH		; flashing off	
	clrf	ON_OFF		; switch to off mode
	clrf	SW_FLG		; switch off
	clrf	CCPR1L		; pwm bits off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	;
	bcf		PORTB,5		; red LED off
	bcf		PORTB,4		; green LED off	
	clrf	SW_1SET		; switch timers
	clrf	SW_2SET
	clrf	FLASH_X		; type of flash
	clrf	CURRENT_AVG	; total over 15 counts
	clrf	AVG_COUNT
	clrf	DIMMING		; dimming flag
	goto	RECLAIM

SW_ON_SW
	btfss	SW_FLG,0	; if set then 3 switchings
	goto	ON_ON
	bcf		FLASH,1
	bcf		FLASH,2
	bsf		FLASH,0		; emergency flash
	bsf		FLASH_X,0	; set for mode 8 
	goto	ON_ON1
ON_ON
	clrf	FLASH		; flashing off	
ON_ON1
	bsf		ON_OFF,0	; set to on
	clrf	SW_FLG
	clrf	SW_1SET		; switch timers
	clrf	SW_2SET
	clrf	FLICKER		; hysteresis
	goto	RECLAIM

; PWM output routine for charging
PWM_CHRG_SET			; run for 255 in 256 cycles

	movf	SWTIME_MSTR,w	; counter. Check ms bit for change
	andlw	B'01111111'		; look at ls 7-bits if zero then ms changed
	btfsc	STATUS,Z
	bsf		INTER_READY,0	; set changed bit

; determine if at minimum setting
	movf	CHRG_STRT,w	; charger started flag
	btfsc	STATUS,Z	; if zero not charging 
	goto	NOT_CHARG_RES
	movf	LOW_TME,w
	sublw	D'20'		; set minimum
	btfss	STATUS,C
	goto	CHRG_PWM_RUN
CLR_OUT
	movlw	D'20'
;	movwf	LOW_TME
	goto	TST_MDE
CLR_OUT1
	movlw	D'215'
	movwf	LOW_TME
	goto	TST_MDE		
CHRG_PWM_RUN
	movf	LOW_TME,w
	addlw	D'40'		; set maximum
	btfsc	STATUS,C	; if over then clear	
	goto	CLR_OUT1
; full time pulses
	movf	LOW_TME,w	; PWM low time
TST_MDE 
	btfsc	FLAG_1,0	; check bit 0
	goto	LOW_OUT
	bsf		FLAG_1,0	; clear if set

	sublw	D'01'
	movwf	TMR0		; low time

; apply pulsing if low time minimum not small enough
	movf	LOW_TME,w
	sublw	D'20'		; set minimum
	btfss	STATUS,C
	goto	SET_A6
	incf	PULSE_PWM,f
	movf	PULSE_PWM,w
	sublw	D'21'		; if 20 reset
	btfss	STATUS,C
	clrf	PULSE_PWM	; reset to 0
	movf	PULSE_PWM,w
	subwf	LOW_TME,w	; if low time less than timer pulse
	btfsc	STATUS,C 
SET_A6
 	bsf		PORTA,6		; output high
	goto	RECLAIM
LOW_OUT
	addwf	TMR0,f		; high time is inverse of 8MHz/4/2/256-LOW_TME  
	bcf		FLAG_1,0	; set if clear
NOT_CHARG_RES
	bcf		PORTA,6		; charging off

; end of interrupt reclaim w and status
RECLAIM	
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt
RECLAIM_ACK
	btfss	ACK_LED,0	; if acknowledge set clear LED
	clrf	LONG_SW
	goto	RECLAIM
CLEAR_ACK
	bcf		PORTB,4		; green LED off	
	bcf		B_STORE,4		; 
	clrf	ACK_LED

	goto	RECLAIM


 end
