'4-20ma.bas
'PICAXE-08M

'NOTE: variable w4 may have to be altered slightly (four places) to allow
'for 5V regulator tolerances - values given are for 4.99V rail.

start:
w6=200:w4=80:b4=1			'w6=pwm, w4=adc for 4ma, b4=12ma loop cnt.
gosub raise				'raise to 4ma
gosub interrupt			'and wait for push button

loop0:
wait 2
w4=244				'adc for 12ma
gosub raise				'raise to 12ma

b3=2					'b3=led flash number
if b4>5 then loop1		'only stop at 12ma 5 times
gosub flash				'led indication
b4=b4+1

loop1:			
w4=408				'adc for 20ma
gosub raise				'raise to 20ma

b3=3						
gosub flash

lower:				'lower routine
wait 2
w4=80					'adc for 4ma
for w6=w6 to 0 step-1		'decrease pwm
for b1=1 to 10			'slow lower time by looping
pwmout 2,255,w6			'pwm on output2
readadc10 1,w5			'check adc feedback
if w5<70 or w5>420 then fault	'out of range
if w5<=w4 then loop2		'value reached?	
next b1
next w6

loop2:
pulsout 4,300			'1 flash for 4ma
goto loop0				'back to raise

raise:				'raise routine
for w6=w6 to 1024			'increase pwm
for b1=1 to 15			'slow raise time by looping
pwmout 2,255,w6			'pwm on output2
readadc10 1,w5			'check adc feedback
if w5>=w4 then valueup		'value reached?
next b1
if w5<40 or w5>420 then fault	'out of range
next w6

valueup:
return

flash:				'led routine
for b2=1 to b3			'b3=number of flashes
pulsout 4,300			'flash output4 
pause 800
next b2
return

interrupt:				'interrupt routine
pulsout 4,300			'pb has been pressed
b3=1					'no more confusing flashes
pause 1000				'wait for pb release

freeze:				'freeze output
pwmout 2,255,w6			'pwm on output2
pause 10				
readadc10 1,w3			'check feedback
if pin3=1 then loop3		'has pb been pressed?	
if w3<70 or w3>420 then loop4	'out of range?		
if w3<w5 then tweakup		'has output drifted low?
if w3>w5 then tweakdown		'has output drifted high?
goto freeze				'all ok

loop3:
pulsout 4,300			'indicate pb press
pause 1000				'wait for pb release

loop4:
setint %00001000,%00001000	'enable interrupt for freeze control
return

tweakup:				'adjust output up
w6=w6+1
goto freeze
tweakdown:				'adjust output down
w6=w6-1
goto freeze

fault:				'fault routine
setint %00000000,%00000000	'dissable interrupt
pwmout 2,0,0			'turn off output

loop5:				'led fault routine
for b5=0 to 30								
if pin3=1 then loop6		'has pb been pressed?(reset)
if b5>29 then loop5
if b5>10 then led

loop7:
pause 50
next b5

led:
pulsout 4,300			'led fault indication
goto loop7

loop6:
pulsout 4,300			'indicate pb press
goto start				'start again


