'----------------------------------------------------------
' Personal Timer
' Eric Rodda 2004
'----------------------------------------------------------

' PICAXE-18X

symbol SW = pin0			'rename input 0  'SW'
symbol LED1 = 3			'physical pin 9 
symbol LED2 = 2			'physical pin 8 
symbol POWER = 1			'physical pin 7 
symbol SOUNDER = 7		'physical pin 13					

' Variables used:
'	b0 - temp count in for/next
'	b1 - tens count
'	b2 - units count
'	b3 - temp count
'	w2(b5:b4) - total seconds
'	b6 - checksw var
'	b7 - remaining time section
'----------------------------------------------------------

main:
	if SW = 1 then solidpush
	goto main

solidpush:					'ensures switch is actually pushed, not a glitch
	pause 60				'wait a bit
	if SW = 1 then letsbegin 	'check switch again
	goto main

letsbegin:
	high POWER				'keep on signal	
	pulsout LED1,1000			'blink 10ms
	sound SOUNDER, (200,2)
	pulsout LED2,1000			'blink 10ms

	let b1 =0
	let b2 =0
	let b6 =0
	wait 1

' Capture tens of minutes

	high LED1
	count 0,5000,b1			'count for 5 seconds
	low LED1

'	if b1 <= 9 then min10ok
'	let b1 = 9   			'make it 90 mins max

' Capture units of minutes

min10ok:
	high LED2
	count 0,5000,b2			'count for 5 seconds
	low LED2
	if b2 <= 9 then minsok
	let b2 = 9				'make it 9 mins max

' Check if no time setting selected and exit if so.

minsok:
	if b1 =0 and b2 =0 then cancelit
	gosub display
	b0 =b1 * 10
	b3 =b0 + b2			 	'minutes
	w2 =b3 * 60			 	'seconds

alladdedup:
	sound SOUNDER, (100,1)

' Timing loop

timing:
	pause 1017				'get rid of a second(1000) - adjust for exact timing!
	if w2 <300 and w2 >60 then fivemin 'between 1min and 5 min
	if w2 >60 then notyet		'if greater than 60secs left - pulse LED1
	if w2 <=10 then lastten
	pulsout LED2,200			'if less than 60secs left - pulse LED2
	goto takeitaway

' Between 1 min and 5 mins

fivemin:
	if b0 =1 then fivemin2
	pulsout LED1,200
	let b0 =1
	goto takeitaway

fivemin2:
	pulsout LED2,200
	let b0 =0
	goto takeitaway

lastten:
	pulsout LED1,100		 	'if ten or less secs left - flash both LEDs
	pulsout LED2,100
	sound SOUNDER, (200,1)
	goto takeitaway

notyet:
	pulsout LED1,100		 	'blink 1ms

takeitaway:
	w2 =w2 - 1
	if w2 =0 then letitring	
	gosub checksw
	  if b6 =2 then cancelit
	goto timing

'End of timing loop

letitring:
	for b0 = 1 to 5
	sound SOUNDER, (125,5)
	pause 100
	next b0
	pause 300
      for b0 = 1 to 5
	sound SOUNDER, (125,5)
	pause 100
	next b0
	low POWER				'turn it off!!!
	goto main
		
'Dont do it

cancelit:
	pulsout LED1,1000			'blink 10ms
	sound SOUNDER, (25,5)
	pulsout LED2,1000			'blink 10ms
	wait 1

displayremaining:				'the following displays the remaining time on the LEDS
	b7=w2/60				'get minutes from seconds
	if b7=0 then nottheendyet	'get out if nothing left
	if b7>9 then morethannine	'check if greater than 9
	let b1=0
	let b2=b7
	gosub display
	goto theend

morethannine:
	b0=b7/10				'do rounding (down only)(b7=total minutes remaining)
	b3=b0*10			 
	b6=b3-b7
	if b6=0 then azero
	if b6=255 then aone
	if b6=254 then atwo
	if b6=253 then athree
	if b6=252 then afour
	if b6=251 then afive
	if b6=250 then asix
	if b6=249 then aseven
	if b6=248 then aeight
	if b6=247 then anine
	goto theend			    	

azero:
	let b1=b0
	let b2=0
	gosub display
	goto theend

aone:
	let b1=b0
	let b2=1
	gosub display
	goto theend

atwo:
	let b1=b0
	let b2=2
	gosub display
	goto theend

athree:
	let b1=b0
	let b2=3
	gosub display
	goto theend

afour:
	let b1=b0
	let b2=4
	gosub display
	goto theend

afive:
	let b1=b0
	let b2=5
	gosub display
	goto theend

asix:
	let b1=b0
	let b2=6
	gosub display
	goto theend

aseven:
	let b1=b0
	let b2=7
	gosub display
	goto theend

aeight:
	let b1=b0
	let b2=8
	gosub display
	goto theend

anine:
	let b1=b0
	let b2=9
	gosub display
	goto theend

nottheendyet:
	let b1 =0
	let b2 =0
	let b6 =0
	let w2 =0

' Check for count up request

	high LED1
	high LED2
	count 0,3000,b1			'count for 3 seconds
	low LED1
	low LED2
	if b1 = 0 then theend		'no request for count up timer

countup:	
	w2 =w2 + 1
	gosub checksw
	if b6 =2 then cancelit
	pause 1017
	if w2 < 3600 then flashunits
	if w2 = 3600 then onehour
	if w2 > 3600 then flashtens
	if w2 >= 7200 then twohours

flashunits:
	pulsout LED2,100			'blink 1ms
   	goto countup

onehour:
	sound SOUNDER, (125,5)

flashtens:
	pulsout LED1,100			'blink 1ms
   	goto countup

twohours:
	sound SOUNDER, (125,5)
	pause 300
	sound SOUNDER, (125,5)
	goto theend

theend:
	let b0=0
	let b1=0
	let b2=0
	let b3=0
	let b6=0
	let b7=0
	low POWER				'turn it off!!!
	goto main		

' Subroutines

'Display tens of minutes (b1)

display:
	if b1=0 then delayunits
		for b0 = 1 to b1
		pulsout LED1,30000
	  	pause 250
		next b0
	goto dounits
	delayunits:
	pause 500

'Display units of minutes (b2)	

dounits:	
	if b2=0 then fini
		for b0 = 1 to b2
		pulsout LED2,30000
	  	pause 250
	  	next b0
fini:
return

checksw:
	if SW =0 then finisw
	let b6 = b6 +1
	return

finisw:
	let b6=0
	return















