' Improved Bathroom Exhaust Fan Controller
' Version 9.1  13/09/2005   W.A.Fitzsimons

' PICAXE-08M

mainloop:
	readadc 1,b0			'read voltage divider
	if b0<96 then timer1		'hot water temperature turns the fan on
	if pin3=1 then timer1		'momentary switch takes P3 high
	goto mainloop

timer1:
	b1=0					'reset delay flag
	readadc 4,b5			'reads timer setting
	w3=224-90				'calculating b2 range =90+(b5*(224-90))/256
	w4=b5*w3
	w4=w4+1				'ensures that zero is not used in next calculation
	b5=w4/256
	b5=90+b5				'value for b2's for..next loop
	high 2				'turn fan on
	pause 2000				'cloaking for P3

timer2:
	for b4=1 to 8			'start timer
		if pin3=1 then fanoff1
		for b3=1 to 243
			if pin3=1 then fanoff1
			for b2=1 to b5		'time range of 4 to 10 minutes
				if pin3=1 then fanoff1
			next b2
		next b3
	if b4=4 then beep1		'1/2 way reminder
	if b4=8 then beep2		'for timer completion
beep:
	next b4
	goto fanoff


' One beep on P0 or turn fan off after delay

beep1: 
	if b1=1 then fanoff		'after delay period turn fan off
	pulsout 0,65535 			'1 beep on P0
	goto beep

beep2: 					'2 beeps on P0
	pulsout 0,65535
	pause 1000
	pulsout 0,65535
	goto beep

fanoff1:
	if b1=1 then timer1		'if delay flag is set then turn fan on
	readadc 1,b0
	if b0>96 then fanoff		'no delay required
	if b0=96 then fanoff		'no delay required
	b1=1					'set delay flag
	low 2					'stop fan
	pause 2000				'cloaking for P3
	goto timer2

fanoff:
	b1=0					'reset delay flag
	low 2					'stop fan
	pause 2000				'cloaking for P3
	goto mainloop


