' Nokia 5110 (LPH7366) LCD Display
' PICAXE-18X

symbol SCLK = 0			'LCD pin 2 -> PICAXE out0
symbol SDA = 1			'LCD pin 3 -> PICAXE out1
symbol DC = 2			'LCD pin 4 -> PICAXE out2
symbol RES = 4			'LCD pin 9 -> PICAXE out4
symbol RX = 6			'serial input on in6
symbol loop1 = b0
symbol var_data = b1
symbol loop2 = b2
symbol command = b3
'symbol counter = b4
symbol X = b5
symbol Y = b6
symbol mask = b7
symbol loop3 = b8
symbol eep_loc = b9
symbol message2 = b10
symbol mess_end = b11
setfreq m8

'  Character lookup table in EEPROM for standard ASCII characters in a 5x7 format.

EEPROM 0,(33,197,6,19,32,12)	'control codes
EEPROM 6,(0,0,0,0,0)		' // sp
EEPROM 12,(20,8,62,8,20)	' // *
EEPROM 18,(0,96,96,0,0)		' // .
EEPROM 24,(62,81,73,69,62)	' // 0
EEPROM 30,(0,66,127,64,0)	' // 1
EEPROM 36,(66,97,81,73,70)	' // 2
EEPROM 42,(33,65,69,75,49)	' // 3
EEPROM 48,(24,20,18,127,16)	' // 4
EEPROM 54,(39,69,69,69,57)	' // 5
EEPROM 60,(60,74,73,73,48)	' // 6
EEPROM 66,(1,113,9,5,3)		' // 7
EEPROM 72,(54,73,73,73,54)	' // 8
EEPROM 78,(6,73,73,41,30)	' // 9
EEPROM 84,(126,17,17,17,126)	' // A
EEPROM 90,(127,73,73,73,54)	' // B
EEPROM 96,(62,65,65,65,34)	' // C
EEPROM 102,(127,65,65,34,28)	' // D
EEPROM 108,(127,73,73,73,65)	' // E
EEPROM 114,(127,9,9,9,1)	' // F
EEPROM 120,(62,65,73,73,122)	' // G
EEPROM 126,(127,8,8,8,127)	' // H
EEPROM 132,(0,65,127,65,0)	' // I
EEPROM 138,(32,64,65,63,1)	' // J
EEPROM 144,(127,8,20,34,65)	' // K
EEPROM 150,(127,64,64,64,64)	' // L
EEPROM 156,(127,2,12,2,127)	' // M
EEPROM 162,(127,4,8,16,127)	' // N
EEPROM 168,(62,65,65,65,62)	' // O
EEPROM 174,(127,9,9,9,6)	' // P
EEPROM 180,(62,65,81,33,94)	' // Q
EEPROM 186,(127,9,25,41,70)	' // R
EEPROM 192,(70,73,73,73,49)	' // S
EEPROM 198,(1,1,127,1,1)	' // T
EEPROM 204,(63,64,64,64,63)	' // U
EEPROM 210,(31,32,64,32,31)	' // V
EEPROM 216,(63,64,56,64,63)	' // W
EEPROM 222,(99,20,8,20,99)	' // X
EEPROM 228,(7,8,112,8,7)	' // Y
EEPROM 234,(97,81,73,69,67)	' // Z

' LCD initialisation
' see www.microsyl.com/nokialcd/nokialcd.html

init:
low SCLK
low SDA
low DC
low RES
pause 20
low RES
pause 500
high RES
command = 1
for loop1 = 0 to 5		'start a loop reading control codes
	read loop1,var_data	'read var_data from EEPROM
	gosub WriteToLCD 	'transmit to LCD module
next loop1
X = 0 ' position cursor top left
Y = 0
gosub GotoXY
gosub clearfast

start:
gosub normal

x = 0				'horizontal position (increases in steps of 4!)
y = 0
gosub GotoXY
message2 = 0

loop:
lookup message2,("Waiting for Transmission on 6"),var_data
message2 = message2 + 1
gosub decode			'dislay the message
if message2 < 29 then loop	'message length

receive:
gosub ser_in
goto receive			'loop forever, waiting for serial data

'===================================
' Decoding section
'===================================

decode:
if var_data <> 32 then loop_1b 'check if ascii = space
eep_loc = 6
goto loop_1x

' Check if ascii = "."

loop_1b:
if var_data <> 45 then loop_1c
eep_loc = 18
goto loop_1x

' Filter out ASCII above and below alphanumerics

loop_1c:
if var_data > 47 or var_data < 123 then loop_1d 
eep_loc = 12
goto loop_1x

' Convert lower case to upper case

loop_1d:
if var_data < 97 then loop_1e
var_data = var_data - 32

' Filter out ASCII between numbers and letters

loop_1e:
if var_data < 58 or var_data > 64 then loop_1f 
eep_loc = 12
goto loop_1x

loop_1f:
if var_data > 57 then loop_alpha 'otherwise convert numbers
var_data = var_data - 47
var_data = var_data * 6
var_data = var_data + 18
eep_loc = var_data
goto loop_1x

' Convert letters

loop_alpha:
var_data = var_data - 64
var_data = var_data * 6
var_data = var_data + 78
eep_loc = var_data

loop_1x:
mess_end = eep_loc + 5
gosub PrnText
return

' End of decoding section
'===================================

' Reads data from eeprom location corresponding to ASCII character

PrnText:
command = 0
for loop1 = eep_loc to mess_end
	read loop1,var_data
	gosub WriteToLCD
next loop1
return

WriteToLCD:
high DC				'data mode
if command = 0 then dataMode
low DC				'command mode

DataMode:
for loop2 = 1 to 8
	low SCLK
	mask = var_data & 128
	low SDA
	if mask = 0 then Skiphigh
	high SDA
Skiphigh:
	high SCLK
	var_data = var_data * 2
next loop2
return

' Clears screen

ClearFast:
low SDA
high DC
for loop1 = 1 to 48
	for loop3 = 1 to 84
		low SCLK
		high SCLK
	next loop3
next loop1
return

' Sets the cursor position

GotoXY:
command = 1
var_data = X + 128
gosub WriteToLCD
var_data = Y + 64
gosub WriteToLCD
return

Normal:
command = 1
var_data = 12			'black text on white
'var_data = 13			'invert (white text on black)
gosub writetolcd
return

' Serial input

ser_in:
serin RX,n1200,var_data		'really 2400 (8MHz clock)
gosub decode
return

