' Low Battery Cutout
' Written by Terry Mowles, October 2005
' PICAXE-08M

symbol lo=296			'low limit (turn off voltage)
symbol hi=503			'high limit (turn on voltage)

main:
	if pin3=0 then bypass	'bypass for testing or adjustment purposes
	read 0,b2			'read recharge flag from memory into variable b2

main2:
	readadc10 4,w0 		'read ADC on input4 into variable w0
	'debug
	if w0>lo and w0<hi then check 'if w0 is between lo and hi then check if
					'recharge flag set
	if w0<lo then shutdown	'if w0 is less than lo then turn off (shutdown)
	if w0>hi then start	'if w0 is greater than hi then turn on (start)
				
start:
	high 1			'switch output on 
	low 2				'switch off RECHARGE LED 
	if b2=1 then clearflag	'if recharge flag set then clear flag

pause2:
	pause 1000			'pause 1s before next reading
	goto main2			'loop

shutdown:
	low 1				'switch output off 
	high 2			'switch on RECHARGE LED 
	if b2=0 then setflag	'if recharge flag not set then set flag
	pause 50			'pause 50 ms
	low 2				'switch off RECHARGE LED (flashes LED)
	pause 1000			'pause 1 second
	goto shutdown		'loop

clearflag:
	let b2=0			'clear recharge flag 
	write 0,b2			'store value in memory
	goto pause2			'loop back into start 

setflag:
	let b2=1			'set recharge flag 
	write 0,b2			'store value in memory
	goto shutdown		'loop back to shutdown

check:
	if b2=0 then start	'if recharge flag not set go to start
	goto shutdown		'else go to shutdown

bypass:
	high 1			'switch output on

flash:
	high 2			'switch on RECHARGE LED
	pause 250			'pause 250 milliseconds
	low 2				'switch off RECHARGE LED
	pause 250			'pause 250 milliseconds
	goto flash			'loop

