;*********************************************************
;	IR Remote Repeater
; 	Regenerate Multiple IR Signals
;	Carrier frequency 38KHz (T/2=52, on 16MHz Fosc)
;	Processor Clock 16MHz (Tcy = 250ns)
;	Alex Sum 
;	11 December 2005
;	V1.03A (_MCLRE_OFF RST circuit removed from Schematic)
;*********************************************************
			list	p=12f675		;list directive to define processor
			#include	<p12f675.inc>	;default Processor specific header file
			errorlevel	-302	; suppress message 302 from list file

	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON & _HS_OSC & _CPD_OFF

; Define Constants here
Delay		equ		.7		; should be (52-n)/y*dly01
							; y is number of instructions in dly01
							; n is overhead in cloop etc
#define	IRLED	GPIO,0		;IR LED on GP 0
#define LED		GPIO,1		;Status LED on GP 1
#define	INPUT	GPIO,2		;Input on GP 2
;------------
; Define Data
;------------
			ORG		0x20		;RAM Area
statevar	RES		1			;carrier output toggle
cntr		RES		1			; Counter for T/2
; Code
			ORG		0x00		;Reset Vector
			goto 	MCUINIT
			ORG		0x04		;Interrupt Vector
			retfie				;return from interrupt
			ORG		0x08		;Program starts here
MCUINIT
			BANKSEL	ANSEL		;Bank 1
			clrf	ANSEL		;GP 0-3 as digital I/O
			clrf	VRCON		;turn off VREF
			movlw	b'00111100'	;GP 0-1 as outputs, GP 2 input
			movwf	TRISIO
			movlw	b'01001000'	;Weak Pull up enabled, Rising edge
			movwf	OPTION_REG	;assign PS to WDT 1:1
			bsf		WPU,2		;GP 2 weak pull up enabled
			BANKSEL	GPIO		;Bank 0
			clrf	GPIO
			movlw	0x07		;turn off comparator
			movwf	CMCON
			movlw	0x00
			movwf	statevar

sigwait		btfsc	INPUT		; Read GP2 and check for Z
			goto	sigwait		; no wait until Z
			movlw	0x00
			movwf	statevar	; make sure statevar is zero
			bsf		LED			; Turn LED on
cloop		movlw	Delay		; (52-n)/y*dly01
			movwf	cntr
			movf	statevar,w	;Toggle State
			xorlw	0x01
			movwf	statevar
			btfsc	statevar,0
			goto	gp0high
gp0low		bcf		IRLED
			goto	dly01
gp0high		bsf		IRLED
dly01		decfsz	cntr,F		;reach T/2 yet?
			goto	notyet
t2now
			btfss	INPUT		;yes T/2 now so check input again
			goto	cloop
LEDoff		bcf		LED			; turn off LED, wait for more signal
			bcf		IRLED		; make sure IR is off as well
			goto 	sigwait
notyet
			btfss	INPUT		; check input again
			goto	dly01
			goto	LEDoff

			end
