' ChaseClock.bas
' Written by Ron Russo  27/04/05

' PICAXE-08

symbol Sec = b13				'seconds counter
symbol Leds = b12				'chase counter
symbol TmLength = w0			'duration of pulsout to match chase with second
symbol ChaseClock = 0			'pin0
symbol NewSec = 1				'pin1
symbol NewMin = 2				'pin2
symbol ChaseData = 4			'pin4 (chase data output & reset input for synchronisation)

MAIN:
   pause 100				'settling time
   high NewMin				'release SR9-SR16 reset (MR) inputs
   goto RES_MIN				'go initilise for start of new minute

LOOP:
   input 4					'set pin 4 as input
   if input4 = 1 then RES_MIN 	'if sync button is pressed initialise for new minute
   if input3 = 1 then NXT_SEC 	'else a high-going pulse on input 3 indicates one second
						'has elapsed, so start a new second.

' NOTE: Some analogue clocks have low-going rather than high-going pulses (change the above line to suit).

   goto LOOP				'loop until a clock pulse occurs
           
NXT_SEC:
   output 4					'set pin4 to output to send chase data
   if Sec = 0 then RES_MIN		'if min is up then go reset minute
   Sec = Sec - 1				'else one sec has elapsed so decrement secs

' Calculate optimum time factor so that all intended LEDs are illuminated just before
' the current second is up. A multiplication factor of 90 is optimum for the PICAXE-08.

   TmLength = 61 - Sec
   TmLength = TmLength * 90

CHASE:
   high ChaseData				'set chase data bit high
 
  for Leds = Sec To 0 Step -1 	'count back starting from relevent second
   	pulsout ChaseClock, TmLength	'pulse with calculated duration to 
						'increment clock input of chase regs(SR1-SR8).
   	low ChaseData			'after first clock pulse, set data low for rest of chase
   next Leds				'do rest of LEDs until this sec finished

   low NewSec				'zero SR1-SR8 outputs, clock SR9-SR16
   pause 1					'make pulse 1ms wide
   high NewSec				'return high
   goto LOOP

RES_MIN:
   Sec = 60					'power up or minute is up or syncro reset...
   low NewMin				'reset all SR9-SR16 outputs to zero
   pause 1					'make pulse 1ms wide
   high NewMin
                
' As the first 4 outputs of SR9 are not connected to LEDs we must send a dummy run
' of 4 clock pulses to shift regs SR9-SR16 to start at LED60 (SR9 output O4). This
' will also pulse the reset (MR) inputs of SR1-SR8, zeroing their outputs ready for
' the new minute.

   for B10 = 1 to 4
 	  pulsout NewSec, 10
   next

   if input4 = 1 then LOOP 		'check input again if sync button still pressed
   goto NXT_SEC				'else go start a new minute




