' Yoghurt Maker by M.Tiede 08/06
' PICAXE-08M

symbol TOPTEMP = 37		'upper temp
symbol BOTTEMP = 35		'lower temp

symbol temp = b10

' pin definitions

symbol FAN = 0			'circulation/heatsink fans
symbol PWR_RLY = 1		'power relay (RLY1)
symbol POL_RLY = 2		'polarity relay (RLY2)
symbol DS18B20 = 4		'temp sensor

main:
   low FAN			'fan off
   low PWR_RLY			'Peltier off

loop:
   pause 5000			'to check temp every 5 secs
   readtemp DS18B20,temp	'get current temp
   if temp > TOPTEMP then toohot
   if temp < BOTTEMP then toocold
   goto loop

toohot:
   high FAN			'turn on the fan
   high POL_RLY			'set correct polarity for cooling
   high PWR_RLY		'power up the Peltier
   pause 100			'settling time
less:
   readtemp DS18B20,temp	'get current temp
   if temp > TOPTEMP then less 	'loop until cool enough
   goto main

toocold:
   high FAN			'turn on the fan
   low POL_RLY			'set correct polarity for heating
   high PWR_RLY		'power up the Peltier
   pause 100			'settling time
more:
   readtemp DS18B20,temp	'get current temp
   if temp < BOTTEMP then more 	'loop until warm enough
   goto main
