; LCDDrive.bas
; PICAXE-18X

symbol  RS = 2			;0 = Command   1 = Data
symbol  EN = 3			;0 = Idle      1 = Active
symbol  MEM = b11  		;used when reading EEPROM
symbol  LCD_ch = b12		;byte to be written to LCD
symbol  RS_bit = b13		;RS bit

START:
   gosub INIT_LCD		;always initialise LCD first!

   eeprom 0,("  Hello World   ") 	;store text in EEPROM
   eeprom 16,("- Test Message -")

; Set display position to start of first line

DISPLAY:	
   LCD_ch = $80
   gosub WRCMD

; Display the first line

   for MEM = 0 TO 15
      read MEM,LCD_ch
      gosub WRCHR
   next
   pause 500
 
; Set display position to start of second line

   LCD_ch = $C0		;second line starts at $40, not $10! 	
   gosub WRCMD		;(see PICAXE manual for details)

; Display the second line

   for MEM = 16 TO 32
      read MEM,LCD_ch
      gosub WRCHR
      next
   pause 500
   goto DISPLAY

; Initialise the LCD module

INIT_LCD:
   pause 200		;200ms power-on delay 
   RS_bit = $00		;clear RS to send command
   pins = %00110000	;command (sets 8-bit mode initially)
   pulsout EN,1		;give a 10us pulse on E
   pause 10		;wait 10ms
   pulsout EN,1		;give a 10us pulse on E
   pause 1		;wait 1ms
   pulsout EN,1		;give a 10us pulse on E
   pause 1		;wait 1ms
   pins = %00100000	;command (now set 4-bit mode)
   pulsout EN,1		;give a 10us pulse on E
   pause 1		;wait 1ms

   LCD_ch = $28	;command (4-bit, 2 lines, 5x7 mode)
   gosub WRCMD
   LCD_ch = $0C	;command (display on, cursor off)
   gosub WRCMD
   LCD_ch = $06	;command (increment, no shift)
   gosub WRCMD
   LCD_ch = $01	;command (clear display)
   gosub WRCMD
   return

; Write a command (instruction) to the LCD

WRCMD:
   RS_bit = $00			;clear RS to send command

; Write command or data to the LCD

WRCHR:
   pins = LCD_ch & %11110000 | RS_bit 	;put high nibble out first
   pulsout EN,1				;give a 10uS pulse on E
   pins = LCD_ch * 16 | RS_bit 		;put low nibble out next
   pulsout EN,1				;give a 10uS pulse on E
   RS_bit = %00000100			;default (to send data)
   pause 5				;wait 5ms
   return
