; Updated speedometer corrector with automatic input sensing
; added optional faster update 
; digital speedometer corrector
; outputs an altered frequency by a factor of between
; 0% and 99% in 1% steps 

; CPU configuration
; 
	ERRORLEVEL -302

	list P=16F628A
	#include p16f628A.inc

	__config _HS_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_ON & _MCLRE_ON & _LVP_OFF

; Define variables at memory locations


EEPROM0		equ	H'00'	; non-volatile storage for pullup/down/sensitivity  RA4,3,2
EEPROM1		equ	H'01'	; non-volatile storage for faster/slower
EEPROM2		equ	H'02'	; low resolution increase
EEPROM3		equ	H'03'	; duration before signal stops after signal input ceases

; Define variables at memory locations

; RAM

FLAG_0		equ	H'20'	; overrange flag
FLAG_I		equ	H'21'	; recount flag
TEMP_1		equ	H'22'	; temporary working storage
TEMP_2		equ	H'23'	; temp storage
COUNT1		equ	H'24'	; input counter ls byte
COUNT2		equ	H'25'	; input counter ms byte
COUNT3		equ	H'26'	; latched input counter ls byte
COUNT4		equ	H'27'	; latched input counter ms byte
COUNT5		equ	H'28'	; half way ls byte High Level
COUNT6		equ	H'29'	; half way ms byte High Level
COUNT7		equ	H'2A'	; halfway counter ls byte Low Level from count5
COUNT8		equ	H'2B'	; halfway counter ms byte Low Level from count6
COUNT9		equ	H'2C'	; output counter ls byte Low Level from calc1
COUNT10		equ	H'2D'	; output counter ms byte Low Level from calc2
CALC1		equ	H'2E'	; calculated value ls byte
CALC2		equ	H'2F'	; calculated value ms byte
COUNTA		equ	H'30'	; 1/4 way ls byte High Level
COUNTB		equ	H'31'	; 1/4 way ms byte High Level
COUNT11		equ	H'32'	; 1/4 way counter ls byte Low Level from counta
COUNT12		equ	H'33'	; 1/4 way counter ms byte Low Level from countb
COUNTC		equ	H'34'	; 3/4 way ls byte High Level
COUNTD		equ	H'35'	; 3/4 way ms byte High Level
COUNT13		equ	H'36'	; 3/4 way counter ls byte Low Level from countc
COUNT14		equ	H'37'	; 3/4 way counter ms byte Low Level from countd
COUNTE		equ	H'38'	; output running counter ls
COUNTF		equ	H'39'	; output running counter ms
FAST_SLOW	equ	H'3A'	; fast/ slow correction
SWITCH_SET	equ	H'3B'	; switch settings store
PORTA_STO	equ	H'3C'	; storage of PORTA status
DELCNT		equ	H'3D'	; delay loop
VALUE_1		equ	H'3E'	; delay counter
VALUE_2		equ	H'3F'	; delay counter
AUTO_COUNT	equ	H'40'	; counter of input pulses for automatic setup
SET_FLG		equ	H'41'	; automatic setting flag (for completed indication)
LOW_RES		equ	H'42'	; low resolution flag
MIN_RANGE	equ	H'43'	; duration to stop signal
NEW_STORE	equ	H'44'	; temporary store
TEMP_C		equ	H'45'	; calculation divisor or numerator
SWITCH_STO	equ	H'46'	; last switch setting
TOGGLE_FLG	equ	H'47'	; toggle flag
AUTO_SET_FLG	equ H'48'; autoset flag
EDGE_INT	equ	H'49'	; edge interrupt flag
	
; math routines

TEMPB1      equ H'62'
TEMPB0      equ H'63'
TEMPD       equ H'64'    ; temporary storage
AARGB3		equ	H'65'
AARGB2      equ H'66'
AARGB1      equ H'67'
AARGB0      equ H'68'	; most significant byte of argument A
    
BARGB1      equ H'69'
BARGB0      equ H'6A'	; most significant byte of argument B
    
REMB1       equ H'6B'
REMB0       equ H'6C'   ; most significant byte of remainder
LOOPCOUNT   equ H'6D'   ; loop counter
STO1	    equ	H'6E'	; AARGB1 storage
STO2		equ	H'6F'	; AARGB2 storage

; All Banks RAM
ST_ADR		equ	H'70'	; storage of EEPROM Address during interrupt
EDTA_ST		equ	H'71'	; EEPROM data store
W_TMP		equ	H'72'	; storage of w before interrupt
STATUS_TMP	equ	H'73'	; status storage before interrupt
WRITE_FLAG	equ	H'74'	; flag to indicate when EEPROM write in progress
PORT_A4		equ	H'75'	; portA,4 status

; preprogram EEPROM DATA 
	
	ORG     2100
	DE	B'00000000'		; RA2 pullup if high, RA3 pulldown if high, RA4 input more sensitive if high 
	DE	B'00000000'		; bit 0 for fast/slow 
	DE	B'00000000'		; low resolution. set bit 0 at 1 for slow speeds
	DE	B'01000000'		; minimum of 0.5 second before signal goes off after loss of signal

; define reset and interrupt vector start addresses

	org	0	 		 	; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org     4			; interrupt vector 0004h, start interrupt routine here
	goto	INTRUPT		; go to start of interrupt routine, bypass subroutines

; subroutine to get multiplier/divisor depending on fast or slow rate

DIVSR
	addwf	PCL,f		; add value of switch settings to program counter
	retlw	D'100'		; 0 0% rate (fast) or 0% (slow)
	retlw	D'101'		; 1 1% fast or 1% slow
	retlw	D'102'		; 2 2%
	retlw	D'103'		; 3 3% rate
	retlw	D'104'		; 4 4% rate
	retlw	D'105'		; 5 5% rate
	retlw	D'106'		; 6 6% rate
	retlw	D'107'		; 7 7% rate
	retlw	D'108'		; 8 8% rate
	retlw	D'109'		; 9 9% rate

	retlw	D'109'		; A not part of 0 to 9 coded switch
	retlw	D'109'		; B 
	retlw	D'109'		; C
	retlw	D'109'		; D
	retlw	D'109'		; E
	retlw	D'109'		; F

	retlw	D'110'		; 10 10% rate
	retlw	D'111'		; 11 11% rate
	retlw	D'112'		; 12 12% rate
	retlw	D'113'		; 13 13% rate
	retlw	D'114'		; 14 14% rate
	retlw	D'115'		; 15 15% rate
	retlw	D'116'		; 16 16% rate
	retlw	D'117'		; 17 17% rate
	retlw	D'118'		; 18 18% rate
	retlw	D'119'		; 19 19% rate

	retlw	D'119'		; 1A 
	retlw	D'119'		; 1B 
	retlw	D'119'		; 1C 
	retlw	D'119'		; 1D 
	retlw	D'119'		; 1E 
	retlw	D'119'		; 1F 

	retlw	D'120'		; 20 20% rate
	retlw	D'121'		; 21 21% rate
	retlw	D'122'		; 22 22% rate
	retlw	D'123'		; 23 23% rate
	retlw	D'124'		; 24 24% rate
	retlw	D'125'		; 25 25% rate
	retlw	D'126'		; 26 26% rate
	retlw	D'127'		; 27 27% rate
	retlw	D'128'		; 28 28% rate
	retlw	D'129'		; 29 29% rate

	retlw	D'129'		; 2A 
	retlw	D'129'		; 2B 
	retlw	D'129'		; 2C
	retlw	D'129'		; 2D
	retlw	D'129'		; 2E
	retlw	D'129'		; 2F

	retlw	D'130'		; 30 30% rate
	retlw	D'131'		; 31 31% rate
	retlw	D'132'		; 32 32% rate
	retlw	D'133'		; 33 33% rate
	retlw	D'134'		; 34 34% rate
	retlw	D'135'		; 35 35% rate
	retlw	D'136'		; 36 36% rate
	retlw	D'137'		; 37 37% rate
	retlw	D'138'		; 38 38% rate
	retlw	D'139'		; 39 39% rate

	retlw	D'139'		; 3A 
	retlw	D'139'		; 3B 	
	retlw	D'139'		; 3C 	
	retlw	D'139'		; 3D 
	retlw	D'139'		; 3E 
	retlw	D'139'		; 3F

	retlw	D'140'		; 40 40% rate
	retlw	D'141'		; 41 41% rate
	retlw	D'142'		; 42 42% rate
	retlw	D'143'		; 43 43% rate
	retlw	D'144'		; 44 44% rate
	retlw	D'145'		; 45 45% rate
	retlw	D'146'		; 46 46% rate
	retlw	D'147'		; 47 47% rate
	retlw	D'148'		; 48 48% rate
	retlw	D'149'		; 49 49% rate

	retlw	D'149'		; 4A 
	retlw	D'149'		; 4B 	
	retlw	D'149'		; 4C 	
	retlw	D'149'		; 4D 
	retlw	D'149'		; 4E 
	retlw	D'149'		; 4F

	retlw	D'150'		; 50 50% rate
	retlw	D'151'		; 51 51% rate
	retlw	D'152'		; 52 52% rate
	retlw	D'153'		; 53 53% rate
	retlw	D'154'		; 54 54% rate
	retlw	D'155'		; 55 55% rate
	retlw	D'156'		; 56 56% rate
	retlw	D'157'		; 57 57% rate
	retlw	D'158'		; 58 58% rate
	retlw	D'159'		; 59 59% rate

	retlw	D'159'		; 5A 
	retlw	D'159'		; 5B 	
	retlw	D'159'		; 5C 	
	retlw	D'159'		; 5D 
	retlw	D'159'		; 5E 
	retlw	D'159'		; 5F
	
	retlw	D'160'		; 60 60% rate
	retlw	D'161'		; 61 61% rate
	retlw	D'162'		; 62 62% rate
	retlw	D'163'		; 63 63% rate
	retlw	D'164'		; 64 64% rate
	retlw	D'165'		; 65 65% rate
	retlw	D'166'		; 66 66% rate
	retlw	D'167'		; 67 67% rate
	retlw	D'168'		; 68 68% rate
	retlw	D'169'		; 69 69% rate

	retlw	D'169'		; 6A 
	retlw	D'169'		; 6B 	
	retlw	D'169'		; 6C 	
	retlw	D'169'		; 6D 
	retlw	D'169'		; 6E 
	retlw	D'169'		; 6F

	retlw	D'170'		; 70 70% rate
	retlw	D'171'		; 71 71% rate
	retlw	D'172'		; 72 72% rate
	retlw	D'173'		; 73 73% rate
	retlw	D'174'		; 74 74% rate
	retlw	D'175'		; 75 75% rate
	retlw	D'176'		; 76 76% rate
	retlw	D'177'		; 77 77% rate
	retlw	D'178'		; 78 78% rate
	retlw	D'179'		; 79 79% rate

	retlw	D'179'		; 7A 
	retlw	D'179'		; 7B 	
	retlw	D'179'		; 7C 	
	retlw	D'179'		; 7D 
	retlw	D'179'		; 7E 
	retlw	D'179'		; 7F
	
	retlw	D'180'		; 80 80% rate
	retlw	D'181'		; 81 81% rate
	retlw	D'182'		; 82 82% rate
	retlw	D'183'		; 83 83% rate
	retlw	D'184'		; 84 84% rate
	retlw	D'185'		; 85 85% rate
	retlw	D'186'		; 86 86% rate
	retlw	D'187'		; 87 87% rate
	retlw	D'188'		; 88 88% rate
	retlw	D'189'		; 89 89% rate

	retlw	D'189'		; 8A 
	retlw	D'189'		; 8B 	
	retlw	D'189'		; 8C 	
	retlw	D'189'		; 8D 
	retlw	D'189'		; 8E 
	retlw	D'189'		; 8F
	
	retlw	D'190'		; 90 90% rate
	retlw	D'191'		; 91 91% rate
	retlw	D'192'		; 92 92% rate
	retlw	D'193'		; 93 93% rate
	retlw	D'194'		; 94 94% rate
	retlw	D'195'		; 95 95% rate
	retlw	D'196'		; 96 96% rate
	retlw	D'197'		; 97 97% rate
	retlw	D'198'		; 98 98% rate
	retlw	D'199'		; 99 99% rate

	retlw	D'200'		; 9A 100% 
	retlw	D'200'		; 9B 	
	retlw	D'200'		; 9C 	
	retlw	D'200'		; 9D 
	retlw	D'200'		; 9E 
	retlw	D'200'		; 9F	
;******************************************************************************************* 
; INTERRUPT
; counts time between pulses
; start interrupt by saving w and status registers before altered by interrupt routine

INTRUPT	
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 

	bcf		STATUS,RP0	; select bank 0

	bcf		INTCON,T0IF	; clear timer interrupt flag
				; freq is approx 20MHz/4/256-220/(4) ~ 34kHz
	
	movlw	D'220'		; speed up timer interrupt rate 
	movwf	TMR0

	btfsc	FLAG_0,2	; overrange flag
	bcf		PORTA,0		; output low on overrange

; count between positive edges
CNT_P
	btfss	INTCON,INTF	; Intcon INTF flag set on edge detect on RB0 (see option register)
	goto	COUNT		; not so bypass
	bsf		EDGE_INT,0
	 
;	bcf		INTCON,INTF	; clear interrupt flag

; automatic setup input record
	incf	AUTO_COUNT,w; 
	btfss	STATUS,Z	; if at maximum (FF) or zero when incremented by 1 stop increasing
	incf	AUTO_COUNT,f; increase if not at maximum
	btfsc	AUTO_SET_FLG,0
	goto	RECLAIM		; bypass on autoset

; check for low resolution
	btfsc	LOW_RES,0	; 0 for 2 counts; 1 for 1 count
	goto	XFER
; 2 counts for sufficient resolution at higher frequencies
	btfsc	FLAG_I,0	; counted two cycles
	goto	XFER
	btfss	FLAG_0,2	; if set start with new count
	goto	COUNT_S

XFER
	bcf		FLAG_0,3
	movf	COUNT1,w
	movwf	COUNT3		; latch value for processing
	movf	COUNT2,w
	movwf	COUNT4		; latch value for processing
; Check range

	bcf		STATUS,C
	rrf		MIN_RANGE,w
	subwf	COUNT2,w
	btfss	STATUS,C	; overrange if over
	bcf		FLAG_0,2	; clear when below overflow

CLR_CNT
	clrf	FLAG_I		; count repeat flag
	clrf	COUNT1
	incf	COUNT1,f
	clrf	COUNT2		; clear for recount
	bcf		FLAG_0,0	; clear overrange flag
	goto	CHEK_CT

COUNT_S
	bsf		FLAG_I,0	; increment to indicate next count
COUNT
	btfsc	FLAG_0,3	; if overrange stop count
	goto	RECLAIM		; 
	incfsz	COUNT1,f	; increment least significant byte
	goto	CHEK_CT 	; check count value
	incf	COUNT2,f	; if zero flag overrange

; check range
	movf	MIN_RANGE,w
	subwf	COUNT2,w
	btfss	STATUS,C	; overrange if over
;	btfss	COUNT2,6
	goto	CHEK_CT 	; check count value
	bsf		FLAG_0,0	; flag set if overrange	
	bsf		FLAG_0,1	; set valid flag
	bsf		FLAG_0,2
	bsf		FLAG_0,3
	bcf		PORTA,0		; output low
	goto	RECLAIM

; check counter
 
; one counter gives the low output and second gives high output duration
 
CHEK_CT
	btfss	FLAG_0,2	; overrange flag
;	btfss	FLAG_0,1	; valid flag
	goto	DIV_2
	bcf		PORTA,0		; output low
	goto	RECLAIM		; not valid so out

DIV_2
	incfsz	COUNTE,f	; increment least significant byte
	goto	COMP	 	; check count value
	incf	COUNTF,f	; 
COMP
	movf	COUNTE,w	; ls counter
	xorwf	COUNT9,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	CHK_HL2
	movf	COUNTF,w	; ms counter
	xorwf	COUNT10,w
	btfss	STATUS,Z	; if equal reset values
	goto	CHK_HL2
	btfss	FLAG_0,2
	bsf		PORTA,0		; RA0 output high
	
; transfer calculated values

	clrf	COUNTE		; reset counter
	clrf	COUNTF
	movf	CALC2,w 	; ms counter byte full output
	movwf	COUNT10
	movf	CALC1,w
	movwf	COUNT9
	
	movf	COUNT6,w	; ms counter byte halfway count
	movwf	COUNT8
	movf	COUNT5,w
	movwf	COUNT7

	movf	COUNTB,w	; ms counter byte 1/4 way count
	movwf	COUNT12
	movf	COUNTA,w
	movwf	COUNT11

	movf	COUNTD,w	; ms counter byte 3/4 way count
	movwf	COUNT14
	movf	COUNTC,w
	movwf	COUNT13
	goto	RECLAIM

; 1/2, 1/4 and 3/4 check tests

CHK_HL2	
	btfsc	LOW_RES,0
	goto	OUT_LOW_RES
	movf	COUNTE,w	; ls counter
	xorwf	COUNT7,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	CHK_HL4
	movf	COUNTF,w	; ms counter
	xorwf	COUNT8,w
	btfss	STATUS,Z	; if equal reset values
	goto	CHK_HL4
	btfss	FLAG_0,2
	bsf		PORTA,0		; output high

CHK_HL4	
	movf	COUNTE,w	; ls counter
	xorwf	COUNT11,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	CK_34
	movf	COUNTF,w	; ms counter
	xorwf	COUNT12,w
	btfss	STATUS,Z	; if equal reset values
	goto	CK_34	
	bcf		PORTA,0		; output low

CK_34
	movf	COUNTE,w	; ls counter
	xorwf	COUNT13,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	RECLAIM
	movf	COUNTF,w	; ms counter
	xorwf	COUNT14,w
	btfss	STATUS,Z	; if equal reset values
	goto	RECLAIM
	bcf		PORTA,0		; output low
	goto	RECLAIM

OUT_LOW_RES
	movf	COUNTE,w	; ls counter
	xorwf	COUNT7,w
	btfss	STATUS,Z	; if the same check ms byte
	goto	RECLAIM
	movf	COUNTF,w	; ms counter
	xorwf	COUNT8,w
	btfsc	STATUS,Z	; if equal reset values
	bcf		PORTA,0		; output low

; end of interrupt reclaim w and status 

RECLAIM	
	btfsc	EDGE_INT,0
	bcf		INTCON,INTF	; clear interrupt flag
	bcf		EDGE_INT,0
	btfsc	FLAG_0,2	; overrange flag
	bcf		PORTA,0		; output low
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register

	retfie
;********************************************************************************************** 
  	
; RESET		
; Set ports A & B

MAIN
	clrf	COUNT1
	clrf	COUNT2
	clrf	COUNT3
	clrf	COUNT4
	clrf	COUNT5
	clrf	COUNT6
	clrf	TOGGLE_FLG	; toggle flag
	bsf		FLAG_0,0	; overrange flag
	bsf		FLAG_0,1	; valid flag
	clrf	FLAG_I		; extra count flag
	clrf	SET_FLG		; auto set flag
	clrf	SWITCH_STO	; switch storage

	movlw	B'00000000'	; RA oputputs low
	movwf	PORTA
	movlw	H'07'		; comparators off
	movwf	CMCON		; I/O pins
	
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11111111'	; RB0 - RB7 inputs
	movwf	TRISB		; port B data direction register
	movlw	B'01000001'	; 10MHz 010000000, change to 01000001 for 20MHz 
	movwf	OPTION_REG	; TMRO prescaler 4 division, PORTB pullups enabled
	movlw   B'00000010'	; RA1 input, RA0,2,3,4 ouputs
	movwf   TRISA		; A port data direction register
	bcf		STATUS,RP0	; select memory bank 0

; read EEPROM values
	movlw	EEPROM1		; fast or slow
	call	EEREAD		; get value
	movwf	FAST_SLOW

	movlw	EEPROM2		; low resolution
	call	EEREAD		; get value
	movwf	LOW_RES

	movlw	EEPROM3		; minimum duration to stop signal
	call	EEREAD		; get value
	movwf	MIN_RANGE

	movlw	EEPROM0		; pullup/pulldown/sensitivity settings
	call	EEREAD		; get value
	movwf	PORTA		; set outputs
	movwf	PORT_A4		; for porta,4 status
	call	SET_RA4_IN	; set RA4 as input or output
	goto	ALL_INTER

; set RA4 as input or output if required
SET_RA4_IN
	bsf		STATUS,RP0	; select memory bank 1
	movlw   B'00000010'	; RA1 input, RA0,2,3,4 ouputs
	btfsc	PORT_A4,4	; if set then input
	movlw   B'00010010'	; RA1,4 input, RA0,2,3 ouputs
	movwf   TRISA		; A port data direction register
	bcf		STATUS,RP0	; select memory bank 0
	return

; allow interrupts
ALL_INTER
	bcf		INTCON,T0IF
	bcf		EDGE_INT,0
;	bsf		INTCON,INTE
	bsf		INTCON,T0IE	; set interrupt enable for timer
	bsf		INTCON,GIE	; set global interrupt enable 

; read switch inputs 

RD_SW 
	clrf	TEMP_1		; start by clearing TEMP_1
; bit 0
	btfss	PORTB,6		; for ls bit of switches
	bsf		TEMP_1,0	; if low set bit0 in TEMP_1
; bit 1	
	btfss	PORTB,4		; for bit 1 of switches
	bsf		TEMP_1,1	; if low set bit1 in TEMP_1
; bit 2	
	btfss	PORTB,5		; for bit 2 of switches
	bsf		TEMP_1,2	; if low set bit2 in TEMP_1
; bit 3	
	btfss	PORTB,7		; for bit 3 of switches
	bsf		TEMP_1,3	; if low set bit3 in TEMP_1
; bit 4	
	btfss	PORTB,2		; for bit 4 of switches
	bsf		TEMP_1,4	; if low set bit4 in TEMP_1
; bit 5	
	btfss	PORTB,1		; for bit 5 of switches
	bsf		TEMP_1,5	; if low set bit5 in TEMP_1
; bit 6	
	btfss	PORTA,1		; for bit 6 of switches
	bsf		TEMP_1,6	; if low set bit6 in TEMP_1
; bit 7	
	btfss	PORTB,3		; for bit 7 of switches
	bsf		TEMP_1,7	; if low set bit7 in TEMP_1

	movf	TEMP_1,w
	subwf	SWITCH_STO,w; compare with store switch setting
	btfsc	STATUS,Z	; if the same continue if different add delay and bypass switch value
	goto	CK_10S	
	call	DELAY1
	movf	TEMP_1,w	; switch values
	movwf	SWITCH_STO	; store value
	goto	RD_SW		; read switch again

; check if 10's switch set at A to F
CK_10S
	movf	TEMP_1,w	; switch values
	movwf	SWITCH_STO	; store value
	andlw	B'11110000'	; strip out ls bits
	movwf	SWITCH_SET	; F0 toggle faster/slower, E0 no pullup or pulldown low sensitivity
						; D0 pull down, C0 AC input, B0 pullup, A0 auto set 

	xorlw 	H'F0'		; faster slower
	btfsc	STATUS,Z	; if equal
	goto	F_S_TOGGLE	; 

	clrf	TOGGLE_FLG	; toggle flag clear
	movf	SWITCH_SET,w
	xorlw 	H'A0'		; auto set
	btfsc	STATUS,Z	; if equal
	goto	AUTO_SET

	clrf	AUTO_SET_FLG	; auto set flag

	bsf		INTCON,GIE	; enable global interrupt
	clrf	SET_FLG		; auto set flag cleared
	movf	SWITCH_SET,w	
	xorlw 	H'E0'		; no pullup or pulldown resistors
	btfsc	STATUS,Z	; if equal
	goto	NO_PULLUP_DN; 

	movf	SWITCH_SET,w	
	xorlw 	H'D0'		; pulldown resistor
	btfsc	STATUS,Z	; if equal
	goto	PULL_DN		;

	movf	SWITCH_SET,w	
	xorlw 	H'C0'		; AC input
	btfsc	STATUS,Z	; if equal
	goto	AC_IN		;

	movf	SWITCH_SET,w	
	xorlw 	H'B0'		; pullup resistor
	btfsc	STATUS,Z	; if equal
	goto	PULL_UP		;

	movf	TEMP_1,w	; switch value
	movwf	TEMP_C		; calculation value

; if overrange flag set then bypass calc
FLG_CK
;	btfss	FLAG_0,0
	goto	DO_CALC
;	bcf		PORTA,0		; LED off	
;	goto	RD_SW

; toggle fast or slow setting
F_S_TOGGLE
	btfsc	TOGGLE_FLG,0; if already set bypass changes	
	goto	LED_ACK
	bsf		TOGGLE_FLG,0; toggle flag
	bcf		INTCON,GIE	; disable interrupt	
	movlw	EEPROM1		; fast or slow
	call	EEREAD		; get value
	movwf	FAST_SLOW
	incf	FAST_SLOW,f	; toggle bit 0
	movf	FAST_SLOW,w
	call	EWRITE		; store in EEPROM
	bcf		INTCON,GIE	; disable interrupt
	bcf		PORTA,0		; output LED off
	movlw	D'10'		; delay
	call	DELAY_1
; LED flash acknowledge
LED_ACK
	bcf		PORTA,0		; output LED off
	movlw	D'5'		; delay
	call	DELAY_1
	bsf		PORTA,0		; output LED on
	movlw	D'5'		; delay
	call	DELAY_1
	btfss	FAST_SLOW,0	; if set do again
	goto	STOP_CHNG
	bcf		PORTA,0		; LED off
	movlw	D'5'		; delay
	call	DELAY_1
	bsf		PORTA,0		; output LED on
	movlw	D'5'		; delay
	call	DELAY_1
	
STOP_CHNG
	bcf		PORTA,0		; output LED off
	call	DELAY
	goto	RD_SW

; no pullup or pulldown resistors
NO_PULLUP_DN
	bcf		PORTA,2		; RA2,3,4 low and keep RA0 Pullup and pulldown off and low sensitivity
	bcf		PORTA,3
	bcf		PORTA,4	
	bcf		PORT_A4,4	; PORTA,4 status
	call	SET_RA4_IN	; set RA4 as input or output

DUPLICATE
	movf	PORTA,w
	andlw	B'00001100'	; keep RA2,3
	movwf	PORTA_STO
	call	SET_RA4_IN	; set RA4 as input or output

; porta,4 check
	btfsc	PORT_A4,4	; if set, set
	bsf		PORTA_STO,4	; set 
	
	movlw	EEPROM0		; settings
	call	EEREAD		; sets EEADR, data in w
; compare values
	xorwf	PORTA_STO,w	; compare if the same do not reprogram EEPROM
	btfsc	STATUS,Z	; if the same do not write
	goto	BY_WRITE
	movf	PORTA_STO,w	; value
	call	EWRITE		; store value
BY_WRITE
	movlw	D'100'		; output 100%
	movwf	TEMP_C
FLG_CK1
	btfss	FLAG_0,0	; overrange flag
	goto	CALC
	bcf		PORTA,0		; LED off
	goto	RD_SW

; pull down resistor
PULL_DN
	bcf		PORTA,2		; 
	bsf		PORTA,3
	bcf		PORTA,4		; ensure RA2,4 are low
						; RA3 high
	bcf		PORT_A4,4	; PORTA,4 status
	goto	DUPLICATE

; ac signal
AC_IN
	bcf		PORTA,2		; 
	bcf		PORTA,3
	bsf		PORTA,4		; ensure RA2,3 are low
						; RA4 high high sensitivity
	bsf		PORT_A4,4	; PORTA,4 status
	goto	DUPLICATE

; pullup resistor
PULL_UP
	bsf		PORTA,2		; 
	bcf		PORTA,3
	bcf		PORTA,4		; ensure RA3,4 are low
						; RA2 high 
	bcf		PORT_A4,4	; PORTA,4 status
	goto	DUPLICATE

; Automatic setup of input (clear AUTO_COUNT, delay check if auto count > 20)
AUTO_SET
	bsf		AUTO_SET_FLG,0
	movf	SET_FLG,w	; is flag set
	btfss	STATUS,Z	; if zero continue
	goto	ACK_AUTOSET	; acknowledge auto set

; start by changing the resolution depending on S1 setting
; check Switch 1 settings
	bcf		INTCON,GIE	; disable interrupt	
	movlw	EEPROM2		; resolution
	call	EEREAD		; get value
	movf	SWITCH_STO,w
	movwf	LOW_RES
	call	EWRITE		; store in EEPROM

; get min duration
	bcf		INTCON,GIE	; disable interrupt	
	clrf	MIN_RANGE	; min duration
	movf	SWITCH_STO,w
	andlw	B'00001110'	; get 0-9 values
	movwf	NEW_STORE
	xorlw	B'00000000'	; zero
	btfsc	STATUS,Z	; if the same set 	
	bsf		MIN_RANGE,7	; bit 7
	movf	NEW_STORE,w
	xorlw	B'00000010'	; 2 or 3
	btfsc	STATUS,Z	; if the same set 	
	bsf		MIN_RANGE,6	; bit 6
	movf	NEW_STORE,w
	xorlw	B'00000100'	; 4 or 5
	btfsc	STATUS,Z	; if the same set 	
	bsf		MIN_RANGE,5	; bit 5
	movf	NEW_STORE,w
	xorlw	B'00001100'	; 6 or 7
	btfsc	STATUS,Z	; if the same set 	
	bsf		MIN_RANGE,4	; bit 4
	movf	NEW_STORE,w
	xorlw	B'00001000'	; 8 or 9
	btfsc	STATUS,Z	; if the same set 	
	bsf		MIN_RANGE,3	; bit 3

; write
	bcf		INTCON,GIE	; disable interrupt	
	movlw	EEPROM3		; min duration
	call	EEREAD		; get value
	movf	MIN_RANGE,w
	call	EWRITE		; store in EEPROM

; set no pullup/down	
CHANGE_1				; next setting
	bcf		PORTA,0		; output LED off
	bcf		PORTA,2		; no pullup
	bcf		PORTA,3		; no pulldown
	bcf		PORTA,4		; low sensitivity
	bcf		PORT_A4,4	; PORTA,4 status
	call	SET_RA4_IN	; set RA4 as input or output
	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	CHANGE_2	; next setting
; this setting is good. Save setting and set flag so do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set
	goto	ACK_AUTOSET

; ac
CHANGE_2
	bcf		PORTA,0		; output LED off
	bcf		PORTA,2		; no pullup
	bcf		PORTA,3		; no pulldown
	bsf		PORTA,4		; high sensitivity
	bsf		PORT_A4,4	; PORTA,4 status
	call	SET_RA4_IN	; set RA4 as input or output
	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	CHANGE_3	; next setting
; this setting is good. Save setting and set flag so do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set
	goto	ACK_AUTOSET

; set pullup
CHANGE_3				; next setting
	bcf		PORTA,0		; output LED off
	bsf		PORTA,2		; pullup
	bcf		PORTA,3		; no pulldown
	bcf		PORTA,4		; low sensitivity
	bcf		PORT_A4,4	; PORTA,4 status
	call	SET_RA4_IN	; set RA4 as input or output
	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	CHANGE_4	; next setting
; this setting is good. Save setting and set flag so do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set
	goto	ACK_AUTOSET

; set pulldown
CHANGE_4				; next setting
	bcf		PORTA,0		; output LED off
	bcf		PORTA,2		; no pullup
	bsf		PORTA,3		; pulldown
	bcf		PORTA,4		; low sensitivity
	bcf		PORT_A4,4	; PORTA,4 status
	call	SET_RA4_IN	; set RA4 as input or output
	clrf	AUTO_COUNT	; clear counter
	call	DELAY		; wait and check counter
	movf	AUTO_COUNT,w; count value
	sublw	D'20'		; 
	btfsc	STATUS,C	; if c is 0 then negative and w >20
	goto	RD_SW		; check switch again

; this setting is good. Save setting and set flag so do not keep changing
	bsf		SET_FLG,0	; set bit to stop auto set

ACK_AUTOSET
; acknowledge end of auto set
	bcf		INTCON,GIE	; stop interrupt 
	bcf		PORTA,0		; output LED off
	movlw	D'5'		; delay
	call	DELAY_1
	bsf		PORTA,0		; output LED on
	movlw	D'5'		; delay
	call	DELAY_1
	bcf		PORTA,0		; output LED off
	goto	DUPLICATE

; do calculations
DO_CALC
	movf	TEMP_C,w	; 
	call	DIVSR		; get divisor value (lookup table)
	movwf	TEMP_C		; store

; update value
; multiply by 100 or percentage depending on if for faster or slower output rate
; divide by percentage or 100
; 
	
CALC
	clrf	AARGB0		; clear
	btfss	FAST_SLOW,0	; if set faster rate
	goto	SLWR
	movlw	D'100'		; %
	movwf	AARGB1
	goto	STP_INT
SLWR
	movf	TEMP_C,w	; divisor
	movwf	AARGB1
	
; check if interrupt about to occur

STP_INT	
	movf	TMR0,w		; look at timer 
	sublw	D'240'		; only proceed when timer less than 240 as interrupt could occur 	
						; when transferring data
	btfss	STATUS,C	; if c = 0 then timer greater than 240
	goto	STP_INT		;
	bcf		INTCON,GIE
	movf	COUNT3,w	; latched counted value
	movwf	BARGB1
	movf	COUNT4,w
	movwf	BARGB0
	bsf		INTCON,GIE
	call	FXM1616U	; multiply 

; shift answer
	movf	AARGB2,w	; second ls byte of result
	movwf	STO1
	movf	AARGB3,w
	movwf	AARGB2
	movf	AARGB1,w
	movwf	AARGB0
	movf	STO1,w
	movwf	AARGB1
	
; load denominator

	btfsc	FAST_SLOW,0	; if set faster rate	
	goto	SLOWR
	movlw	D'100'		; %
	goto	FSTER
SLOWR
	movf	TEMP_C,w	; divisor
FSTER
	movwf	BARGB1
	clrf	BARGB0
	call	FXD2416U	; divide 

SOP_INT
	movf	TMR0,w		; look at timer 
	sublw	D'240'		; only proceed when timer less than 240 as interrupt could occur 	
						; when transferring data
	btfss	STATUS,C	; if c = 0 then timer greater than 240
	goto	SOP_INT		;
	bcf		INTCON,GIE
	movf	AARGB2,w	; move values
	movwf	CALC1
	movf	AARGB1,w
	movwf	CALC2

	bcf		STATUS,C
	rrf		CALC2,w 	; ms counter byte (find halfway count)
	movwf	COUNT6
	rrf		CALC1,w
	movwf	COUNT5

	bcf		STATUS,C
	rrf		COUNT6,w 	; ms counter byte (1/4 way count)
	movwf	COUNTB
	rrf		COUNT5,w
	movwf	COUNTA
	
	movf	COUNTA,w	; subtract 1/4 way from CALC1,2 for 3/4 way
	movwf	BARGB1
	movf	COUNTB,w
	movwf	BARGB0		
	call	D_RSUB		; subtract answer in AARGB	
	
	movf	AARGB2,w	; move values
	movwf	COUNTC
	movf	AARGB1,w
	movwf	COUNTD		; count C & D have 3/4 count
	bsf		INTCON,GIE	
; after calculation, 
; clear valid flag

	bcf		FLAG_0,1	
	goto	RD_SW

; ********************************************************************************

; delay time 
DELAY1
	movlw	D'10'
	goto	DELAY_1

DELAY
	movlw	D'50'		; number of delay cycles
DELAY_1	
	movwf	DELCNT
	bcf		STATUS,C	; carry cleared 
	rlf		DELCNT,f	; mult by 2 for 20MHz xtal (not for 10MHz)
DELAY_M
	movlw	D'255'		; set delay period 
	movwf	VALUE_1		; VALUE_1 = w
LP_1
	movlw	D'255'		; set delay period value 2 
	movwf	VALUE_2		; VALUE_2 = w
LP_2
	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1
	decfsz	DELCNT,f
	goto	DELAY_M
	return	

; subroutine to read EEPROM memory 

EEREAD
	bsf 	STATUS,RP0	; select memory bank 1
	movwf 	EEADR		; indirect special function register
	bsf		EECON1,RD	; read EEPROM
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP0	; select bank 0
	return


; EEPROM write 

EWRITE
	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf		STATUS,RP0	; select bank 1
	movwf	EEDATA		; data register
WR4	btfsc	EECON1,WR	; check if write complete 
	goto 	WR4			; not written yet
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE1	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank 0
	bsf		INTCON,GIE	; set global interrupt enable  
	return				; value written 

	
; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U        CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1, F
                MOVF            BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                RLF             AARGB0, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LA 		RLF             AARGB0, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMPD, F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L8         RLF             AARGB1, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LB         RLF             AARGB1, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46L16        RLF             AARGB2, F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMPD, F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD, F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD, F
UOK46LC 		RLF             AARGB2, F
                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        	ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
UOK46L			RETURN
	
; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0



FXM1616U        CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
                RETLW   H'00'
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  H'08'
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
                RETURN

; subroutine subtract AARGB1 AARGB2 - BARGB0 BARGB1 = AARGB
	
	
D_RSUB
	call	NEG_A		; complement of A
	movf	BARGB1,w 
	addwf	AARGB2,f 	; add lsb
	btfsc	STATUS,C	; add carry
	incf	AARGB1,f 
	movf	BARGB0,w 
	addwf	AARGB1,f 
	return

NEG_A
	comf	BARGB1,f 
	incf	BARGB1,f 
	btfsc	STATUS,Z
	decf	BARGB0,f 
	comf	BARGB0,f 
	return	

	
	
	end	
