; Power Tool Charger Controller 

	list P=16F88
	#include p16f88.inc
	ERRORLEVEL -302
	ERRORLEVEL -306

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations

EEPROM0			equ	H'00'	; non-volatile storage for charge status
EEPROM1			equ	H'01'	; non-volatile storage for timeout
EEPROM2			equ	H'02'	; non-volatile storage for timeout

; Bank 0 RAM
; A/D values
TIMEOUT			equ	H'20'	; timeout value
TRICKLE			equ	H'21'	; trickle value
DELTA_TEMP		equ	H'22'	; change in temperature
THERMISTOR		equ	H'23'	; thermistor value 
ADCOUNT			equ	H'24'	; A/D address counter 
; General
TIMERH			equ	H'25'	; ms byte of timer
TIMERL			equ	H'26'	; ls byte of timer
FLASHER			equ	H'27'	; LED flasher timer 
LOOP_COUNT		equ	H'28'	; update A/D counter
CHARGE_STATE	equ	H'29'	; charge status
EEWRITE_TIMER	equ	H'2A'	; eewrite counter every 8-minutes
TIMES_5			equ	H'2B'	; times 5 timer
DELTA_TIMER		equ	H'2C'	; delta Temp timer	
STORE1			equ	H'2D'	; delay timer store
STORE2			equ	H'2E'	; delay timer store
STO_NTC			equ	H'2F'	; thermistor storeed value
NTC_COUNT		equ	H'30'	; time between NTC storage
THERM_COUNT		equ	H'31'	; thermistor count

; Math
AARGB0			equ	H'60'	; ms multiplier
AARGB1			equ	H'61'	; ls multiplier
BARGB0			equ	H'62'	; ms multiplier
LOOPCOUNT		equ	H'63'	; counter
AARGB3			equ	H'64'	; div routine
REMB0			equ	H'65'	; remainder
TEMP1			equ	H'66'	; temporary register
			 
; All Banks RAM

W_TMP			equ	H'72'	; storage of w before interrupt
STATUS_TMP		equ	H'73'	; status storage before interrupt

; preprogram EEPROM DATA 
	
	ORG     2100
	DE	D'0'
	DE 	D'0'
	DE	D'0'

; start at memory 0
	org	0
	goto	SETUP
	org	4
	goto	INTERRUPT

; **********************************************************************************************

SETUP
	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11010001'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00110111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled, TMR0/256,negative edge interrupt)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00010111'	; AN0 to AN2 and AN4 are analog inputs
	movwf	ANSEL
	movlw	B'01000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'11000000'	; Fosc, channel etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00111000'	; 0011 for 500kHz
	movwf	OSCCON		; 500kHz osc
	bcf		STATUS,RP0	; select memory bank 0

	movlw	B'00000001'	; timer 1 fosc/4
	movwf	T1CON
	bsf		STATUS,RP0	; select memory bank 1		
	movlw	H'FE'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm set
	clrf	CCPR1L		; duty 0% Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5	; clear 10-bits
	bsf		T2CON,2		; enable timer 2
	bsf		T2CON,1		; prescaler /16
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation
	
; initial conditions
	movlw	D'05'		; x 5
	movwf	TIMES_5
 	clrf	ADCOUNT		; A/D address count

; read EEPROM0 (charge state)
	movlw	EEPROM0
	call	EEREAD_NO_INTERRUPT	; sets EEADR
	movwf	CHARGE_STATE

; read EEPROM1 (timeout)
	movlw	EEPROM1
	call	EEREAD_NO_INTERRUPT	; sets EEADR
	movwf	TIMERH

; read EEPROM0 (timeout)
	movlw	EEPROM2
	call	EEREAD_NO_INTERRUPT	; sets EEADR
	movwf	TIMERL

; A/D conversion start and get A/D values before interrupt
	movlw	D'10'
	movwf	LOOP_COUNT	; counter	
REDO_AD					; redo A/D conversion
	call	ANALOG_AD
	decfsz	LOOP_COUNT,f
	goto	REDO_AD
	movlw	D'20'		; counts to initiate stored thermistor value
	movwf	THERM_COUNT	; thermistor count

; allow interrupts
	bsf		INTCON,INTE		; negative edge interrupt
	bcf		INTCON,INTF		; clear edge interrupt flag
	bsf		STATUS,RP0		; select memory bank 1
	bsf		PIE1,TMR1IE		; timer 1 overflow interrupt
	bcf		STATUS,RP0		; select memory bank 0
	bcf		PIR1,TMR1IF		; timer 1 interrupt flag
	bsf		INTCON,PEIE		; enable periperal interrupts 	 
	bsf 	INTCON,GIE		; set global interrupt enable 

CYCLE						; code cycle

; update A/D values
; A/D conversion
; set analog input address

	movlw	B'11000111'		; mask bits 5:3
	andwf	ADCON0,f		; set bits 5:3 to zero
	btfsc	ADCOUNT,0		; if bit 0 set then set bit 3 in ADCON0
	bsf		ADCON0,3
	btfsc	ADCOUNT,1		; if bit 1 set then set bit 4 in ADCON0
	bsf		ADCON0,4
	btfsc	ADCOUNT,2		; if bit 2 set,set bit 5
	bsf		ADCON0,5

	movf	ADCOUNT,w		; find address
	btfsc	STATUS,Z		; if zero
	goto	CH_0AD
	movf	ADCOUNT,w
	xorlw	0x01			; 1
	btfsc	STATUS,Z
	goto	CH_1AD
	movf	ADCOUNT,w
	xorlw	0x02			; 2
	btfsc	STATUS,Z
	goto	CH_2AD
	movf	ADCOUNT,w
	xorlw	0x03			; 3
	btfsc	STATUS,Z
	goto	CH_3AD
	movf	ADCOUNT,w
	xorlw	0x04			; 4
	btfsc	STATUS,Z
	goto	CH_4AD

; Channel 0 A/D value
CH_0AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV0
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV0
	movf	ADRESH,w
	movwf	TIMEOUT			; timeout value
	goto	NEW_ADDRESS		; end

; Channel 1 A/D value
CH_1AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV1
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV1
	movf	ADRESH,w
	movwf	TRICKLE			; trickle
	goto	NEW_ADDRESS		; end

; Channel 2 A/D value
CH_2AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV2
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV2
	movf	ADRESH,w
	movwf	DELTA_TEMP		; change in temperature
	goto	NEW_ADDRESS	; end

; Channel 3 A/D value
CH_3AD
	goto	NEW_ADDRESS		; end

; Channel 4 A/D value
CH_4AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV4
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV4
	movf	ADRESH,w
	movwf	THERMISTOR		; Thermistor value
	goto	NEW_ADDRESS		; end

; set new address
NEW_ADDRESS
	incf	ADCOUNT,f		; counter
	movf	ADCOUNT,w
	sublw	B'00000100'		; compare with 4,if positive or zero leave as is
	btfss	STATUS,C
	clrf	ADCOUNT			; back to zero
	goto	CYCLE

 ; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 
	
INTERRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 

	btfss	PIR1,TMR1IF		; timer 1 interrupt flag
	goto	CHECK_EDGE
	bcf		PIR1,TMR1IF		; clear flag
	movf	NTC_COUNT,w
	btfss	STATUS,Z		; when zero do not decrement
	decf	NTC_COUNT,f		; time between checking NTC thermistor
	incf	FLASHER,f		; flasher timer
	
; on overflow set timer to 62137 so 4x 1/500kHz = 8us. 8us x 62137 = update every .4971s 
; a/d value (0-5V) x 142 x .4971 = timeout
; 5V or 255 x 142 x .4971 = 18000 (18000/60/60 = 5hours)
 
	bcf		T1CON,TMR1ON	; stop timer
	movlw	H'0D'
	movwf	TMR1H			; timer high byte
	movlw	H'46'			; 
	movwf	TMR1L			; timer low byte
	bsf		T1CON,TMR1ON	; restart timer	

; measure change in temperature over time based on VR3
; STORE_NTC
	btfss	CHARGE_STATE,0	; check change in temperature when charging only
	goto	CK_NTC_OUT

; over 70 degrees
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'35'			; if <35 then 70 degrees
	btfsc	STATUS,C
	goto	CHARGE_END
; update thermistor value
	movf	THERM_COUNT,w
	btfsc	STATUS,Z	
	goto	CN_NTC
	decfsz	THERM_COUNT,f
	goto	CN_NTC
	movf	THERMISTOR,w	; get NTC value to storage for comparison
	movwf	STO_NTC
	goto	CK_NTC_OUT
CN_NTC
	movf	NTC_COUNT,w		; 
	btfss	STATUS,Z
	goto	CK_NTC_OUT
	movlw	D'121'
	movwf	NTC_COUNT		; 0.495833 x 121 = 60 seconds


; calculate delta T/time. Off when valid (goto CHARGE_END as per timer finished)
; base delta T depending on VR3 (DELTA_TEMP). If current value < previous by the factor then switch off.
; calculate temperature change based on DELTA_TEMP 5 degrees = a change of 10 for Thermistor
; so calculation is DELTA_TEMP /25. 5V for DELTA_TEMP is 255. So 255/25 = 10 or equivalent to 5 degrees
; 1V is 51. so 51/25 is 2 or equivalent to 1 degree. 0.5V gives 0.5 degrees  
	movf	DELTA_TEMP,w
	sublw	D'24'			; if less than 25 set at 1
	btfss	STATUS,C
	goto	SET_VAL1
	movf	DELTA_TEMP,w		
	movwf	AARGB1			; numerator
	clrf	AARGB0
	movlw	D'25'			; 25
	movwf	BARGB0
	call	DIV16_8
	goto	CK_DELTT
SET_VAL1
	movlw	D'01'
	movwf	AARGB1
CK_DELTT	
; check delta T/t (dT/dt)
 	movf	THERMISTOR,w
	subwf	STO_NTC,w	; subtract current from previous
	btfsc	STATUS,Z	; if zero ok
	goto	STO_THERM
	btfss	STATUS,C	; if negative ok
	goto	STO_THERM
	subwf	AARGB1,w
	btfss	STATUS,C	; if negative switch off
	goto	CHARGE_END	
STO_THERM
; store thermistor values between two time periods
	movf	THERMISTOR,w
	movwf	STO_NTC

CK_NTC_OUT
; if NTC out hold timers, Mosfet off and NTC LED on
; out of circuit
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'240'			; if >240 then NTC is out of circuit
	btfsc	STATUS,C		; if minus NTC out
	goto	CK_NTC_LO
	bsf		PORTB,2			; NTC LED on
	bcf		PORTB,1			; charge LED off
	clrf	CCPR1L			; mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	goto	CHECK_EDGE		; stop charging
CK_NTC_LO
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'197'			; if >197 then 0 degrees
	btfsc	STATUS,C		; if minus low temp
	goto	CK_OVR_70
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	btfss	FLASHER,1		; flash LED slowly
	goto	NTC_LED_OFF
	bsf		PORTB,2			; NTC LED on
	goto	CHECK_EDGE
NTC_LED_OFF
	bcf		PORTB,2			; NTC LED off
	bcf		PORTB,1			; charge LED off
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	goto	CHECK_EDGE

; compare temperature for over 70 deg C
CK_OVR_70
	movf	THERMISTOR,w	; NTC thermistor value
	sublw	D'35'			; if <35 then 70 degrees
	btfss	STATUS,C
	goto	CHRG_STATE_MOSFET
	bcf		PORTB,1			; charge LED off
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	btfss	FLASHER,0		; flash LED 
	goto	NTC_LED_OFF
	bsf		PORTB,2			; NTC LED on
	goto	CHECK_EDGE

CHRG_STATE_MOSFET
	bcf		PORTB,2			; NTC LED off
; check charge state and drive Mosfet accordingly
; CHARGE_STATE (bit 0 set = charge, bit 1 set = topup, bit 2 set = trickle)
; topup and trickle based on VR2 and LK3 and if LK2 in circuit
	btfsc	CHARGE_STATE,0
	goto	DRV_LEDS		; charge so bypass and drive led and mosfet
	btfss	CHARGE_STATE,1	; topup
	goto	MOSFET_TRICKLE
; topup drive mosfet at 4x the trickle duty
; calculate duty (link 3, portb,6 low = x 5)
	movf	TRICKLE,w		; 0-255 = 0-50 duty
	btfss	PORTB,6			; if low then x 5
	goto	BY_DIV5			; bypass divide by 5
	movwf	AARGB1
	clrf	AARGB0
	movlw	D'05'
	movwf	BARGB0			; divide by 5
	call	DIV16_8
	movf	AARGB1,w		; Trickle/5		
BY_DIV5
	movwf	BARGB0
	movf	BARGB0,w
	btfsc	STATUS,Z		; if zero load FF to PWM
	goto	LOAD_MAX

; divide duty cycle required into 255 to get PWM 	
	movlw	H'FF'
	movwf	AARGB1
	clrf	AARGB0
	call	DIV16_8			; divide
	movf	AARGB1,w
; multiply by 4
	movwf	AARGB0
	movlw	D'04'
	movwf	BARGB0
	call	EIGHTEIGHT
	movf	AARGB0,w
	btfss	STATUS,Z		; if zero ok
	goto	LOAD_MAX
	movf	AARGB1,w		; multiplier
	movwf	CCPR1L
	goto	DRV_LEDS
LOAD_MAX
	movlw	H'FF'
	movwf	CCPR1L
	goto	DRV_LEDS
LOAD_MIN
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	goto	DRV_LEDS
	
MOSFET_TRICKLE	
 	btfss	CHARGE_STATE,2	; trickle
	goto	DRV_LEDS
; calculate duty (link 3, portb,6 low = x 5)
	movf	TRICKLE,w		; 0-255 = 0-50 duty
	btfss	PORTB,6			; if low then x 5
	goto	BY_DIV_5		; bypass divide by 5
	movwf	AARGB1
	clrf	AARGB0
	movlw	D'05'
	movwf	BARGB0			; divide by 5
	call	DIV16_8
	movf	AARGB1,w		; Trickle/5		
BY_DIV_5
	movwf	BARGB0
	movf	BARGB0,w
	btfsc	STATUS,Z		; if zero load FF to PWM
	goto	LOAD_MAX
; divide duty cycle required into 255 to get PWM 	
	movlw	H'FF'
	movwf	AARGB1
	clrf	AARGB0
	call	DIV16_8			; divide
	movf	AARGB1,w
	movwf	CCPR1L
	
DRV_LEDS
; drive charge LED based on CHARGE_STATE (charge LED off when CHARGE_STATE is 0)
	movf	CHARGE_STATE,w
	btfss	STATUS,Z		; if zero LED off
	goto	OTHER_CHRG_FULL
	bcf		PORTB,1			; charge LED off
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits
	goto	CHECK_EDGE
OTHER_CHRG_FULL
	btfss	CHARGE_STATE,0	; if set full
	goto	OTHER_CHRG_TOPUP
	bsf		PORTB,1			; Charge LED on
	movlw	H'FF'
	movwf	CCPR1L			; Mosfet on
	bsf		CCP1CON,4
	bsf		CCP1CON,5		; set 10-bits
	goto	DEC_TIME
OTHER_CHRG_TOPUP
	btfss	CHARGE_STATE,1	; if set topup
	goto	OTHER_CHRG_TRICKLE
	btfss	FLASHER,0		; flash LED
	goto	TOP_FLSH 
	bsf		PORTB,1			; Charge LED on
	goto	DEC_TIME
TOP_FLSH
	bcf		PORTB,1			; Charge LED on
	goto	DEC_TIME
OTHER_CHRG_TRICKLE
	btfss	CHARGE_STATE,2	; if set trickle
	goto	DEC_TIME
	btfss	FLASHER,1		; flash LED
	goto	TRICKLE_FLSH 
	bsf		PORTB,1			; Charge LED on
	goto	DEC_TIME
TRICKLE_FLSH
	bcf		PORTB,1			; Charge LED on
	goto	DEC_TIME

DEC_TIME
; decrease timers
; check if x 5, check if topup
	btfsc	CHARGE_STATE,1	; bypass x 5 on topup
	goto	BY_X5
	btfsc	PORTB,7			; if x 5 link then decrease x 5 timer
	goto	BY_X5
	decfsz	TIMES_5,f
	goto	CHECK_EDGE
	movlw	D'5'			; x 5
	movwf	TIMES_5 
BY_X5	
	movf	TIMERH,w		; ms timer
	btfss	STATUS,Z		; if zero 
	goto	DEC_LOW
	movf	TIMERL,w		; ls byte of timer
	btfss	STATUS,Z
	goto	DEC_LOW			; do not decrease past 0
	movf	CHARGE_STATE,w	; if charger off bypass
	btfsc	STATUS,Z
	goto	CHARGER_OFF
	goto	CK_TOP_TRICK	; check topup or trickle	
DEC_LOW
; RB5 is timer test
	btfss	PORTB,5
	goto	CLR5
	bcf		PORTB,5
	goto	DEC_TMRHL
CLR5
	bsf		PORTB,5

DEC_TMRHL		
	decfsz	TIMERL,f		; if low byte zero decrease high byte
	goto	BYPASS_DEC
	movf	TIMERH,w
	btfsc	STATUS,Z		; if zero charge ended
	goto	CHARGE_END
	decfsz	TIMERH,f
	goto	BYPASS_DEC
CHARGE_END
	movlw	D'00'
	movwf	TIMERH			; set to 0
	movwf	TIMERL
; write to EEPROM
	movlw	EEPROM1
	call	EEREAD
	movf	TIMERH,w
	call	EWRITE
	movlw	EEPROM2
	call	EEREAD
	movf	TIMERL,w
	call	EWRITE
; check if topup and trickle required
CK_TOP_TRICK
	btfsc	PORTB,4			; if low topup
	goto	STOP_CHRG		; stop charger
	btfss	CHARGE_STATE,0	; if set then clear and set bit 1
	goto	CK_TOPUP
	clrf	CHARGE_STATE
	bsf		CHARGE_STATE,1	; topup
; write to EEPROM
	movlw	EEPROM0
	call	EEREAD
	movf	CHARGE_STATE,w
	call	EWRITE
; set timer	to 60 minutes
	movlw	H'1C'			; * correct timer period
;	movlw	D'01'			; test timer period
	movwf	TIMERH
	movlw	H'4A'
	movwf	TIMERL			; timer loaded
; write to EEPROM
	movlw	EEPROM1
	call	EEREAD
	movf	TIMERH,w
	call	EWRITE
	movlw	EEPROM2
	call	EEREAD
	movf	TIMERL,w
	call	EWRITE
	goto	BYPASS_DEC
CK_TOPUP
	btfss	CHARGE_STATE,1	; if topup, set to trickle
	goto	BYPASS_DEC	
	clrf	CHARGE_STATE
	bsf		CHARGE_STATE,2	; trickle
; write to EEPROM
	movlw	EEPROM0
	call	EEREAD
	movf	CHARGE_STATE,w
	call	EWRITE	

BYPASS_DEC
	decfsz	EEWRITE_TIMER,f
	goto	CHECK_EDGE
; write to EEPROM every 8 minutes
	movlw	EEPROM1
	call	EEREAD
	movf	TIMERH,w
	call	EWRITE
	movlw	EEPROM2
	call	EEREAD
	movf	TIMERL,w
	call	EWRITE

CHECK_EDGE
	btfss	INTCON,INTF		; edge interrupt flag
	goto	RECLAIM
	bcf		INTCON,INTF		; clear edge interrupt flag
 	btfsc	PORTB,0
	goto	RECLAIM

; check if switch stays on for debounce period
	movlw	D'10'
	call	DELAYX
	btfsc	PORTB,0
	goto 	RECLAIM
	movlw	D'10'
	call	DELAYX
	btfsc	PORTB,0
	goto 	RECLAIM
; if charge started bypass
	movf	CHARGE_STATE,w
	btfss	STATUS,Z		; if zero continue if not bypass as already started
	goto	STOP_CHRG	
; still low so start timer
	clrf	CHARGE_STATE	; charge status
	bsf		CHARGE_STATE,0	; fast charge rate
	bsf		PORTB,1			; charger LED
; write to EEPROM
	movlw	EEPROM0
	call	EEREAD
	movf	CHARGE_STATE,w
	call	EWRITE

; load timer
; calculate timeout (TIMEOUT x 142)
	movf	TIMEOUT,w
	movwf	AARGB0
	movlw	D'142'			; * correct timer setting
;	movlw	D'01'			; test for timer /142
	movwf	BARGB0
	call	EIGHTEIGHT		; 
	movf	AARGB0,w		; ms
	movwf	TIMERH			; 
	movf	AARGB1,w
	movwf	TIMERL			; timer loaded

; write to EEPROM
	movlw	EEPROM1
	call	EEREAD
	movf	TIMERH,w
	call	EWRITE
	movlw	EEPROM2
	call	EEREAD
	movf	TIMERL,w
	call	EWRITE
	bcf		INTCON,INTF		; clear edge interrupt flag	
	bcf		PIR1,TMR1IF		; clear timer 1 flag
	movlw	D'20'	
	movwf	THERM_COUNT		; thermistor count
	movlw	D'121'			; delta T of 60 seconds
	movwf	NTC_COUNT		; 0.495833 x 121 = 60 seconds
	goto	RECLAIM
STOP_CHRG
; still low so stop charger
	clrf	CHARGE_STATE	; charge status

; write to EEPROM
	movlw	EEPROM0
	call	EEREAD
	movf	CHARGE_STATE,w
	call	EWRITE
; set timers to 0
	movlw	D'00'
	movwf	TIMERH			; set to 0
	movwf	TIMERL
; write to EEPROM
	movlw	EEPROM1
	call	EEREAD
	movf	TIMERH,w
	call	EWRITE
	movlw	EEPROM2
	call	EEREAD
	movf	TIMERL,w
	call	EWRITE
CHARGER_OFF
	bcf		PORTB,1			; charger LED
	clrf	CCPR1L			; Mosfet off
	bcf		CCP1CON,4
	bcf		CCP1CON,5		; clear 10-bits

; end of interrupt reclaim w and status 
RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

; **************************************************************
; Subroutines

; delay
DELAYms
	movlw	D'20'		; delay 
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP1	
	movlw	0xFF
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return

; A/D conversion
; set analog input address
ANALOG_AD
	movlw	B'11000111'		; mask bits 5:3
	andwf	ADCON0,f		; set bits 5:3 to zero
	btfsc	ADCOUNT,0		; if bit 0 set then set bit 3 in ADCON0
	bsf		ADCON0,3
	btfsc	ADCOUNT,1		; if bit 1 set then set bit 4 in ADCON0
	bsf		ADCON0,4
	btfsc	ADCOUNT,2		; if bit 2 set,set bit 5
	bsf		ADCON0,5

	movf	ADCOUNT,w		; find address
	btfsc	STATUS,Z		; if zero
	goto	CH_0
	movf	ADCOUNT,w
	xorlw	0x01			; 1
	btfsc	STATUS,Z
	goto	CH_1
	movf	ADCOUNT,w
	xorlw	0x02			; 2
	btfsc	STATUS,Z
	goto	CH_2
	movf	ADCOUNT,w
	xorlw	0x03			; 3
	btfsc	STATUS,Z
	goto	CH_3
	movf	ADCOUNT,w
	xorlw	0x04			; 4
	btfsc	STATUS,Z
	goto	CH_4

; Channel 0 A/D value
CH_0
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	TIMEOUT			; timeout value
	goto	INPUTS_READ		; end

; Channel 1 A/D value
CH_1
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	TRICKLE			; trickle
	goto	INPUTS_READ		; end

; Channel 2 A/D value
CH_2
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	DELTA_TEMP		; change in temperature
	goto	INPUTS_READ		; end

; Channel 3 A/D value
CH_3
	goto	INPUTS_READ	; end

; Channel 4 A/D value
CH_4
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	THERMISTOR		; Thermistor value
	goto	INPUTS_READ		; end

; subroutine to wait for conversion
ACQUIRE_AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

INPUTS_READ					; inputs are read
; set new address
	incf	ADCOUNT,f		; counter
	movf	ADCOUNT,w
	sublw	B'00000100'		; compare with 4,if positive or zero leave as is
	btfss	STATUS,C
	clrf	ADCOUNT			; back to zero
	return

; subroutine to read EEPROM memory

EEREAD	
;	bcf		INTCON,GIE	; clear global interrupt enable 
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
;	bsf		INTCON,GIE	; set global interrupt enable 
	return

; subroutine to write to EEPROM

EWRITE
;	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
;	bcf		INTCON,GIE	; disable interrupts
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
;	bsf		INTCON,GIE	; enable interrupts
	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
;	bsf		INTCON,GIE	; set global interrupt enable 
	return				; value written 

; subroutine to read EEPROM memory

EEREAD_NO_INTERRUPT	
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM

EWRITE_NO_INTERRUPT
	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bcf		INTCON,GIE	; disable interrupts
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
WRITE1	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
	return

; 8 x 8 multiply

EIGHTEIGHT      CLRF    AARGB1          ; clear partial product
UMUL0808L        
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
                MOVF    AARGB0,W

LOOPUM0808A
                RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    LUM0808NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808A

                CLRF    AARGB0
                RETLW   H'00'

LUM0808NAP
                BCF     STATUS,C
                GOTO    LUM0808NA

LOOPUM0808
                RRF     BARGB0, F
                BTFSC   STATUS,C
                ADDWF   AARGB0, F
LUM0808NA       RRF    	AARGB0, F
                RRF    	AARGB1, F
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808

                return  

;**********************************************************************************************
        
;       16/8 Bit Unsigned Fixed Point Divide 16/8 -> 16.08

;       Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;               8 bit unsigned fixed point divisor in BARGB0

;      ;       Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;               8 bit unsigned fixed point remainder in REMB0

;       Result: AARG, REM  <--  AARG / BARG

DIV16_8      	CLRF            REMB0
                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608A      RLF             AARGB0,W
                RLF             REMB0, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F

                BTFSC           STATUS,C
                GOTO            UOK68A          
                ADDWF           REMB0, F
                BCF             STATUS,C
UOK68A          RLF             AARGB0, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608A

                CLRF            TEMP1

                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608B      RLF             AARGB1,W
                RLF             REMB0, F
                RLF             TEMP1, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSS           STATUS,C
                INCFSZ          AARGB3,W
                SUBWF           TEMP1, F

                BTFSC           STATUS,C
                GOTO            UOK68B          
                MOVF            BARGB0,W
                ADDWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSC           STATUS,C
                INCFSZ          AARGB3,W
                ADDWF           TEMP1, F

                BCF             STATUS,C
UOK68B          RLF             AARGB1, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608B
                return
           

 end
