' Michael Jeffery Apr 2006 .
' Ver 1.1 Updated June 2006, Fixes 0.00 Bug.

' Currently set up for a Schools Experimenter board
' (AXE092) which uses an 08M Picaxe Chip, output
' to 7-Seg displays via the 10 pin header strip.
' Or Clinch - Axe 0 Stat Display board, 2 or 3 digit version.
' Or you could use any 5V Digital Counter with count/reset pins.
'
' Pin0/Leg7 = display Reset.
' Pin2/Leg5 to Display Count and Piezo Sounder if used.
' Pin1/Leg6 to Minutes/Sec separator LED which is 
' placed between digit 2 and 3, right to left  <<<<.
' Stopwatch counts 0 - 60 Sec using 2 digit display.
' Stopwatch counts 0 - 9.60 (10mins) mins/sec using 3 digit display.
' Accuracy within <1 Second 0 to 10 minutes.
' Count stops at 9 minutes 60 seconds (10 mins).
' When counting the 60th second displays then changes to
' the correct minute value before the first second of the next
' minute is displayed, The timing sequence remains correct.
' By no means a Cesium timebase but may prove useful at a pinch.
' If a piezo sounder is also fitted to Pin2/Leg5 the 
' stopwatch will "Tick" every second and "Beep" every minute.
'
' There is one small quirk with this design - the counter never
' displays X.00, instead whole minutes are displayed as X.60 seconds,
' the correct Minute Digit is shown before the counter reaches the
' first second in the next minute. 4 minutes and 60 seconds is still
' 5 minutes no matter how you look at it, so for the sake of simplicity
' and function that's it.
'
' NOTE if the Axe 0 Stat display board has been set up to read a DS18B20
' temperature chip and you then wish to use READADC with an LDR etc, the
' DISPLAY PCB "DATA" track needs to be broken to prevent false readings
' caused by the 4k7 Ohm pull up resistor used for the DS18B20. Suggested,
' break track where 2 pads are side by side near the DS18B20 socket and
' insert 2 Motherboard style jumper pins and use a jumper, this will
' make it easier to swap back and forth later on. There are spare pads
' on the other end of the data track which can be used for any inputs
' needed. NOTE: remove the DS18B20 chip when not in use.


' Program starts here.

symbol mins = b0

ready:
b1 = 0
pause 250
if pin3 = 1 then reset
goto ready

reset:
high 0
low 0
toggle 1				'Toggle LED added in Ver 1.1
pause 150
if pin3 = 1 then low0
goto reset

low0:
low 1

start:
if pin3 = 1 then tick
goto start

tick:
pause 998

tick2:
if pin3 = 1 then ready
pause 164
goto tick3

minsjump:
pause 140

tick3:
high 2
low 2
if pin3 = 1 then ready		' If you think the timing is out on your
pause 165				' particular setup you can change one of 
if pin3 = 1 then ready		' these pauses to correct the timing.
pause 164				' This is the calibration method you should use if needed.
if pin3 = 1 then ready		' By adjusting any ONE of these pauses  
pause 174				' up or down you will achieve a 0.5 second             
if pin3 = 1 then ready		' drift for every 1 m/sec change over 10 mins.            
pause 164				' 164 = 164 m/sec pause, 0.164 seconds.  
if pin3 = 1 then ready		' Increase to slow down, Decrease to speed up timing.            
pause 165				' A one or two minute period is enough for calibrating                             
b1 = 1 + b1				' using a watch or stop watch for a reference.
if b1 = 59 then minute		' Ver 1.1, 60 Sec bug Fixed, was 60.
goto tick2

minute:
b2 = b2 + 1				' Ver 1.1, 60 Sec bug Fixed, was b2 = b2 + b1 - 59.
b1 = 0
for mins = 1 to 41		' Ver 1.1, 60 Sec bug Fixed, was 40.
high 2
low 2
next mins
high 1
pause 950				' Added for Ver 1.1, 60 Sec bug Fix.
if b2 = 10 then ready		' Remove/change this line for continuous counting.
goto minsjump
goto ready

' Do NOT alter any of the pause values or you will cause a drift of 1 seconds/m-sec
' adjustment on any single pause value, per 1000 sec count(15 Min). This is the
' calibration method you should use if needed. Do not join the pause values into
' one large value either or the stopwatch may not stop when needed. In initial
' testing raising the ambient temperature by 20 Deg C produced a drift of around
' 2.5 seconds over the 10 Mins.
'
' Picaxe is a trademark of Rev-Ed Ltd, www.picaxe.co.uk
'
' www.http://porepunkahps.vic.edu.au/home/jef01/display.htm
' michael.jeffery@porepunkahps.vic.edu.au

 

