
symbol pauseplay = 4
symbol pushbutton = pin3
symbol fastforward = 2
symbol peakdetin = 1
symbol powerout = 0

symbol wcounter = w0
symbol bcounter = b2
symbol peaklev = b3

symbol KEYDOWNMS = 200		'duration of a button push
symbol KEYUPMS = 1000		'duration of the delay after a button push

start:
   input pushbutton
   input peakdetin
   low   pauseplay
   low   fastforward
   low   powerout
   pause 2000			'startup delay

' Hold pause/play button down for several seconds to start.

poweron:
   high  pauseplay
   pause 3000
   low   pauseplay  
   pause 3000

' Press fastforward then pause again immediately.

advancetrack:
   high  fastforward
   pause KEYDOWNMS
   low   fastforward
   pause KEYUPMS

   high  pauseplay
   pause KEYDOWNMS
   low   pauseplay    
   pause 3000			'takes awhile to catch up

 
' Wait for user input, press fastforward every 20s to prevent auto powerdown.      

userwait:
   for bcounter = 1 to 200
      if pushbutton = 1 then playtrack
      pause 100     
   next bcounter

   high fastforward
   pause KEYDOWNMS
   low fastforward
   pause KEYUPMS
   goto userwait

' Powerup the output amp, unpause the track, start playing and wait
' for non-silence. If silence lasts for 5 seconds then reset system.

playtrack:
   high powerout
   high pauseplay
   pause KEYDOWNMS
   low pauseplay

   for wcounter = 1 to 5000
      readadc peakdetin, peaklev
      if peaklev > 0 then playbackstarted
      pause 1
   next wcounter

' No audio detected, so the mp3 player is probably off - try to restart.

   goto start

playbackstarted:  

' Allow to keep playing until at least 1s of continuous silence.

waitforsilence:

   for wcounter = 1 to 1000
      readadc peakdetin, peaklev
      if peaklev > 0 then waitforsilence
      pause 1
   next wcounter

' Powerdown the output amp, reset to next track.

   low powerout
   goto advancetrack

