
; Frequency Meter using LCD 
; modification for busy check when driving display
; Also rounding up addition for use with 10kHz band radio control transmitters.


		ERRORLEVEL -302
	list P=16F628A
	#include p16f628A.inc

	__config _XT_OSC & _WDT_OFF & _PWRTE_ON & _BOREN_ON & _MCLRE_ON & _LVP_OFF

; Define variables at memory locations

EEPROM1		equ	H'00'	; update rate
 
; RAM

ESEVN		equ	H'20'	; 10 000,000 (digit 8)
ESIX		equ	H'21'	; 1000,000s (digit 7 )
EFIVE		equ	H'22'	; 100,000s digit 6 store
EFOUR		equ	H'23'	; 10,000s digit 5 store
ETHREE		equ	H'24'	; 1000s digit 4 store (kHz)
ETWO		equ	H'25'	; 100s digit 3 store
EONE		equ	H'26'	; 10s digit 2 store
EZERO		equ	H'27'	; 1's digit 1 store (Hz)
REG_C		equ	H'28'	; frequency counter LS byte
REG_B		equ	H'29'	; frequency counter 
REG_A		equ	H'2A'	; frequency counter MS byte 
D_STO		equ	H'2B'	; data store
FLAG		equ	H'2C'	; flag to include delay for 100ms update
TIMER		equ	H'2D'	; most significant byte of timer (TMR0) value
SAMPLE		equ	H'2E'   ; period of frequency counting
STORE1		equ	H'2F'	; temporary storage
STORE2		equ	H'30'	; temporary storage
ADDRESS		equ	H'31'	; display address position
CARRY_B		equ	H'32'	; carry borrow storage
FLAG_1		equ	H'33'	; flag for start of .1Hz resolution count
DATA_S		equ	H'34'	; data storage
COUNT		equ	H'35'	; 
BCD1		equ	H'36'	; overrange
BCD2		equ	H'37'	; MS decimal value
BCD3		equ	H'38'	; 
BCD4		equ	H'39'	; decimal value
BCD5		equ	H'3A'	; ls decimal value	
BIN1		equ	H'3B'	; LS binary value
BIN2		equ	H'3C'	; 
BIN3		equ	H'3D'	; 
BIN4		equ	H'3E'	; MS binary value
TEMP		equ	H'3F'	; data storage
TEMPR		equ	H'40'	; temporary for resolution
STORE3		equ	H'41'	; delay storage value
FLAG_S		equ	H'42'	; await signal flag
TIME_I		equ	H'43'	; initial timer
STOREX		equ	H'44'	; display count store
TEMPX		equ	H'45'	; delay register

; math routines

SIGN        equ H'60'   ; save location for sign 
TEMPB1      equ H'61'
TEMPB0      equ H'62'
TEMPD       equ H'63'	; temporary storage
AARGB2      equ H'64'
AARGB1      equ H'65'
AARGB0      equ H'66'
AARG        equ H'67'   ; most significant byte of argument A
BARGB2	    equ	H'68'
BARGB1      equ H'69'
BARGB0      equ H'6A'
BARG        equ H'6B'   ; most significant byte of argument B
REMB2	    equ	H'6C'
REMB1       equ H'6D'
REMB0       equ H'6E'   ; most significant byte of remainder
LOOPCOUNT   equ H'6F'   ; loop counter

	
; preprogram EEPROM DATA
	
	ORG     2100
	DE	H'00'		; standard 1s rate

; start at memory 0

	org	0

; initialise ports
	movlw	0x07		; comparators off
	movwf	CMCON		; I/O pins
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001011'	; port B outputs at MS bits inputs at LS bits
	movwf	TRISB		; port B data direction register
	movlw	B'00010000'	; RA0 to RA3 outputs, RA4 input
	movwf	TRISA		; port A data direction register
	movlw	B'10110111'	; prescaler external clock and /256, 
	movwf	OPTION_REG	; port B pullups disabled
	bcf		STATUS,RP0	; memory bank 0	
;	clrf	PORTA		; ports clear or low
	clrf	PORTB

; set up initial conditions for display
	
	clrf	PORTA		; RS, R/W, E low
 
	call	DELAY_TM
	
	movlw	B'00110000'	; initialise module
	movwf	PORTB
	nop
	bsf		PORTA,0		; enable high
	nop
	bcf		PORTA,0		; low
	call 	DELAYms

; set 4-bit operation

	movlw	B'00100000'
	movwf	PORTB		; place display commands in portB
	bcf		PORTA,1		; R/W low (write)
	bcf		PORTA,2		; register select low
	nop
	bsf		PORTA,0		; enable set
	nop
	bcf		PORTA,0		; enable clear
	
	call	DELAYms
	
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	call	CLEAR
	goto	RESOL
CLEAR
	movlw	A'0'		; ASCII 0
	movwf	ESEVN		; ms display digit to zero
	movwf	ESIX
	movwf	EFIVE
	movwf	EFOUR
	movwf	ETHREE
	movwf	ETWO
	movwf	EONE
	movwf	EZERO		; ls display digit to 0
	call	DISP_L		; load Hz on display
	return

RESOL
	clrf	FLAG_S
	btfsc	PORTB,3		; is RB3 high or low with switch
	goto	CK_EEP
	movlw	EEPROM1
	movwf	EEADR		; address	
	call	EEREAD		; get current resolution
	movwf	TEMPR
; if bit 1 set then clear TEMPR
	movlw	H'FF'		
	btfsc	TEMPR,1
	movwf	TEMPR		; when bit 1 set clear (FF + 1=0)
	incf	TEMPR,w
	movwf	TEMPR
	call	EWRITE
	call	RES_DSP		; resolution display

	movlw	0x0F
	movwf	TEMPX
MORE_D
	call	DELAYms		; debounce delay 160ms
	decfsz	TEMPX,f
	goto	MORE_D
SW_CK
	btfss	PORTB,3		; is switch released
	goto	SW_CK
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	call	CLEAR		; clear display registers

CK_EEP
	movlw	EEPROM1
	call	EEREAD
	movwf	TEMPR
	btfsc	TEMPR,0		; if clear then 100ms gate
	goto	RANGE2
	goto	RANGE1B

RANGE1
	call	DELAY_TM	; slow down update for 100ms gating -
	goto	RESOL		; - as LCD too slow for faster changes

; select resolution 10Hz, 1Hz 
	
RANGE1B
	movlw	D'20'		; 100ms gate 
	movwf	SAMPLE		; count period
	call	CK_CNT		; count clock input frequency signal
	call	BIN_BCD		; convert binary to BCD and ASCII

; check range		

	movf	ESIX,w		; ms digit for 100ms gate period
	xorlw	0x30		; ASCII 0
	btfss	STATUS,Z	; if not zero then MHz
	goto	MHz10		; MHz range 10Hz resolution
	movf	EFIVE,w		; next MHz digit for 100ms gate period
	xorlw	0x30		; ASCII 0
	btfss	STATUS,Z	; if not zero then MHz range
	goto	MHz10		; MHz range 10Hz resolution
	movf	EFOUR,w		; kHz ms digit
	xorlw	0x30
	btfss	STATUS,Z	; if not zero then kHz
	goto	kHz10
	movf	BCD4,w		; check packed BCD value for Ethree and Etwo
	btfss	STATUS,Z	; if zero then Hz1 range
	goto	kHz10		; kHz range 10Hz resolution
	call	Hz1
	goto	RESOL

; MHz range 10Hz resolution

MHz10
	btfsc	TEMPR,1		; when set 10kHz rounding
	goto	MHz10_ROUNDING
	movlw	B'10000001'	; set display address 1
	call	LOAD
	call	SPACE1		; clear ms digit
	movlw	0x02		; output first 2 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq
	movwf	FSR
;	movlw	0x35		; if 50 ('35' refers to 3 for ASCII and 5 for 50MHz)
;	subwf	INDF,w
;	btfsc	STATUS,C	; if c is one then overrange
;	goto	OVER		; overrange
MRNG2
	movlw	0x30		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	MRNG3
	call	SPACE1		; 1 space
	incf	FSR,f		; EFIVE
	decfsz	STOREX,f
	goto	MRNG2
	goto	MRNG4
MRNG3
	movf	INDF,w		; display ESIX
	call	DRV_LCD
	incf	FSR,f		; EFOUR
	decfsz	STOREX,f
	goto	MRNG3
MRNG4
	movlw	0x2E		; ASCII for a dot
	call	DRV_LCD
	movlw	0x05		; 5 characters
	movwf	STOREX	
MRNG5
	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f		; ETHREE, ETWO etc
	decfsz	STOREX,f
	goto	MRNG5
	call	SPACE1		; 1 space

; if PortB,0 low and TEMPR bit1 low change MHz to GHz
	btfsc	TEMPR,1		; no prescaler for rounding  
	goto	NO_PRESCALER_MHz
	btfsc	PORTB,0		; clear so prescaler units
	goto	NO_PRESCALER_MHz
	movlw	A'G'		; ASCII G
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	movlw	A'P'		; ASCII prescaler units
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'c'		;
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'u'		;
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	call	SPACE2		; 
	goto	RANGE1

NO_PRESCALER_MHz	
	movlw	A'M'		; ASCII M
	call	DRV_LCD
DV_Hz
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	call	SPACE4		; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	goto	RANGE1

; MHz range 10Hz resolution
MHz10_ROUNDING

; rounding, strip out ASCII bits first
	movf	EZERO,w		; ls byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EZERO

	movf	EONE,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EONE

	movf	ETWO,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	ETWO

	movf	ETHREE,w	; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	ETHREE

	movf	EFOUR,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EFOUR

	movf	EFIVE,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	EFIVE

	movf	ESIX,w		; next byte
	andlw	H'0F'		; strip ASCII bit
	movwf	ESIX

; check for a five
; EZERO
	movf	EZERO,w	
	sublw	D'04'		; if five or > five increase EONE
	btfsc	STATUS,C
	goto	CK_ONE

; over nine for EZERO
	incf	EONE,f		; one more
	movf	EONE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE

	incf	ETWO,f
	movf	ETWO,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE
	
	incf	ETHREE,f
	movf	ETHREE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE

	incf	EFOUR,f
	movf	EFOUR,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE

	incf	EFIVE,f
	movf	EFIVE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_ONE

	incf	ESIX,f		; 
	
CK_ONE; EONE
	movlw	H'30'		; ASCII 0
	movwf	EZERO		; EZERO cleared
	
	movf	EONE,w		; next byte	
	sublw	D'04'		; if five or > five increase ETWO
	btfsc	STATUS,C
	goto	CK_TWO

; over nine for EONE

	incf	ETWO,f
	movf	ETWO,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO
	
	incf	ETHREE,f
	movf	ETHREE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO

	incf	EFOUR,f
	movf	EFOUR,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO

	incf	EFIVE,f
	movf	EFIVE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_TWO

	incf	ESIX,f	

CK_TWO ; ETWO

	movlw	H'30'		; ASCII 0
	movwf	EONE		; EONE cleared
	
	movf	ETWO,w		; next byte	
	sublw	D'04'		; if five or > five increase ETHREE
	btfsc	STATUS,C
	goto	CK_THREE

; over nine for ETWO

	incf	ETHREE,f
	movf	ETHREE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_THREE

	incf	EFOUR,f
	movf	EFOUR,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_THREE

	incf	EFIVE,f
	movf	EFIVE,w
	sublw	D'09'		; if an A increase next byte
	btfsc	STATUS,C
	goto	CK_THREE

	incf	ESIX,f	

CK_THREE
	movlw	H'30'		; ASCII 0
	movwf	ETWO		; ETWO cleared

; restore ASCII to 3,4,5,6
	movlw	H'30'
	iorwf	ETHREE,f
	iorwf	EFOUR,f
	iorwf	EFIVE,f
	iorwf	ESIX,f

; display value
			
	movlw	B'10000001'	; set display address 1
	call	LOAD
	call	SPACE1		; clear ms digit
	movlw	0x02		; output first 2 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq
	movwf	FSR
;	movlw	0x35		; if 50 ('35' refers to 3 for ASCII and 5 for 50MHz)
;	subwf	INDF,w
;	btfsc	STATUS,C	; if c is one then overrange
;	goto	OVER		; overrange
MRNG2R
	movlw	0x30		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	MRNG3R
	call	SPACE1		; 1 space
	incf	FSR,f		; EFIVE
	decfsz	STOREX,f
	goto	MRNG2R
	goto	MRNG4R
MRNG3R
	movf	INDF,w		; display ESIX
	call	DRV_LCD
	incf	FSR,f		; EFOUR
	decfsz	STOREX,f
	goto	MRNG3R
MRNG4R
	movlw	0x2E		; ASCII for a dot
	call	DRV_LCD
	movlw	0x03		; 3 characters
	movwf	STOREX	
MRNG5R
	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f		; ETHREE, ETWO etc
	decfsz	STOREX,f
	goto	MRNG5R
	call	SPACE1		; 1 space
	movlw	A'M'		; ASCII M
	call	DRV_LCD
DV_HzR
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	
; display 10kHz Rounding

	movlw	0xC0		; display address line2
	call	LOAD
	movlw	A'('		; (
	call	DRV_LCD
	movlw	A'1'		; 1
	call	DRV_LCD
	movlw	A'0'		; 0
	call	DRV_LCD
	movlw	A'k'		; k
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'		; Rounding
	call	DRV_LCD
	movlw	A'o'		; 
	call	DRV_LCD
	movlw	A'u'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'd'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'g'		; 
	call	DRV_LCD
	movlw	A')'		; )
	call	DRV_LCD
	call	SPACE2
	goto	RANGE1

; kHz range 10Hz resolution

kHz10
	movlw	0x81		; display address 1
	call	LOAD
	call	SPACE1		; clear digit
	movlw	0x05		; first 3 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq for kHz
	movwf	FSR
kHz2
	movlw	0x30		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	kHz3
	call	SPACE1		; 0's to space
	incf	FSR,f
	decfsz	STOREX,f
	goto	kHz2
	goto	kHz4
kHz3
	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f
	decfsz	STOREX,f
	goto	kHz3
kHz4
	movlw	0x2E		; dot
	call	DRV_LCD
	movf	INDF,w		; last 2 characters
	call	DRV_LCD
	incf	FSR,f
	movf	INDF,w
	call	DRV_LCD
	call	SPACE1		; 1 space

; if PortB,0 low and TEMPR bit1 low change kHz to MHz
	btfsc	TEMPR,1		; no prescaler for rounding  
	goto	NO_PRESCALER_kHz
	btfsc	PORTB,0		; clear so prescaler units
	goto	NO_PRESCALER_kHz
	movlw	A'M'		; ASCII M
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	movlw	A'P'		; ASCII prescaler units
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'c'		;
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'u'		;
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	call	SPACE2		; 
	goto	RANGE1

NO_PRESCALER_kHz
	movlw	A'k'		; k
	call	DRV_LCD
	goto	DV_Hz

; Hz range 1 second gate 1Hz resolution 

Hz1	movlw	D'200'		; 1s SAMPLE
	movwf	SAMPLE
	call	CK_CNT
	call	BIN_BCD		; convert binary to BCD
	
DISP_L
	movlw	0x81		; address
	call	LOAD
	call	SPACE2		; 2 spaces
	movlw	0x06		; first 6 characters
	movwf	STOREX
	movlw	ESIX		; MSD of freq
	movwf	FSR
Hz4	movlw	0x30		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	Hz2
	call	SPACE1		; leading 0's to space
	incf	FSR,f
	decfsz	STOREX,f
	goto	Hz4
	goto	Hz3
Hz2	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f
	decfsz	STOREX,f
	goto	Hz2
Hz3	movf	INDF,w
	call	DRV_LCD

; if PortB,0 low and TEMPR bit1 low change Hz to kHz
	btfsc	TEMPR,1		; no prescaler for rounding  
	goto	NO_PRESCALER_Hz
	btfsc	PORTB,0		; clear so prescaler units
	goto	NO_PRESCALER_Hz
	call	SPACE1
	movlw	A'k'		; ASCII k
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	movlw	A'P'		; ASCII prescaler units
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'c'		;
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'u'		;
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	call	SPACE2		; 
	return

NO_PRESCALER_Hz
	call	SPACE2		; 2 spaces
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces 
	movlw	0xC0		; display address line2
	call	LOAD
	call	SPACE4		; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	return

; select resolution 1Hz, 0.1Hz. Determine gating depending upon prescaler switch

RANGE2
	movlw	D'200'		; 1s gate period
	movwf	SAMPLE		; count period
	call	CK_CNT		; count clock input frequency signal
	btfsc	FLAG,0		; if flag set then overrange
	goto	RANGE1B		; 100ms range
	call	BIN_BCD		; convert binary to BCD and ASCII

; check range		

	movf	BCD2,w		; ms BCD digit for 1s gate period
	btfss	STATUS,Z	; if not zero then MHz
	goto	MHz1		; MHz range 1Hz resolution

	movf	BCD3,w		; kHz ms BCD digits
	btfss	STATUS,Z	; if not zero then kHz1
	goto	kHz1
	movf	ETHREE,w	; ASCII for Ethree 
	xorlw   0x30		; ASCII 0
	btfss	STATUS,Z	; if not zero then kHz1 range
	goto	kHz1		; kHz range 1Hz resolution
	call	HZ_PT1
	goto	RESOL		; resolution

; MHz range 1Hz resolution

MHz1
	movlw	B'10000001'	; set display address 1
	call	LOAD
	movlw	0x02		; output first 2 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq
	movwf	FSR
MRN2
	movlw	0x30		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	MRN3
	call	SPACE1		; ASCII space. 0's to space
	incf	FSR,f		; ESIX
	decfsz	STOREX,f
	goto	MRN2
	goto	MRN4
MRN3
	movf	INDF,w		; display ESEVN
	call	DRV_LCD
	incf	FSR,f		; ESIX
	decfsz	STOREX,f
	goto	MRN3
MRN4
	movlw	0x2E		; ASCII for a dot
	call	DRV_LCD
	movlw	0x06		; 6 characters
	movwf	STOREX	
MRN5
	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f		; ETHREE, ETWO etc
	decfsz	STOREX,f
	goto	MRN5
	call	SPACE1		; 1 space

; if PortB,0 low and TEMPR bit1 low change MHz to GHz
	btfsc	TEMPR,1		; no prescaler for rounding  
	goto	NO_PRESCALER_Hz1
	btfsc	PORTB,0		; clear so prescaler units
	goto	NO_PRESCALER_Hz1
	movlw	A'G'		; ASCII G
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	movlw	A'P'		; ASCII prescaler units
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'c'		;
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'u'		;
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	call	SPACE2		; 
	goto	RESOL

NO_PRESCALER_Hz1
	movlw	A'M'		; M
	call	DRV_LCD
DV_Hz1
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	call	SPACE4		; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	goto	RESOL

; kHz range 1Hz resolution

kHz1
	movlw	0x81		; display address 1
	call	LOAD
	movlw	0x05		; first 3 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq for kHz
	movwf	FSR
k1z2
	movlw	0x30		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	k1z3
	call	SPACE1		; 0's to space
	incf	FSR,f
	decfsz	STOREX,f
	goto	k1z2
	goto	k1z4
k1z3
	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f
	decfsz	STOREX,f
	goto	k1z3
k1z4
	movlw	0x2E		; dot
	call	DRV_LCD
	movf	INDF,w		; last 3 characters
	call	DRV_LCD
	incf	FSR,f
	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f
	movf	INDF,w
	call	DRV_LCD
	call	SPACE1		; 1 space

; if PortB,0 low and TEMPR bit1 low change kHz to MHz
	btfsc	TEMPR,1		; no prescaler for rounding  
	goto	NO_PRESCALER_kHz1
	btfsc	PORTB,0		; clear so prescaler units
	goto	NO_PRESCALER_kHz1
	movlw	A'M'		; ASCII M
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	movlw	A'P'		; ASCII prescaler units
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'c'		;
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'u'		;
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	call	SPACE2		; 
	goto	RESOL

NO_PRESCALER_kHz1
	movlw	A'k'		; k
	call	DRV_LCD
	goto	DV_Hz1

; Hz at 0.1 Hz resolution

HZ_PT1
	clrf	FLAG_1
	clrf	REG_A		; MS counter
	clrf	REG_B
	clrf	REG_C		; LS counter
	bcf		PORTB,2		; prevent frequency input to RA4
	bsf		PORTA,3		; enable clocking when RB2 goes high
	bsf		PORTB,2		; start input
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'10010111'	; prescaler internal clock and /256, 
	movwf	OPTION_REG	; 
	bcf		STATUS,RP0	; memory bank 0	
	bcf		INTCON,T0IF	; clear timer overflow bit

WAIT
	btfss	INTCON,T0IF	; has timer overflowed
	goto	C_FLG	
	bcf		INTCON,T0IF
	incfsz	REG_A,f
	goto	CK_1Hz
	call	OVER		; clear display no input or too low
	goto	RESOL
CK_1Hz
	btfsc	FLAG_S,0	; bypass await signal 
	goto	C_FLG
	movf	REG_A,w
	xorlw	0x0F		; almost 1 second
	btfss	STATUS,Z	; if 0 then ~ 1 second
	goto	C_FLG
	call	SIGNAL
	bsf		FLAG_S,0	; set flag when await signal displayed
	goto	HZ_PT1	
C_FLG
	btfsc	PORTB,3		; is mode switch pressed
	goto	CON_SQ
	call	CHG_PRT
	goto	RESOL
CON_SQ	
	btfsc	FLAG_1,1	; has counter sequence started
	goto	COUNT_P		; count positive edge start

	btfss	FLAG_1,3	; if flag set then set flag_1,1 when RB0 high
	goto	CHK_LOW
	btfsc	PORTA,4		; is RA4 high
	bsf		FLAG_1,1
	goto	WAIT

CHK_LOW
	btfss	PORTA,4		; is RA4 low
	bsf		FLAG_1,3	; set flag when RA4 is low
	goto	WAIT

; increment counters

COUNT_P
	clrf	TMR0		; timer (counter) and prescaler reset to zero
	clrf	TIMER		; timer counter storage
	clrf	REG_A		; MS counter

; start TMR0

	bcf		INTCON,T0IF	; clear timer overflow bit	
COUNT_T
	btfss	INTCON,T0IF	; is timer overflowed
	goto	CK_END
	incfsz	REG_A,f		; increase most significant byte (if zero then over)
	goto	CLR_T
	call	OVER		; overrange
	goto	RESOL
CLR_T
	bcf		INTCON,T0IF	; clear timer overflow bit
CK_END
	btfsc	FLAG_1,2	; is flag 2 set
	goto	CK_HI
	btfss	PORTA,4		; is porta,4 low again
	bsf		FLAG_1,2	; set flag when low
	goto	COUNT_T		; continue counting
CK_HI
	btfss	PORTA,4		; is it high again
	goto	COUNT_T		;

; stop TMR0

	bcf		PORTB,2		; prevent frequency input to RA4
	call	CHG_PRT		; change port
	btfss	INTCON,T0IF	; is timer overflowed
	goto	NOT_O
	incfsz	REG_A,f		; increase most significant byte (if zero then over)
	goto	NOT_O
	goto	OVER		; overrange
NOT_O
	movf	TMR0,w		; get timer value
	movwf	REG_B		; mid significant byte
	call	EOC		; convert TMR0 and prescaler to REG values

; check if frequency > 150Hz

	movf	REG_A,w		; ms byte
	btfss	STATUS,Z	; if zero check other numbers
	goto	BELOW	
	movlw	0x1A		; ms byte 
	subwf	REG_B,w
	btfsc	STATUS,C
	goto	BELOW
	call	Hz1			; 1Hz resolution
	goto	RESOL		; check resolution
BELOW
	movf	REG_A,w
	movwf	BARGB0
	movf	REG_C,w		; end of count so process
	movwf	BARGB2
	movf	REG_B,w
	movwf	BARGB1
	movlw	0x98		; hex for 10,000,000
	movwf	AARGB0
	movlw	0x96		; hex for 10,000,000
	movwf	AARGB1
	movlw	0x80		; hex for 10,000,000
	movwf	AARGB2
	call	FXD2424U	; divide into 10,000,000
	movf	AARGB0,w
	movwf	BIN3
	movf	AARGB1,w
	movwf	BIN2
	movf	AARGB2,w
	movwf	BIN1
	call	BINBCDX		; convert binary to BCD
	
INST
	movlw	0x81		; address
	call	LOAD
	call	SPACE1		; 1 space
	movlw	0x07		; first 7 characters
	movwf	STOREX
	movlw	ESEVN		; MSD of freq
	movwf	FSR
HzPT4
	movlw	0x30		; check if 0
	subwf	INDF,w
	btfss	STATUS,Z
	goto	HzPT2
	call	SPACE1		; leading 0's to space
	incf	FSR,f
	decfsz	STOREX,f
	goto	HzPT4
	goto	HzPT3
HzPT2
	movf	INDF,w
	call	DRV_LCD
	incf	FSR,f
	decfsz	STOREX,f
	goto	HzPT2
HzPT3
	movlw	0x2E		; dot
	call	DRV_LCD
	movf	INDF,w
	call	DRV_LCD
	call	SPACE1		; 1 space

; if PortB,0 low and TEMPR bit1 low change MHz to GHz
	btfsc	TEMPR,1		; no prescaler for rounding  
	goto	DV_Hz1
	btfsc	PORTB,0		; clear so prescaler units
	goto	DV_Hz1
	movlw	A'k'		; ASCII 
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	0xC0		; display address line2
	call	LOAD
	movlw	A'P'		; ASCII prescaler units
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	movlw	A'c'		;
	call	DRV_LCD
	movlw	A'a'		; 
	call	DRV_LCD
	movlw	A'l'		; 
	call	DRV_LCD
	movlw	A'e'		; 
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'u'		;
	call	DRV_LCD
	movlw	A'n'		; 
	call	DRV_LCD
	movlw	A'i'		; 
	call	DRV_LCD
	movlw	A't'		; 
	call	DRV_LCD
	movlw	A's'		; 
	call	DRV_LCD
	call	SPACE2		; 
	goto	RESOL	

; overrange display

SIGNAL
	movlw	0x01		; clear display
	call	LOAD
	movlw	0x02		; cursor home
	call	LOAD
		
	movlw	0x82		; display address
	call	LOAD
	movlw	A'A'		; A
	call	DRV_LCD
	movlw	A'w'		; w
	call	DRV_LCD
	movlw	A'a'		; a
	call	DRV_LCD
	movlw	A'i'		; i
	call	DRV_LCD
	movlw	A't'		; t
	call	DRV_LCD
	goto	SIG_SP	 	; display 'signal'

OVER
	call	CHG_PRT		; change ports
	goto	OVER_D
CHG_PRT
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'10110111'	; prescaler external clock and /256, 
	movwf	OPTION_REG	; port B pullups disabled
	bcf		STATUS,RP0	; memory bank 0	
	return
OVER_D
	movlw	0x01		; clear display
	call	LOAD
	movlw	0x02		; cursor home
	call	LOAD
	call	SPACE1		; 1 space		
	movlw	0x83		; display address
	call	LOAD
	movlw	A'N'		; N
	call	DRV_LCD
	movlw	A'o'		; o
	call	DRV_LCD
SIG_SP
	call	SPACE1		; space
	movlw	A'S'		; S
	call	DRV_LCD
	movlw	A'i'		; i
	call	DRV_LCD
	movlw	A'g'		; g
	call	DRV_LCD
	movlw	A'n'		; n
	call	DRV_LCD 
	movlw	A'a'		; a
	call	DRV_LCD
	movlw	A'l'		; l
	call	DRV_LCD
	call	SPACE4		; 4 spaces
	call	SPACE4
	movlw	0xC0		; display address line2
	call	LOAD
	call	SPACE4		; remove second line
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	return

; resolution display

RES_DSP
	movlw	0x01		; clear display
	call	LOAD
	movlw	0x02		; cursor home
	call	LOAD
	call	CLEAR		; clear display registers
	movlw	B'11000000'	; display address first column second line
	call	LOAD
	btfss	TEMPR,0		; check resolution
	goto	ONEHZ
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'I'		; I
	call	DRV_LCD
	movlw	A'G'		; G
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	call	SPACE2
	goto	ROUNDING_DSP
	
ONEHZ
	movlw	A'L'		; L
	call	DRV_LCD
	movlw	A'O'		; O
	call	DRV_LCD
	movlw	A'W'		; W
	call	DRV_LCD
	call	SPACE1		; one space

ROUNDING_DSP
; if rounding show this
	btfsc	TEMPR,1		; check rounding
	goto	DO_ROUNDING_DSP
	call	SPACE4
	call	SPACE4
	call	SPACE4
	return

DO_ROUNDING_DSP
	movlw	A'1'		; 1 10kHz
	call	DRV_LCD
	movlw	A'0'		; 0
	call	DRV_LCD
	movlw	A'k'		; k
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	movlw	A'@'		; @
	call	DRV_LCD
	movlw	A'>'		; >16MHz
	call	DRV_LCD
	movlw	A'1'		; 1
	call	DRV_LCD
	movlw	A'6'		; 6
	call	DRV_LCD
	movlw	A'M'		; M
	call	DRV_LCD
	movlw	A'H'		; H
	call	DRV_LCD
	movlw	A'z'		; z
	call	DRV_LCD
	call	SPACE1
	
	return
;***************************************************************************
; subroutines

; add space in display

SPACE4
	movlw	0x20		; space
	call	DRV_LCD
SPACE3
	movlw	0x20		; space
	call	DRV_LCD
SPACE2
	movlw	0x20		; space
	call	DRV_LCD
SPACE1
	movlw	0x20		; space
	call	DRV_LCD
	return

; delay timer

DELAY_TM
	movlw	0x0F
	movwf	TIME_I		; initial timer 
TIM_CON
	call	DELAYms
	decfsz	TIME_I,f
	goto	TIM_CON		; continue timer
; ; go to DELAYms
	
; nominal 10ms delay loop

DELAYms
	movlw	0x0A		; delay with 4 MHz clock
	movwf	STORE1		; STORE1 is number of loops value
LOOP1
	movlw	0xA0
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO		; store data	
	movf	D_STO,w
	andlw	0xF0		; get upper bits
	movwf	PORTB		; place display commands in portB
	bcf		PORTA,1		; R/W low (write)
	bcf		PORTA,2		; register select low
	nop
	bsf		PORTA,0		; enable set
	nop
	bcf		PORTA,0		; enable clear

	swapf	D_STO,w
	andlw	0xF0		; get lower bits
	movwf	PORTB		; place display commands in portB
	bcf		PORTA,1		; R/W low (write)
	bcf		PORTA,2		; register select low
	nop
	bsf		PORTA,0		; enable set
	nop
	bcf		PORTA,0		; enable clear
	call	BUS_CK		; check busy flag
	return

; driving the LCD module with display data

DRV_LCD
	movwf	D_STO		; store data
	movf	D_STO,w
	andlw	0xF0		; upper bits	
	movwf	PORTB		; w to portb
	bcf		PORTA,1		; read write
	bsf		PORTA,2		; register select
	
	bsf		PORTA,0		; enable high
	nop
	bcf		PORTA,0		; enable low
	swapf	D_STO,w
	andlw	0xF0		; lower bits
	movwf	PORTB		; w to portb
	bcf		PORTA,1		; read write
	bsf		PORTA,2		; register select
	
	bsf		PORTA,0		; enable high
	nop
	bcf		PORTA,0		; enable low
	call	BUS_CK		; check busy flag
	return

; check busy flag (note change to porta,0 levels)

BUS_CK
	movlw	0x02		; delay to ensure busy flag is clear
	movwf	STORE1
	call	LOOP1
	return

; alternative to read busy flag

	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11111011'	; PORTB inputs
	movwf	TRISB
	bcf		STATUS,RP0	; memory bank 0	
	bcf		PORTA,2		; rs clear
	bsf		PORTA,1		; R/W high (read)

CK_AGN
	bsf	PORTA,0
	bcf	PORTA,0			; enable high
		
	btfsc	PORTB,7		; check busy flag
	goto	CK_LOW		; wait till busy flag clear
	nop
	bcf		PORTA,0		; enable low
	bcf		PORTA,1		; R/W low (write)
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001011'	; set PORTB as outputs
	movwf	TRISB
	bcf		STATUS,RP0	; memory bank 0	
	call	DELAYms
	return
CK_LOW
	bsf	PORTA,0
	bcf	PORTA,0		; enable high LOW bits accessed
	goto	CK_AGN


; count the input frequency pulses
 
CK_CNT
	bcf	PORTB,2		; prevent frequency input to RA4
	bsf	PORTA,3		; enable clocking when RB2 goes high

; prescaler and register reset

	clrf	REG_A		; counter MS byte
	clrf	TIMER		; timer counter storage
	movf	SAMPLE,w	; SAMPLE time  
	movwf	STORE1		; sample time storage
	clrf	TMR0		; timer (counter) and prescaler reset to zero
	bcf		INTCON,T0IF	; clear timer overflow bit
	bsf		PORTB,2		; start counting frequency at RA4 input
	
CK_CNTA
	movlw 	0x04
	nop					; initial timing adjustment
	nop
	nop
	movwf	STORE3
CK_CNTW
	decfsz	STORE3,f
	goto	CK_CNTW	
	movlw	D'249'		; delay timing
	movwf	STORE2		; store value in register
CK_CNTB
	btfss	INTCON,T0IF	; has timer overflowed
	goto	CK_CNTC
	bcf		INTCON,T0IF	; clear overrange flag
	incfsz	REG_A,f		; increase most significant byte if zero then over
	goto	CK_CNTE
	goto	CK_CNTO		; overrange change range
CK_CNTC
	nop
	nop
	nop
CK_CNTE
	movlw	0x03		; extra delay	
	movwf	STORE3
	nop
	
CK_CNTD
	decfsz	STORE3,f	; delay loop
	goto	CK_CNTD	
	decfsz	STORE2,f
	goto	CK_CNTB
	decfsz	STORE1,f
	goto	CK_CNTA

; end of clock counting
	
	bcf		PORTB,2		; time period ended
	nop					; allow time for TMR0 to clock
	nop
	nop
	nop
	movf	TMR0,w		; get timer value
	movwf	REG_B		; mid significant byte
	btfss	INTCON,T0IF	; has timer overflowed
	goto	CK_CNTG
;	subwf	TIMER,f		; check for TMR0 overflow
;	btfss	STATUS,C
;	goto	CK_CNTG
;	btfss	STATUS,Z
	incf	REG_A,f
EOC
CK_CNTG
	clrf	REG_C		; clear ready to get prescaler CK_CNT
	incf	REG_C,f		; adjust up to compensate for decrement next
CK_CNTH
	 decf	REG_C,f
	bcf		PORTA,3		; clock TMR0 input
	bsf		PORTA,3
	movf	TMR0,w		; check if TMR0 has changed
	subwf	REG_B,w
	btfsc	STATUS,Z
	goto	CK_CNTH
	clrf	FLAG		; clear flag for 1s gating
	return  

; check if REG_A has overflowed. If so set flag to run 100ms gate instead 

CK_CNTO
	 bsf	FLAG,0		; set flag so to run 100ms gate
	return	

; Subroutine BCD (to convert 28-bit binary to 8-digit BCD)
; Binary value is in BIN1, BIN2, BIN3 & BIN4. BIN1 is LSB, BIN4 is MSB
; Result in BCD is in BCD1, BCD2, BCD3, BCD4 & BCD5. BCD1 is for overrange, 
; BCD2 is MSB, BCD5 is LSB

BIN_BCD
	movf	REG_A,w		; ms byte of frequency count
	movwf	BIN3		; next ms byte
	movf	REG_B,w
	movwf	BIN2
	movf	REG_C,w		; ls byte of counter
	movwf	BIN1
BINBCDX
	clrf	BIN4		; ms byte
	bcf		STATUS,C	; clear carry bit
	movlw	D'32'
	movwf	COUNT		; 32 in count
	clrf	BCD1		; set BCD registers to 0 
	clrf	BCD2
	clrf	BCD3
	clrf	BCD4
	clrf	BCD5

LOOPBCD
	rlf		BIN1,f		; LSB shift left binary registers
	rlf		BIN2,f
	rlf 	BIN3,f
	rlf		BIN4,f		; MSB
	rlf		BCD5,f		; LSB shift left BCD registers
	rlf		BCD4,f
	rlf		BCD3,f
	rlf		BCD2,f
	rlf		BCD1,f		; MSB

	decfsz	COUNT,f		; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust
	
; result in BCD1-5. (BCD1 overrange, BCD2 MS byte)

	swapf	BCD2,w		; get ms nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	ESEVN		; ms digit
	movf	BCD2,w		; get 2nd ms nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	ESIX

	swapf	BCD3,w		; get next nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	EFIVE		; ms digit
	movf	BCD3,w		; get next nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	EFOUR
	
	swapf	BCD4,w		; get ms nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	ETHREE		; ms digit
	movf	BCD4,w		; get 2nd ms nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	ETWO

	swapf	BCD5,w		; get ms nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	EONE		; ms digit
	movf	BCD5,w		; get 2nd ms nibble
	andlw	0x0F
	iorlw	0x30		; convert to ASCII
	movwf	EZERO
	return				; completed decimal to BCD operation

; subroutine decimal adjust

DECADJ
	movlw	BCD5		; BCD LSB address
	movwf	FSR			; pointer for BCD5
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD4
	movwf	FSR
	call 	ADJBCD
	movlw	BCD3
	movwf	FSR
	call 	ADJBCD
	movlw	BCD2
	movwf	FSR
	call 	ADJBCD
	movlw	BCD1
	movwf	FSR
	call 	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD
	movlw	0x03		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 1-5)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	0x30		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine


; subroutine to read EEPROM memory

EEREAD	
	bsf 	STATUS,RP0	; select memory bank 1
	movwf 	EEADR		; indirect special function register
	bsf		EECON1,RD	; read EEPROM
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP0	; select bank 0
	return

; subroutine to write to EEPROM

EWRITE
	bsf		STATUS,RP0	; select bank 1
	movwf	EEDATA		; data register
	bcf		INTCON,GIE	; disable interrupts

	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bsf		INTCON,GIE	; enable interrupts
	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank 0 
	return				; value written 

;
;**********************************************************************************************
        
;       24/24 PIC16 FIXED POINT DIVIDE ROUTINES
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: quotient AARG/BARG followed by remainder in REM
;       24/24 Bit Unsigned Fixed Point Divide 24/24 -> 24.24

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               24 bit unsigned fixed point divisor in BARGB0, BARGB1, BARGB2

;       Use:    CALL    FXD2424U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;		24 bit unsigned fixed point divisor in BARGB0, BARGB1,BARGB2
;               24 bit unsigned fixed point remainder in REMB0, REMB1, REMB2

;       Result: AARG, REM  <--  AARG / BARG



FXD2424U        CLRF            REMB0
                CLRF            REMB1
                CLRF            REMB2

                CLRF            TEMP

                RLF             AARGB0,W
                RLF             REMB2, F
                MOVF            BARGB2,W
                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F

                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                RLF             AARGB0, F

                MOVLW           7
                MOVWF           LOOPCOUNT

LOOPU2424A      RLF             AARGB0,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB0,0
                GOTO            UADD44LA

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44LA

UADD44LA        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44LA			RLF             AARGB0, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2424A

                RLF             AARGB1,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB0,0
                GOTO            UADD44L8

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44L8

UADD44L8        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44L8         RLF             AARGB1, F

                MOVLW           7
                MOVWF           LOOPCOUNT

LOOPU2424B      RLF             AARGB1,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB1,0
                GOTO            UADD44LB

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44LB

UADD44LB        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44LB         RLF             AARGB1, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2424B

                RLF             AARGB2,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB1,0
                GOTO            UADD44L16

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44L16

UADD44L16       ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44L16        RLF             AARGB2, F

                MOVLW           7
                MOVWF           LOOPCOUNT

LOOPU2424C      RLF             AARGB2,W
                RLF             REMB2, F
                RLF             REMB1, F
                RLF             REMB0, F
                RLF             TEMP, F
                MOVF            BARGB2,W
                BTFSS           AARGB2,0
                GOTO            UADD44LC

                SUBWF           REMB2, F
                MOVF            BARGB1,W
                BTFSS           STATUS,C
                INCFSZ          BARGB1,W
                SUBWF           REMB1, F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0, F
                CLRW
                BTFSS           STATUS,C
                MOVLW           1
                SUBWF           TEMP, F
                GOTO            UOK44LC

UADD44LC        ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F
                CLRW
                BTFSC           STATUS,C
                MOVLW           1
                ADDWF           TEMP, F
        
UOK44LC 		RLF             AARGB2, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU2424C

                BTFSC           AARGB2,0
                GOTO            UOK44L
                MOVF            BARGB2,W
	        	ADDWF           REMB2, F
                MOVF            BARGB1,W
                BTFSC           STATUS,C
                INCFSZ          BARGB1,W
                ADDWF           REMB1, F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0, F


UOK44L               return

	end
