
; Programmable Ignition 

; Initial power up RUN/VIEW mode set at line 1069 for MODE preset. 0,1,2,3 (VIEW,SITE,FULL,DIAG)

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1

; code protection
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0  & _DEBUG_OFF & _WRT_PROTECT_ALL & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _HS_OSC
;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations
; single map for 15rpm x 15 load MAP 
; MAP1 (1 TO 121) FOR 11 X 11 MAP

EEPROM1		equ	H'00'	; non-volatile storage for data 0  
EEPROM2		equ	H'01'	; non-volatile storage for data 1
EEPROM3		equ	H'02'	; non-volatile storage for data 2
EEPROM4		equ	H'03'	; non-volatile storage for data 3
EEPROM5		equ	H'04'	; non-volatile storage for data 4	
EEPROM6		equ	H'05'	; non-volatile storage for data 5
EEPROM7		equ	H'06'	; non-volatile storage for data 6 		
EEPROM8		equ	H'07'	; non-volatile storage for data 7 
EEPROM9		equ	H'08'	; non-volatile storage for data 8 
EEPROM10	equ	H'09'	; non-volatile storage for data 9
EEPROM11	equ	H'0A'	; non-volatile storage for data 10
EEPROM12	equ	H'0B'	; non-volatile storage for data 11
EEPROM13	equ	H'0C'	; non-volatile storage for data 12
EEPROM14	equ	H'0D'	; non-volatile storage for data 13
EEPROM15	equ	H'0E'	; non-volatile storage for data 14
EEPROM16	equ	H'0F'	; non-volatile storage for data 15
EEPROM17	equ	H'10'	; non-volatile storage for data 16
EEPROM18	equ	H'11'	; non-volatile storage for data 17
EEPROM19	equ	H'12'	; non-volatile storage for data 18  
EEPROM20	equ	H'13'	; non-volatile storage for data 19  
EEPROM21	equ	H'14'	; non-volatile storage for data 20
EEPROM22	equ	H'15'	; non-volatile storage for data 21 
EEPROM23	equ	H'16'	; non-volatile storage for data 22
EEPROM24	equ	H'17'	; non-volatile storage for data 23
EEPROM25	equ	H'18'	; non-volatile storage for data 24
EEPROM26	equ	H'19'	; non-volatile storage for data 25 
EEPROM27	equ	H'1A'	; non-volatile storage for data 26
EEPROM28	equ	H'1B'	; non-volatile storage for data 27
EEPROM29	equ	H'1C'	; non-volatile storage for data 28
EEPROM30	equ	H'1D'	; non-volatile storage for data 29
EEPROM31	equ	H'1E'	; non-volatile storage for data 30
EEPROM32	equ	H'1F'	; non-volatile storage for data 31 
EEPROM33	equ	H'20'	; non-volatile storage for data 32
EEPROM34	equ	H'21'	; non-volatile storage for data 33
EEPROM35	equ	H'22'	; non-volatile storage for data 34 
EEPROM36	equ	H'23'	; non-volatile storage for data 35
EEPROM37	equ	H'24'	; non-volatile storage for data 36
EEPROM38	equ	H'25'	; non-volatile storage for data 37
EEPROM39	equ	H'26'	; non-volatile storage for data 38 
EEPROM40	equ	H'27'	; non-volatile storage for data 39
EEPROM41	equ	H'28'	; non-volatile storage for data 40
EEPROM42	equ	H'29'	; non-volatile storage for data 41  
EEPROM43	equ	H'2A'	; non-volatile storage for data 42 
EEPROM44	equ	H'2B'	; non-volatile storage for data 43
EEPROM45	equ	H'2C'	; non-volatile storage for data 44
EEPROM46	equ	H'2D'	; non-volatile storage for data 45
EEPROM47	equ	H'2E'	; non-volatile storage for data 46
EEPROM48	equ	H'2F'	; non-volatile storage for data 47
EEPROM49	equ	H'30'	; non-volatile storage for data 48 
EEPROM50	equ	H'31'	; non-volatile storage for data 49
EEPROM51	equ	H'32'	; non-volatile storage for data 50
EEPROM52	equ	H'33'	; non-volatile storage for data 51
EEPROM53	equ	H'34'	; non-volatile storage for data 52
EEPROM54	equ	H'35'	; non-volatile storage for data 53
EEPROM55	equ	H'36'	; non-volatile storage for data 54
EEPROM56	equ	H'37'	; non-volatile storage for data 55
EEPROM57	equ	H'38'	; non-volatile storage for data 56
EEPROM58	equ	H'39'	; non-volatile storage for data 57 
EEPROM59	equ	H'3A'	; non-volatile storage for data 58 
EEPROM60	equ	H'3B'	; non-volatile storage for data 59 
EEPROM61	equ	H'3C'	; non-volatile storage for data 60
EEPROM62	equ	H'3D'	; non-volatile storage for data 61
EEPROM63	equ	H'3E'	; non-volatile storage for data 62
EEPROM64	equ	H'3F'	; non-volatile storage for data 63
EEPROM65	equ	H'40'	; non-volatile storage for data 64  
EEPROM66	equ	H'41'	; non-volatile storage for data 65
EEPROM67	equ	H'42'	; non-volatile storage for data 66
EEPROM68 	equ	H'43'	; non-volatile storage for data 67
EEPROM69	equ	H'44'	; non-volatile storage for data 68	
EEPROM70	equ	H'45'	; non-volatile storage for data 69
EEPROM71	equ	H'46'	; non-volatile storage for data 70 		
EEPROM72	equ	H'47'	; non-volatile storage for data 71 
EEPROM73	equ	H'48'	; non-volatile storage for data 72 
EEPROM74	equ	H'49'	; non-volatile storage for data 73
EEPROM75	equ	H'4A'	; non-volatile storage for data 74
EEPROM76	equ	H'4B'	; non-volatile storage for data 75
EEPROM77	equ	H'4C'	; non-volatile storage for data 76
EEPROM78	equ	H'4D'	; non-volatile storage for data 77
EEPROM79	equ	H'4E'	; non-volatile storage for data 78
EEPROM80	equ	H'4F'	; non-volatile storage for data 79
EEPROM81	equ	H'50'	; non-volatile storage for data 80
EEPROM82	equ	H'51'	; non-volatile storage for data 81
EEPROM83	equ	H'52'	; non-volatile storage for data 82  
EEPROM84	equ	H'53'	; non-volatile storage for data 83  
EEPROM85	equ	H'54'	; non-volatile storage for data 84
EEPROM86	equ	H'55'	; non-volatile storage for data 85 
EEPROM87	equ	H'56'	; non-volatile storage for data 86
EEPROM88	equ	H'57'	; non-volatile storage for data 87
EEPROM89	equ	H'58'	; non-volatile storage for data 88
EEPROM90    equ	H'59'	; non-volatile storage for data 89 
EEPROM91	equ	H'5A'	; non-volatile storage for data 90
EEPROM92	equ	H'5B'	; non-volatile storage for data 91
EEPROM93	equ	H'5C'	; non-volatile storage for data 92
EEPROM94	equ	H'5D'	; non-volatile storage for data 93
EEPROM95	equ	H'5E'	; non-volatile storage for data 94
EEPROM96	equ	H'5F'	; non-volatile storage for data 95 
EEPROM97	equ	H'60'	; non-volatile storage for data 96
EEPROM98	equ	H'61'	; non-volatile storage for data 97
EEPROM99	equ	H'62'	; non-volatile storage for data 98 
EEPROM100	equ	H'63'	; non-volatile storage for data 99
EEPROM101	equ	H'64'	; non-volatile storage for data 100
EEPROM102	equ	H'65'	; non-volatile storage for data 101
EEPROM103	equ	H'66'	; non-volatile storage for data 102 
EEPROM104	equ	H'67'	; non-volatile storage for data 103
EEPROM105	equ	H'68'	; non-volatile storage for data 104
EEPROM106	equ	H'69'	; non-volatile storage for data 105  
EEPROM107	equ	H'6A'	; non-volatile storage for data 106 
EEPROM108	equ	H'6B'	; non-volatile storage for data 107
EEPROM109	equ	H'6C'	; non-volatile storage for data 108
EEPROM110	equ	H'6D'	; non-volatile storage for data 109
EEPROM111	equ	H'6E'	; non-volatile storage for data 110
EEPROM112	equ	H'6F'	; non-volatile storage for data 111
EEPROM113	equ	H'70'	; non-volatile storage for data 112 
EEPROM114	equ	H'71'	; non-volatile storage for data 113
EEPROM115	equ	H'72'	; non-volatile storage for data 114
EEPROM116	equ	H'73'	; non-volatile storage for data 115
EEPROM117	equ	H'74'	; non-volatile storage for data 116
EEPROM118	equ	H'75'	; non-volatile storage for data 117
EEPROM119	equ	H'76'	; non-volatile storage for data 118
EEPROM120	equ	H'77'	; non-volatile storage for data 119
EEPROM121	equ	H'78'	; non-volatile storage for data 120

; MAP2 (1 TO 121) FOR 11 X 11 MAP (or single map continuation)

EEPROM122	equ	H'79'	; non-volatile storage for data 0 (or 121)
EEPROM123	equ	H'7A'	; non-volatile storage for 
EEPROM124	equ	H'7B'	; non-volatile storage for 
EEPROM125	equ	H'7C'	; non-volatile storage for 
EEPROM126	equ	H'7D'	; non-volatile storage for 
EEPROM127	equ	H'7E'	; non-volatile storage for 
EEPROM128	equ	H'7F'	; non-volatile storage for 

EEPROM129	equ	H'80'	; non-volatile storage for data 7 (or 128) 
EEPROM130	equ	H'81'	; non-volatile storage for data 
EEPROM131	equ	H'82'	; non-volatile storage for data 
EEPROM132	equ	H'83'	; non-volatile storage for data 
EEPROM133	equ	H'84'	; non-volatile storage for data 	
EEPROM134	equ	H'85'	; non-volatile storage for data 
EEPROM135	equ	H'86'	; non-volatile storage for data  		
EEPROM136	equ	H'87'	; non-volatile storage for data  
EEPROM137	equ	H'88'	; non-volatile storage for data  
EEPROM138	equ	H'89'	; non-volatile storage for data 
EEPROM139	equ	H'8A'	; non-volatile storage for data 
EEPROM140	equ	H'8B'	; non-volatile storage for data 
EEPROM141	equ	H'8C'	; non-volatile storage for data 
EEPROM142	equ	H'8D'	; non-volatile storage for data 
EEPROM143	equ	H'8E'	; non-volatile storage for data 
EEPROM144	equ	H'8F'	; non-volatile storage for data 
EEPROM145	equ	H'90'	; non-volatile storage for data 
EEPROM146	equ	H'91'	; non-volatile storage for data 
EEPROM147	equ	H'92'	; non-volatile storage for data   
EEPROM148	equ	H'93'	; non-volatile storage for data   
EEPROM149	equ	H'94'	; non-volatile storage for data 
EEPROM150	equ	H'95'	; non-volatile storage for data  
EEPROM151	equ	H'96'	; non-volatile storage for data 
EEPROM152	equ	H'97'	; non-volatile storage for data 
EEPROM153	equ	H'98'	; non-volatile storage for data 
EEPROM154	equ	H'99'	; non-volatile storage for data  
EEPROM155	equ	H'9A'	; non-volatile storage for data 
EEPROM156	equ	H'9B'	; non-volatile storage for data 
EEPROM157	equ	H'9C'	; non-volatile storage for data 
EEPROM158	equ	H'9D'	; non-volatile storage for data 
EEPROM159	equ	H'9E'	; non-volatile storage for data 
EEPROM160	equ	H'9F'	; non-volatile storage for data  
EEPROM161	equ	H'A0'	; non-volatile storage for data 
EEPROM162	equ	H'A1'	; non-volatile storage for data 
EEPROM163	equ	H'A2'	; non-volatile storage for data  
EEPROM164	equ	H'A3'	; non-volatile storage for data 
EEPROM165	equ	H'A4'	; non-volatile storage for data 
EEPROM166	equ	H'A5'	; non-volatile storage for data 
EEPROM167	equ	H'A6'	; non-volatile storage for data 
EEPROM168	equ	H'A7'	; non-volatile storage for data 
EEPROM169	equ	H'A8'	; non-volatile storage for data 
EEPROM170	equ	H'A9'	; non-volatile storage for data   
EEPROM171	equ	H'AA'	; non-volatile storage for data  
EEPROM172	equ	H'AB'	; non-volatile storage for data 
EEPROM173	equ	H'AC'	; non-volatile storage for data 
EEPROM174	equ	H'AD'	; non-volatile storage for data 
EEPROM175	equ	H'AE'	; non-volatile storage for data 
EEPROM176	equ	H'AF'	; non-volatile storage for data 
EEPROM177	equ	H'B0'	; non-volatile storage for data  
EEPROM178	equ	H'B1'	; non-volatile storage for data 
EEPROM179	equ	H'B2'	; non-volatile storage for data 
EEPROM180	equ	H'B3'	; non-volatile storage for data 
EEPROM181	equ	H'B4'	; non-volatile storage for data 
EEPROM182	equ	H'B5'	; non-volatile storage for data 
EEPROM183	equ	H'B6'	; non-volatile storage for data 
EEPROM184	equ	H'B7'	; non-volatile storage for data 
EEPROM185	equ	H'B8'	; non-volatile storage for data 
EEPROM186	equ	H'B9'	; non-volatile storage for data  
EEPROM187	equ	H'BA'	; non-volatile storage for data  
EEPROM188	equ	H'BB'	; non-volatile storage for data  
EEPROM189	equ	H'BC'	; non-volatile storage for data 
EEPROM190	equ	H'BD'	; non-volatile storage for data 
EEPROM191	equ	H'BE'	; non-volatile storage for data 
EEPROM192	equ	H'BF'	; non-volatile storage for data 
EEPROM193	equ	H'C0'	; non-volatile storage for data   
EEPROM194	equ	H'C1'	; non-volatile storage for data 
EEPROM195	equ	H'C2'	; non-volatile storage for data 
EEPROM196 	equ	H'C3'	; non-volatile storage for data 
EEPROM197	equ	H'C4'	; non-volatile storage for data 	
EEPROM198	equ	H'C5'	; non-volatile storage for data 
EEPROM199	equ	H'C6'	; non-volatile storage for data  		
EEPROM200	equ	H'C7'	; non-volatile storage for data  
EEPROM201	equ	H'C8'	; non-volatile storage for data  
EEPROM202	equ	H'C9'	; non-volatile storage for data 
EEPROM203	equ	H'CA'	; non-volatile storage for data 
EEPROM204	equ	H'CB'	; non-volatile storage for data 
EEPROM205	equ	H'CC'	; non-volatile storage for data 
EEPROM206	equ	H'CD'	; non-volatile storage for data 
EEPROM207	equ	H'CE'	; non-volatile storage for data 
EEPROM208	equ	H'CF'	; non-volatile storage for data 
EEPROM209	equ	H'D0'	; non-volatile storage for data 
EEPROM210	equ	H'D1'	; non-volatile storage for data 
EEPROM211	equ	H'D2'	; non-volatile storage for data   
EEPROM212	equ	H'D3'	; non-volatile storage for data   
EEPROM213	equ	H'D4'	; non-volatile storage for data 
EEPROM214	equ	H'D5'	; non-volatile storage for data  
EEPROM215	equ	H'D6'	; non-volatile storage for data 
EEPROM216	equ	H'D7'	; non-volatile storage for data 
EEPROM217	equ	H'D8'	; non-volatile storage for data 
EEPROM218   equ	H'D9'	; non-volatile storage for data  
EEPROM219	equ	H'DA'	; non-volatile storage for data 
EEPROM220	equ	H'DB'	; non-volatile storage for data 
EEPROM221	equ	H'DC'	; non-volatile storage for data 
EEPROM222	equ	H'DD'	; non-volatile storage for data 
EEPROM223	equ	H'DE'	; non-volatile storage for data 
EEPROM224	equ	H'DF'	; non-volatile storage for data  ; end of single map 15 x 15
EEPROM225	equ	H'E0'	; non-volatile storage for data 
EEPROM226	equ	H'E1'	; non-volatile storage for data 
EEPROM227	equ	H'E2'	; non-volatile storage for data  
EEPROM228	equ	H'E3'	; non-volatile storage for data 
EEPROM229	equ	H'E4'	; non-volatile storage for data 
EEPROM230	equ	H'E5'	; non-volatile storage for data 
EEPROM231	equ	H'E6'	; non-volatile storage for data  
EEPROM232	equ	H'E7'	; non-volatile storage for data 
EEPROM233	equ	H'E8'	; non-volatile storage for data 
EEPROM234	equ	H'E9'	; non-volatile storage for data   
EEPROM235	equ	H'EA'	; non-volatile storage for data  
EEPROM236	equ	H'EB'	; non-volatile storage for data 
EEPROM237	equ	H'EC'	; non-volatile storage for data 
EEPROM238	equ	H'ED'	; non-volatile storage for data 
EEPROM239	equ	H'EE'	; non-volatile storage for data 
EEPROM240	equ	H'EF'	; non-volatile storage for data 
EEPROM241	equ	H'F0'	; non-volatile storage for data  
EEPROM242	equ	H'F1'	; non-volatile storage for data end of map 2 (121)

; settings storage
EEPROM243	equ	H'F2'	; non-volatile storage for low rpm calculation modification 
EEPROM244	equ	H'F3'	; non-volatile storage for cylinder degree factor ms
EEPROM245	equ	H'F4'	; non-volatile storage for cylinder degree factor ls
;(1440/number of cylinders for 0.5 degree resolution)= 240 for 6-cylinder
;(720/number of cylinders for 1 degree resolution)
EEPROM246	equ	H'F5'	; non-volatile storage for dwell value 1=204.8us, 2=409.6us etc 
EEPROM247	equ	H'F6'	; non-volatile storage for load steps in MAP
EEPROM248	equ	H'F7'	; non-volatile storage for number of cylinders (1-12)
EEPROM249	equ	H'F8'	; non-volatile storage for (bit 0, 0.5 or 1 degree steps)
;(bit 1, invert or standard edge trigger)(bit 2, 1 or 2 maps) (bit 3, oscillator)
;(bit 4, interpolation)(bit 5, debounce)(bit 6, 4000/6000rpm knock limit)(bit 7, knock on/off)
EEPROM250	equ	H'F9'	; non-volatile storage for rpm calculation numerator MS byte
EEPROM251	equ	H'FA'	; non-volatile storage for rpm calculation numerator LS byte
; (46875 for 1cyl 2-stroke (2-cyl 4-stroke. 93750/cyl for 4-stroke)If 1/cylinder the 
; most ms byte is set at the calculation site
EEPROM252	equ	H'FB'	; non-volatile storage for min rpm 
EEPROM253	equ	H'FC'	; non-volatile storage for max rpm
EEPROM254	equ	H'FD'	; non-volatile storage for min load
EEPROM255	equ	H'FE'	; non-volatile storage for max load
EEPROM256	equ	H'FF'	; non-volatile storage for rpm steps in MAP

; bank 0 RAM

INPUT			equ	H'20'	; input value
AD_CK			equ	H'21'	; clock counter for A/D conversion
VIEW			equ	H'22'	; input viewing value
PORTA_STO		equ	H'23'	; storage of PORTA	
SETT_CHNG		equ	H'24'	; settings changed (the LK3 has been changed)
VW_FLAG	 		equ	H'25'	; view run flag to add delay 
KNOCK_CYCLE		equ	H'26'	; knock sensor firing cycle counter
EDGE_CALCU_SEL	equ	H'27'	; edge/calc/firing select
DWELL_CALC		equ	H'28'	; calculated dwell based on supply and links
MODE			equ	H'29'	; run or view mode
	
BCD_0			equ	H'2A'	; MS bcd value
BCD_1			equ	H'2B'	; LS binary coded decimal value
BIN_0			equ	H'2C'	; 8-bit binary value
TEMP			equ	H'2D'	; data storage (BCD convert)
CNT_8			equ	H'2E'	; counter in BCD routine
OUTPUT			equ	H'2F'	; output offset value
OUT1			equ	H'30'	; ms decimal display value
OUT2			equ	H'31'	; mid decimal display value
OUT3			equ	H'32'	; ls decimal display value
STORE1			equ	H'33'	; delay counter	
STORE2			equ	H'34'	; delay counter
STORE3			equ	H'35'	; delay counter
D_STO			equ	H'36'	; display data storage
SW_VAL			equ	H'37'	; switch value
KNOCK_COUNT		equ	H'38'	; duration counter for measurement of knocking
STEP			equ	H'39'	; step increment or decrement value
E_COUNT			equ	H'3A'	; counter to provide default settings in all EEPROM locations
TIMER0_H		equ	H'3B'	; ms byte for timer 0
TIMER0_HH		equ	H'3C'	; ms byte for timer 0
PORTB_STO		equ	H'3D'	; storage of PORTB
MAP_STO			equ	H'3E'	; previous 1 or 2 MAP setting 
SETT_VAL		equ	H'3F'	; settings value
IN_STO			equ	H'40'	; input value store
TIMERHH			equ	H'41'	; timer 1 high byte store
TIMERH			equ	H'42'	; timer 1 high byte store
TIMERL			equ	H'43'	; timer 1 low byte store
TIMER1_H		equ	H'44'	; timer 1 ms 16-bit byte
TIMER1_HH		equ	H'45'	; timer 1 24-bit byte
DWELL			equ	H'46'	; dwell value
CONVERSION		equ	H'47'	; delay for setting up A/D 		
CYL_DEG0		equ	H'48'	; cylinder factor for degrees calculation
CYL_DEG1		equ	H'49'	; cylinder factor for degrees calculation
TIMERL1			equ	H'4A'	; timer low byte store
TIMERH1			equ	H'4B'	; timer high byte store
TIMERHH1		equ	H'4C'	; timer high byte store
LOW_RPM			equ	H'4D'	; LOW RPM value
DEBOUNCE		equ	H'4E'	; debounce counter
LAST_EEREAD		equ	H'4F'	; last EEREAD value
TIMER2_H		equ	H'50'	; ms byte for timer 0
TIMER2_HH		equ	H'51'	; ms byte for timer 0
TIMER2			equ	H'52'	; working timer 2
SPARK_DUR		equ	H'53'	; minimum spark duration timer
TIMER0			equ	H'54'	; working timer0 register
DWELL_TEMP		equ	H'55'	; temporary dwell store
RPM_0			equ	H'56'	; rpm calculation value ms byte numerator
RPM_1			equ	H'57'	; rpm calculation value ls byte numerator
ALTERNATE		equ	H'58'	; alternate calculations counter for rpm/dwell/MAP
CYLINDER_VAL	equ	H'59'	; cylinder number
RPM_VAL			equ	H'5A'	; rpm value
LOAD_D_A		equ	H'5B'	; load digital value
SW_PRESS		equ	H'5C'	; switch pressed flag
DEG_EDG_MAP		equ	H'5D'	; 0.5 or 1 degree steps, edger trigger and maps 2/1
STORE_COUNT		equ	H'5E'	; store counter

; Math
; warning!: addresses 5F to 6F are mirrored in bank 1 do not change 
TEMPD			equ H'5F'	; argument
AARGB0			equ H'60'	; argument Ms
AARGB1			equ H'61'	; argument ls
AARGB2			equ H'62'	; argument
AARGB3			equ	H'63'
AARGB4			equ H'64'	; argument
AARGB5			equ	H'65'  
BARGB0			equ H'66'	; argument Ms
BARGB1			equ	H'67'
BARGB2			equ	H'68'	
REMB0			equ	H'69'	; remainder
REMB1			equ	H'6A'	; remainder
TEMPB0			equ	H'6B'
TEMPB1			equ	H'6C'
TEMPB2			equ	H'6D'
TEMP1			equ	H'6E'	; temp register
LOOPCOUNT		equ	H'6F'	; loop counter

; All Banks RAM

W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt
MIN_LOAD		equ	H'72'	; minimum load value
LOAD_STEP		equ	H'73'	; load steps in map
MIN_RPM			equ	H'74'	; minimum RPM
RPM_STEP		equ	H'75'	; rpm steps in map
RPM_MAP			equ	H'76'	; rpm map value 
LOAD_MAP		equ	H'77'	; Load map value 
OVERFLOW		equ	H'78'	; overflow flag
DISPLAY_REFRESH	equ	H'79'	; display refresh timer counter
MAX_RPM			equ	H'7A'	; maximum rpm value
MAX_LOAD		equ	H'7B'	; maximum load value
TEMP_LOAD		equ	H'7C'	; REMB0 storage
PCLATH_STO		equ	H'7D'	; pclath storage
KNOCK			equ	H'7E'	; knock or pinging signal
STOW_EEREAD		equ	H'7F'	; storage of EEREAD

; bank 1 RAM

STO1_EEPROM		equ	H'A1'	; storage of load/rpm map adv/ret value
STO2_EEPROM		equ	H'A3'	; storage of load/rpm +1 adv/ret value
STO3_EEPROM		equ	H'A4'	; storage of load +1 /rpm map adv/ret value
STO4_EEPROM		equ	H'A5'	; storage of load +1 /rpm +1 adv/ret value 
OFF_RPM			equ	H'A6'	; rpm amount over the rpm site
OFF_LOAD		equ	H'A7'	; load value over the load site
STO1_2_EEPROM	equ	H'A8'	; storage of interpolated adv/ret value of 1 and 2
STO3_4_EEPROM	equ	H'A9'	; storage of interpolated adv/ret value of 3 and 4
TEMP_INTERP		equ	H'AA'	; temporary register
TEMP_NEW		equ	H'AB'	; temporary register
NEG_FLG			equ	H'AC'	; bit 0, negative flag (for indicating subtraction polarity)
STO5_EEPROM		equ	H'AD'	; storage of interpolated adv/ret value of 1_2 and 3_4

OFFSET_MS		equ	H'AE'	; ms counter offset for retard setting used in recalculation at edge detect
OFFSET_MID		equ	H'AF'	; counter offset for retard setting used in recalculation at edge detect
OFFSET_LS		equ	H'B0'	; ls counter offset for retard setting used in recalculation at edge detect
TMRX_L			equ	H'B1'	; recalculation timer registers
TMRX_H			equ	H'B2'	; recalculation timer registers
TMRX_HH			equ	H'B3'	; recalculation timer registers 
STARTUP			equ	H'B4'	; startup counter (counts up the initial sparks, no dwell till zero) 
	
; Math
; address mirror math registers from bank 0 into bank 1 so it can be stored easily during interrupt
; warning!: addresses DF to EF are mirrored in bank 0 do not change 
TEMPD_STO		equ H'DF'	; argument (equivalent to 5F in bank 0)
AARGB0_STO		equ H'E0'	; argument Ms
AARGB1_STO		equ H'E1'	; argument ls
AARGB2_STO		equ H'E2'	; argument
AARGB3_STO		equ	H'E3'
AARGB4_STO		equ H'E4'	; argument
AARGB5_STO		equ	H'E5'  
BARGB0_STO		equ H'E6'	; argument Ms
BARGB1_STO		equ	H'E7'
BARGB2_STO		equ	H'E8'	
REMB0_STO		equ	H'E9'	; remainder
REMB1_STO		equ	H'EA'	; remainder
TEMPB0_STO		equ	H'EB'
TEMPB1_STO		equ	H'EC'
TEMPB2_STO		equ	H'ED'
TEMP1_STO		equ	H'EE'	; temp register
LOOPCOUNT_STO	equ	H'EF'	; loop counter

; preprogram EEPROM DATA at zero advance/retard
	
	ORG     H'2100'

; clear map data
; (0 degrees is 128)
; (0.5 degree advance is 129. 0.5 degree retard is 127)
; (1 degree advance is 130 (0.5deg resolution) or 129 (1degree resolution). 
; (1 degree retard  is 126 (0.5deg resolution). 127 (1degree resolution). 

; map A (11 x 11 = 121) ; 128 IS ZERO
	;   LOAD1...... ....................................................................LOAD11
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'; RPM1
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'; RPM11

; map B (11 x 11)
	;   LOAD1...........................................................................LOAD11
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'; RPM1
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'
	DE	D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128', D'128'; RPM11

; settings
	DE	D'00', D'00', D'240', D'05', D'17', D'06', B'00010000'
	DE	H'3D', H'09', D'00', D'60', D'00', D'250', D'06'

; *************************************************************************************************
; test data for Telstar

; timing map added (0.5 degree resolution)
; map A (with a 6 degree preset) 
	;   LOAD1...........................................................................LOAD11
;	DE	D'148', D'146', D'144', D'142', D'140', D'138', D'136', D'134', D'132', D'130', D'128' ; rpm1
;	DE	D'153', D'151', D'149', D'147', D'145', D'143', D'141', D'139', D'137', D'135', D'133'
;	DE	D'159', D'157', D'155', D'153', D'151', D'149', D'147', D'145', D'143', D'141', D'139'
;	DE	D'162', D'160', D'158', D'156', D'154', D'152', D'150', D'148', D'146', D'144', D'142'
;	DE	D'167', D'165', D'163', D'161', D'159', D'157', D'155', D'153', D'151', D'149', D'147'
;	DE	D'174', D'172', D'170', D'168', D'166', D'164', D'162', D'160', D'158', D'156', D'154'
;	DE	D'180', D'178', D'176', D'174', D'172', D'170', D'168', D'166', D'164', D'162', D'160'
;	DE	D'188', D'186', D'184', D'182', D'180', D'178', D'176', D'174', D'172', D'170', D'168'
;	DE	D'192', D'190', D'188', D'186', D'184', D'182', D'180', D'178', D'176', D'174', D'172'
;	DE	D'201', D'199', D'197', D'195', D'193', D'191', D'189', D'187', D'185', D'183', D'181'
;	DE	D'204', D'202', D'200', D'198', D'196', D'194', D'192', D'190', D'188', D'186', D'184' ; rpm11

; map B (with a zero degree preset. ie full map when 0 degrees is set on distributor)
	;   LOAD1...........................................................................LOAD11
;	DE	D'160', D'158', D'156', D'154', D'152', D'150', D'148', D'146', D'144', D'142', D'140' ; rpm1
;	DE	D'165', D'163', D'161', D'159', D'157', D'155', D'153', D'151', D'149', D'147', D'145'
;	DE	D'171', D'169', D'167', D'165', D'163', D'161', D'159', D'157', D'155', D'153', D'151'
;	DE	D'174', D'172', D'170', D'168', D'166', D'164', D'162', D'160', D'158', D'156', D'154'
;	DE	D'179', D'177', D'175', D'173', D'171', D'169', D'167', D'165', D'163', D'161', D'159'
;	DE	D'186', D'184', D'182', D'180', D'178', D'176', D'174', D'172', D'170', D'168', D'166'
;	DE	D'192', D'190', D'188', D'186', D'184', D'182', D'180', D'178', D'176', D'174', D'172'
;	DE	D'200', D'198', D'196', D'194', D'192', D'190', D'188', D'186', D'184', D'182', D'180'
;	DE	D'204', D'202', D'200', D'198', D'196', D'194', D'192', D'190', D'188', D'186', D'184'
;	DE	D'213', D'211', D'209', D'207', D'205', D'203', D'201', D'199', D'197', D'195', D'193'
;	DE	D'216', D'214', D'212', D'210', D'208', D'206', D'204', D'202', D'200', D'198', D'196' ; rpm11

; settings
;	DE	H'07', H'01', H'68', H'1E', H'04', H'04', H'D0'
;	DE  H'5B', H'8D', H'0A', H'32', H'97', H'BF', H'04'
; ******************************************************************

; start at memory 0

	org		0			; reset vector
	clrf	PORTB		; byte 0 portB,3 output low so coil off
	goto	MAIN		; byte 1

;	2 (spare byte)
;	3 (spare byte)

	org     4			; interrupt vector
; start interrupt by saving w and status registers  
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	movf	PCLATH,w	; keep PCLATH
	movwf	PCLATH_STO	; store PC lath
	bsf		PCLATH,3	; page 1
	goto	INTERRUPT	; interrupt continues at page 1 address

; ******************************************************************************************************
; engine firing, dwell and counters updates
	org		H'EA8'		; page 1

INTERRUPT ;(status,w and PCLATH saved at interrupt vector)
	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1	; bank 0
	
; check edge interrupt on programmed edge
	btfss	INTCON,INTF	; if edge 
	goto	CK_TMR0	; 
	bcf		INTCON,INTF	; clear flag
; decrease startup counter
	bsf		STATUS,RP0	; bank1	
	movf	STARTUP,w
	btfss	STATUS,Z
	decf	STARTUP,f	; reduce to zero (startup value)
	bcf		STATUS,RP0	; bank0
; check if debounce period ended
	movf	DEBOUNCE,w
	btfss	STATUS,Z	; if zero accept edge interrupt
	goto	CK_TMR0

	bcf		T2CON,2		; timer 2 off
	btfss	PIR1,TMR2IF	; if overflow increase Timer2_H & Timer2_HH
	goto	TRANSF2
; increase counters on overflow flag
	bcf		PIR1,TMR2IF	; flag cleared
	incf	TIMER2_H,f
	btfsc	STATUS,Z
	incfsz	TIMER2_HH,f
	goto	TRANSF2
	bcf		PORTB,3		; off
	bsf		OVERFLOW,0	; overflow flag
	goto	TRANSF2X	; bypass clearing overflow flag
TRANSF2
; clear overflow when startup ended
	bsf		STATUS,RP0	; bank 1
	movf	STARTUP,w	; startup value
	bcf		STATUS,RP0
	btfsc	STATUS,Z	; do not clear if STARTUP counter not zero	
	bcf		OVERFLOW,0	; overflow flag
TRANSF2X
; transfer count between edges
	movf	TIMER2_HH,w
	movwf	TIMERHH
	movf	TIMER2_H,w	; timer2 count
	movwf	TIMERH		; ms rpm counter
	movf	TMR2,w
	movwf	TIMERL		; ls rpm counter
; reset timer counters
	clrf	TIMER2_HH	; 24 bit counting
	clrf	TIMER2_H	; 16-bit
	clrf	TMR2		; clear timer 
	bcf		PIR1,TMR2IF	; clear flag
	bsf		T2CON,2		; timer 2 on restart timer
	movlw	D'3'		; 0.4ms debounce
	btfsc	DEG_EDG_MAP,5; when set, 2ms
	movlw	D'11'		; 2ms debounce
	movwf	DEBOUNCE	; reset debounce
  	bsf		EDGE_CALCU_SEL,3; flag to indicate calculation can be done
; alternate between timer0 and timer1 for firing and dwell start
	btfsc	EDGE_CALCU_SEL,7
	goto	TIM_0_CLR

; timer1
	bsf		EDGE_CALCU_SEL,7
	
; calculate 
	movf	LOW_RPM,w
	subwf	RPM_VAL,w	; when less than low-rpm value calculate here
	btfsc	STATUS,C
	goto	TIM_1_RET
	bsf		EDGE_CALCU_SEL,4; set called from interrupt flag
	bcf		PCLATH,3	; page 0
	call	CALC_SUB	; calculate the adv/retard firing location (PCLATH set at end of this routine when called from here)
	bcf		EDGE_CALCU_SEL,4; clear called from interrupt flag
TIM_1_RET	

; setup firing start point using timer1 (use as 8-bit counter)
	bcf		T1CON,0		; stop timer 1
	movlw	D'30'		; compensate firing point
	movwf	TMR1L		; clear timers
	clrf	TIMER1_H	; 16-bit counting
	clrf	TIMER1_HH	; 24 bit counting

; set timer 1 to overflow at timing point 
	movf	TIMERL1,w
	subwf	TMR1L,f
	movf	TIMERH1,w
	btfss	STATUS,C
	incfsz	TIMERH1,w
	subwf	TIMER1_H,f
	movf	TIMERHH1,w		; 24-bit
	btfss	STATUS,C
	incfsz	TIMERHH1,w
	subwf	TIMER1_HH,f		; timer 2 24-bit

	movlw	H'FF'			; set 16-bit timer at FF for over when LS counter overflows
	movwf	TMR1H			; 16-bit
	bcf		PIR1,TMR1IF		; clear overflow flag
	bsf		T1CON,0			; timer on
	bcf		EDGE_CALCU_SEL,2; timer 2 fired flag

; recalc firing now that edge is detected
	btfss	STOW_EEREAD,7	; if set then 0 or advance and should have fired already
	goto	CK_RECALC
CK_OVR
	btfsc	EDGE_CALCU_SEL,0	; if fired bypass
	goto	CK_TMR0
	bsf		INTCON,TMR0IF
	clrf	TIMER0_H
	clrf	TIMER0_HH
	goto	CK_TMR0

CK_RECALC
	btfsc	EDGE_CALCU_SEL,0; timer 0 fired flag. If set ignore recalculation
	goto	CK_TMR0
; set timer0 for firing
	clrf	TMR0		; 8-bit	
	bsf		STATUS,RP0	; regsters in bank 1
	clrf	TMRX_H		; 16-bit counting
	clrf	TMRX_HH		; 24 bit counting
	clrf	TMRX_L

	movf	OFFSET_LS,w
	subwf	TMRX_L,f
	movf	OFFSET_MID,w
	btfss	STATUS,C
	incfsz	OFFSET_MID,w
	subwf	TMRX_H,f
	movf	OFFSET_MS,w		; 24-bit
	btfss	STATUS,C
	incfsz	OFFSET_MS,w
	subwf	TMRX_HH,f		; timer 2 24-bit

; transfer timers bank 1 to bank 0 timers
	movf	TMRX_L,w
	bcf		STATUS,RP0
	movwf	TMR0		; timers 0
	bsf		STATUS,RP0
	movf	TMRX_H,w
	bcf		STATUS,RP0
	movwf	TIMER0_H	; 16-bit counting
	bsf		STATUS,RP0
	movf	TMRX_HH,w
	bcf		STATUS,RP0
	movwf	TIMER0_HH	; 24 bit counting
	goto	CK_TMR0

TIM_0_CLR
	bcf		EDGE_CALCU_SEL,7

; calculate
	movf	LOW_RPM,w	; low rpm value
	subwf	RPM_VAL,w	; when less than low rpm value calculate here
	btfsc	STATUS,C
	goto	TIM_0_RET
	
	bsf		EDGE_CALCU_SEL,4; set called from interrupt flag
	bcf		PCLATH,3	; page 0
	call	CALC_SUB	; calculate the adv/retard firing location
	bcf		EDGE_CALCU_SEL,4; clear called from interrupt flag

TIM_0_RET

; set timer0 for firing
	clrf	TMR0		; 8-bit	
	clrf	TIMER0_H	; 16-bit
	clrf	TIMER0_HH	; 24-bit
	movlw	D'23'		; compensate firing point
	movwf	TIMER0	 	; working register for tmr0
						; (one that does not change when working with numbers)

; set timer 0 to overflow at timing point 
	movf	TIMERL1,w
	subwf	TIMER0,f
	movf	TIMERH1,w
	btfss	STATUS,C
	incfsz	TIMERH1,w
	subwf	TIMER0_H,f
	movf	TIMERHH1,w		; 24-bit
	btfss	STATUS,C
	incfsz	TIMERHH1,w
	subwf	TIMER0_HH,f		; timer 0 24-bit
	movf	TIMER0,w		; working timer 0 value
	movwf	TMR0			; set timer 0
	
	bcf		EDGE_CALCU_SEL,0; timer 0 fired flag
	bcf		INTCON,TMR0IF

; recalc firing now that edge is detected
	btfss	STOW_EEREAD,7	; if set then 0 or advance and should have fired already
	goto	CK_RECALC1
CK_OVR1
	btfsc	EDGE_CALCU_SEL,2; if fired bypass
	goto	CK_TMR1
	bsf		PIR1,TMR1IF		; set counter flag so value is checked
	clrf	TIMER1_H
	clrf	TIMER1_HH
	goto	CK_TMR1

CK_RECALC1
	btfsc	EDGE_CALCU_SEL,2; timer 2 fired flag. If fired ignore recalculation
	goto	CK_TMR1
; setup firing start point using timer1 (use as 8-bit counter)
	bcf		T1CON,0		; stop timer 1
	bsf		STATUS,RP0	; registers in bank 1
	clrf	TMRX_L		; clear timers
	clrf	TMRX_H		; 16-bit counting
	clrf	TMRX_HH		; 24 bit counting

; set timer 1 to overflow at timing point 
	
	movf	OFFSET_LS,w
	subwf	TMRX_L,f
	movf	OFFSET_MID,w
	btfss	STATUS,C
	incfsz	OFFSET_MID,w
	subwf	TMRX_H,f
	movf	OFFSET_MS,w		; 24-bit
	btfss	STATUS,C
	incfsz	OFFSET_MS,w
	subwf	TMRX_HH,f		; timer 2 24-bit

; transfer timers bank 1 to bank 0 timers
	movf	TMRX_L,w
	bcf		STATUS,RP0
	movwf	TMR1L		; timers 1
	bsf		STATUS,RP0
	movf	TMRX_H,w
	bcf		STATUS,RP0
	movwf	TIMER1_H	; 16-bit counting
	bsf		STATUS,RP0
	movf	TMRX_HH,w
	bcf		STATUS,RP0
	movwf	TIMER1_HH	; 24 bit counting

	movlw	H'FF'			; set 16-bit timer at FF for over when LS counter overflows
	movwf	TMR1H			; 16-bit
	bsf		T1CON,0			; timer on
	goto	CK_TMR1

CK_TMR0
; check for the latest interrupt flags
	btfsc	INTCON,INTF	; if edge 
	goto	INTERRUPT

	btfss	INTCON,TMR0IF
	goto	CK_TMR1
	bcf		INTCON,TMR0IF
; decrease debounce counter
	movf	DEBOUNCE,w	; debounce counter
	btfsc	STATUS,Z	; if zero do not decrease
	goto	NO_DEC_DEBOUNCE
	decf	DEBOUNCE,f
	bcf		INTCON,INTF	; clear edge interrupt until debounce is 0
NO_DEC_DEBOUNCE
	btfsc	EDGE_CALCU_SEL,0	; if fired out
	goto	CK_TMR1
	movf	TIMER0_H,w		; if both timers 0 fire
	btfss	STATUS,Z
	goto	NXT_TMR0
	movf	TIMER0_HH,w
	btfsc	STATUS,Z
	goto	FIRER0
NXT_TMR0
	incfsz	TIMER0_H,f
	goto	CK_TMR1
	incfsz	TIMER0_HH,f	; increase 24bit counter when 16-bit overflows
	goto	CK_TMR1
FIRER0
; fire 
	btfsc	EDGE_CALCU_SEL,0	; if fired bypass
	goto	CK_TMR1
FIRE0
	bsf		EDGE_CALCU_SEL,0	; fired flag
	bcf		PORTB,3		; fire
	movlw	D'5'		; 204.8us/value
	movwf	SPARK_DUR	; spark duration minimum @ 1.024ms
	movlw	D'29'		; 6ms
	movwf	KNOCK_COUNT	; knock period for detection

CK_TMR1
; check for the latest interrupt flags
	btfsc	INTCON,INTF	; if edge 
	goto	INTERRUPT
	btfsc	INTCON,TMR0IF; timer 0 overflow
	goto	CK_TMR0
	
	btfss	PIR1,TMR1IF	; if timer 1 overflow
	goto	CK_TMR2

	movlw	H'FF'		; set 16-bit timer at FF for over when LS counter overflows
	movwf	TMR1H		; 16-bit
	bcf		PIR1,TMR1IF	; clear flag
; spark duration
	movf	SPARK_DUR,w	; spark duration counter
	btfss	STATUS,Z	; when zero stop decrementing
	decf	SPARK_DUR,f	; reduce by 1
; knocking detect duration
	movf	KNOCK_COUNT,w
	btfss	STATUS,Z
	decf	KNOCK_COUNT,f
	btfsc	EDGE_CALCU_SEL,2	; if fired out
	goto	CK_TMR2

	movf	TIMER1_H,w		; if both timers 0 fire
	btfss	STATUS,Z
	goto	NXT_TMR1
	movf	TIMER1_HH,w
	btfsc	STATUS,Z
	goto	FIRER1
NXT_TMR1
	incfsz	TIMER1_H,f
	goto	CK_TMR2
	incfsz	TIMER1_HH,f
	goto	CK_TMR2

FIRER1
; fire 
	btfsc	EDGE_CALCU_SEL,2	; if fired bypass
	goto	CK_TMR2
FIRE1
	bsf		EDGE_CALCU_SEL,2	; fired flag
	bcf		PORTB,3		; fire
	movlw	D'5'		; 204.8us/value
	movwf	SPARK_DUR	; spark duration minimum @ 1.024ms
; knock cycle counter decrease on every spark FIRER2 until zero
	movf	KNOCK_CYCLE,w
	btfss	STATUS,Z
	decf	KNOCK_CYCLE,f

CK_TMR2
; check for the latest interrupt flags
	btfsc	INTCON,INTF	; if edge 
	goto	INTERRUPT
	btfsc	INTCON,TMR0IF; timer 0 overflow
	goto	CK_TMR0
	btfsc	PIR1,TMR1IF	; if timer 1 overflow
	goto	CK_TMR1

; increase counters 2 on overflow flag
	btfss	PIR1,TMR2IF	; if timer 2 overflow
	goto	CK_DWELL0
	bcf		PIR1,TMR2IF	; flag cleared
	incf	TIMER2_H,f
	btfss	STATUS,Z
	goto	CK_DWELL0
	incf	TIMER2_HH,w
	btfsc	STATUS,Z	; if zero clear firing
	bcf		PORTB,3		; off
	incf	TIMER2_HH,f	; next count
	btfss	TIMER2_HH,5	; when set: off	
	goto	CK_OSC_RUN
	bcf		PORTB,3		; off
	bsf		OVERFLOW,0	; overflow flag
; set startup
	movlw	D'02'		; startup value
	bsf		STATUS,RP0	; page 1
	movwf	STARTUP
	bcf		STATUS,RP0	; page 0	
	goto	CK_DWELL0	; bypass clearing overflow flag
CK_OSC_RUN
	btfss	DEG_EDG_MAP,3; when set run internal oscillator
	goto	CK_DWELL0
; oscillator
	btfss	TIMER2_HH,2	; oscillator rate
	goto	CK_DWELL0
	bsf		INTCON,INTF	; set edge interrupt detect flag

CK_DWELL0
; check for the latest interrupt flags
	btfsc	INTCON,INTF	; if edge 
	goto	INTERRUPT
	btfsc	INTCON,TMR0IF; timer 0 overflow
	goto	CK_TMR0
	btfsc	PIR1,TMR1IF	; if timer 1 overflow
	goto	CK_TMR1

; wait till spark duration complete
	movf	SPARK_DUR,w
	btfss	STATUS,Z
	goto	CK_DWELL1
	
; check against dwell count
	movf	DWELL_CALC,w
	sublw	D'0'		; negate
	subwf	TIMER0_H,w
	btfss	STATUS,C
	goto	CK_DWELL1
	movf	TIMER0_HH,w
	xorlw	H'FF'
	btfss	STATUS,Z
	goto	CK_DWELL1
; start dwell when startup is at 0
	bsf		STATUS,RP0	; bank 1
	movf	STARTUP,w	; startup value
	bcf		STATUS,RP0
	btfsc	STATUS,Z	; no dwell if STARTUP counter not zero	
	bsf		PORTB,3		; dwell
	clrf	KNOCK_COUNT	; knock counter cleared to prevent read of knock signal

CK_DWELL1
; check for the latest interrupt flags
	btfsc	INTCON,INTF	; if edge 
	goto	INTERRUPT
	btfsc	INTCON,TMR0IF; timer 0 overflow
	goto	CK_TMR0
	btfsc	PIR1,TMR1IF	; if timer 1 overflow
	goto	CK_TMR1

; wait till spark duration complete
	movf	SPARK_DUR,w
	btfss	STATUS,Z
	goto	RECLAIM

; check timer against dwell count
	movf	DWELL_CALC,w
	sublw	D'0'
	subwf	TIMER1_H,w
	btfss	STATUS,C
	goto	RECLAIM
	movf	TIMER1_HH,w
	xorlw	H'FF'
	btfss	STATUS,Z
	goto	RECLAIM	
; start dwell when startup is at 0
	bsf		STATUS,RP0	; bank 1
	movf	STARTUP,w	; startup value	
	bcf		STATUS,RP0	; bank0
	btfsc	STATUS,Z	; no dwell if STARTUP counter not zero
	bsf		PORTB,3		; dwell
	clrf	KNOCK_COUNT	; knock counter cleared
	goto	RECLAIM

; end of interrupt reclaim w and status
RECLAIM
; check for the latest interrupt flags
	
	movf	DEBOUNCE,w
	btfss	STATUS,Z	; if zero check interrupt edge
	goto	OTHER_INTER1
	btfsc	INTCON,INTF	; if edge 
	goto	INTERRUPT
	goto	OTHER_INTER
OTHER_INTER1
	bcf		INTCON,INTF	; clear during debounce
OTHER_INTER
	btfsc	INTCON,TMR0IF; timer 0 overflow
	goto	CK_TMR0
	btfsc	PIR1,TMR1IF	; if timer 1 overflow
	goto	CK_TMR1

	movf	PCLATH_STO,w; restore PCLATH	
	movwf	PCLATH
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;******************************************************************************************* 
	org		H'0B'		; page 0
MAIN
	bsf		STATUS,RP0	; select memory bank 1
	movlw	D'02'
	movwf	STARTUP		; startup value
	movlw	H'FF'
	movwf	PR2			; timer2 match
; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'00000001'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00111111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'11000001'	; settings (pullups disabled TMR0/4)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00001100'	; AN2,3 analog inputs
	movwf	ANSEL
	movlw	B'00000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'010010000'	; Fosc, channel 2 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

	movlw	B'00100001'	; timer 1 fosc/4 /4
	movwf	T1CON

	movlw	B'00000101'	; timer 2 fosc/4 /4 1:1 postscaler
	movwf	T2CON

; initial conditions
INITIAL
; initialise registers
	movlw	H'0E'		; settings
	movwf	SETT_VAL	; settings value to show settings
			
	bsf		OVERFLOW,0	; overflow flag

	movlw	D'128'
	movwf	STOW_EEREAD	; initial setting

; clear registers using FSR
;	clrf	KNOCK_CYCLE
;	clrf	INPUT		; initial input = 0
;	clrf	VIEW		; initial viewing input 0
;	clrf	AD_CK		; A/D clock counter
;	clrf	EDGE_CALCU_SEL; fired,calculate,alternate timer select
;	clrf	VW_FLAG		; view run flag
;	clrf	DWELL_CALC	; set at high dwell
;	clrf	SETT_CHNG	; change required for display
;	clrf	PORTA_STO	; portA storage
;	clrf	MODE		; display mode

	movlw	H'20'		; do not change. start address
	movwf	FSR
CLR_NXT
	clrf	INDF
	incf	FSR,f		; next memory
	btfss	FSR,4		; reached 2F
	goto	CLR_NXT

;*** change here for optional stsrtup mode selection
	movlw	H'01'		; set display RUN/VIEW mode at startup. 1=SITE
;						; 2=FULL, 3=DIAG, 0=VIEW)	
	movwf	MODE		; set to initial mode
	clrf	KNOCK		; knocking value to zero

; get stored values

; low rpm value
	movlw	EEPROM243	; low rpm storage
	call	EEREAD
	movwf	LOW_RPM		; store value

; cylinder degree factor
; (1440/number of cylinders for 0.5 degree resolution)= 240 for 6-cylinder

	movlw	EEPROM244	; cylinder degree factor ms
	call	EEREAD
	movwf	CYL_DEG0	; store value
	movlw	EEPROM245	; cylinder degree factor ls
	call	EEREAD
	movwf	CYL_DEG1	; store value

; rpm calculation numerator 
; 46875 for 1-cyl 2-stroke (2-cyl 4-stroke). (93750/cyl for 4-stroke)
; If 1-cylinder the most ms byte is set at the calculation site

	movlw	EEPROM250	; rpm calculation factor ms
	call	EEREAD
	movwf	RPM_0		; store value
	movlw	EEPROM251	; rpm calculation factor ls
	call	EEREAD
	movwf	RPM_1		; store value

; dwell
	movlw	EEPROM246	; dwell
	call	EEREAD
	movwf	DWELL		; store value
	
; cylinders
	movlw	EEPROM248	; cylinders 1-12
	call	EEREAD
	movwf	CYLINDER_VAL; store value

; degree resolution, edge trigger and maps 2 or 1 plus knock option	
	movlw	EEPROM249	; 0.5 or 1 degree resolution etc
	call	EEREAD
	movwf	DEG_EDG_MAP ; bit 0 clear then 0.5 degree, set = 1 degree	
	movwf	MAP_STO		; used to detect a change for number of MAPs
	
; min load
	movlw	EEPROM254	; min load
	call	EEREAD
	movwf	MIN_LOAD

; min rpm
	movlw	EEPROM252	; min rpm
	call	EEREAD
	movwf	MIN_RPM

; load steps
	movlw	EEPROM247	; load steps
	call	EEREAD
	movwf	LOAD_STEP

; RPM steps
	movlw	EEPROM256	; rpm steps
	call	EEREAD
	movwf	RPM_STEP

; maximum rpm
	movlw	EEPROM253	; max rpm
	call	EEREAD
	movwf	MAX_RPM

; maximum load value
	movlw	EEPROM255	; max load
	call	EEREAD
	movwf	MAX_LOAD

; setup interrupt edge
SET_EDGE
	btfss	DEG_EDG_MAP,1	; if low invert
	goto	L_INT1			; set high going edge
	bsf		STATUS,RP0		; bank 1
	bcf		OPTION_REG,INTEDG; interrupt every falling edge
	bcf		STATUS,RP0		; bank 0
	goto	SETUP
L_INT1
	bsf		STATUS,RP0		; bank 1
	bsf		OPTION_REG,INTEDG; interrupt every rising edge
	bcf		STATUS,RP0		; bank 0
SETUP
	call	INIT_LC	
	movlw	H'FF'		; start up delay
	call	DELAYX
	call	INIT_LC
	call	DELAYms
	call	INIT_LC
	call	DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD		; 
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX

	bsf		PCLATH,3	; page 1
	call	CHARACTR_GEN;generate characters for knock
	bcf		PCLATH,3	; page 0

; allow interrupts
ALL_INTERRUPTS
	bsf		INTCON,TMR0IE	; timer 0 interrupt enable
	bsf		INTCON,INTE	; external interrupt
	bcf		INTCON,INTF
	bsf		STATUS,RP0	; select memory bank 1		

	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0

	bcf		PIR1,TMR1IF	; timer 1 interrupt flag
	bcf		PIR1,TMR2IF	; timer 2 interrupt flag
	bsf		INTCON,PEIE	; enable periperal interrupts 	 
	bsf 	INTCON,GIE	; set global interrupt enable 

BACKGROUND
; alternate calculations
	incf	ALTERNATE,f 
	btfsc	ALTERNATE,1		; if bit 1 set check bit 0
	goto	CK_ALT_0
	btfss	ALTERNATE,0		; if bit zero set, do A_D for dwell
	goto	DWELL_A_D		; measure dwell input from supply
	goto	MEAS_LOAD		; measure load input
CK_ALT_0
	btfss	ALTERNATE,0
	goto	MEAS_RPM

DISPLAY_UPDATE			; refresh display settings
	movf	DISPLAY_REFRESH,w
	xorlw	D'255'		; when 255 run display update
	btfsc	STATUS,Z
	goto	UP_VAL_DSP	
; update values in display
	decfsz	DISPLAY_REFRESH,f; update at slower rate
	goto	CALCULATE
	movlw	D'250'		; do not use 255
	movwf	DISPLAY_REFRESH
; check if normal or Settings
	btfsc	PORTA,5		
	goto	UP_VAL_DSP	; settings mode 

BY_DSP
; if display already updated, bypass
	btfss	SETT_CHNG,1	; if set no update
	goto	SETTINGS
	goto	CALCULATE

UP_VAL_DSP
	clrf	SETT_CHNG	; clear display flag
	bsf		SETT_CHNG,0	; set re-run display update flag (stops full update but only values)
; check modes
; Run and view mode check map
;
	movlw	H'83'		; address line 1 pos 3
	call	LOAD
; check map arrangement
	btfss	DEG_EDG_MAP,2	; if set then single map 
	goto	DISP_A_B1
	call	SPACE2		; single map
	goto	GET_OUTPUT_VALU
; display A or B map
DISP_A_B1
	movlw	B'11100000'	; map1 alpha
	btfsc	PORTA,4		; low is map1
	movlw	B'11100010'	; map2 beta
	call	DRV_LCD
	call	SPACE1

; get output value
GET_OUTPUT_VALU
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; if zero view mode
	goto	RN_MD1
	movf	VIEW,w		; viewing input value 
	goto	IN_VW11

RN_MD1
	movf	INPUT,w		; input 
IN_VW11
	movwf	IN_STO		; stored value
	movwf	TEMP
; if single map bypass checking for map2
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	SINGLE1_MAP
	movlw	D'121'
	btfsc	PORTA,4		; if set; map2
	addwf	TEMP,f		; add 121 for map 2
SINGLE1_MAP
	movf	MODE,w
	xorlw	D'2'		; when mode is (FULL) '2' show interpolated value
	btfsc	STATUS,Z
	goto	INTERP_MAP
	movf	MODE,w
	xorlw	D'3'		; when mode is (DIAG) '3' show interpolated value if set for on
	btfss	STATUS,Z
	goto	NO_INTERP
	btfss	DEG_EDG_MAP,4	; if on interpolate
	goto	NO_INTERP
; include knock retard
; if knock is on
INTERP_MAP
	btfsc	DEG_EDG_MAP,7; when set knock retard is on
	goto	INTERP_ON
	movf	STOW_EEREAD,w
	goto	INTERP_Y
INTERP_ON	
	movf	KNOCK,w
	subwf	STOW_EEREAD,w; stored variation value (0 to 127)
 	btfss	STATUS,C	; if negative keep BARGB2 at 0
	movlw	H'00'
	goto	INTERP_Y 
NO_INTERP
	movf	TEMP,w
	call	EEREAD		; get EEPROM value
INTERP_Y
	movwf	OUTPUT
	btfsc	OUTPUT,7	; if bit 7 set then +
	goto	PLUS1
	movf	OUTPUT,w
	sublw	H'80'		; display shows offset from 128
	movwf	OUTPUT		; 
	movlw	A'-'		; minus sign
	call	DRV_LCD
	goto	VALU1
PLUS1
	movf	OUTPUT,w
	xorlw	B'10000000'
	btfsc	STATUS,Z	; if zero add space and bypass + sign
	goto	ADDSPCE1
	movlw	A'+'		; + sign
	call	DRV_LCD
	goto	VALU1
ADDSPCE1
	call	SPACE1		; space instead of +
VALU1
	movf	OUTPUT,w	; output value
	andlw	B'01111111'	; extract only 7 bits (bit 7 is sign)
; set up for 0.5 degree changes
	movwf	BIN_0		;
	bcf		STATUS,C
	btfss	DEG_EDG_MAP,0	; if clear 0.5 degree resolution
	rrf		BIN_0,f		; divide by 2 (bit 0 in OUTPUT determines 0.5)
	call	BCD_ASCII	; get bcd/ASCII value
	btfss	DEG_EDG_MAP,0	; if clear 0.5 degree resolution
	goto	MID_PT51
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD11
	call	SPACE1		; leading 0's to space

; mid digit
MID_PT51
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD21
	call	SPACE1		; leading 0's to space
	goto	LOAD31
LOAD11
	movf	OUT1,w
	call	DRV_LCD
LOAD21
	movf	OUT2,w
	call	DRV_LCD
LOAD31
	movf	OUT3,w
	call	DRV_LCD

	btfsc	DEG_EDG_MAP,0	; if clear 0.5 degree resolution
	goto	SPACE_INSTEAD1

; decimal point
	movlw	A'.'		; decimal point
	call	DRV_LCD
	movlw	A'0'
	btfsc	OUTPUT,0	; if set 0.5
	movlw	A'5'		; for 0.5
	call	DRV_LCD	

	movlw	H'DF'		; DEG symbol
	call	DRV_LCD
	goto	BY_SPACEX1
SPACE_INSTEAD1
	movlw	H'DF'		; DEG symbol
	call	DRV_LCD
BY_SPACEX1

; check display style
	movf	MODE,w
	xorlw	D'2'		; when 2 show interpolated values in the FULL display mode
	btfsc	STATUS,Z
	goto	LOAD_RPM_STEPS
	movf	MODE,w
	xorlw	D'3'		; when 3 show rpm and load actual values
	btfsc	STATUS,Z
	goto	LOAD_RPM_ACTUAL

; line 2 (RPM value)	
	movlw	H'C4'		; address line 2 pos 4
	call	LOAD
; get input value
; get rpm and load from input value (divide input by 11 for two Maps(or 15 for single map)
; result is rpm and remainder is load)
	movf	IN_STO,w 	; get stored input value 
	movwf	AARGB1		; numerator ls byte
	clrf	AARGB0		; numerator ms byts
	movlw	D'11'		; denominator is 11
	btfsc	DEG_EDG_MAP,2	; if set then single map
	movlw	D'15'
	movwf	BARGB0
	call	DIV16_8		; divide
	incf	REMB0,w
	movwf	TEMP_LOAD	; hold value
	incf	AARGB1,w	; result
	movwf	BIN_0		;
	call	BCD_ASCII	; get ASCII values
	
	movf	OUT2,w		; middle digit
	xorlw	H'30'		; is it 0
	btfss	STATUS,Z
	goto	LOAD81
	call	SPACE1 
	goto	LOAD51
LOAD81	
	movf	OUT2,w		; not zero so load value
	call 	DRV_LCD
LOAD51
	movf	OUT3,w
	call	DRV_LCD
	call	SPACE1

; line 2 show knock symbol if knocking
	movlw	H'C7'		; line position
	call	LOAD
	movf	KNOCK,w
	btfsc	STATUS,Z	; if zero no knock
	goto	L2_LOAD_SPACE
	bsf		PCLATH,3	; page 1
	call	KNOCK_DRV0	; knock symbol
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	goto	L2_LOAD_VALUE

; line 2 (Load Value)
L2_LOAD_SPACE
	call	SPACE1
L2_LOAD_VALUE
	movlw	H'CE'		; line 2 position E
	call	LOAD
; drive load value
	movf	TEMP_LOAD,w ; remainder
	movwf	BIN_0		;
	call	BCD_ASCII	; get ASCII values
	
	movf	OUT2,w		; middle digit
	xorlw	H'30'		; is it 0
	btfss	STATUS,Z
	goto	LOADL11
	call	SPACE1 
	goto	LOADL111
LOADL11	
	movf	OUT2,w		; not zero so load value
	call 	DRV_LCD
LOADL111
	movf	OUT3,w
	call	DRV_LCD
	goto	TEST_DELAY

; display rpm and load values plus the steps
LOAD_RPM_STEPS; (FULL display)
; line 2 (RPM value)	
	movlw	H'C3'		; address line 2 pos 3
	call	LOAD
; get input value
; get rpm and load from input value (divide input by 11 for two Maps(or 15 for single map)
; result is rpm and remainder is load)
	movf	IN_STO,w 	; get stored input value 
	movwf	AARGB1		; numerator ls byte
	clrf	AARGB0		; numerator ms byts
	movlw	D'11'		; denominator is 11
	btfsc	DEG_EDG_MAP,2	; if set then single map
	movlw	D'15'
	movwf	BARGB0
	call	DIV16_8		; divide
	incf	REMB0,w
	movwf	TEMP_LOAD	; hold value
	incf	AARGB1,w	; result
	movwf	BIN_0		;
	call	BCD_ASCII	; get ASCII values
	
	movf	OUT2,w		; middle digit
	xorlw	H'30'		; is it 0
	btfss	STATUS,Z
	goto	LOAD811
	call	SPACE1 
	goto	LOAD511
LOAD811	
	movf	OUT2,w		; not zero so load value
	call 	DRV_LCD
LOAD511
	movf	OUT3,w
	call	DRV_LCD
	movlw	A';'		; 
	call	DRV_LCD

; show RPM_offset
	bsf		STATUS,RP0	; bank1
	movf	OFF_RPM,w	; rpm offset
	bcf		STATUS,RP0	; bank 0
	movwf	BIN_0		;
	call	BCD_ASCII	; get ASCII values
	movf	OUT2,w		; middle digit
	xorlw	H'30'		; is it 0
	btfsc	STATUS,Z
	goto	LOAD512
LOAD812	
	movf	OUT2,w		; not zero so load value
	call 	DRV_LCD
LOAD512
	movf	OUT3,w
	call	DRV_LCD

; show knock symbol if knocking
	movf	KNOCK,w
	btfsc	STATUS,Z	; if zero no knock
	goto	L2_LOAD_SPACE1
	bsf		PCLATH,3	; page 1
	call	KNOCK_DRV0	; knock symbol
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	goto	L2_LOAD_VALUE1
L2_LOAD_SPACE1
	call	SPACE1
; line 2 (Load Value)
L2_LOAD_VALUE1
	movlw	H'CB'
	call	LOAD
	movf	TEMP_LOAD,w ; remainder
	movwf	BIN_0		;
	call	BCD_ASCII	; get ASCII values
	
	movf	OUT2,w		; middle digit
	xorlw	H'30'		; is it 0
	btfss	STATUS,Z
	goto	LOADL12
	call	SPACE1 
	goto	LOADL112
LOADL12	
	movf	OUT2,w		; not zero so load value
	call 	DRV_LCD
LOADL112
	movf	OUT3,w
	call	DRV_LCD
	movlw	A';'		; 
	call	DRV_LCD

; show LOAD_offset
	bsf		STATUS,RP0	; bank1
	movf	OFF_LOAD,w	; load offset
	bcf		STATUS,RP0	; bank 0
	movwf	BIN_0		;
	call	BCD_ASCII	; get ASCII values
	movf	OUT2,w		; middle digit
	xorlw	H'30'		; is it 0
	btfsc	STATUS,Z
	goto	LOAD513
LOAD813	
	movf	OUT2,w		; not zero so load value
	call 	DRV_LCD
LOAD513
	movf	OUT3,w
	call	DRV_LCD
	call	SPACE1
	goto	TEST_DELAY

LOAD_RPM_ACTUAL ; show actual rpm and load values
	bsf		PCLATH,3
	goto	LOAD_RPM_ACTUAL_CODE ;(in second 2k memory

TEST_DELAY
	movf	DISPLAY_REFRESH,w
	xorlw	D'255'	; when 255 run delay
	btfss	STATUS,Z
	goto	CALCULATE
	movlw	D'1'
	movwf	DISPLAY_REFRESH	
	movlw	D'200'		;  DELAYms
	movwf	STORE3
MOR_DEL1
	call	DELAYms
	decfsz	STORE3,f
	goto	MOR_DEL1
	goto	CALCULATE

MEAS_RPM 
; measure rpm	
; get captured value
	btfsc	OVERFLOW,0	; overflow flag if set then zero rpm
	goto	SET_RPM0	; clear rpm
	call	CALC_SUB	; calculate for firing
	bcf		INTCON,GIE	; stop interrupt
	movf	TIMERHH,w	; ms counter
	movwf	BARGB0
	movf	TIMERH,w
	movwf	BARGB1
	movf	TIMERL,w
	movwf	BARGB2		; ls byte
	bsf 	INTCON,GIE	; allow interrupt
; divide by 16 and remove ms 4-bytes
	rrf		BARGB0,f
	rrf		BARGB1,f	; /2
	rrf		BARGB2,f
	rrf		BARGB0,f
	rrf		BARGB1,f	; /4
	rrf		BARGB2,f
	rrf		BARGB0,f
	rrf		BARGB1,f	; /8
	rrf		BARGB2,f
	rrf		BARGB0,f
	rrf		BARGB1,f	; /16
	rrf		BARGB2,f
	movlw	B'00001111'
	andwf	BARGB0,f	; remove ms bits
	btfss	STATUS,Z	; if zero can calculate rpm
	goto	SET_RPM0	; set rpm at 0 since overrange
	movf	BARGB1,w	; transfer 
	movwf	BARGB0
	movf	BARGB2,w
	movwf	BARGB1
; numerator, If 1/cylinder set AARGB0 at 1
	clrf	AARGB0		; set AARGB0 at 0 for all except 1-cylinder engine
	decf	CYLINDER_VAL,w; if zero then set AARGB0 at 1 otherwise at 0
	btfsc	STATUS,Z
	incf	AARGB0,f	; set to 1
	movf	RPM_0,w		; ms byte stored in EEPROM
	movwf	AARGB1
	movf	RPM_1,w		; ls byte
	movwf	AARGB2	
	call	FXD2416U
	movf	AARGB2,w
	movwf	RPM_VAL
; result in RPM_VAL
	goto	CALCULATE	
SET_RPM0
	clrf	RPM_VAL
	goto	CALCULATE

; A/D conversion for input Voltage change dwell for lower voltage
DWELL_A_D

	call	CALC_SUB	; calculate for firing
; Channel 3 A/D value
; set A/D to channel 3
	movlw	B'01011001'	; Fosc, channel,3 etc
	movwf	ADCON0
	call	ACQUIRE_AD

; alter dwell with supply voltage 
; test for >12V, >9V and <7.2V respectively)
	movlw	D'195'
	subwf	ADRESH,w
	btfsc	STATUS,C	; 
	goto	GRT_V		; > 12V (x1)
	movlw	D'118'
	subwf	ADRESH,w
	btfss	STATUS,C
	goto	LESS_V		; < 7.2V (x4)
	movlw	D'146'
	subwf	ADRESH,w
	btfss	STATUS,C	; 
	goto	LESS_9		; < 9 V (x3) (x2 for between 9 & 12V)
; multiply by 2
	bcf		STATUS,C
	rlf		DWELL,w		; x2
	goto	SET_DWELL_VAL
LESS_9
; mult by 3
	bcf		STATUS,C
	rlf		DWELL,w		; x2
	addwf	DWELL,w		; x3
	goto	SET_DWELL_VAL	
GRT_V ; >12V
; set at normal x 1
	movf	DWELL,w		; for min dwell at 12V and above
	goto	SET_DWELL_VAL
LESS_V
; set at x 4
	bcf		STATUS,C
	rlf		DWELL,w		; x2 max dwell below 7.2V
	movwf	DWELL_TEMP
	bcf		STATUS,C
	rlf		DWELL_TEMP,w; x4
SET_DWELL_VAL
	movwf	DWELL_CALC
	goto	CALCULATE

MEAS_LOAD
; measure LOAD input
; set A/D to channel 2
	movlw	B'01010001'	; Fosc, channel,2 etc
	movwf	ADCON0
	call	ACQUIRE_AD	; get value
	movf	ADRESH,w	; 
	movwf	LOAD_D_A	 

; Measure knocking input
; only measure during spark duration. SPARK_DUR is >0 when firing coil
	movf	KNOCK_COUNT,w; 
	btfsc	STATUS,Z	; if zero do not measure
	goto	CALCULATE
; no knock detection for over 4000rpm or 6000rpm 
	movlw	D'60'		; 6000rpm
	btfsc	DEG_EDG_MAP,6; if set 4000rpm
	movlw	D'40'		; 4000rpm
COMPARE_LIMIT
	subwf	RPM_VAL,w
	btfsc	STATUS,C	; if RPM_VAL> for example 60 then over 6000rpm
	goto	NO_KNOCK	; set knock at 0
	
; set A/D to channel 1 for knock reading
RD_KNOCK
	movlw	B'01001001'	; Fosc, channel,1 etc
	movwf	ADCON0
	call	ACQUIRE_AD	; get value

; measure knocking input set knocking retard value in degrees (0 degrees for <64) progressively
; increase to 9 degrees at 3.75V, 12 degrees at 5V.for 1 degree resolution
; (4.5 and 6 degrees for 0.5 deg resolution)
	movlw	D'63'
	subwf	ADRESH,f	; take 63 away (range from 0 to 192)
	btfss	STATUS,C	; if negative no knock adjust as below 64
	goto	NO_KNOCK
		
	swapf	ADRESH,w	; swap 4-bit byte
	andlw	B'00001111'	; remove ms 4-byte
						; swaping and removing upper bits = divide by 16
	movwf	TEMPB0		; knocking retard value stored
; check if smaller than last knock value
	subwf	KNOCK,w		; if greater than last knock value increase
	btfsc	STATUS,C	; negative so greater than last knock value
	goto	DEC_KNOCK	; only decrease knock when knock_cycle counter is zero
NEW_KNOCK
	movf	TEMPB0,w
DEC_SLOW
	movwf	KNOCK		; new knock value

; set knock_cycle counter at 5 (10 firing cycles)
	movlw	D'5'
	movwf	KNOCK_CYCLE
	goto	CALCULATE
NO_KNOCK
	movf	KNOCK_CYCLE,w; if zero can clear knock otherwise not
	btfsc	STATUS,Z
	clrf	KNOCK
	goto	CALCULATE
DEC_KNOCK
	movf	KNOCK_CYCLE,w; if zero can reduce knock value otherwise not
	btfss	STATUS,Z
	goto	CALCULATE
	movf	KNOCK,w
	btfsc	STATUS,Z	; when knock is zero do not decrease
	goto	CALCULATE
	decf	KNOCK,w		; decrease knock value slowly
	goto	DEC_SLOW

CALCULATE
	call	CALC_SUB	; calculate for firing
; calculate sites RPM_MAP and LOAD_MAP from RPM_VAL and LOAD_D_A 
; based on MIN_RPM, RPM_STEPS, MIN_LOAD and LOAD_STEPS 
; load sites
; LOAD_MAP (0-10)(2-maps)or (0-14)(single map)= (LOAD_D_A - MIN_LOAD)/LOAD_STEP
; compare with maximum

	movf	MAX_LOAD,w
	subwf	LOAD_D_A,w	; compare LOAD with max
	btfsc	STATUS,C
	goto	SET_AT_MAX_LOAD	; set at 10	(14 for single map)
	movf	MIN_LOAD,w
	subwf	LOAD_D_A,w	; d/a value	
	btfss	STATUS,C	; if negative set at 0
	goto	SET_AT_MIN_LOAD	; zero
	movwf	AARGB1
	clrf	AARGB0
	movf	LOAD_STEP,w
	movwf	BARGB0
	call	DIV16_8
	movf	AARGB1,w
SET_LOAD_MAP
	movwf	LOAD_MAP
; check limit
	movlw	D'10'			; limit for 2-maps
	btfsc	DEG_EDG_MAP,2	; if set then 1 map
	movlw	D'14'
	subwf	LOAD_MAP,w
	btfsc	STATUS,C		; if plus set at max
	goto	SET_AT_MAX_LOAD
	movf	REMB0,w
	bsf		STATUS,RP0	; select memory bank 1
	movwf	OFF_LOAD	; amount offset from site toward the next
	bcf		STATUS,RP0	; select memory bank 0
	goto	CALC_RPM_MAP
SET_AT_MAX_LOAD
	movlw	D'10'			; limit for 2-maps
	btfsc	DEG_EDG_MAP,2	; if set then 1 map
	movlw	D'14'			; limit for single map
	movwf	LOAD_MAP		; at limit
	clrw					; off load at 0
	bsf		STATUS,RP0	; select memory bank 1
	movwf	OFF_LOAD	; amount offset from site toward the next
	bcf		STATUS,RP0	; select memory bank 0
	goto	CALC_RPM_MAP
SET_AT_MIN_LOAD	
	clrf	LOAD_MAP
	clrw					; off load at 0
	bsf		STATUS,RP0	; select memory bank 1
	movwf	OFF_LOAD	; amount offset from site toward the next
	bcf		STATUS,RP0	; select memory bank 0

CALC_RPM_MAP
; RPM_MAP (0-10) 2-maps (0-14 for single map)= (RPM_VAL - MIN_RPM)/RPM_STEP
; compare with maximum rpm
	call	CALC_SUB	; calculate for firing
	movf	MAX_RPM,w
	subwf	RPM_VAL,w	; compare rpm with max
	btfsc	STATUS,C
	goto	SET_AT_MAX_RPM	; set at 10	(14 for 1 map)	
	movf	MIN_RPM,w
	subwf	RPM_VAL,w	; rpm value
	btfss	STATUS,C	; if negative set at 0
	goto	SET_AT_MIN_RPM	; zero
	movwf	AARGB1
	clrf	AARGB0
	movf	RPM_STEP,w
	movwf	BARGB0
	call	DIV16_8
	movf	AARGB1,w
SET_RPM_MAP
	movwf	RPM_MAP
	movlw	D'10'			; limit for 2-maps
	btfsc	DEG_EDG_MAP,2	; if set then 1 map
	movlw	D'14'
	subwf	RPM_MAP,w
	btfsc	STATUS,C		; if plus set at max
	goto	SET_AT_MAX_RPM
	movf	REMB0,w
	bsf		STATUS,RP0	; select memory bank 1
	movwf	OFF_RPM		; amount offset from site toward the next
	bcf		STATUS,RP0	; select memory bank 0
	call	CALC_SUB	; calculate for firing
	goto	CALC_INPUT	
SET_AT_MAX_RPM
	movlw	D'10'
	btfsc	DEG_EDG_MAP,2	; if set then 1 map
	movlw	D'14'
	movwf	RPM_MAP		; at limit
	clrw				; off load at 0
	bsf		STATUS,RP0	; select memory bank 1
	movwf	OFF_RPM		; amount offset from site toward the next
	bcf		STATUS,RP0	; select memory bank 0
	goto	CALC_INPUT
SET_AT_MIN_RPM
	clrf	RPM_MAP
	clrw					; off load at 0
	bsf		STATUS,RP0	; select memory bank 1
	movwf	OFF_RPM		; amount offset from site toward the next
	bcf		STATUS,RP0	; select memory bank 0

CALC_INPUT
; convert load and rpm sites to an input value
; rpm map value x 11(2-maps) (x15 for single map)+ load 
	movf	RPM_MAP,w
	movwf	AARGB0
	movlw	D'11'
	btfsc	DEG_EDG_MAP,2	; if set then 1 map
	movlw	D'15'
	movwf	BARGB0
	call	EIGHTEIGHT	; multiply rpm value x 11 or 15
	movf	AARGB1,w
	addwf	LOAD_MAP,w

	movwf	INPUT		; input value 
; MAP1 or 2 set by PORTA,4, low=1
	movwf	TEMP
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	ONE_MAP_5
	movlw	D'121'		; add 121 for map 2
	btfsc	PORTA,4		; if set; map2
	addwf	TEMP,f	
ONE_MAP_5
	movf	TEMP,w
	call	EEREAD		; get degree value in w
	
	
; interpolation
INTERPOLATION
	bsf		STATUS,RP0	; select memory bank 1
	movwf	STO1_EEPROM	; main value
	bcf		STATUS,RP0	; select memory bank 0

;	movlw	D'3'
;	xorwf	MODE,w		; when diagnostic mode check for no interpolation
;	btfss	STATUS,Z	
;	goto	INTRP1
	btfsc	DEG_EDG_MAP,4	; if on interpolate
	goto	INTRP1
	bsf		STATUS,RP0	; select memory bank 1
	movf	STO1_EEPROM,w	; main value to w
	bcf		STATUS,RP0	; select memory bank 0
	goto	END_INTERPOLATION

; INTERPOLATE values (load to load and rpm to rpm interpolation) 

; RPM Interpolation
; No rpm interpolation if rpm load site is 11 (15)(LOAD_MAP=10 or 14)
INTRP1
	movlw	D'10'			; 2-maps	
	btfsc	DEG_EDG_MAP,2	; when set single map
	movlw	D'14'
	subwf	RPM_MAP,w	; subtract. When negative (ie map limit is over rpm map value) can interpolate
	btfsc	STATUS,C
	goto	NO_RPM_INTERP

; No rpm interpolation if rpm below minimum rpm (RPM_VAL<MIN_RPM)
	
	movf	RPM_VAL,w	; rpm_value
	subwf	MIN_RPM,w
	btfsc	STATUS,C	; if negative (ie rpm over min setting) can interpolate
	goto	NO_RPM_INTERP

; determine limits
	movlw	D'224'		; limit for single map
	btfsc	DEG_EDG_MAP,2	; if set single map
	goto	LIMIT_LEV
	movlw	D'241'		; if 241 or over for map 2, no interpolation	
	btfss	PORTA,4		; if set; map2
	movlw	D'120'		; limit for map 1 
	
LIMIT_LEV
; get value for next RPM site (same LOAD site)(add 11 or 15 to TEMP)
	bsf		STATUS,RP0	; select memory bank 1
	movwf	TEMP_INTERP	; limit value (120,240 or 224)
	bcf		STATUS,RP0	; select memory bank 0
	movf	TEMP,w		; adv/ret value
	addlw	D'11'			
	btfsc	DEG_EDG_MAP,2	; when set single map
	addlw	D'4'		; add another 4 to make 15
	bsf		STATUS,RP0	; select memory bank 1
	subwf	TEMP_INTERP,w; compare with limit
	bcf		STATUS,RP0	; select memory bank 0
	btfss	STATUS,C	; if plus can interpolate
	goto	NO_RPM_INTERP
	movf	TEMP,w		; adv/ret value
	addlw	D'11'			
	btfsc	DEG_EDG_MAP,2	; when set single map
	addlw	D'4'		; another 4 for 15
	bsf		STATUS,RP0	; select memory bank 1
	movwf	TEMP_NEW	; store value
	bcf		STATUS,RP0	; select memory bank 0
	call	EEREAD
	bsf		STATUS,RP0	; select memory bank 1
	movwf	STO2_EEPROM	; next value 
	bcf		STATUS,RP0	; select memory bank 0
	goto	NEXT_RPM_INTERP
NO_RPM_INTERP
	bsf		STATUS,RP0	; select memory bank 1
	movf	STO1_EEPROM,w	; original main value
	movwf	STO2_EEPROM	; next value 
	bcf		STATUS,RP0	; select memory bank 0

NEXT_RPM_INTERP

; No load interpolation if LOAD_D_A > MAX_LOAD 
	movf	MAX_LOAD,w	; load
	subwf	LOAD_D_A,w
	btfsc	STATUS,C	; if negative (ie load under max setting) can interpolate
	goto	NO_LOAD_INTERP

; No load interpolation if load below minimum load (LOAD_D_A < MIN_LOAD) 
	movf	LOAD_D_A,w	; load
	subwf	MIN_LOAD,w
	btfsc	STATUS,C	; if negative (ie load over min setting) can interpolate
	goto	NO_LOAD_INTERP

; get value for RPM_MAP +1 and LOAD_MAP+1 (add 1 to TEMP_NEW)
	bsf		STATUS,RP0	; bank 1
	incf	TEMP_NEW,f	; next memory=next load site
	movf	TEMP_NEW,w
	subwf	TEMP_INTERP,w; compare with memory limit
	btfss	STATUS,C	; if plus can interpolate
	goto	NO_INTERP4
	movf	TEMP_NEW,w
	bcf		STATUS,RP0	; select memory bank 0
	call	EEREAD
	bsf		STATUS,RP0	; select memory bank 1
	movwf	STO4_EEPROM	; next value 
	bcf		STATUS,RP0	; select memory bank 0
	goto	NEXT_INTERP3
NO_INTERP4
	movf	STO2_EEPROM,w	; next rpm site value
	movwf	STO4_EEPROM	; next value 
	bcf		STATUS,RP0	; select memory bank 0
NEXT_INTERP3
	
; Load Interpolation
; get value for RPM_MAP and LOAD_MAP+1 (add 1 to TEMP)
	incf	TEMP,w		; next memory=next load site
	bsf		STATUS,RP0	; select memory bank 1
	subwf	TEMP_INTERP,w; compare with memory limit
	btfss	STATUS,C	; if plus can interpolate
	goto	NO_INTERP3
	bcf		STATUS,RP0	; select memory bank 0
	incf	TEMP,w
	call	EEREAD
	bsf		STATUS,RP0	; select memory bank 1
	movwf	STO3_EEPROM	; next value 
	goto	CALC_INTERP
NO_INTERP3
	movf	STO1_EEPROM,w	; original rpm site value
	movwf	STO3_EEPROM	; next value 
	goto	CALC_INTERP

NO_LOAD_INTERP
	bsf		STATUS,RP0	; select memory bank 1
	movf	STO1_EEPROM,w	; original main value
	movwf	STO3_EEPROM	; next value 
	movf	STO2_EEPROM,w	; original main value plus 1 rpm site
	movwf	STO4_EEPROM	; next value 

CALC_INTERP
; Interpolation between STO1 and STO2 (if the same value do not do calculation)
 	movf	STO2_EEPROM,w
	subwf	STO1_EEPROM,w; take 2 from 1
	btfsc	STATUS,Z	; when the same bypass calculation
	goto	BY_1CALC	; place STO1_EEPROM into STO1_2_EEPROM
; if negative set negative flag
	clrf	NEG_FLG		; clear first
	btfsc	STATUS,C	; check polarity
	goto	CALC1		; calculation
	bsf		NEG_FLG,0	; flag set when negative
	movf	STO1_EEPROM,w
	subwf	STO2_EEPROM,w; take 1 from 2 when negative
CALC1
; if NEG_FLG clear (STO2_EEPROM - STO1_EEPROM) x OFF_RPM/RPM_STEP. 
; Add to STO1_EEPROM and place in STO1_2_EEPROM 
; if NEG_FLG,0 set (STO1_EEPROM - STO2_EEPROM) x OFF_RPM/RPM_STEP. 
; Subtract from STO1_EEPROM and place in STO1_2_EEPROM 

	bcf		STATUS,RP0	; select memory bank 0
	movwf	AARGB0
	bsf		STATUS,RP0	; select memory bank 1
	movf	OFF_RPM,w	; offset value 
	bcf		STATUS,RP0	; select memory bank 0
	movwf	BARGB0
	call	EIGHTEIGHT	; mult (ST02_EEPROM and STO1_EEPROM difference) by OFF_RPM
	movf	RPM_STEP,w
	movwf	BARGB0
	call	DIV16_8		; divide by RPM_STEP
	movf	AARGB1,w	; result
; add or subtract w with STO1_EEPROM
	bsf		STATUS,RP0	; select memory bank 1
	btfss	NEG_FLG,0	; if clear subtract
	goto	SUB1
	addwf	STO1_EEPROM,w	; added
	btfsc	STATUS,C	; if over set at FF
	goto	SET_STO1_2_EEPROM; set at FF
	goto	STORAGE_INIT1; place in STO1_2
SUB1
	subwf	STO1_EEPROM,w; subtracted
	btfsc	STATUS,C	; if negative set at 00
	goto	STORAGE_INIT1; place in STO1_2
	movlw	H'00'
	goto	STORAGE_INIT1; set at 00
SET_STO1_2_EEPROM
	movlw	H'FF'
	goto	STORAGE_INIT1	
BY_1CALC ; place STO1_EEPROM into STO1_2_EEPROM
	movf	STO1_EEPROM,w
STORAGE_INIT1
	bsf		STATUS,RP0	; select memory bank 1
	movwf	STO1_2_EEPROM; result of first calculation
	bcf		STATUS,RP0	; select memory bank 0	
	call	CALC_SUB	; calculate for firing
; Next interpolation
; Interpolation between STO3 and STO4 (if the same value do not do calculation)
	bsf		STATUS,RP0	; bank 1
 	movf	STO4_EEPROM,w
	subwf	STO3_EEPROM,w; take 4 from 3
	btfsc	STATUS,Z	; when the same bypass calculation
	goto	BY_2CALC	; place STO3_EEPROM into STO3_4_EEPROM
; if negative set negative flag
	clrf	NEG_FLG		; clear first
	btfsc	STATUS,C	; check polarity
	goto	CALC2		; calculation
	bsf		NEG_FLG,0	; flag set when negative
	movf	STO3_EEPROM,w
	subwf	STO4_EEPROM,w; take 3 from 4 when negative
CALC2
; if NEG_FLG clear (STO4_EEPROM - STO3_EEPROM) x OFF_RPM/RPM_STEP. 
; Add to STO3_EEPROM and place in STO3_4_EEPROM 
; if NEG_FLG,0 set (STO3_EEPROM - STO4_EEPROM) x OFF_RPM/RPM_STEP. 
; Subtract from STO3_EEPROM and place in STO3_4_EEPROM 

	bcf		STATUS,RP0	; select memory bank 0
	movwf	AARGB0
	bsf		STATUS,RP0	; select memory bank 1
	movf	OFF_RPM,w	; offset value 
	bcf		STATUS,RP0	; select memory bank 0
	movwf	BARGB0
	call	EIGHTEIGHT	; mult (ST04_EEPROM and STO3_EEPROM difference) by OFF_RPM
	movf	RPM_STEP,w
	movwf	BARGB0
	call	DIV16_8		; divide by RPM_STEP
	movf	AARGB1,w	; result
; add or subtract w with STO1_EEPROM
	bsf		STATUS,RP0	; select memory bank 1
	btfss	NEG_FLG,0	; if clear subtract
	goto	SUB2
	addwf	STO3_EEPROM,w	; added
	btfsc	STATUS,C	; if over set at FF
	goto	SET_STO3_4_EEPROM; set at FF
	goto	STORAGE_INIT2; place in STO3_4
SUB2
	subwf	STO3_EEPROM,w; subtracted
	btfsc	STATUS,C	; if negative set at 00
	goto	STORAGE_INIT2; place in STO3_4
	movlw	H'00'
	goto	STORAGE_INIT2; set at 00
SET_STO3_4_EEPROM
	movlw	H'FF'
	goto	STORAGE_INIT2	
BY_2CALC ; place STO3_EEPROM into STO3_4_EEPROM
	movf	STO3_EEPROM,w
STORAGE_INIT2
	bsf		STATUS,RP0	; select memory bank 1
	movwf	STO3_4_EEPROM; result of second calculation
	bcf		STATUS,RP0	; select memory bank 0	
	call	CALC_SUB	; calculate for firing
	
; Next interpolation
; Interpolation between STO1_2 and STO3_4 (if the same value do not do calculation)
	bsf		STATUS,RP0	; bank 1
 	movf	STO3_4_EEPROM,w
	subwf	STO1_2_EEPROM,w; take 3_4 from 1_2
	btfsc	STATUS,Z	; when the same bypass calculation
	goto	BY_3CALC	; place STO1_2_EEPROM into STO5_EEPROM
; if negative set negative flag
	clrf	NEG_FLG		; clear first
	btfsc	STATUS,C	; check polarity
	goto	CALC3		; calculation
	bsf		NEG_FLG,0	; flag set when negative
	movf	STO1_2_EEPROM,w
	subwf	STO3_4_EEPROM,w; take 1_2 from 3_4 when negative
CALC3
; if NEG_FLG clear (STO3_4_EEPROM - STO1_2_EEPROM) x OFF_LOAD/LOAD_STEP. 
; Add to STO1_2_EEPROM and place in STO5_EEPROM 
; if NEG_FLG,0 set (STO1_2_EEPROM - STO3_4_EEPROM) x OFF_LOAD/LOAD_STEP. 
; Subtract from STO1_2_EEPROM and place in STO5_EEPROM 

	bcf		STATUS,RP0	; select memory bank 0
	movwf	AARGB0
	bsf		STATUS,RP0	; select memory bank 1
	movf	OFF_LOAD,w	; offset value 
	bcf		STATUS,RP0	; select memory bank 0
	movwf	BARGB0
	call	EIGHTEIGHT	; mult (ST03_4_EEPROM and STO1_2_EEPROM difference) by OFF_LOAD
	movf	LOAD_STEP,w
	movwf	BARGB0
	call	DIV16_8		; divide by RPM_STEP
	movf	AARGB1,w	; result
; add or subtract w with STO1_2_EEPROM
	bsf		STATUS,RP0	; select memory bank 1
	btfss	NEG_FLG,0	; if clear subtract
	goto	SUB3
	addwf	STO1_2_EEPROM,w	; added
	btfsc	STATUS,C	; if over set at FF
	goto	SET_STO5_EEPROM; set at FF
	goto	STORAGE_INIT3; place in STO5
SUB3
	subwf	STO1_2_EEPROM,w; subtracted
	btfsc	STATUS,C	; if negative set at 00
	goto	STORAGE_INIT3; place in STO5
	movlw	H'00'
	goto	STORAGE_INIT3; set at 00
SET_STO5_EEPROM
	movlw	H'FF'
	goto	STORAGE_INIT3	
BY_3CALC ; place STO1_2_EEPROM into STO5_EEPROM
	movf	STO1_2_EEPROM,w
STORAGE_INIT3
	bsf		STATUS,RP0	; select memory bank 1
	movwf	STO5_EEPROM	; result of first calculation
	bcf		STATUS,RP0	; select memory bank 0	
	call	CALC_SUB	; calculate for firing
	bsf		STATUS,RP0	; select memory bank 1
	movf	STO5_EEPROM,w; interpolated value
	bcf		STATUS,RP0	; select memory bank 0

END_INTERPOLATION
	movwf	STOW_EEREAD	; final interpolated value
	call	CALC_SUB	; calculate for firing
	goto	START

; *********************************************************
; calculation
CALC_SUB

	btfss	EDGE_CALCU_SEL,3; when set calculate
	return
	btfsc	EDGE_CALCU_SEL,5; if running already bypass
	return
	bsf		EDGE_CALCU_SEL,5; set running flag
; if called via interrupt, save values first
	btfss	EDGE_CALCU_SEL,4
	goto	ADV_RET		; bypass saving register values

; this routine is run in the interrupt so save math register values first
	
	movlw	D'17'		; number of registers to store
	movwf	STORE_COUNT	; counter
	movlw	H'5F'		; start address (bank 0) of math registers
	movwf	FSR			; indirect addressing pointer
LOOP_STO
	movf	INDF,W		; bank 0 value
	bsf		FSR,7		; bank 1 for indirect addressing
	movwf	INDF		; store in mirrored register bank 1
	bcf		FSR,7		; bank 0
	incf	FSR,f		; next
	decfsz	STORE_COUNT,f; decrease until 0
	goto	LOOP_STO

; add or subtract the advance or retard value
; firstly calculate the counter value required
ADV_RET
	movf	CYL_DEG0,w	; cylinder degree factor
	movwf	BARGB0		; ms byte
	movf	CYL_DEG1,w	; cylinder degree factor
	movwf	BARGB1		; divisor
	btfss	EDGE_CALCU_SEL,4	; if set bypass
	bcf		INTCON,GIE	; stop interrupt 
	movf	TIMERHH,w	; ms counter
	movwf	AARGB0
	movf	TIMERH,w
	movwf	AARGB1
	movf	TIMERL,w
	movwf	AARGB2		; ls byte
	btfss	EDGE_CALCU_SEL,4	; if set bypass
	bsf		INTCON,GIE
; multiply by 16 to improve accuracy of calculation (/16 later)
	bcf		STATUS,C	; carry cleared 
	rlf		AARGB2,f
	rlf		AARGB1,f
	rlf		AARGB0,f	; x2
	rlf		AARGB2,f
	rlf		AARGB1,f
	rlf		AARGB0,f	; x4
	rlf		AARGB2,f
	rlf		AARGB1,f
	rlf		AARGB0,f	; x8
	rlf		AARGB2,f
	rlf		AARGB1,f
	rlf		AARGB0,f	; x16
	
	call	FXD2416U	; divide counter by cylinder degree factor
	clrf	BARGB0		; ms byte
	clrf	BARGB1
; subtract knock degree value to reduce knocking with increasing signal at AN1
; check if knock is off
	btfss	DEG_EDG_MAP,7	; when set knock is on
	goto	KNOCK_IS_OFF	
	movf	KNOCK,w
	subwf	STOW_EEREAD,w; stored variation value (0 to 127)
 	btfss	STATUS,C	; if negative keep BARGB2 at 0
	movlw	H'00'
TEST_7
 	movwf	BARGB2		; multiplier
	btfsc	BARGB2,7	; if set then positive (advance)
	goto	SUBT_TIMER
	goto	ADD_TIMER
KNOCK_IS_OFF
	movf	STOW_EEREAD,w
	goto	TEST_7		
ADD_TIMER
; take from 128 (128 is zero degrees)
	movf	BARGB2,w
	sublw	D'128'
	movwf	BARGB2
	call	FXM2424U	; multiply
	call	DIV_16AARGB	; divide by 16
	goto	ADD_TO_TIMERH

DIV_16AARGB ; small subroutine to divide by 16	
; divide by 16
	bcf		STATUS,C	; carry cleared
	rrf		AARGB2,f
	rrf		AARGB3,f
	rrf		AARGB4,f
	rrf		AARGB5,f	; /2
	rrf		AARGB2,f
	rrf		AARGB3,f
	rrf		AARGB4,f
	rrf		AARGB5,f	; /4
	rrf		AARGB2,f
	rrf		AARGB3,f
	rrf		AARGB4,f
	rrf		AARGB5,f	; /8
	rrf		AARGB2,f
	rrf		AARGB3,f
	rrf		AARGB4,f
	rrf		AARGB5,f	; /16
	return

; add to TIMERH	
ADD_TO_TIMERH
	btfss	EDGE_CALCU_SEL,4	; if set bypass
	bcf		INTCON,GIE	; stop interrupt
	movf	TIMERHH,w
	movwf	TIMERHH1
	movf	TIMERH,w
	movwf	TIMERH1
	movf	TIMERL,w
	movwf	TIMERL1
	movf	AARGB5,w
	bsf		STATUS,RP0	; bank 1
	movwf	OFFSET_LS	; store for recalculation in interrupt
	bcf		STATUS,RP0	; bank 0
	addwf	TIMERL1,f	; ls byte
	movf	AARGB4,w	; ms byte
	bsf		STATUS,RP0	; bank 1
	movwf	OFFSET_MID	; store for recalculation in interrupt
	bcf		STATUS,RP0	; bank 0
	btfsc	STATUS,C
	incfsz	AARGB4,w
	addwf	TIMERH1,f
	movf	AARGB3,w
	bsf		STATUS,RP0	; bank 1
	movwf	OFFSET_MS	; store for recalculation in interrupt
	bcf		STATUS,RP0	; bank 0
	btfsc	STATUS,C
	incfsz	AARGB3,w
	addwf	TIMERHH1,f	; 24 bit timing
	goto	RETRIEVE
	
SUBT_TIMER
	bcf		BARGB2,7
	call	FXM2424U
	call	DIV_16AARGB	; divide by 16

; subtract from timer
	btfss	EDGE_CALCU_SEL,4	; if set bypass
	bcf		INTCON,GIE	; stop interrupt
	movf	TIMERHH,w
	movwf	TIMERHH1
	movf	TIMERH,w
	movwf	TIMERH1
	movf	TIMERL,w
	movwf	TIMERL1

	movf	AARGB5,w	; low byte
	subwf	TIMERL1,f
	
	movf	AARGB4,w	; ms byte
	btfss	STATUS,C
	incfsz	AARGB4,w
	subwf	TIMERH1,f	; subtract ms bytes

	movf	AARGB3,w
	btfss	STATUS,C
	incfsz	AARGB3,w	; increase if ls bytes carry
	subwf	TIMERHH1,f
	
RETRIEVE
	btfss	EDGE_CALCU_SEL,4; if set bypass
	bsf		INTCON,GIE	; allow interrupts 
	btfss	EDGE_CALCU_SEL,4; if set then recall values
	goto	NO_RESTORE	
; restore math register values 
	movlw	D'17'		; number of registers to store
	movwf	STORE_COUNT	; counter
	movlw	H'5F'		; start address (bank 0) of math registers
	movwf	FSR			; indirect addressing pointer
LOOP_RESTO
	bsf		FSR,7	 	; bank 1
	movf	INDF,W		; bank 1 value
	bcf		FSR,7		; bank 0
	movwf	INDF		; restore from mirrored register in bank 1
	incf	FSR,f		; next
	decfsz	STORE_COUNT,f; decrease until 0
	goto	LOOP_RESTO
	bsf		PCLATH,3	; page 1 return for interrupt call
NO_RESTORE
	btfss	EDGE_CALCU_SEL,4; if set bypass
	bcf		PCLATH,3	; page 0	
	bcf		EDGE_CALCU_SEL,3; calculation done flag
	bcf		EDGE_CALCU_SEL,5; end of calc
	return
; end of calculation
; *****************************************************

START
	btfss	PORTA,5		; if link 3 set
	goto	SET_LK3
	btfss	SETT_CHNG,0	; if clear run display update
	goto	DRV_DSP		; drive display
	goto	FIND_CLOSED
SET_LK3
	btfsc	SETT_CHNG,1	; if clear run settings display update
	goto	FIND_CLOSED		
	bsf		PCLATH,3	; page 1	
	goto	UP_DSP_SET

; find closed switch 
FIND_CLOSED
	clrf	SW_VAL		; switch value cleared
	bsf		PORTB,7		; reset 4017
	nop
	nop
	nop
	bcf		PORTB,6		; clock low
	bcf		PORTB,7		; reset off
	
; check DEG_EDG_MAP,2 for single to double Map change
	btfss	DEG_EDG_MAP,2	; if set check if MAP_STO,2 is set
	goto	CK_LINK0
	btfsc	MAP_STO,2	; if set then no change required
	goto	RECH_SW
	goto	DIFF_MAP
CK_LINK0
	btfss	MAP_STO,2	; if clear no change required
	goto	RECH_SW
; different MAP from last time
DIFF_MAP
	movf	DEG_EDG_MAP,w	; store new setting 
	movwf	MAP_STO
; recalculate max rpm and max load when link is changed
	
; max rpm
; For maps 1 and 2 recalculate MAX_RPM = 10 x RPM_STEP + MIN_RPM
; for single map MAX_RPM = 14 x RPM_STEP + MIN_RPM
	movf	RPM_STEP,w
	movwf	AARGB0
	movlw	D'14'		; for single map
	btfss	DEG_EDG_MAP,2		; skip when bit 2 is high
	movlw	D'10'		; load 10 for bit 2 low
	movwf	BARGB0
	movwf	BARGB0
	call	EIGHTEIGHT	; multiply
; check over
	movf	AARGB0,w
	btfss	STATUS,Z	; if not zero overload
	goto	OVR_MAX_RPM1
	movf	AARGB1,w
	addwf	MIN_RPM,w
	movwf	MAX_RPM
	btfsc	STATUS,C	; if carry set over
	clrf	MAX_RPM
; rewrite max rpm to EEPROM
RE_253_1
	movlw	EEPROM253
	call	EEREAD		; set EEADR
	movf	MAX_RPM,w
	call	EWRITE
	goto	MAX_LOAD_CALC1
OVR_MAX_RPM1
	clrf	MAX_RPM		; cleared on overload
	goto	RE_253_1

MAX_LOAD_CALC1
; max load
; for MAP1/MAP2 recalculate MAX_LOAD = 10 x LOAD_STEP + MIN_LOAD
; for single MAP MAX_LOAD = 14 x LOAD_STEP + MIN_LOAD
	movf	LOAD_STEP,w
	movwf	AARGB0
	movlw	D'14'		; for single map
	btfss	DEG_EDG_MAP,2		; skip when bit 2 is high
	movlw	D'10'		; load 10 for bit 2 low
	movwf	BARGB0
	call	EIGHTEIGHT	; multiply
; check over
	movf	AARGB0,w
	btfss	STATUS,Z	; if not zero overload
	goto	OVR_MAX_LOAD1
	movf	AARGB1,w
	addwf	MIN_LOAD,w
	movwf	MAX_LOAD
	btfsc	STATUS,C	; if carry set over
	clrf	MAX_LOAD
; rewrite max load to EEPROM
RE_255_1
	movlw	EEPROM255
	call	EEREAD		; set EEADR
	movf	MAX_LOAD,w
	call	EWRITE
	goto	RECH_SW1
OVR_MAX_LOAD1
	clrf	MAX_LOAD	; cleared on overload
	goto	RE_255_1

; *****
RECH_SW1
	bcf		SETT_CHNG,1	; clear so re-run display update
RECH_SW	
	bcf		SW_PRESS,0	; switch pressed flag clear, set when pressed
	bcf		PORTB,6		; clock low
	btfsc	PORTA,0		; if high a switch is pressed
	goto	SW_PRESSED
	bsf		PORTB,6		; clock 4017		
	incf	SW_VAL,f	; check next switch	
	movf	SW_VAL,w
	sublw	D'10'		; if c =0 then reset
	bcf		PORTB,6
	btfss	STATUS,C
	goto	BACKGROUND	; only drive display when switch closes	
	goto	RECH_SW	
	
; place delay and check sw flag again 
SW_PRESSED	
	movlw	D'102'
	call	DELAYX		; delay to ensure switch is not a glitch
	btfss	PORTA,0		; if high switch still pressed
	goto	BACKGROUND
	movlw	D'202'
	call	DELAYX		; delay to ensure switch is not a glitch
	btfss	PORTA,0		; if high switch still pressed
	goto	BACKGROUND
	bsf		SW_PRESS,0
; if settings mode 
	btfss	PORTA,5		
	goto	SETTINGS
	bcf		SETT_CHNG,0
	movf	SW_VAL,w
	xorlw	D'04'
	btfsc	STATUS,Z
	goto	VW_DTA		; view/run modes

	movf	SW_VAL,w	; stored switch value data correct
	btfsc	STATUS,Z	; 
	goto	RT_VIEW		; right view switch
	decf	SW_VAL,w	
	btfsc	STATUS,Z
	goto	UP_VARY		; up variation switch
	movf	SW_VAL,w
	xorlw	D'02'
	btfsc	STATUS,Z
	goto	RT_VW2		; right view larger step
	movf	SW_VAL,w
	xorlw	D'03'
	btfsc	STATUS,Z
	goto	DN_VRY2		; down variation larger step
	movf	SW_VAL,w
	xorlw	D'05'
	btfsc	STATUS,Z
	goto	UP_VRY2		; up variation larger step
	movf	SW_VAL,w
	xorlw	D'06'
	btfsc	STATUS,Z
	goto	LF_VIEW		; left view
	movf	SW_VAL,w
	xorlw	D'07'
	btfsc	STATUS,Z
	goto	LF_VW2		; left view larger step
	movf	SW_VAL,w
	xorlw	D'08'
	btfsc	STATUS,Z
	goto	DN_VARY		; down variation
	movf	SW_VAL,w
	xorlw	D'09'
	btfsc	STATUS,Z
	goto	DEF_LT		; default (RESET)
	goto	DRV_DSP

; switch operations

; right view
RT_VIEW	
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	incf	VIEW,w		; view position
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	SET_224_RT
	sublw	D'120' 		; maximum
TEST_224_RT
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX0
	incf	VIEW,f		; increase value
	goto	DRV_DSP
SET_MX0
	movlw	D'120'
	btfsc	DEG_EDG_MAP,2		; when set single map
	movlw	D'224'
	movwf	VIEW		; ensure value doesn't go above max
	goto	DRV_DSP
SET_224_RT
	sublw	D'224'
	goto	TEST_224_RT

; right view larger step
RT_VW2
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	movlw	D'11'		; step increment
; if single map use 15
	btfsc	DEG_EDG_MAP,2		; when set single map
	movlw	D'15'
INC_VW2
	addwf	VIEW,w		; view position
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	SET_224_INC
	sublw	D'120' 		; was 120 maximum
TEST_224
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	DRV_DSP
	movlw	D'11'		; step increment
; if single map use 15
	btfsc	DEG_EDG_MAP,2		; when set single map
	movlw	D'15'
	addwf	VIEW,f		; increase value
	goto	DRV_DSP
SET_224_INC
	sublw	D'224'		; was 224
	goto	TEST_224

; left view
LF_VIEW
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	movf	VIEW,w		; view position
	btfsc	STATUS,Z	; check for 0 or minimum
	goto	DRV_DSP
	decf	VIEW,f		; decrease value
	goto	DRV_DSP

; left view larger step
LF_VW2
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; bypass if mode in run mode	
	goto	DRV_DSP		; run mode so do not alter
	movlw	D'11'		; step increment
; if single map use 15
	btfsc	DEG_EDG_MAP,2		; when set single map
	movlw	D'15'
DEC_VW7
	subwf	VIEW,w		; view position
	btfss	STATUS,C	; check for 0 or minimum
	goto	DRV_DSP
	movlw	D'11'		; step increment
; if single map use 15
	btfsc	DEG_EDG_MAP,2		; when set single map
	movlw	D'15'
	subwf	VIEW,f		; decrease value
	goto	DRV_DSP
	
; VIEW/RUN
VW_DTA
	incf	MODE,f		; increase to 2 or 3
	movf	MODE,w
	sublw	D'03'
	btfsc	STATUS,C	; if 4 clear
	goto	SW_DLY
	movf	INPUT,w		; transfer current input value
	movwf	VIEW
	clrf	MODE
SW_DLY
	bsf		VW_FLAG,0	; set view run flag
	goto	DRV_DSP
				
; up variation switch					
UP_VARY	
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; if zero view mode
	goto	RUN_MD1
	movf	VIEW,w		; viewing input value (0 to 120)
	goto	IN_VW1
RUN_MD1
	movf	INPUT,w 	; get current input value (0 to 120)
IN_VW1
	movwf	TEMP
; if single map bypass checking for map2
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	SINGLE_MAP4
	movlw	D'121'
	btfsc	PORTA,4		; if set; map2
	addwf	TEMP,f		; add 121 if map 2
SINGLE_MAP4
	movf	TEMP,w
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT		; output variation value
	sublw	D'254' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX1
	incf	OUTPUT,w	; increase value
	goto	WRI_UP1
SET_MX1
	 movlw	D'255'		; ensure value doesn't go above 255
WRI_UP1
	call	EEWRITE		
	goto	DRV_DSP			

; up variation larger step
UP_VRY2
	movlw	D'05'		; step increment
	movwf	STEP
MODE_1
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; if zero view mode
	goto	RUN_MD5
	movf	VIEW,w		; viewing input value (0 to 120)
	goto	IN_VW5
RUN_MD5
	movf	INPUT,w 	; get current input value (0 to 120)
IN_VW5
	movwf	TEMP
; if single map bypass checking for map2
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	SINGLE_MAP3
	movlw	D'121'
	btfsc	PORTA,4		; if set; map2
	addwf	TEMP,f		; add 121 if map 2
SINGLE_MAP3
	movf	TEMP,w
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT		; output variation value
NXT5
	movf	OUTPUT,w
	sublw	D'254' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SET_MX5
	incf	OUTPUT,f	; increase value
	decfsz	STEP,f
	goto	NEXT5
	decf	OUTPUT,f
	goto	DRV_DSP
NEXT5
	movf	OUTPUT,w
	call	EEWRITE
	goto	MODE_1
SET_MX5
	movlw	D'255'		; ensure value doesn't go above 255
	call	EEWRITE		
	goto	DRV_DSP

; down variation
DN_VARY
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; if zero view mode
	goto	RUN_MD8
	movf	VIEW,w		; viewing input value (1 to 121)or (1-240)
	goto	IN_VW8
RUN_MD8
	movf	INPUT,w 	; get current input value (1 to 121)or (1-240)
IN_VW8
	movwf	TEMP
; if single map bypass checking for map2
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	SINGLE_MAP2
	movlw	D'121'
	btfsc	PORTA,4		; if set; map2
	addwf	TEMP,f		; add 121 if map 2
SINGLE_MAP2
	movf	TEMP,w
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT
	decf	OUTPUT,w	; output variation value
	btfsc	STATUS,Z	; check if zero 
	goto	DRV_DSP		; already zero so bypass
	decf	OUTPUT,w
	call	EEWRITE
	goto	DRV_DSP

; down variation larger step	
DN_VRY2
	movlw	D'04'		; step increment
	movwf	STEP
MODE_3
	movf	MODE,w		; check mode
	btfss	STATUS,Z	; if zero view mode
	goto	RUN_MD3
	movf	VIEW,w		; viewing input value (0 to 120)
	goto	IN_VW3
RUN_MD3	
	movf	INPUT,w 	; get current input value (0 to 120)
IN_VW3
	movwf	TEMP
; if single map bypass checking for map2
	btfsc	DEG_EDG_MAP,2		; when set single map
	goto	SINGLE_MAP1
	movlw	D'121'
	btfsc	PORTA,4		; if set; map2
	addwf	TEMP,f		; add 121 if map 2
SINGLE_MAP1
	movf	TEMP,w
	call	EEREAD		; get output value (routine sets EEADR)
	movwf	OUTPUT
NXT_3
	decf	OUTPUT,w	; output variation value
	btfsc	STATUS,Z	; check if zero 
	goto	DRV_DSP		; already zero so bypass
	decf	OUTPUT,w
	call	EEWRITE
	decfsz	STEP,f
	goto	MODE_3		; next step
	decf	OUTPUT,f
	goto	DRV_DSP

; default of 0 offset
DEF_LT
	movlw	D'20'		;  2.5s delay
	movwf	STORE3
ROTAT
	movlw	D'255'
	call	DELAYX		;  delay
	decfsz	STORE3,f
	goto	ROTAT

	movf	SW_VAL,w	;  check value
	xorlw	D'09'		;  reset switch
	btfss	STATUS,Z	;  if the same
	goto	DRV_DSP		;  bypass if switch not the reset

	movlw	H'80'		; address line 1
	call	LOAD
	movlw	A'R'		; R
	call	DRV_LCD
	movlw	A'E'		; E
	call	DRV_LCD
	movlw	A'S'		; S
	call	DRV_LCD
	movlw	A'E'		; E
	call	DRV_LCD
	movlw	A'T'		; T
	call	DRV_LCD
	call	SPACE2		; 2 spaces
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	A'.'		; 
	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	H'DF'		; 
	call	DRV_LCD
	movlw	H'90'		; address line 1 position 17
	call	LOAD

	bcf		INTCON,GIE	; clear global interrupt enable for above
; if single map
	btfss	DEG_EDG_MAP,2
	goto	TWO_MAP
	movlw	D'225'
	movwf	E_COUNT		; EEPROM counter
	movlw	EEPROM1
	goto	MAP_CLEAR
TWO_MAP
	movlw	D'121'
	movwf	E_COUNT		; EEPROM counter
	movlw	EEPROM1		; map1
	btfsc	PORTA,4		; if set map2
	movlw	EEPROM122	; MAP 2
MAP_CLEAR	
	bsf		STATUS,RP1	; select bank 2
	movwf	EEADR		; set EEPROM address
	bcf		STATUS,RP1	; select bank 0
EE_LD
	movlw	D'128'		; no offset
	call	EWRITE		; set at 0 offset
	decfsz	E_COUNT,f
	goto	NXT_EE
	bsf 	INTCON,GIE	; set global interrupt enable for above
	goto	DRV_DLY
NXT_EE
	bsf		STATUS,RP1	; select bank 2	
	incf	EEADR,f		; next EEPROM location
	bcf		STATUS,RP1	; select bank 0
	goto	EE_LD

DRV_DLY	
	movlw	D'20'		;  2.5s delay
	movwf	STORE3
ROTAT1
	movlw	D'255'
	call	DELAYX		;  delay
	decfsz	STORE3,f
	goto	ROTAT1

; drive display with values
DRV_DSP
; check if normal or Settings
	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1	; bank 0
	
	btfss	PORTA,5		
	goto	SETTINGS

; if display already updated, bypass
	btfsc	SETT_CHNG,0	; if set no update
	goto	BACKGROUND

; adjust updated flags
	bsf		SETT_CHNG,0	; 
	bcf		SETT_CHNG,1
		
	movlw	H'80'		; address line 1
	call	LOAD
	
	movlw	A'M'		; TIMING MAP
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD

	movlw	H'8A'
	call	LOAD		; line 1 position a
	call	SPACE2
	movf	MODE,w
	xorlw	D'2'		; if 2 then display FULL
	btfsc	STATUS,Z
	goto	FULL
	movf	MODE,w
	xorlw	D'3'		; if 3 then display DIAG
	btfsc	STATUS,Z
	goto	DIAG
	movf	MODE,w
	btfsc	STATUS,Z	; if zero view mode
	goto	VIEW_M		; view mode
; mode is 1 so show SITE
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD	
	goto	LN2
FULL
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'U'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	goto	LN2
DIAG
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'G'		; 
	call	DRV_LCD
	goto	LN2
VIEW_M
	movlw	A'V'		; VIEW
	call	DRV_LCD
	movlw	A'I'		; I
	call	DRV_LCD
	movlw	A'E'		; E
	call	DRV_LCD
	movlw	A'W'		; W
	call	DRV_LCD
; line 2
LN2
	movlw	B'11000000'	; address line 2
	call	LOAD

	movlw	A'R'		; RPM
	call	DRV_LCD
	movlw	A'P'			;
	call	DRV_LCD
	movlw	A'M'		; 
	call	DRV_LCD
	call	SPACE1
	
	movlw	H'C8'		; line 2 position 8
	call	LOAD
	call	SPACE1
	movf	MODE,w
	xorlw	D'2'		; when 2 show interpolated value
	btfsc	STATUS,Z
	goto	LD_DSP
	
	movlw	A'L'		; LOAD
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	call	SPACE4
	goto	SW_DEL1
LD_DSP	
	movlw	A'L'		; LOAD
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	call	SPACE4
	call	SPACE2
SW_DEL1
	btfss	SW_PRESS,0	; if switch pressed add delay
	goto	BACKGROUND	
	clrf	VW_FLAG		; clear 
ST_DLY1

	bsf		SETT_CHNG,1	; display updated
	movlw	D'255'
	movwf	DISPLAY_REFRESH; refresh display
	goto	DISPLAY_UPDATE

SW_DEL; delay between display update and switch operations
	btfss	SW_PRESS,0	; if switch pressed add delay
	goto	BACKGROUND	
	clrf	VW_FLAG		; clear 
ST_DLY
	movlw	D'200'		;  DELAYms
	movwf	STORE3
MOR_DEL
	call	DELAYms
	decfsz	STORE3,f
	goto	MOR_DEL
	bsf		SETT_CHNG,1	; display updated
	movlw	D'200'		;  DELAYms
	movwf	STORE3
MOR_DEL2
	call	DELAYms
	decfsz	STORE3,f
	goto	MOR_DEL2
	goto	BACKGROUND

SETTINGS
	bcf		PCLATH,4
	bsf		PCLATH,3	; page 1
	goto	SETTINGS_DSP

; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

; Subroutines

; subroutine to wait for conversion

ACQUIRE_AD
; wait for >20us
	movlw	D'50'
	movwf	CONVERSION
LOOP_CONV
	decfsz	CONVERSION,f	; decrease 
	goto	LOOP_CONV	
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return


; add space in display

SPACE4
	movlw	H'20'		; space
	call	DRV_LCD
SPACE3
	movlw	H'20'		; space
	call	DRV_LCD
SPACE2
	movlw	H'20'		; space
	call	DRV_LCD
SPACE1
	movlw	H'20'		; space
	call	DRV_LCD
	return

; delay loop (altered when switch pressed)

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	btfss	EDGE_CALCU_SEL,3; if start flag set call calc_sub
	goto	LOOPG
	call	CALC_SUB	; calculate firing and dwell
	movlw	D'3'
	subwf	STORE1,f
	btfss	STATUS,C	; if negative return
	return
	btfsc	STATUS,Z	; if zero return
	return
LOOPG
	decfsz	STORE1,f
	goto	LOOP8		; decrease till STORE1 is zero
	return

; initialise display

INIT_LC
	movlw	B'00110000'	; initialise module
	movwf	PORTB
	nop
	bsf		PORTB,1		; enable high
	nop
	bcf		PORTB,1		; low
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO		; store data	
	movf	D_STO,w
	andlw	H'F0'		; get upper bits
; place display commands in portB
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,7	
	btfsc	PORTB_STO,6
	bsf		PORTB,6	
	btfsc	PORTB_STO,5
	bsf		PORTB,5	
	btfsc	PORTB_STO,4
	bsf		PORTB,4	

	bcf		PORTB,2		; register select low
	nop
	bsf		PORTB,1		; enable set
	nop
	bcf		PORTB,1		; enable clear

	swapf	D_STO,w
	andlw	H'F0'		; get lower bits
; place display commands in portB
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,7	
	btfsc	PORTB_STO,6
	bsf		PORTB,6	
	btfsc	PORTB_STO,5
	bsf		PORTB,5	
	btfsc	PORTB_STO,4
	bsf		PORTB,4	
	bcf		PORTB,2		; register select low
	nop
	bsf		PORTB,1		; enable set
	nop
	bcf		PORTB,1		; enable clear
	goto	BUS_CK		; check busy flag
	
; driving the LCD module with display data

DRV_LCD	
	movwf	D_STO		; store data
	andlw	H'F0'		; upper bits
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,7	
	btfsc	PORTB_STO,6
	bsf		PORTB,6	
	btfsc	PORTB_STO,5
	bsf		PORTB,5	
	btfsc	PORTB_STO,4
	bsf		PORTB,4	
	bsf		PORTB,2		; register select
	bsf		PORTB,1		; enable high
	nop
	bcf		PORTB,1		; enable low

	swapf	D_STO,w
	andlw	H'F0'		; lower bits
	movwf	PORTB_STO
	bcf		PORTB,7
	bcf		PORTB,6
	bcf		PORTB,5
	bcf		PORTB,4
	btfsc	PORTB_STO,7
	bsf		PORTB,7	
	btfsc	PORTB_STO,6
	bsf		PORTB,6	
	btfsc	PORTB_STO,5
	bsf		PORTB,5	
	btfsc	PORTB_STO,4
	bsf		PORTB,4	
	bsf		PORTB,2		; register select
	bsf		PORTB,1		; enable high
	nop
	bcf		PORTB,1		; enable low

BUS_CK
	movlw 	D'2'		; was 30
	movwf	STORE1		; delay values
	movlw	D'255'		; delay for busy flag to clear
	movlw	B'00001000'	; keep RA3 state but clear drive to LCD
	andwf	PORTB,f	
	goto	DELDSP

; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP0	; select bank 0
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 	STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 

; Subroutine to convert from 8-bit binary to 2-digit BCD (packed)
; Binary value is in BIN_0  
; Result in BCD is in BCD_0 & BCD_1.  
; BCD_0 is MSB, BCD_1 is LSB
; converts to unpacked ASCII in OUT1, OUT2, OUT3 (out1 is ms byte, out3 is ls byte)

BCD_ASCII
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf	BCD_0
	clrf	BCD_1		; set BCD registers to 0 
LOOPBCD
	rlf		BIN_0,f		; shift left binary registers
	rlf		BCD_1,f		; MSB shift left

	rlf		BCD_0,f		; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust

; completed decimal to BCD operation, convert to unpacked ASCII
	
	movf	BCD_1,w		; ls decimal
	andlw	H'0F'		; ls
	addlw	H'30'		; convert to ASCII
	movwf	OUT3
	swapf	BCD_1,w 	; mid decimal value
	andlw	H'0F'
	addlw	H'30'		; convert to ASCII
	movwf	OUT2
	movf	BCD_0,w
	addlw	H'30'		; convert to ASCII
	movwf	OUT1		; ms decimal value
	return				; ASCII values returned in OUT1, OUT2, OUT3 

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR			; pointer for BCD1
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR			; pointer for BCD0
	call	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD	
	movlw	H'03'		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	H'30'		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; **********************************************************************
; maths routines

;***********************************************************************
        

; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U       	CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1,F
                MOVF            BARGB1,W
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                RLF             AARGB0,F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46LA 		RLF             AARGB0,F
                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46L8         RLF             AARGB1,F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46LB         RLF             AARGB1,F
                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46L16        RLF             AARGB2,F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46LC 		RLF             AARGB2,F
                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        	ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
UOK46L			RETURN

; 24x24 Bit Unsigned Fixed Point Multiply 24x24 -> 48
; Input: 24 bit unsigned fixed point multiplicand in AARGB0
; 24 bit unsigned fixed point multiplier in BARGB0
; Use: CALL FXM2424U
; Output: 48 bit unsigned fixed point product in AARGB0
; Result: AARG <-- AARG x BARG
; Max Timing: 9+501+2 = 512 clks
; Min Timing: 9+150 = 159 clks

FXM2424U
	CLRF 	AARGB3 ; clear partial product
	CLRF 	AARGB4
	CLRF 	AARGB5
	MOVF 	AARGB0,W
	MOVWF 	TEMPB0
	MOVF 	AARGB1,W
	MOVWF 	TEMPB1
	MOVF 	AARGB2,W
	MOVWF 	TEMPB2

	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
LOOPUM2424A
	RRF 	BARGB2,F
	BTFSC 	STATUS,C
	GOTO 	ALUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO	LOOPUM2424A
	MOVWF 	LOOPCOUNT
LOOPUM2424B
	RRF 	BARGB1,F
	BTFSC 	STATUS,C
	GOTO	BLUM2424NAP
	DECFSZ	LOOPCOUNT,F
	GOTO	LOOPUM2424B
	MOVWF	LOOPCOUNT
LOOPUM2424C
	RRF		BARGB0,F
	BTFSC 	STATUS,C
	GOTO 	CLUM2424NAP
	DECFSZ 	LOOPCOUNT,F
	GOTO 	LOOPUM2424C
	CLRF 	AARGB0
	CLRF 	AARGB1
	CLRF 	AARGB2
	RETLW 	H'00'
CLUM2424NAP
	BCF 	STATUS,C
	GOTO 	CLUM2424NA
BLUM2424NAP
	BCF 	STATUS,C
	GOTO 	BLUM2424NA
ALUM2424NAP
	BCF 	STATUS,C
	GOTO 	ALUM2424NA
ALOOPUM2424
	RRF 	BARGB2,F
	BTFSS 	STATUS,C
	GOTO 	ALUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF	AARGB0,F
ALUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	ALOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
BLOOPUM2424
	RRF 	BARGB1,F
	BTFSS 	STATUS,C
	GOTO 	BLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
BLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	BLOOPUM2424
	MOVLW 	H'08'
	MOVWF 	LOOPCOUNT
CLOOPUM2424
	RRF 	BARGB0,F
	BTFSS 	STATUS,C
	GOTO 	CLUM2424NA
	MOVF 	TEMPB2,W
	ADDWF 	AARGB2,F
	MOVF 	TEMPB1,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB1,W
	ADDWF 	AARGB1,F
	MOVF 	TEMPB0,W
	BTFSC 	STATUS,C
	INCFSZ 	TEMPB0,W
	ADDWF 	AARGB0,F
CLUM2424NA
	RRF 	AARGB0,F
	RRF 	AARGB1,F
	RRF 	AARGB2,F
	RRF 	AARGB3,F
	RRF 	AARGB4,F
	RRF 	AARGB5,F
	DECFSZ 	LOOPCOUNT,F
	GOTO 	CLOOPUM2424
	return

; 8 x 8 multiply

EIGHTEIGHT	    CLRF    AARGB1          ; clear partial product
UMUL0808L        
                MOVLW   H'08'
                MOVWF   LOOPCOUNT
                MOVF    AARGB0,W

LOOPUM0808A
                RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    LUM0808NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808A

                CLRF    AARGB0
                RETLW   H'00'

LUM0808NAP
                BCF     STATUS,C
                GOTO    LUM0808NA

LOOPUM0808
                RRF     BARGB0, F
                BTFSC   STATUS,C
                ADDWF   AARGB0, F
LUM0808NA       RRF    	AARGB0, F
                RRF    	AARGB1, F
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM0808

                return             



;**********************************************************************************************
        
;       16/8 Bit Unsigned Fixed Point Divide 16/8 -> 16.08

;       Input:  16 bit unsigned fixed point dividend in AARGB0, AARGB1
;               8 bit unsigned fixed point divisor in BARGB0

;      ;       Output: 16 bit unsigned fixed point quotient in AARGB0, AARGB1
;               8 bit unsigned fixed point remainder in REMB0

;       Result: AARG, REM  <--  AARG / BARG

DIV16_8		   	CLRF            REMB0
                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608A      RLF             AARGB0,W
                RLF             REMB0, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F

                BTFSC           STATUS,C
                GOTO            UOK68A          
                ADDWF           REMB0, F
                BCF             STATUS,C
UOK68A          RLF             AARGB0, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608A

                CLRF            TEMP1

                MOVLW           H'08'
                MOVWF           LOOPCOUNT

LOOPU1608B      RLF             AARGB1,W
                RLF             REMB0, F
                RLF             TEMP1, F
                MOVF            BARGB0,W
                SUBWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSS           STATUS,C
                INCFSZ          AARGB3,W
                SUBWF           TEMP1, F

                BTFSC           STATUS,C
                GOTO            UOK68B          
                MOVF            BARGB0,W
                ADDWF           REMB0, F
                CLRF            AARGB3
                CLRW
                BTFSC           STATUS,C
                INCFSZ          AARGB3,W
                ADDWF           TEMP1, F

                BCF             STATUS,C
UOK68B          RLF             AARGB1, F

                DECFSZ          LOOPCOUNT, F
                GOTO            LOOPU1608B
                return



; ********************************************************************
; page 1
	org		H'800'		; start at the page 1 address
SETTINGS_DSP
	bsf		PCLATH,3	; page 1
	bcf		STATUS,RP0	; select bank 0
	bcf		STATUS,RP1	; bank 0
	btfsc	SW_PRESS,0	; if switch pressed find switch
	goto	SW_MOVE
	bcf		PCLATH,3	; page 0
	goto	CALCULATE
	
SW_MOVE	
	movf	SW_VAL,w
	btfsc	STATUS,Z	; 
	goto	UP_SETT		; up settings type switch
	decf	SW_VAL,w	
	btfsc	STATUS,Z
	goto	UP_VARY_SETT; up variation switch
	movf	SW_VAL,w
	xorlw	H'06'
	btfsc	STATUS,Z
	goto	DN_SETT		; settings type down
	movf	SW_VAL,w
	xorlw	H'08'
	btfsc	STATUS,Z
	goto	DN_VARY_SETT; down variation
	bcf		PCLATH,3	; page 0
	goto	CALCULATE	; no valid switch pressed

UP_SETT					; increase the settings SETT_VAL 
	bcf		SETT_CHNG,1	
	incf	SETT_VAL,w	; settings 
	sublw	H'0E' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SETT_0_VAL
	incf	SETT_VAL,f
	goto	UP_DSP_SET	; update display
SETT_0_VAL
	clrf	SETT_VAL
	goto	UP_DSP_SET
DN_SETT					; decrease the settings SETT_VAL
	bcf		SETT_CHNG,1	
	movf	SETT_VAL,w	; settings
	btfsc	STATUS,Z	; if already zero change to an E	
	goto	SETT_A
	decf	SETT_VAL,f
	goto	UP_DSP_SET	; Display update
SETT_A
	movlw	H'0E'
	movwf	SETT_VAL
	goto	UP_DSP_SET		

; up variation setting
UP_VARY_SETT			; change the settings value
	bcf		SETT_CHNG,1	
	movf	SETT_VAL,w	; settings value 0-8 
	btfsc	STATUS,Z	; 0
	goto	CYL_DSP_SET	
	
	movf	SETT_VAL,w
	xorlw	H'01'		; minrpm
	btfsc	STATUS,Z
	goto	MINRPM_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'02'		; maxrpm
	btfsc	STATUS,Z
	goto	MAXRPM_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'03'		; minload
	btfsc	STATUS,Z
	goto	MINLOAD_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'04'		; maxload
	btfsc	STATUS,Z
	goto	MAXLOAD_DSP_SET
	
	movf	SETT_VAL,w
	xorlw	H'05'		; 1 MAP or 2 MAPs
	btfsc	STATUS,Z
	goto	MAP_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'06'		; 0.5/1 degree
	btfsc	STATUS,Z
	goto	OFIVEONE_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'07'		; low rpm
	btfsc	STATUS,Z
	goto	LOWRPM_DSP_SET
	
	movf	SETT_VAL,w
	xorlw	H'08'		; dwell
	btfsc	STATUS,Z
	goto	DWELL_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'09'		; edge
	btfsc	STATUS,Z
	goto	EDGE_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'0A'		; Debounce
	btfsc	STATUS,Z
	goto	DEB_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'0B'		; Knock
	btfsc	STATUS,Z
	goto	KNOCK_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'0C'		; DIAGnostic
	btfsc	STATUS,Z
	goto	DIAGN_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'0D'		; Oscillator
	btfsc	STATUS,Z
	goto	OSC_DSP_SET

	goto	UP_DSP_SET	; update display

; ******
CYL_DSP_SET
; cylinder setting:
	incf	CYLINDER_VAL,w	; cylinder value 
	sublw	D'12' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SETT_1_CYLVAL
	incf	CYLINDER_VAL,f
	goto	NEW_CYL_VAL	
SETT_1_CYLVAL
	clrf	CYLINDER_VAL
	incf	CYLINDER_VAL,f
NEW_CYL_VAL	
; write to EEPROM
	movlw	EEPROM248
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	CYLINDER_VAL,w
	call	EWRITE
	
; rpm calculation numerator	
; 93750 (H16E36)/cylinders. For 1 cylinder the 1 in 16E36 is set at 
; calculation of rpm in normal code routine
	movlw	H'01'
	movwf	AARGB0
	movlw	H'6E'		; H16E36
	movwf	AARGB1
	movlw	H'36'	
 	movwf	AARGB2
	clrf	BARGB0
	movf	CYLINDER_VAL,w
	movwf	BARGB1
	bcf		PCLATH,3	; page 0
	call	FXD2416U	; divide
	movf	AARGB1,w
	movwf	RPM_0
	movf	AARGB2,w
	movwf	RPM_1
; write rpm calculation factor to EEPROM
	movlw	EEPROM250
	call	EEREAD		; set EEADR
	movf	RPM_0,w
	call	EWRITE
	movlw	EEPROM251
	call	EEREAD		; set EEADR
	movf	RPM_1,w
	call	EWRITE
	bsf		PCLATH,3	; page 1
; calculate cylinder degree factor depending on cylinders and 0.5 or 1 degree resolution 
	goto 	WRI_RES		; calculation code (calculation done at 0.5/1 degree resolution setting)
CYL_DSP_SET_DN
; decrease the cylinder value
	decf	CYLINDER_VAL,w	; 
	btfsc	STATUS,Z	; if zero change to an 12	
	goto	SETT_12
	decf	CYLINDER_VAL,f
	goto	NEW_CYL_VAL	
SETT_12
	movlw	D'12'
	movwf	CYLINDER_VAL
	goto	NEW_CYL_VAL	

; *****
DWELL_DSP_SET
; dwell limit to 124 (25.3ms)
	incf	DWELL,w		; settings 
	sublw	D'124' 		; maximum
	btfss	STATUS,C	; if c = 0 then at maximum
	goto	SETT_0_DWELL
	incf	DWELL,f
; write to EEPROM
WRI_DWELL
	movlw	EEPROM246
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	DWELL,w
	call	EWRITE
	bsf		PCLATH,3	; page 1
	goto	UP_DSP_SET	; update display
SETT_0_DWELL
	clrf	DWELL
	goto	WRI_DWELL
DWELL_DSP_SET_DN
; dwell limit to 124 (25.3ms)
	movf	DWELL,w		; setting
	btfsc	STATUS,Z	; if already zero change to an 8	
	goto	DWELL_124
	decf	DWELL,f
	goto	WRI_DWELL
DWELL_124
	movlw	D'124'
	movwf	DWELL
	goto	WRI_DWELL

; ****
MINLOAD_DSP_SET
; minimum load up(0-255)
	incf	MIN_LOAD,f
; write to EEPROM
WRI_MIN_LOAD
	movlw	EEPROM254
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	MIN_LOAD,w
	call	EWRITE
; recalculate maximum load
	bsf		PCLATH,3	; page 1
	goto	REC_MAXLOAD ; recalculate maximum load
MINLOAD_DSP_SET_DN
; minimum load down(0-255)
	decf	MIN_LOAD,f
	goto	WRI_MIN_LOAD

; ****
MAXLOAD_DSP_SET
; change load/site steps (0-255) and calculate max load
; load/site steps up(0-255)
	incf	LOAD_STEP,f
; write to EEPROM
WRI_LOAD_STEP
	movlw	EEPROM247
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	LOAD_STEP,w
	call	EWRITE
REC_MAXLOAD
; for MAP1/MAP2 recalculate MAX_LOAD = 10 x LOAD_STEP + MIN_LOAD
; for single MAP MAX_LOAD = 14 x LOAD_STEP + MIN_LOAD
	movf	LOAD_STEP,w
	movwf	AARGB0
	movlw	D'14'		; for single map
	btfss	DEG_EDG_MAP,2		; skip when bit 2 is high
	movlw	D'10'		; load 10 for bit 2 low
	movwf	BARGB0
	bcf		PCLATH,3	; page 0
	call	EIGHTEIGHT	; multiply
; check over
	bsf		PCLATH,3	; page 1
	movf	AARGB0,w
	btfss	STATUS,Z	; if not zero overload
	goto	OVR_MAX_LOAD
	movf	AARGB1,w
	addwf	MIN_LOAD,w
	movwf	MAX_LOAD
	btfsc	STATUS,C	; if carry set over
	clrf	MAX_LOAD
; rewrite max load to EEPROM
RE_255
	bcf		PCLATH,3	; page 0
	movlw	EEPROM255
	call	EEREAD		; set EEADR
	movf	MAX_LOAD,w
	call	EWRITE

	bsf		PCLATH,3	; page 1
	goto	UP_DSP_SET	; update display
MAXLOAD_DSP_SET_DN
; maximum load down(0-255)
	decf	LOAD_STEP,f
	goto	WRI_LOAD_STEP
OVR_MAX_LOAD
	clrf	MAX_LOAD	; cleared on overload
	goto	RE_255

; ****
MINRPM_DSP_SET
; minimum rpm up(0-25500)
	incf	MIN_RPM,f
; write to EEPROM
WRI_MIN_RPM
	movlw	EEPROM252
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	MIN_RPM,w
	call	EWRITE
; recalculate maximum rpm
	bsf		PCLATH,3	; page 1
	goto	REC_MAXRPM ; recalculate maximum rpm
MINRPM_DSP_SET_DN
; minimum rpm down(000-25500)
	decf	MIN_RPM,f
	goto	WRI_MIN_RPM

; ****
MAXRPM_DSP_SET
; change rpm/site steps (000-25500) and calculate max rpm
; rpm/site steps up(000-25500)
	incf	RPM_STEP,f
; write to EEPROM
WRI_RPM_STEP
	movlw	EEPROM256
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	RPM_STEP,w
	call	EWRITE
	bsf		PCLATH,3	; page 1
	goto	REC_MAXRPM

MAXRPM_DSP_SET_DN
; max rpm down(000-25500)
	decf	RPM_STEP,f
	goto	WRI_RPM_STEP

REC_MAXRPM
; For maps 1 and 2 recalculate MAX_RPM = 10 x RPM_STEP + MIN_RPM
; for single map MAX_RPM = 14 x RPM_STEP + MIN_RPM
	movf	RPM_STEP,w
	movwf	AARGB0
	movlw	D'14'		; for single map
	btfss	DEG_EDG_MAP,2		; skip when bit 2 is high
	movlw	D'10'		; load 10 for bit 2 low
	movwf	BARGB0
	movwf	BARGB0
	bcf		PCLATH,3	; page 0
	call	EIGHTEIGHT	; multiply
; check over
	bsf		PCLATH,3	; page 1
	movf	AARGB0,w
	btfss	STATUS,Z	; if not zero overload
	goto	OVR_MAX_RPM
	movf	AARGB1,w
	addwf	MIN_RPM,w
	movwf	MAX_RPM
	btfsc	STATUS,C	; if carry set over
	clrf	MAX_RPM
; rewrite max rpm to EEPROM
RE_253
	bcf		PCLATH,3	; page 0
	movlw	EEPROM253
	call	EEREAD		; set EEADR
	movf	MAX_RPM,w
	call	EWRITE
	bsf		PCLATH,3	; page 1
	goto	UP_DSP_SET	; update display
OVR_MAX_RPM
	clrf	MAX_RPM		; cleared on overload
	goto	RE_253

; *****
OFIVEONE_DSP_SET
OFIVEONE_DSP_SET_DN	; up and down the same as a toggle function 
; 0.5 and 1 degree setting recalculate cylinder degree factor
	btfss	DEG_EDG_MAP,0	; if set clear
	goto	SET_RES
	bcf		DEG_EDG_MAP,0	; 0.5 degree
	goto	WRI_RES
SET_RES
	bsf		DEG_EDG_MAP,0	; 1 degree
WRI_RES
	btfss	DEG_EDG_MAP,0	; if low 0.5
	goto	SET_CYL_DEG05
; 1 degree resolution. cylinder degree factor is 720/cylinders
	movlw	H'02'		; 720=H2D0
	movwf	AARGB1
	movlw	H'D0'	
CALC_CYL_DEG1
 	movwf	AARGB2
	clrf	AARGB0
	clrf	BARGB0
	movf	CYLINDER_VAL,w
	movwf	BARGB1
	bcf		PCLATH,3	; page 0
	call	FXD2416U	; divide
	movf	AARGB1,w
	movwf	CYL_DEG0
	movf	AARGB2,w
	movwf	CYL_DEG1
; write cylinder degree factor to EEPROM
	movlw	EEPROM244
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	CYL_DEG0,w
	call	EWRITE
	movlw	EEPROM245
	call	EEREAD		; set EEADR
	movf	CYL_DEG1,w
	call	EWRITE
	bsf		PCLATH,3	; page 1
	goto	EEP_249		; write resolution option to EEPROM
SET_CYL_DEG05
	movlw	H'05'		; 1440=H5A0
	movwf	AARGB1
	movlw	H'A0'
	goto	CALC_CYL_DEG1

; *****
LOWRPM_DSP_SET
; low rpm setting
	incf	LOW_RPM,f	; settings 
	
; write to EEPROM
WRI_LOW_RPM
	movlw	EEPROM243
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	LOW_RPM,w
	call	EWRITE
	bsf		PCLATH,3	; page 1
	goto	UP_DSP_SET	; update display

LOWRPM_DSP_SET_DN
 	decf	LOW_RPM,f
	goto	WRI_LOW_RPM

; *****
EDGE_DSP_SET
EDGE_DSP_SET_DN	; up and down same function as it is a toggle feature

; high/low edge triggering change edge at change
	btfss	DEG_EDG_MAP,1	; if set clear
	goto	SET_EDGE1
	bcf		DEG_EDG_MAP,1	; if low invert
	goto	WRI_EDGE_LEVEL
SET_EDGE1
	bsf		DEG_EDG_MAP,1	; if high non-invert
WRI_EDGE_LEVEL
	btfss	DEG_EDG_MAP,1	; if low invert
	goto	EDGE_L			; set high going edge
	bsf		STATUS,RP0		; bank 1
	bcf		OPTION_REG,INTEDG; interrupt every falling edge
	bcf		STATUS,RP0		; bank 0
	goto	EEP_249
EDGE_L
	bsf		STATUS,RP0		; bank 1
	bsf		OPTION_REG,INTEDG; interrupt every rising edge
	bcf		STATUS,RP0		; bank 0
EEP_249
	movlw	EEPROM249
	bcf		PCLATH,3	; page 0
	call	EEREAD		; set EEADR
	movf	DEG_EDG_MAP,w
	call	EWRITE
	bsf		PCLATH,3	; page 1
	goto	UP_DSP_SET	; update display

MAP_DSP_SET
; 1 MAP or 2 MAPs
	btfss	DEG_EDG_MAP,2	; if set clear
	goto	SET_MAP1
	bcf		DEG_EDG_MAP,2	; if low 
	goto	EEP_249			; write to EEPROM
SET_MAP1
	bsf		DEG_EDG_MAP,2	; if high 
	goto	EEP_249

; *****
DEB_DSP_SET
DEB_DSP_SET_DN
; debounce settings up
	btfss	DEG_EDG_MAP,5
	goto	CLR_DEB
	bcf		DEG_EDG_MAP,5	; 0.4ms
	goto	EEP_249			; write to eeprom
CLR_DEB
	bsf		DEG_EDG_MAP,5	; 2ms
	goto	EEP_249	

; *****
KNOCK_DSP_SET
; knock settings up
	movf	DEG_EDG_MAP,w
	movwf	REMB0
	swapf	REMB0,f			; ms to ls bits
	rrf		REMB0,f			; shift to get 7,6 to 1,0
	rrf		REMB0,f
	incf	REMB0,f			; next up
KNOCK_MOVE
	bcf		DEG_EDG_MAP,7
	bcf		DEG_EDG_MAP,6
	btfsc	REMB0,1
	bsf		DEG_EDG_MAP,7
	btfsc	REMB0,0
	bsf		DEG_EDG_MAP,6
	goto	EEP_249

KNOCK_DSP_SET_DN
; knock settings down
	movf	DEG_EDG_MAP,w
	movwf	REMB0
	swapf	REMB0,f			; ms to ls bits
	rrf		REMB0,f			; shift to get 7,6 to 1,0
	rrf		REMB0,f
	decf	REMB0,f			; next down
	goto	KNOCK_MOVE

; *****
; Diagnostic interpolation on/off
DIAGN_DSP_SET
	btfss	DEG_EDG_MAP,4	; if clear set
	goto	SET_INTERP_ON
	bcf		DEG_EDG_MAP,4	; clear			
	goto	EEP_249
SET_INTERP_ON
	bsf		DEG_EDG_MAP,4
	goto	EEP_249

; *****
; Oscillator on/off
OSC_DSP_SET
	btfss	DEG_EDG_MAP,3	; if clear set
	goto	SET_OSC_ON
	bcf		DEG_EDG_MAP,3	; clear			
	goto	UP_DSP_SET	; update display (no storage in EEPROM)
SET_OSC_ON
	bsf		DEG_EDG_MAP,3
	goto	UP_DSP_SET	; update display (no storage in EEPROM)

; *****
; settings change
DN_VARY_SETT			; change the settings value
	bcf		SETT_CHNG,1	
	movf	SETT_VAL,w	; settings value 0-7 (1-8)
	btfsc	STATUS,Z	; 0
	goto	CYL_DSP_SET_DN	
	
	movf	SETT_VAL,w
	xorlw	H'01'		; minrpm
	btfsc	STATUS,Z
	goto	MINRPM_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'02'		; maxrpm
	btfsc	STATUS,Z
	goto	MAXRPM_DSP_SET_DN
	
	movf	SETT_VAL,w
	xorlw	H'03'		; minload
	btfsc	STATUS,Z
	goto	MINLOAD_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'04'		; maxload
	btfsc	STATUS,Z
	goto	MAXLOAD_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'05'		; 1 MAP or 2 MAPs
	btfsc	STATUS,Z
	goto	MAP_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'06'		; 0.5/1 degree
	btfsc	STATUS,Z
	goto	OFIVEONE_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'07'		; low rpm
	btfsc	STATUS,Z
	goto	LOWRPM_DSP_SET_DN
	
	movf	SETT_VAL,w
	xorlw	H'08'		; dwell
	btfsc	STATUS,Z
	goto	DWELL_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'09'		; edge
	btfsc	STATUS,Z
	goto	EDGE_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'0A'		; Debounce
	btfsc	STATUS,Z
	goto	DEB_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'0B'		; knock
	btfsc	STATUS,Z
	goto	KNOCK_DSP_SET_DN

	movf	SETT_VAL,w
	xorlw	H'0C'		; Diagnostic
	btfsc	STATUS,Z
	goto	DIAGN_DSP_SET

	movf	SETT_VAL,w
	xorlw	H'0D'		; Oscillator
	btfsc	STATUS,Z
	goto	OSC_DSP_SET
	
;	goto	UP_DSP_SET	; update display

; *****
UP_DSP_SET
	bcf		PCLATH,3	; page 0
	btfsc	SETT_CHNG,1	; if set bypass update
	goto	CALCULATE
; adjust updated flags
	bsf		SETT_CHNG,1	; 
	bcf		SETT_CHNG,0
; initialise display for settings

	movlw	H'80'		; address line 1
	call	LOAD
	movlw	A'S'		; Set
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	bsf		PCLATH,3	; page 1

; Settings value 0-7 (1-8)
	movf	SETT_VAL,w	; cylinders. 
	btfsc	STATUS,Z	; 0
	goto	CYL_DSP	
	
	movf	SETT_VAL,w
	xorlw	H'01'		; minrpm
	btfsc	STATUS,Z
	goto	MINRPM_DSP

	movf	SETT_VAL,w
	xorlw	H'02'		; maxrpm
	btfsc	STATUS,Z
	goto	MAXRPM_DSP

	movf	SETT_VAL,w
	xorlw	H'03'		; minload
	btfsc	STATUS,Z
	goto	MINLOAD_DSP

	movf	SETT_VAL,w
	xorlw	H'04'		; maxload
	btfsc	STATUS,Z
	goto	MAXLOAD_DSP
	
	movf	SETT_VAL,w
	xorlw	H'05'		; 1 MAP or 2 MAPs
	btfsc	STATUS,Z
	goto	MAP_DSP_SHOW
	
	movf	SETT_VAL,w
	xorlw	H'06'		; 0.5/1 degree
	btfsc	STATUS,Z
	goto	OFIVEONE_DSP

	movf	SETT_VAL,w
	xorlw	H'07'		; low rpm
	btfsc	STATUS,Z
	goto	LOWRPM_DSP
	
	movf	SETT_VAL,w
	xorlw	H'08'		; dwell
	btfsc	STATUS,Z
	goto	DWELL_DSP

	movf	SETT_VAL,w
	xorlw	H'09'		; edge
	btfsc	STATUS,Z
	goto	EDGE_DSP

	movf	SETT_VAL,w
	xorlw	H'0A'		; debounce
	btfsc	STATUS,Z
	goto	DEB_DSP

	movf	SETT_VAL,w
	xorlw	H'0B'		; Knock
	btfsc	STATUS,Z
	goto	KNOCK_DSP

	movf	SETT_VAL,w
	xorlw	H'0C'		; Diag
	btfsc	STATUS,Z
	goto	DIAGN_DSP

	movf	SETT_VAL,w
	xorlw	H'0D'		; Osc
	btfsc	STATUS,Z
	goto	OSC_DSP

; settings
	bcf		PCLATH,3	; page 0
	movlw	H'80'		; address line 1
	call	LOAD
	call	SPACE3
	movlw	A'<'		; 
	call	DRV_LCD
	movlw	A'S'		; Settings
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'T'		; Set
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'G'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'>'		; Settings
	call	DRV_LCD
	call	SPACE4
	movlw	H'C0'		; line 2
	call	LOAD
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
	bsf		PCLATH,3	; page 1	
	goto	SETT_SW_DEB

; 1. Cylinders
CYL_DSP
	bcf		PCLATH,3	; page 0
	movlw	H'80'		; address line 1
	call	LOAD
	movlw	A'S'			;
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'K'		; 
	call	DRV_LCD
	movlw	A'E'		;
	call	DRV_LCD
	call	SPACE1
	call	SPACE4
	movlw	A'4'		; 
	call	DRV_LCD
	call	SPACE1
	
	movlw	A'['			;
	call	DRV_LCD
	movlw	A'2'		; 
	call	DRV_LCD
	movlw	A']'			;
	call	DRV_LCD
	
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'C'		; 
	call	DRV_LCD
	movlw	A'Y'			;
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'N'			;
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'R'			;
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	call	SPACE1

	movf	CYLINDER_VAL,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	bsf		PCLATH,3	; page 1
	
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADC2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADC3

LOADC2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADC3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	call	SPACE1

; write 2-stroke cylinder
	movlw	A'['		; 
	call	DRV_LCD
	bsf		PCLATH,3	; page 1
	btfsc	CYLINDER_VAL,0; if set write dash
	goto	DASH
	bcf		STATUS,C
	rrf		CYLINDER_VAL,w
	movwf	BIN_0
	bcf		PCLATH,3	; page 0		
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT3,w
	call	DRV_LCD
	movlw	A']'		; 
	call	DRV_LCD
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB
DASH
	bcf		PCLATH,3	; page 0
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A']'		; 
	call	DRV_LCD
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 2. Dwell
DWELL_DSP
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'W'			;
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'L'			;
	call	DRV_LCD
	call	SPACE4
	call	SPACE1
; multiply DWELL x 2048(H800) (204.8us/value) and / 1000 (H2710)
	movf	DWELL,w
	movwf	AARGB2
	clrf	AARGB0		; ms bytes cleared
	clrf	AARGB1
	movlw	H'08'		; 800H
	movwf	BARGB1
	movlw	H'00'
	movwf	BARGB2
	clrf	BARGB0		; ms bytes cleared
	call	FXM2424U	; multiply 
; divide by 10000
	movf	AARGB3,w	; shift bytes
	movwf	AARGB0
	movf	AARGB4,w
	movwf	AARGB1
	movf	AARGB5,w
	movwf	AARGB2
	movlw	H'3'
	movwf	BARGB0
	movlw	H'E8'
	movwf	BARGB1
	call	FXD2416U	; divide
	movf	AARGB2,w
	
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	bsf		PCLATH,3	; page 1
	
	movf	OUT1,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADDW1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADDW2

LOADDW1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADDW2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	movlw	A'.'		; decimal point
	call	DRV_LCD
	movf	OUT3,w
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A's'		;
	call	DRV_LCD
	call 	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 3. Min Load (show load steps and calc maximum)
MINLOAD_DSP
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'I'			;
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	call	SPACE2
; display min load
	movf	MIN_LOAD,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	bsf		PCLATH,3	; page 1
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADLMR1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADLMR2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADLMR3
LOADLMR1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADLMR2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADLMR3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	call	SPACE4
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 4. Max Load (show load steps and calc maximum)(changes to steps not maximum value)
MAXLOAD_DSP
	bcf		PCLATH,3	; page 0
	movlw	H'80'		; address line 1
	call	LOAD

; display load steps
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'/'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
;	call	SPACE1
	
; display load steps
	movf	LOAD_STEP,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	bsf		PCLATH,3	; page 1
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADMLS1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADMLS2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3
	goto	LOADMLS3
LOADMLS1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMLS2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMLS3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	call	SPACE4

; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'A'			;
	call	DRV_LCD
	movlw	A'X'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'D'		; 
	call	DRV_LCD
	call	SPACE2
; display max load
	movf	MAX_LOAD,w
	movwf	BIN_0		;
	bsf		PCLATH,3	; page 1
	btfsc	STATUS,Z	; if zero write error
	goto	WRI_ERR
	bcf		PCLATH,3	; page 0
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	bsf		PCLATH,3	; page 1
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADMLMR1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADMLMR2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADMLMR3
LOADMLMR1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMLMR2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMLMR3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	call	SPACE4
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

WRI_ERR1
	bcf		PCLATH,3	; page 0
	call	SPACE1
WRI_ERR
	bcf		PCLATH,3	; page 0
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'R'			;
	call	DRV_LCD
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'R'			;
	call	DRV_LCD
	call	SPACE4
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 5. Min rpm  (show rpm steps and calc maximum)
MINRPM_DSP
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'I'			;
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'P'			;
	call	DRV_LCD
	movlw	A'M'		; 
	call	DRV_LCD
	call	SPACE1
; display min rpm
	movf	MIN_RPM,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	bsf		PCLATH,3	; page 1
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADMR1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADMR2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADMR3
LOADMR1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMR2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMR3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 10's digit
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 1's digit
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'p'			;
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	call	SPACE1
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 6. Max rpm  (show rpm steps and calc maximum)(changes to steps not maximum value)	
MAXRPM_DSP
	bcf		PCLATH,3	; page 0
	movlw	H'80'		; address line 1
	call	LOAD

; display rpm steps
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'/'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	
; display rpm steps

	movf	RPM_STEP,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	bsf		PCLATH,3	; page 1
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADMAR1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADMAR2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3
	goto	LOADMAR3
LOADMAR1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMAR2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMAR3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 10's digit
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 1's digit
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'p'			;
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD

; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'A'			;
	call	DRV_LCD
	movlw	A'X'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'P'			;
	call	DRV_LCD
	movlw	A'M'		; 
	call	DRV_LCD
	call	SPACE1
; display max rpm
	movf	MAX_RPM,w
	movwf	BIN_0		;
	bsf		PCLATH,3	; page 1
	btfsc	STATUS,Z	; if zero write error
	goto	WRI_ERR1
	bcf		PCLATH,3	; page 0
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	bsf		PCLATH,3	; page 1
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADMR1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADMMAR2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADMMAR3
LOADMMAR1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMMAR2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADMMAR3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 10's digit
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 1's digit
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'p'			;
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	call	SPACE1
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 7. 0.5 or 1 degree steps
OFIVEONE_DSP
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE1
	call	SPACE4
	CALL 	SPACE4
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'E'			;
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'L'			;
	call	DRV_LCD
	movlw	A'U'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'I'			;
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
	bsf		PCLATH,3	; page 1
	btfss	DEG_EDG_MAP,0
	goto	WRI_05
	bcf		PCLATH,3	; page 0
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A'.'			;
	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	H'DF'		; degrees
	call	DRV_LCD
	call	SPACE3
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB
WRI_05
	bcf		PCLATH,3	; page 0
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	A'.'			;
	call	DRV_LCD
	movlw	A'5'		; 
	call	DRV_LCD
	movlw	H'DF'		; degrees
	call	DRV_LCD
	call	SPACE3
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB	

; 8. Low rpm
LOWRPM_DSP	
	bcf		PCLATH,3	; page 0
	movlw	A':'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'E'			;
	call	DRV_LCD
	movlw	A'S'			;
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'			;
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'E'			;
	call	DRV_LCD
	call	SPACE1
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'W'			;
	call	DRV_LCD
	call	SPACE1
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'M'			;
	call	DRV_LCD
	call	SPACE1
; 
	movf	LOW_RPM,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value

	movf	OUT1,w		; ms value
	bsf		PCLATH,3	; page 1
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADLOW1
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADLOW2
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADLOW3
LOADLOW1
	movf	OUT1,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADLOW2
	movf	OUT2,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
LOADLOW3
	movf	OUT3,w
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 10's digit
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 1's digit
	call	DRV_LCD
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'p'			;
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	call	SPACE1
;
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 9. High or low edge triggering
EDGE_DSP
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE1
	call	SPACE4
	call	SPACE4
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'D'			;
	call	DRV_LCD
	movlw	A'G'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	call	SPACE4
	call	SPACE3
	bsf		PCLATH,3	; page 1
	btfss	DEG_EDG_MAP,1
	goto	WRI_HIGH
	bcf		PCLATH,3	; page 0
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'W'		; 
	call	DRV_LCD
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB
WRI_HIGH
	bcf		PCLATH,3	; page 0
	movlw	A'H'		; 
	call	DRV_LCD
	movlw	A'I'			;
	call	DRV_LCD
	movlw	A'G'		; 
	call	DRV_LCD
	movlw	A'H'		; 
	call	DRV_LCD
	call	SPACE3
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB	

; 10. Debounce
; 
DEB_DSP
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call	SPACE1
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'D'		; 
	call	DRV_LCD
	movlw	A'E'			;
	call	DRV_LCD
	movlw	A'-'		; 
	call	DRV_LCD
	movlw	A'B'		; 
	call	DRV_LCD
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'U'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'C'			;
	call	DRV_LCD
	movlw	A'E'			;
	call	DRV_LCD
	call	SPACE2

	movlw	A'0'			; 0.4ms
	btfsc	DEG_EDG_MAP,5 	; when set 2ms
	movlw	A'2'			; 2.0ms
	call	DRV_LCD
	movlw	A'.'		; decimal point
	call	DRV_LCD
	movlw	A'4'			; 0.4ms
	btfsc	DEG_EDG_MAP,5 	; when set 2ms
	movlw	A'0'			; 2.0ms
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	movlw	A's'		;
	call	DRV_LCD
	call 	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 11 Maps (1 MAP or 2-MAPS)
MAP_DSP_SHOW
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE1
	call	SPACE4
	call	SPACE4
; line 2
	movlw	B'11000000'	; address line 2
	call	LOAD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'A'			;
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	call	SPACE4
;	call	SPACE2
	bsf		PCLATH,3	; page 1
	btfss	DEG_EDG_MAP,2
	goto	WRI_TWO
	bcf		PCLATH,3	; page 0
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A'('		;
	call	DRV_LCD
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A'5'		; 
	call	DRV_LCD
	movlw	A'x'		;
	call	DRV_LCD
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A'5'		; 
	call	DRV_LCD
	movlw	A')'		;
	call	DRV_LCD
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB
WRI_TWO
	bcf		PCLATH,3	; page 0
	movlw	A'2'		; 
	call	DRV_LCD
	movlw	A'('		;
	call	DRV_LCD
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A'x'		;
	call	DRV_LCD
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A'1'		; 
	call	DRV_LCD
	movlw	A')'		;
	call	DRV_LCD
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 12. Knock
KNOCK_DSP
	bcf		PCLATH,3	; page 0
	call 	SPACE4
	movlw	A'K'		; KNOCK
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'C'		; 
	call	DRV_LCD
	movlw	A'K'		; 
	call	DRV_LCD
	movlw	A':'		; 
	call	DRV_LCD
	bsf		PCLATH,3	; page 1
	btfss	DEG_EDG_MAP,7; on or off
	goto	OFF_KNOCK
	bcf		PCLATH,3	; page 0
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	KNOCK_L2
OFF_KNOCK
	bcf		PCLATH,3	; page 0
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	call	SPACE4

KNOCK_L2; line 2
	bcf		PCLATH,3	; page 0
	movlw	H'C0'		; line 2
	call	LOAD
	movlw	A'L'		; LIMIT
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD	
	call	SPACE2
; find settings
	movlw	A'6'		; 6000 rpm LIMIT
	btfsc	DEG_EDG_MAP,6; if set 4000rpm limit
	movlw	A'4'		; 4000 rpm LIMIT

	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	movlw	A'0'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'r'		; 
	call	DRV_LCD
	movlw	A'p'		; 
	call	DRV_LCD
	movlw	A'm'		; 
	call	DRV_LCD
	call	SPACE4
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 13. Diagnostic interpolation on/off
DIAGN_DSP
	bcf		PCLATH,3	; page 0
	call 	SPACE3
	movlw	A'D'		; DIAGNOSTIC
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'G'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'C'		; 
	call	DRV_LCD
	
; line 2
	movlw	H'C0'		; line 2
	call	LOAD
	bsf		PCLATH,3	; page 1
	btfsc	DEG_EDG_MAP,4; on or off
	goto	WRITE_INTERPOLATE
	bcf		PCLATH,3	; page 0
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	call	SPACE1

WRITE_INTERPOLATE
	bcf		PCLATH,3	; page 0
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'R'		; 
	call	DRV_LCD	
	movlw	A'P'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD	
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
; get setting	
	bsf		PCLATH,3	; page 1
	btfss	DEG_EDG_MAP,4; on or off
	goto	OFF_DIAGN
	bcf		PCLATH,3	; page 0
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB
OFF_DIAGN
	bcf		PCLATH,3	; page 0
	call	SPACE1
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB

; 14. Oscillator on/off
OSC_DSP
	bcf		PCLATH,3	; page 0
	call	SPACE4
	call	SPACE1
	call	SPACE4
	call	SPACE4

OSC_L2; line 2
	movlw	H'C0'		; line 2
	call	LOAD
	movlw	A'O'		; Oscillator
	call	DRV_LCD
	movlw	A'S'		; 
	call	DRV_LCD
	movlw	A'C'		; 
	call	DRV_LCD
	movlw	A'I'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'R'		; 
	call	DRV_LCD
; get setting	
	bsf		PCLATH,3	; page 1
	btfss	DEG_EDG_MAP,3; on or off
	goto	OFF_OSC
	bcf		PCLATH,3	; page 0
	call	SPACE4
	movlw	A'O'			;
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	call	SPACE1
	bsf		PCLATH,3	; page 1
	goto	SETT_SW_DEB
OFF_OSC
	bcf		PCLATH,3	; page 0
	call	SPACE3
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	call	SPACE1

; add delay for switch debounce
SETT_SW_DEB
	movlw	D'15'
	movwf	STORE3
RE_DO_DELAY
	bcf		PCLATH,3	; page 0
	call	DELAYX
	bsf		PCLATH,3	; page 1
	decfsz 	STORE3,f
	goto	RE_DO_DELAY
	bcf		PCLATH,3	; page 0	
	goto	CALCULATE

; routine moved from page 0 to page 1 (no room)
LOAD_RPM_ACTUAL_CODE ;(rpm and load values in RUN/DIAG mode)
	bcf		PCLATH,3	; page 0
	movlw	H'C3'
	call	LOAD		; position 3 line 2
	movf	RPM_VAL,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	bsf		PCLATH,3	; page 1
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADRX
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADRY
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADRZ
LOADRX
	bcf		PCLATH,3	; page 0
	movf	OUT1,w
	call	DRV_LCD
LOADRY
	bcf		PCLATH,3	; page 0
	movf	OUT2,w
	call	DRV_LCD
LOADRZ
	bcf		PCLATH,3	; page 0
	movf	OUT3,w
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 10's digit
	call	DRV_LCD
	movlw	A'0'		; 0 fixed 1's digit
	call	DRV_LCD

	bsf		PCLATH,3	; page 1
	movf	KNOCK,w
	btfsc	STATUS,Z	; if zero no knock
	goto	LX_LOAD_SPACE
	call	KNOCK_DRV0	; knock symbol
	bcf		PCLATH,3	; page 0
	call	DRV_LCD
	bsf		PCLATH,3	; page 1
	goto	LX_LOAD_VALUE
LX_LOAD_SPACE
	bcf		PCLATH,3	; page 0
	call	SPACE1
LX_LOAD_VALUE
	bcf		PCLATH,3	; page 0
	movlw	H'CD'		; position on display
	call	LOAD
	movf	LOAD_D_A,w
	movwf	BIN_0		;
	call	BCD_ASCII	; get bcd/ASCII value
	bsf		PCLATH,3	; page 1
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOADLDX
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space

; mid digit
	bsf		PCLATH,3	; page 1
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOADLDY
	bcf		PCLATH,3	; page 0
	call	SPACE1		; leading 0's to space
	bsf		PCLATH,3	; page 1
	goto	LOADLDZ
LOADLDX
	bcf		PCLATH,3	; page 0
	movf	OUT1,w
	call	DRV_LCD
LOADLDY
	bcf		PCLATH,3	; page 0
	movf	OUT2,w
	call	DRV_LCD
LOADLDZ
	bcf		PCLATH,3	; page 0
	movf	OUT3,w
	call	DRV_LCD
	goto	TEST_DELAY

; knock symbol showing 4-stages of intensity
KNOCK_DRV0
	movf	KNOCK,w
	sublw	D'02'		; less then low knock
	btfsc	STATUS,C
	retlw	H'00'		; light ! (exclamation)
	movf	KNOCK,w
	sublw	D'04'		; less then medium knock
	btfsc	STATUS,C
	retlw	H'01'		; 2 dot !
	movf	KNOCK,w
	sublw	D'06'		; less then high knock
	btfsc	STATUS,C
	retlw	H'02'		; 3 dot !
	movf	KNOCK,w
	sublw	D'09'		; less then more severe knock
	btfsc	STATUS,C
	retlw	H'03'		; 4 dot !
	retlw	H'04'		; 5 dot !

; character generation for knock indication (!)	
CHARACTR_GEN
; character 1, minimum width (!)
; low knock level
	bcf		PCLATH,3	; page 0 address (2k blocks)
	movlw	B'01000000'	; address 0
	call	LOAD		; character gen 1 
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00000100'
	call	DRV_LCD
; character 2
; medium knock (wider !)
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00001100'
	call	DRV_LCD
; character 3
; high knock, Wider (!)
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00001110'
	call	DRV_LCD
; character 4 
; higher
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
; character 5
; severe knock
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	return

	end
