'Pic08M Thermostat with 4017 decade counter display

'pin0 (out) = reset line to 4017
'pin1 (out) = clock data to 4017
'pin2 (out) = LED/Relay (high active)
'pin3 (in)  = pushbutton (high active)
'pin4 (in)  = Thermistor input ADC

'b1 = loop counter (4017 clock)
'b2 = processed temp data
'b3 = another loop counter/processed temp data (testmode)
'b4 = temperature setpoint
'w5 = temperature data via thermistor voltage divider
'w6 = delay counter - about 1 minute hysteresis

'**** Initialization *******
'set pins as outputs and assert state
low 0 'hold 4017 reset line low
low 1 'set 4017 clock line low
low 2 'LED/relay off

b4=3 'preload setpoint - arbitrary value


'***** Test Mode - display raw ADC count *******
'display last two digits of ADC value on bargraph
 
'This section all remmed out - remove apostrophe to enable 
'this code. Other code will need to be remmed out to 
'avoid exceeding program size limit.


'testmode:
'readadc10 4,w5

'debug w5 
'use debug initially to obtain full three digits of ADC variable

'b2=w5/10
'b2=b2//10
'b3=w5//10 'derive byte values from last two of word variable

'testloop1: 'display second digit of ADC
'pulsout 1,1 'clock 4017 quickly
'b1=b1+1 
'if b1<b2 then testloop1  
'b1=0
'pause 500 'shorter pause
'pulsout 0,1 'reset 4017

'testloop2: 'display last digit of ADC
'pulsout 1,7500 'clock 4017 slowly
'b1=b1+1 
'if b1<b3 then testloop2  
'b1=0
'pause 1200 'longer pause
'pulsout 0,1 'reset 4017

'goto testmode

'*** End Test Mode ***


'******** Read Temperature Sensor ********
readsensor:
w6=0 'reset delaycounter
pulsout 0,1 'reset 4017

readadc10 4,w5 'get temp data from thermistor 10bit mode

'Adjust w5 comparison values below in accordance with calibration
'values obtained by debug or using test mode.

't16: or lower
if w5>390 then t17
b2=0
goto compare_data

t17:
if w5>400 then t18
b2=1
goto compare_data

t18:
if w5>411 then t19
b2=2
goto compare_data

t19:
if w5>423 then t20
b2=3
goto compare_data

t20:
if w5>435 then t21
b2=4
goto compare_data

t21:
if w5>447 then t22
b2=5
goto compare_data

t22:
if w5>460 then t23
b2=6
goto compare_data

t23:
if w5>473 then t24
b2=7
goto compare_data

t24:
if w5>486 then t25
b2=8
goto compare_data

t25: 'or higher
b2=9


compare_data:
if b4>b2 then outputon 'check if temp lower than setpoint
low 2 'turn off LED/relay 

'******* Main loop **************
mainloop:
if b2=0 then nocount: 'skip clock pulses if no data
pulsout 1,2 'clock the 4017
b1=b1+1 'add the counter
w6=w6+1 'delay counter about 1 minute
if b1<b2 then mainloop 'loop around 
b1=0
nocount:
pulsout 0,1 'reset 4017
w6=w6+1 'loop here for around 1 minute then recheck temperature
if pin3=1 then push0 'check if button pushed
if w6> 24000 then readsensor '24000 ~ 1 minute
goto mainloop

'******* Button Pushed ***********
push0:
pulsout 0,1 'reset 4017

push: 'initial push just displays current value
if b4=0 then nocount1
pulsout 1,10 'clock the 4017
b1=b1+1 'add the counter
if b1<b4 then push 'loop around 
b1=0

nocount1:
pause 750 'debounce delay - initially display current setting
if pin3=0 then readsensor 'return if button released

push1: 'continued push changes current setpoint
pulsout 1,10 'clock the 4017
b4=b4+1 'adjust setpoint
if b4 > 9 then push2 'restart count at zero
pause 400 'slow the loop
if pin3=0 then readsensor 'return if button released
goto push1

push2: 'display 0, wrap around to bottom then count up again
b4=0 'reset setpoint
pulsout 0,1 'reset/noclock of 4017
pause 400 'equivalent pause
if pin3=0 then readsensor 'return if button released
goto push1


'***** Switch on Output *********
outputon:
high 2 'turn on LED/relay
goto mainloop

'**** End *****


















