' Ian Paterson's Spoke POV image converter
' copyright 2005 Ian Paterson and copyleft under the terms of the GNU General Public License:
' http://www.gnu.org/licenses/gpl.txt
'
'    This program is free software; you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation; either version 2 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
'
' To contact Ian Paterson, or for more information about this program, visit http://www.ianpaterson.org

DIM angleincrement AS SINGLE
DIM anglecounter AS INTEGER
DIM ringcounter AS INTEGER
DIM ledspacing AS INTEGER
DIM ledoffset AS INTEGER
DIM imagesize AS INTEGER
DIM origin AS INTEGER
DIM x AS SINGLE
DIM y AS SINGLE
DIM fileoffset AS LONG
DIM pixel AS STRING * 1
DIM outputstring AS STRING

imagesize = 700          'Horizontal and vertiacal pixel count of source image.
angleincrement = 1.41176 '360 degrees divided by 255 segments.
ledspacing = 10          'Scaling factor. Use a larger number for larger images.
ledoffset = 27           'Bike hub size. Use a larger number for larger hubs.
angleincrement = angleincrement / 57.296 'Convert to radians.
origin = imagesize / 2   'Pivot point (assumed to be the centre of image).

OPEN "d:\che.raw" FOR BINARY AS 1 'Source file and path.
OPEN "d:\che.asm" FOR OUTPUT AS 2 'Destination file and path.

'****** Produce output for memory page 5 ******
PRINT #2, "; Page boundary, image data starts here."
FOR anglecounter = 0 TO 254
   outputstring = "   RETLW B'"
   FOR ringcounter = 32 TO 25 STEP -1
      x = origin + (SIN(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      y = origin + (COS(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      fileoffset = INT(x) + (imagesize * (imagesize - INT(y)))
      GET #1, fileoffset, pixel
      IF ASC(pixel) = 0 THEN
         outputstring = outputstring + "1"
      ELSE
         outputstring = outputstring + "0"
      END IF
   NEXT ringcounter
   outputstring = outputstring + "'"
   PRINT #2, outputstring
NEXT anglecounter
PRINT #2, "   RETLW B'00000000'" 'The final raster line must always be blank
PRINT #2, "; Page boundary"

'****** Produce output for memory page 6 ******
FOR anglecounter = 0 TO 254
   outputstring = "   RETLW B'"
   FOR ringcounter = 24 TO 17 STEP -1
      x = origin + (SIN(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      y = origin + (COS(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      fileoffset = INT(x) + (imagesize * (imagesize - INT(y)))
      GET #1, fileoffset, pixel
      IF ASC(pixel) = 0 THEN
         outputstring = outputstring + "1"
      ELSE
         outputstring = outputstring + "0"
      END IF
   NEXT ringcounter
   outputstring = outputstring + "'"
   PRINT #2, outputstring
NEXT anglecounter
PRINT #2, "   RETLW B'00000000'" 'The final raster line must always be blank
PRINT #2, "; Page boundary"

'****** Produce output for memory page 7 ******
FOR anglecounter = 0 TO 254
   outputstring = "   RETLW B'"
   FOR ringcounter = 16 TO 9 STEP -1
      x = origin + (SIN(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      y = origin + (COS(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      fileoffset = INT(x) + (imagesize * (imagesize - INT(y)))
      GET #1, fileoffset, pixel
      IF ASC(pixel) = 0 THEN
         outputstring = outputstring + "1"
      ELSE
         outputstring = outputstring + "0"
      END IF
   NEXT ringcounter
   outputstring = outputstring + "'"
   PRINT #2, outputstring
NEXT anglecounter
PRINT #2, "   RETLW B'00000000'" 'The final raster line must always be blank
PRINT #2, "; Page boundary"

'****** Produce output for memory page 8 ******
FOR anglecounter = 0 TO 254
   outputstring = "   RETLW B'"
   FOR ringcounter = 8 TO 1 STEP -1
      x = origin + (SIN(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      y = origin + (COS(anglecounter * angleincrement) * ((ringcounter * ledspacing) + ledoffset))
      fileoffset = INT(x) + (imagesize * (imagesize - INT(y)))
      GET #1, fileoffset, pixel
      IF ASC(pixel) = 0 THEN
         outputstring = outputstring + "1"
      ELSE
         outputstring = outputstring + "0"
      END IF
   NEXT ringcounter
   outputstring = outputstring + "'"
   PRINT #2, outputstring
NEXT anglecounter
PRINT #2, "   RETLW B'00000000'" 'The final raster line must always be blank

CLOSE

