;Power Fail Lights  

;Ver 1.4 Program for Picaxe 08M

;-------------------------------------------------------------------------

;define pins and variables

symbol mainsin = pin4		;i/p read mains input, low for fail
symbol pushbut = pin3		;i/p push button 
symbol battin  = 2			;IO for low battery etc

symbol grnled = 0			;green led on output #0 NB: is also serial out pin
symbol relay1 = 1			;relay on output #1

symbol n      = b0			;counter for time loop
let n = 0				;initialize variable n

symbol failed = b1			;flag to stop reactivation after first 5 min period
let failed = 0				;initialise variable failed

symbol intlvl= b2			;interrupt level count
let intlvl= 0				;initialise, 1 = mains failed and interrupted

symbol batvolt = b3			;adc value of battery voltage

symbol quiet = b4			;flag to record alarm is silenced
let quiet = 0				;initialise flag
					
;interrupt settings
symbol inlvl = %00000000		;interrupt on push button press to zero
symbol pinmask  = %00001000	;set bit for pin3

;--------------------------------------------------------------------------
main:	
	setint inlvl,pinmask		;turn interrupts on 

	if mainsin = 0 then fail	;chkmains:link has been shorted = mains failure
	failed = 0			;reset failed flag as mains ok

	goto finish			;reset everything and loop back

fail:	
	gosub batchk			;check battery voltage

	if failed = 1 then main		;failure has been noted previously
	high relay1			;turn on lights relay 
	failed = 1			;set failed flag

	for n = 1 to 150		;leave lights on 150 x 2 = 300 secs
	if mainsin = 1 then finish	;link open while lights on = mains returned
	pause 2000			;2 sec delay

	gosub gnled			;flash green led  

	if intlvl= 1 then main		;returns here from int if button pressed during pause
	next n

	low relay1			;no override push button so turn off
	high grnled			;mains still failed, leave led on
	intlvl= 0			;reset interrupt flag	
	goto main

finish: 
	low relay1			;no push button so turn off
	low grnled
	intlvl= 0			;reset interrupt flag	
	quiet = 0			;reset buzzer quiet flag

	goto main			;loop back