'Project: PWM Variable Speed Drive
'Device: PICAXE-08M, 4MHz
'Code by: Neville Armstrong
'Date: 16/08/07


'Pin allocation
'pin 0: ouptut, FWD signal
'pin 1: output, REV signal
'pin 2: PWMOUT, PWM signal
'pin 3: input, unused
'pin 4: SERIN, serial comms for VSD addr & speed data.


'Symbol definitions
symbol fwd=0
symbol rev=1

symbol pwmduty=w0				'note: w0=b1:b0
symbol frequency=b3
symbol pwmperiod=b4
symbol bytecount=b5
symbol nibbleaddr=b6
symbol datanibble=b7
symbol addrnibble=b8
symbol address=b9
symbol speed=b10
symbol byte1=b11
symbol byte2=b12


'Execution starts here
main:
	address=1				'VSD ADDR, range: 0-7
	frequency=4				'VSD FREQ, range: 1-8 (4-32kHz)

'Initialisation
	low fwd				'FWD=0
	low rev				'REV=0
	speed=128			
	pwmperiod=255/frequency		
	gosub updatepwm			'disable drive initially

'Program loop to receive and process bytes from serial port
getbyte:
	if bytecount=0 then getbyte1
	if bytecount=1 then getbyte2

getbyte1:
	serin 4,N2400,byte1		'wait for byte from serial port
	datanibble=byte1 & $0F		'mask to extract data & addr nibbles
	addrnibble=byte1 & $F0
	addrnibble=addrnibble/16	'right shift 4 places
	nibbleaddr=2*address
	if addrnibble=nibbleaddr then		'adddr & nibble bits match?
		speed=datanibble			'yes, get (ls) speed data
		bytecount=1				'set byte counter = 1
	endif
	goto getbyte
	
getbyte2:
	serin 4,N2400,byte2		'wait for byte from serial port
	datanibble=byte2 & $0F		'mask to extract data & addr nibbles
	addrnibble=byte2 & $F0
	addrnibble=addrnibble/16	'right shift 4 places
	nibbleaddr=2*address+1
	if addrnibble=nibbleaddr then 	'addr & nibble bits match?
		speed=16*speed+datanibble	'yes, get (ms) speed data
		gosub updatepwm			'update PWM with new speed data
	endif
	bytecount=0
	goto getbyte


'Subroutine to update PWM module and digital outputs FWD & REV
updatepwm:
	if speed=128 then disabledrive	'neither forward nor reverse, so disable
	
	if speed>=0 and speed<=127 then	'forward?
		low rev				'yes, set output REV=0 then FWD=1
		high fwd
	else 						'no,reverse
		speed=-speed			'change sign of speed data (ie, take 2'comp)
		low fwd				'set output FWD=0 then REV=1
		high rev
	endif	
	pwmduty=8/frequency*speed		'calc PWM module duty value
	pwmout 2,pwmperiod,pwmduty		'set PWM module period & duty
	return

disabledrive:
	pwmduty=0					'PWM module duty=0
	low fwd					'set outputs FWD=0 & REV=0 (all MOSFETs off)
	low rev
	pwmout 2,pwmperiod,pwmduty		'set PWM module period & duty
	return

	end









