;
;----------------------------------------------------------------
;
;	PICprobe - 2 to 5VDC logic probe based on a PIC10F20x micro
;
;	Any of the family of PIC10F20x will work.
;
;	Written by 	: 	Ross Purdy
;	Date 		:	9-12-2006
;	Version 	:	1.0
;
;	Designed with MPLAB IDE v7.50 & PICkit 2 as programmer
;
#include p10f202.inc
;
;	If you want the watchdog on swap the comment on the two lines.
;
	__config _WDT_OFF & _MCLRE_OFF
;;	__config _MCLRE_OFF
;
;	RAM defines
;
CNT0	EQU	0x10
;
FLAG	EQU 0x11
CHANGE	EQU	0		; Change on input seen
LATCH	EQU	1		; Latch mode enabled
BDOWN	EQU	2		; Button down for 2 seconds
BPRESS	EQU	3		; Button pressed
;
CNT1	EQU	0x12
CNT2	EQU	0x13
;
;	Port defines
;
ORANGE	EQU	GP1		; Define what the ports have on them
REDGRN	EQU	GP2
PROBE	EQU	GP3
BUTTON	EQU	GP0
;
;	General defines
;
TMRCNT	EQU	0x3d	; Reload for timer 0 for 50mS overflow rate
;
;	Reset vectors here with calibration data in W
;
	ORG		0x00
;
;	Comment out the next line if you require calibrated oscillator
;
	movlw	0x7e			; Go flat out !
	MOVWF	OSCCAL
	movlw	B'00001001'		; GP1 & GP2 output all other input
	tris	GPIO		
;
	movlw	B'11000111'		; PSA to timer 0 /256, no pullup with button pressed on power up
	btfss	GPIO,BUTTON		; Button pressed ?
	movlw	B'10000111'		; PSA to timer 0 /256 (pullup on Probe input)
;	
	option
	movlw	TMRCNT			; Set TMR0 count
	movwf	TMR0
;
	bsf		GPIO,ORANGE		; LEDS OFF to start
	bsf		GPIO,REDGRN
	movlw	.40
	movwf	CNT0			; Debounce for button 40*50mS=2 Seconds
	clrf	FLAG			; Clear all the working flags
;
;	MAIN LOOP
;
;	Make loop as small as possible to detect smallest pulses
;
main
;;	clrwdt					; Clear the watchdog (uncomment for watchdog !)
	btfsc	FLAG,BDOWN		; Button pressed for > 2 Seconds ?
	call	cngmode			; Yes. Change mode if button down
;
;	Check if TMR0 = 0 for timer expired
;
	movf	TMR0,W			; Read TMR0 to W (don't do any writes as that clears the PSA)
	btfsc	STATUS,Z		; Skip if not zero
	call	time			; Do timer routine
;
;	Check Probe input and move to REDGRN output
;	
	btfsc	GPIO,PROBE		; Skip if PROBE = 0
	goto	main1			; PROBE=1
;
;	Probe is LOW
;
	btfsc	GPIO,REDGRN		; Already on ?
	goto	main			; Nothing to do
	bsf		GPIO,REDGRN		; GREEN ON
	bsf		FLAG,CHANGE
	goto	main
;
;	Probe is HIGH
;
main1
	btfss	GPIO,REDGRN		; Already on ?
	goto	main			; Yes, nothing to do.
	bcf		GPIO,REDGRN		; RED ON
	bsf		FLAG,CHANGE
	goto	main
;
;----------------------------------------------------------	
;
;	Timer 0 has expired
;
time
	movlw	TMRCNT			; Get reload value
	movwf	TMR0			; Reload timer, clear prescaler
;
	btfsc	GPIO,BUTTON		; Button pressed ?
	goto	time1			; No button down
	bsf		FLAG,BPRESS		; Signal button pressed
	decfsz	CNT0,F			; Count debounce down
	retlw	0				; no extended timeout yet
;
;	Button down for 2 seconds now
;
	bsf		FLAG,BDOWN		; Signal to main loop that button down
	retlw	0				; Exit now.
;
;	No button pressed, check mode for Orange LED
;
time1
	movlw	.40
	movwf	CNT0			; Reset debounce counter
	btfsc	FLAG,LATCH
	goto	l_mode			; Latch mode
;
;	Pulse stretch mode
;
	bcf		FLAG,BPRESS		; Ignore button in this mode			
	btfsc	FLAG,CHANGE
	goto	time2			; Put orange on
	bsf		GPIO,ORANGE		; LED OFF
	retlw	0
time2
	bcf		FLAG,CHANGE		; Clear flag
	bcf		GPIO,ORANGE		; Orange ON	
	retlw	0
;
;	Latch pulse mode
;
l_mode
	btfss	FLAG,BPRESS		; Button pressed ?
	goto	l_mode1			; No, check for change
	bcf		FLAG,BPRESS		; Clear flag
	bsf		GPIO,ORANGE		; Unlatch LED now
	retlw	0
l_mode1
	btfss	FLAG,CHANGE		; Any change ?
	retlw	0				; No ,exit.
	bcf		FLAG,CHANGE		; Seen change, clear flag now
	bcf		GPIO,ORANGE		; Latch Orange LED ON
	retlw	0
;
;--------------------------------------------------------
;
;	Subroutine to change the mode.
;	If the button is pressed for > 2 seconds we blink
;	the Orange LED until the button is released.
;	When released we toggle the mode from LATCHED and
;	STRETCHED pulse.
;
cngmode
	clrf	CNT1
	clrf	CNT2
	movlw	.40
	movwf	CNT0
	bcf		FLAG,BDOWN		; Clear the flag
;
btn1
	btfsc	GPIO,BUTTON
	goto	btn2
	bsf		GPIO,ORANGE		; turn on LED
Dly
	clrwdt					; Clear the watchdog
	decfsz	CNT1,f			; Waste time.  
	goto	Dly				; Delay 768 instructions
	decfsz	CNT2,f
	goto	Dly				; (768+3) * 256 = 197376 instructions
;
	bcf		GPIO,ORANGE		; Turn off LED
Dly1
	clrwdt					; Clear the watchdog
	decfsz	CNT1,f			; same delay as above
	goto	Dly1
	decfsz	CNT2,f
	goto	Dly1
	goto	btn1
;
;	Button released
;
btn2
	btfsc	FLAG,LATCH
	goto	btn3
	bsf		FLAG,LATCH		; Go to LATCH mode
	retlw	0
btn3
	bcf		FLAG,LATCH		; Back to stretch mode
	retlw	0
;
	END
