; File OSCAR.ASM    B.HEALY  August 2007
; Assembler code for PIC16F84A microcontroller 
; NOUGHTS & CROSSES PROGRAM ( OSCAR)
; Uses 9 red LEDs, 9 green LEDs, 9 push buttons multiplexed, one Oscar first turn & 1 reset button
; Red, Green and button are multiplexed, 1 leg of each is connected together.
; CPU configuration
; (It's a 16F84A, RC oscillator,
; watchdog timer off, power-up timer on)
		processor 16f84A
		include	  <p16f84A.inc>
		__config  _RC_OSC & _WDT_OFF & _PWRTE_ON
; Red cathode, Green cathode, and one side of button are all connected together for
; each square, each connects as below. 
; Squares 1 - 8  are connected to port B, bit 0 - bit 7 
; pins 6,7,8,9,10,11,12,13  square 9 is connected to port A, bit 0, pin 17
; squares are active low
; anodes of all red LEDs are connected together and 
; are driven from port A, bit 1, pin 18, active high
; anodes of all green LEDs are connected together and
; are driven from port A, bit 2, pin 1, active high
; other terminal of all buttons feed back to Port A, bit 3, pin 2, active low 
; Oscars first turn button is connected to Port A, bit 4, pin 3, active low.
; Reset button resets PIC directly (connected to reset pin)
; Player is green,   Oscar is red
; first bit of variable = green
; third bit of variable = red
; 7th bit is activated on a win, and makes winning line flash.

;  	LAYOUT		G H J
;  				K L M
;  				N P Q
; Declare variables at 17 memory locations

G			equ	H'1C'	  		; G = address hex 1C square 1
H			equ	H'1D'	  		; H = address hex 1D square 2
J			equ	H'1E'     		; J = address hex 1E square 3
K			equ H'1F'	  		; K = address hex 1F square 4
L			equ H'20'	  		; L = address hex 20 square 5
M			equ H'21'     		; M = address hex 21 square 6
N			equ H'22'	  		; N = address hex 22 square 7
P			equ H'23'	  		; P = address hex 23 square 8	
Q			equ H'24'	  		; Q = address hex 24 square 9
R			equ H'25'	  		; R = address hex 25 used to flag key press.
S			equ H'26'	  		; S = address hex 26 used in "Think" subroutine 
T			equ H'27'	  		; T = address hex 27 used by DISPLAY routine
U			equ H'2A'			; U = address hex 2A used to flash winner
X			equ H'28'			; X = address hex 28 used for random number generator
Y			equ H'29'			; Y = address hex 29 used to flag key press for O.F.Turn
PORTA		equ H'05'
PORTB		equ H'06'
OPTION_REG 	equ H'81'     		; defines option reg address

			org	0	          		; start at address 0

; Set port B as output and initialize it. and set port A part input & output.
BEGIN		BSF		STATUS,5		; set bank 1
 			MOVLW	0x00      		; w = 00000000 binary
			TRIS	PORTB	  		; port B ctrl register Port B is output
 	   		MOVLW	0x18     		; 00011000 binary
	    	TRIS	PORTA           ; port A ctrl register Port A,
                     				; bits 0,1,2 are outputs,
	                           		; bit 3 and bit 4 are inputs.
	   		BCF		STATUS,5		; set bank 0 again
			MOVLW	0xFF
			MOVWF	PORTB
			BSF		PORTA,0
			CLRF	G				; clear all variables
			CLRF	H
			CLRF	J
			CLRF	K
			CLRF	L
			CLRF	M
			CLRF	N
			CLRF	P
			CLRF	Q
			CLRF   	R
			CLRF	X
			CLRF	Y
; Routine to generate random number 1-9, works by counting 1-9 in waiting time			
G0		INCF	X,1				;increment X
		MOVF	X,0				;move X into W
		XORLW	0x09			;is X = 9
		BTFSC	STATUS,2		; if it is not jump over next instruction
		CLRF	X 				;if it is reset it to zero
		

			MOVF	G,0				;this routine checks to see if computer
			ADDWF	H,0				;has 3 in a row.
			ADDWF	J,0				;If computer does, then game stops, and
			XORLW	0x0C			;winning line is displayed flashing
			BTFSC	STATUS,2
			GOTO	WIN1
			MOVF	K,0
			ADDWF	L,0 
			ADDWF	M,0
			XORLW	0x0C		
			BTFSC	STATUS,2
			GOTO 	WIN2
			MOVF	N,0
			ADDWF	P,0
			ADDWF	Q,0	
			XORLW	0x0C
			BTFSC	STATUS,2
			GOTO	WIN3
			MOVF	G,0
			ADDWF	K,0
			ADDWF	N,0
			XORLW	0x0C
			BTFSC	STATUS,2
			GOTO	WIN4
			MOVF	H,0
			ADDWF	L,0
			ADDWF	P,0
			XORLW	0x0C
			BTFSC	STATUS,2
			GOTO	WIN5
			MOVF	J,0
			ADDWF	M,0
			ADDWF	Q,0
			XORLW	0x0C		
			BTFSC	STATUS,2
			GOTO 	WIN6
			MOVF	G,0
			ADDWF	L,0
			ADDWF	Q,0	
			XORLW	0x0C
			BTFSC	STATUS,2
			GOTO	WIN7
			MOVF	N,0
			ADDWF	L,0
			ADDWF	J,0
			XORLW	0x0C
			BTFSC	STATUS,2
			GOTO	WIN8			;end of routine checking for computer win.
		
;		 This is the main interface part of the program.		
; It scans board continuosly, red, then green, then key-press
; If red should be lit, it displays it, If green should be lit, it displays it,
; only if no Red or Green does it then look at the keyboard.
; then moves to next square and scans again. After square 9 goes back to 1
; If a keypress is detected bit 0 of variable is set, bit 0 of R is also set
; R is a flag. In display routine if R is set then computer looks for a reply move.
; otherwise just keeps looping around lighting LEDs and checking buttons.   		
		
			MOVLW	0xFF			;this is for square 1 ( G )	
			MOVWF	PORTB			;clear PortB
			BSF		PORTA,0			;clear square 9 (previous square)
			BCF		PORTA,2			;clear red driver
			BCF		PORTA,1			;clear green driver
			BTFSS	G,2				;is square 1 red?
			GOTO	G1				;no, but maybe green?
			BSF		PORTA,1			;yes it is red so turn red driver on.
			BCF		PORTB,0			;turn square 1 on.
			GOTO	G3				;don't look at keyboard
G1			BTFSS	G,0				;is square 1 green
			GOTO	G2				;no
			BSF		PORTA,2			;yes it is green so turn green driver on.
			BCF		PORTB,0			;turn square 1
			GOTO 	G3				;to be displayed, do not look at keyboard.
G2			BCF		PORTB,0			;only if square is blank
			BTFSC	PORTA,3			;test for button press			
			GOTO	G3				;not pressed so display and check next square.
			BSF		G,0				;is pressed so store new value in variable G
			BSF		R,0				;R is a flag noting button has been pressed.
			BSF		Y,0				;makes oscars first turn  button inactive
G3			CALL	DISPLAY			;display routine

H0			BSF		PORTB,0			;this is for square 2 ( H )
			BTFSS	H,2
			GOTO	H1
			BSF		PORTA,1			;red
			BCF		PORTB,1			;square 2
			GOTO	H3
H1			BTFSS	H,0
			GOTO	H2
			BSF		PORTA,2			;green
			BCF		PORTB,1			;square 2
			GOTO 	H3
H2			BCF		PORTB,1
			BTFSC	PORTA,3			;test for button press			
			GOTO	H3
			BSF		H,0
			BSF		R,0
			BSF		Y,0
H3			CALL	DISPLAY			;display routine
        
J0			BSF		PORTB,1			;this is for square 3 ( J )
			BTFSS	J,2
			GOTO	J1
			BSF		PORTA,1			;red
			BCF		PORTB,2			;square 3
			GOTO	J3
J1			BTFSS	J,0
			GOTO	J2
			BSF		PORTA,2
			BCF		PORTB,2
			GOTO 	J3
J2			BCF		PORTB,2
			BTFSC	PORTA,3			;test for button press			
			GOTO	J3
			BSF		J,0
			BSF		R,0
			BSF		Y,0
J3			CALL	DISPLAY

K0			BSF		PORTB,2			;this is for square 4 ( K )
			BTFSS	K,2
			GOTO	K1
			BSF		PORTA,1			;red
			BCF		PORTB,3			;square 4
			GOTO	K3
K1			BTFSS	K,0
			GOTO	K2
			BSF		PORTA,2
			BCF		PORTB,3
			GOTO 	K3
K2			BCF		PORTB,3
			BTFSC	PORTA,3			;test for button press			
			GOTO	K3
			BSF		K,0
			BSF		R,0
			BSF		Y,0
K3			CALL	DISPLAY

L0			BSF		PORTB,3			;this is for square 5 ( L )
			BTFSS	L,2
			GOTO	L1
			BSF		PORTA,1			;red
			BCF		PORTB,4			;square 5
			GOTO	L3
L1			BTFSS	L,0
			GOTO	L2
			BSF		PORTA,2
			BCF		PORTB,4
			GOTO 	L3
L2			BCF		PORTB,4
			BTFSC	PORTA,3			;test for button press			
			GOTO	L3
			BSF		L,0
			BSF		R,0
			BSF		Y,0
L3			CALL	DISPLAY
        
M0			BSF		PORTB,4			;this is for square 6 ( M )
			BTFSS	M,2
			GOTO	M1
			BSF		PORTA,1			;red
			BCF		PORTB,5			;square 6
			GOTO	M3
M1			BTFSS	M,0
			GOTO	M2
			BSF		PORTA,2
			BCF		PORTB,5
			GOTO 	M3
M2			BCF		PORTB,5
			BTFSC	PORTA,3			;test for button press			
			GOTO	M3
			BSF		M,0
			BSF		R,0
			BSF		Y,0
M3			CALL	DISPLAY

N0			BSF		PORTB,5			;this is for square 7 ( N )
			BTFSS	N,2
			GOTO	N1
			BSF		PORTA,1			;red
			BCF		PORTB,6			;square 7
			GOTO	N3
N1			BTFSS	N,0
			GOTO	N2
			BSF		PORTA,2
			BCF		PORTB,6
			GOTO 	N3
N2			BCF		PORTB,6
			BTFSC	PORTA,3			;test for button press			
			GOTO	N3
			BSF		N,0
			BSF		R,0
			BSF		Y,0
N3			CALL	DISPLAY

P0			BSF		PORTB,6			;this is for square 8 ( P )
			BTFSS	P,2
			GOTO	P1
			BSF		PORTA,1			;red
			BCF		PORTB,7			;square 8
			GOTO	P3
P1			BTFSS	P,0
			GOTO	P2
			BSF		PORTA,2
			BCF		PORTB,7
			GOTO 	P3
P2			BCF		PORTB,7
			BTFSC	PORTA,3			;test for button press			
			GOTO	P3
			BSF		P,0
			BSF		R,0
			BSF		Y,0
P3			CALL	DISPLAY
		
Q0			BSF		PORTB,7			;this is for square 9 ( Q 0
			BTFSS	Q,2
			GOTO	Q1
			BSF		PORTA,1			;red
			BCF		PORTA,0			;square 9
			GOTO	Q3
Q1			BTFSS	Q,0
			GOTO	Q2
			BSF		PORTA,2
			BCF		PORTA,0
			GOTO 	Q3
Q2			BCF		PORTA,0
			BTFSC	PORTA,3			;test for button press			
			GOTO	Q3
			BSF		Q,0
			BSF		R,0				;R is flag for button press
			BSF		Y,0
Q3			CALL	DISPLAY
			
			BTFSC	Y,0
			GOTO	Q4
			BTFSC	PORTA,4			;Test for Oscar's first turn
			GOTO	Q4
			BSF		PORTA,0
			BCF		PORTA,2
			BCF		PORTA,1
			BSF		Y,0
			MOVF	X,0
			XORLW	0x01
			BTFSC	STATUS,2
			GOTO	GX
			MOVF	X,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	HX
			MOVF	X,0
			XORLW	0x03
			BTFSC	STATUS,2
			GOTO	JX
			MOVF	X,0
			XORLW	0x04
			BTFSC	STATUS,2
			GOTO	KX		
			MOVF	X,0
			XORLW	0x05
			BTFSC	STATUS,2
			GOTO	LX
			MOVF	X,0
			XORLW	0x06
			BTFSC	STATUS,2
			GOTO	MX
			MOVF	X,0
			XORLW	0x07
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	X,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	NX		
			MOVF	X,0
			XORLW	0x00
			BTFSC	STATUS,2
			GOTO	QX
Q4			CALL	DISPLAY
			GOTO	G0				;loop around again

								
DISPLAY		MOVLW	0x18 		; This is main routine to hold LED lit
			MOVWF	T			; for finite time. 
DISPLAY1	DECFSZ	T,1
			GOTO	DISPLAY1
			BCF		PORTA,1
			BCF		PORTA,2
			
			BTFSS	R,0			;thislooks at R to see if a key has been pressed
			RETURN				;if not just loop again. If yes then go below,

			CALL	DELAY

;       L O G I C  S T A G E  O N E ,    ** W I N   F O R   S U R E **
			BCF		R,0				; R flags key press
			MOVLW	0x00			; see if first square is blank
			XORWF	G,0
			BTFSS	STATUS,2
			GOTO	HD				; if not blank goto next square
			MOVF	H,0				; check to see if squares H and J are both red
			ADDWF	J,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	GX				; then exit this test and declare win		
			MOVF	L,0				; try next combo L + Q
			ADDWF	Q,0
			XORLW	0x08		
			BTFSC	STATUS,2
			GOTO 	GX
			MOVF	K,0				;try K + N
			ADDWF	N,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	GX				
		
HD			MOVLW	0x00
			XORWF	H,0
			BTFSS	STATUS,2
			GOTO	JD
			MOVF	L,0
			ADDWF	P,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	HX
			MOVF	G,0
			ADDWF	J,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	HX
		
JD			MOVLW	0x00
			XORWF	J,0
			BTFSS	STATUS,2
			GOTO	KD
			MOVF	G,0
			ADDWF	H,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	JX
			MOVF	N,0
			ADDWF	L,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	JX
			MOVF	M,0
			ADDWF	Q,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	JX

KD			MOVLW	0x00
			XORWF	K,0
			BTFSS	STATUS,2
			GOTO	LD
			MOVF	G,0
			ADDWF	N,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	KX
			MOVF	L,0
			ADDWF	M,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	KX
		
LD			MOVLW	0x00
			XORWF	L,0
			BTFSS	STATUS,2
			GOTO	MD
			MOVF	G,0
			ADDWF	Q,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	LX
			MOVF	H,0
			ADDWF	P,0
			XORLW	0x08		
			BTFSC	STATUS,2
			GOTO 	LX
			MOVF	N,0
			ADDWF	J,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	LX
			MOVF	K,0
			ADDWF	M,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	LX
				
MD			MOVLW	0x00
			XORWF	M,0
			BTFSS	STATUS,2
			GOTO	ND
			MOVF	K,0
			ADDWF	L,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	MX
			MOVF	J,0
			ADDWF	Q,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	MX
		
ND			MOVLW	0x00
			XORWF	N,0
			BTFSS	STATUS,2
			GOTO	PD
			MOVF	G,0
			ADDWF	K,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	J,0
			ADDWF	L,0
			XORLW	0x08		
			BTFSC	STATUS,2
			GOTO 	NX
			MOVF	P,0
			ADDWF	Q,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	NX
	 
PD			MOVLW	0x00
			XORWF	P,0
			BTFSS	STATUS,2
			GOTO	QD
			MOVF	H,0
			ADDWF	L,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	PX
			MOVF	N,0
			ADDWF	Q,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	PX	

QD			MOVLW	0x00
			XORWF	Q,0
			BTFSS	STATUS,2
			GOTO	GA	
			MOVF	N,0
			ADDWF	P,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	QX
			MOVF	G,0
			ADDWF	L,0
			XORLW	0x08		
			BTFSC	STATUS,2
			GOTO 	QX
			MOVF	J,0
			ADDWF	M,0
			XORLW	0x08
			BTFSC	STATUS,2
			GOTO	QX

			CALL	DELAY

;       	L O G I C    S T A G E    T W O ,       ** P R E V E N T   W I N **			
GA			BCF		R,0
			MOVLW	0x00
			XORWF	G,0
			BTFSS	STATUS,2
			GOTO	HA
			MOVF	H,0
			ADDWF	J,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	GX
			MOVF	L,0
			ADDWF	Q,0
			XORLW	0x02		
			BTFSC	STATUS,2
			GOTO 	GX
			MOVF	K,0
			ADDWF	N,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	GX
		
HA			MOVLW	0x00
			XORWF	H,0
			BTFSS	STATUS,2
			GOTO	JA
			MOVF	L,0
			ADDWF	P,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	HX
			MOVF	G,0
			ADDWF	J,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	HX
		
JA			MOVLW	0x00
			XORWF	J,0
			BTFSS	STATUS,2
			GOTO	KA
			MOVF	G,0
			ADDWF	H,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	JX
			MOVF	N,0
			ADDWF	L,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	JX
			MOVF	M,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	JX

KA			MOVLW	0x00
			XORWF	K,0
			BTFSS	STATUS,2
			GOTO	LA
			MOVF	G,0
			ADDWF	N,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	KX
			MOVF	L,0
			ADDWF	M,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	KX
		
LA			MOVLW	0x00
			XORWF	L,0
			BTFSS	STATUS,2
			GOTO	MA
			MOVF	G,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	LX
			MOVF	H,0
			ADDWF	P,0
			XORLW	0x02		
			BTFSC	STATUS,2
			GOTO 	LX
			MOVF	N,0
			ADDWF	J,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	LX
			MOVF	K,0
			ADDWF	M,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	LX
				
MA			MOVLW	0x00
			XORWF	M,0
			BTFSS	STATUS,2
			GOTO	NA
			MOVF	K,0
			ADDWF	L,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	MX
			MOVF	J,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	MX
		
NA			MOVLW	0x00
			XORWF	N,0
			BTFSS	STATUS,2
			GOTO	PA
			MOVF	G,0
			ADDWF	K,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	J,0
			ADDWF	L,0
			XORLW	0x02		
			BTFSC	STATUS,2
			GOTO 	NX
			MOVF	P,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
	 
PA			MOVLW	0x00
			XORWF	P,0
			BTFSS	STATUS,2
			GOTO	QA
			MOVF	H,0
			ADDWF	L,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	PX
			MOVF	N,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	PX	
		
QA			MOVLW	0x00
			XORWF	Q,0
			BTFSS	STATUS,2
			GOTO	GTAC
			MOVF	N,0
			ADDWF	P,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	QX
			MOVF	G,0
			ADDWF	L,0
			XORLW	0x02		
			BTFSC	STATUS,2
			GOTO 	QX
			MOVF	J,0
			ADDWF	M,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	QX
	
			CALL	DELAY

			MOVF	X,0
			ANDLW	0X03
			MOVWF	X

;      	 	L O G I C   S T A G E   T H R E E ,   ** T A C T I C S  **
GTAC		MOVLW	0x00
			XORWF	G,0
			BTFSS	STATUS,2
			GOTO	HTAC
			MOVF	H,0
			ADDWF	M,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	GX
			MOVF	H,0
			ADDWF	N,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	GX
			MOVF	J,0
			ADDWF	K,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	GX
			MOVF	N,0
			ADDWF	L,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	GX
			MOVF	X,0
			XORLW	0X00
			BTFSS	STATUS,2
			GOTO	HTAC			
			MOVF	L,0
			XORLW	0x01
			BTFSC	STATUS,2
			GOTO	GX

HTAC		MOVLW	0x00
			XORWF	H,0
			BTFSS	STATUS,2
			GOTO	JTAC
			MOVF	N,0
			ADDWF	J,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	HX
			MOVF	G,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	HX

JTAC		MOVLW	0x00
			XORWF	J,0
			BTFSS	STATUS,2
			GOTO	KTAC
			MOVF	H,0
			ADDWF	K,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	JX	
			MOVF	M,0
			ADDWF	G,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	JX	
			MOVF	L,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	JX
			MOVF	X,0
			XORLW	0X01
			BTFSS	STATUS,2
			GOTO	KTAC
			MOVF	L,0
			XORLW	0X01
			BTFSC	STATUS,2
			GOTO	JX	

KTAC		MOVLW	0x00
			XORWF	K,0
			BTFSS	STATUS,2
			GOTO	NTAC
			MOVF	H,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO 	KX
		
NTAC		MOVLW	0x00
			XORWF	N,0
			BTFSS	STATUS,2
			GOTO	QTAC
			MOVF	K,0
			ADDWF	M,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	K,0
			ADDWF	P,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	K,0
			ADDWF	Q,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	L,0
			ADDWF	G,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	P,0
			ADDWF	G,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	P,0
			ADDWF	M,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	NX
			MOVF	X,0
			XORLW	0X02
			BTFSS	STATUS,2
			GOTO	QTAC
			MOVF	L,0
			XORLW	0X01
			BTFSC	STATUS,2
			GOTO	NX
			
			
			
			

QTAC		MOVLW	0x00
			XORWF	Q,0
			BTFSS	STATUS,2
			GOTO	LTAC
			MOVF	L,0
			ADDWF	J,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	QX
			MOVF	M,0
			ADDWF	N,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	QX
			MOVF	J,0
			ADDWF	P,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	QX
			MOVF	H,0
			ADDWF	P,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	QX
			MOVF	P,0
			ADDWF	J,0
			XORLW	0x02
			BTFSC	STATUS,2
			GOTO	QX
			MOVF	X,0
			XORLW	0X03
			BTFSS	STATUS,2
			GOTO	LTAC
			MOVF	L,0
			XORLW	0x01
			BTFSC	STATUS,2
			GOTO	QX

LTAC		MOVLW	0x00
		 	XORWF	L,0
			BTFSS	STATUS,2
			GOTO	RAN
			GOTO	LX
	
			CALL	DELAY

;       	L O G I C   S T A G E   F O U R    ** R A N D O M **  
	
RAN			MOVLW	0x00
			XORWF	G,0
			BTFSC	STATUS,2
			GOTO	GX
			MOVLW	0x00
			XORWF	H,0
			BTFSC	STATUS,2
			GOTO	HX
			MOVLW	0x00
			XORWF	J,0
			BTFSC	STATUS,2
			GOTO	JX
			MOVLW	0x00
			XORWF	K,0
			BTFSC	STATUS,2
			GOTO	KX
			MOVLW	0x00
			XORWF	L,0
			BTFSC	STATUS,2
			GOTO	LX
			MOVLW	0x00
			XORWF	M,0
			BTFSC	STATUS,2
			GOTO	MX
			MOVLW	0x00
			XORWF	N,0
			BTFSC	STATUS,2
			GOTO	NX
			MOVLW	0x00
			XORWF	P,0
			BTFSC	STATUS,2
			GOTO	PX
			MOVLW	0x00
			XORWF	Q,0
			BTFSC	STATUS,2
			GOTO	QX
			GOTO    G0
				
GX			BSF		G,2
			GOTO	G0
HX			BSF		H,2
			GOTO	G0	
JX			BSF		J,2
			GOTO	G0
KX			BSF		K,2
			GOTO	G0
LX			BSF		L,2
			GOTO	G0
MX			BSF		M,2
			GOTO	G0
NX			BSF		N,2
			GOTO	G0
PX			BSF		P,2
			GOTO	G0
QX			BSF		Q,2
			GOTO	G0										
; This routine wastes time to appear to be thinking, it keeps LEDs cycling but
; does not look at keys or do any calculating.
; It is also the routine to display winning line flashing.
; 'Think' is similar to 'Display' but does no actions'
; variable U is incremented each loop, by testing the 5th bit each loop
; 50% of the time it will be a 1, and 50% of the time it will be zero
; this is used to flash the winning Red LEDs
THINK	INCF	U,1				;increment U
		BCF		R,0				;reset R the flag
		MOVLW	0xFF
		MOVWF	PORTB
		BSF		PORTA,0			;clear ports
		BCF		PORTA,2			;clear ports
		BCF		PORTA,1			;clear ports
		BTFSS	G,2				;check the flag for RED
		GOTO	GD1				;not set so jump
	BTFSC	G,7					;check for winning line, No jump next instruction
	BTFSS	U,5					;Is winning, check Red, on or off, jump if off
		BSF		PORTA,1			;turn red on
		BCF		PORTB,0			;square 1
		GOTO	GD2				;don't check green (it was red)
GD1		BTFSS	G,0				;check the flag for GREEN
		GOTO	GD2				;not Green so jump
		BSF		PORTA,2			;turn Green on
		BCF		PORTB,0			;square 1
GD2 	CALL	DISPLAY			;normal display
		
		BSF		PORTB,0
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	H,2
		GOTO	HD1
	BTFSC	H,7
	BTFSS	U,5
		BSF		PORTA,1			;red
		BCF		PORTB,1			;square 2
		GOTO	HD2
HD1		BTFSS	H,0
		GOTO	HD2
		BSF		PORTA,2			;green
		BCF		PORTB,1			;square 2
HD2		CALL 	DISPLAY
	        
		BSF		PORTB,1
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	J,2
		GOTO	JD1
	BTFSC	J,7
	BTFSS	U,5	
		BSF		PORTA,1			;red
		BCF		PORTB,2			;square 3
		GOTO	JD2
JD1		BTFSS	J,0
		GOTO	JD2
		BSF		PORTA,2
		BCF		PORTB,2
JD2		CALL	DISPLAY
		
		BSF		PORTB,2
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	K,2
		GOTO	KD1
	BTFSC	K,7
	BTFSS	U,5	
		BSF		PORTA,1			;red
		BCF		PORTB,3			;square 4
		GOTO	KD2
KD1		BTFSS	K,0
		GOTO	KD2
		BSF		PORTA,2
		BCF		PORTB,3
KD2		CALL 	DISPLAY

		BSF		PORTB,3
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	L,2
		GOTO	LD1
	BTFSC	L,7
	BTFSS	U,5	
		BSF		PORTA,1			;red
		BCF		PORTB,4			;square 5
		GOTO	LD2
LD1		BTFSS	L,0
		GOTO	LD2
		BSF		PORTA,2
		BCF		PORTB,4
LD2		CALL	DISPLAY
        
		BSF		PORTB,4
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	M,2
		GOTO	MD1
	BTFSC	M,7
	BTFSS	U,5	
		BSF		PORTA,1			;red
		BCF		PORTB,5			;square 6
		GOTO	MD2
MD1		BTFSS	M,0
		GOTO	MD2
		BSF		PORTA,2
		BCF		PORTB,5
MD2		CALL	DISPLAY
		
		BSF		PORTB,5
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	N,2
		GOTO	ND1
 	BTFSC	N,7
 	BTFSS	U,5	
 		BSF		PORTA,1			;red
		BCF		PORTB,6			;square 7
		GOTO	ND2
ND1		BTFSS	N,0
		GOTO	ND2
		BSF		PORTA,2
		BCF		PORTB,6
ND2		CALL	DISPLAY

		BSF		PORTB,6
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	P,2
		GOTO	PD1
	BTFSC	P,7
	BTFSS	U,5	
		BSF		PORTA,1			;red
		BCF		PORTB,7			;square 8
		GOTO	PD2
PD1		BTFSS	P,0
		GOTO	PD2
		BSF		PORTA,2
		BCF		PORTB,7
PD2		CALL	DISPLAY
		
		BSF		PORTB,7
		BCF		PORTA,2
		BCF		PORTA,1
		BTFSS	Q,2
		GOTO	QD1
	BTFSC	Q,7
	BTFSS	U,5	
		BSF		PORTA,1			;red
		BCF		PORTA,0			;square 9
		GOTO	QD2
QD1		BTFSS	Q,0
		GOTO	QD2
		BSF		PORTA,2
		BCF		PORTA,0
QD2		CALL	DISPLAY
		RETURN

WIN1	BSF		G,7
		BSF		H,7
		BSF		J,7
		CALL	THINK
		GOTO	WIN1			;keep looping forever.
								;Reset key is only way out
WIN2	BSF		K,7
		BSF		L,7
		BSF		M,7
		CALL	THINK
		GOTO	WIN2
		
WIN3	BSF		N,7
		BSF		P,7
		BSF		Q,7
		CALL	THINK	
		GOTO	WIN3
		
WIN4	BSF		G,7
		BSF		K,7
		BSF		N,7
		CALL	THINK
		GOTO	WIN4
		
WIN5	BSF		H,7
		BSF		L,7
		BSF		P,7
		CALL	THINK
		GOTO	WIN5
		
WIN6	BSF		J,7
		BSF		M,7
		BSF		Q,7
		CALL	THINK	
		GOTO	WIN6		
			
WIN7	BSF		G,7
		BSF		L,7
		BSF		Q,7
		CALL	THINK
		GOTO	WIN7
		
WIN8	BSF		N,7
		BSF		L,7
		BSF		J,7
		CALL	THINK	
		GOTO	WIN8							


DELAY		MOVLW	0xFF 			;this little subroutine introduces
			MOVWF	S				;a delay of approximately 1 - 2
THINK1		CALL 	THINK			;seconds before computer makes
			DECFSZ	S,1				;a move.
			GOTO	THINK1			;it calls big subroutine called THINK
			RETURN
			end	

