
; Infra red rolling code receiver

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_ON & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations
; Transmitter 1
EEPROM0		equ	H'00'	; storage of seed 32-bit ms
EEPROM1		equ	H'01'	; storage of seed 32-bit
EEPROM2		equ	H'02'	; storage of seed 32-bit
EEPROM3		equ	H'03'	; storage of seed 32-bit ls

EEPROM4		equ	H'04'	; storage of multiplier 24-bit ms
EEPROM5		equ	H'05'	; storage of multiplier 24-bit
EEPROM6		equ	H'06'	; storage of multiplier 24-bit ls

EEPROM7		equ	H'07'	; storage of incrementer 
EEPROM8		equ	H'08'	; byte 5 of random code
EEPROM9		equ	H'09'	; byte 6 of random code
EEPROM10	equ	H'0A'	; scramble data code

; Transmitter 2
EEPROM11	equ	H'0B'	; storage of seed 32-bit ms
EEPROM12	equ	H'0C'	; storage of seed 32-bit
EEPROM13	equ	H'0D'	; storage of seed 32-bit
EEPROM14	equ	H'0E'	; storage of seed 32-bit ls

EEPROM15	equ	H'0F'	; storage of multiplier 24-bit ms
EEPROM16	equ	H'10'	; storage of multiplier 24-bit
EEPROM17	equ	H'11'	; storage of multiplier 24-bit ls

EEPROM18	equ	H'12'	; storage of incrementer 
EEPROM19	equ	H'13'	; byte 5 of random code
EEPROM20	equ	H'14'	; byte 6 of random code
EEPROM21	equ	H'15'	; scramble data code

; Transmitter 3
EEPROM22	equ	H'16'	; storage of seed 32-bit ms
EEPROM23	equ	H'17'	; storage of seed 32-bit
EEPROM24	equ	H'18'	; storage of seed 32-bit
EEPROM25	equ	H'19'	; storage of seed 32-bit ls

EEPROM26	equ	H'1A'	; storage of multiplier 24-bit ms
EEPROM27	equ	H'1B'	; storage of multiplier 24-bit
EEPROM28	equ	H'1C'	; storage of multiplier 24-bit ls

EEPROM29	equ	H'1D'	; storage of incrementer 
EEPROM30	equ	H'1E'	; byte 5 of random code
EEPROM31	equ	H'1F'	; byte 6 of random code
EEPROM32	equ	H'20'	; scramble data code

; Transmitter 4
;EEPROM 33 (H'21' to H'2B') 
; Transmitter 5
;EEPROM 44 (H'2C' to H'36')
; Transmitter 6
;EEPROM 55 (H'37' to H'41') 
; Transmitter 7
;EEPROM 66 (H'42' to H'4C')
; Transmitter 8
;EEPROM 77 (H'4D' to H'57') 
; Transmitter 9
;EEPROM 88 (H'58' to H'62')
; Transmitter 10
;EEPROM 99 (H'63' to H'6D') 
; Transmitter 11
;EEPROM 110 (H'6E' to H'78')
; Transmitter 12
;EEPROM 121 (H'79' to H'83')
; Transmitter 13
;EEPROM 132 (H'84' to H'8E')
; Transmitter 14
;EEPROM 143 (H'8F' to H'99') 
; Transmitter 15
;EEPROM 154 (H'9A' to H'A4')
; Transmitter 16
;EEPROM 165 (H'A5' to H'AF')

EEPROM176 	equ	H'B0'	; armed status (armed/disarmed)
EEPROM177	equ	H'B1'	; Striker1 period
EEPROM178	equ	H'B2'	; Striker2 period
EEPROM179	equ	H'B3'	; Input1 Delay
EEPROM180	equ	H'B4'	; Input2 Delay
EEPROM181	equ	H'B5'	; Alarm Period  		
EEPROM182	equ	H'B6'	; synchronisation flag storage 9-16
EEPROM183   equ	H'B7'	; synchronisation flag storage 0-8

; Bank 0 RAM

; Math
BARGB0		equ	H'20'	; random number generator
BARGB1		equ	H'21'	; random number gen
BARGB2		equ	H'22'	; random number gen
AARGB0		equ	H'23'	; random number gen
AARGB1		equ	H'24'	; random number gen
AARGB2		equ	H'25'	; random number gen
AARGB3		equ	H'26'	; random number gen
AARGB4		equ	H'27'	; random number gen
AARGB5		equ	H'28'	; random number gen
AARGB6		equ	H'29'	; random number gen

TEMPB0		equ	H'2A'	; random gen temp files
TEMPB1		equ	H'2B'	; random gen temp files
TEMPB2		equ	H'2C'	; random gen temp files
TEMPB3		equ	H'2D'	; random gen temp files
LOOPCOUNT	equ	H'2E'	; loop counter in random gen

; Seed
RANDB0		equ	H'2F'	; random number seed ms
RANDB1		equ	H'30'	; random number seed
RANDB2		equ	H'31'	; random number seed
RANDB3		equ	H'32'	; random number seed ls
RANDB4		equ	H'33'	; random number last byte
RANDB5		equ	H'34'	; random number last byte

; Multiplier
MULT0		equ	H'35'	; multiplier ms
MULT1		equ	H'36'	; multiplier ms
MULT2		equ	H'37'	; multiplier ms

; Increment
INCREMENT	equ	H'38'	; increment value

; Counters

VALUE		equ	H'3A'	; Value of bit for sending data
CYCLE_COUNT	equ	H'3B'	; 38kHz cycles per data
IDENTIFIER	equ H'3C'	; S1/S2 transmit identifier
VALUE_1		equ	H'3D'	; delay counter
VALUE_2		equ	H'3E'	; delay counter	
PRIME_CONT	equ	H'3F'	; prime number counter
MULT_CYC	equ	H'40'	; multiplier cycle counter
SCRAMBLE	equ	H'41'	; data code scramble

; Other
TEMPX		equ	H'42'	; temporary register
TRIMPOT_0	equ	H'43'	; trimpot 0 value
TRIMPOT_1 	equ	H'44'	; trimpot 1 value
COUNTER_DIV	equ	H'45'	; counter divider reducing interrupt at 1024us to 262ms
FLAG		equ	H'46'	; interrupt flag

; receive bytes
RECEIVE0	equ	H'47'	; receive byte
RECEIVE1	equ	H'48'	; receive byte
RECEIVE2	equ	H'49'	; receive byte
RECEIVE3	equ	H'4A'	; receive byte
RECEIVE4	equ	H'4B'	; receive byte
RECEIVE5	equ	H'4C'	; receive byte
RECEIVE6	equ	H'4D'	; receive byte
RECEIVE7	equ	H'4E'	; receive byte
RECEIVE8	equ	H'4F'	; receive byte
RECEIVE9	equ	H'50'	; receive byte
RECEIVE10	equ	H'51'	; receive byte

REC_EIVE0	equ	H'52'	; receive byte unscrambled
REC_EIVE1	equ	H'53'	; receive byte 		"
REC_EIVE2	equ	H'54'	; receive byte      "
REC_EIVE3	equ	H'55'	; receive byte		"
REC_EIVE4	equ	H'56'	; receive byte		"
REC_EIVE5	equ	H'57'	; receive byte unscrambled

COUNT_BITS	equ	H'58'	; bit counter for receive bytes
CNT_BIT_STO	equ	H'59'	; bit counter for receive bytes
STORE1		equ	H'5A'	; delay counter
STORE2		equ	H'5B'	; delay counter
IDENTITY	equ	H'5C'	; identity address
TIMER1H_VAL equ	H'5D'	; timer 1 preset ms byte
TIMER1L_VAL equ	H'5E'	; timer 1 preset ls byte
TIMER1H_WK	equ	H'5F'	; timer 1 working value
TIMER1L_WK	equ	H'60'	; timer 1 working value	
TIMER1H_4	equ	H'61'	; timer 1 1/4 value ms byte
TIMER1L_4	equ	H'62'	; timer 1 1/4 value ls byte
SCRAMBLE1	equ	H'63'	; data code scramble working register
STORE3		equ	H'64'	; timer counter
REPEAT		equ	H'65'	; repeat recalculation
STO_RANDB3	equ	H'66'	; stored vale from previous random calculation	
ALTERNATE	equ	H'67'	; A/D alternate counter
TEMPY		equ	H'68'	; temporary register	
SYNC_SET	equ	H'69'	; flag for synchronisation 0 = first data block, 1 = second data block
STORE4		equ	H'6A'	; extra delay storage
PORTB_STORE	equ	H'6B'	; store current PORTB value
PORTB_FLG	equ	H'6C'	; portB (RB5 and RB6)change flag
PORTB_TEMP	equ	H'6D'	; temporary portB storage
TOGGLE_2	equ	H'6E'	; toggle flag for strike 2
ARM			equ H'6F'	; armed register

; All Banks RAM

W_TMP	  	   equ H'70'; storage of w before interrupt
STATUS_TMP	   equ H'71'; status storage before interrupt
PCLATH_STO	   equ H'72'; PCLATH store in interrupt
			
; Timers
STRIKE1_PERIOD equ H'73'; striker 1 period counter
STRIKE2_PERIOD equ H'74'; striker 2 period counter
INPUT1_DELAY   equ H'75'; input1 delay timer
INPUT2_DELAY   equ H'76'; input2 delay timer
ALARM_PERIOD   equ H'77'; alarm period counter
ALARM_SET	   equ H'78'; alarm set flag
ENTRY_TIMER	   equ H'79'; entry timer
PORTA_FLSH	   equ H'7A'; LED flash flags
FLSH_COUNT	   equ H'7B'; flash rate

; working registers				
PORTB_STORE1   equ H'7C'; portB storage temporary
SYNCHRON_FLAG  equ H'7D'; synchronise flag
ALL_COUNT	   equ H'7E'; ID counter to lockout all 16 IDs					
			 				
; preprogram EEPROM DATA 
	
	ORG     H'2100'		; start at 0 for EEPROM
	
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID1
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID2
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID3
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID4
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID5
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID6
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID7
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID8
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID9
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID10
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID11
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID12
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID13
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID14
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID15
	DE	H'72', H'2D', H'9B', H'75', H'00', H'A1', H'8E', H'1D', H'CD', H'17', H'00'; ID16

	DE	H'00'; disarmed
	DE 	D'20', D'20', D'76', D'76', D'128' ; Strike1,2 5s, Inputs1/2 delay 20s, Alarm 60s			
	DE	D'00', D'00' ; EEPROM182,183 for synchronisation flags all clear (all transmitters are locked out)
					 ; bit 0 set in 183 is ID1, bit 7 is ID8, bit 0 in 182 is ID9, bit 7 is ID16

; start at memory 0

	org	0
	goto	SETUP
	org	4
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	movf	PCLATH,w	; keep PCLATH
	movwf	PCLATH_STO	; store PC lath
	bsf		PCLATH,3	; page 1
	goto	INTERRUPT	; interrupt continues at page 1 address
	

; lookup table to find transmitter identity EEADR address
IDENTITY_FIND
	addwf	PCL,f		; add value to program counter
	retlw	H'00'		; transmitter 1 EEPROM start address
	retlw	H'0B'		; transmitter 2 EEPROM start address  
	retlw	H'16'
	retlw	H'21'
	retlw	H'2C'
	retlw	H'37'
	retlw	H'42'
	retlw	H'4D'
	retlw	H'58'		; transmitter 8
	retlw	H'63'
	retlw	H'6E'
	retlw	H'79'
	retlw	H'84'
	retlw	H'8F'
	retlw	H'9A'
	retlw	H'A5'		; transmitter 16 EEPROM start address 

; **********************************************************************************************

SETUP

	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	bsf		STATUS,RP0	; select memory bank 1
	bsf		PIE1,TMR1IE	; enable timer 1 interrupt

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11111000'	; port B outputs/ inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'11100011'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled TMR0/256)
	movwf	OPTION_REG

; analog inputs, A/D

	movlw	B'00000011'	; AN0 to AN1 are analog inputs
	movwf	ANSEL
	movlw	B'00000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	clrf	PORTB		; port B outputs low
	clrf	PORTA		; port A output low
	movlw	B'01000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'01101000'	; for 4MHz
	movwf	OSCCON		; osc
	bcf		STATUS,RP0	; select memory bank 0
	movlw	H'FB'		; preload timer 1
	movwf	TIMER1H_VAL
	movwf	TMR1H
	movlw	H'FF'
	movwf	TIMER1L_VAL
	movwf	TMR1L
	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on
	
; initial conditions

	clrf	ALTERNATE	; ch1/ch2 alternate reading
	clrf	SYNC_SET	; synchronisation set flag for first or second data
	clrf	TOGGLE_2	; strike 2 toggle flag cleared

; timer settings cleared

	clrf	STRIKE1_PERIOD ; striker 1 period counter
	clrf	STRIKE2_PERIOD ; striker 2 period counter
	clrf	INPUT1_DELAY   ; input1 delay timer
	clrf	INPUT2_DELAY   ; input2 delay timer
	clrf	ALARM_PERIOD   ; alarm period counter	
	clrf	ALARM_SET	   ; alarm set flag
	clrf	ENTRY_TIMER	   ; entry timer	
	clrf	PORTA_FLSH	   ; LED flash flags
	clrf	FLSH_COUNT	   ; flash rate

	call	DELAYms		   ; time to settle	

; Lockout procedure selected with S1 pressed at powerup
; Check for S1 closed
	btfsc	PORTB,7			; check S1 if open bypass lockout
	goto	SWITCH_ONE_OPEN

; load timeout counter for all ID lockout 
	movlw	D'04'
	movwf	ALL_COUNT
	
; identity bits set at 0 to 15 with IDENTITY bits 0,1,2,3
	movlw	B'00001111'	; set high first
	movwf	IDENTITY	; 1 of 16 transmitters
	btfsc	PORTB,3
	bcf		IDENTITY,0	; adjust bits for address
	btfsc	PORTA,6
	bcf		IDENTITY,1	; adjust bits for address
	btfsc	PORTA,5
	bcf		IDENTITY,2	; adjust bits for address
	btfsc	PORTA,7
	bcf		IDENTITY,3	; adjust bits for address

;  clear identifier 0 to 7 in EEPROM183

	movlw	H'FF'			; all 1's
	movwf	SYNCHRON_FLAG	; set ready to clear a bit
	movf	IDENTITY,w
	btfsc	STATUS,Z		; when 0 clear bit 0 in EEPROM183
	bcf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'01'			; when 1 clear bit 1 in EEPROM183
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'02'			; when 2 clear bit 2 in EEPROM183
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'03'			; when 3 clear bit 3 in EEPROM183
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'04'			; when 4 clear bit 4 in EEPROM183
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'05'			; when 5 clear bit 5 in EEPROM183
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'06'			; when 6 clear bit 6 in EEPROM183
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'07'			; when 7 clear bit 7 in EEPROM183
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,7	

; get current flags
	movlw	EEPROM183		; 0-8 flags
	call	EEREAD1			; value in w
	andwf	SYNCHRON_FLAG,w	; exclude new flag
	call 	EEWRITE1		; write values

;  clear identifier 8 to 16 in EEPROM182
	movlw	H'FF'
	movwf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	xorlw	D'08'			; when 8 clear bit 0 in EEPROM182
	btfsc	STATUS,Z		; 
	bcf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'09'			; when 9 clear bit 1 in EEPROM182
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'10'			; when 10 clear bit 2 in EEPROM182
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'11'			; when 11 clear bit 3 in EEPROM182
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'12'			; when 12 clear bit 4 in EEPROM182
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'13'			; when 13 clear bit 5 in EEPROM182
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'14'			; when 14 clear bit 6 in EEPROM182
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'15'			; when 15 clear bit 7 in EEPROM182
	btfsc	STATUS,Z
	bcf		SYNCHRON_FLAG,7	

; get current flags
	movlw	EEPROM182		; 9-16 flags
	call	EEREAD1			; value in w
	andwf	SYNCHRON_FLAG,w	; exclude new flag
	call 	EEWRITE1		; write values

; Flash power LED to indicate locked out ID.
REFLASH
	incf	IDENTITY,w		; 1-16 ID number
	movwf	SYNCHRON_FLAG	; use register to work with to flash LED for ID number
; new flash
FLASH_ID	
	bcf		PORTA,3			; ack LED off (power LED)
	movlw 	D'20'
	movwf	STORE3
	
MORE_DELAYA
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYA	

	bsf		PORTA,3			; ack LED on (power LED)
	movlw 	D'20'
	movwf	STORE3
MORE_DELAYB
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYB	
	
	decfsz	SYNCHRON_FLAG,f	; decrease til zero
	goto	FLASH_ID

; check for S1 open
	btfsc	PORTB,7			; check S1 if open start normal program
	goto	SWITCH_ONE_DELAY

; decrease counter
	decfsz	ALL_COUNT,f		; decrease til zero
	goto	SHOW_ID

; zero so clear all IDs

	movlw	EEPROM183		; 0-8 flags
	call	EEREAD1			; sets EEADR
	clrw					; clear all flags	
	call 	EEWRITE1		; write values
	movlw	EEPROM182		; 9-16 flags
	call	EEREAD1			; SETS EEADR
	clrw					; clear all flags
	call 	EEWRITE1		; write values

; power LED on
	bsf		PORTA,3
LOOP_TIL_OPEN
	btfss	PORTB,7			; check S1 if open start normal program
	goto	LOOP_TIL_OPEN
	goto	SWITCH_ONE_DELAY

SHOW_ID
	bcf		PORTA,3			; ack LED off (power LED)
	movlw 	D'200'			; extra delay
	movwf	STORE3
	
MORE_DELAYC
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYC	
	goto	REFLASH			; keep flashing

SWITCH_ONE_DELAY
	bcf		PORTA,3			; ack LED off (power LED)
	movlw 	D'100'			; extra delay
	movwf	STORE3

MORE_DELAYD
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAYD
	
; arm output low or high
SWITCH_ONE_OPEN	
	bsf		PORTA,3		; power LED on
	movlw	EEPROM176	; armed EEPROM storage
	call	EEREAD1		; get value
	movwf	ARM			; store
	xorlw	D'00'		; if 0 then disarmed
	btfss	STATUS,Z
	goto	ARMED_SET
	btfss	PORTB,3		; if low (link in) set RB2 high
	bsf		PORTB,2		; set 
;	bcf		PORTA,4		; armed LED off (already off)
	goto	DELAY_START
ARMED_SET
	btfsc	PORTB,3		; if low (link in) set RB2 low
	bsf		PORTB,2		; set 
	bsf		PORTA_FLSH,4; PORTA,4 flashed; armed LED on	

; delay start
DELAY_START	
	call	DELAYms

; get portB values
	movf	PORTB,w		; read portB
	andlw	B'01100000'	; only RB5 & RB6
	movwf	PORTB_STORE	; get PORTB value
	clrf	PORTB_FLG	; clear portB (RB5 and RB6) change flag

	bcf		PIR1,TMR1IF	; clear timer 1 overflow
	bcf		INTCON,RBIF	; port change interrupt

; allow interrupts
ALL_INTERRUPTS
	bsf		INTCON,PEIE	; peripheral interrupt enable
	bsf		INTCON,RBIE	; port change RB4-RB7 interrupt enable

; check inputs
CHECK_INPUTS
	bsf		INTCON,GIE	; set global interrupt (enable for timer 1, and port B change)
	bsf		T1CON,0		; make sure timer1 is running to count and check for overrange

; bypass inputs check if starting the second synchronisation block (for synchronisation
; sends data in two blocks as indicated by SYNC_SET (zero is block 1 not zero is block 2)

	movf	SYNC_SET,w	; if zero data block 1
	btfss	STATUS,Z
	goto	IR_IN

; inputs1 or 2 changed?
	bsf		PORTA_FLSH,3; momentarily flashing. Power LED flashing
	btfsc	PORTB_FLG,5	; check input 1
	goto	INPUT_1
	btfsc	PORTB_FLG,6	; check input 2
	goto	INPUT_2

; check sync switch
	btfsc	PORTB,7		; when closed check A/D values for strike, input delay and alarm periods 
	goto	IR_IN
	call	DELAYms
	call	DELAYms
	call	DELAYms
	btfsc	PORTB,7		; when closed check A/D values for strike, input delay and alarm periods 
	goto	IR_IN
	call	DELAYms		; switch debounce
	btfsc	PORTB,7		; when closed check A/D values for strike, input delay and alarm periods 
	goto	IR_IN

; RA6 determines which value to change from VR1/VR2
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,6		; set RA6 as an output
	bcf		STATUS,RP0	; select memory bank 0
	bsf		PORTA,6		; set high to charge
	call	DELAYms		; wait
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,6		; set RA6 as an input
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms
	btfss	PORTA,6		; if input is low then - link is in because the voltage discharged
	goto	MINUS_RA6
; check for + link or open	
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,6		; set RA6 as an output
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,6		; set low to discharge
	call	DELAYms		; wait
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,6		; set RA6 as an input
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms
	btfsc	PORTA,6		; if input is high then + link is in because the voltage charged
	goto	PLUS_RA6
; link open
; set alarm period from VR1
	movlw	EEPROM181	; Alarm period EEPROM
	call 	EEREAD		; sets EEADR
	movf	TRIMPOT_0,w
	call 	EEWRITE
	goto	WAIT_4
MINUS_RA6
; delay for inputs
	movlw	EEPROM179	; Delay for Input1 EEPROM
	call 	EEREAD		; sets EEADR
	movf	TRIMPOT_0,w
	call 	EEWRITE
	movlw	EEPROM180	; Delay for Input2 EEPROM
	call 	EEREAD		; sets EEADR
	movf	TRIMPOT_1,w
	call 	EEWRITE
	goto	WAIT_4
PLUS_RA6
; Striker period
	movlw	EEPROM177	; Strike1 EEPROM
	call 	EEREAD		; sets EEADR
	movf	TRIMPOT_0,w
	call 	EEWRITE
	movlw	EEPROM178	; Strike2 EEPROM
	call 	EEREAD		; sets EEADR
	movf	TRIMPOT_1,w
	call 	EEWRITE

; wait for a low RB4 (start of IR transmission)
; or RB7 high (sync switch open)
WAIT_4
	btfsc	PORTB,7
	goto	IR_IN
	btfsc	PORTB,4
	goto	WAIT_4	

; IR input
IR_IN
	movlw	D'56'		; 56 plus 8-bits stop/start (total 64 bits for normal transmission inc start/stop)
	btfss	PORTB,7		; sync switch
	movlw	D'40'		; total of 48 bits synchronise transmission inc start stop received in two lots 
	btfsc	PORTB,4		; if low then check to start reception
	goto	CHECK_INPUTS
	movwf	COUNT_BITS
	movwf	CNT_BIT_STO	; store for reference later

; use start bits to lock the transmission frequency
	bcf		INTCON,GIE	; stop interrupt
	bcf		T1CON,0		; stop timer 1
	clrf	TMR1L		; clear timer 1
	clrf	TMR1H
	clrf	FLAG		; interrupt occurred flag
	bcf		PIR1,TMR1IF	; clear interrupt flag
	clrf	TMR0		; timer 0 cleared plus prescaler
	nop
	nop
	nop					; wait for timer0 to clear	
	bcf		INTCON,TMR0IF; clear timer 0 flag
		
; set LEDs
	bsf		PORTA,3		; acknowledge LED on
	bcf		PORTA_FLSH,3; flag off so does not momentarily flash

; count with timer 1 for RB4 to go high and then low, high and low corresponding to a 1,1,1 start bits

WAIT_HIGH
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE when timer overflow
	btfss	PORTB,4		; wait for a high 
	goto	WAIT_HIGH

WAIT_LOW
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTB,4		; wait till low 
	goto	WAIT_LOW

	bsf		T1CON,0		; timer1 on to count and check for overrange

WAIT_HIGH1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTB,4		; wait for a high 
	goto	WAIT_HIGH1

WAIT_LOW1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTB,4		; wait till low (start of third start bit after 15 interrupts)
	goto	WAIT_LOW1

WAIT_HIGH2
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfss	PORTB,4		; wait for a high 
	goto	WAIT_HIGH2

WAIT_LOW2
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	btfsc	PORTB,4		; wait till low (start of fouth start bit after 16 interrupts)
	goto	WAIT_LOW2

; read timer 1 and divide by 16 to get the required timer 1 offset (take from FFFF to get preload value)
; if outside range then ignore. Typically should be 1024 but 2048 to 512 allowable

	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_INPUTS; IGNORE
	bcf		T1CON,0		; stop timer 1
	movf	TMR1L,w		; read timer 1
	movwf	TIMER1L_WK	; working registers
	movf	TMR1H,w
	movwf	TIMER1H_WK

; divide by 16 to get average count between each edge
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /2
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /4
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /8
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /16

; compare with over range/under range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111110'		; 512 and greater
	btfsc	STATUS,Z		; if zero then value too small 
	goto	CHECK_INPUTS	; IGNORE
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111000'		; 2048 and greater
	btfss	STATUS,Z		; if not zero then value too large 
	goto	CHECK_INPUTS	; IGNORE

; take from FFFF to get preset for interrupt rate	
	movf	TIMER1H_WK,w	; ms byte
	sublw	H'FF'			; maximum
	movwf	TIMER1H_VAL
	movf	TIMER1L_WK,w	; ls byte
	sublw	H'FF'			; maximum
	movwf	TIMER1L_VAL
	btfss	STATUS,C		; if carry reduce ms byte
	decf	TIMER1H_VAL,f

; add compensation for preload losses

	movlw	D'13'			; works from 10 to 15. Use 13
	addwf	TIMER1L_VAL,f	; add compensation
	btfsc	STATUS,C
	incf	TIMER1H_VAL,f	; if overrange increase ms byte

; preload counter 1 to sync with transmission rate 
	movf	TIMER1H_VAL,w
	movwf	TMR1H
	movf	TIMER1L_VAL,w
	movwf	TMR1L
	clrf	FLAG		; clear flag
	bsf		T1CON,0		; timer1 on start count	
	bsf		INTCON,GIE	; allow interrupts

; wait for one interrupt interval
WAIT_FLG_R
	btfss	FLAG,0
	goto	WAIT_FLG_R
	clrf	FLAG

; wait for 1/4 interrupt interval to centre measurement of level on high or low transmission

; calculate 1/4 interval
	bcf		STATUS,C	; carry cleared
	rrf		TIMER1H_WK,w	; divide by 2
	movwf	TIMER1H_4	; place in secondary register
	rrf		TIMER1L_WK,w
	movwf	TIMER1L_4
	bcf		STATUS,C
	rrf		TIMER1H_4,f	; divide by 2 for total of 4
	rrf		TIMER1L_4,f

; take from FFFF to get shift in time to read data centred on a 1 or 0 value
	bcf		INTCON,GIE	; stop interrupts
	bcf		T1CON,0		; stop timer 1

	movf	TIMER1H_4,w	; ms byte
	sublw	H'FF'		; maximum
	movwf	TMR1H
	movf	TIMER1L_4,w	; ls byte
	sublw	H'FF'		; maximum
	movwf	TMR1L
	btfss	STATUS,C	; if carry reduce ms byte
	decf	TMR1H,f

	bcf		PIR1,TMR1IF	; clear interrupt flag
	bsf		T1CON,0		; run timer 1
	clrf	FLAG
	bsf		INTCON,GIE	; allow interrupts

; start of data
; shift into RECEIVE3,4,5 etc
START_DATA
	clrf	RECEIVE3
	clrf	RECEIVE4
	clrf	RECEIVE5
	clrf	RECEIVE6
	clrf	RECEIVE7
	clrf	RECEIVE8
	clrf	RECEIVE9

WAIT_FLG3
	btfss	FLAG,0		; wait for interrupt flag change
	goto	WAIT_FLG3
	clrf	FLAG		; clear flag 
	btfss	PORTB,4		; check level
	goto	SET_CARRY
	bcf		STATUS,C	; clear carry
	bcf		PORTA,3		; ack LED
	goto	STORE_RECEIVE
SET_CARRY
	bsf		STATUS,C	; set when portb,4 is clear
	bsf		PORTA,3
STORE_RECEIVE
	rlf		RECEIVE9,f
	rlf		RECEIVE8,f
	rlf		RECEIVE7,f
	rlf		RECEIVE6,f
	rlf		RECEIVE5,f
	rlf		RECEIVE4,f
	rlf		RECEIVE3,f
	decfsz	COUNT_BITS,f
	goto	WAIT_FLG3	; continue loading bits

; check stop bits
WAIT_FLG4
	btfss	FLAG,0
	goto	WAIT_FLG4
	clrf	FLAG		; clear flag
	btfsc	PORTB,4		; check level must be a low (for the 1 in the stop bits)
	goto	IGNORE 
WAIT_FLG5
	bsf		PORTA,3
	btfss	FLAG,0
	goto	WAIT_FLG5
	clrf	FLAG		; clear flag 
	btfss	PORTB,4		; check level must be a high (for the 0 in the stop bits)
	goto	IGNORE
WAIT_FLG6
	bcf		PORTA,3
	btfss	FLAG,0
	goto	WAIT_FLG6
	clrf	FLAG		; clear flag
	btfsc	PORTB,4		; check level must be a low (for the 1 in the stop bits)
	goto	IGNORE 
WAIT_FLG7
	bsf		PORTA,3
	btfss	FLAG,0
	goto	WAIT_FLG7
	clrf	FLAG		; clear flag 
	btfsc	PORTB,4		; check level must be a low (for the 1 in the stop bits)
	goto	IGNORE 

; when loaded check CNT_BIT_STO to see if it was for synchronisation or Data.
	movf	CNT_BIT_STO,w
	xorlw	D'56'		; data
	btfss	STATUS,Z
	goto	SYNCH_VALUES
	clrf	SYNC_SET	; reset to data block 1

; collate data for scramble recovery
	movf	RECEIVE3,w
	movwf	RECEIVE10	; identifier
; shift RECEIVE4 to 9 to RECEIVE0 to 5
	movf	RECEIVE4,w
	movwf	RECEIVE0
	movf	RECEIVE5,w
	movwf	RECEIVE1
	movf	RECEIVE6,w
	movwf	RECEIVE2
	movf	RECEIVE7,w
	movwf	RECEIVE3
	movf	RECEIVE8,w
	movwf	RECEIVE4
	movf	RECEIVE9,w
	movwf	RECEIVE5

; Identifier in RECEIVE10. Data placed in REC_EIVE,0 to 5
	
; bits 0,1,6,7 are the identity bits set at 0 to 15 with IDENTITY bits 0,1,2,3

	movlw	B'00001111'	; set high first
	movwf	IDENTITY	; 1 of 16 transmitters
	btfsc	RECEIVE10,6
	bcf		IDENTITY,0	; adjust bits for address
	btfsc	RECEIVE10,7
	bcf		IDENTITY,1	; adjust bits for address
	btfsc	RECEIVE10,0
	bcf		IDENTITY,2	; adjust bits for address
	btfsc	RECEIVE10,1
	bcf		IDENTITY,3	; adjust bits for address

; check if this identity has been synchronised yet. If not then exit (IGNORE).
; Identity value 0 is transmitter ID1, 1 is transmitter ID2 etc 15 is transmitter ID16
; set EEPROM address first

	movlw	EEPROM183	; 0-8 ID flags	
	call	EEREAD		; sets EEADR

	movf	IDENTITY,w	; identity value (0-15)= 1-16
	xorlw	D'00'		; if 0 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT0
	movf	IDENTITY,w
	xorlw	D'01'		; if 1 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT1
	movf	IDENTITY,w
	xorlw	D'02'		; if 2 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT2
	movf	IDENTITY,w
	xorlw	D'03'		; if 3 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT3
	movf	IDENTITY,w
	xorlw	D'04'		; if 4 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT4
	movf	IDENTITY,w
	xorlw	D'05'		; if 5 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT5
	movf	IDENTITY,w
	xorlw	D'06'		; if 6 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT6
	movf	IDENTITY,w
	xorlw	D'07'		; if 7 check if bit is set in EEPROM183
	btfsc	STATUS,Z
	goto	CK_IDENT7

; set up EEPROM address	
	movlw	EEPROM182	; 9-16 ID flags	
	call	EEREAD		; sets EEADR

	movf	IDENTITY,w	; 0-15
	xorlw	D'08'		; if 8 check if bit 0 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT8
	movf	IDENTITY,w
	xorlw	D'09'		; if 9 check if bit 1 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT9
	movf	IDENTITY,w
	xorlw	D'10'		; if 10 check if bit 2 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT10
	movf	IDENTITY,w
	xorlw	D'11'		; if 11 check if bit 3 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT11
	movf	IDENTITY,w
	xorlw	D'12'		; if 12 check if bit 4 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT12
	movf	IDENTITY,w
	xorlw	D'13'		; if 13 check if bit 5 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT13
	movf	IDENTITY,w
	xorlw	D'14'		; if 14 check if bit 6 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT14
	movf	IDENTITY,w
	xorlw	D'15'		; if 15 check if bit 7 set in EEPROM182
	btfsc	STATUS,Z
	goto	CK_IDENT15
	goto	IGNORE		; none set so ignore 

CK_IDENT0
;	check if bit 0 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,0	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT1
;	check if bit 1 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,1	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT2
;	check if bit 2 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,2	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT3
;	check if bit 3 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,3	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT4
;	check if bit 4 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,4	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT5
;	check if bit 5 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,5	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT6
;	check if bit 6 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,6	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT7
;	check if bit 7 set in EEPROM183
	call	EEREAD2			; EEADR set previously for EEPROM183
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,7	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT8
;	check if bit 0 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,0	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT9
;	check if bit 1 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,1	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT10
;	check if bit 2 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,2	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT11
;	check if bit 3 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,3	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT12
;	check if bit 4 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,4	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT13
;	check if bit 5 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,5	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT14
;	check if bit 6 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfsc	SYNCHRON_FLAG,6	; if set can CONtinue_CODE_ChecK
	goto	CON_CODE_CK
	goto	IGNORE
CK_IDENT15
;	check if bit 7 set in EEPROM182
	call	EEREAD2			; EEADR set previously for EEPROM182
	movwf	SYNCHRON_FLAG	; store
	btfss	SYNCHRON_FLAG,7	; if set can CONtinue_CODE_ChecK
	goto	IGNORE

CON_CODE_CK; continue with code check
; identity synchronised so continue with code check
	movf	IDENTITY,w
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	addlw	H'0A'			; get scramble value address @10 addresses above identity start address 
	call	EEREAD			;
	movwf	SCRAMBLE

; unscramble data bytes
	call	DECODE_SCRAMBLE

; compare for matching values
	call	MATCH
	goto	RESULT

; subroutine to compare
MATCH ; compare values received with those stored	
;0
	movf	IDENTITY,w
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE0,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;1
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE1,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;2	
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE2,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;3
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE3,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;4
	incf	EEADR,f			; increase to 8th location for last 2-bytes
	incf	EEADR,f			;
	incf	EEADR,f
	incf	EEADR,f
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE4,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; no match
	bsf		STATUS,RP1		; bank 2
;5
	incf	EEADR,w			; next EEPROM
	call	EEREAD			; sets EEADR and reads EEPROM
	xorwf	REC_EIVE5,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	retlw 	D'00'			; not matching
	retlw	D'01'			; matching

RESULT
	xorlw	D'01'			; if 01 then match
	btfss	STATUS,Z
	goto	RECALC_TO_MATCH

; *******************************************************************

FUNCTIONS1
; if correct calculate the next random data and store in EEPROM
	call	RECALCULATE		; next values calculated and stored
	call	STORE
; then act on depending on functions required 
FUNCTIONS
; S1/S2 operation. (Bit 2 in RECEIVE10 is switch bit)
; functions

; link 4 RB3. arm/disarm (normal/invert)

; link 1 RA7. Strike1 (operates on arm +/disarm - or both open)

; link 2 RA5. Strike2  
; Independently momentarily on with S2 (+) or independently toggle with S2 (-)

; link 3 RA6; time periods  delay inputs 1 and 2 separately with VR1/VR2 (+).
; strike period (strike 1 with VR1 and strike 2 with VR2)(-)
; alarm period (open)

; check S1 or S1 for Strike 1/ Strike 2

	btfsc	RECEIVE10,2		; if set then S2
	goto 	S2_OPERATION

; S1 operation
; arm or disarm	
	movlw	EEPROM176		; arm/disarm
	call	EEREAD
	movwf	ARM
	xorlw	D'00'
	btfss	STATUS,Z		; if zero disarmed so arm
	goto	S1_DISARM
; ARM
	movlw	D'01'		; arm
	movwf	ARM
	call	EEWRITE		; write value to EEPROM
; set arm output and LED
	btfss	PORTB,3		; if low (link in) set RB2 low
	goto	SET_RB2_LOW
	bsf		PORTB,2		; set 
	goto	ARM_LED_SET
SET_RB2_LOW
	bcf		PORTB,2	
ARM_LED_SET
	bsf		PORTA_FLSH,4; PORTA,4 flash; armed LED on

; reset values
	movf	PORTB,w		; read portB
	andlw	B'01100000'	; only RB5 & RB6
	movwf	PORTB_STORE	; store value
	clrf	PORTB_FLG	; clear portB (RB5 and RB6) change flag

; set input delays
	movlw	EEPROM179
	call	EEREAD
	movwf	INPUT1_DELAY
	movlw	EEPROM180
	call	EEREAD
	movwf	INPUT2_DELAY
		
; determine strike operation

; RA7 links for Strike1 (operates on arm +/disarm - or both open)

	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7		; set RA7 as an output
	bcf		STATUS,RP0	; select memory bank 0
	bsf		PORTA,7		; set high to charge
	call	DELAYms		; wait
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7		; set RA7 as an input
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms
	btfss	PORTA,7		; if input is low then - link is in because the voltage discharged
	goto	MINUS_RA7
; check for + link or open	
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7		; set RA7 as an output
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,7		; set low to discharge
	call	DELAYms		; wait
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7		; set RA7 as an input
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms
	btfsc	PORTA,7		; if input is high then + link is in because the voltage charged
	goto	PLUS_RA7

; link open
; Strike 1 operates on arm and disarm
; operate
	goto	PLUS_RA7	
MINUS_RA7
; Strike 1 operates on disarm
; no operate
	bcf		PORTB,0
	goto	CHECK_INPUTS
	
PLUS_RA7
; Strike 1 operates on arm
; operate
; load STRIKE1 timer
	movlw	EEPROM177
	call	EEREAD
	movwf	STRIKE1_PERIOD
	bsf		PORTB,0		; strike 1 on for strike 1 period	
	movlw	D'02'		; start reducing counter almost immediately at interrupt for consistent timeout	
	movwf	COUNTER_DIV	
	goto	CHECK_INPUTS

S1_DISARM	
	movlw	D'00'		; arm
	movwf	ARM
	call	EEWRITE		; write value to EEPROM
; clear arm output and LED
	btfss	PORTB,3		; if low (link in) set RB2 high
	goto	SET_RB2_HIGH
	bcf		PORTB,2		; clear 
	goto	ARM_LED_CLEAR
SET_RB2_HIGH
	bsf		PORTB,2	
ARM_LED_CLEAR
	bcf		PORTA,4		; armed LED off
	bcf		PORTA_FLSH,4; flash flag off

; clear timers
	clrf	INPUT1_DELAY
	clrf	INPUT2_DELAY
	clrf	ALARM_PERIOD
	clrf	PORTB_FLG	; inputs changed flags
	bcf		PORTB,1		; alarm off
			
; determine strike operation on disarm
; RA7 links for Strike1 (operates on arm +/disarm - or both open)

	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7		; set RA7 as an output
	bcf		STATUS,RP0	; select memory bank 0
	bsf		PORTA,7		; set high to charge
	call	DELAYms		; wait
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7		; set RA7 as an input
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms
	btfss	PORTA,7		; if input is low then - link is in because the voltage discharged
	goto	MINUS_RA7_DISARM
; check for + link or open	
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,7		; set RA7 as an output
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,7		; set low to discharge
	call	DELAYms		; wait
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,7		; set RA7 as an input
	bcf		STATUS,RP0	; select memory bank 0
	call	DELAYms
	btfsc	PORTA,7		; if input is high then + link is in because the voltage charged
	goto	PLUS_RA7_DISARM

; link open
; Strike 1 operates on arm and disarm
; operate
	goto	MINUS_RA7_DISARM
	
PLUS_RA7_DISARM
; Strike 1 operates on arm not disarm
; so do not operate
	bcf		PORTB,0
	goto	CHECK_INPUTS
	
MINUS_RA7_DISARM
; Strike 1 operates on arm only
; do not operate
; load STRIKE1 timer
	movlw	EEPROM177
	call	EEREAD
	movwf	STRIKE1_PERIOD
	bsf		PORTB,0		; strike 1 on for strike 1 period	
	movlw	D'02'		; start reducing counter almost immediately at interrupt for consistent timeout	
	movwf	COUNTER_DIV	
	goto	CHECK_INPUTS


; ******************************************************
S2_OPERATION

; RA5 links. Strike2  
; Independently momentarily on with S2 (+)or independently toggle with S2 (-)

	btfsc	PORTA,5
	goto	MOMENT2

; Strike 2 toggles on and off 
; operate 2
	btfss	PORTA,2
	goto	SET_RA2
	bcf		PORTA,2		; clear
	bcf		TOGGLE_2,0	
	goto	CHECK_INPUTS	
SET_RA2
	bsf		PORTA,2
	bsf		TOGGLE_2,0	; set toggle bit to avoid RA2 claring on Strike2_period timeout
	goto	CHECK_INPUTS

MOMENT2
; Strike 2 operates independently with S2. Closes momentary with each S2

; load STRIKE2 timer
	movlw	EEPROM178
	call	EEREAD
	movwf	STRIKE2_PERIOD
	bsf		PORTA,2		; strike 2 on for strike 2 period	
	movlw	D'02'		; start reducing counter almost immediately at interrupt for consistent timeout	
	movwf	COUNTER_DIV	
	goto	CHECK_INPUTS

; *************************************************************************

; inputs, when they change set alarm if required
INPUT_1

; ignore if disarmed
	movlw	EEPROM176
	call	EEREAD
	movwf	ARM
	xorlw	D'00'			; if zero disarmed
	btfsc	STATUS,Z
	goto 	DISARMED_INPUT
; ignore if	INPUT1_DELAY not zero (timing)
	movf	INPUT1_DELAY,w
	btfss	STATUS,Z
	goto	IGNORE_INPUT

; set alarm
SET_ALM1
; bypass setting of alarm if already on to prevent alarm period being extended
	clrf	PORTB_FLG		; inputs changed flag
	btfsc	PORTB,1	
	goto	CHECK_INPUTS
	movlw	EEPROM181		; eeprom for alarm period
	call	EEREAD
	bcf		INTCON,GIE		; stop interrupt
	movwf	ALARM_PERIOD
; set input delay
	btfsc	ALARM_SET,0		; if alarm already set bypass loading timer
	goto	CHECK_INPUT_NOW1
	movlw	EEPROM179		; input 1 timer
	call	EEREAD1
	movwf	ENTRY_TIMER
	bsf		ALARM_SET,0		; sets PORTB,1 after entry period; alarm on
CHECK_INPUT_NOW1
	bsf		INTCON,GIE		; restart interrupt
	goto	CHECK_INPUTS
	
DISARMED_INPUT
	clrf	INPUT1_DELAY
	clrf	INPUT2_DELAY
IGNORE_INPUT
	clrf	PORTB_FLG		; inputs changed flags
	bcf		PORTB,1			; alarm off	
	clrf	ALARM_SET		; alarm set off
	goto	CHECK_INPUTS

INPUT_2
; ignore if disarmed
	movlw	EEPROM176
	call	EEREAD
	movwf	ARM
	xorlw	D'00'			; if zero disarmed
	btfsc	STATUS,Z
	goto 	DISARMED_INPUT
; ignore if INPUT2_DELAY not zero (timing)
	movf	INPUT2_DELAY,w
	btfss	STATUS,Z
	goto	IGNORE_INPUT
	
SET_ALM2
; bypass setting of alarm if already on to prevent alarm period being extended
	clrf	PORTB_FLG		; inputs changed flag
	btfsc	PORTB,1			; if alarm on already bypass
	goto	CHECK_INPUTS
	movlw	EEPROM181		; eeprom for alarm period
	call	EEREAD
	bcf		INTCON,GIE		; stop interrupt
	movwf	ALARM_PERIOD
; set input delay
	btfsc	ALARM_SET,0		; if alarm already set bypass loading timer
	goto	CHECK_INPUT_NOW
	movlw	EEPROM180		; input 2 delay
	call	EEREAD1
	movwf	ENTRY_TIMER
	bsf		ALARM_SET,0		; sets PORTB,1 after entry period; alarm on
CHECK_INPUT_NOW
	bsf		INTCON,GIE		; restart interrupt
	goto	CHECK_INPUTS


; ************************************************************************************
; Recalculation
; if incorrect recalculate next random data then store and check again for xx repeats
RECALC_TO_MATCH

	movlw	D'200'			; test at repeat of xx
	movwf	REPEAT			; look ahead count
	call	RECALCULATE		; gets stored values first for random generator and then randomises values
	goto	CK_RANDBX		; bypass call random as already in recalculate
RECALC_XXX
	call	RANDOM			; recalculate random number

; check next number of repeat values if not a match then abort
CK_RANDBX
	movf	RANDB0,w 
	xorwf	REC_EIVE0,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB1,w 
	xorwf	REC_EIVE1,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB2,w 
	xorwf	REC_EIVE2,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB3,w 
	xorwf	REC_EIVE3,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB4,w 
	xorwf	REC_EIVE4,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match
	movf	RANDB5,w 
	xorwf	REC_EIVE5,w		; check ms byte
	btfss	STATUS,Z		; when the same check next byte	
	goto	NXT1			; not a match

; when a match recalculate and store
	call	STORE			; store values
	goto	FUNCTIONS1		; a match so act upon
NXT1
	decfsz	REPEAT,f		; decrease till 0 
	goto	RECALC_XXX
	goto	CHECK_INPUTS	; no match after xx future codes 

RECALCULATE

; get values for RANDB0,1,2,3,mult and increment for calculation
	movf	IDENTITY,w
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
; RANDB0
	call	EEREAD
	movwf	RANDB0
	bsf		STATUS,RP1		; bank 2
; RANDB1
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	RANDB1
	bsf		STATUS,RP1		; bank 2
; RANDB2
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	RANDB2
	bsf		STATUS,RP1		; bank 2
; RAND3
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	RANDB3
	bsf		STATUS,RP1		; bank 2
; MULT0
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	MULT0
	bsf		STATUS,RP1		; bank 2
; MULT1
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	MULT1
	bsf		STATUS,RP1		; bank 2
; MULT2
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	MULT2
	bsf		STATUS,RP1		; bank 2
; INCREMENT
	incf	EEADR,w			; next EEPROM
	call	EEREAD
	movwf	INCREMENT

	call	RANDOM			; recalculate the random values
	return

STORE
; store
	movf	IDENTITY,w	
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR
; RAND0
	movf	RANDB0,w		; Random ms byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND1
	incf	EEADR,f	 		; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB1,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB2,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND3
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB3,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; increase to 8th location for last 2-bytes
	incf	EEADR,f			;
	incf	EEADR,f
	incf	EEADR,f
; RAND4
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB4,w		; Mult byte
	call	EEWRITE
; RAND5
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RANDB5,w		; Random byte
	call	EEWRITE
	return


; ********************************************************************
; SYNCHRONISE

; if synchronise, load into EEPROM new values
SYNCH_VALUES

; First data block IDENTIFIER, RANDB0,1,2,3 (40 bits) 
; Second data block MULT0,1,2, INCREMENT, SCRAMBLE (40 bits)
; located in RECEIVE9 to RECEIVE5
; identifier provides EEPROM locations starting address 
; set synchronisation flag in EEPROM for the identity

; Check which block
	movf	SYNC_SET,w	; if zero data block 1
	btfss	STATUS,Z
	goto	BLOCK2_SYNC

; bits 0,1,6,7 are the identity bits set at 0 to 15 with IDENTITY bits 0,1,2,3
	movlw	B'00001111'	; set high first
	movwf	IDENTITY	; 1 of 16 transmitters
	btfsc	RECEIVE5,6	; identity is in receive5 for block1
	bcf		IDENTITY,0	; adjust bits for address
	btfsc	RECEIVE5,7
	bcf		IDENTITY,1	; adjust bits for address
	btfsc	RECEIVE5,0
	bcf		IDENTITY,2	; adjust bits for address
	btfsc	RECEIVE5,1
	bcf		IDENTITY,3	; adjust bits for address

	movf	IDENTITY,w	
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR

; RAND0
	movf	RECEIVE6,w		; Random ms byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND1
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE7,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE8,w		; Random byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; RAND3
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE9,w		; Random byte
	call	EEWRITE
	movlw	D'03'
	movwf	SYNC_SET		; set at 3 so can be reduced to 0 after 0.75secs max
	goto	CHECK_INPUTS

; block 2
BLOCK2_SYNC
	movf	IDENTITY,w	
	call	IDENTITY_FIND	; lookup table to get start address for EEADR
	call	EEREAD			; sets EEADR
	bsf		STATUS,RP1		; bank 2
	incf	EEADR,f			; next EEPROM
	incf	EEADR,f			; next EEPROM
	incf	EEADR,f			; next EEPROM
	
; MULT0	
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE5,w		; Mult byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; MULT1
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE6,w		; Mult byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; MULT2
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE7,w		; Mult byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2
; INCREMENT
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE8,w		; Increment byte
	call	EEWRITE
	bsf		STATUS,RP1		; bank 2

	incf	EEADR,f			; increase to 8th location for last 2-bytes
	incf	EEADR,f			;
; SCRAMBLE
	incf	EEADR,f			; next EEPROM
	bcf		STATUS,RP1		; bank 0
	movf	RECEIVE9,w		; Scramble byte
	call	EEWRITE
	
	clrf	SYNC_SET		; first block flag cleared

;  store identifier 0 to 7 in EEPROM183

	clrf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	btfsc	STATUS,Z		; when 0 set bit 0 in EEPROM183
	bsf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'01'			; when 1 set bit 1 in EEPROM183
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'02'			; when 2 set bit 2 in EEPROM183
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'03'			; when 3 set bit 3 in EEPROM183
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'04'			; when 4 set bit 4 in EEPROM183
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'05'			; when 5 set bit 5 in EEPROM183
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'06'			; when 6 set bit 6 in EEPROM183
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'07'			; when 7 set bit 7 in EEPROM183
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,7	

; check if zero
	movf	SYNCHRON_FLAG,w
	btfsc	STATUS,Z		; if flag register is zero bypass storing the new flag setting
	goto	ID8_16
; get current flags
	movlw	EEPROM183		; 0-8 flags
	call	EEREAD			; value in w
	iorwf	SYNCHRON_FLAG,w	; include new flag
	call 	EEWRITE			; write values

;  store identifier 8 to 16 in EEPROM182
ID8_16
	clrf	SYNCHRON_FLAG	; cleared ready to set a bit
	movf	IDENTITY,w
	xorlw	D'08'			; when 8 set bit 0 in EEPROM182
	btfsc	STATUS,Z		; 
	bsf		SYNCHRON_FLAG,0
	movf	IDENTITY,w
	xorlw	D'09'			; when 9 set bit 1 in EEPROM182
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,1	
	movf	IDENTITY,w
	xorlw	D'10'			; when 10 set bit 2 in EEPROM182
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,2	
	movf	IDENTITY,w
	xorlw	D'11'			; when 11 set bit 3 in EEPROM182
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,3	
	movf	IDENTITY,w
	xorlw	D'12'			; when 12 set bit 4 in EEPROM182
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,4	
	movf	IDENTITY,w
	xorlw	D'13'			; when 13 set bit 5 in EEPROM182
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,5	
	movf	IDENTITY,w
	xorlw	D'14'			; when 14 set bit 6 in EEPROM182
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,6	
	movf	IDENTITY,w
	xorlw	D'15'			; when 15 set bit 7 in EEPROM182
	btfsc	STATUS,Z
	bsf		SYNCHRON_FLAG,7	

; check if zero
	movf	SYNCHRON_FLAG,w
	btfsc	STATUS,Z		; if flag register is zero bypass storing the new flag setting
	goto	FLAS_ACK

; get current flags
	movlw	EEPROM182		; 9-16 flags
	call	EEREAD			; value in w
	iorwf	SYNCHRON_FLAG,w	; include new flag
	call 	EEWRITE			; write values

; flash ACK LED
FLAS_ACK
	bcf		PORTA,3			; acknowledge LED off
	movlw 	D'25'
	movwf	STORE3
	
MORE_DELAY1
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY1	
; show ACK LED
	bsf		PORTA,3			; acknowledge LED on
	movlw 	D'25'
	movwf	STORE3
	
MORE_DELAY2
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY2	
; flash ACK LED
	bcf		PORTA,3			; acknowledge LED off
	movlw 	D'25'
	movwf	STORE3
	
MORE_DELAY3
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY3	
; show ACK LED
	bsf		PORTA,3			; acknowledge LED on
	btfss	PORTB,7			; keep flashing until RB7 high
	goto	FLAS_ACK
	goto	CHECK_INPUTS

; *********************************************************************

IGNORE
; start and stop bits incorrect so ignore data. Flash Ack LED to indicate ignore 
	bcf		PORTA,3		; ack LED off (power LED)
	movlw 	D'30'
	movwf	STORE3
	
MORE_DELAY9
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY9	

	bsf		PORTA,3		; ack LED on (power LED)
	movlw 	D'30'
	movwf	STORE3
	
MORE_DELAY10
	call	DELAYms
	decfsz	STORE3,f
	goto	MORE_DELAY10
	goto	CHECK_INPUTS

 
; **************************************************************

; subroutines

; delay
DELAYms
	movlw	H'FF'		; delay 
DELAY
	movwf	STORE1		; STORE1 is number of loops value
LOOP1	
	movlw	D'20'
	movwf	STORE2		; STORE2 is internal loop value	
LOOP2
	decfsz	STORE2,f
	goto	LOOP2
	decfsz	STORE1,f
	goto	LOOP1		; decrease till STORE1 is zero
	return

; subroutines to read EEPROM memory

EEREAD; when interrupt stopped	
	bcf		INTCON,GIE	; clear global interrupt enable 
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	bsf		INTCON,GIE	; set global interrupt enable 
	return

EEREAD1; when interrupt not stopped	
	bcf 	STATUS,RP0	; select memory bank 
	bsf		STATUS,RP1	; bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

EEREAD2; when EEADR is set
	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf		STATUS,RP1	; bank 2
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,W	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	bsf		INTCON,GIE	; set global interrupt enable 
	return

; subroutines to write to EEPROM

EEWRITE
	bcf		INTCON,GIE	; clear global interrupt enable 
	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence

	bcf		EECON1,WREN	; clear WREN bit
WRITE	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
	bsf		INTCON,GIE	; set global interrupt enable 
	return				; value written 

EEWRITE1; before interrupts enabled

	bsf	    STATUS,RP1	; select bank 
	bcf 	STATUS,RP0	; select memory bank 2
	movwf	EEDATA		; data register
	bcf		INTCON,GIE	; disable interrupts
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; pointer for data memory
	bsf		EECON1,WREN	; enable write
	movlw	0x55		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	0xAA		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence

	bcf		EECON1,WREN	; clear WREN bit
WRITE1	
	btfsc	EECON1,WR	; skip if write complete WR=0 when write complete
	goto 	WRITE1		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP0	; bank select
	bcf 	STATUS,RP1	; select memory bank 0 
	return				; value written 

; scramble data decode
DECODE_SCRAMBLE
	movf	SCRAMBLE,w
	andlw	B'00011111'	; count of 32 maximum
	movwf	SCRAMBLE1
	btfsc	STATUS,Z	; if zero
	goto	ZERO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 1	
	goto	ONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 2	
	goto	TWO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 3	
	goto	THREE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 4	
	goto	FOUR_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 5	
	goto	FIVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 6	
	goto	SIX_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 7	
	goto	SEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 8	
	goto	EIGHT_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 9	
	goto	NINE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 10	
	goto	TEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 11	
	goto	ELEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 12	
	goto	TWELVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 13	
	goto	THIRTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 14	
	goto	FOURTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 15	
	goto	FIVETEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 16	
	goto	SIXTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 17	
	goto	SEVENTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 18
	goto	EIGHTEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 19	
	goto	NINETEEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 20	
	goto	TWENTY_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 21	
	goto	TWENTYONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 22	
	goto	TWENTYTWO_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 23	
	goto	TWENTYTHREE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 24	
	goto	TWENTYFOUR_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 25	
	goto	TWENTYFIVE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 26	
	goto	TWENTYSIX_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 27	
	goto	TWENTYSEVEN_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 28	
	goto	TWENTYEIGHT_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 29	
	goto	TWENTYNINE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 30	
	goto	THIRTY_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 31	
	goto	THIRTYONE_SCRAMBLE
	decf	SCRAMBLE1,f
	btfsc	STATUS,Z	; if 32	
	goto	THIRTYTWO_SCRAMBLE

ZERO_SCRAMBLE
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
ONE_SCRAMBLE
; 0,1,3,2,4,5 transmitter scramble (swap 2&3)
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE3	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWO_SCRAMBLE
; 0,2,1,3,4,5 (swap 2&1)
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
THREE_SCRAMBLE
; 0,2,3,1,4,5 scramble
; 0,1,2,3,4,5 unscramble
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FOUR_SCRAMBLE
; 0,3,1,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FIVE_SCRAMBLE
; 0,3,2,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE0
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SIX_SCRAMBLE
; 1,2,3,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SEVEN_SCRAMBLE
; 1,2,0,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
EIGHT_SCRAMBLE
; 1,3,0,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
NINE_SCRAMBLE
; 1,3,2,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TEN_SCRAMBLE
; 1,0,2,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
ELEVEN_SCRAMBLE
; 1,0,3,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE1
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWELVE_SCRAMBLE
; 2,0,1,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
THIRTEEN_SCRAMBLE
; 2,0,3,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FOURTEEN_SCRAMBLE
; 2,1,0,3,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
FIVETEEN_SCRAMBLE
; 2,1,3,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE3
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SIXTEEN_SCRAMBLE
; 2,3,0,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
SEVENTEEN_SCRAMBLE
; 2,3,1,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE2
	movf	RECEIVE1,w
	movwf	REC_EIVE3
	movf	RECEIVE2,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
EIGHTEEN_SCRAMBLE
; 3,0,1,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
NINETEEN_SCRAMBLE
; 3,0,2,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE0
	movf	RECEIVE2,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE1	; 
	movf	RECEIVE4,w
 	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTY_SCRAMBLE
; 3,1,0,2,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE0	; 
	movf	RECEIVE3,w
	movwf	REC_EIVE2	; 
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYONE_SCRAMBLE
; 3,1,2,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE1
	movf	RECEIVE2,w
	movwf	REC_EIVE2
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYTWO_SCRAMBLE
; 3,2,0,1,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYTHREE_SCRAMBLE
; 3,2,1,0,4,5
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE3
	movf	RECEIVE1,w
	movwf	REC_EIVE2
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE0
	movf	RECEIVE4,w
	movwf	REC_EIVE4
	movf	RECEIVE5,w
	movwf	REC_EIVE5
	return
TWENTYFOUR_SCRAMBLE
; 4,5,0,1,2,3
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE2
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	return
TWENTYFIVE_SCRAMBLE
; 4,5,0,1,3,2
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE1
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	return
TWENTYSIX_SCRAMBLE
; 4,5,0,2,1,3
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE1
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	return
TWENTYSEVEN_SCRAMBLE
; 4,5,0,2,3,1
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE1
	return
TWENTYEIGHT_SCRAMBLE
; 4,5,0,3,1,2
; 0,1,2,3,4,5
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE1
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	return
TWENTYNINE_SCRAMBLE
; 4,5,0,3,2,1
; 0,1,2,3,4,5	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE0
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE2
	movf	RECEIVE5,w
	movwf	REC_EIVE1
	return
THIRTY_SCRAMBLE
; 4,5,1,2,3,0
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE3
	movf	RECEIVE5,w
	movwf	REC_EIVE0
	return
THIRTYONE_SCRAMBLE
; 4,5,1,2,0,3	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE2
	movf	RECEIVE4,w
	movwf	REC_EIVE0
	movf	RECEIVE5,w
	movwf	REC_EIVE3
	return
THIRTYTWO_SCRAMBLE
; 4,5,1,3,0,2	
	movf	RECEIVE0,w
	movwf	REC_EIVE4
	movf	RECEIVE1,w
	movwf	REC_EIVE5
	movf	RECEIVE2,w
	movwf	REC_EIVE1
	movf	RECEIVE3,w
	movwf	REC_EIVE3
	movf	RECEIVE4,w
	movwf	REC_EIVE0
	movf	RECEIVE5,w
	movwf	REC_EIVE2
	return


; number generator

;	Input:	32 bit initial integer seed in AARGB0, AARGB1, AARGB2, AARGB3

;	X  = (a * X(previous) + c) 

;	X is the result (2**48 bits used) and becomes the seed for next calculation 
;	with multiplier a (24 bit), increment c (8-bit) 

RANDOM

		movf		RANDB0,w		; random numbers
		movwf		AARGB0
		movf		RANDB1,w
		movwf		AARGB1
		movf		RANDB2,w
		movwf		AARGB2
		movf		RANDB3,w
		movwf		STO_RANDB3
		movwf		AARGB3
				

		movf		MULT2,w			; multiplier 
		movwf		BARGB2
		movf		MULT1,w
		movwf		BARGB1
		movf		MULT0,w
		movwf		BARGB0

		call		FXM3224U		; multiply

		movf		INCREMENT,w		; increment value
        addwf       AARGB6,F		; c = incrementer
        btfsc       STATUS,Z		; carry to more significant bytes
        incf        AARGB5,F
		btfsc		STATUS,Z
		incf		AARGB4,F
		btfsc		STATUS,Z
		incf		AARGB3,F
		btfsc       STATUS,Z
        incf        AARGB2,F
		btfsc		STATUS,Z
		incf		AARGB1,F
		btfsc		STATUS,Z
		incf		AARGB0,F

; transfer values to RAND registers
	
		movf		AARGB1,w
		movwf		RANDB5
		movf		AARGB2,w
		movwf		RANDB4

		movf		AARGB3,w
		movwf		RANDB0
		movf		AARGB4,W
		movwf		RANDB1
		movf		AARGB5,W
		movwf		RANDB2
		movf		AARGB6,W
		movwf		RANDB3

; check if value the same as last time
		movf		STO_RANDB3,w
		xorwf		RANDB3,w
		btfsc		STATUS,Z
		incf		RANDB3,f
; check if last 4-ls bits were the same
		movf		STO_RANDB3,w
		andlw		H'0F'			; least 4-bits
		movwf		TEMPX
		movf		RANDB3,w
		andlw		H'0F'	
		xorwf		TEMPX,w
		btfsc		STATUS,Z
		incf		RANDB3,f		
		return


;       32x24 Bit Unsigned Fixed Point Multiply 32x24 -> 56

;       Input:  32 bit unsigned fixed point multiplicand in AARGB0, AARGB1,
;               AARGB2, AARGB3

;               24 bit unsigned fixed point multiplier in BARGB0, BARGB1,
;               BARGB2

;       Use:    CALL    FXM3224U

;       Output: 56 bit unsigned fixed point product in AARGB0

;       Result: AARG  <--  AARG x BARG

;       Max Timing:     11+617+2 = 630 clks

;       Min Timing:     11+151 = 162 clks

;       PM: 11+139+1 = 151              DM: 15

FXM3224U
               	clrf   		 	AARGB4          ; clear partial product
               	clrf    		AARGB5
               	clrf    		AARGB6
                movf   			AARGB0,W
                movwf   		TEMPB0
                movf   			AARGB1,W
                movwf   		TEMPB1
                movf   			AARGB2,W
                movwf   		TEMPB2
                movf   			AARGB3,W
                movwf   		TEMPB3

               	call 			UMUL3224L

                retlw           D'00'

; UMUL3224L        macro

;       Max Timing:     2+15+6*25+24+2+7*26+25+2+7*27+26 = 617 clks

;       Min Timing:     2+7*6+5+1+7*6+5+1+7*6+5+6 = 151 clks

;       PM: 31+24+2+25+2+26+2+27 = 139            DM: 15

UMUL3224L       movlw   		D'8'
                movwf   		LOOPCOUNT

LOOPUM3224A
                rrf    		 	BARGB2,F
                btfsc   		STATUS,C
               	goto   			ALUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto   			LOOPUM3224A

                movwf   		LOOPCOUNT

LOOPUM3224B
                rrf     		BARGB1,F
                btfsc   		STATUS,C
               	goto   			BLUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto   			LOOPUM3224B

                movwf  			LOOPCOUNT

LOOPUM3224C
                rrf     		BARGB0,F
                btfsc   		STATUS,C
              	goto  	 		CLUM3224NAP
                decfsz  		LOOPCOUNT,F
               	goto  	 		LOOPUM3224C

              	clrf    		AARGB0
               	clrf    		AARGB1
               	clrf    		AARGB2
               	clrf    		AARGB3
                retlw   		D'00'
                
ALUM3224NAP     bcf     		STATUS,C
               	goto  	 		ALUM3224NA
                
BLUM3224NAP     bcf     		STATUS,C
               	goto 	  		BLUM3224NA
                
CLUM3224NAP     bcf     		STATUS,C
              	goto  	 		CLUM3224NA

ALOOPUM3224
                rrf     		BARGB2,F
                btfss   		STATUS,C
                goto   			ALUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

ALUM3224NA
                rrf    			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf             AARGB3,F
                rrf             AARGB4,F
                decfsz  		LOOPCOUNT,F
                goto    		ALOOPUM3224

                movlw   		D'8'
                movwf   		LOOPCOUNT

BLOOPUM3224
                rrf     		BARGB1,F
                btfss   		STATUS,C
              	goto  	 		BLUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

BLUM3224NA
                rrf    			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf             AARGB3,F
                rrf             AARGB4,F
                rrf             AARGB5,F
                decfsz  		LOOPCOUNT,F
              	goto   			BLOOPUM3224

                movlw   		D'8'
                movwf   		LOOPCOUNT

CLOOPUM3224
                rrf     		BARGB0,F
                btfss   		STATUS,C
               	goto 	  		CLUM3224NA
                movf    		TEMPB3,W
                addwf   		AARGB3,F
                movf            TEMPB2,W
                btfsc           STATUS,C
                incfsz          TEMPB2,W
                addwf           AARGB2,F
                movf            TEMPB1,W
                btfsc           STATUS,C
                incfsz          TEMPB1,W
                addwf           AARGB1,F
                movf            TEMPB0,W
                btfsc           STATUS,C
                incfsz          TEMPB0,W
                addwf           AARGB0,F

CLUM3224NA
                rrf  			AARGB0,F
                rrf    			AARGB1,F
                rrf    			AARGB2,F
                rrf    			AARGB3,F
                rrf             AARGB4,F
                rrf             AARGB5,F
                rrf             AARGB6,F
                decfsz  		LOOPCOUNT,F
                goto   			CLOOPUM3224
				return	
 

; ******************************************************************************************************
; INTERRUPT

; start interrupt by saving w and status registers 
	org	H'800'; page 1	
INTERRUPT
	
	bcf		STATUS,RP0
	bcf		STATUS,RP1	; bank 0

; check RB5 & RB6 for a change
	btfss	INTCON,RBIF	; port change flag
	goto	TMER1_FLG	; not port change
	bcf		INTCON,RBIF
	movf	PORTB,w
	movwf	PORTB_TEMP
	andlw	B'01100000'	; RB5 & RB6
	xorwf	PORTB_STORE,w	; compare previous PORTB value
	btfsc	STATUS,Z	; if zero bypass
	goto	TMER1_FLG
; test RB6
	movf	PORTB_STORE,w
	andlw	B'01000000'	; RB6 
	movwf	PORTB_STORE1
	movf	PORTB_TEMP,w
	andlw	B'01000000'
	xorwf	PORTB_STORE1,w
	btfss	STATUS,Z	; if RB6 has changed
	bsf		PORTB_FLG,6	; set RB6 flag
; test RB5
	movf	PORTB_STORE,w
	andlw	B'00100000'	; RB5 
	movwf	PORTB_STORE1
	movf	PORTB_TEMP,w
	andlw	B'00100000'
	xorwf	PORTB_STORE1,w
	btfss	STATUS,Z	; if RB5 has changed
	bsf		PORTB_FLG,5	; set RB5 flag
; reread portB	
	movf	PORTB_TEMP,w
	andlw	B'01100000'	; RB5 & RB6
	movwf	PORTB_STORE

TMER1_FLG
	btfss	PIR1,TMR1IF	; check timer 1 flag
	goto	RECLAIM		; not timer 1
; preload timer
	bcf		T1CON,0		; timer 1 off	
	movf	TIMER1H_VAL,w
	addwf	TMR1H,f
	movf	TIMER1L_VAL,w
	addwf	TMR1L,f
	btfsc	STATUS,C
	incf	TMR1H,f		; increase ms byte if ls addition has carry
	bsf		T1CON,0		; timer 1 on

	bcf		PIR1,TMR1IF	; clear timer 1 overflow

	bsf		FLAG,0		; set flag bit to indicate an interrupt has occurred

	decf	COUNTER_DIV,f	; extra divider for A/D and timers/counters

; momentary flash for power and arm LEDs
	btfss	COUNTER_DIV,4	; sets flash rate
	goto	COUNTERS
	decf	FLSH_COUNT,f	; flash counter
	movlw	D'10'			; sets flash on-time with respect to 256 total
	subwf	FLSH_COUNT,w
	btfsc	STATUS,C		; if 10 or less flash on
	goto	BY_FLSH_LED
	btfsc	PORTA_FLSH,3	; power
	bsf		PORTA,3			; power LED on
	btfsc	PORTA_FLSH,4	; arm
	bsf		PORTA,4			; arm LED on
	goto	COUNTERS
BY_FLSH_LED
	btfsc	PORTA_FLSH,3	; power
	bcf		PORTA,3			; power LED off
	btfsc	PORTA_FLSH,4	; arm
	bcf		PORTA,4			; arm LED off

COUNTERS
	movf	COUNTER_DIV,w
	btfss	STATUS,Z		; when zero 0.26s so run counters
	goto	RECLAIM

; decrease SYNC_SET to 0 after 0.75s maximim (whyen 0 returns to block1 data for synchronise)

	movf	SYNC_SET,w			; block2 data 
	btfss	STATUS,Z			; if zero do not decrease
	decf	SYNC_SET,f

; decrease counters to zero (0.26s/value)
; Strike1
	movf	STRIKE1_PERIOD,w	; strike1 period
	btfss	STATUS,Z			; if zero do not decrease
	decf	STRIKE1_PERIOD,f
	movf	STRIKE1_PERIOD,w	; strike1 period
	btfsc	STATUS,Z			; when zero clear RB0
	bcf		PORTB,0
; Strike2
	movf	STRIKE2_PERIOD,w	; strike2 period
	btfss	STATUS,Z			; if zero do not decrease
	decf	STRIKE2_PERIOD,f
	movf	STRIKE2_PERIOD,w	; strike2 period
	btfss	STATUS,Z			; when zero clear RA2
	goto	IN_DELAYS

; clear only if TOGGLE_2,0 is clear. When set the Strike2 is in toggle mode so clearing on
; timer ending is not required.
	btfss	TOGGLE_2,0
	bcf		PORTA,2

IN_DELAYS
; Input1 delay
	movf	INPUT1_DELAY,w
	btfss	STATUS,Z			; if zero do not decrease
	decf	INPUT1_DELAY,f
; Input2 delay
	movf	INPUT2_DELAY,w
	btfss	STATUS,Z			; if zero do not decrease
	decf	INPUT2_DELAY,f
; Alarm delay
	movf	ENTRY_TIMER,w		; entry timer delay
	btfss	STATUS,Z
	decf	ENTRY_TIMER,f
	movf	ENTRY_TIMER,w
	btfss	STATUS,Z
	goto	ALTERNATE_VALUES	
; when zero set alarm if alarm_set flag set
	btfss	ALARM_SET,0
	goto	ALTERNATE_VALUES
	bsf		PORTB,1				; alarm on after the entry delay

ALTERNATE_VALUES
	incf	ALTERNATE,f
	btfsc	ALTERNATE,0			; alternate for A/D Ch0/1
	goto	CH_1

; decrease Alarm period (0.52s/value)
	movf	ENTRY_TIMER,w		; entry timer delay
	btfss	STATUS,Z			; decrease alarm period after entry timer has expired
	goto	CH_0
	movf	ALARM_PERIOD,w
	btfss	STATUS,Z
	decf	ALARM_PERIOD,f
	movf	ALARM_PERIOD,w	; alarm period
	btfsc	STATUS,Z		; when zero clear RB1
	bcf		PORTB,1
	clrf	ALARM_SET		; alarm flag

; A/D conversion
; Channel 0 A/D value
CH_0
	movlw	B'01000000'	; Fosc, channel 0 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	TRIMPOT_0			; 
	movlw	B'01001000'	; Fosc, channel 1 ready for next reading
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	goto	FLSH_LED

; Channel 1 A/D value
CH_1
	movlw	B'01001000'	; Fosc, channel 1 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on
	call	ACQUIRE_AD
	movf	ADRESH,w
	movwf	TRIMPOT_1			; 
	movlw	B'01000000'	; Fosc, channel 0 ready for next reading
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

; add slow flashing ARM LED here for entry delay indication
FLSH_LED
	movf	ARM,w
	xorlw	D'00'
	btfsc	STATUS,Z	; if zero disarmed so bypass LED
	goto 	ARM_LED_OFF
	
; flash LED while both INPUT1_DELAY and INPUT2_DELAY are not zero or ENTRY_TIMER not zero

	movf	ENTRY_TIMER,w
	btfss	STATUS,Z
	goto	FLS_ARM

	movf	INPUT1_DELAY,w
	btfss	STATUS,Z	; if not zero flash
	goto	FLS_ARM

	movf	INPUT2_DELAY,w
	btfss	STATUS,Z	; if not zero flash
	goto	FLS_ARM

	bsf		PORTA_FLSH,4; PORTA,4 flashing; input delays finished so arm LED momentary flash
	goto	RECLAIM
FLS_ARM
	bcf		PORTA_FLSH,4
	btfsc	PORTA,4		; if on, set off; if off, set on
	goto	ARM_LED_OFF
	bsf		PORTA,4
	goto	RECLAIM
ARM_LED_OFF
	bcf		PORTA,4		; disarm so ARM LED off
	bcf		PORTA_FLSH,4

; end of interrupt reclaim w and status 
RECLAIM
	movf	PCLATH_STO,w; restore PCLATH	
	movwf	PCLATH
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt
 
; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return
  	            

 end
