;Raypac gas spa heater controller
;software vers 1.0 final
;clive Allan - cstallan@bigpond.com
;9/10/2007

;symbol defs
;ouputs
symbol disclk=0	'display driver clock
symbol disres=1	'display driver reset
symbol dislat=2	'display latch reg to output
symbol gasrel=3	'gas regulator power relay
symbol tempds=4	'display showing set temp
symbol fltled=5	'fault led 
symbol pumpon=6	'water pressure on
symbol gas =7	'gas regulator on
;inputs
symbol tsetup =input0	'temperature set (up)
symbol temsen=input1	'data line from temp sensor
symbol tsetdn =input2	'temperature set (down)
symbol watron=input6	'detects water pumps on (pressure in line)
symbol notus1=input7	'not in use

;variables

symbol vlowset = 20   	;set low point for temp adjust
symbol vhihset = 40	;set high point for temp adjust

;				*the following are offsets to set temp
;				*they determine cycle range for heating/cooling
symbol vlowpot = 1	;determines when heating cycle restarts
symbol vhihpot = 1 	;determines when heating cycle stops

;registers


;************************************

;b10 is used as the main status register for all subroutines

;0 0 0 0 0 0 0 0
;| | | | | | | |_fault
;| | | | | | |___gas on
;| | | | | |_____pressure detected
;| | | | |_______reserved
;| | | |_________reserved
;| | |___________reserved
;| |_____________reserved
;|_______________reserved
;

;b0=local temp reg 
;b1=local temp reg 	
;b2=local temp store 
;b3=local temp store 
;b9=localtempstore
;b11=value to be displayed
;b12=set temp store 
;b13=temp sensor storage
 



;initialising routine
;clear display
;load temp sense value from eprom to working reg

main: gosub init
main1:gosub temp
	let b11=b13 	'load current temp for display
	gosub displ
	gosub press		'check water pressure
	gosub setemp 	'test for set temp command
	gosub temstat	'test heating cycle
	gosub gascall	'gas control & fault set
	goto main1

init:	high 1
	low 1 
	low 2
	eeprom 0,(vlowset)'preload set temp value to lowest value
	return
	
;SUBROUTINE:temp	
;			temp.reads temp sensor.
;			sets fault flag if out of range

temp: readtemp temsen,b13
	if b13<=0 then temer
	goto temrt
temer:b13=0				'force value to zero
	let b10=b10 | %00000001	'set fault flag
	goto tempout 
temrt:let b10=b10 & %11111110	'reset fault flag
tempout:	return

;SUBROUTINE displ 
;			display value held in B13 (actual/set temp)  
;			if b13=0 special load to offset counter

displ:if b11=0 then dis0	'clear display - show 00
	for b1=1 to b11
	high disclk			'pulse dsiply river clk
	low disclk
	next b1
dis0:	high dislat			'load value into display
	low dislat
	high disres			'clear dsiplay counter
	low disres			'ready for next display	
	return

;SUBROUTINE pres
;			tests for water pressure, ie pump on.
;			changes flag to suit

press: b9=watron
	 if b9=0 then peslow	;no water pressure detected
	 pause 20			;debounce
	 b10=b10|%00000100	;set pressure detected flag
	 high pumpon		;turn on pump on led
	 goto pressout		;get out
peslow:b10=b10 & %11111011	;clear flag
	 low pumpon			;turn led off
pressout: return


;SUBROUTINE setemp
;			tests for tsetup /tsetdn switch closure
;			shows current "SET temp as long as switch is closed
;			looks for release,if repressed within 1 sec inc/dec setting
;			no activity for 2 secs store value in EPROM 
;			return to main program

setemp: b2=tsetup
	  b3=tsetdn
	  if b2=0 and b3=0 then stout	;neither switch closed return
	  pause 50				;one switch must be closed debounce then load current setting
	  high tempds			;turn on set tem led
	  b0=0
	  read b0,b11			;load value from eprom
	  
	  gosub displ			;display value
contd:  b2=tsetup
	  b3=tsetdn
	  if b2=0 and b3=0 then setr1	;switch release
	  pause 50
	  goto contd			;keep testing for switch release
setr1:  pause 100
	  for b0=1 to 255			;start 2 sec timing for adjustment
setrel: b2=tsetup
	  b3=tsetdn
	  if b2<>0 then incount
	  if b3<>0 then decount
	  pause 10
	  next b0
	  goto setout			;cleanup, getout
incount:b11=b11+1				;increment settemp
	  b9=vhihset
	  b9=b9+1
	  if b11=b9  then setig1	;test for higher limit
	  gosub displ			;display new value
	  pause 100
	  goto setrel			;look for another press
setig1: b11=vhihset			;load limit
	  goto setrel
decount:b11=b11-1				;increment settemp
	  b9=vlowset
	  b9=b9-1
	  if b11=b9 then setig2	;test for higher limit
	  gosub displ			;display new value
	  pause 100
	  goto setrel			;look for another press
setig2: b11=vlowset			;load limit
	  goto setrel	  
setout: b0=0
	  write b0,b11			;load new tempset value into EEPROM
stout:  low tempds			;turn off led
						;load tempset reg with value
	  return
	  
;SUBROUTINE temstat
;			compares value of actual and set temperature
;			need to confirm is it heating or cooling cycle
;			if on (heating cycle) check against hipot
;			if off (cooling cycle) check against lowpot
;			hipot & lowpot determine hysterisis 
	 
temstat: read b0,b12
	   let b9=b10 & %00000010		'get gas status
         if b9=%00000010 then temup 	'heating cycle
	   b9=b12-vlowpot 			'must be cooling cycle
	   if b13>b9 then temout 		'do nothing - still cooling
	   b10=b10|%00000010			'set heat on request	   	
	   goto temout
	   
temup:   b9=b12+vhihpot
	   if b13<b9 then temout		'do nothing get out
	   b10=b10&%11111101			'setheat request off
temout:  return	   
		 

;SUROUTINE gascall	
;			turns gas regulator on / off 
;			checks fault register - if set always turns gas off
;			checks water pressure - if clear always turn gas off

gascall: 
	   let b9=b10 & %00000001		;if fault on stop	
	   if b9=%00000001 then gasflt	;set fault
	   let b9=b10 & %00000100		;check water pressure
	   if b9=%00000000 then gascool	;no pressure, always cool
	   let b9=b10 & %00000010		;test call gas flag
	   if b9=%00000000 then gascool	;cool cycle
	   high gas
	   high gasrel					;heat cycle
	   low fltled
	   goto gasrt 
gasflt:  high fltled				;turn on fault led
	   low gas
	   low gasrel	
	   goto gasrt
gascool: low gas
	   low gasrel
	   low fltled	   
gasrt:   return
	   













