'     Battery discharger and voltage logger with transfer of data to pc capability
'	
'	Using Picaxe-28X, EEPROM and MAX 232
'
'	See accompanying circuit diagram for pinouts
'
' 	By Peter Shooter 2004, revisted 2007
'
symbol 	startpb = pin7		'start p/button to initiate logging or data transfer
symbol	modesw = pin1		'=1 means pow sw on transfer mode. =0 for logging
symbol	bt1dischd = bit0		'discharge of this battery complete
symbol	bt2dischd = bit1		'discharge of this battery complete
symbol	bt3dischd = bit2		'discharge of this battery complete
symbol	bt4dischd = bit3		'discharge of this battery complete
symbol	lastrun = bit4		'last logging run
symbol	lastlogb1= bit5		'last log of this batt to get val after stop discharge
symbol	lastlogb2= bit6		'last log of this batt to get val after stop discharge
symbol	lastlogb3= bit7		'last log of this batt to get val after stop discharge
symbol	lastlogb4= bit8		'last log of this batt to get val after stop discharge
symbol	fstlog= bit9		'first logging to record value before discharging
symbol	logndis=bit10		'logging in progress


initialise:	pause 500		'allow lcd to initialise
		high 6		'write protect eeprom
		if modesw =1 then transfer	'select mode of operation =0: stay with loging
		b0=0	b1=0	b2=0	b3=0	b4=0 b8=0	b9=0	b10=0	b11=0	
		w2=8			'w2 is first eeprom storage location for each cycle
		w6=0			'w6 is location data is written to	
	
control:
		if b2 =60 then resetb2	'to reset secs count to 0 NORMALLY 60 for log every 60 secs
		goto batt1:

resetb2:	let b2=0		'seconds count to zero
			
	'****read the analog values, process them, then display and write to eeprom****

batt1:
	
	readadc 0,b6		'read battery 1 analog input0 to b6
	let w3=b6*200		'convert analog values to milli-volts
	let w3=w3/10		'w3 is this batt's mvolts for this cycle
	serout 7,N2400, (254,128,"1:",#w3,"     ")	'send to LCD
	if fstlog=1 then goto batt2	'on the first pass just want initial voltage
	if b2 <> 0 then testbatt1	'if b2 not =0 test batt,if b2(time in seconds)=0 log values
	w6=w2				'get storage location for this cycle
	low 6				'write enable
	i2cslave %10100000, i2cfast, i2cword	'set block parameters
	writei2c w6,(b6,b7)	'write to location with both bytes of battery voltage
	pause 10			'takes time to write to the EEPROM
	high 6			'write protect
	if bt1dischd =1 then testbatt1	'if battery has drained dn to set volts stop count
	b11=b11+1	'increment the batt1 minute counter 

testbatt1:	if startpb =1 and w3>900 then batt1on	'start p/b pressed & HI batt volts >900mv
	if w3 >900 then batt2    'if volts still >900mv then stay on & goto next batt
	if lastlogb1=1 and b2=0 then batt1off	'one more log to show min volts	
	let lastlogb1=1		'last cycle bit to rec min volt on next log run before off load	
	goto batt2
batt1off:	low 1			'must have been <900 so turn off load
	let bt1dischd =1		'set discharged bit to one
	goto batt2
batt1on:	high 1		'turn on discharge relay and set discharged bit off
	let bt1dischd  =0
'-------------------------------------------
batt2:
	readadc 1,b6		'read battery 2 analog input
	let w3=b6*200		'convert analog values to milli-volts
	let w3=w3/10		'w3 is this batt's mvolts for this cycle
	serout 7,N2400, (254,137,"2:",#w3,"    ")		'send to LCD
	if fstlog=1 then goto batt3		'on the first pass just want initial voltage

 	if b2 <> 0 then testbatt2
	w6=w2+2			'storage location for this batt is 2 up on first battery

	low 6				'write enable
	i2cslave %10100000, i2cfast, i2cword	'set block parameters
	writei2c w6,(b6,b7)	'write to location with both bytes of battery voltage
	pause 10
	high 6			'write protect

	if bt2dischd=1 then testbatt2	'if battery has drained down to set volts stop counting 
	b8=b8+1	'increment the batt2 minute counter
testbatt2:if startpb=1 and w3>900 then batt2on	'start p/b pressed & HI batt volts i.e. >900mv
	if w3 >900 then batt3
	if lastlogb2=1 and b2=0 then batt2off	'one more log to show min volts	
	let lastlogb2=1		'last cycle bit to rec min volt on next log run before off load	
	goto batt3
batt2off:	low 2
	let bt2dischd=1
	goto batt3
batt2on:	high 2
	let bt2dischd =0
	goto batt3
'----------------------------------------------
batt3:
	readadc 2,b6		'read battery 3 analog input
	let w3=b6*200
	let w3=w3/10
	serout 7,N2400, (254,192,"3:",#w3,"     ")		'set up serial for LCD
	if fstlog=1 then goto batt4		'on the first pass just want initial voltage

	if b2 <> 0 then testbatt3
	w6=w2+4			'storage location for this batt is 4 up on first battery
	low 6				'write enable
	i2cslave %10100000, i2cfast, i2cword	'set block 0 parameters
	writei2c w6,(b6,b7)	'write to location with both bytes of battery voltage
	pause 10
	high 6			'write protect

	if bt3dischd=1 then testbatt3	'if battery has drained down to set volts stop counting 
	b9=b9+1			'increment the batt3 minute counter

testbatt3:	if startpb=1 and w3>900 then batt3on
	if w3 >900 then batt4
	if lastlogb3=1 and b2=0 then batt3off	'one more log to show min volts	
	let lastlogb3=1		'last cycle bit to rec min volt on next log run before off load	
	goto batt4
batt3off:	low 3
	let bt3dischd=1
	goto batt4

batt3on:	high 3
	let bt3dischd =0
'------------------------------------------------
batt4:
	readadc 3,b6		'read battery 4 analog input
	let w3=b6*200
	let w3=w3/10
	serout 7,N2400, (254,201,"4:",#w3,"     ")		'set up serial for LCD	
	if fstlog=1 then goto done		'on the first pass just want initial voltage

	if b2 <> 0 then testbatt4
	w6=w2+6			'storage location for this batt is 6 up on first battery
	low 6				'write enable
	i2cslave %10100000, i2cfast, i2cword	'set block parameters
	writei2c w6,(b6,b7)	'write to location with both bytes of battery voltage
	pause 10
	high 6			'write protect

	if bt4dischd=1 then testbatt4	'if battery has drained down to set volts stop counting 
	b10=b10+1			'increment the batt4 minute counter

testbatt4:if startpb=1 and w3>900 then batt4on
	if w3 >900  or  b10=0 then done
	if lastlogb4=1 and b2=0 then batt4off	'one more log to show min volts	
	let lastlogb4=1		'last cycle bit to rec min volt on next log run before off load	
	goto done
batt4off:	low 4
	let bt4dischd=1
	goto done	
batt4on:	high 4	
	let bt4dischd =0

done:	if logndis=1 then goto go_on
	let fstlog =1
	if startpb=1 or fstlog=0 then goto go_on
	goto control		'back to the start again
	
go_on:let  logndis=1
	let fstlog =0
	if lastrun=1 and b2=0 then complete
	
	low 0				'keep "complete" LED off
	if bt1dischd =1 and bt2dischd=1 and bt3dischd=1 and bt4dischd=1  then lastcycle	
						'i.e. all disch bits are high
	goto final		
lastcycle:	let lastrun=1
	goto final	

complete:				'stop logging because the batteries have all discharged
	high 0			'turn on "complete" LED		
	serout 7,N2400, (254,128,"bt1:",#b11,"   ",254,135," bt2:",#b8,"   ")	'disp disch times
	serout 7,N2400, (254,192,"bt3:",#b9,"   ",254,199," bt4:",#b10,"   ")	'disp disch times
	w2=w6				'last store position was value of w6, put this in w2
	w6=0				'prepare to store last store position value in location 0
	low 6				'write enable
	i2cslave %10100000, i2cfast, i2cword	'set block parameters
	writei2c 0,(b4,b5)  	'write to loc 0 with last storage point to assist transfer later	
				  	'this is so trans prog can find end point of data to stop transfer
	pause 10
	writei2c 4,(b11,b8,b9,b10)  	'write to loc 4...etc with disch times for lcd display later 
						'in transfer mode	
	pause 10
	high 6			'write protect & end here- don't want to keep writing to eeprom!!
	end

	'final check that mem/time capabilities have not been exceeded and increments the timing

final:	if b11=254 or b8=254 or b9=254 or b10=254 or w2>2500then stoppall 'limit time/mem
	pause 1000			'10 EQUALS .01 SECOND PAUSE 1000= 1 second  ********************
	if b2=0 then incrmins	'when seconds count has gone full 60 then go increment minutes
	b2=b2+1			'increment seconds
	if lastrun=0 then goto control
quick:	b2=0
	goto control		'back to the start again

incrmins:	w2=w2+8		'increment eeprom base storage location-8 bytes per cycle
	b2=b2+1			'increment the seconds count
	goto control

stoppall:				'stop because the memory is full or 254 minutes elapsed
	serout 7,N2400, (254,128,"mem full/time up    ")	'set up serial for LCD
	serout 7,N2400, (254,192,"                ")		'set up serial for LCD
	let b6=88
	w2=w6				'last store position
	low 6				'write enable
	i2cslave %10100000, i2cfast, i2cword	'set block  parameters
	writei2c 0,(b4,b5)	'write to location 0...etc with last store position
	pause 10
	high 6			'write protect
	low 1				'turn off all discharging because memory full
	low 2
	low 3
	low 4

flasher:
	high 0			'flash "complete" LED for memory full- an unlikely event!
	pause 100
	low 0
	pause 100
	goto flasher
	end


		'********transfer of data to pc terminal program**********
			'set terminal speed to 4800, no parity, 1 stop bit.
			'when pc ready press start to initiate transfer
transfer:
	high 6		'make sure we are write protecting!!!
	serout 7,N2400, (254,128,"start to transf ")		'send to LCD
	serout 7,N2400, (254,192,"hold for times  ")		'sent to LCD
	w4=0
	w5=0
	
controler:	if startpb=0  then controler	'no presses then wait
		if startpb=1 then timer		
		if startpb=0  then controler
timer:	pause 1000				'look for press length: short = transfer, lng=display

		if startpb=1 then display	'display times from last logging
		goto main				'if not still pressed then go on to transfer data

display:    'reads values from 1st 4 logged bytes and displays discharge times

	i2cslave %10100000, i2cfast, i2cword	'set block parameters
	readi2c 4,(b4,b5,b6,b7)	'read from this loc with values to b4,b5,b6 etc
	serout 7,N2400, (254,128,"bt1:",#b4,"   ",254,135," bt2:",#b5,"   ")	'disp times
	serout 7,N2400, (254,192,"bt3:",#b6,"   ",254,199," bt4:",#b7,"   ")	'disp disch times
	pause 1000
	if startpb=1 then main		'if pressed again then transfer data	
	goto display

main:	'here we transfer the data to the PC

	i2cslave %10100000, i2cfast, i2cword	'set block parameters for EEPROM
	readi2c 4,(b4,b5,b6,b7)				'read from this location (4) with values 
								'to b4,b5,b6 etc

	serout 5,T4800,("1",LF)				'sending 1 and line feed initiates the 
								'transfer protocol. Found without it a random 
								'character would be sent first. This works!! 
	serout 5,T4800,(#b4,",",#b5,",",#b6,",",#b7,LF)	'send values read to pc with line feed 
						'at the end to do a carriage return and give us lines of
						'four values each. These values are the discharge times- 
						'they appear at the head of the transfer to the PC

main2:	i2cslave %10100000, i2cfast, i2cword	'set block parameters
	readi2c w4,(b4,b5,b6,b7,b10,b11,b12,b13)	'read from this loc (given by w4's value)
								'with values to b4,b5,b6 etc loc 0,1 holds  
								'voltages logged

	serout 7,N2400, (254,128,"DATA TRANSFERING")		'display on LCD this message
	serout 7,N2400, (254,192,"reading: ",#w4,"      ")	'display on LCD current EEPROM 
										'location being read from
	if w4>7 then second	'if already read first line of data go to second We had to 
					'process that first line to extract the final data location
					'only the info in b4,b5 was needed but the process is et up to 
					'continue reading the subsequent data.
	let w1=w2			'transfer value from w2 (obtained from initial reading of EEPROM
					'locations 0 and 1 just done, and values put in b4,b5) to w1
	w1=w1/8
	w1=w1*8			'filter it to get value of last line of battery voltages logged
					'this represents the end point of logging & so last location to 
					'retrieve data from
	w4=w4+8			'increment read location by 8

	goto main2
			'all reads from now on are battery voltages
second:
	serout 5,T4800,(#w2,",",#w3,",",#w5,",",#w6,LF)	'send values read to pc with a line feed
									'also note each piece of data is  
									'seperated (or "delimitted") by a comma:
									'important for bringing it into Excel
	if w4>=w1 then nuf	'check if final line read yet
	if w4>2500 then nuf	'default endpoint in case no endpoint specified
	w4=w4+8			'increment read location by 8 each cycle
	goto main2

nuf:	serout 7,N2400, (254,128,"transfer complete")	'send complete message to LCD
	serout 7,N2400, (254,192,"last read ",#w4,"      ")		'send last read loc to LCD
	high 0			'complete LED on

	end





















