; Relay Transmitter using UHF transmitter module

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

	
; bank 0 RAM 

ONOFF			equ	H'20'	; pump on or off flag	
TEMP			equ	H'21'	; temporary working register
STORE1			equ	H'22'	; delay counter	
STORE2			equ	H'23'	; delay counter
STORE3			equ	H'24'	; delay counter

; start at memory 0

	org		0			; reset vector

MAIN
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	H'FF'		; port B inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00000000'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled) timer 0/ 256
	movwf	OPTION_REG
	movlw	B'000000000'; digital inputs
	movwf	ANSEL
	movlw	B'01101000'	; 0110 for 4MHz
	movwf	OSCCON		; 
	bcf		STATUS,RP0	; select memory bank 0

; initial conditions
	movlw	B'00000010'	; port A low, LED off
	movwf	PORTA	
	clrf	ONOFF		; on/off flag

; catch S2 closed if pressed
	bcf		PORTA,4		; shunt RA4 to ground
	call	DELAY		; debounce S2
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,4		; port A4 an input
	bcf		STATUS,RP0	; bank 0
	nop					; time to rise
	btfsc	PORTA,4		; if bit 4 is set set bit 0 for on/off flag
	bsf		ONOFF,0
; test again
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,4		; port A4 an output
	bcf		STATUS,RP0	; bank 0
	bcf		PORTA,4		; shunt RA4 to ground
	call	DELAY		; debounce S2
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,4		; port A2 an input
	bcf		STATUS,RP0	; bank 0
	nop					; time to rise
	btfsc	PORTA,4		; if bit 4 is set set bit 0 for on/off flag
	bsf		ONOFF,0
; test again
	bsf		STATUS,RP0	; select memory bank 1
	bcf		TRISA,4		; port A4 an output
	bcf		STATUS,RP0	; bank 0
	bcf		PORTA,4		; shunt RA4 to ground
	call	DELAY		; debounce S2
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,4		; port A2 an input
	bcf		STATUS,RP0	; bank 0
	nop					; time to rise
	btfsc	PORTA,4		; if bit 4 is set set bit 0 for on/off flag
	bsf		ONOFF,0
; set RA4 low
	bcf		PORTA,4

; test RA2
; catch S1 closed if pressed
	bcf		PORTA,2		; shunt RA2 to ground
	call	DELAY		; debounce S1
	bsf		STATUS,RP0	; select memory bank 1
	bsf		TRISA,2		; port A2 an input
	bcf		STATUS,RP0	; bank 0
	nop					; time to rise
	btfsc	PORTA,2		; if bit 2 is set check ONOFF
	goto	TEST_ON		; if both high error
; check for inputs (RA2 and RA4) both low
	btfss	ONOFF,0		; set when RA4 is set
	goto	ERROR_FLSH	; both RA2 and 4 low
	goto	PWR_LATCH
TEST_ON
	btfsc	ONOFF,0
	goto	ERROR_FLSH	; both RA4 and RA2 high
PWR_LATCH
; latch power on
	bsf		PORTA,7		; power on latch
	bcf		PORTA,1		; led on

; Send Data

; start bits with gap for locking to data rate, encode value, tank number
; onoff code and stop bits

; find encode
	clrf	TEMP		; initially clear
	btfss	PORTB,7		; set bits in TEMP if inputs are clear
	bsf		TEMP,6
	btfss	PORTB,6
	bsf		TEMP,5
	btfss	PORTB,5
	bsf		TEMP,7
	btfss	PORTB,4
	bsf		TEMP,4

; find pump No.
	
	btfss	PORTB,0		; set bits in TEMP if inputs are clear
	bsf		TEMP,1
	btfss	PORTB,1
	bsf		TEMP,2
	btfss	PORTB,2
	bsf		TEMP,0
	btfss	PORTB,3
	bsf		TEMP,3

SEND_DATA
; start bits with gap for locking to data rate

; send out a 1 to engage the receiver

	bsf		PORTA,0		; send a 1
	movlw	D'100'		; 50 ms
	call	DELAYXX		; ms
	bcf		PORTA,0		; send a zero
	movlw	D'10'		; 5 ms 
	call	DELAYXX		; ms

; send a reference gap

	bsf		PORTA,0		; a 1
	movlw	D'32'		; 16ms 
	call	DELAYXX		; extra length
	bcf		PORTA,0		; a 0		
	call	DELAY1

; start sending data
; encode and tank 
; 8-bits
	movf	TEMP,w		; send encode as ms nibble
	call	ROLL_8		; send out 

; pump off code
; 8-bits
	movlw	D'162'		; pump on
	btfsc	ONOFF,0		; if bit is clear, send an on signal, if bit is set an off
	movlw	D'150'		; send a pump off 
	call	ROLL_8
; stop bits
; 8-bits
	movlw	D'204'		; send stop bits (code for pump)
	call	ROLL_8
OUT_XM
; transmit ended
	bcf		PORTA,0		; transmit input low
	bcf		PORTA,7		; power on latch off
	bsf		PORTA,1		; transmit LED off
ENDED
	goto	ENDED

; flash LED 3x when an error
ERROR_FLSH
	bsf		PORTA,7		; power on latch
	bcf		PORTA,1		; LED on
	movlw	D'255'		; 122ms
	call	DELAYXX
	movlw	D'255'		; 122ms
	call	DELAYXX
	bsf		PORTA,1		; LED off
	movlw	D'255'		; 122ms
	call	DELAYXX
	movlw	D'255'		; 122ms
	call	DELAYXX
	bcf		PORTA,1		; LED on
	movlw	D'255'		; 122ms
	call	DELAYXX
	movlw	D'255'		; 122ms
	call	DELAYXX
	bsf		PORTA,1		; LED off
	movlw	D'255'		; 122ms
	call	DELAYXX
	movlw	D'255'		; 122ms
	call	DELAYXX
	bcf		PORTA,1		; LED on
	movlw	D'255'		; 122ms
	call	DELAYXX
	movlw	D'255'		; 122ms
	call	DELAYXX
	goto	OUT_XM
; ********************************************************************************
	
; subroutines
; send out 8-bits
ROLL_8
	movwf	TEMP
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	return
SET_OUT
	btfss	STATUS,C	; if set send a 1
	goto	CLR_4
	bsf		PORTA,0
	call	DELAY1
	return
CLR_4	
	bcf		PORTA,0
	call	DELAY1
	return

; delay loops
DELAY
	movlw	D'10'		; 5 ms
	goto	DELAYXX		; ms

DELAY1
	movlw	D'2'		; delay value
DELAYXX
	movwf	STORE1		; STORE1 is number of loops value
LOOPA	
	movlw	D'165'
	movwf	STORE2		; STORE2 is internal loop value	
LOOPB
	decfsz	STORE2,f
	goto	LOOPB
	decfsz	STORE1,f
	goto	LOOPA		; decrease till STORE1 is zero
	return


	end
