
 
; (UHF mains switch)
; can be used as Water Tank Pump Control receiver 

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO
;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; EEPROM locations

EEPROM1			equ	H'00'	; non-volatile storage for on flag
	
; bank 0 RAM 
TIMEOUTH		equ	H'20'	; timeout counter ms byte
TIMEOUTL		equ	H'21'	; timeout counter ms byte
TEMP_M			equ	H'22'	; temporary register 
FLAG1			equ	H'23'	; interrupt flag with timer 2
TIMEOUT			equ	H'24'	; timeout counter
SW_FLAG			equ	H'25'	; switch closed flag
TRANS_COUNT		equ	H'26'	; transmission counter	
STORE1			equ	H'27'	; delay counter	
STORE2			equ	H'28'	; delay counter
RECEIVE0		equ	H'29'	; received data
RECEIVE1		equ	H'2A'	; received data
TIMER1L_WK		equ	H'2B'	; timer 1 ls byte working register
TIMER1H_WK		equ	H'2C'	; timer 1 ms byte working register
TIMER1L_VAL		equ	H'2D'	; timer 1 ls byte working register
TIMER1H_VAL		equ	H'2E'	; timer 1 ms byte working register
TIMER1L_2		equ	H'2F'	; timer 1 /2 ls byte working register
TIMER1H_2		equ	H'30'	; timer 1 /2 lm byte working register
FLAG			equ	H'31'   ; interrupt flag with timer 1
COUNT_BITS		equ	H'32'	; data count bits
ENCODE			equ	H'33'	; encode value
RECEIVEX		equ	H'34'	; stop bits
CONVERSION		equ	H'35'	; A/D conversion counter
BROWN_FLG		equ	H'36'	; brownout flag
TIME_SW			equ	H'37'	; timeout switch
ON_FLAG			equ	H'38'	; relay on or off flag
TEMP			equ	H'39'	; temporary register
		
; All Banks RAM

W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt

	ORG     H'2100'

	DE		H'00'			; initially set relay off at powerup

; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN		; byte 1
	org     4			; interrupt vector
	goto	INTERRUPT

SW_TIMEOUTS
	addwf	PCL,f		; add value to program counter (67seconds per value)
	retlw	D'00'		; timeout 0, for no timeout
	retlw	D'01'		; 1 minute
	retlw	D'02'		; 2.25 minute
	retlw	D'04'		; 4.5 minute
	retlw	D'05'		; 5.5 minute
	retlw	D'06'		; 6.75 minute
	retlw	D'09'		; 10 minute
	retlw	D'14'		; 15.5 minute
	retlw	D'27'		; 30 minute
	retlw	D'40'		; 45 minute
	retlw	D'54'		; 60 minute, 1hr
	retlw	D'81'		; 90 minute, 1.5hr
	retlw	D'108'		; 120 minute, 2hr
	retlw	D'134'		; 150 minute, 2.5hr 
	retlw	D'161'		; 180 minute, 3hr
	retlw	D'215'		; 240 minutes, 4hr

INTERRUPT
; Interrupt
; start interrupt by saving w and status registers  
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
; page and banks	
	bcf		STATUS,RP0	; select memory bank 
	bcf		STATUS,RP1	; select memory bank 0

;Interrupt source
	btfss	PIR1,TMR1IF	; if timer 1 flag
	goto	TIME_2		; is it timer 2 
; preload timer
	bcf		T1CON,0		; timer 1 off	
	movf	TIMER1H_VAL,w
	addwf	TMR1H,f
	movf	TIMER1L_VAL,w
	addwf	TMR1L,f
	btfsc	STATUS,C
	incf	TMR1H,f		; increase ms byte if ls addition has carry
	bsf		T1CON,0		; timer 1 on
	bcf		PIR1,TMR1IF	; clear timer 1 overflow
	bsf		FLAG,0		; set flag bit to indicate an interrupt has occurred for data reception
	
TIME_2
	btfss	PIR1,TMR2IF
	goto	RECLAIM
; increase timers (~67s)
	bcf		PIR1,TMR2IF
	bsf		FLAG1,0		; set flag bit to indicate an interrupt has occurred for data reception
	incfsz	TIMEOUTL,f	; timeout counter ls byte
	goto	RECLAIM
	incfsz	TIMEOUTH,f	; timeout counter ms byte, when zero 65.536 seconds elapsed  between zeroes
	goto	RECLAIM

; each 67 seconds decrease timeout counters for each tank if selected
	movf	TIMEOUT,w	; timeout
	btfss	STATUS,Z	; if zero switch relay off
	goto	DEC_TIMEOUT	; decrease timeout
TURN_OFF
	movf	TIME_SW,w	; timeout switch
	btfsc	STATUS,Z	; if switch is set at zero, no timeout
	goto	RECLAIM
	bcf		ON_FLAG,0	; clear on flag
	bcf		PORTA,3		; pump off
	goto	RECLAIM
DEC_TIMEOUT
	decf	TIMEOUT,f	; decrease
	movf	TIMEOUT,w	; timeout
	btfsc	STATUS,Z	; if zero switch relay off
	goto	TURN_OFF	; turn off relay if timer set

; end of interrupt restore status and w 
RECLAIM
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;******************************************************************************************* 

MAIN
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	H'FF'		; port B inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'11110111'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled) timer 0/ 256
	movwf	OPTION_REG

	movlw	B'00000100'	; AN2 is an analog input
	movwf	ANSEL
	movlw	B'00000000'	; left justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PORTA,3		; relay off

	movlw	B'01010001'	; Fosc, channel 2 etc
	movwf	ADCON0

	bsf		ADCON0,ADON	; A/D on
	bsf		STATUS,RP0	; select memory bank 1

	movlw	B'01101000'	; 0110 for 4MHz
	movwf	OSCCON		; 
	bsf		PIE1,TMR1IE	; enable timer 1 interrupt
	bsf		PIE1,TMR2IE	; enable timer 2 interrupt
	bsf		INTCON,PEIE	; peripheral interrupt enable
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00011100'
	movwf	T2CON		; timer 2 on /4 or /1024 overall
 	movlw	H'FB'		; preload timer 1
	movwf	TIMER1H_VAL
	movwf	TMR1H
	movlw	H'FF'
	movwf	TIMER1L_VAL
	movwf	TMR1L
	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on	

	call	DELAYms		; add small delay

; if RA4 low then toggle bit 0 in EEPROM for relay on or off at power up.
	btfsc	PORTA,4
	goto	BY_CHANGE  		
	movlw	EEPROM1
	call	EEREAD		; read current setting
	movwf	TEMP		; temporary storage
	incf	TEMP,w		; next value to toggle bit 0
	call	EEWRITE		; rewrite

WAIT_OPEN
	call	SW_DELAY
	btfss	PORTA,4		; continue when switch is open
	goto	WAIT_OPEN

BY_CHANGE
; restore the on or off flag if power down
	bcf		ON_FLAG,0	; relay on flag set to off
	movlw	EEPROM1
	call	EEREAD		; read current setting
	movwf	TEMP		; temporary storage
	btfsc	TEMP,0		; if set, set on flag
	bsf		ON_FLAG,0
	bsf 	BROWN_FLG,0	; brownout flag set at startup. Cleared if no brownout 

; read timer switch setting
	clrf	TEMP_M		; switch value clear
	btfss	PORTA,0		; set bits according to switch setting 
	bsf		TEMP_M,0
    btfss	PORTA,7
	bsf		TEMP_M,1
	btfss	PORTA,1
	bsf		TEMP_M,2
	btfss	PORTA,6
	bsf		TEMP_M,3
	movf	TEMP_M,w
	call	SW_TIMEOUTS	; get timer value
	movwf	TIMEOUT		; preload timeout

; allow interrupts
ALL_INTERRUPTS
	bsf		STATUS,RP0	; select memory bank 1		
;	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bsf		PIE1,TMR2IE	; timer 2 match interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag
	bcf		PIR2,TMR2IF	; timer 2 interrupt flag	
	bsf		INTCON,PEIE	; enable periperal interrupts 	 
	bsf 	INTCON,GIE	; set global interrupt enable 

; check for a high at RA5
INPUT_SIG
	btfss	PORTA,5		; when high begin to read data
	goto	CHECK_BROWNOUT
	clrf	FLAG1		; 
	movlw	D'10'		; transmission counter
	movwf	TRANS_COUNT
TRANS_LOOP
	btfss	FLAG1,0		; count flags (set in interrupt) for a 10ms transmission from transmitter 
	goto	TRANS_LOOP
	btfss	PORTA,5		; check if still high
	goto	INPUT_SIG	; not high so out
	decfsz	TRANS_COUNT,f; count
	goto	QUIETING_LOOP
	goto	LOCK_START
QUIETING_LOOP
	clrf	FLAG1
	goto	TRANS_LOOP
	
LOCK_START
; use start bits to lock the transmission frequency

;	bcf		INTCON,GIE	; stop interrupt
	bsf		STATUS,RP0	; select memory bank 1		
	bcf		PIE1,TMR1IE	; stop timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0

	bcf		T1CON,0		; stop timer 1
	clrf	TMR1L		; clear timer 1
	clrf	TMR1H
	clrf	FLAG		; interrupt occurred flag
	bcf		PIR1,TMR1IF	; clear interrupt flag
	clrf	TMR0		; timer 0 cleared plus prescaler
	nop
	nop
	nop					; wait for timer0 to clear	
	bcf		INTCON,TMR0IF; clear timer 0 flag
	movlw	D'24'
	movwf	COUNT_BITS	; number of bits of data
	
; count with timer 1 for RA5 to go low, high, low corresponding to a 0,1 start bits

WAIT_LOW
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_BROWNOUT
	btfsc	PORTA,5		; wait till low 
	goto	WAIT_LOW

WAIT_HIGH
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_BROWNOUT
	btfss	PORTA,5		; wait for a high 
	goto	WAIT_HIGH

; start of 16ms reference period from transmitter
	bsf		T1CON,0		; timer1 on to count and check for overrange
WAIT_LOW1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_BROWNOUT
	btfsc	PORTA,5		; wait till low
	goto	WAIT_LOW1

; read timer 1 and divide by 16 to get the required timer 1 offset (take from FFFF to get preload value)
; if outside range then ignore. Typically should be 1024 but 2048 to 512 allowable

	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_BROWNOUT
	bcf		T1CON,0		; stop timer 1
	movf	TMR1L,w		; read timer 1
	movwf	TIMER1L_WK	; working registers
	movf	TMR1H,w
	movwf	TIMER1H_WK

; divide by 16 to get average count between each edge
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /2
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /4
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /8
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /16

; compare with over range/under range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111110'		; 512 and greater
	btfsc	STATUS,Z		; if zero then value too small 
	goto	CHECK_BROWNOUT	; value off range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111000'		; 2048 and greater
	btfss	STATUS,Z		; if not zero then value too large 
	goto	CHECK_BROWNOUT

; take from FFFF to get preset for interrupt rate	
	movf	TIMER1H_WK,w	; ms byte
	sublw	H'FF'			; maximum
	movwf	TIMER1H_VAL
	movf	TIMER1L_WK,w	; ls byte
	sublw	H'FF'			; maximum
	movwf	TIMER1L_VAL
	btfss	STATUS,C		; if carry reduce ms byte
	decf	TIMER1H_VAL,f

; add compensation for preload losses

	movlw	D'7'			; compensate for loss during preloading at interrupt
	addwf	TIMER1L_VAL,f	; add compensation
	btfsc	STATUS,C
	incf	TIMER1H_VAL,f	; if overrange increase ms byte

; preload counter 1 to sync with transmission rate 
	movf	TIMER1H_VAL,w
	movwf	TMR1H
	movf	TIMER1L_VAL,w
	movwf	TMR1L
	clrf	FLAG		; clear flag
	bsf		T1CON,0		; timer1 on start count	

	bsf		STATUS,RP0	; select memory bank 1		
	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt restart
	bcf		STATUS,RP0	; select memory bank 0
;	bsf		INTCON,GIE	; allow interrupts

; wait for one interrupt interval
WAIT_FLG_R
	btfss	FLAG,0
	goto	WAIT_FLG_R
	clrf	FLAG

; wait for 1/2 interrupt interval to centre measurement of level on high or low transmission

; calculate 1/2 interval
	bcf		STATUS,C	; carry cleared
	rrf		TIMER1H_WK,w	; divide by 2
	movwf	TIMER1H_2	; place in secondary register
	rrf		TIMER1L_WK,w
	movwf	TIMER1L_2
	
; take from FFFF to get shift in time to read data centred on a 1 or 0 value
	bcf		INTCON,GIE	; stop interrupts
	bcf		T1CON,0		; stop timer 1

	movf	TIMER1H_2,w	; ms byte
	sublw	H'FF'		; maximum
	movwf	TMR1H
	movf	TIMER1L_2,w	; ls byte
	sublw	H'FF'		; maximum
	movwf	TMR1L
	btfss	STATUS,C	; if carry reduce ms byte
	decf	TMR1H,f

	bcf		PIR1,TMR1IF	; clear interrupt flag
	bsf		T1CON,0		; run timer 1
	clrf	FLAG
	bsf		INTCON,GIE	; allow interrupts

; start of data
; shift into RECEIVE
WAIT_FLG3
	btfss	FLAG,0		; wait for interrupt flag change
	goto	WAIT_FLG3

	clrf	FLAG		; clear interrupt flag
	bcf		STATUS,C	; clear carry 
	btfsc	PORTA,5		; check level
	bsf		STATUS,C	; set carry when portA,5 is set
	rlf		RECEIVEX,f	; stop bits value
	rlf		RECEIVE0,f	; tank on or off signal
	rlf		RECEIVE1,f	; tank/ encode

	decfsz	COUNT_BITS,f
	goto	WAIT_FLG3	; continue loading bits

; check stop bits
	movf	RECEIVEX,w	; check if stops bits are correct
	xorlw	D'204'		; must be for pump control
	btfss	STATUS,Z	; if status is zero value is correct
	goto	CHECK_BROWNOUT 

; check encode (ms bits in RECEIVE1)
; encoded at rotary BCD switch (PORTB4-7) 
	clrf	ENCODE
	btfss	PORTB,6		; if clear set bit 4
	bsf		ENCODE,5	; ls bit of encode
	btfss	PORTB,4		; if clear set bit 5
	bsf		ENCODE,4	; mid bit of encode
	btfss	PORTB,5		; if clear set bit 6
	bsf		ENCODE,7	; mid bit of encode
	btfss	PORTB,7		; if clear set bit 7
	bsf		ENCODE,6	; ms bit of encode

; check tank (ls bits in RECEIVE1)
; encoded at rotary BCD switch (PORTB0-3)place in ls bits of encode 
	btfss	PORTB,0		; if clear set bit 1
	bsf		ENCODE,1	; ls bit of encode
	btfss	PORTB,1		; if clear set bit 2
	bsf		ENCODE,2	; mid bit of encode
	btfss	PORTB,2		; if clear set bit 0
	bsf		ENCODE,0	; mid bit of encode
	btfss	PORTB,3		; if clear set bit 3
	bsf		ENCODE,3	; ms bit of encode

; received encode must equal switch encode
	movf	RECEIVE1,w	; encoder/tank No.
	xorwf	ENCODE,w
	btfss	STATUS,Z
	goto	CHECK_BROWNOUT

; check tank on/off signal
	movf	RECEIVE0,w	; on/off
	xorlw	D'162'		; on signal
	btfsc	STATUS,Z
	goto	ON_PUMP		; equal so turn pump on
; check off signal
	movf	RECEIVE0,w
	xorlw	D'150'		; off signal
	btfsc	STATUS,Z
	goto	OFF_PUMP	; equal so turn pump off
	goto	CHECK_BROWNOUT; not equal so bypass

ON_PUMP
; if brown out do not switch on
	btfss	BROWN_FLG,0	; brownout flag if set do not switch on
	goto	ON_PUMP_SW
	bcf		PORTA,3		; ensure pump is off
	goto	CHECK_BROWNOUT
ON_PUMP_SW
; if going from off to on set timer
	btfsc	PORTA,3		; if was off set timer
	goto	CONTINUE
	bcf		INTCON,GIE	; stop interrupts
	movf	TIME_SW,w
	call	SW_TIMEOUTS	; get timer value
	movwf	TIMEOUT
	clrf	TIMEOUTL	; timeout counter ls byte
	clrf	TIMEOUTH	; clear timers
	bsf		INTCON,GIE
CONTINUE
	btfsc	BROWN_FLG,0	; if brownout flag is set then switch off RA3
	goto	OFF_PUMP1	; not on
	bsf		PORTA,3		; relay on
	bsf		ON_FLAG,0
	goto	CHECK_BROWNOUT
OFF_PUMP
	bcf		ON_FLAG,0
OFF_PUMP1
	bcf		PORTA,3		; pump off

; ***************************************************************************	
CHECK_BROWNOUT
; check brownout, timeout etc

; read timer switch
	
	clrf	TEMP_M		; switch value clear
	btfss	PORTA,0		; set bits according to switch setting 
	bsf		TEMP_M,0
    btfss	PORTA,7
	bsf		TEMP_M,1
	btfss	PORTA,1
	bsf		TEMP_M,2
	btfss	PORTA,6
	bsf		TEMP_M,3
	movf	TEMP_M,w
	movwf	TIME_SW		; new time switch value
	
	bsf		STATUS,RP0	; select memory bank 1		
	bcf		PIE1,TMR1IE	; timer 1 overflow interrupt off
	bcf		STATUS,RP0	; select memory bank 0
	bsf		INTCON,GIE	; if timer 0 timed out restart interrupt

; run A/D for AN2 for brown out. Off below 200VAC on again at 220VAC
CH_2AD ; mains voltage measure for brownout detection
	bcf		ADCON0,3
	bsf		ADCON0,4	; channel 2
	call	ACQUIRE_AD	; convert
	movf	ADRESH,w
	
; check for over 220VAC under 200VAC
	sublw	D'136'		; if over 220VAC switch brownout flag off
	btfss	STATUS,C
	goto	BROWN_OFF
	movf	ADRESH,w
	sublw	D'100'		; if under 100 (200VAC) switch brownout flag on
	btfss	STATUS,C
	goto	BROWN_BY 	; no change
; brownout
; for brownout set flag BROWN_FLG,0
	bsf		BROWN_FLG,0	; set brownout flag
	bcf		PORTA,3		; relay off on brownout
	goto	BROWN_BY

; with brownout off, clear flag (also keep clear or set RA3 according to ON_FLAG)
; need to switch on relay if it was on before the brownout (ON_FLAG,0 set) 
BROWN_OFF
	bcf		BROWN_FLG,0
	btfsc	ON_FLAG,0	; check if was on before brownout

	bsf		PORTA,3		; was on so switch back on

BROWN_BY
; check external switch RA4 if low tank/on/off (on and off as per transmitter control)
	btfsc	PORTA,4		; switch input if low closed
	goto	INPUT_SIG
	call	DELAYms		; delay for debounce
	btfsc	PORTA,4		; switch input if still low
	goto	INPUT_SIG
; switch closed
SW_CLOSED
	btfsc	ON_FLAG,0	; if pump was on switch off
	goto	OFF_PUMP_SW	
	btfsc	BROWN_FLG,0	; if brownout then switch off RA3
	goto	OFF_PUMP2
; switch relay on
; preload counters
	bcf		INTCON,GIE
	movf	TIME_SW,w
	call	SW_TIMEOUTS	; get timer value
	movwf	TIMEOUT
	clrf	TIMEOUTL	; timeout counter ls byte
	clrf	TIMEOUTH	; clear timers
	bsf		INTCON,GIE

	bsf		PORTA,3		; relay on
	bsf		ON_FLAG,0
	goto	WAIT_OPEN1	

OFF_PUMP_SW
	bcf		ON_FLAG,0
OFF_PUMP2
	bcf		PORTA,3		; pump off
WAIT_OPEN1
	call	SW_DELAY
	btfss	PORTA,4		; wait til high (off)
	goto	WAIT_OPEN1	; switch closed so wait til open
	goto	INPUT_SIG	; switch open so continue with program

; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

; Subroutines

; switch delay
SW_DELAY 
	movlw	D'80'
	movwf	SW_FLAG
SW_LOOP
	call	DELAYms
	decfsz	SW_FLAG,f	; decrease til zero
	goto	SW_LOOP
	return

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

ACQUIRE_AD
; wait for >20us
	movlw	D'100'
	movwf	CONVERSION
LOOP_CONV
	decfsz	CONVERSION,f	; decrease 
	goto	LOOP_CONV	
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP0	; select bank 0
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 	STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
;	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 

	end
