;****************************************************************************
;*		Floating Point to ASCII
;*
;* INPUT: 32 bit floating point number in AEXP, AARGB0, AARGB1, AARGB2
;*        For this example, the number must be between 0.000 and 9.999.
;*        (You can easily change the number range to suit your needs.)
;*
;* OUTPUT: ones, tenths, hundredths, thousandths (ASCII digit in each)
;*         
;*
;* USED: INDF,FSR,AARG,BARG,REMB,digit_count
;*
;* PROCEDURE: The floating point number in AARG is multiplied by 1000.
;*            Then the product is divided by 10 three times.  After each
;*            divide, the remainder is kept.  
;*
;*            After each digit is obtained, 30H is added to it to make it
;*            an ASCII representation of that number.  Then, the ASCII
;*            value is stored in register RAM at the locations specified
;*            in the "cblock."      
;*
;*	Note: The ASCII decimal point is not generated by this routine.
;*            You must output the decimal point in the correct decimal
;*            position for your application.  For this example, the
;*            decimal point is after the first digit: ones.
;*            
;* The following files are needed for this routine to function.
;*  p16c74a.inc		-- or any other midrange processor include file 
;*                         include the processor file in your "main" file
;*
;*  math16.inc          -- constant and variable definitions for 
;*                         AN575 floating point routines and
;*                         AN617 fixed point routines, both are used
;*                         in this float to ASCII routine
;*                         "include" this file in your "main" program
;*
;*  fxd26.a16 		-- fixed point 32/16 divide, included at the end
;*                         of this routine.
;*
;*  fp32.a16		-- 32 bit float to 32 bit integer conversion 
;*                         included at the end of this program. 
;* 
;****************************************************************************


;RAM Register Definitions       Your "main" program must have a "cblock"
                                ;directive with a RAM address so the 
                                ;following "cblock" will be located in RAM

      cblock                    ;reserve four bytes of data RAM for 
        ones                    ;each digit        
        tenths        
        hundredths        
        thousandths              
      
      endc

last_digit set thousandths

      cblock
        digit_count             ;counter used to cycle through each digit 
      endc


SIG_FIG equ     4               ;set SIG_FIG equal to the number of 
                                ;significant figures in your decimal number
                                ;for example: ones, tenths,hundredths, 
                                ;thousandths, requires 4 sig figs

float_ascii3
; 3 figures before the decimal point
	movlw	0x82			; BARG=10 decimal (floating point)
	movwf	BEXP			; fprep.exe was used
	movlw	0x20			; floating point representation of 10
	movwf	BARGB0
	movlw	0x00
	movwf	BARGB1
	movlw	0x00
	movwf	BARGB2
	goto	float_ascii
float_ascii2
; 2 figures before the decimal point
	movlw	0x85			;BARG= 100 decimal (floating point)
	movwf 	BEXP            ;fprep.exe was used to get this
	movlw	0x48            ;floating point representation of 100
	movwf	BARGB0
	movlw	0x00
	movwf	BARGB1
	movlw	0X00
	movwf	BARGB2
float_ascii
	call	FPM32		;AARG = AARG * 1000
float_ascii4
	call	INT3232		;AARG  <--  INT( AARG )
	movlw	last_digit
	movwf	FSR		;pointer = address of smallest digit
	movlw	SIG_FIG         ;load counter with the number of
	movwf	digit_count     ;significant figures the decimal number	

flo_asclp
	clrf	BARGB0		;Make the divisor 10.  
	movlw	d'10'
	movwf	BARGB1

	call	FXD3216U	;divide (32 bit fixed) / 10 (to get remainder)
	
	movf	REMB1,w		;put remainder in w register
	movwf	INDF		;put number into appropriate digit position

	movlw	0x30
	addwf	INDF,f		;add 30H to decimal number to convert to ASCII

	decf	FSR,f		;move pointer to next digit 	

	decfsz	digit_count,f
	goto	flo_asclp

	return

        include "fxd26.a16"     ;fixed point 32/16 divide from AN617

        include "fp32.a16"      ;32 bit float routines
                                ;we are using FPM32 for 32 bit multiply
                                ;and INT3232 for 32-bit float to 32-bit int
                                ;conversion.  Routines are in AN575 


    

