//Tim Blythman
//July 2022
//Modified Phil Prosser for Volume Control
#include "io.h"

void ioinit(void){
    //RA5 = Rotary Encoder channel B, digital input, needs weak pullup
    //RA4 = Rotary Encoder channel A, digital input, needs weak pullup
    //RA3 = IR Receiver, digital input, external pullup exists, but set weak pullup
    //RA2 = SCLK output to PGA2311, digital output
    //RA1 = DATA output to PGA2311, digital output
    //RA0 = Chip Select (active low) output to PGA2311, digital output, idle high

    //NO ADC
    ADCON0=0;            //reset
    ADCON1= 0b11000000;  //Dont really care - but ...1=right align, 100=1/4 FOSC, 00=NA, 00=V+REF=VDD
    ADACT=0;             //no auto trigger    
    ADCON0bits.ADON=0;   //set off
    ANSELA = 0;
    
    //IO pins idle state
    TRISA5=1; //Rotary Encoder input B
    WPUA5=1;  //Weak pullup Rotary Encoder input B
    TRISA4=1; //Rotary Encoder input A
    WPUA4=1;  //Weak pullup Rotary Encoder input A
    TRISA3=1; //IR Receiver input 
    WPUA3=1;  //Weak pullup IR
    TRISA2=0; //SCLK output to PGA2311
    RA2 = 1; // init to hi
    TRISA1=0; //Data output to PGA2311
    RA1 = 0; // init to low
    TRISA0=0; //CS output to PGA2311
    RA2 = 1; // init to high - i.e. no selected
    //set these for I2C, control with TRIS
    LATA2=0;
    LATA1=1;  // helps with debug
    LATA0=1;  //CS is active Low
    
}


void Io_Check_Remote(void){
    //RA5 = Rotary Encoder channel B, digital input, needs weak pullup
    //RA4 = Rotary Encoder channel A, digital input, needs weak pullup
    //RA3 = IR Receiver, digital input, external pullup exists, but set weak pullup
    //RA2 = Test this input and see if it is pulled low for TV Channel
    //RA1 = Test this input and see if it is pulled low for SAT channel
    //RA0 = Chip Select (active low) output to PGA2311, digital output, idle high

    //NO ADC
    ADCON0=0;            //reset
    ADCON1= 0b11000000;  //Dont really care - but ...1=right align, 100=1/4 FOSC, 00=NA, 00=V+REF=VDD
    ADACT=0;             //no auto trigger    
    ADCON0bits.ADON=0;   //set off
    ANSELA = 0;
    
    //IO pins idle state
    TRISA5=1; //Rotary Encoder input B
    WPUA5=1;  //Weak pullup Rotary Encoder input B
    TRISA4=1; //Rotary Encoder input A
    WPUA4=1;  //Weak pullup Rotary Encoder input A
    TRISA3=1; //IR Receiver input 
    WPUA3=1;  //Weak pullup IR
    TRISA2=0; //SCLK output to PGA2311
    RA2 = 1; // init to hi

    /* just set these for now - real init will reset them after read the input type */
    TRISA1=1; //TV Channel select input - pull lot to set to TV
    WPUA1=1;  //Weak pullup for TV remote select
    TRISA0=1; //SAT remote select input - pull lot to set to SAT 
    WPUA0=1;  //Weak pullup SAT remote select

    RA2 = 1; // init to high - i.e. no selected
    //set these for I2C, control with TRIS
    LATA2=0;
    
}
