#include "util.h"
#include "flash.h"


void sleepDelay(void){                  //nominally 200ms for legible display updates
    WDTCONbits.PS=8;    //256ms nominal
    WDTCONbits.SEN=1;   //enable
    SLEEP();            //sleep
    NOP();              //ensure next instruction is executed
    WDTCONbits.SEN=0;   //disable
}

void loadVolFromFlash(void){            //custom wrapper for this program
    Volume_Data.Volume  = (int)(NVMimage[0] & 0xFF);      //load volume
    //validate
    // get rid of lower limit as valid from zero
    //    if(Volume_Val<VOLUME_VAL_LOWER){Volume_Val=VOLUME_VAL_LOWER;}
    if(Volume_Data.Volume >VOLUME_VAL_UPPER){Volume_Data.Volume =VOLUME_VAL_UPPER;}
    if(Volume_Data.Volume <VOLUME_VAL_LOWER){Volume_Data.Volume =VOLUME_VAL_LOWER;}
    
    Volume_Data.Source  = (int)(NVMimage[1] & 0xFF);      //load source
    if(Volume_Data.Source == 1)   /* this is the TV */
        Volume_Data.IR_Addr = Volume_Address_IR;
    else     /* else it is the RCVR */
        Volume_Data.IR_Addr = Volume_Address_IR_RCVR;
}

void loadRemCodeFromFlash(void){            //custom wrapper for this program
    Volume_Data.Volume  = (int)(NVMimage[0] & 0xFF); //load volume
    Volume_Data.Source  = (int)(NVMimage[1] & 0xFF); //load source
    Volume_Data.Check_Byte_0  = (int) (NVMimage[2]); //load source
    Volume_Data.Check_Byte_1  = (int)(NVMimage[3]);  //load source
    Volume_Data.Check_Byte_2  = (int)(NVMimage[4]);  //load source
    //validate
    // get rid of lower limit as valid from zero
    //    if(Volume_Val<VOLUME_VAL_LOWER){Volume_Val=VOLUME_VAL_LOWER;}
    if(Volume_Data.Volume >VOLUME_VAL_UPPER){Volume_Data.Volume =VOLUME_VAL_UPPER;}
    if(Volume_Data.Volume <VOLUME_VAL_LOWER){Volume_Data.Volume =VOLUME_VAL_LOWER;}
}

void SaveVolToFlash(void){              //custom wrapper for this program
    flashshadow[0]=(Volume_Data.Volume>>0)&0xFF;
    flashshadow[1]=(Volume_Data.Volume>>8)&0x0F;
    flashshadow[2]=(Volume_Data.Source>>0)&0xFF;
    flashshadow[3]=(Volume_Data.Source>>8)&0x0F;    
    flashshadow[4]=(Volume_Data.Check_Byte_0>>0)&0xFF;
    flashshadow[5]=(Volume_Data.Check_Byte_0>>8)&0x0F;    
    flashshadow[6]=(Volume_Data.Check_Byte_1>>0)&0xFF;
    flashshadow[7]=(Volume_Data.Check_Byte_1>>8)&0x0F;    
    flashshadow[8]=(Volume_Data.Check_Byte_2>>0)&0xFF;
    flashshadow[9]=(Volume_Data.Check_Byte_2>>8)&0x0F;    
    eraseflash(LAST_FLASH_PAGE);
    writeflash(LAST_FLASH_PAGE);
}


