;=======================================================================
;
;                    Frequency Response Sweep Oscillator
;                          (C) Jeremy Crook 2006
;
;=======================================================================

;-------------------------- DEVICE DIRECTIVES --------------------------

		DEVICE		SX28,OSCHS1,TURBO,CARRYX,SYNC,STACKX,OPTIONX,BOR42
		IRC_CAL		IRC_SLOW
		FREQ 	50_000_000


		RESET		Initialise




;------------------------------BANK 0 VARIABLES ------------------------------

		M_Cntr		EQU		$08	;frequency marker counter
		Table_pntr_L	EQU		$09	;points to frequency table being used
		Table_pntr_H	EQU		$0A
		Time_dly		EQU		$0B	;hold time delay for interrupt
			
		AccumL		EQU		$10	;24 bit accumulator
		AccumM		EQU		$11	;
		AccumH		EQU		$12	;;<-used to point into sine table
		FreqL		EQU		$13	;24 bit frequency register
		FreqM		EQU		$14	;
		FreqH		EQU		$15	;
		FreqT_Pntr	EQU		$16	;8 bit frequency table pointer.
		Bttn_Cntr		EQU		$17	;

		MaccumL		EQU		$18
		MaccumM	EQU		$19
		MaccumH	EQU		$1A
		MfreqL		EQU		$1B
		MfreqM		EQU		$1C
		MfreqH		EQU		$1D
		MfreqT_Pntr	EQU		$1E	;holds frequency marker value
		Bttn_Flgs		EQU		$1F	;holds previous state of buttons



		Delay_1		EQU		$B4	;for 5ms/div
		Delay_2		EQU		$69	;for 10ms/div


;---------------------------- DEBUG SETTINGS ---------------------------

		ORG	$000

;-----------------start of 0.2ms interrupt routine---------------------
;
;	MODE register points to sine table on entry
;	Mode register must point to sine table on exit
;
;	()Value fetched from table is added to frequency register
;	  This increases the frequency produced by the main output routine.
;	  At end of sweep everything is reset.
;	()Marker Buttons are read
;	()Marker frequency is updated
;	()Marker pointer is updated
;	()Trigger is generated
;
;----------------------------------------------------------------------

Interrupt

;----------------------check frequency range switch--------------------

		sb	ra.0			;select frequency range
		jmp	:fr_sel_0
		
		mov	Table_pntr_L,#F_Table1_L>>8	;range 1
		mov	Table_pntr_H,#F_Table1_H>>8
		jmp	:fr_sel_e
:fr_sel_0
		mov	Table_pntr_L,#F_Table2_L>>8	; range 2
		mov	Table_pntr_H,#F_Table2_H>>8
:fr_sel_e

;--------------------Fetch low and high frequency word------------------

		mov	M,Table_pntr_L			;Fetch low word
		mov	W,FreqT_Pntr			;

		iread					;
;M now contains lower nibble of FreqM and W contains FreqL

		mov	FreqL,W				;
		mov	FreqM,M				;

		mov	M,Table_pntr_H			;Fetch high word
		mov	W,FreqT_Pntr			;

		iread					;

;M now contains FreqH and W now contains Higher nibble of FreqM

		or	FreqM,W				;
		mov	FreqH,M				;

		inc	FreqT_Pntr			;

		snz					;test for overflow
		jmp	New_Sweep			;jump to new sweep

;-----------------------start of button reading routine---------------
;detect button press
Bttn_Start
		break
		sb	rb.0
		jmp	down_C
		sb	rb.1
		jmp	down_F
		sb	rb.2
		jmp	up_F
		sb	rb.3
		jmp	up_C
;;no button pressed: reset counter and flags
		jmp	Bttn_Rst
;;code to handle button presses for marker display
down_C		;coarse down frequency routine
		snb	Bttn_Flgs.0		;test for previouse button press
		jmp	down_C_1		;yes: decrement count
		jmp	down_C_0
down_C_1	mov	Bttn_Cntr,#$FF		;reset counter
		clrb	Bttn_Flgs.0		;clear flag(active low)
		jmp	Bttn_End			;end routine
down_C_0	dec	Bttn_Cntr			;decrement counter
		sz				;is counter zero?
		jmp	Bttn_End			;no: jump to end
		dec	MfreqT_Pntr		;yes:decrement frequency pointer 4 times
		dec	MfreqT_Pntr
		dec	MfreqT_Pntr
		dec	MfreqT_Pntr
		jmp	Bttn_Rst			;reset everything		
down_F		;fine down frequency routine
		snb	Bttn_Flgs.1
		jmp	down_F_1
		jmp	down_F_0
down_F_1	mov	Bttn_Cntr,#$FF
		clrb	Bttn_Flgs.1
		jmp	Bttn_End
down_F_0	dec	Bttn_Cntr
		sz
		jmp	Bttn_End
		dec	MfreqT_Pntr
		jmp	Bttn_Rst		
up_F		;fine up frequency routine
		snb	Bttn_Flgs.2
		jmp	up_F_1
		jmp	up_F_0
up_F_1		mov	Bttn_Cntr,#$FF
		clrb	Bttn_Flgs.2
		jmp	Bttn_End
up_F_0		dec	Bttn_Cntr
		sz
		jmp	Bttn_End
		inc	MfreqT_Pntr
		jmp	Bttn_Rst		
up_C		;coarse up frequency routine
		snb	Bttn_Flgs.3
		jmp	up_C_1
		jmp	up_C_0
up_C_1		mov	Bttn_Cntr,#$FF
		clrb	Bttn_Flgs.3
		jmp	Bttn_End
up_C_0		dec	Bttn_Cntr
		sz
		jmp	Bttn_End
		inc	MfreqT_Pntr
		inc	MfreqT_Pntr
		inc	MfreqT_Pntr
		inc	MfreqT_Pntr
		
;-----------------------reset counter and flags-----------------------
Bttn_Rst
		mov	Bttn_Cntr,#$FF		;reset counter
		setb	Bttn_Flgs.0		;reset down coarse
		setb	Bttn_Flgs.1		;reset down fine
		setb	Bttn_Flgs.2		;reset up fine
		setb	Bttn_Flgs.3		;reset up coarse
Bttn_End
;---------------------end of button reading routine-------------------

;------start of marker frequency output routine on rb.7---------------
;:fetch current marker value
		mov	M,Table_pntr_L		;1:Fetch low word
		mov	W,MFreqT_Pntr		;

		iread				;

;M now contains lower nibble of FreqM and W contains FreqL

		mov	MFreqL,W		;
		mov	MFreqM,M		;

		mov	M,Table_pntr_H		;1:Fetch high word
		mov	W,MFreqT_Pntr		;

		iread				;

;M now contains FreqH and W now contains Higher nibble of FreqM

		or	MFreqM,W		;
		mov	MFreqH,M		;

;:marker frequency value now in MFreqH.MfreqM.MfreqL

;------------------end of frequency marker output routine---------------

;-----start of frequency marker display rb.5 (ch2 on oscilloscope)------
;bttn_flgs.4=0 no marker being displayed so test counter
;bttn_flgs.4=1 marker displayed so clear marker


		sb	Bttn_Flgs.4
		jmp	tst_cntr			;bttn_flgs.4=0
		clrb	bttn_Flgs.4		;bttn_flgs.4=1
		clrb	rb.5
		jmp	F_M_end
tst_cntr
		stc	
		mov	W, M_Cntr		;is M_Cntr=MFreqT_Pntr
		mov	W,MFreqT_Pntr-W
		sz
		jmp	F_M_end			;no
		setb	rb.5			;yes
		setb	bttn_flgs.4
F_M_end
		inc	M_Cntr

;--------------end of frequency marker display-------------------------



;----------------start of trigger section. Output on rb.6---------------
; toggle trigger output based on state of FreqT_Pntr.7

		sb	FreqT_Pntr.7		;
		clrb	rb.6			;
		snb	FreqT_Pntr.7		;
		setb	rb.6			;

;---------------------end of trigger section----------------------------
	
		mov	M,#sine>>8		;point M to Sine table
		mov	W,#%10000110		;set RTCC interrupt
		mov	!OPTION,W		;

;---------------------check delay switch-----------------------------

		sb	ra.1			;select	time delay
		jmp	:td_sel_0
		mov	Time_dly,#delay_1		;ra.1 is 1
		jmp	:td_sel_e
:td_sel_0	mov	Time_dly,#delay_2			;ra.1 is 0
:td_sel_e

		mov	$01,Time_dly		;move count to RTCC

;----------------------------delay set-------------------------------

		reti				;



New_Sweep
		mov	FreqL,#$5A		;set start frequency
		mov	FreqM,#$00
		mov	FreqH,#$00

		clr	AccumL			;clear accumulator
		clr	AccumM
		clr	AccumH

		mov	M,#sine>>8		;point M to Sine table
		mov	W,#%10000110		;set RTCC interrupt
		mov	!OPTION,W		;

;--------------------------check delay switch----------------------

		sb	ra.1			;select	time delay
		jmp	:td_sel_0
		mov	Time_dly,#delay_1	;ra.1 is 1
		jmp	:td_sel_e
:td_sel_0	mov	Time_dly,#delay_2
:td_sel_e

		mov	$01,Time_dly		;move count to RTCC

;----------------------------delay set-------------------------------

		clr	M_Cntr

		reti
		


;-------------------End of interrupt------------------
		
Initialise
		jmp	@Main

;-----------------Start of tables----------------------

		ORG	$200
;-----------------Start of 256 element sine table------------------
Sine
	DW	$280,$283,$286,$289,$28c,$28f,$292,$295,$298,$29c,$29f,$2a2,$2a5,$2a8,$2ab,$2ae
	DW	$2b0,$2b3,$2b6,$2b9,$2bc,$2bf,$2c1,$2c4,$2c7,$2c9,$2cc,$2ce,$2d1,$2d3,$2d5,$2d8
	DW	$2da,$2dc,$2de,$2e0,$2e2,$2e4,$2e6,$2e8,$2ea,$2ec,$2ed,$2ef,$2f0,$2f2,$2f3,$2f5
	DW	$2f6,$2f7,$2f8,$2f9,$2fa,$2fb,$2fc,$2fc,$2fd,$2fe,$2fe,$2ff,$2ff,$2ff,$2ff,$2ff
	DW	$2ff,$2ff,$2ff,$2ff,$2ff,$2ff,$2fe,$2fe,$2fd,$2fc,$2fc,$2fb,$2fa,$2f9,$2f8,$2f7
	DW	$2f6,$2f5,$2f3,$2f2,$2f0,$2ef,$2ed,$2ec,$2ea,$2e8,$2e6,$2e4,$2e2,$2e0,$2de,$2dc
	DW	$2da,$2d8,$2d5,$2d3,$2d1,$2ce,$2cc,$2c9,$2c7,$2c4,$2c1,$2bf,$2bc,$2b9,$2b6,$2b3
	DW	$2b0,$2ae,$2ab,$2a8,$2a5,$2a2,$29f,$29c,$298,$295,$292,$28f,$28c,$289,$286,$283
	DW	$280,$27c,$279,$276,$273,$270,$26d,$26a,$267,$263,$260,$25d,$25a,$257,$254,$251
	DW	$24f,$24c,$249,$246,$243,$240,$23e,$23b,$238,$236,$233,$231,$22e,$22c,$22a,$227
	DW	$225,$223,$221,$21f,$21d,$21b,$219,$217,$215,$213,$212,$210,$20f,$20d,$20c,$20a
	DW	$209,$208,$207,$206,$205,$204,$203,$203,$202,$201,$201,$200,$200,$200,$200,$200
	DW	$200,$200,$200,$200,$200,$200,$201,$201,$202,$203,$203,$204,$205,$206,$207,$208
	DW	$209,$20a,$20c,$20d,$20f,$210,$212,$213,$215,$217,$219,$21b,$21d,$21f,$221,$223
	DW	$225,$227,$22a,$22c,$22e,$231,$233,$236,$238,$23b,$23e,$240,$243,$246,$249,$24c
	DW	$24f,$251,$254,$257,$25a,$25d,$260,$263,$267,$26a,$26d,$270,$273,$276,$279,$27c


;-----------------------------------Start of 2*2 word frequency tables-------------------------------
;
;	These values are added loaded in to the frequency register to produce the output frequency
;	in a logarithmic fashion leading to a proper frequency response display on the oscilloscope.
;	Table #1 spans from 100Hz to 100KHz in 50ms.
;	Table #2 spans from 50Hz to 15KHz in 50ms.
;-------------------------------------------------------------------------------------------------
		ORG	$300
F_Table1_L

	DW	$3A6,$3BF,$3DA,$3F5,$411,$42D,$44B,$469,$488,$4A8,$4C8,$4EA,$50C,$530,$554,$57A
	DW	$5A0,$5C8,$5F1,$61A,$645,$671,$69F,$6CD,$6FD,$72E,$760,$794,$7CA,$800,$839,$872
	DW	$8AE,$8EB,$929,$96A,$9AC,$9F0,$A36,$A7E,$AC7,$B13,$B61,$BB1,$C03,$C58,$CAE,$D08
	DW	$D63,$DC1,$E22,$E85,$EEB,$F54,$FC0,$02F,$0A1,$115,$18E,$209,$288,$30A,$390,$419
	DW	$4A7,$538,$5CD,$666,$704,$7A5,$84C,$8F6,$9A6,$A5A,$B13,$BD2,$C95,$D5E,$E2D,$F01
	DW	$FDB,$0BB,$1A1,$28D,$380,$47A,$57A,$681,$790,$8A6,$9C4,$AEA,$C17,$D4D,$E8C,$FD3
	DW	$123,$27C,$3DF,$54C,$6C3,$844,$9CF,$B65,$D07,$EB4,$06D,$232,$403,$5E1,$7CC,$9C5
	DW	$BCC,$DE0,$004,$236,$478,$6CA,$92C,$B9F,$E23,$0B9,$361,$61B,$8E9,$BCA,$EC0,$1CB
	DW	$4EB,$820,$B6D,$ED1,$24C,$5E0,$98D,$D54,$135,$532,$94B,$D81,$1D4,$645,$AD6,$F87
	DW	$459,$94D,$E63,$39E,$8FD,$E82,$42D,$A01,$FFD,$624,$C76,$2F4,$9A0,$07B,$786,$EC2
	DW	$631,$DD5,$5AE,$DBF,$608,$E8B,$74B,$047,$983,$300,$CC0,$6C4,$10E,$BA1,$67E,$1A7
	DW	$D1F,$8E8,$503,$174,$E3C,$B5E,$8DC,$6B9,$4F7,$39A,$2A3,$216,$1F6,$245,$307,$43F
	DW	$5F0,$81D,$ACA,$DFA,$1B1,$5F3,$AC3,$026,$61E,$CB1,$3E3,$BB8,$435,$D5D,$737,$1C6
	DW	$D10,$919,$5E8,$381,$1EB,$12A,$145,$241,$426,$6F8,$AC0,$F82,$548,$C17,$3F6,$CEE
	DW	$706,$246,$EB6,$C5E,$B47,$B7A,$D00,$FE2,$429,$9E1,$111,$9C6,$409,$FE6,$D68,$C9A
	DW	$D88,$03F,$4CA,$B38,$394,$DEE,$A52,$8CF,$973,$C4F,$171,$8E9,$2C9,$F20,$E00,$F7B

		ORG	$400

F_Table1_H		;value shifted left 4 binary places to simplify fetch routine

	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$010,$010,$010,$010,$010,$010,$010,$010,$010
	DW	$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010
	DW	$010,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020
	DW	$030,$030,$030,$030,$030,$030,$030,$030,$030,$030,$040,$040,$040,$040,$040,$040
	DW	$040,$040,$050,$050,$050,$050,$050,$050,$050,$060,$060,$060,$060,$060,$060,$070
	DW	$070,$070,$070,$070,$080,$080,$080,$080,$090,$090,$090,$090,$0A0,$0A0,$0A0,$0A0
	DW	$0B0,$0B0,$0B0,$0C0,$0C0,$0C0,$0D0,$0D0,$0D0,$0E0,$0E0,$0F0,$0F0,$100,$100,$100
	DW	$110,$110,$120,$120,$130,$130,$140,$150,$150,$160,$160,$170,$180,$180,$190,$1A0
	DW	$1A0,$1B0,$1C0,$1D0,$1D0,$1E0,$1F0,$200,$210,$220,$230,$240,$250,$260,$270,$280
	DW	$290,$2A0,$2B0,$2C0,$2E0,$2F0,$300,$320,$330,$340,$360,$370,$390,$3A0,$3C0,$3E0
	DW	$3F0,$410,$430,$450,$470,$490,$4B0,$4D0,$4F0,$510,$530,$550,$580,$5A0,$5D0,$5F0
	DW	$620,$650,$670,$6A0,$6D0,$700,$730,$760,$7A0,$7D0,$810,$840,$880,$8B0,$8F0,$930
	DW	$970,$9C0,$A00,$A40,$A90,$AD0,$B20,$B70,$BC0,$C10,$C70,$CC0,$D20,$D70,$DD0,$E30

		ORG	$500
F_Table2_L

	DW	$1D1,$1DB,$1E6,$1F1,$1FD,$208,$214,$220,$22D,$239,$246,$254,$261,$26F,$27D,$28C
	DW	$29B,$2AA,$2BA,$2CA,$2DA,$2EB,$2FC,$30D,$31F,$331,$344,$357,$36A,$37E,$393,$3A8
	DW	$3BD,$3D3,$3E9,$400,$417,$42F,$448,$461,$47A,$495,$4AF,$4CB,$4E7,$503,$521,$53F
	DW	$55D,$57D,$59D,$5BE,$5DF,$601,$624,$648,$66D,$693,$6B9,$6E0,$709,$732,$75C,$787
	DW	$7B3,$7E0,$80E,$83D,$86D,$89E,$8D1,$904,$939,$96F,$9A6,$9DE,$A18,$A53,$A8F,$ACD
	DW	$B0C,$B4D,$B8F,$BD2,$C17,$C5E,$CA6,$CF0,$D3C,$D89,$DD8,$E29,$E7C,$ED1,$F27,$F80
	DW	$FDA,$037,$096,$0F7,$15A,$1BF,$227,$291,$2FE,$36D,$3DE,$452,$4C9,$543,$5BF,$63E
	DW	$6C0,$745,$7CD,$858,$8E6,$978,$A0D,$AA5,$B41,$BE0,$C83,$D29,$DD4,$E82,$F35,$FEB
	DW	$0A5,$164,$227,$2EF,$3BB,$48C,$562,$63C,$71C,$800,$8EA,$9D9,$ACE,$BC8,$CC8,$DCE
	DW	$ED9,$FEB,$103,$222,$347,$472,$5A5,$6DE,$81F,$967,$AB7,$C0E,$D6D,$ED4,$043,$1BB
	DW	$33B,$4C4,$656,$7F1,$995,$B43,$CFB,$EBD,$089,$260,$441,$62E,$826,$A29,$C38,$E53
	DW	$07A,$2AE,$4EF,$73D,$998,$C01,$E78,$0FE,$393,$636,$8E9,$BAC,$E7E,$162,$456,$75B
	DW	$A73,$D9C,$0D7,$426,$788,$AFE,$E87,$226,$5DA,$9A3,$D83,$179,$586,$9AB,$DE8,$23E
	DW	$6AD,$B37,$FDA,$499,$974,$E6B,$37F,$8B0,$E00,$36F,$8FE,$EAE,$47E,$A71,$086,$6BF
	DW	$D1C,$39E,$A47,$116,$80D,$F2D,$677,$DEB,$58A,$D57,$550,$D79,$5D1,$E5A,$714,$002
	DW	$924,$27C,$C09,$5CF,$FCE,$A07,$47D,$F2F,$A1F,$550,$0C2,$C77,$870,$4B0,$137,$E07

		ORG	$600

F_Table2_H		;value shifted left 4 binary places to simplify fetch routine

	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000,$000
	DW	$000,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010
	DW	$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010,$010
	DW	$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020,$020
	DW	$020,$020,$030,$030,$030,$030,$030,$030,$030,$030,$030,$030,$030,$030,$040,$040
	DW	$040,$040,$040,$040,$040,$040,$040,$040,$050,$050,$050,$050,$050,$050,$050,$050
	DW	$060,$060,$060,$060,$060,$060,$060,$070,$070,$070,$070,$070,$070,$080,$080,$080
	DW	$080,$080,$090,$090,$090,$090,$090,$0A0,$0A0,$0A0,$0A0,$0B0,$0B0,$0B0,$0B0,$0C0
	DW	$0C0,$0C0,$0C0,$0D0,$0D0,$0D0,$0E0,$0E0,$0E0,$0F0,$0F0,$0F0,$100,$100,$110,$110
	DW	$110,$120,$120,$130,$130,$130,$140,$140,$150,$150,$160,$160,$170,$170,$180,$190
	DW	$190,$1A0,$1A0,$1B0,$1B0,$1C0,$1D0,$1D0,$1E0,$1F0,$200,$200,$210,$220,$230,$230

;------------------------- INITIALIZATION ROUTINE -------------------------

Main
;--------------------------------Configure port settings--------------------------
		mov	rc, #%00000000		;Port C output zero
		mov	!ra,#%11111111		;port A all pins are inputs
		mov	!rc,#%00000000		;Port C all pins are output dir.
		mov	!rb,#%00011111		;make rb.7 and rb.6 and rb.5 outputs

		mov	W,#%10000110		;set timer interrupt
		mov	!OPTION,W

		setb	Bttn_Flgs.0
		setb	Bttn_Flgs.1
		setb	Bttn_Flgs.2
		setb	Bttn_Flgs.3

;----------------------check frequency range switch------------------------

		sb	ra.0			;select frequency range
		jmp	:fr_sel_0
		
		mov	Table_pntr_L,#F_Table1_L>>8
		mov	Table_pntr_H,#F_Table1_H>>8
		jmp	:fr_sel_e
:fr_sel_0
		mov	Table_pntr_L,#F_Table2_L>>8
		mov	Table_pntr_H,#F_Table2_H>>8
:fr_sel_e

;-----------------------frequency range set----------------------

;-----------------------check delay switch-----------------------

		sb	ra.1			;select	time delay
		jmp	:td_sel_0
		mov	Time_dly,#delay_1		;50ms sweep
		jmp	:td_sel_e
:td_sel_0	mov	Time_dly,#delay_2			;100ms sweep
:td_sel_e	
;-----------------------end of switch routine--------------------

		mov	$01,Time_dly		;move count to RTCC

		clr	FreqL			;set start frequency
		clr	FreqM
		clr	FreqH

		clr	MfreqL			;set frequency
		clr	MfreqM
		clr	MfreqH

		clr	FreqT_Pntr		;set to start of frequency table

		clr	AccumL			;clear accumulator
		clr	AccumM
		clr	AccumH

		clr	MaccumL			;clear accumulator
		clr	MaccumM
		clr	MaccumH	

		clr	M_Cntr			;clear frequency marker counter
		clrb	Bttn_Flgs.4		;	

		mov	M,#sine>>8		;set M to start of sine table

;---------------------------Start of waveform output routine-----------------------------
;
; main routine outputs data to R2R AtoD converter using DDS algorithm
; marker frequency generated by testing for change in bit 7 of MaccumH
; and toggling output on rb.7
;
;---------------------------------------------------------------------------------------------------


Freq_Gen	

	
		clc				;
		mov	W,FreqL			; : Add freq register to accumulator
		add	AccumL,W		;
		mov	W,FreqM			;
		add	AccumM,W		;
		mov	W,FreqH			;
		add	AccumH,W		;

		mov	W,AccumH		; : Fetch byte from sine table
		iread				;

		mov	rc, W			; output value to port

		clc				;
		mov	W,MfreqL			; : Add freq register to accumulator
		add	MaccumL,W		;
		mov	W,MfreqM		;
		add	MaccumM,W		;
		mov	W,MfreqH		;
		add	MaccumH,W		;

		sb	MaccumH.7		; generate marker frequency
		clrb	rb.7			;
		snb	MaccumH.7		;
		setb	rb.7			;

		jmp	@Freq_Gen		;

;--------------------------------------------------------------------------------------------------------------------------------------
