;-------TVREMOTE2.ASM--------8Nov07--
	list	p=12f675
	__config	h'3fc4'
	radix	hex
;------------------------------------
;for sony tv
;timing doesn't need to be too precise
;uses 12f675 internal RC oscillator, 3 volts only
;interrupt from sleep on port change
;assymetrical square wave, 9 microsecs high, 16 microsecs low
;40 khz carrier signal
;sony protocol requires 2.4 msec start burst, then 0.6 msec gap,
;then 7 bit command, then 5 bit device address
;'one' is 1.2 msec burst, 'zero' is 0.6 msec burst
;0.6 msec gap between each bit 
;commands repeated every 45 msec
;LSB first for both command and address
;d '20' is mute, d '19' is vol down
;d '18' is vol up, d '21' is power
;d '01' is tv address
;commands repeat as long as button is held down
;except for mute that goes to power after 1 second
;------------------------------------
pc	equ	0x02
status	equ	0x03
gpio	equ	0x05
intcon	equ	0x0b
cmcon	equ	0x19
optreg	equ	0x81
trisio	equ	0x85
osccal	equ	0x90
ioc	equ	0x96
ansel	equ	0x9f
count1	equ	0x20
count2	equ	0x21
count3	equ	0x22
count4	equ	0x23
count5	equ	0x24
count6	equ	0x25
count7	equ	0x26
count8	equ	0x27
count9	equ	0x28
count10	equ	0x29
count11	equ	0x2a
;------------------------------------
c	equ	0
z	equ	2
rp0	equ	5
;------------------------------------
	org	0x000
;
start	bsf	status,rp0
	call 	3ffh
	movwf	osccal
	bcf	status,rp0
	movlw	b'00000111'
	movwf	cmcon	
	bsf	status,rp0
	clrf	ansel
	movlw	b'00011111'
	movwf	trisio
	movlw	b'10001000'
	movwf	optreg
	movlw	b'00011111'
	movwf	ioc
	bcf	status,rp0
	bsf	intcon,3
	bcf	intcon,7
;
zzz	movlw	0x60
	movwf	count1
	movlw	0x16
	movwf	count5
	bcf	gpio,5
	bcf	intcon,0
	sleep
	nop
	call	dbounce
ready	btfss	gpio,0
	goto	mute
	btfss	gpio,1
	goto	volup
	btfss	gpio,2
	goto	voldown
	goto	zzz
;------------------------------------
;sony tv remote
;------------------------------------
mute	call	block1		;start 2.4 msec burst	
	call	gap
	call 	block2		;command d'20' LSB first, 7 bit command
	call	gap
	call	block2
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block3		;address d'01' LSB first, 5 bit command
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	decfsz	count5,f
	goto 	delay
	goto	power
;------------------------------------
volup	call	block1		;start 2.4 msec burst	
	call	gap
	call 	block2		;command d'18' LSB first
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block3		;address d'01' LSB first
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	goto 	delay
;------------------------------------
voldown	call	block1		;start 2.4 msec burst	
	call	gap
	call 	block3		;command d'19' LSB first
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block3		;address d'01' LSB first
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	goto 	delay
;------------------------------------
power	call	block1		;start 2.4 msec burst	
	call	gap
	call 	block3		;command d'21' LSB first
	call	gap
	call	block2
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block3
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block3		;address d'01' LSB first
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	call	block2
	call	gap
	movlw	0x58		;gap to establish 45 msec start to start period
	movwf	count8		;for power command
load9	movlw	0x60
	movwf	count9
dec9	decfsz	count9,f
	goto	dec9
	decfsz	count8,f
	goto	load9
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	btfss	gpio,0
	goto	power
	goto	zzz
;------------------------------------
block1	bsf	gpio,5		;2.4 msec burst
	nop	
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	bcf	gpio,5
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	decfsz	count1,f
	goto	block1
	return
;------------------------------------
block2	bsf	gpio,5		;zero bit, 0.6 msec burst
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	bcf	gpio,5
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	decfsz	count2,f
	goto	block2	
	return
;------------------------------------
block3	bsf	gpio,5		;one bit, 1.2 msec burst
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	bcf	gpio,5
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	decfsz	count3,f
	goto	block3	
	return
;------------------------------------
gap	movlw	0x60		;0.6 msec gap
	movwf	count1
	movlw	0x18
	movwf	count2
	movlw	0x30
	movwf	count3
	movlw	0x1c
	movwf	count4
repeat	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	decfsz	count4,f
	goto	repeat
	return
;------------------------------------
delay	movlw	0x58		;gap to establish 45 msec start to start period
	movwf	count6
load7	movlw	0x60
	movwf	count7
dec7	decfsz	count7,f
	goto	dec7
	decfsz	count6,f
	goto	load7
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	goto	ready
;------------------------------------
dbounce	movlw	0x50		;20 msec debounce delay
	movwf	count10
load11	movlw	0x50
	movwf	count11
dec11	decfsz	count11,f
	goto	dec11
	decfsz	count10,f
	goto	load11
	return
;------------------------------------	
	end



		

