'     LED STROBE UNIT		16/6/2008
'
'	This program is presented to facilitate experimenting with a Picaxe to control the
'	flash rate of a 1 W LED. A MC34063 DC - DC converter takes care of controling the 
'	LED current and the Picaxe controls the strobe rate.
'	
'	This simple program is only the beginning and varying the duty cycle and range of flash 
'	are other options. Another option is to dispense with the MC34063 DC - DC converter
'	and directly flash the LED using a power transister driven by the Picaxe. This has 
'	the risk though of a programming error leading to the LED being supplied at too high
'	a current for too long. The DC - DC converter saves you that worry. 

'	Using Picaxe 08M to drive PWM output to control a DC - DC converter IC by applying 
'	a voltage to its feedback pin. Imposing a voltage to this pin reduces the drive out 
'	of the PWM controller and this reduces the light output. See accompanying circuit.
'
'	The Picaxe is used to strobe the LED with the strobe rate adjusted using a pot.
'
'	A small red LED is used as a power on/locator for when lamp is off.
'
'	**********CAUTION for some people certain strobe rates can induce epileptic fits 
'			or siezures. For some sensations of nausea can occur.*****************
'
'	IC Pin 1		VDD
'	IC Pin 2		SERIN-PROGRAMMING
'	IC Pin 3		PIN 4	FLED	indicator LED		
'	IC Pin 4		pin 3	PB	push button, N/O to 5v for ON	
'	IC Pin 5		pin 2		PWM output	via resistors to reference pin off MC
'	IC Pin 6		pin 1		ADC batttery voltage sense via voltage divider
'	IC Pin 7		pin 0		serpout to programmer
'	IC Pin 8		0V		supply ground
'
'	
symbol FLED=4				'indicator LED: flashes when off & indicates button press	
symbol PB=pin3				'control button
symbol LED=2				'Main LED- pin 2 can be on/off or PWM controlled	


initial:	high LED			'to hold LED off and wait for turn on input
		high FLED			'indicator LED on

		output 1			'out 1 high to hold switch off
		input 1			'configue pin 1 as input (to handle ADC function)
		if PB=1 then turnon	'start strobe
		goto initial		'if no on button then cycle till button pressed

turnon:	low LED			'go low so main LED on
		low FLED			'indicator LED off
		pause 300

flash:	readadc 1,b12		'read in analog value from pot to byte 12

		b12=b12/2			'divide by 2 to vary the span of the flash rate

		low LED			'output of Picaxe low=main LED on
		pause b12			'on time  
		high LED			'output of Picaxe high=main LED off
		pause b12			'off time
		if PB=1 then turnoff
		goto flash

turnoff:	high LED			'turnoff: where the Picaxe output is high so main LED off
		pause 500
		goto initial

end





