'     LED LIGHTING UNIT	CONTROL    ON-OFF, 3 LIGHT LEVELS, SUPPLY VOLTAGE MONITOR	
'
'	By Peter Shooter 15/6/2008
'
'	Using Picaxe 08M to drive PWM output to control a DC - DC converter IC by applying 
'	a voltage to its feedback pin. Imposing a voltage to this pin reduces the drive out 
'	of the PWM controller and this reduces the light output.
'
'	With inspiration from Silicon chip LED control unit May 2004 and ON Semiconductor 
'	datasheet and application note AND8117
'
'	Features: three light levels selected by succesive presses of the push button 
'	When the button has not been pressed for 1 second then the next press will turn unit off.
'	
'	When the battery voltage falls below a set point the LED, if on, will dim to save power.
'	If the battery voltage falls further the LED will go off to protect the battery.
'
'	If the supply voltage is low, in an emergency the button can be held down and after 
'	cycling through the levels the lamp will stay on at low level. 
'
'	A small red LED is used as a power on/locator for when lamp is off.
'
'	IC Pin 1		VDD
'	IC Pin 2		SERIN-PROGRAMMING
'	IC Pin 3		'PIN 4'		FLED	indicator LED		
'	IC Pin 4		'pin 3'		PB	push button, N/O, to 5v for ON	
'	IC Pin 5		'pin 2'		PWM output via resistors to reference pin off MC34063 
'	IC Pin 6		'pin 1'		ADC1 batttery voltage sense via voltage divider
'	IC Pin 7		'pin 0'		serpout to programmer
'	IC Pin 8		0V			supply ground
'
'	ADC input: 6.8k and 2.4k voltage divider input via 2.2k resister to ADC1 'pin 1' 
'	The ADC input is used to monitor the supply voltage
'
symbol FLED=4				'indicator LED: flashes when off & indicates button press	
symbol PB=pin3				'control button
symbol LED=2				'Main LED- pin 2 can be on/off or PWM controlled	
symbol LOWBIT=bit1			'control bit for low level
symbol MEDBIT=bit2			'control bit for med level
symbol HIBIT=bit3				'control bit for hi level
symbol LEDON=bit4				'control bit for LED on
symbol REPRESSDEL=bit5			'delay before next press turns off	
symbol EM=bit7				'In emergency on mode (low power)


initial:	output 1			'out 1 high to hold switch off
		input 1			'configue pin 1 as input (to handle ADC function)
		goto quickoff	

quickoff:	pwmout 2,0,0		'stop PWM function
		high LED			'drive output high to ensure LED full off
		let b13=0			'reset turn on timer
		let LOWBIT=0		'reset light level status bits
		let MEDBIT=0
		let HIBIT=0
		pause 500	
	
wereoff:	if PB=1 then select   	'if button pressed go to light level selection process

snooze:		'manage sleep mode to save pwr, wake up to be ready for button press,
			'and flash the locator LED

		low FLED			'indicator LED off
		nap 5				'nap 0.5 secs- low power use
		high FLED			'indicator LED on
		pause 10			'indicator LED on time 10mSec
		if PB=1 then select	'button pressed- demand for light on
		goto snooze			'and remain off

select:		'For the selection of light level or emergency on mode

		low FLED	
		let b13=0				'reset turnon timer
		if b11>12 then emerg		'if b11 > 12 then go to emergency on mode
		b11=b11+1				'b11 counts cycles when button held. After set 
							'numbers of cycle goes to emerg mode
		if LOWBIT=1 then medset		'if already low then go to medium
		if MEDBIT=1 then hiset		'if already medium then go to high
		if HIBIT=1 then lowset		'if already high then go to low 

lowset:	let w2=1000				'set pwm mark/space ratio for low light level
		let LOWBIT=1			'set low status bit
		let MEDBIT=0			'clear other status bits
		let HIBIT=0
		goto setdone

medset:	let w2=900				'set pwm mark/space ratio for medium light level
		let LOWBIT=0			'clear other status bits
		let MEDBIT=1			'set medium status bit
		let HIBIT=0				'clear other status bits
		goto setdone

hiset:	let w2=100				'set pwm mark/space ratio for high light level
		let LOWBIT=0			'clear other status bits
		let MEDBIT=0
		let HIBIT=1				'set high status bit
		goto setdone

emerg:	'if, in an emergency, you need the light on but the supply is below the cut off
		'then hold down the button till the light stays on at the low level, it will
		'continue to stay on indefinately.

		let w2=1000				'set pwm mark/space ratio for low light level
		let LOWBIT=1			'set low status bit
		let MEDBIT=0			'clear other status bits
		let HIBIT=0
		let EM=1				'set emergency bit on
		goto setdone

setdone:	pause 200				'pause to avoid contact bounce
		
ledrun:	if HIBIT=1 then fullon
		pwmout 2,255,w2			'write the pwm values
		goto	continue

fullon:	pwmout 2,0,0			'this turns off the pwm function
		low 2					'set output low- full intensity

continue:	pause 100
		if b13>10 then loop		'allow 10x pause 100 to elapse then permit turnoff
		let b13=b13+1			'allows you to set level before permitting turn off
		if PB=1 then select 		'once reached 10 counts then turn off permitted
		goto cycle

loop:		'read supply voltage and compare to reference.
		if PB=0 then checkv		'if button not pressed: check supply voltage	
		pause	100				'pause to check if EMI spike
		if PB=0 then checkv		'if button pressed: goto turnoff
		goto turnoff

checkv:	readadc 1,b12			'read in analog value
 		if b12>167  then cycle		'is supply volts above 12.5 ?
		pause 150				'pause in case of brief supply flick
		if b12>167 then cycle		're-examine supply
		HIBIT=0				'go to dimmest setting
		let w2 =1000			'if still below 12.5 then dim (also set in 'emerg')
		if b12>162  then cycle		'is supply volts above 12.2 ?
		pause 150				'pause in case of brief supply flick
		if b12>162 then cycle		'is supply volts above 12.2 ? If not goto dimmoff
		if EM=1 then cycle		'in emergency on mode so stay on dspite low volts
		goto turnoff			'go to dimming function and shut down
				
cycle:	goto	ledrun

turnoff:	pwmout 2,255,1000			'write the pwm value for turning off
		let EM=0				'reset emergency function
		b11=0
		goto quickoff
		end








