'     LED LIGHTING UNIT	CONTROL    DELAY OFF	
'
'	By Peter Shooter 15/6/2008
'
'	Program for control of LED 1W light using MC34063 DC - DC converter and 08M Picaxe.
'	With inspiration from Silicon chip LED control unit May 2004 and ON Semiconductor 
'	datasheet and application note AND8117
'
'	Originally designed for use over a camping group's wash trough where an auto-off
'	facility was important for power conservation.
'
'	The MC34063 is set up and the current adjusted without the Picaxe connected. The 
'	Picaxe is then programmed and connected to the feedback pin of the DC - DC converter 
'	and VR1 adjusted to ensure the LED is off when it should be- that is the PWM 
'	output on pin 5 of the Picaxe is full on.
'
'	When powered up the LED will briefly flash then remain off until the pushbutton is 
'	pressed for 3 seconds. At this point the PWM output of the Picaxe on pin 5 
'	will ramp down to fully off. 
'	This will leave the feedback to the MC34063 fully dependent on the current 
'	feeback from the LED, leaving the LED on. After 6 minutes the pin 5 
'	PWM output of the Picaxe will ramp up thereby overriding the feedback 
'	to the MC34063 unitl the LED is extinguished. It simulates the feedback from the led 
'	current sensing resister/opamp network feeding back that the led current is high, in 
'	turn the DC-DC converter reduces the output to the led.
'	This happens gradually to alert users that the light is about to go off. 
'	The LED is flicked briefly before going off as a final alert to users.
'	Before it goes fully off a press of the buton will bring it back to full brilliance 
'	for another 6 minutes. 
'	At any stage when the LED is on, a second press will reset the time to 6 minutes. 
'	A further press of the button will again extend the time, but now to 20 minutes.
'	The settings for the time durations can be change if longer times are desired.
'	The LED can be turned off by holding the button pressed for about 2 seconds.
'	When off a second smaller red LED will flash, serving as a locator beacon at night.
'	This LED also flashes when the button is pressed.
'	
'	IC Pin 1		VDD
'	IC Pin 2		SERIN-PROGRAMMING
'	IC Pin 3		'PIN 4'		FLED	indicator LED		
'	IC Pin 4		'pin 3'		PB	push button, N/O to 5v for ON	
'	IC Pin 5		'pin 2'		PWM output	via resistors to reference pin off MC
'	IC Pin 6		'pin 1'		not used
'	IC Pin 7		'pin 0'		serpout to programmer
'	IC Pin 8		 0V			supply ground


symbol	relite= bit0 			'set if during dimming off mode button pressed
symbol	pbutton= pin3			'the control button
symbol	timer= bit4				'
symbol	offquick= bit6			'set on turnoff command from button pressed
symbol	extend= bit5			'set on first extension of time

initial:	output 1				'out 1 high to hold LED off	
		goto intialoff

dimmoff:		'DIMMING phase, 	

		setint 00001000,00001000	'set interupt for p/button, interrupt when high
		pwmout 2,255,920			'PWM output period of 255 and duty cycle of 920
		pause 20000				'pause 20 seconds
		if relite=1 then relight	'test for relight desired
		pwmout 2,255,1000			'brief increase PWM duty cycle to create flick off
		pause 70				'to alert users that turnoff coming up
		pwmout 2,255,920			'back to previous PWM level after flick
		for b1=1 to 250			'further delay until turnoff, using 'for' routine
		pause 10				'so we can regularly check for a relight/ or continued
		if relite=1 then relight	'use desired signal
		next b1
quickoff:	
		offquick=0				'reset the offquick demand bit
		setint 00000000,00000000	'cancel interrupt function

intialoff:	high 2				
		pwmout 2,0,0			'stop PWM function so can change 2 to output
		high 2				'ensures full dim while sleeping when PWM stops

stayoff:		'sleep to save power, wake up every 2.3 secs to flash red LED and check 
			'if button pressed
			
		low 4					'flashing LED off
		sleep 1				'sleep 2.3 secs- low power use
		high 4				'flashing LED on
		pause 10				'flashing LED on time 10mSec
		if pbutton =1 then turnon		'button pressed
		goto stayoff			'and remain off

turnon:		'turn on gently

		for w1=950  to 100 step-1	'ramp down the duty cycle of the PWM output from 950
		pwmout 2,255,w1			'to 100 in smallsteps of 1 with 1 mSec pause between
		pause 1				'each decrement. So we get a gentler turnon than just
		next w1				'sharp on

relight:	pwmout 2,0,0			'go to no dimming-full on-turn off PWM
		low 2					'no output- LED current purely a function of feeback
		relite=0				'reset the relight instruction
		low 4					'flashing LED off

staybright:		'For when the light is on and running normally	
			'on time has three options-normal 6 minutes, can be reset for another 5
			'on the next button press is reset to 20 minutes.

		let timer=1				'set timer on
		setint 00001000,00001000	'enable interrupt
		b2=5					'normal time period b2=5 is 6 minutes  
		for b1=0 to b2			'cycle the minutes from 0 to the value in b2
		if offquick=1 then quickoff	'bit 6 (offquick) is turnoff instruction derived from 
							'interrupt routine
		pause 60000				'1 minute			
		if offquick=1 then quickoff	'if interrupt happens during the 1 min delay above
							'then this is first line processed & if the offquick
		next b1				'bit is set then we now goto the quickoff function
		setint 00000000,00000000	'disenable interrupt
		let extend=0			'reset the time extension function
		timer=0				'reset timer on bit now we are about to turn off
		goto dimmoff			'go to dimming function to shut down

	'******************INTERRUPT ROUTINE************************



interrupt:	high 4				'flashing LED on
		if timer=0 then relightoption	'in on timer tmode
		pause 1000				'test for brief press of button
		low 4					'flashing LED off
		if pbutton=1 then offoptions	'button still pressed so consider turnoff
		if extend=0 then extendonce	'=0 for first time round request for more time
		let b2=15				'must be 2nd "more time request" so extend to 15 min
extendonce:	let b1=0				'reset ontimer to 1
		let extend=1			'register one extension
		pause 500				'wait to clear contact bounce so don't re-interrupt
		setint 00001000,00001000	'set interrupt again ready for next time
		low 4
		return				'back to where we were before interrupt
offoptions:				
		let extend=0			'clear on time extension bit
		offquick=1				'set the off bit
		low 4
		return

relightoption:	
			let relite=1
			low 4
			return













