
; model train controller

; Information on RC-5 infra red transmission at end of file 


; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB3 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _XT_OSC

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; Define variables at memory locations
; EEPROM

EEPROM1		equ	H'00'	; non-volatile storage for MAX_SPEED0 ; maximum speed ms byte
EEPROM2		equ	H'01'	; non-volatile storage for MAX_SPEED1 ; maximum speed ls byte
EEPROM3		equ	H'02'	; non-volatile storage for MIN_SPEED0 ; minimum speed ms byte
EEPROM4		equ	H'03'	; non volatile storage for MIN_SPEED1 ; minimum speed ls byte
EEPROM5		equ	H'04'	; non volatile storage for LOCKOUT0	  ; lockout speed ms byte
EEPROM6		equ	H'05'	; non volatile storage for LOCKOUT1   ; lockout speed ls byte
EEPROM7		equ	H'06'	; non volatile storage for INERTIA	  ; inertia rate
EEPROM8		equ	H'07'	; non volatile storage for STOP_RATE  ; stop rate
EEPROM9		equ	H'08'	; non volatile storage for LOC_REMOTE ; local or remote control
EEPROMA		equ	H'09'	; non volatile storage for SPEED0 	  ; speed setting ms byte (desired setting)
EEPROMB		equ	H'0A'	; non volatile storage for SPEED1 	  ; speed setting ls byte
EEPROMC		equ	H'0B'	; non volatile storage for for/rev 	  ; forward/reverse
EEPROMD		equ	H'0C'	; non volatile storage for FEEDBACK	  ; feedback rate
EEPROME		equ	H'0D'	; non volatile storage for CODES	  ; remote control code
EEPROMF		equ	H'0E'	; non volatile storage for SPEED_CHNG ; speed change rate
EEPROMG		equ	H'0F'	; non volatile storage for PULSE	  ; PWM frequency
EEPROMH		equ	H'10'	; non volatile storage for SELECT	  ; Parameters selection
EEPROMI		equ	H'11'	; non volatile storage for REM_RATE	  ; remote control adjust rate
				
; RAM
; bank 0 
REMOTE_M	equ	H'20'	; remote control input ms byte
REMOTE_L	equ	H'21'	; remote control input LS byte
REM_FLG		equ	H'22'	; flag to indicate current remote control sequencing 
REM_CNT		equ	H'23'	; interrupt count for polling remote control signal
REM_COD		equ	H'24'	; remote control bit counter mode.
TOGGLE		equ	H'25'	; remote control toggle bit
BACK_EMF0	equ	H'26'	; back EMF ms
BACK_EMF1	equ	H'27'	; back EMF ls
DISPLAY		equ	H'28'	; display update flag
VALUE_1		equ	H'29'	; delay value
VALUE_2		equ	H'2A'	; delay value
TEMP_R		equ	H'2B'	; remote code temporary
SIGN		equ	H'2C'	; feedback sign value
MODE		equ	H'2D'	; display mode
D_STO		equ	H'2E'	; data store
STOP_OP		equ	H'2F'	; STOP in operation when bit 0 is clear
MAX_SPEED0	equ	H'30'	; maximum speed ms byte
MAX_SPEED1	equ	H'31'	; maximum speed ls byte
MIN_SPEED0	equ	H'32'	; minimum speed ms byte
MIN_SPEED1	equ	H'33'	; minimum speed ls byte
LOCKOUT0	equ	H'34'	; lockout speed ms byte
LOCKOUT1	equ	H'35'	; lockout speed ls byte
INERTIA		equ	H'36'	; inertia rate
STOP_RATE	equ	H'37'	; stop rate
SPEED0		equ	H'38'	; speed setting ms byte
SPEED1		equ	H'39'	; speed setting ls byte
FOR_REV		equ	H'3A'	; forward reverse setting
REM_RATE	equ	H'3B'	; interrupt rate toggle for remote control timing
OVERLOAD	equ	H'3C'	; overload
LOCK		equ	H'3D'	; lockout
BAR			equ	H'3E'	; spaces in bargraph
STORE1		equ	H'3F'	; delay counter
STORE2		equ	H'40'	; delay counter
STORE3		equ	H'41'	; delay counter
SPEEDX		equ	H'42'	; potentiometer speed setting ms byte
SPEEDY		equ	H'43'	; potentiometer speed setting ls byte
PULSE		equ	H'44'	; PWM frequency
TIMER0		equ	H'45'	; ms timer byte
TIMER1		equ	H'46'	; ls timer byte
SELECT		equ	H'47'	; parameters select on display
SPEED0_LST	equ	H'48'	; last speed value ms
SPEED1_LST	equ	H'49'	; last speed value ls
FEEDBACK	equ	H'4A'	; feedback control
RUN0		equ	H'4B'	; current speed ms (altered via inertia/stop rates)
RUN1		equ	H'4C'	; current speed ls
CODES		equ	H'4D'	; remote control code
SET_FLG		equ	H'4E'	; settings set flag
TIMER5		equ	H'4F'	; display update timer
INERTIA_CNT	equ	H'50'	; inertia counter
STOP_CNT	equ	H'51'	; stop counter
SPEED_CHNG	equ	H'52'	; speed change rate
TEMPS		equ	H'53'	; speed change counter
TEMPI0		equ	H'54'	; temporary Interrupt use
TEMPI1		equ	H'55'	; temporary Interrupt use
TIMERX		equ	H'56'	; remote code repeat timer
SET0		equ	H'57'	; settings value to display ms byte
SET1		equ	H'58'	; settings value to display ls byte
	
; math routines
TEMP0		equ	H'5A'	; temporary
BIN_0		equ	H'5B'	; 8-bit binary value
TEMP		equ	H'5C'	; data storage 
CNT_8		equ	H'5D'	; counter in BCD routine
OUT1		equ	H'5E'	; ASCII byte
OUT2		equ	H'5F'	; ASCII byte
OUT3		equ	H'60'	; ASCII byte
REMB0		equ	H'61'	; remainder
REMB1		equ	H'62'
BCD_0		equ	H'63'	; MS bcd value
BCD_1		equ	H'64'	; LS binary coded decimal value
TEMP1		equ H'65'	; temporary
TEMPD		equ	H'66'
AARGB3		equ	H'67'	; ls of argument A
AARGB2      equ H'68'
AARGB1      equ H'69'
AARGB0      equ H'6A'	; most significant byte of argument A
TEMPB1      equ H'6B'	; temporary
TEMPB0      equ H'6C'
BARGB1      equ H'6D'	; 
BARGB0      equ H'6E'	; most significant byte of argument B
LOOPCOUNT   equ H'6F'  	; loop counter

; all banks ram
W_TMP		equ	H'70'	; temporary store for w in interrupt
STATUS_TMP	equ	H'71'	; temporary store of status in interrupt 
PCLATH_STO	equ	H'72'	; PC lath storage
LOC_REM		equ	H'73'	; local or remote control
FEEDCONT0	equ	H'74'	; feedback control value
FEEDCONT1	equ	H'75'	; feedback control value
TEMPIX0		equ	H'76'	; temporary Interrupt use
TEMPIX1		equ	H'77'	; temporary	Interrupt use
REM_READY	equ	H'78'	; remote control ready flag
REMOTE_LOW	equ	H'79'	; remote control data
REMOTE_HIGH	equ	H'7A'	; remote control data
REM_LOW_L	equ H'7B'	; user remote control data
REM_HIGH_M 	equ H'7C'	; user remote control data
REM_STO		equ	H'7D'	; remote code storage
REM_STO1	equ	H'7E'	; remote code storage
	
; preprogram EEPROM DATA 
	
 	ORG     H'2100'
 	DE		H'02'		; maximum speed ms (equivalent to 12V with 17V PWM)
	DE 		H'D3'		; 	"		"   ls
	DE 		H'00'		; min speed ms
	DE		H'05'		;  "	"   ls
	DE		H'00'		; lockout ms
	DE 		H'20'		; 	"	  ls
	DE 		H'0A'		; inertia
	DE		H'05'		; stop rate
	DE		H'01'		; local / remote
	DE 		H'01'		; default  speed ms
	DE 		H'00'		;   "		"    ls
	DE		H'00'		; forward reverse
	DE		H'00'		; feedback
	DE		H'00'		; code
	DE		D'10'		; speed change rate
	DE		H'02'		; PWM frequency (122Hz)
	DE		H'00'		; parameters selection
	DE		H'04'		; remote control decode rate

; define reset and interrupt vector start addresses

	org		0			; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector

	org     4			; interrupt vector 0004h, start interrupt routine here
	
; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1
	movf	PCLATH,w
	movwf	PCLATH_STO	; keep PCLATH
	bsf		PCLATH,3	; page 1
	goto	CK_INTERRUPT; continue on page 1

	org	H'800'	; page 1

CK_INTERRUPT	
	btfss	INTCON,INTE	; edge interrupt enable if set check flag
	goto	COUNTER
	btfss	INTCON,INTF	; if set edge interrupt
	goto	COUNTER
	bcf		INTCON,INTF	; interrupt flag off
	bsf		REM_FLG,0	; set beginning of remote control flag
	bsf		REM_FLG,7	; start bits flag
	
	movlw	D'11'		; initial time period to wait till next start bit
;						; 200us x 11 =  2.2ms for 1.778ms + 444.5us = 2.22ms for middle of next start bit
	movwf	REM_CNT
	movlw	D'13'		; shift register counter
	movwf	REM_COD
	bsf		REMOTE_L,0	; set first bit in remote control sequence

	movlw	D'207'
	movwf	TMR0		; 200us start timer from edge
	bcf		INTCON,INTE	; edge interrupt disable
	bcf		INTCON,INTF	; edge flag off
	bcf		INTCON,TMR0IF; timer 0 flag off
	goto	RECLAIM

COUNTER
	bcf		INTCON,TMR0IF	; clear TMRO interrupt flag
	decfsz	TIMER1,f
	goto	LOC_REMI
; timers decrement unless 0
; switch and update timer

	movf	TIMER0,w	; if timer 0 at zero bypass decrement	
	btfss	STATUS,Z
	decf	TIMER0,f

; display update timer

	movf	TIMER5,w	; if timer 5 at zero bypass decrement	
	btfss	STATUS,Z
	decf	TIMER5,f

; remote control last data clear timer
	movf	TIMERX,w	; if timer X at zero bypass decrement	
	btfss	STATUS,Z
	decf	TIMERX,f

LOC_REMI
; check for remote or local control
	movf	LOC_REM,w	; if zero then remote control
	btfss	STATUS,Z
	goto	CONVERT		; bypass since local control

; remote control sequence
	btfss	REM_FLG,0	; has remote control sequence started		
	goto	CONVERT
	decfsz	REM_CNT,f	; decrease interrupt counter for timing
	goto	CONVERT	
	bcf		REM_FLG,7	; clear initial start bits flag
	movlw	D'9'		; 8 x ((196us + 200us)/2)+ 196us = 198us x 8 + 196us or 1.780ms 
;						; or almost 1.778ms period between valid bits (can be varied see at CONVERT)
	movwf	REM_CNT
	rlf		REMOTE_L,f	; least sig byte in remote control code sequence
	rlf		REMOTE_M,f	; most sig byte 

	btfsc	PORTB,0		; check if high or low
	goto	HI			; high so clear
	bsf		REMOTE_L,0	; if low set this bit
	goto	BY_HI		; bypass high
HI	
	bcf		REMOTE_L,0	; clear 0 bit
BY_HI		
	decfsz	REM_COD,f	; decrease shift register count
	goto	CONVERT

; transfer values
	movf	REMOTE_L,w	; data
	movwf	REMOTE_LOW	; store data
	movf	REMOTE_M,w	; data
	movwf	REMOTE_HIGH	; store
	clrf	REM_FLG		; clear remote control decoding flag
; set REM_READY,0 flag
	bsf		REM_READY,0 ; remote control signal ready flag
	bsf		INTCON,INTE	; edge interrupt enable
	bcf		INTCON,INTF	; edge flag off
	
CONVERT
; adjust interrupt rate with counter
; if REM_FLG,7 is set use (200us) so the 11 counts between first start bit 
; to first quarter of second start bit is aligned correctly 
	btfsc	REM_FLG,7	; when set use 200us
	goto	SET_AT_207
	
; then changes from 208 to 207 for 196 and 200us to average at 198us  
; or between 196 and 200us for settings of REM_RATE between 0 and 9
; 2MHz/4/2/49 = 196us, 2MHz/4/2/50 = 200us
ALT_REM_RATE
	movf	REM_RATE,w
	subwf	REM_CNT,w	; counter
	btfss	STATUS,C
	goto	SET_AT_207
	movlw	D'208'		; 208 for 196us
	goto	ADD_TIMER
SET_AT_207
	movlw	D'207'		; 207 for 200us
ADD_TIMER
	addwf	TMR0,f		; add to timer register (halted for 2 instruction cycles)

; set RUN0,1 when timer is ready
; this breaks up interrupt routine to fit into available time period
	movf	TIMER1,w
	andlw	B'00001111'
	xorlw	B'00001111'
	btfss	STATUS,Z
	goto	ALTERATION

; 3.Halt any speed changes during overload (bit0 set)
	btfsc	OVERLOAD,0	; if set bypass
	goto	RECLAIM

CONTROL1 ; stop or run

; 4.If STOP_OP,0 clear, run stop routine at stop_rate. (Returns to previous speed when STOP_OP,0 is set)
; Stop function decreases speed at stop_rate to min setting then off.
	btfsc	STOP_OP,0	; stop?	
	goto	RUN_SPEED_CONTROL

; if counter is clear decrease STOP_CNT

	movf	STOP_CNT,w	; if zero reduce RUN0,RUN1
	btfsc	STATUS,Z	;
	goto	RED_RUN
	decfsz	STOP_CNT,f
	goto	RECLAIM	; wait till reduced to 0
RED_RUN
	btfsc	INERTIA,7	; if set bypass inertia control
	goto	STOP_BY		; for faster operation no inertia
	movf	STOP_RATE,w	; stop rate
	movwf	STOP_CNT	; rate counter
; reduce RUN0,1 at stop rate
RED_AT_STOP
	movf	RUN1,w		; ls byte
	btfsc	STATUS,Z	; if zero decrease high byte
	decf	RUN0,f
	decf	RUN1,f
	movf	RUN0,w		; check ms
	andlw	B'11111100' ; bits 0 and 1 stripped (ms bits of 10-bit)
	btfsc	STATUS,Z	; if zero continue otherwise set at 0
	goto	RECLAIM
	clrf	RUN0
	clrf	RUN1
	goto	RECLAIM

STOP_BY
; decrease faster with no inertia set
; subtract 
	movlw	D'03'		; larger is faster rate
	subwf	RUN1,f		; ls byte
	btfss	STATUS,C	; if carry decrease high byte
	decf	RUN0,f
; check for below 0
	movf	RUN0,w		; check ms
	andlw	B'11111100' ; bits 0 and 1 stripped (ms bits of 10-bit)
	btfsc	STATUS,Z	; if zero continue otherwise set at 0
	goto	RECLAIM
	clrf	STOP_CNT
	clrf	RUN0
	clrf	RUN1
	goto	RECLAIM

; 4.Run speed control 
RUN_SPEED_CONTROL

; if counter is clear decrease INERTIA_CNT
	movf	INERTIA_CNT,w	; if zero can alter RUN0,RUN1
	btfsc	STATUS,Z	;
	goto	ALT_RUN
	decfsz	INERTIA_CNT,f
	goto	RECLAIM			; wait till reduced to 0
ALT_RUN
	btfsc	INERTIA,7	; if set bypass inertia control
	goto	CHECK_IF_EQUAL; 
	movf	INERTIA,w	; inertia rate
	movwf	INERTIA_CNT	; inertia rate counter
	goto	CHECK_IF_EQUAL

; check if RUN0,1 is =, > or < SPEED0,1 and increase or decrease RUN0,1 accordingly
; SPEED0, SPEED1 desired speed (shown on display)
; RUN0, RUN1, current speed determined by inertia/stop rates)

CHECK_IF_EQUAL ; greater or Less
; less or more or =
	movf	RUN0,w		; ms byte current speed
	subwf	SPEED0,w	; required speed
	movwf	TEMPI0
	movf	RUN1,w		; ls byte current speed
	subwf	SPEED1,w
	movwf	TEMPI1
	btfss	STATUS,C
	decf	TEMPI0,f	; decrease if carry
	iorwf	TEMPI0,w
	btfsc	STATUS,Z
	goto	RECLAIM		; equal so no change required
	btfsc	TEMPI0,7	; if set then run speed is greater than required speed
	goto	REDUCE_RUN

; increase RUN0,1
	btfsc	INERTIA,7	; if set bypass inertia control
	goto	INC_BY		; for faster operation no inertia
; increase and check if at maximum
	incf	RUN1,f
	btfsc	STATUS,Z	; if zero increase high byte
	incf	RUN0,f
; compare against maximum 
	movf	RUN0,w		; ms byte current speed
	subwf	MAX_SPEED0,w
	movwf	TEMPI0
	movf	RUN1,w		; ls byte current speed
	subwf	MAX_SPEED1,w
	movwf	TEMPI1
	btfss	STATUS,C
	decf	TEMPI0,f		; decrease if carry
	btfss	TEMPI0,7		; if set then speed is greater than maximum speed 
	goto	RECLAIM
; transfer max speed setting to current
	movf	MAX_SPEED0,w
	movwf	RUN0
	movf	MAX_SPEED1,w
	movwf	RUN1
	goto	RECLAIM

INC_BY ; inertia bypass
	movlw	D'03'		; larger is faster rate
	addwf	RUN1,f
	btfsc	STATUS,C	; if carry increase high byte
	incf	RUN0,f
; compare against maximum 
	movf	RUN0,w		; ms byte current speed
	subwf	MAX_SPEED0,w
	movwf	TEMPI0
	movf	RUN1,w		; ls byte current speed
	subwf	MAX_SPEED1,w
	movwf	TEMPI1
	btfss	STATUS,C
	decf	TEMPI0,f	; decrease if carry
	btfss	TEMPI0,7	; if set then speed is greater than maximum speed 
	goto	RECLAIM
; transfer max speed setting to current
	movf	MAX_SPEED0,w
	movwf	RUN0
	movf	MAX_SPEED1,w
	movwf	RUN1
	clrf	INERTIA_CNT
	goto	RECLAIM

; reduce run0,1
REDUCE_RUN
	btfsc	INERTIA,7	; if set bypass inertia control
	goto	DEC_BY		; for faster operation no inertia
	movf	RUN1,w		; ls byte
	btfsc	STATUS,Z	; if zero decrease high byte
	decf	RUN0,f
	decf	RUN1,f
	movf	RUN0,w		; check ms
	andlw	B'11111100' ; bits 0 and 1 stripped (ms bits of 10-bit)
	btfsc	STATUS,Z	; if zero continue otherwise set at 0
	goto	RECLAIM
	clrf	RUN0
	clrf	RUN1
	goto	RECLAIM

DEC_BY ; faster decrease with no inertia
; subtract 
	movlw	D'03'		; larger is faster rate
	subwf	RUN1,f		; ls byte
	btfss	STATUS,C	; if carry decrease high byte
	decf	RUN0,f
; check for below 0
	movf	RUN0,w		; check ms
	andlw	B'11111100' ; bits 0 and 1 stripped (ms bits of 10-bit)
	btfsc	STATUS,Z	; if zero continue otherwise set at 0
	goto	RECLAIM
	clrf	RUN0
	clrf	RUN1
	clrf	INERTIA_CNT
	goto	RECLAIM

ALTERATION
; set PWM when timer is ready
; breaks up routine to fit into available time period for interrupt
	movf	TIMER1,w
	andlw	B'00001111'
	xorlw	B'00001011'
	btfss	STATUS,Z
	goto	RECLAIM

; set PWM to 0 when run0,1 is just below min speed setting 
 
	movf	RUN0,w		; ms byte current speed
	subwf	MIN_SPEED0,w
	movwf	TEMPI0
	movf	RUN1,w		; ls byte current speed
	subwf	MIN_SPEED1,w
	movwf	TEMPI1
	btfss	STATUS,C
	decf	TEMPI0,f	; decrease if carry
	btfsc	TEMPI0,7	; if set then speed is greater than minimum speed 
	goto	BY_CLEAR_PWM
; clear PWM
	clrf 	CCPR1L		; ms PWM
	bcf		CCP1CON,5	; ls bytes
	bcf		CCP1CON,4
	goto	RECLAIM	

BY_CLEAR_PWM

; PWM is equal to RUN0,1 but can be altered by back EMF (BACK_EMF0,1)
; if back emf (BACK_EMF0,1) = RUN0,1 set PWM without alteration
	movf	BACK_EMF0,w
	xorwf	RUN0,w
	btfss	STATUS,Z
	goto	PWM_VARY
	movf	BACK_EMF1,w
	xorwf	RUN1,w
	btfss	STATUS,Z
	goto	PWM_VARY
; equal
EQUAL
; convert RUN0,1 to PWM
	rrf		RUN0,w		; ms two bits in bit 0, bit 1, shift bit 0
	movwf	TEMPI1		; save
	rrf		RUN1,w		; shift once into RUN1
	movwf	TEMPI0		; save
	rrf		TEMPI1,w	; shift bit 1 originally from RUN0
	rrf		TEMPI0,f	; shift twice. This has ms byte for PWM (CCPR1L)

	clrf	TEMPI1
	btfsc	RUN1,0		; ls bit
	bsf		TEMPI1,4
	btfsc	RUN1,1		; next ls bit
	bsf		TEMPI1,5	; CCP1CON bits
	bsf		TEMPI1,2	; PWM mode and divider bits
	bsf		TEMPI1,3
; place in PWM	
	movf	TEMPI0,w
	movwf	CCPR1L		; ms PWM
	movf	TEMPI1,w
	movwf	CCP1CON		; ls 2-bits
	goto	RECLAIM

PWM_VARY
; alter PWM from RUN0,1 according to back emf (cf back emf with RUN0,1) inc pwm if less by amount set
; by feedback value	

; If FEEDBACK = 0 no feedback control so go to EQUAL (ie PWM follows RUN0,1)
	movf	FEEDBACK,w
	btfsc	STATUS,Z	; if zero no feedback control
	goto	EQUAL

; add or subtract multiplied value (FEEDCON0,1) to PWM
	btfss	SIGN,0
	goto	ADD_CONTROL
; subtract
	movf	FEEDCONT0,w	; ms byte control 
	subwf	RUN0,w		; run value
	movwf	TEMPI0
	movf	FEEDCONT1,w	; ls byte control
	subwf	RUN1,w
	movwf	TEMPI1
	btfss	STATUS,C
	decf	TEMPI0,f	; decrease if carry
	btfss	TEMPI0,7	; if set then below zero so set at 0
	goto	PWM_SET
 	clrf	TEMPI1
	clrf	TEMPI0

PWM_SET
; convert TEMPI0,1 to PWM
	rrf		TEMPI0,w	; ms two bits in bit 0, bit 1, shift bit 0
	movwf	TEMPIX1		; save
	rrf		TEMPI1,w	; shift once into TEMPI1
	movwf	TEMPIX0		; save
	rrf		TEMPIX1,w	; shift bit 1 originally from TEMPI0
	rrf		TEMPIX0,f	; shift twice. This has ms byte for PWM (CCPR1L)

	clrf	TEMPIX1
	btfsc	TEMPI1,0	; ls bit
	bsf		TEMPIX1,4
	btfsc	TEMPI1,1	; next ls bit
	bsf		TEMPIX1,5	; CCP1CON bits
	bsf		TEMPIX1,2	; PWM mode and divider bits
	bsf		TEMPIX1,3
; place in PWM	
	movf	TEMPIX0,w
	movwf	CCPR1L		; ms PWM
	movf	TEMPIX1,w
	movwf	CCP1CON		; ls 2-bits
	goto	RECLAIM

ADD_CONTROL
	movf	FEEDCONT0,w	; ms byte control 
	addwf	RUN0,w		; run value
	movwf	TEMPI0
	movf	FEEDCONT1,w	; ls byte control
	addwf	RUN1,w
	movwf	TEMPI1
	btfsc	STATUS,C
	incf	TEMPI0,f	; increase if carry
	btfsc	TEMPI0,2	; if set over 3FF
	goto	RECLAIM		; keep old PWM value
	btfss	TEMPI0,1	; if set then check bit 0
	goto	PWM_SET
	btfss	TEMPI0,0	; if set then check for allowable limit
	goto	PWM_SET
; check against H039A. For 80% PWM max
	movlw	H'33'
	subwf	TEMPI1,w
	btfss	STATUS,C	
	goto	PWM_SET

	
; end of interrupt reclaim w and status 
RECLAIM	
	btfsc	INTCON,TMR0IF	; if TMRO interrupt flag set again re-run Interrupt
	goto	COUNTER	
	movf	PCLATH_STO,w
	movwf	PCLATH		; restore PCLATH
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

;********************************************************************************************** 
  
; RESET		
; Set ports A & B
	org	H'0D'	; page 0
MAIN
	clrf	PORTB
	clrf	PORTA
	clrf	STOP_OP		; STOP in operation
	clrf	REM_CNT		; remote control polling counter
	clrf	REM_FLG		; remote control flag status
	clrf	REM_READY	; remote control data ready flag
	clrf	DISPLAY		; display update flag
	clrf	OVERLOAD	; overload flag
	clrf	LOCK		; lockout
	clrf	MODE		; display mode
	clrf	SPEEDX		; potentiometer speed setting ms byts
	clrf	SPEEDY		; ls byte
	clrf	TIMER0
	clrf	TIMER1		; timers
	clrf	SPEED0_LST	; last speed value ms
	clrf	SPEED1_LST	; last speed value ls
	clrf	SET_FLG		; settings set flag
	clrf	STOP_CNT	; stop rate counter
	clrf	INERTIA_CNT	; inertia rate counter
	clrf	TEMPS		; speed change counter
	clrf	TIMER5		; display update timer
	clrf	RUN0		; run speed
	clrf	RUN1		; run speed
	clrf	TIMERX		; remote code repeat timer
	clrf	REM_STO		; remote code storage
	clrf	REM_STO1	; storage remote code

; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	B'11110001'	; I/O (RB4,5,6,7 inputs)
	movwf	TRISB		; port B data direction register
	movlw	B'00000000'	; 
	movwf	OPTION_REG	; TMRO prescaler is 2, PORTB pullups enabled, RB0 interrupt on falling edge
	movlw   B'00011100'	; I/O * Set bit 2 when tracer is off
	movwf   TRISA		; port A data direction register

; analog inputs, A/D
	movlw	B'00011100'	;  AN2,3,4 are analog inputs * Set bit 2 when tracer is off
	movwf	ANSEL
	movlw	B'11000000'	; right justified A/D result, Vdd to Vss A/D
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	clrf	PORTA
	clrf	PORTB
	movlw	B'00010000'	; Fosc, channel 4 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

	bsf		STATUS,RP0	; select memory bank 1
	movlw	H'FF'
	movwf	PR2			; PWM period register
	bcf		STATUS,RP0	; memory bank 0
	
; pwm set
	movlw	H'FF'
	movwf	PR2			; prescaler	
	movlw	H'00'		; 0% duty
	movwf	CCPR1L		; ms byte of PWM
	movlw	B'00000010'
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	movlw	B'00001100'	; set PWM mode
	movwf	CCP1CON		; enable PWM operation

; startup
	call	DELAYY		; start up delay
	call	INIT_LC		; initialise LCD
	call	DELAYms
	call	INIT_LC
	call	DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x10 dots)
	call	LOAD		; 
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX
	bsf		PCLATH,3	; page 1
	call	CHARACTER_GEN; level bars and lockout icon

; obtain EEPROM values
; max speed
	movlw	EEPROM1
	call	EEREAD		; sets EEADR
	movwf	MAX_SPEED0	; 
	movlw	EEPROM2
	call	EEREAD		; sets EEADR
	movwf	MAX_SPEED1	; 
; min speed
	movlw	EEPROM3
	call	EEREAD		; sets EEADR
	movwf	MIN_SPEED0	; 
	movlw	EEPROM4
	call	EEREAD		; sets EEADR
	movwf	MIN_SPEED1	; 
; lockout
	movlw	EEPROM5
	call	EEREAD		; sets EEADR
	movwf	LOCKOUT0	; 
	movlw	EEPROM6
	call	EEREAD		; sets EEADR
	movwf	LOCKOUT1	; 
; inertia
	movlw	EEPROM7
	call	EEREAD
	movwf	INERTIA
; stop-rate
	movlw	EEPROM8
	call	EEREAD
	movwf	STOP_RATE
; local/ remote
	movlw	EEPROM9
	call	EEREAD
	movwf	LOC_REM		; local or remote control
; current speed
	movlw	EEPROMA
	call	EEREAD		; sets EEADR
	movwf	SPEED0	; 
	movlw	EEPROMB
	call	EEREAD		; sets EEADR
	movwf	SPEED1	; 
; forward/reverse
	movlw	EEPROMC
	call	EEREAD
	movwf	FOR_REV
	btfss	FOR_REV,0
	goto	FORWARD_SET
; reverse set
	bcf		PORTB,1
	bsf		PORTB,2
	goto	FEED
FORWARD_SET
	bcf		PORTB,2
	bsf		PORTB,1
; feedback control
FEED
	movlw	EEPROMD
	call	EEREAD		; 
	movwf	FEEDBACK	; 
; remote control code
	movlw	EEPROME
	call	EEREAD		; 
	movwf	CODES
; Speed Change Rate
	movlw	EEPROMF
	call	EEREAD		; 
	movwf	SPEED_CHNG
; PWM frequency
	movlw	EEPROMG
	call	EEREAD		; 
	andlw	B'00000011'	; just the ls divider bits
	movwf	PULSE
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
; Parameters
	movlw	EEPROMH
	call	EEREAD		; 
	movwf	SELECT		; parameters select
; remote control decode rate
	movlw	EEPROMI
	call	EEREAD		; 
	movwf	REM_RATE	; remote control decoder rate
			
; interrupt enable 
	bsf		INTCON,TMR0IE; set interrupt enable for TMR0 
	bsf		INTCON,GIE	; set global interrupt enable for above
	movf	LOC_REM,w
	btfss	STATUS,Z
	goto 	RUN_CYCLE	; local 
	bcf		INTCON,INTF	; clear flag 
	bsf		INTCON,INTE

RUN_CYCLE
	movf	LOC_REM,w
	btfss	STATUS,Z
	goto 	CK_SW		; local 
; if remote and mode not 0 bypass remote
	movf	MODE,w
	btfsc	STATUS,Z
	goto	REMX
	clrf	REM_FLG		; clear remote control data ready flag
	goto	CK_SW

; if remote control flag clear (no remote code data) then set the edge interrupt
REMX
	movf	REM_FLG,w
	btfss	STATUS,Z
	goto	DEC_REM1
	btfss	INTCON,INTE	; is edge interrupt already set (set usually in interrupt)
	bcf		INTCON,INTF	; clear flag if enable not already set
	bsf		INTCON,INTE

DEC_REM1
	
; decode remote control signal
	btfss	REM_READY,0	; is remote control data ready flag set
	goto	CK_SW

	clrf	REM_READY	; clear flag
; transfer values
	bcf		INTCON,GIE	; prevent interrupt corruption of transfer
	movf	REMOTE_LOW,w
	movwf	REM_LOW_L
	movf	REMOTE_HIGH,w
	movwf	REM_HIGH_M	
	bsf		INTCON,GIE

; compare with address code out if invalid clear REM_FLG
; if valid check command bits and ls 2 address bits then clear REM_FLG
	
	movf	CODES,w		; current code setting value	
	btfss	STATUS,Z
	goto	OTHER_CODES

; code for television (TV1)

TV_1
	movf	REM_HIGH_M,w; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	xorlw	B'00110000'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF1	; clear remote flag

	movf	REM_LOW_L,w
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	UP_SET
	movf	REM_LOW_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	DN_SET  
	movf	REM_LOW_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	STOP_ST
	movf	REM_LOW_L,w	; least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	FORWARD_ST
	movf	REM_LOW_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REVERSE_ST 
	movf	REM_LOW_L,w
	xorlw	B'00001100'	; bits 0-5 keycode (12), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INERTIA_ST
	goto	CLR_RMF1

; satellite decoding SAT1 & SAT2

OTHER_CODES ; check codes
	movf	CODES,w
	xorlw	D'01'
	btfss	STATUS,Z
	goto	SAT_2
SAT_1
	movf	REM_HIGH_M,w; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit
	
	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF1	; clear remote flag
	movf	REM_LOW_L,w	;  least sig remote code
	
	xorlw	B'00010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	UP_SET
	movf	REM_LOW_L,w
	xorlw	B'00010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	DN_SET
	movf	REM_LOW_L,w
	xorlw	B'00001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	STOP_ST 
	movf	REM_LOW_L,w	; least sig remote code
	xorlw	B'00100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	FORWARD_ST
	movf	REM_LOW_L,w
	xorlw	B'00100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REVERSE_ST 	
	movf	REM_LOW_L,w
	xorlw	B'00001100'	; bits 0-5 keycode (12), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INERTIA_ST
  	goto	CLR_RMF1

SAT_2
	movf	REM_HIGH_M,w; most significant remote code 
	andlw	B'00110111'	; mask out bit 7 and 6 and toggle bit

	xorlw	B'00110010'	; compare with start bits and ms 3-bits of address
	btfss	STATUS,Z	; if zero then matching
	goto	CLR_RMF1	; clear remote flag
	
	movf	REM_LOW_L,w	; least sig remote code
	xorlw	B'10010000'	; bits 0-5 keycode (16), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	UP_SET
	movf	REM_LOW_L,w
	xorlw	B'10010001'	; bits 0-5 keycode (17), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	DN_SET 
	movf	REM_LOW_L,w
	xorlw	B'10001101'	; bits 0-5 keycode (13), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	STOP_ST  
	movf	REM_LOW_L,w	; least sig remote code
	xorlw	B'10100000'	; bits 0-5 keycode (32), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	FORWARD_ST
	movf	REM_LOW_L,w
	xorlw	B'10100001'	; bits 0-5 keycode (33), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	REVERSE_ST 
	movf	REM_LOW_L,w
	xorlw	B'10001100'	; bits 0-5 keycode (12), bit 7 and bit 6 are ls address bits
	btfsc	STATUS,Z
	goto	INERTIA_ST
;	goto	CLR_RMF1


CLR_RMF1
	movf	REM_LOW_L,w
	movwf	REM_STO		; store so incorrect data is compared at next valid code
	movf	REM_HIGH_M,w
	movwf	REM_STO1	
	goto	CK_SW
CLR_RMFX
	movlw	D'10'
	movwf	TIMER0		; timer
CLR_RMF2	
	clrf	DISPLAY		; indicator to update display (clear is for update display)
CLR_RMF
	clrf	REM_FLG		; remote flag cleared
	goto	CK_SW

; **************************
; remote control functions

; speed up 
UP_SET	


; repeated code the same check
; if timerx is clear transfer data
	movf	TIMERX,w
	btfss	STATUS,Z
	goto	CK_SAMEY	
	movf	REM_LOW_L,w
	movwf	REM_STO		; store
	movf	REM_HIGH_M,w
	movwf	REM_STO1	; store so incorrect data is compared at next valid code
	movlw	D'4'		; timeout clear
	movwf	TIMERX
	goto	CLR_RMF
CK_SAMEY
	movf	REM_LOW_L,w
	xorwf	REM_STO,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
	movf	REM_HIGH_M,w
	xorwf	REM_STO1,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF

; increase speed
	bsf		STOP_OP,0		; STOP flag off
	movf	SPEED_CHNG,w	; speed change rate
	movwf	TEMPS			; temp speed counter
; if mode is 1 then bypass faster update count
	movf	MODE,w
	btfss	STATUS,Z
	clrf	TEMPS		
	
SPEED_CHNG_RATE_UP
	bcf		INTCON,GIE
	incf	SPEED1,f
	btfsc	STATUS,Z
	incf	SPEED0,f
	bsf		INTCON,GIE
; if overrange set at max
	btfss	SPEED0,2	; > bit 9 for 10-bit resolution
	goto	CK_OVER
SET_AT_MAX
	bcf		INTCON,GIE
	movf	MAX_SPEED0,w
	movwf	SPEED0
	movf	MAX_SPEED1,w
	movwf	SPEED1
	bsf		INTCON,GIE
	goto	CLR_RMF2

; if > maximum speed, set at max
CK_OVER
; only check if over when Mode is 0. If settings, allow full range
	movf	MODE,w
	btfss	STATUS,Z
	goto	CLR_RMF2	
	bcf		INTCON,GIE
	movf	SPEED0,w	; ms byte current speed
	subwf	MAX_SPEED0,w
	movwf	TEMP0
	movf	SPEED1,w	; ls byte current speed
	bsf		INTCON,GIE
	subwf	MAX_SPEED1,w
	movwf	TEMP1
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfsc	TEMP0,7		; if set then speed setting is greater than max speed
	goto	SET_AT_MAX
	movf	TEMPS,w
	btfsc	STATUS,Z
	goto	CLR_RMF2
	decfsz	TEMPS,f
	goto	SPEED_CHNG_RATE_UP; keep increasing till TEMPS is 0
	goto	CLR_RMF2
		
DN_SET	

; repeated code the same check
; if timerx is clear transfer data
	movf	TIMERX,w
	btfss	STATUS,Z
	goto	CK_SAMEX	
	movf	REM_LOW_L,w
	movwf	REM_STO		; store
	movf	REM_HIGH_M,w
	movwf	REM_STO1	; store so incorrect data is compared at next valid code
	movlw	D'4'		; timeout clear
	movwf	TIMERX
	goto	CLR_RMF
CK_SAMEX
	movf	REM_LOW_L,w
	xorwf	REM_STO,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
	movf	REM_HIGH_M,w
	xorwf	REM_STO1,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF

; decrease speed 
;	bsf		STOP_OP,0		; STOP flag off
	movf	SPEED_CHNG,w	; speed change rate
	movwf	TEMPS			; temp speed counter
; if mode is 1 then bypass faster update count
	movf	MODE,w
	btfss	STATUS,Z
	clrf	TEMPS
SPEED_CHNG_RATE_DN
	bcf		INTCON,GIE
	movf	SPEED1,w
	btfsc	STATUS,Z	; if ls byte is zero
	decf	SPEED0,f	; decrease ms byte
	decf	SPEED1,f	; decrease ls byte
; if ms byte is FF (decreased from 00) reload min speed
	incf	SPEED0,w	; ms byte
	bsf		INTCON,GIE	
	btfss	STATUS,Z	; if zero	 
	goto	CK_MIN		; was not FF
; load minimum value
SET_AT_MIN
	bcf		INTCON,GIE
	movf	MIN_SPEED0,w
	movwf	SPEED0
	movf	MIN_SPEED1,w
	movwf	SPEED1
	bsf		INTCON,GIE
	goto	CLR_RMF2
; if less than min setting set at minimum
CK_MIN
; only check if min when Mode is 0. If settings, allow full range
	movf	MODE,w
	btfss	STATUS,Z
	goto	CLR_RMF2	
	bcf		INTCON,GIE
	movf	SPEED0,w	; ms byte current speed
	subwf	MIN_SPEED0,w
	movwf	TEMP0
	movf	SPEED1,w	; ls byte current speed
	bsf		INTCON,GIE
	subwf	MIN_SPEED1,w
	movwf	TEMP1
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfss	TEMP0,7		; if set then speed setting is greater than min speed
	goto	SET_AT_MIN
	movf	TEMPS,w
	btfsc	STATUS,Z
	goto	CLR_RMF2
	decfsz	TEMPS,f
	goto	SPEED_CHNG_RATE_DN; keep decreasing till TEMPS is 0
	goto	CLR_RMF2
	
REVERSE_ST
; if lockout no change allowed
	btfsc	LOCK,0
	goto	CLR_RMF	

; repeated code the same check
; if timerx is clear transfer data
	movf	TIMERX,w
	btfss	STATUS,Z
	goto	CK_SAME1	
	movf	REM_LOW_L,w
	movwf	REM_STO		; store
	movf	REM_HIGH_M,w
	movwf	REM_STO1	; store so incorrect data is compared at next valid code
	movlw	D'4'		; timeout clear
	movwf	TIMERX
	goto	CLR_RMF
CK_SAME1
	movf	REM_LOW_L,w
	xorwf	REM_STO,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
	movf	REM_HIGH_M,w
	xorwf	REM_STO1,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF

	movf	TIMER0,w
	btfss	STATUS,Z	; if timer running bypass
	goto	CLR_RMF	

	bsf		FOR_REV,0   ; set FOR_REV
WRI_FOR_REV ; store in EEPROM
	movlw	EEPROMC
	call	EEREAD		; set EEADR
	movf	FOR_REV,w
	call	EEWRITE		; write to EEPROM
	movlw	D'5'
	movwf	TIMER0		; timer
; set actual forward/reverse
	btfss	FOR_REV,0
	goto	FORWARD_SET_REM
; reverse set
	bcf		PORTB,1
	nop
	bsf		PORTB,2
	goto	CLR_RMFX
FORWARD_SET_REM
	bcf		PORTB,2
	nop
	bsf		PORTB,1	
	goto	CLR_RMFX

FORWARD_ST
; if lockout no change allowed
	btfsc	LOCK,0
	goto	CLR_RMF	

; repeated code the same check
; if timerx is clear transfer data
	movf	TIMERX,w
	btfss	STATUS,Z
	goto	CK_SAME2	
	movf	REM_LOW_L,w
	movwf	REM_STO		; store
	movf	REM_HIGH_M,w
	movwf	REM_STO1	; store so incorrect data is compared at next valid code
	movlw	D'4'		; timeout clear
	movwf	TIMERX
	goto	CLR_RMF
CK_SAME2
	movf	REM_LOW_L,w
	xorwf	REM_STO,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
	movf	REM_HIGH_M,w
	xorwf	REM_STO1,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF

	movf	TIMER0,w
	btfss	STATUS,Z	; if timer running bypass
	goto	CLR_RMF	
	
	clrf	FOR_REV		; clear FOR_REV
	goto	WRI_FOR_REV

; STOP operation
STOP_ST
; stop on/off
; toggle STOP_OP,0

; repeated code the same check
; if timerx is clear transfer data

	goto	CK_TM3		; ** bypass check as Mute and Inertia are slow to operate

	movf	TIMERX,w
	btfss	STATUS,Z
	goto	CK_SAME3	
	movf	REM_LOW_L,w
	movwf	REM_STO		; store
	movf	REM_HIGH_M,w
	movwf	REM_STO1	; store so incorrect data is compared at next valid code
	movlw	D'4'		; timeout clear
	movwf	TIMERX
	goto	CLR_RMF
CK_SAME3
	movf	REM_LOW_L,w
	xorwf	REM_STO,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
	movf	REM_HIGH_M,w
	xorwf	REM_STO1,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
CK_TM3
	movf	TIMER0,w
	btfss	STATUS,Z	; wait till timer is zero preventing multiple toggles in a short time
	goto	CLR_RMF
	
	btfss	STOP_OP,0
	goto	SET_STOP
	clrf	STOP_OP		; stop toggled on
	goto	CLR_RMFX
SET_STOP
	bsf		STOP_OP,0	; stop toggled off
	goto	CLR_RMFX	

INERTIA_ST
; inertia on/off
; toggle INERTIA

; repeated code the same check
; if timerx is clear transfer data

	goto	CK_TM4		; ** bypass check as Mute and Inertia are slow to operate

	movf	TIMERX,w
	btfss	STATUS,Z
	goto	CK_SAME4	
	movf	REM_LOW_L,w
	movwf	REM_STO		; store
	movf	REM_HIGH_M,w
	movwf	REM_STO1	; store so incorrect data is compared at next valid code
	movlw	D'4'		; timeout clear
	movwf	TIMERX
	goto	CLR_RMF
CK_SAME4
	movf	REM_LOW_L,w
	xorwf	REM_STO,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
	movf	REM_HIGH_M,w
	xorwf	REM_STO1,w
	btfss	STATUS,Z		; if the same as last time act on decoded signal
	goto	CLR_RMF
CK_TM4
	movf	TIMER0,w
	btfss	STATUS,Z	; wait till timer is zero preventing multiple toggles in a short time
	goto	CLR_RMF

	btfss	INERTIA,7
	goto	SET_INERTIA
	bcf		INERTIA,7
WRI_INERTIA ; store in EEPROM
	movlw	EEPROM7
	call	EEREAD		; set EEADR
	movf	INERTIA,w
	call	EEWRITE		; write to EEPROM
	goto	CLR_RMFX
SET_INERTIA
	bsf		INERTIA,7	
	goto	WRI_INERTIA

; **********************
	
CK_SW ; check switches
	
; if timer running still in switch debounce/delay mode
	movf	TIMER0,w	; timer0 clear?
	btfss	STATUS,Z
	goto	DISP_CHNG	; bypass switch until timers complete

; check if local control
CK_LOC_REM1
	
	movf	LOC_REM,w
	btfsc	STATUS,Z
	goto 	SW_LOC		; local switches

; local mode
; read potentiometer setting at AN2 restrict to min and max range
; place in speed0,1

; A/D conversion
; channel 2
	bcf		ADCON0,3
	bcf		ADCON0,5
	bsf		ADCON0,4
; wait 20us to charge input capacitance
	movlw	D'5'
	movwf	STORE3
WAIT20
	decfsz	STORE3,f
	goto	WAIT20	
		
	call	ACQUIRE_AD
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0
	bcf		INTCON,GIE
	movwf	SPEED1
	movf	ADRESH,w
	movwf	SPEED0
	bsf		INTCON,GIE

; if mode is for settings allow speed0,1 to be any value
; Allow full range with settings mode
	movf	MODE,w
	btfss	STATUS,Z
	goto	COMP_LAST; SW_LOC	
; check for maximum
	movf	SPEED0,w	; ms byte current speed
	subwf	MAX_SPEED0,w
	movwf	TEMP0
	movf	SPEED1,w	; ls byte current speed
	subwf	MAX_SPEED1,w
	movwf	TEMP1
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfss	TEMP0,7		; if set then speed setting is greater than max speed
	goto	CK_MIN1
; set at maximum
	movf	MAX_SPEED0,w
	movwf	SPEED0
	movf	MAX_SPEED1,w
	movwf	SPEED1
	goto	COMP_LAST
CK_MIN1
	movf	SPEED0,w	; ms byte current speed
	subwf	MIN_SPEED0,w
	movwf	TEMP0
	movf	SPEED1,w	; ls byte current speed
	subwf	MIN_SPEED1,w
	movwf	TEMP1
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfsc	TEMP0,7		; if set then speed setting is greater than min speed
	goto	COMP_LAST
; set at minimum
	movf	MIN_SPEED0,w
	movwf	SPEED0
	movf	MIN_SPEED1,w
	movwf	SPEED1
COMP_LAST
; compare speed setting with previous (last) value
	movf	SPEED0,w
	xorwf	SPEED0_LST,w
	btfss	STATUS,Z
	clrf	DISPLAY		; different so update display
	movf	SPEED1,w
	xorwf	SPEED1_LST,w
	btfss	STATUS,Z
	clrf	DISPLAY		; update when different
; update current and last files 
	movf	SPEED0,w
	movwf	SPEED0_LST
	movf	SPEED1,w
	movwf	SPEED1_LST

SW_LOC 
	movf	TIMER0,w
	btfss	STATUS,Z	; wait till timer is zero preventing multiple toggles in a short time
	goto	DISP_CHNG
	movf	MODE,w
	btfss	STATUS,Z	; when mode is zero use local switches
	goto	OTHER_SW

; check local switches

; local switch functions
; S1, inertia, S2, stop, S3, forward reverse

	btfss	PORTB,6		; if low then for/rev switch
	goto	REVERSE_FORWARD
	btfss	PORTB,5		; if low then stop switch
	goto	STOP_SW
	btfss	PORTB,7		; if low then inertia switch
	goto	INERTIA_SW
	goto	OTHER_SW

REVERSE_FORWARD
; if lockout no change allowed
	btfsc	LOCK,0
	goto	BY_FOR_REV
	incf	FOR_REV,w	; alter bit 0
	andlw	B'00000001'
	movwf	FOR_REV		; just bit 0
; store in EEPROM
	movlw	EEPROMC
	call	EEREAD		; set EEADR
	movf	FOR_REV,w
	call	EEWRITE		; write to EEPROM
; set actual forward/reverse
	btfss	FOR_REV,0
	goto	FORWARD_SET_SW
; reverse set
	bcf		PORTB,1
	nop
	bsf		PORTB,2
	goto	BY_FOR_REV
FORWARD_SET_SW
	bcf		PORTB,2
	nop
	bsf		PORTB,1	

BY_FOR_REV
	goto	DISP_CHNG2

; STOP switch operation
	
STOP_SW
; stop on/off
; toggle STOP_OP,0

	btfss	STOP_OP,0
	goto	SET_STOP1
	clrf	STOP_OP		; stop toggled on
	goto	DISP_CHNG2
SET_STOP1
	bsf		STOP_OP,0	; stop toggled off
	goto	DISP_CHNG2

INERTIA_SW
; inertia on/off
; toggle INERTIA
	btfss	INERTIA,7
	goto	SET_INERTIA_SW
	bcf		INERTIA,7
WRI_INERTIA_SW ; store in EEPROM
	movlw	EEPROM7
	call	EEREAD		; set EEADR
	movf	INERTIA,w
	call	EEWRITE
	goto	DISP_CHNG2
SET_INERTIA_SW
	bsf		INERTIA,7	
	goto	WRI_INERTIA_SW

OTHER_SW
	btfss	PORTB,7		; if low then UP switch
	goto	UP_SW
	btfss	PORTB,5		; if low then DN switch
	goto	DN_SW
	btfss	PORTB,6		; if low then select switch
	goto	SELECT_SW
	btfss	PORTB,4		; if low then MODE switch (0 for normal display, 1 for select options)
	goto	MODE_TOGGLE
	bcf		SET_FLG,0	; set flag to show "loaded" if set (off)
	goto	DISP_CHK	; if no switches pressed go to DISP_CHECK

UP_SW
; if mode is zero ignore switch
	movf	MODE,w		; mode value
	btfsc	STATUS,Z
	goto	DISP_CHNG	; mode was zero
; 0
	movf	SELECT,w
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_MAX
; 1
	movf	SELECT,w
	xorlw	D'1'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_MIN
; 2
	movf	SELECT,w
	xorlw	D'2'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_LOCKOUT
; 3
	movf	SELECT,w
	xorlw	D'3'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_CURRENT
; 4
	movf	SELECT,w
	xorlw	D'4'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_LOC_REM
; 5
	movf	SELECT,w
	xorlw	D'5'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_CODES
; 6
	movf	SELECT,w
	xorlw	D'6'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_INERTIA_UP
; 7
	movf	SELECT,w
	xorlw	D'7'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_STOP_UP
; 8
	movf	SELECT,w
	xorlw	D'8'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_FEEDBACK_UP
; 9
	movf	SELECT,w
	xorlw	D'9'
	btfsc	STATUS,Z	; when zero 
	goto	SPEED_CHNG_UP
; 10
	movf	SELECT,w
	xorlw	D'10'
	btfsc	STATUS,Z	; when zero 
	goto	PULSE_UP
	goto	DISP_CHK1

LOAD_MAX 
; 0. load maximum speed setting (MAX_SPEED0, MAX_SPEED1, EEPROM1,2)
; if > 80% duty (H333) set at 80%
	btfss	SPEED0,0
	goto	LOAD_MAX_SPEED
	btfss	SPEED0,1
	goto	LOAD_MAX_SPEED
	movlw	H'33'
	subwf	SPEED1,w
	btfss	STATUS,C
	goto	LOAD_MAX_SPEED
	movlw	H'33'
	movwf	SPEED1
LOAD_MAX_SPEED
	movf	SPEED0,w	; ms speed
	movwf	MAX_SPEED0
	movlw	EEPROM1
	call	EEREAD		; sets EEADR
	movf	MAX_SPEED0,w
	call	EEWRITE		; write to EEPROM

	movf	SPEED1,w	; ls speed
	movwf	MAX_SPEED1
	movlw	EEPROM2
	call	EEREAD		; sets EEADR
	movf	MAX_SPEED1,w
	call	EEWRITE		; write to EEPROM
	bsf		SET_FLG,0	; set flag to show if set
	goto	DISP_CHK1

LOAD_MIN 
; 1. load minimum speed setting (MIN_SPEED0, MIN_SPEED1, EEPROM3,4)
	movf	SPEED0,w	; ms speed
	movwf	MIN_SPEED0
	movlw	EEPROM3
	call	EEREAD		; sets EEADR
	movf	MIN_SPEED0,w
	call	EEWRITE		; write to EEPROM

	movf	SPEED1,w	; ls speed
	movwf	MIN_SPEED1
	movlw	EEPROM4
	call	EEREAD		; sets EEADR
	movf	MIN_SPEED1,w
	call	EEWRITE		; write to EEPROM

; compare lockout to minimum. If less then set at minimum speed

	movf	SPEED0,w	; ms byte current speed
	subwf	LOCKOUT0,w
	movwf	TEMP0
	movf	SPEED1,w	; ls byte current speed
	subwf	LOCKOUT1,w
	movwf	TEMP1
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfsc	TEMP0,7		; if set then min speed is greater than lockout speed 
	goto	LOAD_LOCKOUT; load lockout	
	bsf		SET_FLG,0	; set flag to show if set
	goto	DISP_CHK1

; 2. load lockout speed (LOCKOUT0, LOCKOUT1, EEPROM5,6)
LOAD_LOCKOUT
	movf	SPEED0,w	; ms speed
	movwf	LOCKOUT0
	movlw	EEPROM5
	call	EEREAD		; sets EEADR
	movf	LOCKOUT0,w
	call	EEWRITE		; write to EEPROM

	movf	SPEED1,w	; ls speed
	movwf	LOCKOUT1
	movlw	EEPROM6
	call	EEREAD		; sets EEADR
	movf	LOCKOUT1,w
	call	EEWRITE		; write to EEPROM
	bsf		SET_FLG,0	; set flag to show if set
	goto	DISP_CHK1

; 3. load current speed (SPEED0, SPEED1, EEPROMA,B)
LOAD_CURRENT
	movlw	EEPROMA
	call	EEREAD		; sets EEADR
	movf	SPEED0,w
	call	EEWRITE		; write to EEPROM

	movlw	EEPROMB
	call	EEREAD		; sets EEADR
	movf	SPEED1,w
	call	EEWRITE		; write to EEPROM
	bsf		SET_FLG,0	; set flag to show if set
	goto	DISP_CHK1

; 4. local or IR remote control (LOC_REM, EEPROM9) (Toggle selection with switch)
LOAD_LOC_REM
	incf	LOC_REM,w	; alternate bit 0
	andlw	B'00000001'	; clear bits 1 to 7
	movwf	LOC_REM
; write to EEPROM
	movlw	EEPROM9
	call	EEREAD		; sets EEADR
	movf	LOC_REM,w
	call	EEWRITE		; write to EEPROM
	goto	DISP_CHK1

; 5. REMOTE Control decode rate
LOAD_CODES
	incf	REM_RATE,f	; increase
	movf	REM_RATE,w
	sublw	D'9'		; take from 9
	btfss	STATUS,C	; if negative set at 0
	clrf	REM_RATE
	movlw	EEPROMI
	call	EEREAD		; sets EEADR
	movf	REM_RATE,w
	call	EEWRITE		; write to EEPROM
	goto	DISP_CHK1
	
; 6. inertia set (INERTIA, EEPROM7), bit 7 is inertia on/off
LOAD_INERTIA_UP
	movf	INERTIA,w	; store inertia value mainly to restore bit 7 (on or off)
	movwf	TEMP1                                                                
	incf	INERTIA,f	; next value
	bcf		INERTIA,7	; ignore inertia on/off bit
	movf	INERTIA,w
	sublw	D'100'		; take from 100
	btfsc	STATUS,C	; if negative set at 0
	goto	INERTIA_UP_DN
	movlw	D'0'
INERTIA_100
	movwf	INERTIA
INERTIA_UP_DN
	bcf		INERTIA,7	; on/off bit
	btfsc	TEMP1,7		; if bit 7 was set in inertia value then set
	bsf		INERTIA,7
	movlw	EEPROM7
	call	EEREAD		; sets EEADR
	movf	INERTIA,w
	call	EEWRITE		; write to EEPROM
	goto	DISP_CHK1

; 7. stop rate (STOP, EEPROM8)
LOAD_STOP_UP
	incf	STOP_RATE,f		; increase
	movf	STOP_RATE,w
	sublw	D'100'		; take from 100
	btfsc	STATUS,C	; if negative set at 0
	goto	STOP_UP_DN
	movlw	D'0'
STOP_100
	movwf	STOP_RATE
STOP_UP_DN
	movlw	EEPROM8
	call	EEREAD		; sets EEADR
	movf	STOP_RATE,w
	call	EEWRITE		; write to EEPROM
	goto	DISP_CHK1

; 8. feedback control (FEEDBACK, EEPROMD) 
LOAD_FEEDBACK_UP
	incf	FEEDBACK,f	; increase
	movf	FEEDBACK,w
	sublw	D'100'		; take from 100
	btfsc	STATUS,C	; if negative set at 0
	goto	FEEDBACK_UP_DN
	movlw	D'0'
FEEDBACK_100
	movwf	FEEDBACK
FEEDBACK_UP_DN
	movlw	EEPROMD
	call	EEREAD		; sets EEADR
	movf	FEEDBACK,w
	call	EEWRITE		; write to EEPROM
	goto	DISP_CHK1

; 9. Speed change rate (SPEED_CHNG, EEPROMF) 
SPEED_CHNG_UP
	incf	SPEED_CHNG,f	; increase
	movf	SPEED_CHNG,w
	sublw	D'100'		; take from 100
	btfsc	STATUS,C	; if negative set at 0
	goto	SPEED_CHNG_UP_DN
	movlw	D'0'
SPEED_CHNG_100
	movwf	FEEDBACK
SPEED_CHNG_UP_DN
	movlw	EEPROMF
	call	EEREAD		; sets EEADR
	movf	SPEED_CHNG,w
	call	EEWRITE		; write to EEPROM
	goto	DISP_CHK1

; 10. PWM frequency (PULSE, EEPROMG) 
PULSE_UP
	decf	PULSE,f		; decrease
	movlw	D'10'
	btfsc	PULSE,7		; if set return to 01
	movwf	PULSE
	
PULSE_UP_DN
	movlw	EEPROMG
	call	EEREAD		; sets EEADR
	movf	PULSE,w
	call	EEWRITE		; write to EEPROM
	movf	PULSE,w
	andlw	B'00000011'	; just the ls divider bits
	movwf	PULSE
	movwf	T2CON
	bsf		T2CON,2		; enable timer 2
	goto	DISP_CHK1

DN_SW
; if mode is zero ignore switch
	movf	MODE,w		; mode value
	btfsc	STATUS,Z
	goto	DISP_CHNG	; was zero
; if select is 0 to 4 go to UP_SW
	movf	SELECT,w
	sublw	D'04'
	btfsc	STATUS,C
	goto	UP_SW

; select 5,6,7&8 left
; 5
	movf	SELECT,w
	xorlw	D'5'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_TV_SAT_DN
; 6
	movf	SELECT,w
	xorlw	D'6'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_INERTIA_DN
; 7
	movf	SELECT,w
	xorlw	D'7'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_STOP_DN
; 8
	movf	SELECT,w
	xorlw	D'8'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_FEEDBACK_DN
; 9
	movf	SELECT,w
	xorlw	D'9'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_SPEED_CHNG_DN
; 10
	movf	SELECT,w
	xorlw	D'10'
	btfsc	STATUS,Z	; when zero 
	goto	LOAD_PULSE_DN
	goto	DISP_CHK1

LOAD_TV_SAT_DN ; TV, SAT1, SAT2 selection
	incf	CODES,f
	movf	CODES,w
	sublw	D'2'		; if >2 then clear
	btfss	STATUS,C
	clrf	CODES
	movlw	EEPROME
	call	EEREAD		; sets EEADR
	movf	CODES,w
	call	EEWRITE		; write to EEPROM
	goto	DISP_CHK1

LOAD_INERTIA_DN
	movf	INERTIA,w	; store inertia value mainly to restore bit 7 (on or off)
	movwf	TEMP1    
	bcf		INERTIA,7	; clear inertia on/off bit                                                            
	decf	INERTIA,f	; next value
	btfss	INERTIA,7	; if bit 7 set return to 100
	goto	INERTIA_UP_DN
	movlw	D'100'
	goto	INERTIA_100	; load 100
LOAD_STOP_DN
	decf	STOP_RATE,f		; decrease
	btfss	STOP_RATE,7	; if set return to 100
	goto	STOP_UP_DN
	movlw	D'100'
	goto	STOP_100
LOAD_FEEDBACK_DN
	decf	FEEDBACK,f	; decrease
	btfss	FEEDBACK,7	; if set return to 100
	goto	FEEDBACK_UP_DN
	movlw	D'100'
	goto	FEEDBACK_100
LOAD_SPEED_CHNG_DN
	decf	SPEED_CHNG,f ; decrease
	btfss	SPEED_CHNG,7 ; if set return to 100
	goto	SPEED_CHNG_UP_DN
	movlw	D'100'
	goto	SPEED_CHNG_100
LOAD_PULSE_DN
	incf	PULSE,f		; increase
	movf	PULSE,w
	andlw	B'00000011'
	xorlw	B'00000011'	; if bits set clear	
	btfsc	STATUS,Z	; if = set at 0
	clrf	PULSE
	goto	PULSE_UP_DN
; .......................

SELECT_SW
; if mode is zero ignore switch
	movf	MODE,w		; mode value
	btfsc	STATUS,Z
	goto	DISP_CHNG	; was zero

; increment SELECT value
; stop at 10 then to 0
	incf	SELECT,f
	movf	SELECT,w
	sublw	D'10'
	btfss	STATUS,C
	clrf	SELECT		; when reaches 11 clear	
; store
	movlw	EEPROMH
	call	EEREAD		; 
	movf	SELECT,w
	call	EEWRITE
	
	movlw	D'10'		; select delay for change rate
	goto	DISP_CHK2

MODE_TOGGLE
	movf	MODE,w
	movlw	D'00'		; clear	
	btfsc	STATUS,Z
	movlw	D'01'		; set
	movwf	MODE		; set if was clear
	clrf	DISPLAY
	movlw	D'10'
	goto	DISP_CHK2

DISP_CHK1
	movlw	D'5'
DISP_CHK2
	movwf	TIMER0		; delay timer
; if mode clear run DISP_CHNG
DISP_CHK
	movf	MODE,w
	btfsc	STATUS,Z
	goto	DISP_CHNG

; run SELECTed display format

	movlw	H'80'		; address line 1
	call	LOAD

; show selection
	movf	SELECT,w
	btfss	STATUS,Z	; when zero 
	goto	ONE
; SHOW_MAX speed
	movlw	A'M'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'X'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movf	MAX_SPEED0,w	; get value to show
	movwf	SET0
	movf	MAX_SPEED1,w
	movwf	SET1
	goto	SHOW_SPEED
; 1
ONE	movf	SELECT,w
	xorlw	D'1'
	btfss	STATUS,Z	; when zero 
	goto	TWO
; SHOW_MIN speed
	movlw	A'M'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movf	MIN_SPEED0,w	; get value to show
	movwf	SET0
	movf	MIN_SPEED1,w
	movwf	SET1
	goto	SHOW_SPEED
; 2
TWO	movf	SELECT,w
	xorlw	D'2'
	btfss	STATUS,Z	; when zero 
	goto	THREE
; SHOW_LOCKOUT speed
	movlw	A'L'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'C'
	call	DRV_LCD
	movlw	A'K'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movf	LOCKOUT0,w	; get value to show
	movwf	SET0
	movf	LOCKOUT1,w
	movwf	SET1
	goto	SHOW_SPEED
; 3
THREE
	movf	SELECT,w
	xorlw	D'3'
	btfss	STATUS,Z	; when zero 
	goto	FOUR
; SHOW_CURRENT (DEFAULT) speed
	movlw	A'D'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'F'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'L'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	EEPROMA
	call	EEREAD
	movwf	SET0
	movlw	EEPROMB
	call	EEREAD
	movwf	SET1
	
SHOW_SPEED
	call	SPACE1
 	movlw	A'S'
	call	DRV_LCD
	movlw	A'P'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	movlw	D'10'
	call	SPACEX
	goto	NXT_DSP
; 4
FOUR
	movf	SELECT,w
	xorlw	D'4'
	btfss	STATUS,Z	; when zero 
	goto	FIVE
; SHOW_LOC_REM
	btfsc	LOC_REM,0	; set is local
	goto	LOC_SHOW
; remote
	movlw	A'R'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	D'11'
	call	SPACEX
	goto	NXT_DSP
LOC_SHOW
	movlw	A'L'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'C'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'L'
	call	DRV_LCD
	movlw	D'12'
	call	SPACEX
	goto	NXT_DSP
; 5
FIVE
	movf	SELECT,w
	xorlw	D'5'
	btfss	STATUS,Z	; when zero 
	goto	SIX
; SHOW_CODES
	movlw	A'C'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	call	SPACE1
	movf	CODES,w
	btfss	STATUS,Z
	goto	OTHER_SHOW
; TV
	movlw	A'T'
	call	DRV_LCD
	movlw	A'V'
	call	DRV_LCD

	movlw	D'2'
	call	SPACEX
COMMON_RATESHOW
	call	SPACE1
	movlw	A'<'	; <
	call	DRV_LCD
	movf	REM_RATE,w
	addlw	H'30'	; convert number 0-9 to ASCII
	call	DRV_LCD
	movlw	A'>'	; >
	call	DRV_LCD
	movlw   D'4'
	call	SPACEX
	goto	NXT_DSP	
OTHER_SHOW
	movlw	A'S'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movf	CODES,w
	xorlw	D'01'
	btfss	STATUS,Z
	goto	OTHER_SHOW2
	movlw	A'1'
	call	DRV_LCD
	goto	COMMON_RATESHOW
OTHER_SHOW2
	movlw	A'2'
	call	DRV_LCD
	goto	COMMON_RATESHOW
; 6
SIX	movf	SELECT,w
	xorlw	D'6'
	btfss	STATUS,Z	; when zero 
	goto	SEVEN
; SHOW_INERTIA
	movlw	A'I'
	call	DRV_LCD
	movlw	A'N'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'R'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'I'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	D'02'
	call	SPACEX
; show inertia value	
	movf	INERTIA,w
	andlw	B'01111111'
COMMON_SHOW
	call	DISPLAY_NUMBER
	movlw	D'06'
	call	SPACEX
	goto	NXT_DSP

; 7
SEVEN
	movf	SELECT,w
	xorlw	D'7'
	btfss	STATUS,Z	; when zero 
	goto	EIGHT
; SHOW_STOP
	movlw	A'S'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'P'
	call	DRV_LCD
	movlw	D'5'	
	call	SPACEX

; show stop rate value	
	movf	STOP_RATE,w
	goto	COMMON_SHOW

; 8
EIGHT
	movf	SELECT,w
	xorlw	D'8'
	btfss	STATUS,Z	; when zero 
	goto	NINE
; SHOW_FEEDBACK
	movlw	A'F'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	movlw	A'B'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'C'
	call	DRV_LCD
	movlw	A'K'
	call	DRV_LCD
	call	SPACE1
; show feedback value	
	movf	FEEDBACK,w
	goto	COMMON_SHOW

;9
NINE
	movf	SELECT,w
	xorlw	D'9'
	btfss	STATUS,Z	; when zero 
	goto	TEN
; SHOW_SPEED CHANGE	
	movlw	A'S'
	call	DRV_LCD
	movlw	A'P'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	call 	SPACE1
	movlw	A'R'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'M'
	call	DRV_LCD
	movlw	A'P'
	call	DRV_LCD
	call	SPACE1

; show speed change rate value	
	movf	SPEED_CHNG,w
	goto	COMMON_SHOW

;10
TEN
	movf	SELECT,w
	xorlw	D'10'
	btfss	STATUS,Z	; when zero 
	goto	NXT_DSP
; SHOW_PWM rate
	movlw	A'P'
	call	DRV_LCD
	movlw	A'U'
	call	DRV_LCD
	movlw	A'L'
	call	DRV_LCD
	movlw	A'S'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	D'03'
	call	SPACEX

; show pwm rate value	
	btfsc	PULSE,1
	goto	WRI_122		; write 122Hz
	btfss	PULSE,0
	goto	WRI_1953	; write 1953 Hz
; write 488Hz
	call	SPACE1
	movlw	A'4'
	call	DRV_LCD
	movlw	A'8'
	call	DRV_LCD
	movlw	A'8'
	call	DRV_LCD
	goto	HERTZ
WRI_122
	call	SPACE1
	movlw	A'1'
	call	DRV_LCD
	movlw	A'2'
	call	DRV_LCD
	movlw	A'2'
	call	DRV_LCD
	goto	HERTZ
WRI_1953
	movlw	A'1'
	call	DRV_LCD
	movlw	A'9'
	call	DRV_LCD
	movlw	A'5'
	call	DRV_LCD
	movlw	A'3'
	call	DRV_LCD
HERTZ
	movlw	A'H'
	call	DRV_LCD
	movlw	A'z'
	call	DRV_LCD
	movlw	D'06'
	call	SPACEX
;	goto	NXT_DSP

NXT_DSP
	movlw	H'C0'		; address line 2
	call	LOAD
	btfss	SET_FLG,0	; if set show loaded
	goto	LOAD_SPACE
	bcf		SET_FLG,0	; cleared
	movlw	A'L'
	call	DRV_LCD
	movlw	A'O'
	call	DRV_LCD
	movlw	A'A'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'D'
	call	DRV_LCD
	movlw	D'10'
	goto	SP_LESS
LOAD_SPACE
; if SELECT is for MAXIMUM, MINIMUM, LOCKOUT and CURRENT SPEEDs show value

	movf	SELECT,w
	sublw	D'03'
	btfss	STATUS,C
	goto	SEVENTEEN_SP

; show set at ?
	movlw	A'S'
	call	DRV_LCD
	movlw	A'E'
	call	DRV_LCD
	movlw	A'T'
	call	DRV_LCD
	movlw	A'@'
	call	DRV_LCD
	call	SPACE1
; show speed as a number 0-204 so shift right
; check if >H333 (80%) if so set at 80%

	btfss	SPEED0,0
	goto	DISP_ROLL
	btfss	SPEED0,1
	goto	DISP_ROLL
	movlw	H'33'
	subwf	SPEED1,w
	btfss	STATUS,C
	goto	DISP_ROLL
	movlw	H'33'
	movwf	SPEED1
DISP_ROLL ; show as 8-bit number
	rrf		SPEED0,w
	movwf	TEMPB0
	rrf		SPEED1,w
	movwf	TEMPB1
	rrf		TEMPB0,w
	rrf		TEMPB1,w	
	call	DISPLAY_NUMBER
	movlw	A'?'
	call	DRV_LCD
	movlw	D'2'
	call	SPACEX
	movlw	A'('
	call	DRV_LCD
; show setting speed as a number 0-204 so shift right
	rrf		SET0,w
	movwf	TEMPB0
	rrf		SET1,w
	movwf	TEMPB1
	rrf		TEMPB0,w
	rrf		TEMPB1,w	
	call	DISPLAY_NUMBER
	movlw	A')'
	call	DRV_LCD
	movlw	D'1'
	goto	SP_LESS
SEVENTEEN_SP
	movlw	D'17'
SP_LESS
	call	SPACEX
	goto	DISP_CHNG

; *********************
CK_DISP_UPDATE
; update display at a slower rate but immediate on any action update
	movf	TIMER5,w
	btfss	STATUS,Z
	goto	MON_I_EMF
	movlw	D'12'
	movwf	TIMER5
	goto	DISP_CHNGX

DISP_CHNG2
	movlw	D'10'	
	goto	BY_CHNG1
DISP_CHNG1
	movlw	D'5'
BY_CHNG1
	movwf	TIMER0		; delay timer
	clrf	DISPLAY
DISP_CHNG
; display driving for mode 0
	movf	MODE,w
	btfss	STATUS,Z	; if zero then can run this display
	goto	MON_I_EMF
	btfsc	DISPLAY,0	; if clear update
	goto	CK_DISP_UPDATE
DISP_CHNGX
	movlw	D'04'
	movwf	TIMER5
; display changes 
	movlw	H'80'		; address line 1
	call	LOAD

; track setting level bargraph display

; calculate speed
	
; (run0,1 - speed min) x 60/(speedmax-speedmin)

; speed 0,1 - speed min
	bcf		INTCON,GIE
	movf	MIN_SPEED0,w	; ms byte min speed
	subwf	RUN0,w
	movwf	AARGB0
	movf	MIN_SPEED1,w	; ls byte min speed
	subwf	RUN1,w
	bsf		INTCON,GIE
	movwf	AARGB1
	btfss	STATUS,C
	decf	AARGB0,f		; decrease if carry
	btfss	AARGB0,7		; if bit 7 is set, set speed at 0%
	goto	SP60_1
	clrf	AARGB2			; 0%
	goto	TRACK_BAR
SP60_1
; speed x 60
	clrf	BARGB0
	movlw	D'60'
	movwf	BARGB1	
	bsf		PCLATH,3		; page 1
	call    FXM1616U

; speed max - speed min
	movf	MIN_SPEED0,w	; ms byte min speed
	subwf	MAX_SPEED0,w
	movwf	BARGB0
	movf	MIN_SPEED1,w	; ls byte min speed
	subwf	MAX_SPEED1,w
	movwf	BARGB1
	btfss	STATUS,C
	decf	BARGB0,f		; decrease if carry
; divide by subtracted value (range between max and min)
; shift multiply bytes left
	movf	AARGB1,w
	movwf	AARGB0
	movf	AARGB2,w
	movwf	AARGB1
	movf	AARGB3,w
	movwf	AARGB2
	bsf		PCLATH,3		; page 1
	call	FXD2416U		; divide

; check values
	movf	AARGB0,w		; check for overrange of ms byte
	movlw	D'60'
	btfss	STATUS,Z
	movwf	AARGB2			; if AARGB0 is not zero set AARGB2 at 60 
; make sure not >60
	movlw	D'61'			; take 61 away
	subwf	AARGB2,w
	movlw	D'60'
	btfsc	STATUS,C
	movwf	AARGB2		;	; set at 60 if >60 	

; AARGB2 has division (0-60)
; drive bargraph
TRACK_BAR
	call	BAR_DRV

DIRECTION_WRI

; check for overload and write OVER
	btfss	OVERLOAD,0
	goto	ARROWS
	movlw	A'O'		; OL
	call	DRV_LCD
	movlw	A'V'		; OL
	call	DRV_LCD
	movlw	A'E'		; OL
	call	DRV_LCD
	movlw	A'R'		; OL
	call	DRV_LCD
	goto	LINE2
ARROWS
	movlw	H'7E'		; right arrow
	btfss	FOR_REV,0
	movlw	H'7F'		; left arrow
	call	DRV_LCD

LOCKOUT
	movlw	H'20'		; space	
	btfsc	LOCK,0
	movlw	H'04'		; lock symbol
	call	DRV_LCD

; show I for inertia on and S for stop
SHOW_STOP
	movlw	H'20'		; space	
	btfss	STOP_OP,0	; if clear stop is on, if set then STOP is off
	movlw	A'S'		; stop indication sign
	call	DRV_LCD
	
; Inertia?
	movlw	H'20'		; space
	btfss	INERTIA,7	; if bit 7 set no inertia
	movlw	A'I'
	call	DRV_LCD

LINE2
	movf	DISPLAY,w	; if clear update line 2
	btfss	STATUS,Z
	goto	MON_I_EMF
	bsf		DISPLAY,0
; line 2
	movlw	H'C0'		; address line 2
	call	LOAD
; speed setting level bargraph display

; calculate speed
	
; (speed0,1 - speed min) x 60/(speedmax-speedmin)

; speed 0,1 - speed min
	bcf		INTCON,GIE
	movf	MIN_SPEED0,w	; ms byte min speed
	subwf	SPEED0,w
	movwf	AARGB0
	movf	MIN_SPEED1,w	; ls byte min speed
	subwf	SPEED1,w
	bsf		INTCON,GIE
	movwf	AARGB1
	btfss	STATUS,C
	decf	AARGB0,f		; decrease if carry
	btfss	AARGB0,7		; if bit 7 is set, set speed at 0%
	goto	SP60
	clrf	AARGB2			; 0%
	goto	SETTING_BAR
SP60
; speed x 60
	clrf	BARGB0
	movlw	D'60'
	movwf	BARGB1	
	bsf		PCLATH,3		; page 1
	call    FXM1616U

; speed max - speed min
	movf	MIN_SPEED0,w	; ms byte min speed
	subwf	MAX_SPEED0,w
	movwf	BARGB0
	movf	MIN_SPEED1,w	; ls byte min speed
	subwf	MAX_SPEED1,w
	movwf	BARGB1
	btfss	STATUS,C
	decf	BARGB0,f		; decrease if carry
; divide by subtracted value (range between max and min)
; shift multiply bytes left
	movf	AARGB1,w
	movwf	AARGB0
	movf	AARGB2,w
	movwf	AARGB1
	movf	AARGB3,w
	movwf	AARGB2
	bsf		PCLATH,3		; page 1
	call	FXD2416U		; divide

; check values
	movf	AARGB0,w		; check for overrange of ms byte
	movlw	D'60'
	btfss	STATUS,Z
	movwf	AARGB2			; if AARGB0 is not zero set AARGB2 at 60 
; make sure not >60
	movlw	D'61'			; take 61 away
	subwf	AARGB2,w
	movlw	D'60'
	btfsc	STATUS,C
	movwf	AARGB2		;	; set at 60 if >60 	

; AARGB2 has division (0-60)
; drive bargraph
SETTING_BAR
	call	BAR_DRV
	goto	NUMBER_SHOW

; set spaces counter subroutine
BAR_DRV
	movlw	D'11'			; 11 spaces max or 12 if value for speed is 0
	movwf	BAR				; store
	
BAR_END_CK
	btfsc	BAR,7			; when past 0 end
	return					; end of bar

; compare with 0
	movf	AARGB2,w
	btfsc	STATUS,Z		; when zero write space/s
	goto	A0
; compare with 1
	movlw	H'01'
	xorwf	AARGB2,w		; if 1 write left hand single bar		
	btfsc	STATUS,Z
	goto	A1
; compare with 2
	movlw	H'02'
	xorwf	AARGB2,w		; if 2 write left hand 2-bars		
	btfsc	STATUS,Z
	goto	A2
; compare with 3
	movlw	H'03'
	xorwf	AARGB2,w		; if 3 write left hand 3-bars		
	btfsc	STATUS,Z
	goto	A3
; compare with 4
	movlw	H'04'
	xorwf	AARGB2,w		; if 4 write left hand 4-bars		
	btfsc	STATUS,Z
	goto	A4
; compare with 5
	movlw	H'05'
	xorwf	AARGB2,w		; if 5 write left hand 5-bars		
	btfsc	STATUS,Z
	goto	A5				
; not 0,1,2,3,4,5 so > more. Write 5-bars
	movlw	H'FF'			; 5 bars
	call	DRV_LCD
; subtract 5 from AARGB3 for next bar calculation
	movlw	D'05'
	subwf	AARGB2,f		; reduce for next bar
	decf	BAR,f			; decrease space allocations as bar extends
	goto	BAR_END_CK		; continue bargraph calculation: check if end of bargraph

A0	incf	BAR,f			; 12 spaces
	goto	DRV_SPACES
A1	movlw	H'00'			; 1 bar
	call	DRV_LCD
	goto	DRV_SPACES
A2	movlw	H'01'			; 2 bars
	call	DRV_LCD
	goto	DRV_SPACES
A3	movlw	H'02'			; 3 bars
	call	DRV_LCD
	goto	DRV_SPACES
A4	movlw	H'03'			; 4 bars
	call	DRV_LCD
	goto	DRV_SPACES
A5	movlw	H'FF'			; 5 bars
	call	DRV_LCD
	goto	DRV_SPACES

DRV_SPACES
	movf	BAR,w
	btfsc	STATUS,Z
	return					; end of bar
	movf	BAR,w
	call	SPACEX			; fill remainder with spaces
	return

NUMBER_SHOW

; show % speed setting
; (speed0,1 - min speed) x 100/(speedmax-speedmin)

; speed 0,1 - speed min
	bcf		INTCON,GIE
	movf	MIN_SPEED0,w	; ms byte min speed
	subwf	SPEED0,w
	movwf	AARGB0
	movf	MIN_SPEED1,w	; ls byte min speed
	subwf	SPEED1,w
	bsf		INTCON,GIE
	movwf	AARGB1
	btfss	STATUS,C
	decf	AARGB0,f		; decrease if carry
	btfss	AARGB0,7		; if bit 7 is set, set speed at 0%
	goto	SP100
	clrf	AARGB2			; 0%
	goto	PERCENT_DRV
	
SP100
; speed x 100
	clrf	BARGB0
	movlw	D'100'
	movwf	BARGB1	
	bsf		PCLATH,3		; page 1
	call    FXM1616U

; speed max - speed min
	movf	MIN_SPEED0,w	; ms byte min speed
	subwf	MAX_SPEED0,w
	movwf	BARGB0
	movf	MIN_SPEED1,w	; ls byte min speed
	subwf	MAX_SPEED1,w
	movwf	BARGB1
	btfss	STATUS,C
	decf	BARGB0,f		; decrease if carry

; divide by subtracted value (range between max and min)

; shift multiply bytes left
	movf	AARGB1,w
	movwf	AARGB0
	movf	AARGB2,w
	movwf	AARGB1
	movf	AARGB3,w
	movwf	AARGB2
	bsf		PCLATH,3		; page 1
	call	FXD2416U		; divide

; check values
	movf	AARGB0,w
	movlw	D'100'
	btfss	STATUS,Z
	movwf	AARGB2			; if AARGB0 is not zero set AARGB2 at 100 
; make sure not >100
	movlw	D'101'			; take 101 away
	subwf	AARGB2,w
	movlw	D'100'
	btfsc	STATUS,C
	movwf	AARGB2			; set at 100 if >100 

; AARGB2 has division (0-100)
PERCENT_DRV
	movf	AARGB2,w
	call	DISPLAY_NUMBER
	goto	PERCENT

DISPLAY_NUMBER
	movwf	BIN_0		; binary value
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD1
	call	SPACE1		; leading 0's to space
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD2
	call	SPACE1		; leading 0's to space
	goto	LOAD3
LOAD1
	movf	OUT1,w
	call	DRV_LCD
LOAD2
	movf	OUT2,w
	call	DRV_LCD
LOAD3
	movf	OUT3,w
	call	DRV_LCD
	return

PERCENT		
	movlw	A'%'		; %
	call	DRV_LCD

; *************************
MON_I_EMF ; monitor current and back emf

; A/D conversion
; channel 4, current
	bcf		ADCON0,3
	bsf		ADCON0,5
	bcf		ADCON0,4
; wait 20us to charge input capacitance
	movlw	D'5'
	movwf	STORE3
WAIT20A
	decfsz	STORE3,f
	goto	WAIT20A	
		
	call	ACQUIRE_AD
	movf	ADRESH,w	; ms byte
	btfss	STATUS,Z	; if not zero overcurrent
	goto	OVER_I
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0
	sublw	D'123'		; 6 Amps
	btfsc	STATUS,C
	goto	UNDER_I		; current level ok
OVER_I
	bsf		OVERLOAD,0	; set overload flag
	bcf		PORTB,1		; drive off
	bcf		PORTB,2
	bsf		PORTA,1		; drive buzzer
; Place OVER on display
	movlw	H'8C'
	call	LOAD
	movlw	A'O'		; OL
	call	DRV_LCD
	movlw	A'V'		; OL
	call	DRV_LCD
	movlw	A'E'		; OL
	call	DRV_LCD
	movlw	A'R'		; OL
	call	DRV_LCD
OVERLOAD_CONTINUE
	call	DELAY_BUZZER; delay
; restore for 1ms and check for overload

	btfss	FOR_REV,0	; restore forward reverse settings
	goto	FORWARD_RESET1
	bcf		PORTB,1		; 
	bsf		PORTB,2
	goto	REREAD
FORWARD_RESET1
	bcf		PORTB,2		; 
	bsf		PORTB,1
REREAD
; wait ~20ms for filter capacitor to recharge
	movlw	D'255'		; 25 is about 2ms
	call	DELAYX		;
; read current again
	call	ACQUIRE_AD
	movf	ADRESH,w	; ms byte
	btfss	STATUS,Z	; if not zero overcurrent
	goto	OVER_I1
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0
	sublw	D'123'		; 6 Amps
	btfsc	STATUS,C
	goto	UNDER_I		; current level ok
OVER_I1
	bcf		PORTB,1		; drive off
	bcf		PORTB,2
; loop till overload is off
	goto	OVERLOAD_CONTINUE

UNDER_I	
; if overload not set, restore values	
	btfss	OVERLOAD,0	; if set clear and restore portB
	goto	BACK_V		; if clear ensure overload is off

	btfss	FOR_REV,0	; restore forward reverse settings
	goto	FORWARD_RESET
	bcf		PORTB,1		; 
	bsf		PORTB,2
	goto	BACK_V
FORWARD_RESET
	bcf		PORTB,2		; 
	bsf		PORTB,1
BACK_V
	clrf	OVERLOAD
	bcf		PORTA,1		; overload buzzer off

BACK_V1
; read back EMF

; A/D conversion
; channel 3
	bsf		ADCON0,3
	bcf		ADCON0,5
	bsf		ADCON0,4
; wait 20us to charge input capacitance
	movlw	D'5'
	movwf	STORE3
WAIT20B
	decfsz	STORE3,f
	goto	WAIT20B	
		
	call	ACQUIRE_AD
	movf	ADRESH,w	; ms byte
	movwf	BACK_EMF0
	bsf		STATUS,RP0	; select memory bank 1
	movf	ADRESL,w
	bcf		STATUS,RP0	; select memory bank 0
	movwf	BACK_EMF1

; SPEED RUN
; 1.set RUN0,1 to min speed if below this.(ie keep within min and max values)
	bcf		INTCON,GIE
	movf	RUN0,w		; ms byte current speed
	subwf	MIN_SPEED0,w
	movwf	TEMP0
	movf	RUN1,w		; ls byte current speed
	bcf		INTCON,GIE
	subwf	MIN_SPEED1,w
	movwf	TEMP1
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfsc	TEMP0,7		; if set then speed is greater than minimum speed 
	goto	CK_LOCK_FOR_REV	
; transfer min speed setting to current
	bcf		INTCON,GIE
	movf	MIN_SPEED0,w
	movwf	RUN0
	movf	MIN_SPEED1,w
	movwf	RUN1
	bcf		INTCON,GIE

; 2.Forward/rev must only change at lockout speed or below. So set lock whenever speed too high
; compare RUN0, RUN1 with LOCKOUT0, LOCKOUT1 if less then lock is off.(LOCK,0 set is lock)
; release lockout when run speed<lockout
CK_LOCK_FOR_REV
	bcf		INTCON,GIE
	movf	RUN0,w		; ms byte current speed
	subwf	LOCKOUT0,w
	movwf	TEMP0
	movf	RUN1,w		; ls byte current speed
	bsf		INTCON,GIE
	subwf	LOCKOUT1,w
	movwf	TEMP1
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfss	TEMP0,7		; if set then speed is greater than lockout speed
	goto	CLEAR_LOCK
	bsf		LOCK,0		; set lock when required
	goto	FEEDBACK_CONTROL
CLEAR_LOCK
	clrf	LOCK

FEEDBACK_CONTROL

	movf	FEEDBACK,w	; if feedback value is zero bypass feedback control calculation
	btfsc	STATUS,Z
	goto	RUN_CYCLE
; Subtract back emf from run to get difference (if negative reverse subtraction)
	bcf		INTCON,GIE
	movf	BACK_EMF0,w	; ms back EMF 
	subwf	RUN0,w		; run value
	movwf	TEMP0
	movf	BACK_EMF1,w	; ls back EMF 
	subwf	RUN1,w
	movwf	TEMP1
	bsf		INTCON,GIE
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	btfss	TEMP0,7		; if set then below zero so reverse subtraction
	goto	MULT1
; reverse subtraction
	bcf		INTCON,GIE
	movf	RUN0,w		; ms run value 
	subwf	BACK_EMF0,w	; back EMF
	movwf	TEMP0
	movf	RUN1,w		; ls run
	subwf	BACK_EMF1,w
	movwf	TEMP1
	bsf		INTCON,GIE
	btfss	STATUS,C
	decf	TEMP0,f		; decrease if carry
	bsf		SIGN,0
	goto	MULT
; multiply difference by FEEDBACK 
MULT1
	clrf	SIGN		; positive sign
MULT
	movf	TEMP0,w		; ms difference
	movwf	AARGB0
	movf	TEMP1,w
	movwf	AARGB1
	movf	FEEDBACK,w
	movwf	BARGB1
	clrf	BARGB0
	bsf		PCLATH,3	; page 1
	call	FXM1616U	; multiply

; shift multiply bytes left
	movf	AARGB1,w
	movwf	AARGB0
	movf	AARGB2,w
	movwf	AARGB1
	movf	AARGB3,w
	movwf	AARGB2
; divide by
	movlw	D'50'		; back EMF control division factor 
	movwf	BARGB1
	clrf	BARGB0
	bsf		PCLATH,3	; page 1
	call	FXD2416U	; divide

	movf	AARGB1,w	; check if over
	sublw	B'00000011'
	btfss	STATUS,C
	goto	OVER_VAL
	movf	AARGB1,w
	bcf		INTCON,GIE
	movwf	FEEDCONT0
	movf	AARGB2,w
	movwf	FEEDCONT1
	bsf		INTCON,GIE
	goto	RUN_CYCLE	; continue program cycle
OVER_VAL
; if over value set at max
	bcf		INTCON,GIE
	movlw	B'00000011'
	movwf	FEEDCONT0
	movlw	H'FF'
	movwf	FEEDCONT1
	bsf		INTCON,GIE
	goto	RUN_CYCLE

; *******************************************************************************************
; subroutines

; subroutine to wait for A/D conversion
ACQUIRE_AD
	bsf		ADCON0,2	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return

; add space in display

SPACEX
	movwf	STORE3
SP_CONT	
	movlw	H'20'		; space
	call	DRV_LCD
	decfsz	STORE3,f
	goto	SP_CONT		; space continue
	return

SPACE1
	movlw	H'20'		; space
	call	DRV_LCD
	return

; buzzer delay loop
DELAY_BUZZER
	movlw	H'04'
	movwf	STORE3
LOOP_BUZZER
	movlw	H'FF'		; delay 
	call	DELAYX
	decfsz	STORE3,f	; next store3
	goto	LOOP_BUZZER	
	return

; delay loop 

DELAYms
	movlw	D'25'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'A'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8		; decrease till STORE1 is zero
	return


DELAYY
	movlw	H'FF'
	movwf	STORE1		; STORE1 is number of loops value
LOOPA	
	movlw	D'100'
	movwf	STORE2		; STORE2 is internal loop value	
LOOPB
	decfsz	STORE2,f
	goto	LOOPB
	decfsz	STORE1,f
	goto	LOOPA		; decrease till STORE1 is zero
	return

; initialise display

INIT_LC
	bcf		PORTA,1		; RS low

; portb4-7 outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000001'	; RB4-RB7 outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

	movlw	B'00110000'	; initialise module
	movwf	PORTB
	nop
	bsf		PORTA,0		; enable high
	nop
	bcf		PORTA,0		; low

; portb4-7 inputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11110001'	; RB1-RB7 inputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO		; store data

; portb4-7 outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000001'	; RB4-RB7 outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

	movlw	B'00001111'
	andwf	PORTB,f		; set ms bits low	
	movf	D_STO,w
	andlw	H'F0'		; get upper bits
; place display commands in portB
	iorwf	PORTB,f		; set ms bits
	bcf		PORTA,1		; register select low
	nop
	bsf		PORTA,0		; enable set
	nop
	bcf		PORTA,0		; enable clear

; if overload set PORTA,1 high
	btfsc	OVERLOAD,0
	bsf		PORTA,1

SECOND_BYTE
	movlw	B'00001111'
	andwf	PORTB,f		; set ms bits low	
	swapf	D_STO,w
	andlw	H'F0'		; get lower bits
; place display commands in portB
	iorwf	PORTB,f		; set ms bits
	bcf		PORTA,1		; register select low
	nop
	bsf		PORTA,0		; enable set
	nop
	bcf		PORTA,0		; enable clear

; if overload set PORTA,1 high
	btfsc	OVERLOAD,0
	bsf		PORTA,1
	
; portb4-7 inputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11110001'	; RB1-RB7 inputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

	goto	BUS_CK		; check busy flag
	
; driving the LCD module with display data

DRV_LCD	
	movwf	D_STO		; store data

; portb4-7 outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000001'	; RB4-RB7 outputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

	movlw	B'00001111'
	andwf	PORTB,f		; set ms bits low	
	movf	D_STO,w
	andlw	H'F0'		; get upper bits
; place display commands in portB
	iorwf	PORTB,f		; set ms bits
	bsf		PORTA,1		; register select high
	nop
	bsf		PORTA,0		; enable set
	nop
	bcf		PORTA,0		; enable clear

; if overload keep PORTA,1 high
	btfss	OVERLOAD,0
	bcf		PORTA,1

	movlw	B'00001111'
	andwf	PORTB,f		; set ms bits low	
	swapf	D_STO,w
	andlw	H'F0'		; get lower bits

; place display commands in portB
	iorwf	PORTB,f		; set ms bits
	bsf		PORTA,1		; register select high
	nop
	bsf		PORTA,0		; enable set
	nop
	bcf		PORTA,0		; enable clear

; if overload keep PORTA,1 high
	btfss	OVERLOAD,0
	bcf		PORTA,1

; portb4-7 inputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'11110001'	; RB1-RB7 inputs
	movwf	TRISB		; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0

BUS_CK
	movlw 	D'1'		; 
	movwf	STORE1		; delay values
	movlw	D'28'		; delay for busy flag to clear
	goto	DELDSP


; binary to ASCII
BCD_ASCII
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf	BCD_0
	clrf	BCD_1		; set BCD registers to 0 
LOOPBCD
	rlf		BIN_0,f		; shift left binary registers
	rlf		BCD_1,f		; MSB shift left

	rlf		BCD_0,f		; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust

; completed decimal to BCD operation, convert to unpacked ASCII
	
	movf	BCD_1,w		; ls decimal
	andlw	H'0F'		; ls
	addlw	H'30'		; convert to ASCII
	movwf	OUT3
	swapf	BCD_1,w 	; mid decimal value
	andlw	H'0F'
	addlw	H'30'		; convert to ASCII
	movwf	OUT2
	movf	BCD_0,w
	addlw	H'30'		; convert to ASCII
	movwf	OUT1		; ms decimal value
	return				; ASCII values returned in OUT1, OUT2, OUT3 

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR			; pointer for BCD1
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR			; pointer for BCD0
	call	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD	
	movlw	H'03'		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	H'30'		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP1	; select bank 0
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 	STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 


; page 1

	org	H'C00'	; page 1

; character generation for level bars	
CHARACTER_GEN
	bcf		PCLATH,3	; page 0
; character 1, left bar
	movlw	B'01000000'	; address 0
	call	LOAD		; character gen 1 
	movlw	B'00010000'
	call	DRV_LCD
	movlw	B'00010000'
	call	DRV_LCD
	movlw	B'00010000'
	call	DRV_LCD
	movlw	B'00010000'
	call	DRV_LCD
	movlw	B'00010000'
	call	DRV_LCD
	movlw	B'00010000'
	call	DRV_LCD
	movlw	B'00010000'
	call	DRV_LCD
	movlw	B'00010000'
	call	DRV_LCD
; character 2
; 2-bars
	movlw	B'00011000'
	call	DRV_LCD
	movlw	B'00011000'
	call	DRV_LCD
	movlw	B'00011000'
	call	DRV_LCD
	movlw	B'00011000'
	call	DRV_LCD
	movlw	B'00011000'
	call	DRV_LCD
	movlw	B'00011000'
	call	DRV_LCD
	movlw	B'00011000'
	call	DRV_LCD
	movlw	B'00011000'
	call	DRV_LCD

; character 3
; 3-bars
	movlw	B'00011100'
	call	DRV_LCD
	movlw	B'00011100'
	call	DRV_LCD
	movlw	B'00011100'
	call	DRV_LCD
	movlw	B'00011100'
	call	DRV_LCD
	movlw	B'00011100'
	call	DRV_LCD
	movlw	B'00011100'
	call	DRV_LCD
	movlw	B'00011100'
	call	DRV_LCD
	movlw	B'00011100'
	call	DRV_LCD

; character 4
; 4-bars
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD
	movlw	B'00011110'
	call	DRV_LCD

; 5-bars use HFF

; character 5
; lock symbol
	movlw	B'00001110'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00000000'
	call	DRV_LCD

	return


; Math routines

;

; 24/16 Bit Unsigned Fixed Point Divide 

;       Input:  24 bit unsigned fixed point dividend in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point divisor in BARGB0, BARGB1

;       Use:    CALL    FXD2416U

;       Output: 24 bit unsigned fixed point quotient in AARGB0, AARGB1,AARGB2
;               16 bit unsigned fixed point remainder in REMB0, REMB1

;       Result: AARG, REM  <--  AARG / BARG


FXD2416U    	CLRF            REMB0
                CLRF            REMB1
                CLRF            TEMPD
                RLF             AARGB0,W
                RLF             REMB1,F
                MOVF            BARGB1,W
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                RLF             AARGB0,F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416A      RLF             AARGB0,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46LA
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46LA
UADD46LA        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46LA 		RLF             AARGB0,F
                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU2416A
                RLF             AARGB1,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB0,0
                GOTO            UADD46L8
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46L8
UADD46L8        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46L8         RLF             AARGB1,F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416B      RLF             AARGB1,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46LB
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46LB
UADD46LB        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46LB         RLF             AARGB1,F
                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU2416B
                RLF             AARGB2,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB1,0
                GOTO            UADD46L16
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46L16
UADD46L16       ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46L16        RLF             AARGB2,F
                MOVLW           H'7'
                MOVWF           LOOPCOUNT
LOOPU2416C      RLF             AARGB2,W
                RLF             REMB1,F
                RLF             REMB0,F
                RLF             TEMPD,F
                MOVF            BARGB1,W
                BTFSS           AARGB2,0
                GOTO            UADD46LC
                SUBWF           REMB1,F
                MOVF            BARGB0,W
                BTFSS           STATUS,C
                INCFSZ          BARGB0,W
                SUBWF           REMB0,F
                CLRW
                BTFSS           STATUS,C
                MOVLW           H'1'
                SUBWF           TEMPD,F
                GOTO            UOK46LC
UADD46LC        ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
                CLRW
                BTFSC           STATUS,C
                MOVLW           H'1'
                ADDWF           TEMPD,F
UOK46LC 		RLF             AARGB2,F
                DECFSZ          LOOPCOUNT,F
                GOTO            LOOPU2416C
                BTFSC           AARGB2,0
                GOTO            UOK46L
                MOVF            BARGB1,W
	        	ADDWF           REMB1,F
                MOVF            BARGB0,W
                BTFSC           STATUS,C
                INCFSZ          BARGB0,W
                ADDWF           REMB0,F
UOK46L			bcf				PCLATH,3		; page 0
				RETURN

; multiply
;
;       Input:  fixed point arguments in AARG and BARG
;
;       Output: product AARGxBARG in AARG
;

;       16x16 Bit Unsigned Fixed Point Multiply 

;       Input:  16 bit unsigned fixed point multiplicand in AARGB0
;               16 bit unsigned fixed point multiplier in BARGB0

;       Use:    CALL    FXM1616U

;       Output: 32 bit unsigned fixed point product in AARGB0



FXM1616U        CLRF    AARGB2          ; clear partial product
                CLRF    AARGB3
                MOVF    AARGB0,W
                MOVWF   TEMPB0
                MOVF    AARGB1,W
                MOVWF   TEMPB1
                MOVLW   0x08
                MOVWF   LOOPCOUNT
LOOPUM1616A     RRF     BARGB1, F
                BTFSC   STATUS,C
                GOTO    ALUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616A
                MOVWF   LOOPCOUNT
LOOPUM1616B     RRF     BARGB0, F
                BTFSC   STATUS,C
                GOTO    BLUM1616NAP
                DECFSZ  LOOPCOUNT, F
                GOTO    LOOPUM1616B
                CLRF    AARGB0
                CLRF    AARGB1
                RETLW   0x00
BLUM1616NAP     BCF     STATUS,C
                GOTO    BLUM1616NA
ALUM1616NAP     BCF     STATUS,C
                GOTO    ALUM1616NA
ALOOPUM1616     RRF     BARGB1, F
                BTFSS   STATUS,C
                GOTO    ALUM1616NA
                MOVF    TEMPB1,W
                ADDWF   AARGB1, F
                MOVF    TEMPB0,W
                BTFSC   STATUS,C
                INCFSZ  TEMPB0,W
                ADDWF   AARGB0, F
ALUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                DECFSZ LOOPCOUNT, F
                GOTO   ALOOPUM1616
                MOVLW  0x08
                MOVWF  LOOPCOUNT
BLOOPUM1616     RRF    BARGB0, F
                BTFSS  STATUS,C
                GOTO   BLUM1616NA
                MOVF   TEMPB1,W
                ADDWF  AARGB1, F
                MOVF   TEMPB0,W
                BTFSC  STATUS,C
                INCFSZ TEMPB0,W
                ADDWF  AARGB0, F
BLUM1616NA      RRF    AARGB0, F
                RRF    AARGB1, F
                RRF    AARGB2, F
                RRF    AARGB3, F
                DECFSZ LOOPCOUNT, F
                GOTO   BLOOPUM1616
				bcf	   PCLATH,3		; page 0
                RETURN

	
	end


; Philips RC5 code for infra red transmission (also used with Marantz, Grundig and Loewe)
; Comprises 2 start bits, 1 toggle bit (alternates high or low on successive same key press)
; 5-system address bits and 6 command bits. Data stream starts with the start bits. 
; biphase encoding with high to a low transition = a low and low to high = high
; each bit transmitted at 1.778ms rate. Whole code at 24.889ms and next code starts 113.778ms
; later. Can decode by detecting first start bit then waiting 1.778ms + 444.5us for next start
; bit. Successive bits are 1.778ms apart. Total of 14 bits. 

;Address
;0 TV1
;1 TV2
;2 Videotext
;3 Expansion for TV1 and TV2
;4 Laser vision player
;5 VCR1
;6 VCR2
;7 Reserved
;8 SAT1
;9 Expansion for VCR1 and VCR2
;10 SAT2
;11 Reserved
;12 CD Video
;13 Reserved
;14 CD Photo
;15 Reserved
;16 Audio preamplifier1
;17 Tuner
;18 Analogue cassetter recorder
;19 Audio Preamp2
;20 CD
;21 Audio rack
;22 Audio Satellite
;23 DCC Recorder
;24 Reserved
;25 Reserved
;26 Writable CD
;27-31 Reserved

;Keycode commands 
;0 0
;1 1
;2 2
;3 3
;4 4
;5 5
;6 6
;7 7
;8 8
;9 9
;16 Volume +
;17 Volume -
;18 Brightness +
;19 Brightness -
;20 Colour saturation +
;21 Colour Saturation -
;22 Bass +
;23 Bass -
;24 Treble +
;25 Treble -
;26 Balance right
;27 balance left
;63 System select
;71 Dim local display

; Special commands
;10 1/2/3 digits /10
;11 Freq/prog/ch11
;12 standby
;13 Mute
;14 Personal preference
;15 Display
;28 Contrast +
;29 Contrast -
;30 Search +
;31 Tint/hue
;32 CH/prog +
;33 CH/prog -
;34 Alternate CH

;37 stereo/mono
;39 Tint/hue +
;48 Pause
;50 rewind
;52 wind
;53 play
;54 stop
;55 record
	
