#line 1 "D:/_work/projects/MikroC/CameraTimer-1.0.3/CameraTimer.c"
#line 176 "D:/_work/projects/MikroC/CameraTimer-1.0.3/CameraTimer.c"
void shoot(void);
unsigned char isButtonPressed(void);
void beep(void);
void beepLo(void);
void beepMed(void);
void beepHi(void);
void beepOK(void);
void beepFail(void);
void delay(void);


volatile unsigned int nInterruptsRemaining;
volatile unsigned short nDuration;



union
{
 unsigned int n;
 unsigned short byte[2];
} nSecondsBetweenShots;
unsigned int nSecondsRemaining;
unsigned short nDigit;

unsigned char bFlags;



void main(void)
{




 nInterruptsRemaining = 0;
 nDuration = 0;
 nSecondsBetweenShots.n = 0;
 nSecondsRemaining = 0;
 nDigit = 9;
 bFlags = 0;

 GPIO = 0b00000000;

 T1CON.T1CKPS1 = 1;
 T1CON.T1CKPS0 = 1;





 CMCON = 0b00000111;
 ANSEL = 0b00000000;
 TRISIO = 0b00001000;
 PIE1.T1IE = 1;





 INTCON.PEIE = 1;
 INTCON.GIE = 1;
 TMR1L =  (0xFFFF - ( 4000000  + 4000000  * 4 / 100 ) /4 / 8 / 8  + 4+ 32 )  & 0xff ;
 TMR1H =  (0xFFFF - ( 4000000  + 4000000  * 4 / 100 ) /4 / 8 / 8  + 4+ 32 )  >> 8 ;
 T1CON.TMR1ON = 1;
 beepOK();
 GPIO. GP1  =  1 ;

 for(;;)
 {





 if ( !GPIO. GP1 )
 {
 nDuration = 0;
 if (isButtonPressed())
 {
 GPIO. GP5  =  0 ;
 GPIO. GP1  =  1 ;
 nSecondsBetweenShots.n = 0;
 beepOK();
 }
 else
 {
 if (nInterruptsRemaining == 0)
 {
 nInterruptsRemaining =  8 ;
 nSecondsRemaining--;
 if (nSecondsRemaining == 0)
 {
 nSecondsRemaining = nSecondsBetweenShots.n;
 shoot();
 }
 }
 }
 }





 else
 {
  bFlags.F2  = 0;
 if (isButtonPressed())
 {
 nDuration = 0;
 while ( !GPIO. GP3 )
 {
 if (nDuration >=  8 )
 {
  bFlags.F2  = 1;
 beepHi();
 nDuration = 0;
 }
 }
 nDuration = 0;
 if (! bFlags.F2 )
 {
 nDigit++;
  bFlags.F1  = 1;
 if (nDigit > 9)
 {
 nDigit = 0;
 beepLo();
 }
 else
 beepHi();
 }
 }

 if ( bFlags.F1 )
 {
 if (nDuration >=  8 )
 {
 beepOK();

 nSecondsBetweenShots.n = nSecondsBetweenShots.n * 10 + nDigit;
 nDigit = 9;
  bFlags.F1  = 0;
 }
 }

 if ( bFlags.F2 )
 {
 if (nSecondsBetweenShots.n == 0)
 {
 nSecondsBetweenShots.byte[0] = Eeprom_read(0);
 nSecondsBetweenShots.byte[1] = Eeprom_read(1);
 }
 if (nSecondsBetweenShots.n == 0)
 beepFail();
 else
 {
 Eeprom_write(0, nSecondsBetweenShots.byte[0]);
 Eeprom_write(1, nSecondsBetweenShots.byte[1]);
 nInterruptsRemaining =  8 ;
 nSecondsRemaining = nSecondsBetweenShots.n;
 GPIO. GP1  =  0 ;
 shoot();
 }
 }
 }
 }
}

void shoot(void)
{
 GPIO. GP5  =  1 ;
 delay();
 GPIO. GP5  =  0 ;
}

void delay(void)
{
 Delay_ms(50);
}

unsigned char isButtonPressed(void)
{
 if ( !GPIO. GP3 )
 {
 Delay_us(500);
 Delay_us(500);
 if ( !GPIO. GP3 )
 return 1;
 }
 return 0;
}


void beepOK(void)
{
 beepHi();
 delay();
 beepLo();
}

void beepFail()
{
 delay();
 beepLo();
 delay();
 beepLo();
 delay();
 beepLo();
}

void beepLo(void)
{
 TRISIO. GP2  =  1 ;
 beep();
}
void beepMed(void)
{
 GPIO. GP2  =  0 ;
 TRISIO. GP2  =  0 ;
 beep();
 TRISIO. GP2  =  1 ;
}
void beepHi(void)
{
 GPIO. GP2  =  1 ;
 TRISIO. GP2  =  0 ;
 beep();
 TRISIO. GP2  =  1 ;
}

void beep(void)
{
 GPIO. GP4  =  1 ;
 delay();
 GPIO. GP4  =  0 ;
}

void interrupt(void)
{
 if (PIR1.TMR1IF)
 {
 PIR1.TMR1IF = 0;
 nInterruptsRemaining--;
 nDuration++;
 T1CON.TMR1ON = 0;
 TMR1L =  (0xFFFF - ( 4000000  + 4000000  * 4 / 100 ) /4 / 8 / 8  + 4+ 32 )  & 0xff ;
 TMR1H =  (0xFFFF - ( 4000000  + 4000000  * 4 / 100 ) /4 / 8 / 8  + 4+ 32 )  >> 8 ;
 T1CON.TMR1ON = 1;
 }
}
