;  ASM code generated by mikroVirtualMachine for PIC - V. 8.2.0.0
;  Date/Time: 2008/11/02 12:59:47
;  Info: http://www.mikroe.com


; ADDRESS	OPCODE	ASM
; ----------------------------------------------
$0000	$2824			GOTO	_main
$0004	$	_interrupt:
$0004	$00DF			MOVWF	STACK_15
$0005	$0E03			SWAPF	STATUS, 0
$0006	$0183			CLRF	STATUS
$0007	$00AA			MOVWF	?saveSTATUS
$0008	$0804			MOVF	FSR, 0
$0009	$00A9			MOVWF	?saveFSR
$000A	$080A			MOVF	PCLATH, 0
$000B	$00AB			MOVWF	?savePCLATH
$000C	$018A			CLRF	PCLATH
;CameraTimer.c,413 :: 		void interrupt(void)    // In this app it is always a Timer1 interrupt...
;CameraTimer.c,415 :: 		if (PIR1.TMR1IF)      // If it's a Timer1 interrupt
$000D	$1C0C			BTFSS	PIR1, 0
$000E	$281B			GOTO	L_interrupt_24
;CameraTimer.c,417 :: 		PIR1.TMR1IF = 0;	  // Clear the timer interrupt flag
$000F	$100C			BCF	PIR1, 0
;CameraTimer.c,418 :: 		nInterruptsRemaining--;    // Decrement interrupts remaining in this second
$0010	$3001			MOVLW	1
$0011	$02A0			SUBWF	_nInterruptsRemaining, 1
$0012	$1C03			BTFSS	STATUS, C
$0013	$03A1			DECF	_nInterruptsRemaining+1, 1
;CameraTimer.c,419 :: 		nDuration++;        // Number of interrupts since last reset
$0014	$0AA2			INCF	_nDuration, 1
;CameraTimer.c,420 :: 		T1CON.TMR1ON = 0;   // Turn off Timer1 so we can reset its value
$0015	$1010			BCF	T1CON, 0
;CameraTimer.c,421 :: 		TMR1L = TMR1_INITIAL_LO;
$0016	$30A9			MOVLW	169
$0017	$008E			MOVWF	TMR1L
;CameraTimer.c,422 :: 		TMR1H = TMR1_INITIAL_HI;
$0018	$30C0			MOVLW	192
$0019	$008F			MOVWF	TMR1H
;CameraTimer.c,423 :: 		T1CON.TMR1ON = 1;   // Turn on Timer1
$001A	$1410			BSF	T1CON, 0
;CameraTimer.c,424 :: 		}
$001B	$	L_interrupt_24:
;CameraTimer.c,425 :: 		}
$001B	$	L_Interrupt_end:
$001B	$082B			MOVF	?savePCLATH, 0
$001C	$008A			MOVWF	PCLATH
$001D	$0829			MOVF	?saveFSR, 0
$001E	$0084			MOVWF	FSR
$001F	$0E2A			SWAPF	?saveSTATUS, 0
$0020	$0083			MOVWF	STATUS
$0021	$0EDF			SWAPF	STACK_15, 1
$0022	$0E5F			SWAPF	STACK_15, 0
$0023	$0009			RETFIE
$0143	$	_delay:
;CameraTimer.c,351 :: 		void delay(void)
;CameraTimer.c,353 :: 		Delay_ms(50);
$0143	$3041			MOVLW	65
$0144	$1303			BCF	STATUS, RP1
$0145	$1283			BCF	STATUS, RP0
$0146	$00DB			MOVWF	STACK_11
$0147	$30FF			MOVLW	255
$0148	$00DA			MOVWF	STACK_10
$0149	$0BDB			DECFSZ	STACK_11, F
$014A	$294C			GOTO	$+2
$014B	$294F			GOTO	$+4
$014C	$0BDA			DECFSZ	STACK_10, F
$014D	$294C			GOTO	$-1
$014E	$2949			GOTO	$-5
$014F	$30C3			MOVLW	195
$0150	$00DA			MOVWF	STACK_10
$0151	$0BDA			DECFSZ	STACK_10, F
$0152	$2951			GOTO	$-1
$0153	$0000			NOP
;CameraTimer.c,354 :: 		}
$0154	$0008			RETURN
$016F	$	_beep:
;CameraTimer.c,406 :: 		void beep(void)
;CameraTimer.c,408 :: 		GPIO.BEEPER = ON;     // Turn beeper on
$016F	$1303			BCF	STATUS, RP1
$0170	$1283			BCF	STATUS, RP0
$0171	$1605			BSF	GPIO, 4
;CameraTimer.c,409 :: 		delay();              // Wait a bit
$0172	$2143			CALL	_delay
;CameraTimer.c,410 :: 		GPIO.BEEPER = OFF;    // Turn beeper off
$0173	$1205			BCF	GPIO, 4
;CameraTimer.c,411 :: 		}
$0174	$0008			RETURN
$015F	$	_beepHi:
;CameraTimer.c,398 :: 		void beepHi(void)
;CameraTimer.c,400 :: 		GPIO.TONE = ON;       // Set high frequency
$015F	$1303			BCF	STATUS, RP1
$0160	$1283			BCF	STATUS, RP0
$0161	$1505			BSF	GPIO, 2
;CameraTimer.c,401 :: 		TRISIO.TONE = OUTPUT; // Activate tone control pin
$0162	$1683			BSF	STATUS, RP0
$0163	$1105			BCF	TRISIO, 2
;CameraTimer.c,402 :: 		beep();
$0164	$216F			CALL	_beep
;CameraTimer.c,403 :: 		TRISIO.TONE = INPUT;  // Float the tone control pin
$0165	$1683			BSF	STATUS, RP0
$0166	$1505			BSF	TRISIO, 2
;CameraTimer.c,404 :: 		}
$0167	$0008			RETURN
$017B	$	_beepLo:
;CameraTimer.c,386 :: 		void beepLo(void)
;CameraTimer.c,388 :: 		TRISIO.TONE = INPUT;  // Deactivate tone control pin (floating)
$017B	$1303			BCF	STATUS, RP1
$017C	$1683			BSF	STATUS, RP0
$017D	$1505			BSF	TRISIO, 2
;CameraTimer.c,389 :: 		beep();
$017E	$216F			CALL	_beep
;CameraTimer.c,390 :: 		}
$017F	$0008			RETURN
$0180	$	_beepOK:
;CameraTimer.c,369 :: 		void beepOK(void)
;CameraTimer.c,371 :: 		beepHi();
$0180	$215F			CALL	_beepHi
;CameraTimer.c,372 :: 		delay();
$0181	$2143			CALL	_delay
;CameraTimer.c,373 :: 		beepLo();
$0182	$217B			CALL	_beepLo
;CameraTimer.c,374 :: 		}
$0183	$0008			RETURN
$012E	$	_isButtonPressed:
;CameraTimer.c,356 :: 		unsigned char isButtonPressed(void)
;CameraTimer.c,358 :: 		if (BUTTON_PRESSED)   // Low means button is pressed
$012E	$1303			BCF	STATUS, RP1
$012F	$1283			BCF	STATUS, RP0
$0130	$1985			BTFSC	GPIO, 3
$0131	$2941			GOTO	L_isButtonPressed_22
;CameraTimer.c,360 :: 		Delay_us(500);      // Debounce interval...
$0132	$30A6			MOVLW	166
$0133	$00DA			MOVWF	STACK_10
$0134	$0BDA			DECFSZ	STACK_10, F
$0135	$2934			GOTO	$-1
$0136	$0000			NOP
;CameraTimer.c,361 :: 		Delay_us(500);      // ...of 1 ms
$0137	$30A6			MOVLW	166
$0138	$00DA			MOVWF	STACK_10
$0139	$0BDA			DECFSZ	STACK_10, F
$013A	$2939			GOTO	$-1
$013B	$0000			NOP
;CameraTimer.c,362 :: 		if (BUTTON_PRESSED) // If still low after 1 ms
$013C	$1985			BTFSC	GPIO, 3
$013D	$2941			GOTO	L_isButtonPressed_23
;CameraTimer.c,363 :: 		return 1;         // Then indicate button is pressed
$013E	$3001			MOVLW	1
$013F	$00D0			MOVWF	STACK_0
$0140	$0008			RETURN
$0141	$	L_isButtonPressed_23:
;CameraTimer.c,364 :: 		}
$0141	$	L_isButtonPressed_22:
;CameraTimer.c,365 :: 		return 0;             // Else indicate button is not pressed
$0141	$01D0			CLRF	STACK_0, 1
;CameraTimer.c,366 :: 		}
$0142	$0008			RETURN
$0175	$	_shoot:
;CameraTimer.c,344 :: 		void shoot(void)
;CameraTimer.c,346 :: 		GPIO.SHUTTER = ON;    // Press the shutter button
$0175	$1303			BCF	STATUS, RP1
$0176	$1283			BCF	STATUS, RP0
$0177	$1685			BSF	GPIO, 5
;CameraTimer.c,347 :: 		delay();              // Hold the shutter button for a bit
$0178	$2143			CALL	_delay
;CameraTimer.c,348 :: 		GPIO.SHUTTER = OFF;   // Release the shutter button
$0179	$1285			BCF	GPIO, 5
;CameraTimer.c,349 :: 		}
$017A	$0008			RETURN
$0155	$	_EEprom_read:
$0155	$1303			BCF	STATUS, RP1
$0156	$1283			BCF	STATUS, RP0
$0157	$082C			MOVF	FARG_EEprom_read+0, 0
$0158	$1683			BSF	STATUS, RP0
$0159	$009B			MOVWF	EEADR
$015A	$139C			BCF	EECON1, 7
$015B	$141C			BSF	EECON1, 0
$015C	$081A			MOVF	EEDATA, 0
$015D	$00D0			MOVWF	STACK_0
$015E	$0008			RETURN
$0168	$	_beepFail:
;CameraTimer.c,376 :: 		void beepFail()
;CameraTimer.c,378 :: 		delay();
$0168	$2143			CALL	_delay
;CameraTimer.c,379 :: 		beepLo();
$0169	$217B			CALL	_beepLo
;CameraTimer.c,380 :: 		delay();
$016A	$2143			CALL	_delay
;CameraTimer.c,381 :: 		beepLo();
$016B	$217B			CALL	_beepLo
;CameraTimer.c,382 :: 		delay();
$016C	$2143			CALL	_delay
;CameraTimer.c,383 :: 		beepLo();
$016D	$217B			CALL	_beepLo
;CameraTimer.c,384 :: 		}
$016E	$0008			RETURN
$0118	$	_EEprom_write:
$0118	$0000			NOP
$0119	$	L_EEprom_write_0:
$0119	$1303			BCF	STATUS, RP1
$011A	$1683			BSF	STATUS, RP0
$011B	$1C9C			BTFSS	EECON1, 1
$011C	$291F			GOTO	L_EEprom_write_1
$011D	$0000			NOP
$011E	$2919			GOTO	L_EEprom_write_0
$011F	$	L_EEprom_write_1:
$011F	$082C			MOVF	FARG_EEprom_write+0, 0
$0120	$009B			MOVWF	EEADR
$0121	$082D			MOVF	FARG_EEprom_write+1, 0
$0122	$009A			MOVWF	EEDATA
$0123	$139C			BCF	EECON1, 7
$0124	$151C			BSF	EECON1, 2
$0125	$138B			BCF	INTCON, 7
$0126	$3055			MOVLW	85
$0127	$009D			MOVWF	EECON2
$0128	$30AA			MOVLW	170
$0129	$009D			MOVWF	EECON2
$012A	$149C			BSF	EECON1, 1
$012B	$178B			BSF	INTCON, 7
$012C	$111C			BCF	EECON1, 2
$012D	$0008			RETURN
$00ED	$	_Mul_16x16_U:
$00ED	$1303			BCF	STATUS, RP1
$00EE	$1283			BCF	STATUS, RP0
$00EF	$01DB			CLRF	STACK_11
$00F0	$01DA			CLRF	STACK_10
$00F1	$01D9			CLRF	STACK_9
$00F2	$3080			MOVLW	128
$00F3	$00D8			MOVWF	STACK_8
$00F4	$0CD1			RRF	STACK_1, F
$00F5	$0CD0			RRF	STACK_0, F
$00F6	$1C03			BTFSS	STATUS, C
$00F7	$2901			GOTO	$+10
$00F8	$0854			MOVF	STACK_4, W
$00F9	$07D9			ADDWF	STACK_9, F
$00FA	$0855			MOVF	STACK_5, W
$00FB	$1803			BTFSC	STATUS, C
$00FC	$0F55			INCFSZ	STACK_5, W
$00FD	$07DA			ADDWF	STACK_10, F
$00FE	$1803			BTFSC	STATUS, C
$00FF	$0ADB			INCF	STACK_11, F
$0100	$1003			BCF	STATUS, C
$0101	$1FD0			BTFSS	STACK_0, 7
$0102	$2909			GOTO	$+7
$0103	$0854			MOVF	STACK_4, W
$0104	$07DA			ADDWF	STACK_10, F
$0105	$0855			MOVF	STACK_5, W
$0106	$1803			BTFSC	STATUS, C
$0107	$0F55			INCFSZ	STACK_5, W
$0108	$07DB			ADDWF	STACK_11, F
$0109	$0CDB			RRF	STACK_11, F
$010A	$0CDA			RRF	STACK_10, F
$010B	$0CD9			RRF	STACK_9, F
$010C	$0CD8			RRF	STACK_8, F
$010D	$1C03			BTFSS	STATUS, C
$010E	$28F4			GOTO	$-26
$010F	$085B			MOVF	STACK_11, W
$0110	$00D3			MOVWF	STACK_3
$0111	$085A			MOVF	STACK_10, W
$0112	$00D2			MOVWF	STACK_2
$0113	$0859			MOVF	STACK_9, W
$0114	$00D1			MOVWF	STACK_1
$0115	$0858			MOVF	STACK_8, W
$0116	$00D0			MOVWF	STACK_0
$0117	$0008			RETURN
$0024	$	_main:
;CameraTimer.c,204 :: 		void main(void)
;CameraTimer.c,210 :: 		nInterruptsRemaining = 0; // Timer interrupts remaining in this second
$0024	$1303			BCF	STATUS, RP1
$0025	$1283			BCF	STATUS, RP0
$0026	$01A0			CLRF	_nInterruptsRemaining
$0027	$01A1			CLRF	_nInterruptsRemaining+1
;CameraTimer.c,211 :: 		nDuration = 0;            // Interrupts counted for button presses/releases
$0028	$01A2			CLRF	_nDuration, 1
;CameraTimer.c,212 :: 		nSecondsBetweenShots.n = 0; // Seconds to wait between each shot
$0029	$01A3			CLRF	_nSecondsBetweenShots
$002A	$01A4			CLRF	_nSecondsBetweenShots+1
;CameraTimer.c,213 :: 		nSecondsRemaining = 0;    // Seconds remaining until next shot is taken
$002B	$01A5			CLRF	_nSecondsRemaining
$002C	$01A6			CLRF	_nSecondsRemaining+1
;CameraTimer.c,214 :: 		nDigit = 9;               // Cause the first button press to cycle to zero
$002D	$3009			MOVLW	9
$002E	$00A7			MOVWF	_nDigit
;CameraTimer.c,215 :: 		bFlags = 0;               // Reset all flags to false
$002F	$01A8			CLRF	_bFlags, 1
;CameraTimer.c,217 :: 		GPIO = 0b00000000;        // Turn off all pins
$0030	$0185			CLRF	GPIO, 1
;CameraTimer.c,219 :: 		T1CON.T1CKPS1 = 1;        // Timer1 clock prescaler = 8 (PS1:PS0 = 11)
$0031	$1690			BSF	T1CON, 5
;CameraTimer.c,220 :: 		T1CON.T1CKPS0 = 1;
$0032	$1610			BSF	T1CON, 4
;CameraTimer.c,226 :: 		CMCON  = 0b00000111;      // Turn off the comparator <-- DO THIS OR SUFFER!
$0033	$3007			MOVLW	7
$0034	$0099			MOVWF	CMCON
;CameraTimer.c,227 :: 		ANSEL  = 0b00000000;      // All pins are digital (not analog) <-- AND THIS!
$0035	$1683			BSF	STATUS, RP0
$0036	$019F			CLRF	ANSEL, 1
;CameraTimer.c,228 :: 		TRISIO = 0b00001000;      // All pins are output (except GP3)
$0037	$3008			MOVLW	8
$0038	$0085			MOVWF	TRISIO
;CameraTimer.c,229 :: 		PIE1.T1IE = 1;            // Enable interrupt on TMR1 overflow
$0039	$140C			BSF	PIE1, 0
;CameraTimer.c,235 :: 		INTCON.PEIE = 1;		      // Enable peripheral interrupts (needed for TMR1)
$003A	$170B			BSF	INTCON, 6
;CameraTimer.c,236 :: 		INTCON.GIE = 1;	          // Enable interrupts globally
$003B	$178B			BSF	INTCON, 7
;CameraTimer.c,237 :: 		TMR1L = TMR1_INITIAL_LO;  // Set the low byte of the timer interval
$003C	$30A9			MOVLW	169
$003D	$1283			BCF	STATUS, RP0
$003E	$008E			MOVWF	TMR1L
;CameraTimer.c,238 :: 		TMR1H = TMR1_INITIAL_HI;  // Set the high byte of the timer interval
$003F	$30C0			MOVLW	192
$0040	$008F			MOVWF	TMR1H
;CameraTimer.c,239 :: 		T1CON.TMR1ON = 1;         // Turn on Timer1
$0041	$1410			BSF	T1CON, 0
;CameraTimer.c,240 :: 		beepOK();                 // Indicate that we are powered up and ready
$0042	$2180			CALL	_beepOK
;CameraTimer.c,241 :: 		GPIO.RED_LED = ON;        // Indicate we are in "set" mode
$0043	$1485			BSF	GPIO, 1
;CameraTimer.c,243 :: 		for(;;)                   // This loops hundreds of times each second...
$0044	$	L_main_0:
;CameraTimer.c,250 :: 		if (SHOOT_MODE)           // If we are shooting pictures
$0044	$1885			BTFSC	GPIO, 1
$0045	$286F			GOTO	L_main_3
;CameraTimer.c,252 :: 		nDuration = 0;          // Duration of button press (interrupt count)
$0046	$01A2			CLRF	_nDuration, 1
;CameraTimer.c,253 :: 		if (isButtonPressed())  // Pressing the button cancels shoot mode
$0047	$212E			CALL	_isButtonPressed
$0048	$0850			MOVF	STACK_0, 0
$0049	$1903			BTFSC	STATUS, Z
$004A	$2851			GOTO	L_main_4
;CameraTimer.c,255 :: 		GPIO.SHUTTER = OFF;   // Release the shutter immediately
$004B	$1285			BCF	GPIO, 5
;CameraTimer.c,256 :: 		GPIO.RED_LED = ON;    // Indicate we are now in "set" mode
$004C	$1485			BSF	GPIO, 1
;CameraTimer.c,257 :: 		nSecondsBetweenShots.n = 0; // Reset the shooting interval
$004D	$01A3			CLRF	_nSecondsBetweenShots
$004E	$01A4			CLRF	_nSecondsBetweenShots+1
;CameraTimer.c,258 :: 		beepOK();             // Indicate shooting interval is reset to zero
$004F	$2180			CALL	_beepOK
;CameraTimer.c,259 :: 		}
$0050	$286E			GOTO	L_main_5
$0051	$	L_main_4:
;CameraTimer.c,262 :: 		if (nInterruptsRemaining == 0)  // If a whole second has elapsed
$0051	$3000			MOVLW	0
$0052	$0621			XORWF	_nInterruptsRemaining+1, 0
$0053	$1D03			BTFSS	STATUS, Z
$0054	$2857			GOTO	L_main_25
$0055	$3000			MOVLW	0
$0056	$0620			XORWF	_nInterruptsRemaining, 0
$0057	$	L_main_25:
$0057	$1D03			BTFSS	STATUS, Z
$0058	$286E			GOTO	L_main_6
;CameraTimer.c,264 :: 		nInterruptsRemaining = INTERRUPTS_IN_ONE_SECOND;
$0059	$3008			MOVLW	8
$005A	$00A0			MOVWF	_nInterruptsRemaining
$005B	$3000			MOVLW	0
$005C	$00A1			MOVWF	_nInterruptsRemaining+1
;CameraTimer.c,265 :: 		nSecondsRemaining--;
$005D	$3001			MOVLW	1
$005E	$02A5			SUBWF	_nSecondsRemaining, 1
$005F	$1C03			BTFSS	STATUS, C
$0060	$03A6			DECF	_nSecondsRemaining+1, 1
;CameraTimer.c,266 :: 		if (nSecondsRemaining == 0)   // If the shooting interval has elapsed
$0061	$3000			MOVLW	0
$0062	$0626			XORWF	_nSecondsRemaining+1, 0
$0063	$1D03			BTFSS	STATUS, Z
$0064	$2867			GOTO	L_main_26
$0065	$3000			MOVLW	0
$0066	$0625			XORWF	_nSecondsRemaining, 0
$0067	$	L_main_26:
$0067	$1D03			BTFSS	STATUS, Z
$0068	$286E			GOTO	L_main_7
;CameraTimer.c,268 :: 		nSecondsRemaining = nSecondsBetweenShots.n;
$0069	$0823			MOVF	_nSecondsBetweenShots, 0
$006A	$00A5			MOVWF	_nSecondsRemaining
$006B	$0824			MOVF	_nSecondsBetweenShots+1, 0
$006C	$00A6			MOVWF	_nSecondsRemaining+1
;CameraTimer.c,269 :: 		shoot();    // Take the next shot
$006D	$2175			CALL	_shoot
;CameraTimer.c,270 :: 		}
$006E	$	L_main_7:
;CameraTimer.c,271 :: 		}
$006E	$	L_main_6:
;CameraTimer.c,272 :: 		}
$006E	$	L_main_5:
;CameraTimer.c,273 :: 		}
$006E	$28EB			GOTO	L_main_8
$006F	$	L_main_3:
;CameraTimer.c,281 :: 		bLongPress = 0;
$006F	$1128			BCF	_bFlags, 2
;CameraTimer.c,282 :: 		if (isButtonPressed())
$0070	$212E			CALL	_isButtonPressed
$0071	$0850			MOVF	STACK_0, 0
$0072	$1903			BTFSC	STATUS, Z
$0073	$2894			GOTO	L_main_9
;CameraTimer.c,284 :: 		nDuration = 0;  // Duration of button press (interrupt count)
$0074	$01A2			CLRF	_nDuration, 1
;CameraTimer.c,285 :: 		while (BUTTON_PRESSED) // Wait for button to be released
$0075	$	L_main_10:
$0075	$1303			BCF	STATUS, RP1
$0076	$1283			BCF	STATUS, RP0
$0077	$1985			BTFSC	GPIO, 3
$0078	$2883			GOTO	L_main_11
;CameraTimer.c,287 :: 		if (nDuration >= LONG_PRESS)
$0079	$3008			MOVLW	8
$007A	$0222			SUBWF	_nDuration, 0
$007B	$1C03			BTFSS	STATUS, C
$007C	$2880			GOTO	L_main_12
;CameraTimer.c,289 :: 		bLongPress = 1;
$007D	$1528			BSF	_bFlags, 2
;CameraTimer.c,290 :: 		beepHi();   // Indicate about to enter shoot mode
$007E	$215F			CALL	_beepHi
;CameraTimer.c,291 :: 		nDuration = 0;
$007F	$01A2			CLRF	_nDuration, 1
;CameraTimer.c,292 :: 		}
$0080	$	L_main_12:
;CameraTimer.c,293 :: 		}
$0080	$1303			BCF	STATUS, RP1
$0081	$1683			BSF	STATUS, RP0
$0082	$2875			GOTO	L_main_10
$0083	$	L_main_11:
;CameraTimer.c,294 :: 		nDuration = 0;  // Duration of button release (interrupt count)
$0083	$1303			BCF	STATUS, RP1
$0084	$1683			BSF	STATUS, RP0
$0085	$01A2			CLRF	_nDuration, 1
;CameraTimer.c,295 :: 		if (!bLongPress)
$0086	$1928			BTFSC	_bFlags, 2
$0087	$2894			GOTO	L_main_13
;CameraTimer.c,297 :: 		nDigit++;
$0088	$0AA7			INCF	_nDigit, 1
;CameraTimer.c,298 :: 		bDigitPending = 1;
$0089	$14A8			BSF	_bFlags, 1
;CameraTimer.c,299 :: 		if (nDigit > 9)
$008A	$0827			MOVF	_nDigit, 0
$008B	$3C09			SUBLW	9
$008C	$1803			BTFSC	STATUS, C
$008D	$2891			GOTO	L_main_14
;CameraTimer.c,301 :: 		nDigit = 0; // Wrap from 9 to 0
$008E	$01A7			CLRF	_nDigit, 1
;CameraTimer.c,302 :: 		beepLo();   // Emit a low beep for 0 (so the user starts counting)
$008F	$217B			CALL	_beepLo
;CameraTimer.c,303 :: 		}
$0090	$2894			GOTO	L_main_15
$0091	$	L_main_14:
;CameraTimer.c,305 :: 		beepHi();   // Emit a high beep for 1 to 9
$0091	$1303			BCF	STATUS, RP1
$0092	$1283			BCF	STATUS, RP0
$0093	$215F			CALL	_beepHi
$0094	$	L_main_15:
;CameraTimer.c,306 :: 		}
$0094	$	L_main_13:
;CameraTimer.c,307 :: 		}
$0094	$	L_main_9:
;CameraTimer.c,309 :: 		if (bDigitPending)
$0094	$1303			BCF	STATUS, RP1
$0095	$1683			BSF	STATUS, RP0
$0096	$1303			BCF	STATUS, RP1
$0097	$1683			BSF	STATUS, RP0
$0098	$1CA8			BTFSS	_bFlags, 1
$0099	$28B2			GOTO	L_main_16
;CameraTimer.c,311 :: 		if (nDuration >= LONG_RELEASE)
$009A	$3008			MOVLW	8
$009B	$0222			SUBWF	_nDuration, 0
$009C	$1C03			BTFSS	STATUS, C
$009D	$28B2			GOTO	L_main_17
;CameraTimer.c,313 :: 		beepOK();     // Indicate the next digit is accepted
$009E	$2180			CALL	_beepOK
;CameraTimer.c,315 :: 		nSecondsBetweenShots.n = nSecondsBetweenShots.n * 10 + nDigit;
$009F	$0823			MOVF	_nSecondsBetweenShots, 0
$00A0	$00D0			MOVWF	STACK_0
$00A1	$0824			MOVF	_nSecondsBetweenShots+1, 0
$00A2	$00D1			MOVWF	STACK_0+1
$00A3	$300A			MOVLW	10
$00A4	$00D4			MOVWF	STACK_4
$00A5	$3000			MOVLW	0
$00A6	$00D5			MOVWF	STACK_4+1
$00A7	$20ED			CALL	_mul_16x16_u
$00A8	$0827			MOVF	_nDigit, 0
$00A9	$0750			ADDWF	STACK_0, 0
$00AA	$00A3			MOVWF	_nSecondsBetweenShots
$00AB	$0851			MOVF	STACK_0+1, 0
$00AC	$1803			BTFSC	STATUS, C
$00AD	$3F01			ADDLW	1
$00AE	$00A4			MOVWF	_nSecondsBetweenShots+1
;CameraTimer.c,316 :: 		nDigit = 9;   // Ready for next digit entry
$00AF	$3009			MOVLW	9
$00B0	$00A7			MOVWF	_nDigit
;CameraTimer.c,317 :: 		bDigitPending = 0;  // Wait for user to select the next digit
$00B1	$10A8			BCF	_bFlags, 1
;CameraTimer.c,318 :: 		}
$00B2	$	L_main_17:
;CameraTimer.c,319 :: 		}
$00B2	$	L_main_16:
;CameraTimer.c,321 :: 		if (bLongPress)
$00B2	$1303			BCF	STATUS, RP1
$00B3	$1283			BCF	STATUS, RP0
$00B4	$1303			BCF	STATUS, RP1
$00B5	$1283			BCF	STATUS, RP0
$00B6	$1D28			BTFSS	_bFlags, 2
$00B7	$28EB			GOTO	L_main_18
;CameraTimer.c,323 :: 		if (nSecondsBetweenShots.n == 0)
$00B8	$3000			MOVLW	0
$00B9	$0624			XORWF	_nSecondsBetweenShots+1, 0
$00BA	$1D03			BTFSS	STATUS, Z
$00BB	$28BE			GOTO	L_main_27
$00BC	$3000			MOVLW	0
$00BD	$0623			XORWF	_nSecondsBetweenShots, 0
$00BE	$	L_main_27:
$00BE	$1D03			BTFSS	STATUS, Z
$00BF	$28C9			GOTO	L_main_19
;CameraTimer.c,325 :: 		nSecondsBetweenShots.byte[0] = Eeprom_read(0);
$00C0	$01AC			CLRF	FARG_EEprom_read+0, 1
$00C1	$2155			CALL	_EEprom_read
$00C2	$0850			MOVF	STACK_0, 0
$00C3	$00A3			MOVWF	_nSecondsBetweenShots
;CameraTimer.c,326 :: 		nSecondsBetweenShots.byte[1] = Eeprom_read(1);
$00C4	$3001			MOVLW	1
$00C5	$00AC			MOVWF	FARG_EEprom_read+0
$00C6	$2155			CALL	_EEprom_read
$00C7	$0850			MOVF	STACK_0, 0
$00C8	$00A4			MOVWF	_nSecondsBetweenShots+1
;CameraTimer.c,327 :: 		}
$00C9	$	L_main_19:
;CameraTimer.c,328 :: 		if (nSecondsBetweenShots.n == 0)
$00C9	$1303			BCF	STATUS, RP1
$00CA	$1683			BSF	STATUS, RP0
$00CB	$3000			MOVLW	0
$00CC	$0624			XORWF	_nSecondsBetweenShots+1, 0
$00CD	$1D03			BTFSS	STATUS, Z
$00CE	$28D1			GOTO	L_main_28
$00CF	$3000			MOVLW	0
$00D0	$0623			XORWF	_nSecondsBetweenShots, 0
$00D1	$	L_main_28:
$00D1	$1D03			BTFSS	STATUS, Z
$00D2	$28D5			GOTO	L_main_20
;CameraTimer.c,329 :: 		beepFail();   // Indicate that the shooting interval is invalid
$00D3	$2168			CALL	_beepFail
$00D4	$28EB			GOTO	L_main_21
$00D5	$	L_main_20:
;CameraTimer.c,332 :: 		Eeprom_write(0, nSecondsBetweenShots.byte[0]);
$00D5	$1303			BCF	STATUS, RP1
$00D6	$1283			BCF	STATUS, RP0
$00D7	$01AC			CLRF	FARG_EEprom_write+0, 1
$00D8	$0823			MOVF	_nSecondsBetweenShots, 0
$00D9	$00AD			MOVWF	FARG_EEprom_write+1
$00DA	$2118			CALL	_EEprom_write
;CameraTimer.c,333 :: 		Eeprom_write(1, nSecondsBetweenShots.byte[1]);
$00DB	$3001			MOVLW	1
$00DC	$00AC			MOVWF	FARG_EEprom_write+0
$00DD	$0824			MOVF	_nSecondsBetweenShots+1, 0
$00DE	$00AD			MOVWF	FARG_EEprom_write+1
$00DF	$2118			CALL	_EEprom_write
;CameraTimer.c,334 :: 		nInterruptsRemaining = INTERRUPTS_IN_ONE_SECOND;
$00E0	$3008			MOVLW	8
$00E1	$00A0			MOVWF	_nInterruptsRemaining
$00E2	$3000			MOVLW	0
$00E3	$00A1			MOVWF	_nInterruptsRemaining+1
;CameraTimer.c,335 :: 		nSecondsRemaining = nSecondsBetweenShots.n;
$00E4	$0823			MOVF	_nSecondsBetweenShots, 0
$00E5	$00A5			MOVWF	_nSecondsRemaining
$00E6	$0824			MOVF	_nSecondsBetweenShots+1, 0
$00E7	$00A6			MOVWF	_nSecondsRemaining+1
;CameraTimer.c,336 :: 		GPIO.RED_LED = OFF;     // Indicate we are not in "set" mode
$00E8	$1283			BCF	STATUS, RP0
$00E9	$1085			BCF	GPIO, 1
;CameraTimer.c,337 :: 		shoot();
$00EA	$2175			CALL	_shoot
;CameraTimer.c,338 :: 		}
$00EB	$	L_main_21:
;CameraTimer.c,339 :: 		}
$00EB	$	L_main_18:
;CameraTimer.c,340 :: 		}
$00EB	$	L_main_8:
;CameraTimer.c,341 :: 		}
$00EB	$	L_main_2:
$00EB	$2844			GOTO	L_main_0
;CameraTimer.c,342 :: 		}
$00EC	$28EC			GOTO	$
